<?php

$VatTypes = [];
$VatTypesName = [];
$AllVATTypes = mysqli_query($link, "SELECT * FROM poreske_stope");
if (mysqli_num_rows($AllVATTypes) != 0) {
    while ($rowVATTypes = mysqli_fetch_array($AllVATTypes)) {
        $VatTypes[$rowVATTypes['id']] = $rowVATTypes['vrednost'];
        $VatTypesName[$rowVATTypes['id']] = $rowVATTypes['oznaka'];
    }
}
$SheetName = 'Izvoz liste artikala ';
$filename = $SheetName . "-" . date('Ymd') . '.xlsx';
include_once('xlsreader/xlsxwriter.class.php');
header('Content-disposition: attachment; filename="' . XLSXWriter::sanitize_filename($filename) . '"');
header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
header('Content-Transfer-Encoding: binary');
header('Cache-Control: must-revalidate');
header('Pragma: public');

$writer = new XLSXWriter();
$writer->setAuthor('Sparkom software - www.sparkom.net');

$GenerateReport = mysqli_query($link, "SELECT  * FROM artikal WHERE 1") or die(mysqli_error($link));
if (mysqli_num_rows($GenerateReport) != 0) {
    /* HEADER */
    $header = array(
        'Naziv artikla' => 'string',
        'Cena artikla' => 'price',
        'Podgrupa' => 'string',
        'Jedinica mere' => 'string',
        'Poreska stopa' => 'string',
        'Dozvoljen popust' => 'string',
        'Barkod artikla' => 'string'
    );
    $writer->writeSheetHeader($SheetName, $header);

    /* HEADER END */
    $Rb = 1;
    while ($rowAllData = mysqli_fetch_array($GenerateReport)) {
        $name = $rowAllData['name'];
        $barCode = $rowAllData['barCode'];
        $jedinicaMere = $rowAllData['jedinicaMere'];
        $poreskaGrupa = $rowAllData['poreskaGrupa'];
        $PODGRUPA_ID = $rowAllData['PODGRUPA_ID'];
        $cena = $rowAllData['cena'];
        $dozvoljenPopust = $rowAllData['dozvoljenPopust'];
        $writer->writeSheetRow($SheetName, array($name, $cena, $PODGRUPA_ID, $jedinicaMere, $poreskaGrupa, $dozvoljenPopust, $barCode));
    }

    $writer->writeSheetRow($SheetName, array(''));
    $writer->writeSheetRow($SheetName, array("Lista artikala na dan: " . date('d-m-Y')));

    $writer->writeToStdOut();
    exit(0);
} else {
    Echo "Nema rezultata!!!";
}