<?php

ini_set('memory_limit', '1024M');
require 'escpos/autoload.php';

use Mike42\Escpos\EscposImage;
use Mike42\Escpos\Printer;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;

if (isset($_POST['ZahtevajSifruZaRastavljanje'])) {
    $zahtevajSifru = GetSettingVal("objekat.sastavljanje.stolova.sifra");
    echo json_encode(array('zahtevajSifru' => $zahtevajSifru));
    die();
}

if (isset($_POST['SifraZaRastavljanje'])) {
    $ispravnaSifra = 'false';
    $Lozinka = mysqli_real_escape_string($link, $_POST['SifraZaRastavljanje']);
    $GetLoginStorno = mysqli_query($link, "SELECT * FROM login WHERE pass='$Lozinka' LIMIT 1") or die(mysqli_error($link));
    if (mysqli_num_rows($GetLoginStorno) == 1) {
        $ispravnaSifra = 'true';
    }
    $GetKonobarStorno = mysqli_query($link, "SELECT * FROM konobar WHERE sifra='$Lozinka' AND nivo='SEF' LIMIT 1") or die(mysqli_error($link));
    if (mysqli_num_rows($GetKonobarStorno) == 1) {
        $ispravnaSifra = 'true';
    }
    echo json_encode(array('ispravnaSifra' => $ispravnaSifra));
    die();
}
if(isset($_POST['GetOccupiedTables'])) {
	$Tables = [];
	$Waiters = [];
    $GetWaiterNames = mysqli_query($link, "SELECT * FROM konobar");
    if (mysqli_num_rows($GetWaiterNames) > 0) {
        while ($rowWaiters = mysqli_fetch_array($GetWaiterNames)) {
            $Waiters[$rowWaiters['id']] = $rowWaiters['skrIme'];
        }
    }
    $GetTableWaiter = mysqli_query($link, "SELECT crnoPlacanje, id, KONOBAR_ID, brojStola, DOSTAVA_ID FROM racun WHERE zatvoren=0");
    if (mysqli_num_rows($GetTableWaiter) > 0) {
        while ($rowTableWaiter = mysqli_fetch_array($GetTableWaiter)) {
			$sto['idStola'] = $rowTableWaiter['brojStola'];
			$sto['idKonobara'] = $rowTableWaiter['KONOBAR_ID'];
			$sto['imeKonobara'] = $Waiters[$rowTableWaiter['KONOBAR_ID']];
			$Tables[] = $sto;
        }
    }
	if (!empty($Tables)) {
        echo json_encode(array('Status' => 'success', 'Message' => '', 'Tables' => $Tables));
    } else {
        echo json_encode(array('Status' => 'success', 'Message' => '', 'Tables' => ''));
    }
}
if (isset($_POST['GetAllTables'])) {
    $Tables = [];
    $Waiters = [];
    $GetWaiterNames = mysqli_query($link, "SELECT * FROM konobar");
    if (mysqli_num_rows($GetWaiterNames) > 0) {
        while ($rowWaiters = mysqli_fetch_array($GetWaiterNames)) {
            $Waiters[$rowWaiters['id']] = $rowWaiters['skrIme'];
        }
    }
    $RacuniIn = "";
    $GetTableWaiter = mysqli_query($link, "SELECT crnoPlacanje, id, KONOBAR_ID, brojStola, DOSTAVA_ID FROM racun WHERE zatvoren=0");
    if (mysqli_num_rows($GetTableWaiter) > 0) {
        while ($rowTableWaiter = mysqli_fetch_array($GetTableWaiter)) {
            $Tables[$rowTableWaiter['brojStola']]['Konobar'] = $rowTableWaiter['KONOBAR_ID'];
            $Tables[$rowTableWaiter['brojStola']]['KonobarIme'] = $Waiters[$rowTableWaiter['KONOBAR_ID']];
            $Tables[$rowTableWaiter['brojStola']]['Suma'] = -1;
            $Tables[$rowTableWaiter['brojStola']]['Dostava'] = $rowTableWaiter['DOSTAVA_ID'];
            if ($rowTableWaiter['crnoPlacanje'] != '') {
                $Tables[$rowTableWaiter['brojStola']]['Medjuzbir'] = $rowTableWaiter['crnoPlacanje'];
            } else {
                $Tables[$rowTableWaiter['brojStola']]['Medjuzbir'] = "";
            }
            if ($RacuniIn == "") {
                $RacuniIn = $rowTableWaiter['id'];
            } else {
                $RacuniIn .= ", " . $rowTableWaiter['id'];
            }
        }
    }
    if ($RacuniIn != '') {
        $GetTableSums = mysqli_query($link, "SELECT brojStola, SUM(kolicina*cena) as iznos FROM stavkaracuna where racun_id IN ( $RacuniIn ) GROUP BY brojStola");
        if (mysqli_num_rows($GetTableSums) > 0) {
            while ($rowTableSums = mysqli_fetch_array($GetTableSums)) {
                if (!empty($Tables[$rowTableSums['brojStola']])) {
                    if ($rowTableSums['iznos'] >= 0) {
                        $Tables[$rowTableSums['brojStola']]['Suma'] = $rowTableSums['iznos'];
                    }
                }
            }
        }
    }
    if (!empty($Tables)) {
        echo json_encode(array('Status' => 'success', 'Message' => '', 'Tables' => $Tables));
    } else {
        echo json_encode(array('Status' => 'success', 'Message' => '', 'Tables' => ''));
    }
}
if (isset($_POST['GetActiveTables'])) {
}
if (isset($_POST['GetTableItems'])) {
    $Table = mysqli_real_escape_string($link, $_POST['GetTableItems']);
    if ($Table != "") {
        $TableItems = [];
        $RacunId = 0;
        $GetRacunId = mysqli_query($link, "SELECT * FROM racun WHERE brojStola='$Table' AND zatvoren=0 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetRacunId) == 1) {
            $RacunId = mysqli_fetch_array($GetRacunId)['id'];
        }
        $GetTableItems = mysqli_query($link, "SELECT gostbroj, ARTIKAL_ID, GLAVNASTAVKA_ID, kolicina, cena, naziv, id, TURA_ID, opis FROM stavkaracuna WHERE brojStola='$Table' AND RACUN_ID='$RacunId' ORDER BY gostbroj ASC, TURA_ID ASC, id ASC");
        if (mysqli_num_rows($GetTableItems) > 0) {
            $GetTuraTime = 0;
            $TuraTime = "";
            while ($rowTableItems = mysqli_fetch_array($GetTableItems)) {
                if ($rowTableItems['TURA_ID'] != $GetTuraTime) {
                    $GetTuraTime = $rowTableItems['TURA_ID'];
                    $GetTime = mysqli_query($link, "SELECT * FROM tura WHERE id='$GetTuraTime'");
                    if (mysqli_num_rows($GetTime) == 1) {
                        $TuraData = mysqli_fetch_array($GetTime);
                        $TuraTime = $TuraData['datum'];
                        $BrojTure = $TuraData['brojTure'];
                    }
                }
                if ($rowTableItems['GLAVNASTAVKA_ID'] != '' || $rowTableItems['GLAVNASTAVKA_ID'] != NULL) {
                    $TableItems[$rowTableItems['gostbroj'] . '' . $rowTableItems['id']] = [
                        'BrojGosta' => $rowTableItems['gostbroj'], 'Naziv' => $rowTableItems['naziv'],
                        'Kolicina' => $rowTableItems['kolicina'],
                        'Cena' => number_format($rowTableItems['cena'], 2, '.', ''),
                        'IdTure' => $rowTableItems['TURA_ID'],
                        'BrojTure' => $BrojTure,
                        'Dodatni' => $rowTableItems['GLAVNASTAVKA_ID'],
                        'ArtikalId' => $rowTableItems['ARTIKAL_ID'],
                        'StavkaId' => $rowTableItems['id'],
                        'Vreme' => date('H:i', strtotime($TuraTime)),
                        'Opis' => $rowTableItems['opis']
                    ];
                } else {
                    $TableItems[$rowTableItems['gostbroj'] . '' . $rowTableItems['id']] = [
                        'BrojGosta' => $rowTableItems['gostbroj'], 'Naziv' => $rowTableItems['naziv'],
                        'Kolicina' => $rowTableItems['kolicina'],
                        'Cena' => number_format($rowTableItems['cena'], 2, '.', ''),
                        'IdTure' => $rowTableItems['TURA_ID'],
                        'BrojTure' => $BrojTure,
                        'Dodatni' => 0,
                        'ArtikalId' => $rowTableItems['ARTIKAL_ID'],
                        'StavkaId' => $rowTableItems['id'],
                        'Vreme' => date('H:i', strtotime($TuraTime)),
                        'Opis' => $rowTableItems['opis']
                    ];
                }
            }
            $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
            $LogDate = date('Y-m-d');
            $LogTime = date('H:i:s');
            $LogUser = $UserName;
            $LogWhat = "Prikaz sadrzaja stola Sto->" . $Table . " -> Korisnik: " . $UserName;
            mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
            echo json_encode(array('Status' => 'success', 'Message' => '', 'TableItems' => $TableItems));
        } else {
            echo json_encode(array('Status' => 'success', 'Message' => '', 'TableItems' => ''));
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Neispravan broj stola', 'TableItems' => ''));
    }
    die();
}
if (isset($_POST['GetArticlePrice'])) {
    $ProductId = mysqli_real_escape_string($link, $_POST['GetArticlePrice']);
    $GetPriceLists = mysqli_query($link, "SELECT * FROM cenovnici WHERE aktivan=1 ORDER BY id ASC");
    $ReturnPrice = 0;
    if (mysqli_num_rows($GetPriceLists) > 0) {
        while ($rowPriceLists = mysqli_fetch_array($GetPriceLists)) {
            $PriceListId = $rowPriceLists['id'];
            $PriceListType = $rowPriceLists['CENOVNIKTIP_ID'];
            if ($PriceListType == 1) {
                $GetIsValid = mysqli_query($link, "SELECT * FROM cenovnikdetalji WHERE CENOVNICI_ID='$PriceListId' AND datum_od<=now() AND datum_do>=now() ORDER BY id DESC LIMIT 1") or die(mysqli_error($link));
                if (mysqli_num_rows($GetIsValid) == 1) {
                    $GetPrice = mysqli_query($link, "SELECT * FROM cenovnicistavka WHERE CENOVNICI_ID='$PriceListId' AND ARTIKAL_ID='$ProductId' ORDER BY id DESC LIMIT 1");
                    if (mysqli_num_rows($GetPrice) == 1) {
                        $ReturnPrice = mysqli_fetch_array($GetPrice)['cenovnikCena'];
                    }
                }
            } elseif ($PriceListType == 2) {
                $Day = date('N');
                $Hour = 1 * date('H');
                $Minute = date('i');
                $Time = $Hour . '' . $Minute;
                $GetIsValid = mysqli_query($link, "SELECT * FROM cenovnikdetalji WHERE CENOVNICI_ID='$PriceListId' AND dan_pocetak>='$Day' AND dan_zavrsetak<='$Day' ORDER BY id DESC LIMIT 1");
                if (mysqli_num_rows($GetIsValid) == 1) {
                    $ValidData = mysqli_fetch_array($GetIsValid);
                    if ($ValidData['minut_pocetak'] < 10) {
                        $ValidData['minut_pocetak'] = '0' . $ValidData['minut_pocetak'];
                    }
                    if ($ValidData['minut_zavrsetak'] < 10) {
                        $ValidData['minut_zavrsetak'] = '0' . $ValidData['minut_zavrsetak'];
                    }
                    $TimeStart = $ValidData['sat_pocetak'] . '' . $ValidData['minut_pocetak'];
                    $TimeEnd = $ValidData['sat_zavrsetak'] . '' . $ValidData['minut_zavrsetak'];
                    if ($TimeStart >= $TimeEnd) {
                        if ($TimeStart <= $Time || $TimeEnd >= $Time) {
                            $GetPrice = mysqli_query($link, "SELECT * FROM cenovnicistavka WHERE CENOVNICI_ID='$PriceListId' AND ARTIKAL_ID='$ProductId' ORDER BY id DESC LIMIT 1");
                            if (mysqli_num_rows($GetPrice) == 1) {
                                $ReturnPrice = mysqli_fetch_array($GetPrice)['cenovnikCena'];
                            }
                        }
                    } else {
                        if ($TimeStart <= $Time && $TimeEnd > $Time) {
                            $GetPrice = mysqli_query($link, "SELECT * FROM cenovnicistavka WHERE CENOVNICI_ID='$PriceListId' AND ARTIKAL_ID='$ProductId' ORDER BY id DESC LIMIT 1");
                            if (mysqli_num_rows($GetPrice) == 1) {
                                $ReturnPrice = mysqli_fetch_array($GetPrice)['cenovnikCena'];
                            }
                        }
                    }
                }
            } elseif ($PriceListType == 3) {
                $Day = date('N');
                $Hour = date('H');
                $Minute = date('i');
                $Time = $Day . '' . $Hour . '' . $Minute;
                $GetIsValid = mysqli_query($link, "SELECT * FROM cenovnikdetalji WHERE CENOVNICI_ID='$PriceListId' ORDER BY id DESC LIMIT 1") or die(mysqli_error($link));
                if (mysqli_num_rows($GetIsValid) == 1) {
                    $ValidData = mysqli_fetch_array($GetIsValid);
                    if ($ValidData['sat_pocetak'] < 10) {
                        $ValidData['sat_pocetak'] = '0' . $ValidData['sat_pocetak'];
                    }
                    if ($ValidData['minut_pocetak'] < 10) {
                        $ValidData['minut_pocetak'] = '0' . $ValidData['minut_pocetak'];
                    }
                    if ($ValidData['sat_zavrsetak'] < 10) {
                        $ValidData['sat_zavrsetak'] = '0' . $ValidData['sat_zavrsetak'];
                    }
                    if ($ValidData['minut_zavrsetak'] < 10) {
                        $ValidData['minut_zavrsetak'] = '0' . $ValidData['minut_zavrsetak'];
                    }
                    $TimeStart = $ValidData['dan_pocetak'] . '' . $ValidData['sat_pocetak'] . '' . $ValidData['minut_pocetak'];
                    $TimeEnd = $ValidData['dan_zavrsetak'] . '' . $ValidData['sat_zavrsetak'] . '' . $ValidData['minut_zavrsetak'];
                    if ($TimeStart >= $TimeEnd) {
                        if ($Time >= $TimeStart || $TimeEnd <= $Time) {
                            $GetPrice = mysqli_query($link, "SELECT * FROM cenovnicistavka WHERE CENOVNICI_ID='$PriceListId' AND ARTIKAL_ID='$ProductId' ORDER BY id DESC LIMIT 1");
                            if (mysqli_num_rows($GetPrice) == 1) {
                                $ReturnPrice = mysqli_fetch_array($GetPrice)['cenovnikCena'];
                            }
                        }
                    } else {
                        if ($TimeStart <= $Time && $TimeEnd >= $Time) {
                            $GetPrice = mysqli_query($link, "SELECT * FROM cenovnicistavka WHERE CENOVNICI_ID='$PriceListId' AND ARTIKAL_ID='$ProductId' ORDER BY id DESC LIMIT 1");
                            if (mysqli_num_rows($GetPrice) == 1) {
                                $ReturnPrice = mysqli_fetch_array($GetPrice)['cenovnikCena'];
                            }
                        }
                    }
                }
            }
        }
        if ($ReturnPrice > 0) {
            echo json_encode(array('Status' => 'success', 'Price' => $ReturnPrice));
        } else {
            echo json_encode(array('Status' => 'error', 'Price' => ''));
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Price' => ''));
    }
    die();
}
if (isset($_POST['InsertOrderForTable'])) {
    $StoId = mysqli_real_escape_string($link, $_POST['InsertOrderForTable']);
    $UserId = mysqli_real_escape_string($link, $_COOKIE['UserId']);
    $TuraOpis = $_POST['TuraOpis'];
    $ArtikliTure = $_POST['ArtikliTure'];
    $VremePorudzbine = date('Y-m-d H:i:s');
    $NazivStola = mysqli_real_escape_string($link, str_replace("\n", "", $_POST['TableName']));
    $IznosStola = 0;
    $RacunId = 0;
    $RacunKonobar = $UserId;
    $DostavaID = mysqli_real_escape_string($link, $_POST['DeliveryBuyerId']);
    $DostavaAdresaID = mysqli_real_escape_string($link, $_POST['DeliveryBuyerAddressId']);
    $Logout = "";
    if (isset($KasaData['smenski_rad_odjava'])) {
        if ($KasaData['smenski_rad_odjava'] == 'true') {
            $Logout = "Logout";
        }
    }
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Nova porudzbina Sto->" . $StoId . " Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    $RacunId = 0;
    $GetRacunId = mysqli_query($link, "SELECT * FROM racun WHERE brojStola='$StoId' AND zatvoren=0 ORDER BY id DESC LIMIT 1");
    if (mysqli_num_rows($GetRacunId) == 1) {
        $RacunData = mysqli_fetch_array($GetRacunId);
        $RacunId = $RacunData['id'];
        $RacunKonobar = $RacunData['KONOBAR_ID'];
        $IznosStola = -1;
    }
    $IsTableOpened = mysqli_query($link, "SELECT kolicina, cena FROM stavkaracuna where RACUN_ID='$RacunId' AND brojStola='$StoId'");
    if (mysqli_num_rows($IsTableOpened) > 0) {
        $IznosStola = 0;
        while ($row = mysql_fetch_array($IsTableOpened)) {
            $IznosStola = $IznosStola + ($row['kolicina'] * $row['cena']);
        }
    }
    if ($IznosStola >= 0 && $RacunId > 0) {
        if ($UserId != $RacunKonobar) {
            echo json_encode(array('Status' => 'error', 'Message' => 'Sto je zauzet od strane drugog konobara!!!', 'Action' => ""));
            die();
        }
    } else {
        $GetBrojRacuna = mysqli_query($link, "SELECT MAX(brojRacuna) as broj FROM racun") or die(mysqli_error($link));
        if (mysqli_num_rows($GetBrojRacuna) > 0) {
            $ResBrojRacuna = mysqli_fetch_array($GetBrojRacuna);
            $brojRacuna = $ResBrojRacuna['broj'] + 1;
        } else {
            $brojRacuna = 1;
        }
        $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetZd) == 1) {
            $Zd = mysqli_fetch_array($GetZd)['zdBroj'];
        }
        $datumRacuna = date('Y-m-d H:i:s');
        $kasaId = $KasaId;
        $TotalPopust = 0;
        mysqli_query($link, "INSERT INTO racun(brojRacuna, brojStola, datum, fiskalniOdstampan, storniran, zatvoren, KASA_ID, KONOBAR_ID, popust, zdBroj, DOSTAVA_ID, DOSTAVAADRESA_ID, naOsnovno)
            VALUES('$brojRacuna', '$StoId', '$datumRacuna', 0, 0, 0, '$kasaId', '$UserId', '$TotalPopust', '$Zd', '$DostavaID', '$DostavaAdresaID', '1')") or die(mysqli_error($link) . "na upisu racuna");
        $RacunId = mysqli_insert_id($link);
    }
    $Stampaci = [];
    $GetStampace = mysqli_query($link, "SELECT * FROM artikal_stampac WHERE 1");
    if (mysqli_num_rows($GetStampace) > 0) {
        while ($rowStampaci = mysqli_fetch_array($GetStampace)) {
            $Stampaci[$rowStampaci['ARTIKLI_ID']][$rowStampaci['STAMPAC_ID']] = $rowStampaci['STAMPAC_ID'];
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema podešenih štampača za artikle!!!', 'Action' => ""));
        die();
    }
    $Inc = 0;
    $ArrayStampaca = [];
    $GostBroj = 0;
    foreach ($ArtikliTure as $ArtikliBroj => $ArtikliData) {
        $IdArtikla = mysqli_real_escape_string($link, $ArtikliData[0]);
        $TipArtikla = mysqli_real_escape_string($link, $ArtikliData[1]);
        $CenaArtikla = mysqli_real_escape_string($link, $ArtikliData[2]);
        $NazivArtikla = mysqli_real_escape_string($link, str_replace("\n", "", $ArtikliData[3]));
        $KolicinaArtikla = mysqli_real_escape_string($link, str_replace("\n", "", $ArtikliData[4]));
        $GlavniArtikal = mysqli_real_escape_string($link, $ArtikliData[5]);
        $OpisArtikla = $ArtikliData[6];
        $StampacArtikla = $Stampaci[$IdArtikla];
        $ArtikalGost = mysqli_real_escape_string($link, $ArtikliData[7]);
        if ($ArtikalGost != $GostBroj) {
            $BrojTureGet = mysqli_query($link, "SELECT MAX(brojTure) as brojTure FROM tura WHERE datum >= (SELECT MAX(zakljucenje) as datum FROM zd WHERE pocetak=1)");
            if (mysqli_num_rows($BrojTureGet) > 0) {
                $BrojTure = mysqli_fetch_array($BrojTureGet)['brojTure'] + 1;
            } else {
                $BrojTure = 1;
            }
            $OpisTureInsert = str_replace('&nbsp;', ' ', $TuraOpis);
            $OpisTureInsert = str_replace('</div>', ' ', $OpisTureInsert);
            $OpisTureInsert = strip_tags($OpisTureInsert);
            $TuraOpisInsert = mysqli_real_escape_string($link, $OpisTureInsert);
            $TuraOpisInsert = mb_substr($TuraOpisInsert, 0, 255, 'UTF-8');
            mysqli_query($link, "INSERT INTO tura (brojStola, brojTure, datum, pripremljena, uPripremi, pocetak, REZERVACIJA_ID, napomena, RACUN_ID) 
                            VALUES ('$StoId', '$BrojTure', '$VremePorudzbine', 0, 0, now(), 0, '$TuraOpisInsert', '$RacunId')") or die(mysqli_error($link));
            $IdTure = mysqli_insert_id($link);
            $GostBroj = $ArtikalGost;
        }
        if (is_array($StampacArtikla)) {
            foreach ($StampacArtikla as $StampacArtikla) {
                $Tura = array_search($StampacArtikla, array_column($ArrayStampaca, 'StampacID'));
                if (is_numeric($Tura)) {
                    array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $NazivArtikla, 'Kolicina' => $KolicinaArtikla, 'Tip' => $TipArtikla));
                    if ($OpisArtikla != '') {
                        $OpisArtiklaPrint = preg_replace('/(<[^>]+) style=".*?"/i', '$1', $ArtikliData[6]);
                        $OpisArtiklaPrint = strip_tags($OpisArtiklaPrint, '<div>');
                        $OpisArtiklaPrint = str_replace('&nbsp;', '', $OpisArtiklaPrint);
                        $OpisArtiklaPrint = str_replace('</div>', '', $OpisArtiklaPrint);
                        $arrayOpis = preg_split("<div>", $OpisArtiklaPrint);
                        foreach ($arrayOpis as $Opis) {
                            $Opis = str_replace('<', '', $Opis);
                            $Opis = str_replace('>', '', $Opis);
                            array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $Opis, 'Kolicina' => $KolicinaArtikla, 'Tip' => 'OPISARTIKLA'));
                        }
                    }
                } else {
                    array_push($ArrayStampaca, array('StampacID' => $StampacArtikla, 'artikli' => array(array('Naziv' => $NazivArtikla, 'Kolicina' => $KolicinaArtikla, 'Tip' => $TipArtikla))));
                    if ($OpisArtikla != '') {
                        $Tura = array_search($StampacArtikla, array_column($ArrayStampaca, 'StampacID'));
                        if (is_numeric($Tura)) {
                            $OpisArtiklaPrint = preg_replace('/(<[^>]+) style=".*?"/i', '$1', $ArtikliData[6]);
                            $OpisArtiklaPrint = strip_tags($OpisArtiklaPrint, '<div>');
                            $OpisArtiklaPrint = str_replace('&nbsp;', '', $OpisArtiklaPrint);
                            $OpisArtiklaPrint = str_replace('</div>', '', $OpisArtiklaPrint);
                            $arrayOpis = preg_split("<div>", $OpisArtiklaPrint);
                            foreach ($arrayOpis as $Opis) {
                                $Opis = str_replace('<', '', $Opis);
                                $Opis = str_replace('>', '', $Opis);
                                array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $Opis, 'Kolicina' => $KolicinaArtikla, 'Tip' => 'OPISARTIKLA'));
                            }
                        }
                    }
                }
            }
        } else {
            $Tura = array_search($StampacArtikla, array_column($ArrayStampaca, 'StampacID'));
            if (is_numeric($Tura)) {
                array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $NazivArtikla, 'Kolicina' => $KolicinaArtikla, 'Tip' => $TipArtikla));
                if ($OpisArtikla != '') {
                    $OpisArtiklaPrint = preg_replace('/(<[^>]+) style=".*?"/i', '$1', $ArtikliData[6]);
                    $OpisArtiklaPrint = strip_tags($OpisArtiklaPrint, '<div>');
                    $OpisArtiklaPrint = str_replace('&nbsp;', '', $OpisArtiklaPrint);
                    $OpisArtiklaPrint = str_replace('</div>', '', $OpisArtiklaPrint);
                    $arrayOpis = preg_split("<div>", $OpisArtiklaPrint);
                    foreach ($arrayOpis as $Opis) {
                        $Opis = str_replace('<', '', $Opis);
                        $Opis = str_replace('>', '', $Opis);
                        array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $Opis, 'Kolicina' => $KolicinaArtikla, 'Tip' => 'OPISARTIKLA'));
                    }
                }
            } else {
                array_push($ArrayStampaca, array('StampacID' => $StampacArtikla, 'artikli' => array(array('Naziv' => $NazivArtikla, 'Kolicina' => $KolicinaArtikla, 'Tip' => $TipArtikla))));
                if ($OpisArtikla != '') {
                    $Tura = array_search($StampacArtikla, array_column($ArrayStampaca, 'StampacID'));
                    if (is_numeric($Tura)) {
                        $OpisArtiklaPrint = preg_replace('/(<[^>]+) style=".*?"/i', '$1', $ArtikliData[6]);
                        $OpisArtiklaPrint = strip_tags($OpisArtiklaPrint, '<div>');
                        $OpisArtiklaPrint = str_replace('&nbsp;', '', $OpisArtiklaPrint);
                        $OpisArtiklaPrint = str_replace('</div>', '', $OpisArtiklaPrint);
                        $arrayOpis = preg_split("<div>", $OpisArtiklaPrint);
                        foreach ($arrayOpis as $Opis) {
                            $Opis = str_replace('<', '', $Opis);
                            $Opis = str_replace('>', '', $Opis);
                            array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $Opis, 'Kolicina' => $KolicinaArtikla, 'Tip' => 'OPISARTIKLA'));
                        }
                    }
                }
            }
        }
        if ($GlavniArtikal == 0) {
            $OpisArtikla = str_replace('&nbsp;', ' ', $OpisArtikla);
            $OpisArtikla = str_replace('</div>', ' ', $OpisArtikla);
            $OpisArtikla = strip_tags($OpisArtikla);
            $OpisArtikla = mysqli_real_escape_string($link, strip_tags($OpisArtikla));
            mysqli_query($link, "INSERT INTO stavkaracuna (brojStola, cena, kolicina, naziv, ARTIKAL_ID, TURA_ID, opis, RACUN_ID, gostbroj) "
                . "VALUES('$StoId', '$CenaArtikla', '$KolicinaArtikla', '$NazivArtikla', '$IdArtikla', '$IdTure', '$OpisArtikla', '$RacunId', '$GostBroj')") or die(mysqli_error($link));
        } else {
            $OpisArtikla = str_replace('&nbsp;', ' ', $OpisArtikla);
            $OpisArtikla = str_replace('</div>', ' ', $OpisArtikla);
            $OpisArtikla = strip_tags($OpisArtikla);
            $OpisArtikla = mysqli_real_escape_string($link, strip_tags($OpisArtikla));
            $IdPoslednjegGL = mysqli_query($link, "SELECT id FROM stavkaracuna WHERE ARTIKAL_ID='$GlavniArtikal' AND TURA_ID='$IdTure' ORDER BY id DESC LIMIT 1") or die(mysqli_error($link));
            $IdPoslednjegGLR = mysqli_fetch_array($IdPoslednjegGL)['id'];
            mysqli_query($link, "INSERT INTO stavkaracuna (brojStola, cena, kolicina, naziv, ARTIKAL_ID, TURA_ID, GLAVNASTAVKA_ID, opis, RACUN_ID, gostbroj) "
                . "VALUES('$StoId', '$CenaArtikla', '$KolicinaArtikla', '$NazivArtikla', '$IdArtikla', '$IdTure', '$IdPoslednjegGLR', '$OpisArtikla', '$RacunId', '$GostBroj')") or die(mysqli_error($link));
        }
        $Inc++;
    }
    $StampacData = [];
    $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE 1");
    if (mysqli_num_rows($GetStampacData) > 0) {
        while ($rowStampacData = mysqli_fetch_array($GetStampacData)) {
            $StampacData[$rowStampacData['id']] = $rowStampacData;
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema štampača za štampu porudžbina!!!', 'Action' => ""));
        die();
    }
    $GetProdajnoMesto = mysqli_query($link, "SELECT naziv FROM prodajnomesto ORDER BY id DESC LIMIT 1");
    if (mysqli_num_rows($GetProdajnoMesto) == 1) {
        $ProdajnoMesto = mysqli_fetch_array($GetProdajnoMesto)['naziv'];
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Naziv prodajnog mesta nije podešen!!!', 'Action' => ""));
        die();
    }

    foreach ($ArrayStampaca as $Stampac) {
        $StampacId = $Stampac['StampacID'];
        $BrojKopija = $StampacData[$StampacId]['brojKopijaPorudzbine'];
        $OdeljenjeNaziv = $StampacData[$StampacId]['bnaziv'];
        $NazivStampaca = $StampacData[$StampacId]['naziv'];
        if ($StampacData[$StampacId]['tip'] == 'POSBANK80MM') {
            $PrinterLetters = 40;
        } else {
            $PrinterLetters = 30;
        }
        for ($x = 0; $x < $BrojKopija; $x++) {
            if ($DostavaID > 0) {
                $GetDostavaDetails = mysqli_query($link, "SELECT * FROM dostava WHERE id='$DostavaID'");
                if (mysqli_num_rows($GetDostavaDetails) == 1) {
                    $NazivStola = "DOSTAVA - " . mysqli_fetch_array($GetDostavaDetails)['naziv'];
                }
            }
            $PrintString = "";

            $PreText = "Datum:" . date('d.m.Y.', strtotime($VremePorudzbine)) . " Vreme:" . date('H:i:s', strtotime($VremePorudzbine));
            $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

            $PreText = "Prodajno mesto: " . $ProdajnoMesto;
            $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

            $PreText = "Kasa: " . $Kasa['oznaka'];
            $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

            $PrintString .= str_pad(" ", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

            $PreText = "Sto: " . $NazivStola;
            $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

            $PrintString .= str_pad(" ", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

            $PreText = $OdeljenjeNaziv;
            $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

            $PrintString .= str_pad(" ", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

            foreach ($Stampac['artikli'] as $ArtikalStampaca) {
                if ($ArtikalStampaca['Tip'] == 'DODA') {
                    $Left = $PrinterLetters - 9;
                    $PreText = str_pad("     " . $ArtikalStampaca['Kolicina'] . "X ", 9, " ", STR_PAD_RIGHT) . "" . mb_substr($ArtikalStampaca['Naziv'], 0, $Left, 'UTF-8');
                    $PrintString .= $PreText . "\n";
                } elseif ($ArtikalStampaca['Tip'] == 'OPISARTIKLA') {
                    $TextPrint = " ** " . $ArtikalStampaca['Naziv'];
                    if (strlen($TextPrint) < $PrinterLetters) {
                        $PreText = str_pad($TextPrint, $PrinterLetters, " ", STR_PAD_RIGHT);
                    } else {
                        $PreText = $TextPrint;
                    }
                    $PrintString .= $PreText . "\n";
                } else {
                    // $Left = $PrinterLetters - 9;
                    // $PreText = str_pad($ArtikalStampaca['Kolicina'] . "X ", 9, " ", STR_PAD_RIGHT) . "" . mb_substr($ArtikalStampaca['Naziv'], 0, $Left, 'UTF-8');
                    $PrintString .= $ArtikalStampaca['Kolicina'] . "X " . $ArtikalStampaca['Naziv'] . "\n";
                }
            }
            $PrintString .= FormatText("") . "\n";

            if ($TuraOpis != '') {
                $OpisTurePrint = preg_replace('/(<[^>]+) style=".*?"/i', '$1', $TuraOpis);
                $OpisTurePrint = strip_tags($OpisTurePrint, '<div>');
                $OpisTurePrint = str_replace('&nbsp;', ' ', $OpisTurePrint);
                $OpisTurePrint = str_replace('</div>', '', $OpisTurePrint);
                //error_log($OpisTurePrint);
                $arrayOpisTure = preg_split('<div>', $OpisTurePrint);
                $PrintString .= str_pad("*", $PrinterLetters, "*", STR_PAD_BOTH) . "\n";

                $PrintString .= FormatText("Opis:") . "\n";

                foreach ($arrayOpisTure as $OpisTure) {
                    $OpisTure = str_replace('<', '', $OpisTure);
                    $OpisTure = str_replace('>', '', $OpisTure);
                    if (strlen($OpisTure) < $PrinterLetters) {
                        $PreText = str_pad($OpisTure, $PrinterLetters, " ", STR_PAD_RIGHT);
                    } else {
                        $PreText = $OpisTure;
                    }
                    $PrintString .= str_pad($PreText, $PrinterLetters, " ", STR_PAD_RIGHT) . "\n";
                }
                $PrintString .= str_pad("*", $PrinterLetters, "*", STR_PAD_BOTH) . "\n";
            }
            $PreText = "Konobar: " . $_COOKIE['UserName'];
            $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
            try {
                // Enter the share name for your USB printer here
                if (strpos($NazivStampaca, "/")) {
                    $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                } else {
                    $connector = new WindowsPrintConnector($NazivStampaca);
                }
                $printer = new Printer($connector);
                $printer->pulse(1, 300, 300);
                $printer->setPrintLeftMargin(0);
                $printer->setJustification(Printer::JUSTIFY_LEFT);
                $printer->text($PrintString);
                $printer->feed();
                $printer->cut();
                $printer->close();
            } catch (Exception $e) {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $NazivStampaca . ' ' . $e->getMessage()));
                die();
            }
        }
    }
    echo json_encode(array('Status' => 'success', 'Message' => '', 'Action' => $Logout));
    die();
}
if (isset($_POST['UbaciRacune'])) {
    $TotalRacun = 0;
    $TotalPopust = 0;
    $brojStola = 0;
    $StalniGostId = null;
    $Placanja = [];
    $IznosPlacanja = 0;
    $PosluzenihGostiju = 0;
    $idKorisnika = mysqli_real_escape_string($link, $_COOKIE['UserId']);
    $korisnikPrograma = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $KasaNameGet = mysqli_real_escape_string($link, $KasaName);
    $Logout = "";
	$racunZatvorenNemaStampaca = "";
    if (isset($KasaData['smenski_rad_odjava'])) {
        if ($KasaData['smenski_rad_odjava'] == 'true') {
            $Logout = "Logout";
        }
    }
    if ($KasaId != '') {
        $kasaId = $KasaId;
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Kasa na kojoj radite ne postoji u bazi!!!'));
        die();
    }
    $RacunKomitent = "";
    $StalniGostId = "";
    $PosluzenihGostiju = "";
    $MeniId = "";
    $MeniNaziv = "";
    $MeniKolicina = "";
    $MeniCena = "";
    $RacunTuraOpis = "";
    $InvoiceType = "";
    $TransactionType = "Sale";
    $BuyerVat = "";
    $BuyerOption = "";
    $BuyerVatID = "";
    $BuyerOptionID = "";
    $ReferentNumber = "";
    $FakturaFormat = "";

    foreach ($_POST['UbaciRacune'] as $d) {
        if ($d[0] == 'TotalZaRacun') {
            $TotalRacun = mysqli_real_escape_string($link, $d[1]);
        } elseif ($d[0] == 'PopustZaRacun') {
            if ($d[1] > 0) {
                $TotalPopust = mysqli_real_escape_string($link, number_format($d[1], 14, '.', ''));
            }
        } elseif ($d[0] == 'BrojStola') {
            $brojStola = mysqli_real_escape_string($link, $d[1]);
        } elseif ($d[0] == 'StalniGostId') {
            if ($d[1] != 0) {
                $StalniGostId = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'RacunKomitent') {
            if ($d[1] != 0) {
                $RacunKomitent = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'BrojPosluzenihGostiju') {
            if ($d[1] > 0) {
                $PosluzenihGostiju = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'MeniId') {
            if ($d[1] > 0) {
                $MeniId = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'MeniNaziv') {
            if ($d[1] != '') {
                $MeniNaziv = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'MeniKolicina') {
            if ($d[1] > 0) {
                $MeniKolicina = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'MeniCena') {
            if ($d[1] > 0) {
                $MeniCena = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'RacunTuraOpis') {
            if ($d[1] != "") {
                $RacunTuraOpis = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'InvoiceType') {
            if ($d[1] != "") {
                $InvoiceType = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'FakturaFormat') {
            if ($d[1] != "") {
                $FakturaFormat = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'BuyerVat') {
            if ($d[1] != "") {
                $BuyerVat = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'BuyerOption') {
            if ($d[1] != "") {
                $BuyerOption = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'BuyerVatID') {
            if ($d[1] != "") {
                $BuyerVatID = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'BuyerOptionID') {
            if ($d[1] != "") {
                $BuyerOptionID = mysqli_real_escape_string($link, $d[1]);
            }
        } elseif ($d[0] == 'ReferentNumber') {
            if ($d[1] != "") {
                $ReferentNumber = mysqli_real_escape_string($link, $d[1]);
            }
        } else {
            if ($d[1] > 0) {
                $Placanja[$d[0]] = $d[1];
                $IznosPlacanja = $IznosPlacanja + $d[1];
            }
        }
    }
    $TipRacuna = mysqli_real_escape_string($link, $_POST['TipUbacivanjaRacuna']);
    $DostavaID = 0;
    $DostavaAdresaID = 0;
    if ($InvoiceType != '') {
        $LPFRUrl = $KasaData['lpfr_adresa'];
        $Pin = $KasaData['lpfr_pin'];
        $UrlStatus = $LPFRUrl . "/api/v3/status";
        $DoRequest = 1;
        $cu = curl_init();
        $apiHeader[] = 'Accept: application/json';
        $apiHeader[] = 'Content-Type: application/json';
        $options = array(
            CURLOPT_URL => $UrlStatus,
            CURLOPT_HTTPHEADER => $apiHeader,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET'
        );
        curl_setopt_array($cu, $options);
        $outputcu = curl_exec($cu);
        if (curl_errno($cu) > 0) {
            $DoRequest = 0;
        }
        curl_close($cu);
        $StatusResults = json_decode($outputcu);
        if ($StatusResults->isPinRequired != '') {
            if ($Pin != '') {
                $UrlPIN = $LPFRUrl . "/api/v3/pin";
                $cu = curl_init();
                $options = array(
                    CURLOPT_URL => $UrlPIN,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_HEADER => false, // true to show header information
                    CURLINFO_HEADER_OUT => true,
                    CURLOPT_HTTPGET => false,
                    CURLOPT_POST => true,
                    CURLOPT_FOLLOWLOCATION => false,
                    CURLOPT_VERBOSE => true,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_SSL_VERIFYHOST => false, // true in production
                    CURLOPT_SSL_VERIFYPEER => false, // true in production
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_HTTPHEADER => $apiHeader,
                    CURLOPT_USERAGENT => 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)',
                    CURLOPT_HTTPAUTH => CURLAUTH_ANYSAFE, // CURLAUTH_BASIC
                    CURLOPT_POSTFIELDS => $Pin,
                );
                curl_setopt_array($cu, $options);
                $outputcu = curl_exec($cu);
                if (curl_errno($cu) > 0) {
                    $DoRequest = 0;
                    echo json_encode(array('Status' => 'error', 'Message' => 'Greška pri komunikaciji sa LPFR!' . curl_error($cu)));
                }
                curl_close($cu);
                $Result = json_decode($outputcu);
                if ($Result != "0100") {
                    if ($Result == "2100") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'PIN koji ste uneli nije ispravan!'));
                    } elseif ($Result == "2110") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Kartica je zaključana!'));
                    } elseif ($Result == "2210") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Sigurnosni element je zaključan! Nije moguća fiskalizacija računa!'));
                    } elseif ($Result == "2220") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća komunikacija sa sigurnosnim elementom!'));
                    } elseif ($Result == "1300") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Kartica nije umetnuta!'));
                    } elseif ($Result->status == "400") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'LPFR nije dostupan!'));
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nepoznata greska! Kod:' . $outputcu));
                    }
                    $DoRequest = 0;
                }
            } else {
                echo json_encode(array('Status' => 'pinrequired', 'Message' => 'Neophodno je da unesete PIN!'));
                $DoRequest = 0;
            }
        }
        if ($DoRequest == 1) {
            if ($KasaData['lpfr_adresa'] != '') {
                $Date = date('Y-m-d');
                $DateOfIssue = $Date . " " . date('H:i:s');
                $FiscalRequest = [];
                $EntityVAT = $BuyerVat;
                $EntityVATType = $BuyerVatID;
                $EntityField = $BuyerOption;
                $EntityFieldType = $BuyerOptionID;
                $ReferentNumber = $ReferentNumber;
                $ReferentTime = "";
                $FiscalRequest['invoiceType'] = $InvoiceType;
                $FiscalRequest['transactionType'] = $TransactionType;
                $FiscalRequest['cashier'] = $UserData['punoIme'];
                if ($EntityVAT > 0) {
                    if ($EntityVATType != '') {
                        $FiscalRequest['buyerId'] = $EntityVATType . ":" . $EntityVAT;
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Odaberite tip oznake kupca!'));
                        die();
                    }
                }
                if ($EntityField != '') {
                    if ($EntityFieldType != '' && $EntityVAT != '') {
                        $FiscalRequest['buyerCostCenterId'] = $EntityFieldType . ":" . $EntityField;
                    } elseif ($EntityVAT == '') {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Unesite oznaku kupca'));
                        die();
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Odaberite Tip opcionog polja kupca'));
                        die();
                    }
                }
                if ($ReferentNumber != '') {
                    //ovde naci referentno vreme
                    $FiscalRequest['referentDocumentDT'] = $ReferentTime;
                    $FiscalRequest['referentDocumentNumber'] = $ReferentNumber;
                }
                $FiscalRequest['options']['OmitTextualRepresentation'] = 0;
                $FiscalRequest['options']['OmitQRCodeGen'] = 0;
                $FiscalRequest['invoiceNumber'] = '230/' . $ThisSoftwareVersion;
                $IncProduct = 0;
                $SvePoreskeStope = [];
                $GetPoreskeStope = mysqli_query($link, "SELECT * FROM poreske_stope WHERE 1");
                if (mysqli_num_rows($GetPoreskeStope) > 0) {
                    while ($rowPS = mysqli_fetch_array($GetPoreskeStope)) {
                        $SvePoreskeStope[$rowPS['id']] = $rowPS['oznaka'];
                    }
                } else {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Kasa nema podešene poreske stope!!! Izdavanje računa nije moguće!!!'));
                    die();
                }
                $SaveProducts = [];
                if ($MeniId == "") {
                    $GrupisaniArtikli = [];
                    foreach ($_POST['UbaceniArtikli'] as $UbaceniArtikal) {
                        $IdArtikla = mysqli_real_escape_string($link, $UbaceniArtikal[3]);
                        $CenaArtikla = mysqli_real_escape_string($link, $UbaceniArtikal[2]);
                        $NazivArtikla = mysqli_real_escape_string($link, $UbaceniArtikal[4]);
                        $ProductInsertQuantity = mysqli_real_escape_string($link, $UbaceniArtikal[1]);
                        if (isset($GrupisaniArtikli[$IdArtikla])) {
                            $ItemIsPresent = 0;
                            foreach ($GrupisaniArtikli[$IdArtikla] as $Key => $KeyData) {
                                if ($KeyData["Cena"] == $CenaArtikla) {
                                    $GrupisaniArtikli[$IdArtikla][$Key]['Kolicina'] = $GrupisaniArtikli[$IdArtikla][$Key]['Kolicina'] + $ProductInsertQuantity;
                                    $ItemIsPresent = 1;
                                }
                            }
                            if ($ItemIsPresent == 0) {
                                $GrupisaniArtikli[$IdArtikla][] = ["Cena" => $CenaArtikla, "Naziv" => $NazivArtikla, "Kolicina" => $ProductInsertQuantity];
                            }
                        } else {
                            $GrupisaniArtikli[$IdArtikla][] = ["Cena" => $CenaArtikla, "Naziv" => $NazivArtikla, "Kolicina" => $ProductInsertQuantity];
                        }
                    }
                    foreach ($GrupisaniArtikli as $IdArtikla => $ArrayArtikala) {
                        $IdArtikla = mysqli_real_escape_string($link, $IdArtikla);
                        $GetArtikal = mysqli_query($link, "SELECT * FROM artikal WHERE id='$IdArtikla'");
                        if (mysqli_num_rows($GetArtikal) == 1) {
                            $rowArtikli = mysqli_fetch_array($GetArtikal);
                            foreach ($ArrayArtikala as $UbaceniArtikal) {
                                $CenaArtikla = mysqli_real_escape_string($link, $UbaceniArtikal["Cena"]);
                                $NazivArtikla = mysqli_real_escape_string($link, $UbaceniArtikal["Naziv"]);
                                $ProductInsertQuantity = mysqli_real_escape_string($link, $UbaceniArtikal["Kolicina"]);
                                if ($ProductInsertQuantity > 0 && $CenaArtikla > 0) {
                                    if ($rowArtikli['dozvoljenPopust'] == 1) {
                                        if ($TotalPopust > 0) {
                                            $Popust = $CenaArtikla * (0 + $TotalPopust / 100);
                                        } else {
                                            $Popust = 0;
                                        }
                                    } else {
                                        $Popust = 0;
                                    }
                                    $ProductUnitName = $rowArtikli['jedinicaMere'];
                                    $ProductName = $NazivArtikla . "(" . $ProductUnitName . ")";
                                    $FiscalPrice = $CenaArtikla - $Popust;
                                    $ProductTotal = $FiscalPrice * number_format($ProductInsertQuantity, 3, '.', '');
                                    $ProductVatName = $SvePoreskeStope[$rowArtikli['poreskaGrupa']];
                                    $ProductGTIN = $rowArtikli['barCode'];
                                    if ($ProductGTIN == "undefined" || $ProductGTIN == "") {
                                        $ProductGTIN = null;
                                    }
                                    $FiscalRequest['items'][$IncProduct] = [
                                        "gtin" => $ProductGTIN, "name" => $ProductName,
                                        "quantity" => number_format($ProductInsertQuantity, 3, '.', ''),
                                        "unitPrice" => number_format($FiscalPrice, 2, '.', ''),
                                        "labels" => [$ProductVatName],
                                        "totalAmount" => $ProductTotal
                                    ];
                                    $SaveProducts[$IncProduct] = [
                                        "gtin" => $ProductGTIN,
                                        "name" => $ProductName,
                                        "quantity" => $ProductInsertQuantity,
                                        "unitPrice" => number_format($FiscalPrice, 2, '.', ''),
                                        "labels" => [$ProductVatName],
                                        "totalAmount" => $ProductTotal,
                                        "unitName" => $ProductUnitName
                                    ];
                                    //ovde ubacujemo stavke racuna
                                    $IncProduct++;
                                }
                            }
                        }
                    }
                } else {
                    $NazivArtiklaRacuna = $MeniNaziv;
                    $CenaArtiklaRacuna = $MeniCena;
                    if ($TotalPopust > 0) {
                        $Popust = $CenaArtiklaRacuna * (0 + $TotalPopust / 100);
                    } else {
                        $Popust = 0;
                    }
                    $CenaArtiklaRacuna = $CenaArtiklaRacuna - $Popust;
                    if ($MeniKolicina > 0 && $CenaArtiklaRacuna > 0) {
                        $CenaArtiklaRacuna = number_format($CenaArtiklaRacuna, 2, '.', '');
                        $KolicinaArtiklaRacuna = number_format($MeniKolicina, 3, '.', '');
                        $poreskaGrupa = GetSettingVal('meni.redni.broj.pg');

                        $OznakaPoreskeStope = $SvePoreskeStope[$poreskaGrupa];
                        //ovde ubacujemo stavke racuna za meni
                        $ProductUnitName = "KOM";
                        $ProductName = $NazivArtiklaRacuna . "(" . $ProductUnitName . ")";
                        $FiscalPrice = $CenaArtiklaRacuna;
                        $ProductTotal = $FiscalPrice * number_format($MeniKolicina, 3, '.', '');
                        $ProductVatName = $SvePoreskeStope[$poreskaGrupa];
                        $ProductGTIN = null;
                        $FiscalRequest['items'][$IncProduct] = [
                            "gtin" => $ProductGTIN, "name" => $ProductName,
                            "quantity" => number_format($ProductInsertQuantity, 3, '.', ''),
                            "unitPrice" => number_format($FiscalPrice, 2, '.', ''),
                            "labels" => [$ProductVatName],
                            "totalAmount" => $ProductTotal
                        ];
                        $SaveProducts[$IncProduct] = [
                            "gtin" => $ProductGTIN,
                            "name" => $ProductName,
                            "quantity" => $ProductInsertQuantity,
                            "unitPrice" => number_format($FiscalPrice, 2, '.', ''),
                            "labels" => [$ProductVatName],
                            "totalAmount" => $ProductTotal,
                            "unitName" => $ProductUnitName
                        ];
                        //ovde ubacujemo stavke racuna
                        $IncProduct++;
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Neispravna količina i cena računa!!! Izdavanje računa nije moguće!!!'));
                        die();
                    }
                }
                $PrintFakturaData = 0;
                if (count($SaveProducts) > 0) {
                    $SavePayments = [];
                    $IncPayment = 0;
                    $UkupnoPlacenoFiskal = 0;
                    foreach ($_POST['UbaciRacune'] as $d) {
                        $NacinPlacanjaFiscal = $d[0];
                        $IznosPlacanjaFiscal = $d[1];
                        if ($IznosPlacanja > 0) {
                            if ($NacinPlacanjaFiscal == 'KARTICA') {
                                if ($IznosPlacanjaFiscal > 0) {
                                    $FiscalRequest['payment'][$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'Card'];
                                    $SavePayments[$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'Card'];
                                    $IncPayment++;
                                    $UkupnoPlacenoFiskal = $UkupnoPlacenoFiskal + $IznosPlacanjaFiscal;
                                }
                            }
                            if ($NacinPlacanjaFiscal == 'GOTOVINA') {
                                if ($IznosPlacanjaFiscal > 0) {
                                    $FiscalRequest['payment'][$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'Cash'];
                                    $SavePayments[$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'Cash'];
                                    $IncPayment++;
                                    $UkupnoPlacenoFiskal = $UkupnoPlacenoFiskal + $IznosPlacanjaFiscal;
                                }
                            }
                            if ($NacinPlacanjaFiscal == 'CEK') {
                                if ($IznosPlacanjaFiscal > 0) {
                                    $FiscalRequest['payment'][$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'Check'];
                                    $SavePayments[$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'Check'];
                                    $IncPayment++;
                                    $UkupnoPlacenoFiskal = $UkupnoPlacenoFiskal + $IznosPlacanjaFiscal;
                                }
                            }
                            if ($NacinPlacanjaFiscal == 'FAKTURA') {
                                if ($IznosPlacanjaFiscal > 0) {
                                    $FiscalRequest['payment'][$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'WireTransfer'];
                                    $SavePayments[$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'WireTransfer'];
                                    $IncPayment++;
                                    $PrintFakturaData = 1;
                                    $UkupnoPlacenoFiskal = $UkupnoPlacenoFiskal + $IznosPlacanjaFiscal;
                                }
                            }
                            if ($NacinPlacanjaFiscal == 'INSTANT') {
                                if ($IznosPlacanjaFiscal > 0) {
                                    $FiscalRequest['payment'][$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'MobileMoney'];
                                    $SavePayments[$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'MobileMoney'];
                                    $IncPayment++;
                                    $UkupnoPlacenoFiskal = $UkupnoPlacenoFiskal + $IznosPlacanjaFiscal;
                                }
                            }
                            if ($NacinPlacanjaFiscal == 'VAUCER') {
                                if ($IznosPlacanjaFiscal > 0) {
                                    $FiscalRequest['payment'][$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'Voucher'];
                                    $SavePayments[$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'Voucher'];
                                    $IncPayment++;
                                    $UkupnoPlacenoFiskal = $UkupnoPlacenoFiskal + $IznosPlacanjaFiscal;
                                }
                            }
                            if ($NacinPlacanjaFiscal == 'DRUGO') {
                                if ($IznosPlacanjaFiscal > 0) {
                                    $FiscalRequest['payment'][$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'Other'];
                                    $SavePayments[$IncPayment] = ["amount" => $IznosPlacanjaFiscal, "paymentType" => 'Other'];
                                    $IncPayment++;
                                    $UkupnoPlacenoFiskal = $UkupnoPlacenoFiskal + $IznosPlacanjaFiscal;
                                }
                            }
                        }
                    }
                    if ($UkupnoPlacenoFiskal >= $TotalRacun) {
                        if (count($SavePayments) > 0) {
                            //error_log(json_encode($FiscalRequest));
                            $UrlService = $LPFRUrl . "/api/v3/invoices";
                            $curl = curl_init();
                            $options = array(
                                CURLOPT_URL => $UrlService,
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_HEADER => false, // true to show header information
                                CURLINFO_HEADER_OUT => true,
                                CURLOPT_HTTPGET => false,
                                CURLOPT_POST => true,
                                CURLOPT_FOLLOWLOCATION => false,
                                CURLOPT_VERBOSE => true,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_SSL_VERIFYHOST => false, // true in production
                                CURLOPT_SSL_VERIFYPEER => false, // true in production
                                CURLOPT_TIMEOUT => 30,
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_HTTPHEADER => $apiHeader,
                                CURLOPT_USERAGENT => 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)',
                                CURLOPT_HTTPAUTH => CURLAUTH_ANYSAFE, // CURLAUTH_BASIC
                                CURLOPT_POSTFIELDS => json_encode($FiscalRequest)
                            );
                            curl_setopt_array($curl, $options);
                            $output = curl_exec($curl);

                            if (curl_errno($curl) > 0) {
                                echo json_encode(array('Status' => 'error', 'Message' => 'Greška pri kontaktiranju LPFR!' . curl_error($curl)));
                                die();
                            } else {
                                //error_log($output);
                                $json = json_decode($output);
                                if (strtoupper($json->messages) != 'SUCCESS') {
                                    $ModelError = $json->modelState;
                                    $GreskeKojeSuUocene = "";
                                    foreach ($ModelError as $ErrorData) {
                                        $StaJeLose = $ErrorData->property;
                                        $KojeSuGreske = $ErrorData->errors;
                                        $GreskeKojeSuUocene .= "Polje:" . $StaJeLose;
                                        foreach ($KojeSuGreske as $KodGreske) {
                                            if ($KodGreske == '2310') {
                                                $GreskeKojeSuUocene .= " poreska stopa nije ispravna. ";
                                            } elseif ($KodGreske == '2800') {
                                                $GreskeKojeSuUocene .= " je obavezno. ";
                                            } elseif ($KodGreske == '2801') {
                                                $GreskeKojeSuUocene .= " je predugo. ";
                                            } elseif ($KodGreske == '2802') {
                                                $GreskeKojeSuUocene .= " je prekratko. ";
                                            } elseif ($KodGreske == '2803') {
                                                $GreskeKojeSuUocene .= " je neispravne dužine. ";
                                            } elseif ($KodGreske == '2804') {
                                                $GreskeKojeSuUocene .= " je izvan očekivane vrednosti. ";
                                            } elseif ($KodGreske == '2805') {
                                                $GreskeKojeSuUocene .= " je neispravne vrednosti. ";
                                            } elseif ($KodGreske == '2806') {
                                                $GreskeKojeSuUocene .= " je neispravnog formata. ";
                                            } elseif ($KodGreske == '2807') {
                                                $GreskeKojeSuUocene .= " ne sadrži makar jedan element. ";
                                            } elseif ($KodGreske == '2808') {
                                                $GreskeKojeSuUocene .= " sadrži više od dozvoljenog broja elemenata. ";
                                            }
                                        }
                                    }
                                    echo json_encode(array('Status' => 'error', 'Message' => 'Neuspešna fiskalizacija! ' . $GreskeKojeSuUocene));
                                    die();
                                } else {
                                    $text = $json->journal;
                                    $qrCode = $json->verificationQRCode;
                                    $qrurl = $json->verificationUrl;
                                    $LPFRNumber = $json->invoiceNumber;
                                    $JournalData = [];
                                    foreach ($json as $JsonName => $JsonValue) {
                                        if ($JsonName != 'verificationQRCode' && $JsonName != 'encryptedInternalData' && $JsonName != 'signature' && $JsonName != 'journal') {
                                            $JournalData[$JsonName] = $JsonValue;
                                        }
                                    }
                                    $JournalData['StavkeProizvoda'] = $SaveProducts;
                                    $JournalData['StavkePlacanja'] = $SavePayments;
                                    $JournalData['EsirKorisnik'] = $UserData['punoIme'];
                                    if ($EntityVAT > 0) {
                                        $JournalData['EsirKupacPIB'] = $EntityVAT;
                                        $JournalData['EsirKupacPIBTip'] = $EntityVATType;
                                    }
                                    if ($EntityField != '') {
                                        $JournalData['EsirKupacOP'] = $EntityField;
                                        $JournalData['EsirKupacOPTip'] = $EntityFieldType;
                                    }
                                    if ($ReferentNumber != '') {
                                        $JournalData['EsirReferentnoVremeDokumenta'] = $ReferentTime;
                                    }
                                    $JournalData['InvoiceType'] = $InvoiceType;
                                    $JournalData['TransactionType'] = $TransactionType;
                                    $brojRacuna = $LPFRNumber;
                                    $tipRacuna = mysqli_real_escape_string($link, $InvoiceType);
                                    $tipTransakcije = mysqli_real_escape_string($link, $TransactionType);
                                    $KONOBAR_ID = mysqli_real_escape_string($link, $UserId);
                                    $vremeRacuna = date('Y-m-d H:i:s', strtotime($JournalData['sdcDateTime']));
                                    $vremeRacuna = mysqli_real_escape_string($link, $vremeRacuna);
                                    $brojRacuna = mysqli_real_escape_string($link, $LPFRNumber);
                                    $podaciRacuna = serialize($JournalData);
                                    $podaciRacuna = mysqli_real_escape_string($link, $podaciRacuna);
									
									// za provjeru da nije 2 puta kliknuto za isti racun
									$maxVremeIzBaze = date('Y-m-d H:i:s', mktime(0,0,0,1,1,2022));
									$GetMaxVreme = mysqli_query($link, "SELECT max(vremeRacuna) as maxVreme FROM racun_fiskal") or die(mysqli_error($link));
									if (mysqli_num_rows($GetMaxVreme) > 0) {
										while ($rowMaxVreme = mysqli_fetch_array($GetMaxVreme)) {
											$maxVremeIzBaze = $rowMaxVreme['maxVreme'];
										}
									}
									// ako je proslo vise od zadatih sekundi, onda ga upisi u bazu
									if(getSecFromDateAndTime($vremeRacuna) - getSecFromDateAndTime($maxVremeIzBaze) > MIN_SEKUNDI_IZMEDJU_DVA_RACUNA)
									{
										mysqli_query($link, "INSERT INTO racun_fiskal (RACUN_ID, brojRacuna, tipRacuna, tipTransakcije, KONOBAR_ID, vremeRacuna, podaciRacuna) 
										VALUES (0, '$brojRacuna', '$tipRacuna', '$tipTransakcije', '$KONOBAR_ID', '$vremeRacuna', '$podaciRacuna')") or die(mysqli_error($link));
										$UpdateRacunFiskal = mysqli_insert_id($link);
									}

                                    if ($FakturaFormat != "A4") {
                                        $GetStampac = mysqli_query($link, "SELECT * FROM stampac WHERE stampaGotovinski=1 ORDER BY id ASC LIMIT 1");
                                        if (mysqli_num_rows($GetStampac) == 1) {
                                            $StampacData = mysqli_fetch_array($GetStampac);
                                            $NazivStampaca = $StampacData['naziv'];
                                            $PrinterSize = 57;
                                            if ($StampacData['tip'] == 'POSBANK80MM') {
                                                $PrinterSize = 80;
                                            }
                                            if ($tipRacuna == 'Normal') {
                                                $PrintNameStart = " FISKALNI RAČUN ";
                                                $PrintNameEnd = " KRAJ FISKALNOG RAČUNA ";
                                            } else {
                                                $PrintNameStart = " OVO NIJE FISKALNI RAČUN ";
                                                $PrintNameEnd = " OVO NIJE FISKALNI RAČUN ";
                                            }
                                            $TipRacunaStampa = "";
                                            $VrstaRacunaStampa = "";
                                            $PorezUkupno = 0;

                                            if ($tipTransakcije == 'Sale') {
                                                $TipRacunaStampa = "PRODAJA";
                                            } else {
                                                $TipRacunaStampa = "REFUNDACIJA";
                                            }
                                            if ($tipRacuna == 'Normal') {
                                                $VrstaRacunaStampa = "PROMET";
                                            } else if ($tipRacuna == 'Training') {
                                                $VrstaRacunaStampa = "OBUKA";
                                            } else if ($tipRacuna == 'Copy') {
                                                $VrstaRacunaStampa = "KOPIJA";
                                            } else if ($tipRacuna == 'Proforma') {
                                                $VrstaRacunaStampa = "PREDRAČUN";
                                            } else if ($tipRacuna == 'Advance') {
                                                $VrstaRacunaStampa = "AVANS";
                                            }

                                            if ($PrinterSize == 80) {
                                                $width1 = 480;
                                                $fontsize = 15;
                                                $linesize = 23;
                                                $barcodeSize = 420;
                                                $fontFamily = "LUCON.TTF";
                                                $TotalCharacters = 40;
                                            } else {
                                                $width1 = 375;
                                                $fontsize = 14;
                                                $linesize = 18;
                                                $barcodeSize = 365;
                                                $fontFamily = "LUCON.TTF";
                                                $TotalCharacters = 34;
                                            }
                                            try {
                                                // Enter the share name for your USB printer here
                                                if (strpos($NazivStampaca, "/")) {
                                                    $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                                                } else {
                                                    $connector = new WindowsPrintConnector($NazivStampaca);
                                                }
                                                $printer = new Printer($connector);
                                                $printer->pulse(1, 300, 300);
                                                $printer->setPrintLeftMargin(0);
                                                if ($PrinterSize == 80) {
                                                    $printer->setJustification(Printer::JUSTIFY_CENTER);
                                                } else {
                                                    $printer->setJustification(Printer::JUSTIFY_LEFT);
                                                }

                                                $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                                $MinusToAdd = floor($MinusToAdd);
                                                $JournalPrint = str_pad("", $MinusToAdd, "=", STR_PAD_LEFT) . "" . mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, "=", STR_PAD_RIGHT) . "\n";

                                                $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['tin'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                                $MinusToAdd = floor($MinusToAdd);
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['tin'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                                $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['businessName'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                                $MinusToAdd = floor($MinusToAdd);
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['businessName'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                                $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['locationName'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                                $MinusToAdd = floor($MinusToAdd);
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['locationName'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                                $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['address'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                                $MinusToAdd = floor($MinusToAdd);
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['address'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                                $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['district'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                                $MinusToAdd = floor($MinusToAdd);
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['district'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                                $JournalPrint .= str_pad("-", $TotalCharacters, "-", STR_PAD_BOTH) . "\n";

                                                $MinusToAdd = $TotalCharacters - mb_strlen("Kasir:" . mb_substr($JournalData['EsirKorisnik'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                $JournalPrint .= "Kasir:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['EsirKorisnik'], 0, $TotalCharacters, 'UTF-8') . "\n";

                                                if (isset($JournalData['EsirKupacPIB']) && $JournalData['EsirKupacPIB']>0) {
                                                    $KupacPrint = $JournalData['EsirKupacPIBTip'] . ":" . $JournalData['EsirKupacPIB'];
                                                    $MinusToAdd = $TotalCharacters - mb_strlen("ID kupca:" . mb_substr($KupacPrint, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                    $JournalPrint .= "ID kupca:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($KupacPrint, 0, $TotalCharacters, 'UTF-8') . "\n";
                                                }

                                                if (isset($JournalData['EsirKupacOP'])) {
                                                    $KupacOpPrint = $JournalData['EsirKupacOPTip'] . ":" . $JournalData['EsirKupacOP'];
                                                    $MinusToAdd = $TotalCharacters - mb_strlen("Opciono polje kupca:" . mb_substr($KupacOpPrint, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                    $JournalPrint .= "Opciono polje kupca:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($KupacOpPrint, 0, $TotalCharacters, 'UTF-8') . "\n";
                                                }

                                                $MinusToAdd = $TotalCharacters - mb_strlen("ESIR broj:" . mb_substr('230/' . $ThisSoftwareVersion, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                $JournalPrint .= "ESIR broj:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr('230/' . $ThisSoftwareVersion, 0, $TotalCharacters, 'UTF-8') . "\n";

                                                if ($ReferentNumber != '') {
                                                    $MinusToAdd = $TotalCharacters - mb_strlen("Ref. broj:" . mb_substr($ReferentNumber, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                    $JournalPrint .= "Ref. broj:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($ReferentNumber, 0, $TotalCharacters, 'UTF-8') . "\n";

                                                    if ($ReferentTime != '') {
                                                        $RefTime = date('d.m.Y H:i:s', strtotime($ReferentTime));
                                                        $MinusToAdd = $TotalCharacters - mb_strlen("Ref. vreme:" . mb_substr($RefTime, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                        $JournalPrint .= "Ref. vreme:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($RefTime, 0, $TotalCharacters, 'UTF-8') . "\n";
                                                    }
                                                }
                                                $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($VrstaRacunaStampa . " " . $TipRacunaStampa, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                                $JournalPrint .= str_pad("", $MinusToAdd, "-", STR_PAD_LEFT) . "" . mb_substr($VrstaRacunaStampa . " " . $TipRacunaStampa, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, "-", STR_PAD_LEFT) . "\n";

                                                $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("Artikli", 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                $JournalPrint .= mb_substr("Artikli", 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "\n";

                                                $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";
                                                if ($PrinterSize == 80) {
                                                    $JournalPrint .= mb_substr("Naziv    Cena       Kol.          Ukupno", 0, $TotalCharacters, 'UTF-8') . "\n";
                                                } else {
                                                    $JournalPrint .= mb_substr("Naziv  Cena     Kol.        Ukupno", 0, $TotalCharacters, 'UTF-8') . "\n";
                                                }



                                                //error_log(str_pad(mb_substr("", 0, 40, 'UTF-8'), 40, "=", STR_PAD_LEFT));
                                                foreach ($JournalData['StavkeProizvoda'] as $StavkaRacuna) {
                                                    /*
													if ($StavkaRacuna['gtin'] != '') {
                                                        $ArticleName = $StavkaRacuna['gtin'] . "-" . $StavkaRacuna['name'];
                                                    } else {
                                                        
                                                    }
													*/
													$ArticleName = $StavkaRacuna['name'];
                                                    $ArticleName .= " (";
                                                    foreach ($StavkaRacuna['labels'] as $TaxMark) {
                                                        $ArticleName .= $TaxMark;
                                                    }
                                                    $ArticleName .= ")";
                                                    $arr = array();
                                                    $strLen = mb_strlen($ArticleName, 'UTF-8');
                                                    for ($i = 0; $i < $strLen; $i++) {
                                                        $Name = mb_substr($ArticleName, $i, $TotalCharacters, 'UTF-8');
                                                        $MinusToAdd = $TotalCharacters - mb_strlen($Name, 'UTF-8');
                                                        $JournalPrint .= str_pad($Name, $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";
                                                        $i = $i + $TotalCharacters - 1;
                                                    }
                                                    if ($TransactionType != 'Sale') {
                                                        $StavkaRacuna['totalAmount'] = "-" . $StavkaRacuna['totalAmount'];
                                                    }
                                                    $TotalCharactersPrice = mb_strlen(number_format($StavkaRacuna['unitPrice'], 2, '.', ''), 'UTF-8');
                                                    $TotalCharactersQuantity = mb_strlen(number_format($StavkaRacuna['quantity'], 3, '.', ''), 'UTF-8');
                                                    $TotalCharactersTotal = mb_strlen(number_format($StavkaRacuna['totalAmount'], 2, '.', ''), 'UTF-8');

                                                    if ($PrinterSize == 80) {
                                                        $MaxPrice = 13;
                                                        $MaxQuantity = 11;
                                                        $MaxTotal = 16;
                                                    } else {
                                                        $MaxPrice = 11;
                                                        $MaxQuantity = 9;
                                                        $MaxTotal = 14;
                                                    }
                                                    if ($TotalCharactersPrice < $MaxPrice) {
                                                        $MinusToAdd = $MaxPrice - $TotalCharactersPrice;
                                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($StavkaRacuna['unitPrice'], 2, '.', '');
                                                        $TakenFromPrice = 0;
                                                    } else {
                                                        $TakenFromPrice = $TotalCharactersPrice - $MaxPrice;
                                                        $JournalPrint .= number_format($StavkaRacuna['unitPrice'], 2, '.', '');
                                                    }

                                                    if ($TotalCharactersQuantity < $MaxQuantity) {
                                                        $MinusToAdd = $MaxQuantity - $TotalCharactersQuantity - $TakenFromPrice;
                                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($StavkaRacuna['quantity'], 3, '.', '');
                                                        $TakenFromQuantity = 0;
                                                    } else {
                                                        $TakenFromQuantity = $TotalCharactersQuantity - $MaxQuantity;
                                                        $JournalPrint .= number_format($StavkaRacuna['quantity'], 3, '.', '');
                                                    }

                                                    if ($TotalCharactersTotal < $MaxTotal) {
                                                        $MinusToAdd = $MaxTotal - $TotalCharactersTotal - $TakenFromQuantity;
                                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($StavkaRacuna['totalAmount'], 2, '.', '') . "\n";
                                                    } else {
                                                        $JournalPrint .= number_format($StavkaRacuna['totalAmount'], 2, '.', '') . "\n";
                                                    }
                                                }
                                                $JournalPrint .= str_pad("", $TotalCharacters, "-", STR_PAD_LEFT) . "\n";
                                                if ($TransactionType == 'Sale') {
                                                    $MinusToAdd = $TotalCharacters - mb_strlen("Ukupan iznos:" . number_format($JournalData['totalAmount'], 2, '.', ''), 'UTF-8');
                                                    $JournalPrint .= "Ukupan iznos:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($JournalData['totalAmount'], 2, '.', '') . "\n";
                                                } else {
                                                    $MinusToAdd = $TotalCharacters - mb_strlen("Ukupna refundacija:" . number_format($JournalData['totalAmount'], 2, '.', ''), 'UTF-8');
                                                    $JournalPrint .= "Ukupna refundacija:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($JournalData['totalAmount'], 2, '.', '') . "\n";
                                                }

                                                $SvaPlacanja = 0;
                                                foreach ($JournalData['StavkePlacanja'] as $StavkaPlacanja) {
                                                    if ($StavkaPlacanja['paymentType'] == 'Cash') {
                                                        $PaymentPrint = "Gotovina:";
                                                    } elseif ($StavkaPlacanja['paymentType'] == 'Card') {
                                                        $PaymentPrint = "Platna kartica:";
                                                    } elseif ($StavkaPlacanja['paymentType'] == 'Check') {
                                                        $PaymentPrint = "Ček:";
                                                    } elseif ($StavkaPlacanja['paymentType'] == 'WireTransfer') {
                                                        $PaymentPrint = "Prenos na račun:";
                                                    } elseif ($StavkaPlacanja['paymentType'] == 'MobileMoney') {
                                                        $PaymentPrint = "Mobilni novac:";
                                                    } elseif ($StavkaPlacanja['paymentType'] == 'Voucher') {
                                                        $PaymentPrint = "Vaučer:";
                                                    } elseif ($StavkaPlacanja['paymentType'] == 'Other') {
                                                        $PaymentPrint = "Dr. bezgotovinsko plaćanje:";
                                                    }
                                                    $MinusToAdd = $TotalCharacters - mb_strlen($PaymentPrint . "" . number_format($StavkaPlacanja['amount'], 2, '.', ''), 'UTF-8');
                                                    $JournalPrint .= $PaymentPrint . "" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($StavkaPlacanja['amount'], 2, '.', '') . "\n";
                                                    $SvaPlacanja = $SvaPlacanja + $StavkaPlacanja['amount'];
                                                }
                                                $Kusur = $SvaPlacanja - $JournalData['totalAmount'];

                                                if ($Kusur >= 0) {
                                                    $MinusToAdd = $TotalCharacters - mb_strlen("Повраћај:" . number_format($Kusur, 2, '.', ''), 'UTF-8');
                                                    $JournalPrint .= "Povraćaj:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($Kusur, 2, '.', '') . "\n";
                                                } else {
                                                    $PreostaloZaNaplatu = -1 * $Kusur;
                                                    if ($PreostaloZaNaplatu > 0) {
                                                        $MinusToAdd = $TotalCharacters - mb_strlen("Преостало за плаћање:" . number_format($PreostaloZaNaplatu, 2, '.', ''), 'UTF-8');
                                                        $JournalPrint .= "Preostalo za plaćanje:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($PreostaloZaNaplatu, 2, '.', '') . "\n";
                                                    }
                                                }
                                                if ($Kusur < 0) {
                                                    $Kusur = 0;
                                                }
                                                $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";
                                                if ($InvoiceType != 'Normal' && $InvoiceType != 'Advance') {
                                                    $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                                    $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";
                                                    $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";
                                                }
                                                if ($PrinterSize == 80) {
                                                    $JournalPrint .= "Oznaka         Ime    Stopa        Porez\n";
                                                } else {
                                                    $JournalPrint .= "Oznaka       Ime  Stopa      Porez\n";
                                                }

                                                foreach ($JournalData['taxItems'] as $TaxData) {
                                                    $PorezUkupno = $PorezUkupno + number_format($TaxData->amount, 2, '.', '');
                                                    if ($TaxData->categoryType == 0) {
                                                        $TaxData->rate = number_format($TaxData->rate, 2, '.', '') . "%";
                                                    } else {
                                                        $TaxData->rate = number_format($TaxData->rate, 2, '.', '');
                                                    }
                                                    $TotalCharactersLabel = mb_strlen($TaxData->label, 'UTF-8');
                                                    $TotalCharactersCategoryName = mb_strlen($TaxData->categoryName, 'UTF-8');
                                                    $TotalCharactersRate = mb_strlen($TaxData->rate, 'UTF-8');
                                                    $TotalCharactersAmount = mb_strlen(number_format($TaxData->amount, 2, '.', ''), 'UTF-8');

                                                    if ($PrinterSize == 80) {
                                                        $MaxLabel = 8;
                                                        $MaxName = 10;
                                                        $MaxRate = 9;
                                                        $MaxAmmount = 13;
                                                    } else {
                                                        $MaxLabel = 6;
                                                        $MaxName = 10;
                                                        $MaxRate = 7;
                                                        $MaxAmmount = 11;
                                                    }
                                                    if ($TotalCharactersLabel < $MaxLabel) {
                                                        $MinusToAdd = $MaxLabel - $TotalCharactersLabel;
                                                        $JournalPrint .= $TaxData->label . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT);
                                                        $TakenFromLabel = 0;
                                                    } else {
                                                        $TakenFromLabel = $TotalCharactersLabel - $MaxLabel;
                                                        $JournalPrint .= $TaxData->label;
                                                    }

                                                    if ($TotalCharactersCategoryName < $MaxName) {
                                                        $MinusToAdd = $MaxName - $TotalCharactersCategoryName - $TakenFromLabel;
                                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $TaxData->categoryName;
                                                        $TakenFromCategoryName = 0;
                                                    } else {
                                                        $TakenFromCategoryName = $TotalCharactersCategoryName - $MaxName;
                                                        $JournalPrint .= $TaxData->categoryName;
                                                    }

                                                    if ($TotalCharactersRate < $MaxRate) {
                                                        $MinusToAdd = $MaxRate - $TotalCharactersRate - $TakenFromCategoryName;
                                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $TaxData->rate;
                                                        $TakenFromRate = 0;
                                                    } else {
                                                        $TakenFromRate = $TotalCharactersRate - $MaxRate;
                                                        $JournalPrint .= $TaxData->rate;
                                                    }

                                                    if ($TotalCharactersAmount < $MaxAmmount) {
                                                        $MinusToAdd = $MaxAmmount - $TotalCharactersAmount - $TakenFromRate;
                                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($TaxData->amount, 2, '.', '') . "\n";
                                                    } else {
                                                        $JournalPrint .= number_format($TaxData->amount, 2, '.', '') . "\n";
                                                    }
                                                }
                                                $JournalPrint .= str_pad("", $TotalCharacters, "-", STR_PAD_LEFT) . "\n";
                                                $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("Ukupan iznos poreza:" . number_format($PorezUkupno, 2, ".", ""), 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                $JournalPrint .= "Ukupan iznos poreza:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($PorezUkupno, 2, ".", "") . "\n";
                                                $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";

                                                $PFRVreme = date('d.m.Y H:i:s', strtotime($JournalData['sdcDateTime']));
                                                $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("PFR vreme:" . $PFRVreme, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                $JournalPrint .= "PFR vreme:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $PFRVreme . "\n";
                                                if ($PrinterSize == 80) {
                                                    $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("PFR br. računa:" . $JournalData['invoiceNumber'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                    $JournalPrint .= "PFR br. računa:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $JournalData['invoiceNumber'] . "\n";
                                                } else {
                                                    $JournalPrint .= str_pad("PFR br. računa:", $TotalCharacters, " ", STR_PAD_RIGHT) . "\n";
                                                    $JournalPrint .= str_pad($JournalData['invoiceNumber'], $TotalCharacters, " ", STR_PAD_LEFT) . "\n";
                                                }

                                                $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("Brojač računa:" . $JournalData['invoiceCounter'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                $JournalPrint .= "Brojač računa:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $JournalData['invoiceCounter'] . "\n";

                                                $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";
                                                $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($PrintNameEnd, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                                $JournalPrint .= str_pad("", $MinusToAdd, "=", STR_PAD_LEFT) . "" . mb_substr($PrintNameEnd, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, "=", STR_PAD_RIGHT) . "\n";

                                                $text = $JournalPrint;
                                                $qrurl = $JournalData['verificationUrl'];

                                                include('qrcode.php');
                                                $options = ['s' => 'qr-l'];
                                                $generator = new QRCodeGen($qrurl, $options);
                                                //QRCode::png($qrurl, null, QR_ECLEVEL_L, 1, 0);
                                                $image = $generator->render_image();
                                                ob_start();
                                                imagepng($image);
                                                $imageString = ob_get_contents();
                                                ob_end_clean();
                                                imagedestroy($image);
                                                $array = preg_split("/\r\n|\n|\r/", $text);
                                                $CountArray = count($array);

                                                $height1 = ($CountArray * $linesize) + $barcodeSize + $linesize;
                                                if ($InvoiceType == 'Copy' && $TransactionType == 'Refund') {
                                                    $height1 = (($CountArray + 3) * $linesize) + $barcodeSize + $linesize;
                                                }
                                                $count = 1;
                                                $image = imagecreate($width1, $height1);
                                                $background = imagecolorallocate($image, 255, 255, 255);
                                                $color = imagecolorallocate($image, 0, 0, 0);
                                                imagefill($image, 0, 0, $background);
                                                $offsetTop = 0;
                                                $JournalPrintBigger = str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT);
                                                foreach ($array as $line) {
                                                    //error_log($line);
                                                    $count++;
                                                    if ($count == $CountArray) {
                                                        $offsetTop = $offsetTop + $linesize;
                                                        $source = imagecreatefromstring($imageString);
                                                        $width = imagesx($source);
                                                        $height = imagesy($source);
                                                        $newwidth = $barcodeSize;
                                                        $newheight = $barcodeSize;
                                                        $margin = ($width1 - $newwidth) / 2;
                                                        $margin = floor($margin);
                                                        imagecopyresized($image, $source, $margin, $offsetTop, 0, 0, $newwidth, $newheight, $width, $height);
                                                        $offsetTop = $offsetTop + $barcodeSize + $linesize;
                                                        //imagestring($image, 5, 10, $offsetTop, $line, $color);
                                                        if ($InvoiceType == 'Copy' && $TransactionType == 'Refund') {
                                                            $offsetTop = $offsetTop + $linesize + $linesize;
                                                            imagettftext($image, $fontsize, 0, 0, $offsetTop, $color, "assets/fonts/" . $fontFamily, "Потпис купца: _________________________");
                                                            $offsetTop = $offsetTop + $linesize;
                                                        }
                                                        imagettftext($image, $fontsize, 0, 0, $offsetTop, $color, "assets/fonts/" . $fontFamily, $line);
                                                    } else {
                                                        if ($line == $JournalPrintBigger) {
                                                            $offsetTop = $offsetTop + $linesize;
                                                            //imagestring($image, 5, 10, $offsetTop, $line, $color);
                                                            if ($PrinterSize == 80) {
                                                                $NewFontSize = $fontsize * 1.6;
                                                            } else {
                                                                $NewFontSize = $fontsize * 1.35;
                                                            }
                                                            imagettftext($image, $NewFontSize, 0, 0, $offsetTop, $color, "assets/fonts/" . $fontFamily, $PrintNameStart);
                                                        } else {
                                                            $offsetTop = $offsetTop + $linesize;
                                                            //imagestring($image, 5, 10, $offsetTop, $line, $color);
                                                            imagettftext($image, $fontsize, 0, 0, $offsetTop, $color, "assets/fonts/" . $fontFamily, $line);
                                                        }
                                                    }
                                                }
                                                $NewHeight = $height1;
                                                $NewWidth = $width1 / 2;

                                                $imageNew = imagecreate($NewWidth, $NewHeight);
                                                imagecopyresized($imageNew, $image, 0, 0, 0, 0, $NewWidth, $NewHeight, $width1, $height1);
                                                $TempImgName = "tempimg" . time();
                                                imagepng($imageNew, $TempImgName . ".png", 9, PNG_NO_FILTER);

                                                $img = EscposImage::load($TempImgName . ".png"); // Load image
                                                if ($PrinterSize == 80) {
                                                    $printer->setJustification(Printer::JUSTIFY_CENTER);
                                                } else {
                                                    $printer->setJustification(Printer::JUSTIFY_LEFT);
                                                }
                                                //list($width, $height) = getimagesize($TempImgName . ".png");
                                                //error_log($height);

                                                $printer->bitImageColumnFormat($img, Printer::IMG_DOUBLE_WIDTH);
                                                unlink($TempImgName . ".png");

                                                $printer->feed();
                                                if ($PrintFakturaData == 1 && $EntityVAT != '') {
                                                    $PibKupca = mysqli_real_escape_string($link, $EntityVAT);
                                                    $GetKupacData = mysqli_query($link, "SELECT * FROM stalnigost WHERE pib='$PibKupca' ORDER BY id DESC LIMIT 1");
                                                    if (mysqli_num_rows($GetKupacData) == 1) {
                                                        $ResKupacData = mysqli_fetch_array($GetKupacData);
                                                        $printer->setJustification(Printer::JUSTIFY_LEFT);
                                                        $printer->text("Kupac: " . $ResKupacData['skrNaziv'] . "\n");
                                                        $printer->text("PIB: " . $ResKupacData['pib'] . "\n");
                                                        $printer->text("MB: " . $ResKupacData['maticniBroj'] . "\n");
                                                        $printer->text("Mesto: " . $ResKupacData['mesto'] . "\n");
                                                        $printer->text("Adresa: " . $ResKupacData['adersa'] . "\n");
                                                    }
                                                }
                                                $RacunId = 0;
                                                $GetRacunId = mysqli_query($link, "SELECT * FROM racun WHERE brojStola='$brojStola' AND zatvoren=0 ORDER BY id DESC LIMIT 1");
                                                if (mysqli_num_rows($GetRacunId) == 1) {
                                                    $RacunData = mysqli_fetch_array($GetRacunId);
                                                    $RacunId = $RacunData['id'];
                                                    $DostavaAdresaID = $RacunData['DOSTAVAADRESA_ID'];
                                                    $DostavaID = $RacunData['DOSTAVA_ID'];
                                                    if ($DostavaID > 0 && $DostavaAdresaID > 0) {
                                                        $GetDostavaData = mysqli_query($link, "SELECT d.naziv, d.telefon, da.* FROM dostava d, dostava_adresa da WHERE d.id=da.DOSTAVA_ID AND da.id='$DostavaAdresaID'");
                                                        if (mysqli_num_rows($GetDostavaData) == 1) {
                                                            $DostavaData = mysqli_fetch_array($GetDostavaData);
                                                            $printer->pulse(1, 300, 300);
                                                            $printer->setPrintLeftMargin(0);
                                                            $printer->setJustification(Printer::JUSTIFY_LEFT);
                                                            $textToPrint = "============================== \n";
                                                            $textToPrint .= "Podaci o kupcu:\n";
                                                            $textToPrint .= "============================== \n";
                                                            $textToPrint .= $DostavaData['naziv'] . " \n";
                                                            $textToPrint .= "Podaci o kupcu:\n";
                                                            $PrintAdresa = $DostavaData['adresa'];
                                                            if ($DostavaData['broj'] != '') {
                                                                $PrintAdresa .= " " . $DostavaData['broj'];
                                                            }
                                                            if ($DostavaData['mesto'] != '') {
                                                                $PrintAdresa = $DostavaData['mesto'] . " " . $PrintAdresa;
                                                            }
                                                            if ($DostavaData['sprat'] != '') {
                                                                $PrintAdresa .= " " . $DostavaData['sprat'];
                                                            }
                                                            $textToPrint .= $PrintAdresa . "\n";
                                                            if ($DostavaData['interfon'] != '') {
                                                                $textToPrint .= "Interfon: " . $DostavaData['interfon'] . " \n";
                                                            }
                                                            if ($DostavaData['napomena'] != '') {
                                                                $textToPrint .= "Napomena: " . $DostavaData['napomena'] . " \n";
                                                            }
                                                            $textToPrint .= "============================== \n";
                                                            $printer->text($textToPrint);
                                                            $printer->feed();
                                                        }
                                                    }
                                                }
                                                $printer->cut();
                                                $printer->close();
                                            } catch (Exception $e) {
                                                //echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $NazivStampaca . ' ' . $e->getMessage()));
                                                //die();
												$Logout = "";
												$racunZatvorenNemaStampaca = "DA";
                                            }
                                        }
                                    }
                                    if ($InvoiceType != 'Normal') {
                                        if ($InvoiceType == 'Training') {
                                            mysqli_query($link, "UPDATE racun SET zatvoren=1 WHERE brojStola='$brojStola'");
                                        }
                                        echo json_encode(array('Status' => 'success', 'Message' => 'Napravljen racun!!!', 'RacunId' => 0, 'Action' => $Logout));
                                        die();
                                    }
                                }
                            }
                        }
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Uplaćeni iznos je manji od vrednosti računa!!!'));
                        die();
                    }
                } else {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Nisu poslate stavke za naplatu!!! Izdavanje računa nije moguće!!!'));
                    die();
                }
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Kasa nije podešena za rad sa LPFR!!! Izdavanje računa nije moguće!!!'));
                die();
            }
        } else {
            die();
        }
    }
    if ($TipRacuna == 'RastavljanjeStola') {
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Rastavljanje stola Sto->" . $brojStola . " Korisnik->" . $UserName;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
        $ArtikliKolicine = [];
        $KojiArtikliSePrebacuju = '';
        foreach ($_POST['UbaceniArtikli'] as $UbaceniArtikal) {
            $ArtikliKolicine[$UbaceniArtikal[0]] = $UbaceniArtikal[1];
            if ($KojiArtikliSePrebacuju == '') {
                $KojiArtikliSePrebacuju = mysqli_real_escape_string($link, $UbaceniArtikal[0]);
            } else {
                $KojiArtikliSePrebacuju .= ', ' . mysqli_real_escape_string($link, $UbaceniArtikal[0]);
            }
        }
        $GetArtikle = mysqli_query($link, "SELECT * FROM stavkaracuna WHERE id IN ( $KojiArtikliSePrebacuju )");
        if (mysqli_num_rows($GetArtikle) > 0) {
            $BrojTureGet = mysqli_query($link, "SELECT MAX(brojTure) as brojTure FROM tura WHERE datum >= (SELECT MAX(zakljucenje) as datum FROM zd WHERE pocetak=1)");
            if (mysqli_num_rows($BrojTureGet) > 0) {
                $BrojTure = mysqli_fetch_array($BrojTureGet)['brojTure'] + 1;
            } else {
                $BrojTure = 1;
            }
            $OldSto = $brojStola;
            $brojStola = 0;
            $GetBrojRacuna = mysqli_query($link, "SELECT MAX(brojRacuna) as broj FROM racun") or die(mysqli_error($link));
            if (mysqli_num_rows($GetBrojRacuna) > 0) {
                $ResBrojRacuna = mysqli_fetch_array($GetBrojRacuna);
                $brojRacuna = $ResBrojRacuna['broj'] + 1;
            } else {
                $brojRacuna = 1;
            }
            $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY id DESC LIMIT 1");
            if (mysqli_num_rows($GetZd) == 1) {
                $Zd = mysqli_fetch_array($GetZd)['zdBroj'];
            }
            $datumRacuna = date('Y-m-d H:i:s');
            $kasaId = $KasaId;
            mysqli_query($link, "INSERT INTO racun(brojRacuna, brojStola, datum, fiskalniOdstampan, storniran, zatvoren, KASA_ID, KONOBAR_ID, popust, zdBroj, naOsnovno)
                VALUES('$brojRacuna', '$brojStola', '$datumRacuna', 0, 0, 0, '$kasaId', '$idKorisnika', '0', '$Zd', '1')") or die(mysqli_error($link) . "na upisu racuna");
            $RacunId = mysqli_insert_id($link);
            $VremePorudzbine = date('Y-m-d H:i:s');
            mysqli_query($link, "INSERT INTO tura (brojStola, brojTure, datum, pripremljena, uPripremi, pocetak, REZERVACIJA_ID, napomena, RACUN_ID) 
                VALUES ('$brojStola', '$BrojTure', '$VremePorudzbine', 0, 0, now(), 0, 'RASTAVLJANJE', '$RacunId')") or die(mysqli_error($link));
            $IdTure = mysqli_insert_id($link);
            while ($rowGetArtikle = mysqli_fetch_array($GetArtikle)) {
                $CenaArtikla = $rowGetArtikle['cena'];
                $NazivArtikla = $rowGetArtikle['naziv'];
                $IdArtikla = $rowGetArtikle['ARTIKAL_ID'];
                $OpisArtikla = $rowGetArtikle['opis'];
                $IdStavkeRacuna = $rowGetArtikle['id'];
                $KolicinaArtikla = $ArtikliKolicine[$IdStavkeRacuna];
                if ($rowGetArtikle['kolicina'] > $KolicinaArtikla) {
                    $NovaKolicina = $rowGetArtikle['kolicina'] - $KolicinaArtikla;
                    mysqli_query($link, "UPDATE stavkaracuna SET kolicina='$NovaKolicina' WHERE id='$IdStavkeRacuna'");
                } else {
                    mysqli_query($link, "DELETE FROM stavkaracuna WHERE id='$IdStavkeRacuna'");
                }
                mysqli_query($link, "INSERT INTO stavkaracuna (brojStola, cena, kolicina, naziv, ARTIKAL_ID, TURA_ID, opis, RACUN_ID, gostbroj) "
                    . "VALUES('$brojStola', '$CenaArtikla', '$KolicinaArtikla', '$NazivArtikla', '$IdArtikla', '$IdTure', '$OpisArtikla', '$RacunId', '1')") or die(mysqli_error($link));
            }
        }
    } elseif ($TipRacuna == 'BrzaNaplata') {
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Brza naplata Korisnik->" . $UserName;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
        $BrojTureGet = mysqli_query($link, "SELECT MAX(brojTure) as brojTure FROM tura WHERE datum >= (SELECT MAX(zakljucenje) as datum FROM zd WHERE pocetak=1)");
        if (mysqli_num_rows($BrojTureGet) > 0) {
            $BrojTure = mysqli_fetch_array($BrojTureGet)['brojTure'] + 1;
        } else {
            $BrojTure = 1;
        }
        $brojStola = 0;
        $GetBrojRacuna = mysqli_query($link, "SELECT MAX(brojRacuna) as broj FROM racun") or die(mysqli_error($link));
        if (mysqli_num_rows($GetBrojRacuna) > 0) {
            $ResBrojRacuna = mysqli_fetch_array($GetBrojRacuna);
            $brojRacuna = $ResBrojRacuna['broj'] + 1;
        } else {
            $brojRacuna = 1;
        }
        $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetZd) == 1) {
            $Zd = mysqli_fetch_array($GetZd)['zdBroj'];
        }
        $datumRacuna = date('Y-m-d H:i:s');
        $kasaId = $KasaId;
        mysqli_query($link, "INSERT INTO racun(brojRacuna, brojStola, datum, fiskalniOdstampan, storniran, zatvoren, KASA_ID, KONOBAR_ID, popust, zdBroj, naOsnovno)
                VALUES('$brojRacuna', '$brojStola', '$datumRacuna', 0, 0, 0, '$kasaId', '$idKorisnika', '0', '$Zd', '1')") or die(mysqli_error($link) . "na upisu racuna");
        $RacunId = mysqli_insert_id($link);
        $VremePorudzbine = date('Y-m-d H:i:s');
        mysqli_query($link, "INSERT INTO tura (brojStola, brojTure, datum, pripremljena, uPripremi, pocetak, REZERVACIJA_ID, napomena, RACUN_ID) 
                VALUES ('$brojStola', '$BrojTure', '$VremePorudzbine', 0, 0, now(), 0, 'RASTAVLJANJE', '$RacunId')") or die(mysqli_error($link));
        $IdTure = mysqli_insert_id($link);
        $PrintOrder = 1;
        $Stampaci = [];
        $GetStampace = mysqli_query($link, "SELECT * FROM artikal_stampac WHERE 1");
        if (mysqli_num_rows($GetStampace) > 0) {
            while ($rowStampaci = mysqli_fetch_array($GetStampace)) {
                $Stampaci[$rowStampaci['ARTIKLI_ID']][$rowStampaci['STAMPAC_ID']] = $rowStampaci['STAMPAC_ID'];
            }
        } else {
            $PrintOrder = 0;
        }
        $Inc = 0;
        $ArrayStampaca = [];
        $StampacData = [];
        $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE 1");
        if (mysqli_num_rows($GetStampacData) > 0) {
            while ($rowStampacData = mysqli_fetch_array($GetStampacData)) {
                $StampacData[$rowStampacData['id']] = $rowStampacData;
            }
        } else {
            $PrintOrder = 0;
        }
        $GetProdajnoMesto = mysqli_query($link, "SELECT naziv FROM prodajnomesto ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetProdajnoMesto) == 1) {
            $ProdajnoMesto = mysqli_fetch_array($GetProdajnoMesto)['naziv'];
        } else {
            $PrintOrder = 0;
        }
        foreach ($_POST['UbaceniArtikli'] as $UbaceniArtikal) {
            $IdArtikla = mysqli_real_escape_string($link, $UbaceniArtikal[3]);
            $CenaArtikla = mysqli_real_escape_string($link, $UbaceniArtikal[2]);
            $NazivArtikla = mysqli_real_escape_string($link, $UbaceniArtikal[4]);
            $KolicinaArtikla = mysqli_real_escape_string($link, $UbaceniArtikal[1]);
            $TipArtikla = mysqli_real_escape_string($link, $UbaceniArtikal[5]);
            $OpisArtikla = $UbaceniArtikal[6];
            $OpisArtiklaInsert = str_replace('&nbsp;', ' ', $OpisArtikla);
            $OpisArtiklaInsert = str_replace('</div>', ' ', $OpisArtiklaInsert);
            $OpisArtiklaInsert = strip_tags($OpisArtiklaInsert);
            $OpisArtiklaInsert = mysqli_real_escape_string($link, strip_tags($OpisArtiklaInsert));
            mysqli_query($link, "INSERT INTO stavkaracuna (brojStola, cena, kolicina, naziv, ARTIKAL_ID, TURA_ID, RACUN_ID, gostbroj, opis) "
                . "VALUES('$brojStola', '$CenaArtikla', '$KolicinaArtikla', '$NazivArtikla', '$IdArtikla', '$IdTure', '$RacunId', '1', '$OpisArtiklaInsert')") or die(mysqli_error($link));
            $StampacArtikla = $Stampaci[$IdArtikla];
            if (is_array($StampacArtikla)) {
                foreach ($StampacArtikla as $StampacArtikla) {
                    $Tura = array_search($StampacArtikla, array_column($ArrayStampaca, 'StampacID'));
                    if (is_numeric($Tura)) {
                        array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $NazivArtikla, 'Kolicina' => $KolicinaArtikla, 'Tip' => $TipArtikla));
                        if ($OpisArtikla != '') {
                            $OpisArtiklaPrint = preg_replace('/(<[^>]+) style=".*?"/i', '$1', $UbaceniArtikal[6]);
                            $OpisArtiklaPrint = strip_tags($OpisArtiklaPrint, '<div>');
                            $OpisArtiklaPrint = str_replace('&nbsp;', '', $OpisArtiklaPrint);
                            $OpisArtiklaPrint = str_replace('</div>', '', $OpisArtiklaPrint);
                            $arrayOpis = preg_split("<div>", $OpisArtiklaPrint);
                            foreach ($arrayOpis as $Opis) {
                                $Opis = str_replace('<', '', $Opis);
                                $Opis = str_replace('>', '', $Opis);
                                array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $Opis, 'Kolicina' => $KolicinaArtikla, 'Tip' => 'OPISARTIKLA'));
                            }
                        }
                    } else {
                        array_push($ArrayStampaca, array('StampacID' => $StampacArtikla, 'artikli' => array(array('Naziv' => $NazivArtikla, 'Kolicina' => $KolicinaArtikla, 'Tip' => $TipArtikla))));
                        if ($OpisArtikla != '') {
                            $Tura = array_search($StampacArtikla, array_column($ArrayStampaca, 'StampacID'));
                            if (is_numeric($Tura)) {
                                $OpisArtiklaPrint = preg_replace('/(<[^>]+) style=".*?"/i', '$1', $UbaceniArtikal[6]);
                                $OpisArtiklaPrint = strip_tags($OpisArtiklaPrint, '<div>');
                                $OpisArtiklaPrint = str_replace('&nbsp;', '', $OpisArtiklaPrint);
                                $OpisArtiklaPrint = str_replace('</div>', '', $OpisArtiklaPrint);
                                $arrayOpis = preg_split("<div>", $OpisArtiklaPrint);
                                foreach ($arrayOpis as $Opis) {
                                    $Opis = str_replace('<', '', $Opis);
                                    $Opis = str_replace('>', '', $Opis);
                                    array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $Opis, 'Kolicina' => $KolicinaArtikla, 'Tip' => 'OPISARTIKLA'));
                                }
                            }
                        }
                    }
                }
            } else {
                $Tura = array_search($StampacArtikla, array_column($ArrayStampaca, 'StampacID'));
                if (is_numeric($Tura)) {
                    array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $NazivArtikla, 'Kolicina' => $KolicinaArtikla, 'Tip' => $TipArtikla));
                    if ($OpisArtikla != '') {
                        $OpisArtiklaPrint = preg_replace('/(<[^>]+) style=".*?"/i', '$1', $UbaceniArtikal[6]);
                        $OpisArtiklaPrint = strip_tags($OpisArtiklaPrint, '<div>');
                        $OpisArtiklaPrint = str_replace('&nbsp;', '', $OpisArtiklaPrint);
                        $OpisArtiklaPrint = str_replace('</div>', '', $OpisArtiklaPrint);
                        $arrayOpis = preg_split("<div>", $OpisArtiklaPrint);
                        foreach ($arrayOpis as $Opis) {
                            $Opis = str_replace('<', '', $Opis);
                            $Opis = str_replace('>', '', $Opis);
                            array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $Opis, 'Kolicina' => $KolicinaArtikla, 'Tip' => 'OPISARTIKLA'));
                        }
                    }
                } else {
                    array_push($ArrayStampaca, array('StampacID' => $StampacArtikla, 'artikli' => array(array('Naziv' => $NazivArtikla, 'Kolicina' => $KolicinaArtikla, 'Tip' => $TipArtikla))));
                    if ($OpisArtikla != '') {
                        $Tura = array_search($StampacArtikla, array_column($ArrayStampaca, 'StampacID'));
                        if (is_numeric($Tura)) {
                            $OpisArtiklaPrint = preg_replace('/(<[^>]+) style=".*?"/i', '$1', $UbaceniArtikal[6]);
                            $OpisArtiklaPrint = strip_tags($OpisArtiklaPrint, '<div>');
                            $OpisArtiklaPrint = str_replace('&nbsp;', '', $OpisArtiklaPrint);
                            $OpisArtiklaPrint = str_replace('</div>', '', $OpisArtiklaPrint);
                            $arrayOpis = preg_split("<div>", $OpisArtiklaPrint);
                            foreach ($arrayOpis as $Opis) {
                                $Opis = str_replace('<', '', $Opis);
                                $Opis = str_replace('>', '', $Opis);
                                array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $Opis, 'Kolicina' => $KolicinaArtikla, 'Tip' => 'OPISARTIKLA'));
                            }
                        }
                    }
                }
            }
        }
        foreach ($ArrayStampaca as $Stampac) {
            $StampacId = $Stampac['StampacID'];
            $BrojKopija = $StampacData[$StampacId]['brojKopijaPorudzbine'];
            $OdeljenjeNaziv = $StampacData[$StampacId]['bnaziv'];
            $NazivStampaca = $StampacData[$StampacId]['naziv'];
            if ($StampacData[$StampacId]['tip'] == 'POSBANK80MM') {
                $PrinterLetters = 40;
            } else {
                $PrinterLetters = 30;
            }
            for ($x = 0; $x < $BrojKopija; $x++) {
                $PrintString = "";

                $PreText = "Datum:" . date('d.m.Y.') . " Vreme:" . date('H:i:s');
                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                $PreText = "Prodajno mesto: " . $ProdajnoMesto;
                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                $PreText = "Kasa: " . $Kasa['oznaka'];
                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                $PreText = $OdeljenjeNaziv;
                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                $PrintString .= str_pad(" ", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                foreach ($Stampac['artikli'] as $ArtikalStampaca) {
                    if ($ArtikalStampaca['Tip'] == 'DODA') {
                        $Left = $PrinterLetters - 9;
                        $PreText = str_pad("     " . $ArtikalStampaca['Kolicina'] . "X ", 9, " ", STR_PAD_RIGHT) . "" . mb_substr($ArtikalStampaca['Naziv'], 0, $Left, 'UTF-8');
                        $PrintString .= $PreText . "\n";
                    } elseif ($ArtikalStampaca['Tip'] == 'OPISARTIKLA') {
                        $TextPrint = " ** " . $ArtikalStampaca['Naziv'];
                        if (strlen($TextPrint) < $PrinterLetters) {
                            $PreText = str_pad($TextPrint, $PrinterLetters, " ", STR_PAD_RIGHT);
                        } else {
                            $PreText = $TextPrint;
                        }
                        $PrintString .= $PreText . "\n";
                    } else {
                        $Left = $PrinterLetters - 9;
                        $PreText = str_pad($ArtikalStampaca['Kolicina'] . "X ", 9, " ", STR_PAD_RIGHT) . "" . mb_substr($ArtikalStampaca['Naziv'], 0, $Left, 'UTF-8');
                        $PrintString .= $PreText . "\n";
                    }
                }
                $PrintString .= str_pad(" ", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                if ($RacunTuraOpis != '') {
                    $OpisTurePrint = preg_replace('/(<[^>]+) style=".*?"/i', '$1', $RacunTuraOpis);
                    $OpisTurePrint = strip_tags($OpisTurePrint, '<div>');
                    $OpisTurePrint = str_replace('&nbsp;', ' ', $OpisTurePrint);
                    $OpisTurePrint = str_replace('</div>', '', $OpisTurePrint);
                    //error_log($OpisTurePrint);
                    $arrayOpisTure = preg_split('<div>', $OpisTurePrint);
                    $PrintString .= str_pad("*", $PrinterLetters, "*", STR_PAD_BOTH) . "\n";

                    $PrintString .= str_pad(mb_substr("Opis:", 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                    foreach ($arrayOpisTure as $OpisTure) {
                        $OpisTure = str_replace('<', '', $OpisTure);
                        $OpisTure = str_replace('>', '', $OpisTure);
                        if (strlen($OpisTure) < $PrinterLetters) {
                            $PreText = str_pad($OpisTure, $PrinterLetters, " ", STR_PAD_RIGHT);
                        } else {
                            $PreText = $OpisTure;
                        }
                        $PrintString .= str_pad($PreText, $PrinterLetters, " ", STR_PAD_RIGHT) . "\n";
                    }
                    $PrintString .= str_pad("*", $PrinterLetters, "*", STR_PAD_BOTH) . "\n";
                }
                $PreText = "Konobar: " . $_COOKIE['UserName'];
                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                try {
                    // Enter the share name for your USB printer here
                    if (strpos($NazivStampaca, "/")) {
                        $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                    } else {
                        $connector = new WindowsPrintConnector($NazivStampaca);
                    }

                    $printer = new Printer($connector);
                    $printer->pulse(1, 300, 300);
                    $printer->setPrintLeftMargin(0);
                    $printer->setJustification(Printer::JUSTIFY_LEFT);
                    $printer->text($PrintString);
                    $printer->feed();
                    $printer->cut();
                    $printer->close();
                } catch (Exception $e) {
                    //echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                    //die();
                }
            }
        }
    } else {
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Izrada racuna Sto->" . $brojStola . " Korisnik->" . $UserName;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");

        $RacunId = 0;
        $GetRacunId = mysqli_query($link, "SELECT * FROM racun WHERE brojStola='$brojStola' AND zatvoren=0 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetRacunId) == 1) {
            $RacunData = mysqli_fetch_array($GetRacunId);
            $RacunId = $RacunData['id'];
            $DostavaAdresaID = $RacunData['DOSTAVAADRESA_ID'];
            $DostavaID = $RacunData['DOSTAVA_ID'];
        }
    }

    if ($IznosPlacanja >= $TotalRacun) {
        $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetZd) == 1) {
            $Zd = mysqli_fetch_array($GetZd)['zdBroj'];
        }
        $datumRacuna = date('Y-m-d H:i:s');
        if ($StalniGostId > 0) {
            if ($RacunKomitent > 0) {
                if ($PosluzenihGostiju > 0) {
                    mysqli_query($link, "UPDATE racun SET datum='$datumRacuna', zatvoren=1, KONOBAR_ID='$idKorisnika', popust='$TotalPopust', 
                        STALNIGOST_ID='$RacunKomitent', brojGostiju='$PosluzenihGostiju', zdBroj='$Zd' WHERE id='$RacunId'") or die(mysqli_error($link) . "na upisu racuna");
                } else {
                    mysqli_query($link, "UPDATE racun SET datum='$datumRacuna', zatvoren=1, KONOBAR_ID='$idKorisnika', popust='$TotalPopust', 
                        STALNIGOST_ID='$RacunKomitent', zdBroj='$Zd' WHERE id='$RacunId'") or die(mysqli_error($link) . "na upisu racuna");
                }
            } else {
                if ($PosluzenihGostiju > 0) {
                    mysqli_query($link, "UPDATE racun SET datum='$datumRacuna', zatvoren=1, KONOBAR_ID='$idKorisnika', popust='$TotalPopust', 
                        STALNIGOST_ID='$StalniGostId', brojGostiju='$PosluzenihGostiju', zdBroj='$Zd' WHERE id='$RacunId'") or die(mysqli_error($link) . "na upisu racuna");
                } else {
                    mysqli_query($link, "UPDATE racun SET datum='$datumRacuna', zatvoren=1, KONOBAR_ID='$idKorisnika', popust='$TotalPopust', 
                        STALNIGOST_ID='$StalniGostId', zdBroj='$Zd' WHERE id='$RacunId'") or die(mysqli_error($link) . "na upisu racuna");
                }
            }
        } else {
            if ($RacunKomitent > 0) {
                if ($PosluzenihGostiju > 0) {
                    mysqli_query($link, "UPDATE racun SET datum='$datumRacuna', zatvoren=1, KONOBAR_ID='$idKorisnika', popust='$TotalPopust', 
                        brojGostiju='$PosluzenihGostiju', STALNIGOST_ID='$RacunKomitent', zdBroj='$Zd' WHERE id='$RacunId'") or die(mysqli_error($link) . "na upisu racuna");
                } else {
                    mysqli_query($link, "UPDATE racun SET datum='$datumRacuna', zatvoren=1, KONOBAR_ID='$idKorisnika', popust='$TotalPopust', 
                        STALNIGOST_ID='$RacunKomitent', zdBroj='$Zd' WHERE id='$RacunId'") or die(mysqli_error($link) . "na upisu racuna");
                }
            } else {
                if ($PosluzenihGostiju > 0) {
                    mysqli_query($link, "UPDATE racun SET datum='$datumRacuna', zatvoren=1, KONOBAR_ID='$idKorisnika', popust='$TotalPopust', 
                        brojGostiju='$PosluzenihGostiju', zdBroj='$Zd' WHERE id='$RacunId'") or die(mysqli_error($link) . "na upisu racuna");
                } else {
                    mysqli_query($link, "UPDATE racun SET datum='$datumRacuna', zatvoren=1, KONOBAR_ID='$idKorisnika', popust='$TotalPopust', 
                        zdBroj='$Zd' WHERE id='$RacunId'") or die(mysqli_error($link) . "na upisu racuna");
                }
            }
        }
        $MeniPrometId = 0;
        if ($MeniId > 0 && $MeniKolicina > 0) {
            mysqli_query($link, "INSERT INTO menipromet (cena, datum, kolicina, naziv, RACUN_ID, MENI_ID) VALUES ('$MeniCena', now(), '$MeniKolicina', '$MeniNaziv', '$RacunId', '$MeniId')");
            $MeniPrometId = mysqli_insert_id($link);
            mysqli_query($link, "UPDATE racun SET menipromet='$MeniPrometId' WHERE id='$RacunId'");
        }
        if ($InvoiceType == "") {
            if (count($Placanja) == 1) {
                foreach ($Placanja as $NacinPlacanja => $IznosPlacanja) {
                    if ($NacinPlacanja == 'GOTOVINA' || $NacinPlacanja == 'KARTICA' || $NacinPlacanja == 'CEK' || $NacinPlacanja == 'FAKTURA') {
                        mysqli_query($link, "UPDATE racun SET crnoPlacanje=NULL WHERE id='$RacunId'");
                        mysqli_query($link, "INSERT INTO placanje(iznos, nacin, vreme, RACUN_ID) "
                            . "VALUES('$TotalRacun', '$NacinPlacanja', '$datumRacuna', '$RacunId')");
                        $doc = new DOMDocument('1.0', 'UTF-8');
                        $doc->preserveWhiteSpace = false;
                        $doc->formatOutput = true;
                        $ele = $doc->createElement('FiscalRecipet');
                        $NazivRacuna = 'Racun_' . date('Ymd_His');
                        if ($MeniPrometId == 0) {
                            $GetArtikleZaRacun = mysqli_query($link, "SELECT a.dozvoljenPopust, a.poreskaGrupa, SUM(sr.kolicina) as kolicina, sr.cena, sr.naziv, sr.ARTIKAL_ID FROM stavkaracuna sr, artikal a WHERE sr.brojStola='$brojStola' AND sr.RACUN_ID='$RacunId' AND a.id=sr.ARTIKAL_ID GROUP BY sr.ARTIKAL_ID, sr.cena ORDER BY sr.id ASC") or die(mysqli_error($link . "na stavci racuna"));
                            if (mysqli_num_rows($GetArtikleZaRacun) > 0) {
                                while ($rowArtikli = mysqli_fetch_array($GetArtikleZaRacun)) {
                                    $NazivArtiklaRacuna = $rowArtikli['naziv'];
                                    $CenaArtiklaRacuna = $rowArtikli['cena'];
                                    if ($rowArtikli['dozvoljenPopust'] == 1) {
                                        if ($TotalPopust > 0) {
                                            $Popust = $CenaArtiklaRacuna * (0 + $TotalPopust / 100);
                                        } else {
                                            $Popust = 0;
                                        }
                                    } else {
                                        $Popust = 0;
                                    }

                                    $CenaArtiklaRacuna = $CenaArtiklaRacuna - $Popust;
                                    $CenaArtiklaRacuna = number_format($CenaArtiklaRacuna, 2, '.', '');
                                    $KolicinaArtiklaRacuna = number_format($rowArtikli['kolicina'], 3, '.', '');
                                    $poreskaGrupa = $rowArtikli['poreskaGrupa'];
                                    switch ($poreskaGrupa) {
                                        case "0":
                                            $OznakaPorez = "GRUPA_A";
                                            break;
                                        case "1":
                                            $OznakaPorez = "GRUPA_G";
                                            break;
                                        case "2":
                                            $OznakaPorez = "GRUPA_D";
                                            break;
                                        case "3":
                                            $OznakaPorez = "GRUPA_DJ";
                                            break;
                                        case "4":
                                            $OznakaPorez = "GRUPA_E";
                                            break;
                                        case "5":
                                            $OznakaPorez = "GRUPA_ZJ";
                                            break;
                                        case "6":
                                            $OznakaPorez = "GRUPA_I";
                                            break;
                                        case "7":
                                            $OznakaPorez = "GRUPA_J";
                                            break;
                                        case "8":
                                            $OznakaPorez = "GRUPA_K";
                                            break;
                                    }
                                    $ele2 = $doc->createElement('FiscalItem');
                                    $ele3 = $doc->createElement('Naziv');
                                    $ele3->nodeValue = $NazivArtiklaRacuna;
                                    $ele2->appendChild($ele3);
                                    $ele4 = $doc->createElement('Cena');
                                    $ele4->nodeValue = $CenaArtiklaRacuna;
                                    $ele2->appendChild($ele4);
                                    $ele5 = $doc->createElement('Kolicina');
                                    $ele5->nodeValue = $KolicinaArtiklaRacuna;
                                    $ele2->appendChild($ele5);
                                    $ele6 = $doc->createElement('PoreskaGrupa');
                                    $ele6->nodeValue = $OznakaPorez;
                                    $ele2->appendChild($ele6);
                                    $ele->appendChild($ele2);
                                }
                            } else {
                                echo json_encode(array('Status' => 'error', 'Message' => 'Nema artikala za naplatu!!!'));
                                die();
                            }
                        } else {
                            $NazivArtiklaRacuna = $MeniNaziv;
                            $CenaArtiklaRacuna = $MeniCena;
                            if ($TotalPopust > 0) {
                                $Popust = $CenaArtiklaRacuna * (0 + $TotalPopust / 100);
                            } else {
                                $Popust = 0;
                            }
                            $CenaArtiklaRacuna = $CenaArtiklaRacuna - $Popust;
                            $CenaArtiklaRacuna = number_format($CenaArtiklaRacuna, 2, '.', '');
                            $KolicinaArtiklaRacuna = number_format($MeniKolicina, 3, '.', '');
                            $poreskaGrupa = GetSettingVal('meni.redni.broj.pg');
                            switch ($poreskaGrupa) {
                                case "0":
                                    $OznakaPorez = "GRUPA_A";
                                    break;
                                case "1":
                                    $OznakaPorez = "GRUPA_G";
                                    break;
                                case "2":
                                    $OznakaPorez = "GRUPA_D";
                                    break;
                                case "3":
                                    $OznakaPorez = "GRUPA_DJ";
                                    break;
                                case "4":
                                    $OznakaPorez = "GRUPA_E";
                                    break;
                                case "5":
                                    $OznakaPorez = "GRUPA_ZJ";
                                    break;
                                case "6":
                                    $OznakaPorez = "GRUPA_I";
                                    break;
                                case "7":
                                    $OznakaPorez = "GRUPA_J";
                                    break;
                                case "8":
                                    $OznakaPorez = "GRUPA_K";
                                    break;
                            }
                            $ele2 = $doc->createElement('FiscalItem');
                            $ele3 = $doc->createElement('Naziv');
                            $ele3->nodeValue = $NazivArtiklaRacuna;
                            $ele2->appendChild($ele3);
                            $ele4 = $doc->createElement('Cena');
                            $ele4->nodeValue = $CenaArtiklaRacuna;
                            $ele2->appendChild($ele4);
                            $ele5 = $doc->createElement('Kolicina');
                            $ele5->nodeValue = $KolicinaArtiklaRacuna;
                            $ele2->appendChild($ele5);
                            $ele6 = $doc->createElement('PoreskaGrupa');
                            $ele6->nodeValue = $OznakaPorez;
                            $ele2->appendChild($ele6);
                            $ele->appendChild($ele2);
                        }
                        $ele7 = $doc->createElement('Placanje');
                        $ele8 = $doc->createElement('Kartica');
                        if ($NacinPlacanja == 'KARTICA') {
                            $ele8->nodeValue = $IznosPlacanja;
                        } else {
                            $ele8->nodeValue = '0.0';
                        }
                        $ele7->appendChild($ele8);
                        $ele9 = $doc->createElement('Gotovina');
                        if ($NacinPlacanja == 'GOTOVINA') {
                            $ele9->nodeValue = $IznosPlacanja;
                        } else {
                            $ele9->nodeValue = '0.0';
                        }
                        $ele7->appendChild($ele9);
                        $ele10 = $doc->createElement('Cek');
                        if ($NacinPlacanja == 'CEK' || $NacinPlacanja == 'FAKTURA') {
                            $ele10->nodeValue = $IznosPlacanja;
                        } else {
                            $ele10->nodeValue = '0.0';
                        }
                        $ele7->appendChild($ele10);
                        $ele->appendChild($ele7);
                        $ele11 = $doc->createElement('Konobar');
                        $ele11->nodeValue = $korisnikPrograma;
                        $ele->appendChild($ele11);

                        $doc->appendChild($ele);
                        $doc->save($SaveToReceipt . '/' . $NazivRacuna . '.xml');

                        /* ovde kao gotovinski!!! */
                        //sleep(2);
                        if ($DostavaID > 0 && $DostavaAdresaID > 0) {
                            $GetDostavaData = mysqli_query($link, "SELECT d.naziv, d.telefon, da.* FROM dostava d, dostava_adresa da WHERE d.id=da.DOSTAVA_ID AND da.id='$DostavaAdresaID'");
                            if (mysqli_num_rows($GetDostavaData) == 1) {
                                $DostavaData = mysqli_fetch_array($GetDostavaData);
                                $doc2 = new DOMDocument('1.0', 'UTF-8');
                                $doc2->preserveWhiteSpace = false;
                                $doc2->formatOutput = true;
                                $ele2 = $doc2->createElement('NefiskalnaStampa');
                                $eleH2 = $doc2->createElement('Linija');
                                $eleH2->nodeValue = FormatTextLeft('==============================');
                                $ele2->appendChild($eleH2);
                                $eleH2 = $doc2->createElement('Linija');
                                $eleH2->nodeValue = FormatText('Podaci o kupcu:');
                                $ele2->appendChild($eleH2);
                                $eleH2 = $doc2->createElement('Linija');
                                $eleH2->nodeValue = FormatTextLeft('==============================');
                                $ele2->appendChild($eleH2);

                                $eleH2 = $doc2->createElement('Linija');
                                $eleH2->nodeValue = $DostavaData['naziv'];
                                $ele2->appendChild($eleH2);
                                $eleH2 = $doc2->createElement('Linija');
                                $eleH2->nodeValue = $DostavaData['telefon'];
                                $ele2->appendChild($eleH2);
                                $PrintAdresa = $DostavaData['adresa'];
                                if ($DostavaData['broj'] != '') {
                                    $PrintAdresa .= " " . $DostavaData['broj'];
                                }
                                if ($DostavaData['mesto'] != '') {
                                    $PrintAdresa = $DostavaData['mesto'] . " " . $PrintAdresa;
                                }
                                if ($DostavaData['sprat'] != '') {
                                    $PrintAdresa .= " " . $DostavaData['sprat'];
                                }

                                $eleH2 = $doc2->createElement('Linija');
                                $eleH2->nodeValue = $PrintAdresa;
                                $ele2->appendChild($eleH2);

                                if ($DostavaData['interfon'] != '') {
                                    $eleH2 = $doc2->createElement('Linija');
                                    $eleH2->nodeValue = 'Interfon: ' . $DostavaData['interfon'];
                                    $ele2->appendChild($eleH2);
                                }
                                if ($DostavaData['napomena'] != '') {
                                    $eleH2 = $doc2->createElement('Linija');
                                    $eleH2->nodeValue = 'NAPOMENA: ' . $DostavaData['napomena'];
                                    $ele2->appendChild($eleH2);
                                }

                                $eleH2 = $doc2->createElement('Linija');
                                $eleH2->nodeValue = FormatTextLeft('==============================');
                                $ele2->appendChild($eleH2);
                                $doc2->appendChild($ele2);
                                $doc2->save($SaveToReceipt . '/Dostava' . $NazivRacuna . '.xml');
                            }
                        }
                    } else {
						if ($NacinPlacanja == 'DRUGO' || $NacinPlacanja == 'VAUCER' || $NacinPlacanja == 'INSTANT') {
							mysqli_query($link, "UPDATE racun SET crnoplacanje='$NacinPlacanja' WHERE id='$RacunId'");
						}
                        $GetCrnoData = mysqli_query($link, "SELECT * FROM crnoplacanje WHERE naziv='$NacinPlacanja'");
                        if (mysqli_num_rows($GetCrnoData) == 1) {
                            $CrnoData = mysqli_fetch_array($GetCrnoData);
                            if ($CrnoData['medjuZbir'] == 1) {
                                mysqli_query($link, "UPDATE racun SET zatvoren=0 WHERE id='$RacunId'");
                            }
                            $PrintString = "";
                            $StampacId = $CrnoData['STAMPAC_ID'];
                            $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE id='$StampacId'");
                            if (mysqli_num_rows($GetStampacData) == 1) {
                                $GeneralijeStampaca = mysqli_fetch_array($GetStampacData);
                            } else {
                                echo json_encode(array('Status' => 'error', 'Message' => 'Nema podesenog stampaca za traženi način naplate!!!'));
                                die();
                            }
                            if ($GeneralijeStampaca['tip'] == 'POSBANK80MM') {
                                $PrinterLetters = 40;
                            } else {
                                $PrinterLetters = 30;
                            }
                            $OdeljenjeNaziv = $GeneralijeStampaca['bnaziv'];
                            $NazivStampaca = $GeneralijeStampaca['naziv'];
                            $NaplataNaziv = str_replace(' ', '', $NacinPlacanja);
                            $NaplataNaziv = str_replace('-', '', $NaplataNaziv);
                            $NaplataNaziv = str_replace('/', '', $NaplataNaziv);
                            $NaplataNaziv = "Naplata" . $NaplataNaziv;
                            if ($CrnoData['rekapitulacijaPoreza'] != 1) {
                                $PreText = FormatTextHalfLeft(date('d.m.Y.', strtotime($datumRacuna))) . '' . FormatTextHalfRight(date('H:i:s', strtotime($datumRacuna)));
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                            }
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                            $PreText = $CrnoData['header1'];
                            $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                            $PreText = FormatText("STO: " . $brojStola);
                            $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                            $PrintString .= str_pad("-", $PrinterLetters, "-", STR_PAD_BOTH) . "\n";
                            $FourthLetters = $PrinterLetters / 4;
                            $FourthLetters = floor($FourthLetters);
                            $HalfLetters = $PrinterLetters - ($FourthLetters * 2);
                            if ($CrnoData['rekapitulacijaPoreza'] != 1) {

                                $PreText = str_pad(mb_substr("Artikal", 0, $HalfLetters, 'UTF-8'), $HalfLetters, " ", STR_PAD_RIGHT) . '' . str_pad(mb_substr('Kol', 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . '' . str_pad(mb_substr('Ukupno', 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT);
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                                $PrintString .= str_pad("-", $PrinterLetters, "-", STR_PAD_BOTH) . "\n";
                            }
                            if ($MeniPrometId == 0) {
                                $GetArtikleZaRacun = mysqli_query($link, "SELECT a.dozvoljenPopust, a.poreskaGrupa, SUM(sr.kolicina) as kolicina, sr.cena, sr.naziv, sr.ARTIKAL_ID FROM stavkaracuna sr, artikal a WHERE sr.brojStola='$brojStola' AND sr.RACUN_ID='$RacunId' AND a.id=sr.ARTIKAL_ID GROUP BY sr.ARTIKAL_ID, sr.cena ORDER BY sr.id ASC") or die(mysqli_error($link));
                                while ($rowArtikli = mysqli_fetch_array($GetArtikleZaRacun)) {
                                    $poreskaGrupa = $rowArtikli['poreskaGrupa'];
                                    $NazivArtiklaRacuna = $rowArtikli['naziv'];
                                    $CenaArtiklaRacuna = $rowArtikli['cena'];
                                    $CenaArtiklaRacuna = $rowArtikli['cena'];
                                    if ($rowArtikli['dozvoljenPopust'] == 1) {
                                        if ($TotalPopust > 0) {
                                            $Popust = $CenaArtiklaRacuna * (0 + $TotalPopust / 100);
                                        } else {
                                            $Popust = 0;
                                        }
                                    } else {
                                        $Popust = 0;
                                    }
                                    $CenaArtiklaRacuna = $CenaArtiklaRacuna - $Popust;
                                    $KolicinaArtiklaRacuna = $rowArtikli['kolicina'];
                                    $UkupnoArtikalRacuna = $KolicinaArtiklaRacuna * $CenaArtiklaRacuna;
                                    $OsnovicaA = 0;
                                    $OsnovicaDj = 0;
                                    $OsnovicaE = 0;
                                    switch ($poreskaGrupa) {
                                        case "0":
                                            $OznakaPorez = "A";
                                            $PorezA = 0;
                                            $OsnovicaA = $OsnovicaA + $UkupnoArtikalRacuna;
                                            break;
                                        case "1":
                                            $OznakaPorez = "G";
                                            break;
                                        case "2":
                                            $OznakaPorez = "D";
                                            break;
                                        case "3":
                                            $OznakaPorez = "DJ";
                                            $PorezDj = $PorezDj + ($UkupnoArtikalRacuna - ($UkupnoArtikalRacuna / 1.2));
                                            $OsnovicaDj = $OsnovicaDj + ($UkupnoArtikalRacuna / 1.2);
                                            break;
                                        case "4":
                                            $OznakaPorez = "E";
                                            $PorezE = $PorezE + ($UkupnoArtikalRacuna - ($UkupnoArtikalRacuna / 1.1));
                                            $OsnovicaE = $OsnovicaE + ($UkupnoArtikalRacuna / 1.1);
                                            break;
                                        case "5":
                                            $OznakaPorez = "ZJ";
                                            break;
                                        case "6":
                                            $OznakaPorez = "I";
                                            break;
                                        case "7":
                                            $OznakaPorez = "J";
                                            break;
                                        case "8":
                                            $OznakaPorez = "K";
                                            break;
                                    }
                                    $JedCena = $UkupnoArtikalRacuna / $KolicinaArtiklaRacuna;
                                    $PreText = str_pad(mb_substr($NazivArtiklaRacuna, 0, $HalfLetters, 'UTF-8'), $HalfLetters, " ", STR_PAD_RIGHT) . '' . str_pad(mb_substr($KolicinaArtiklaRacuna . 'X' . number_format($JedCena, 2, '.', ''), 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . '' . str_pad(mb_substr(number_format($UkupnoArtikalRacuna, 2, '.', ''), 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT);
                                    $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                }
                            } else {
                                $poreskaGrupa = GetSettingVal('meni.redni.broj.pg');
                                $NazivArtiklaRacuna = $MeniNaziv;
                                $CenaArtiklaRacuna = $MeniCena;
                                if ($TotalPopust > 0) {
                                    $Popust = $CenaArtiklaRacuna * (0 + $TotalPopust / 100);
                                } else {
                                    $Popust = 0;
                                }
                                $CenaArtiklaRacuna = $CenaArtiklaRacuna - $Popust;
                                $KolicinaArtiklaRacuna = $MeniKolicina;
                                $UkupnoArtikalRacuna = $KolicinaArtiklaRacuna * $CenaArtiklaRacuna;
                                switch ($poreskaGrupa) {
                                    case "0":
                                        $OznakaPorez = "A";
                                        $PorezA = 0;
                                        $OsnovicaA = $OsnovicaA + $UkupnoArtikalRacuna;
                                        break;
                                    case "1":
                                        $OznakaPorez = "G";
                                        break;
                                    case "2":
                                        $OznakaPorez = "D";
                                        break;
                                    case "3":
                                        $OznakaPorez = "DJ";
                                        $PorezDj = $PorezDj + ($UkupnoArtikalRacuna - ($UkupnoArtikalRacuna / 1.2));
                                        $OsnovicaDj = $OsnovicaDj + ($UkupnoArtikalRacuna / 1.2);
                                        break;
                                    case "4":
                                        $OznakaPorez = "E";
                                        $PorezE = $PorezE + ($UkupnoArtikalRacuna - ($UkupnoArtikalRacuna / 1.1));
                                        $OsnovicaE = $OsnovicaE + ($UkupnoArtikalRacuna / 1.1);
                                        break;
                                    case "5":
                                        $OznakaPorez = "ZJ";
                                        break;
                                    case "6":
                                        $OznakaPorez = "I";
                                        break;
                                    case "7":
                                        $OznakaPorez = "J";
                                        break;
                                    case "8":
                                        $OznakaPorez = "K";
                                        break;
                                }
                                $JedCena = $UkupnoArtikalRacuna / $KolicinaArtiklaRacuna;
                                $PreText = str_pad(mb_substr($NazivArtiklaRacuna, 0, $HalfLetters, 'UTF-8'), $HalfLetters, " ", STR_PAD_RIGHT) . '' . str_pad(mb_substr($KolicinaArtiklaRacuna . 'X' . number_format($JedCena, 2, '.', ''), 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . '' . str_pad(mb_substr(number_format($UkupnoArtikalRacuna, 2, '.', ''), 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT);
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                            }
                            mysqli_query($link, "UPDATE racun SET crnoPlacanje='$NacinPlacanja' WHERE id='$RacunId'");
                            if ($CrnoData['rekapitulacijaPoreza'] == 1) {
                                $PrintString .= str_pad('-', $PrinterLetters, "-", STR_PAD_BOTH) . "\n";
                                if ($OsnovicaA != 0) {
                                    $PreText = FormatTextHalfLeft('SA:') . '' . FormatTextHalfRight('0.00%');
                                    $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                                    $PreText = FormatTextHalfLeft('PA: ') . '' . FormatTextHalfRight(number_format($PorezA, 2, '.', ''));
                                    $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                }
                                if ($OsnovicaDj != 0) {
                                    $PreText = FormatTextHalfLeft('SDJ:') . '' . FormatTextHalfRight('20.00%');
                                    $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                                    $PreText = FormatTextHalfLeft('PDJ:') . '' . FormatTextHalfRight(number_format($PorezDj, 2, '.', ''));
                                    $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                }
                                if ($OsnovicaE != 0) {
                                    $PreText = $PreText = FormatTextHalfLeft('SE:') . '' . FormatTextHalfRight('10.00%');
                                    $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                    $PreText = FormatTextHalfLeft('PE:') . '' . FormatTextHalfRight(number_format($PorezE, 2, '.', ''));
                                    $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                }
                                $PorezTotal = $PorezA + $PorezDj + $PorezE;
                                $PreText = FormatTextHalfLeft('PT:') . '' . FormatTextHalfRight(number_format($PorezTotal, 2, '.', ''));
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                if ($OsnovicaA != 0) {
                                    $PreText = FormatTextHalfLeft('EA:') . '' . FormatTextHalfRight(number_format($OsnovicaA, 2, '.', ''));
                                    $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                }
                                if ($OsnovicaDj != 0) {
                                    $PreText = FormatTextHalfLeft('EDJ:') . '' . FormatTextHalfRight(number_format($OsnovicaDj, 2, '.', ''));
                                    $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                }
                                if ($OsnovicaE != 0) {
                                    $PreText = FormatTextHalfLeft('EE:') . '' . FormatTextHalfRight(number_format($OsnovicaE, 2, '.', ''));
                                    $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                                }
                                $PreText = FormatTextHalfLeft('ET:') . '' . FormatTextHalfRight(number_format($TotalRacun, 2, '.', ''));
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                                $PrintString .= str_pad('-', $PrinterLetters, "-", STR_PAD_BOTH) . "\n";

                                $PreText = FormatTextHalfLeft('ZA UPLATU:') . '' . FormatTextHalfRight(number_format($TotalRacun, 2, '.', ''));
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                                $PreText = FormatTextHalfLeft('GOTOVINA:') . '' . FormatTextHalfRight(number_format($TotalRacun, 2, '.', ''));
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                                $PreText = FormatTextHalfLeft('UPLACENO:') . '' . FormatTextHalfRight(number_format($TotalRacun, 2, '.', ''));
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                                $PreText = FormatTextHalfLeft('POVRACAJ:') . '' . FormatTextHalfRight('0.00');
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                                $PreText = date('d.m.Y-H:i', strtotime($datumRacuna));
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                                $PreText = FormatTextHalfLeft($korisnikPrograma) . '' . FormatTextHalfRight('#' . $idKorisnika);
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                            } else {
                                $PrintString .= str_pad("-", $PrinterLetters, "-", STR_PAD_BOTH) . "\n";
                                $PreText = FormatTextHalfLeft('Ukupno: ') . '' . FormatTextHalfRight($TotalRacun);
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                                $PrintString .= FormatText($korisnikPrograma) . "\n";
                            }
                            if ($CrnoData['footer1'] != '' || $CrnoData['footer2'] != '' || $CrnoData['footer3'] != '') {
                                $PrintString .= str_pad("-", $PrinterLetters, "-", STR_PAD_BOTH) . "\n";
                            }
                            if ($CrnoData['footer1'] != '') {
                                $PreText = $CrnoData['footer1'];
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                            }
                            if ($CrnoData['footer2'] != '') {
                                $PreText = $CrnoData['footer2'];
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                            }
                            if ($CrnoData['footer3'] != '') {
                                $PreText = $CrnoData['footer3'];
                                $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                            }
                            if ($CrnoData['footer1'] != '' || $CrnoData['footer2'] != '' || $CrnoData['footer3'] != '') {
                                $PrintString .= str_pad("-", $PrinterLetters, "-", STR_PAD_BOTH) . "\n";
                            }

                            //sleep(2);
                            try {
                                // Enter the share name for your USB printer here
                                if (strpos($NazivStampaca, "/")) {
                                    $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                                } else {
                                    $connector = new WindowsPrintConnector($NazivStampaca);
                                }

                                $printer = new Printer($connector);
                                $printer->pulse(1, 300, 300);
                                $printer->setPrintLeftMargin(0);
                                $printer->setJustification(Printer::JUSTIFY_LEFT);
                                $printer->text($PrintString);
                                $printer->feed();
                                $printer->cut();
                                $printer->close();
                            } catch (Exception $e) {
                                echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                                die();
                            }
                            if ($DostavaID > 0 && $DostavaAdresaID > 0) {
                                $GetDostavaData = mysqli_query($link, "SELECT d.naziv, d.telefon, da.* FROM dostava d, dostava_adresa da WHERE d.id=da.DOSTAVA_ID AND da.id='$DostavaAdresaID'");
                                if (mysqli_num_rows($GetDostavaData) == 1) {
                                    $DostavaData = mysqli_fetch_array($GetDostavaData);
                                    $PrintString = "";
                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";
                                    $PrintString .= FormatText('Podaci o kupcu:') . "\n";

                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                                    $PrintString .= $DostavaData['naziv'] . "\n";

                                    $PrintString .= $DostavaData['telefon'] . "\n";
                                    $PrintAdresa = $DostavaData['adresa'];
                                    if ($DostavaData['broj'] != '') {
                                        $PrintAdresa .= " " . $DostavaData['broj'];
                                    }
                                    if ($DostavaData['mesto'] != '') {
                                        $PrintAdresa = $DostavaData['mesto'] . " " . $PrintAdresa;
                                    }
                                    if ($DostavaData['sprat'] != '') {
                                        $PrintAdresa .= " " . $DostavaData['sprat'];
                                    }

                                    $PrintString .= $PrintAdresa . "\n";

                                    if ($DostavaData['interfon'] != '') {
                                        $PrintString .= 'Interfon: ' . $DostavaData['interfon'] . "\n";
                                    }
                                    if ($DostavaData['napomena'] != '') {
                                        $PrintString .= 'NAPOMENA: ' . $DostavaData['napomena'] . "\n";
                                    }

                                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                                    try {
                                        // Enter the share name for your USB printer here
                                        if (strpos($NazivStampaca, "/")) {
                                            $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                                        } else {
                                            $connector = new WindowsPrintConnector($NazivStampaca);
                                        }

                                        $printer = new Printer($connector);
                                        $printer->pulse(1, 300, 300);
                                        $printer->setPrintLeftMargin(0);
                                        $printer->setJustification(Printer::JUSTIFY_LEFT);
                                        $printer->text($PrintString);
                                        $printer->feed();
                                        $printer->cut();
                                        $printer->close();
                                    } catch (Exception $e) {
                                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                                        die();
                                    }
                                }
                            }
                        } else {
                            echo json_encode(array('Status' => 'error', 'Message' => 'Traženi način naplate ne postoji!!!'));
                            die();
                        }
                    }
                }
            } else {
                $doc = new DOMDocument('1.0', 'UTF-8');
                $doc->preserveWhiteSpace = false;
                $doc->formatOutput = true;
                $ele = $doc->createElement('FiscalRecipet');
                $NazivRacuna = 'Racun_' . date('Ymd_His');
                if ($MeniPrometId == 0) {
                    $GetArtikleZaRacun = mysqli_query($link, "SELECT a.dozvoljenPopust, a.poreskaGrupa, SUM(sr.kolicina) as kolicina, sr.cena, sr.naziv, sr.ARTIKAL_ID FROM stavkaracuna sr, artikal a WHERE sr.brojStola='$brojStola' AND sr.RACUN_ID='$RacunId' AND a.id=sr.ARTIKAL_ID GROUP BY sr.ARTIKAL_ID, sr.cena ORDER BY sr.id ASC") or die(mysqli_error($link) . "na stavci racuna");
                    if (mysqli_num_rows($GetArtikleZaRacun) > 0) {
                        while ($rowArtikli = mysqli_fetch_array($GetArtikleZaRacun)) {
                            $NazivArtiklaRacuna = $rowArtikli['naziv'];
                            $CenaArtiklaRacuna = $rowArtikli['cena'];
                            if ($rowArtikli['dozvoljenPopust'] == 1) {
                                if ($TotalPopust > 0) {
                                    $Popust = $CenaArtiklaRacuna * (0 + $TotalPopust / 100);
                                } else {
                                    $Popust = 0;
                                }
                            } else {
                                $Popust = 0;
                            }
                            $CenaArtiklaRacuna = $CenaArtiklaRacuna - $Popust;
                            $CenaArtiklaRacuna = number_format($CenaArtiklaRacuna, 2, '.', '');
                            $KolicinaArtiklaRacuna = number_format($rowArtikli['kolicina'], 3, '.', '');
                            $poreskaGrupa = $rowArtikli['poreskaGrupa'];
                            switch ($poreskaGrupa) {
                                case "0":
                                    $OznakaPorez = "GRUPA_A";
                                    break;
                                case "1":
                                    $OznakaPorez = "GRUPA_G";
                                    break;
                                case "2":
                                    $OznakaPorez = "GRUPA_D";
                                    break;
                                case "3":
                                    $OznakaPorez = "GRUPA_DJ";
                                    break;
                                case "4":
                                    $OznakaPorez = "GRUPA_E";
                                    break;
                                case "5":
                                    $OznakaPorez = "GRUPA_ZJ";
                                    break;
                                case "6":
                                    $OznakaPorez = "GRUPA_I";
                                    break;
                                case "7":
                                    $OznakaPorez = "GRUPA_J";
                                    break;
                                case "8":
                                    $OznakaPorez = "GRUPA_K";
                                    break;
                            }
                            $ele2 = $doc->createElement('FiscalItem');
                            $ele3 = $doc->createElement('Naziv');
                            $ele3->nodeValue = $NazivArtiklaRacuna;
                            $ele2->appendChild($ele3);
                            $ele4 = $doc->createElement('Cena');
                            $ele4->nodeValue = $CenaArtiklaRacuna;
                            $ele2->appendChild($ele4);
                            $ele5 = $doc->createElement('Kolicina');
                            $ele5->nodeValue = $KolicinaArtiklaRacuna;
                            $ele2->appendChild($ele5);
                            $ele6 = $doc->createElement('PoreskaGrupa');
                            $ele6->nodeValue = $OznakaPorez;
                            $ele2->appendChild($ele6);
                            $ele->appendChild($ele2);
                        }
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nema artikala za naplatu!!!'));
                        die();
                    }
                } else {
                    $NazivArtiklaRacuna = $MeniNaziv;
                    $CenaArtiklaRacuna = $MeniCena;
                    if ($TotalPopust > 0) {
                        $Popust = $CenaArtiklaRacuna * (0 + $TotalPopust / 100);
                    } else {
                        $Popust = 0;
                    }
                    $CenaArtiklaRacuna = $CenaArtiklaRacuna - $Popust;
                    $CenaArtiklaRacuna = number_format($CenaArtiklaRacuna, 2, '.', '');
                    $KolicinaArtiklaRacuna = number_format($MeniKolicina, 3, '.', '');
                    $poreskaGrupa = GetSettingVal('meni.redni.broj.pg');
                    switch ($poreskaGrupa) {
                        case "0":
                            $OznakaPorez = "GRUPA_A";
                            break;
                        case "1":
                            $OznakaPorez = "GRUPA_G";
                            break;
                        case "2":
                            $OznakaPorez = "GRUPA_D";
                            break;
                        case "3":
                            $OznakaPorez = "GRUPA_DJ";
                            break;
                        case "4":
                            $OznakaPorez = "GRUPA_E";
                            break;
                        case "5":
                            $OznakaPorez = "GRUPA_ZJ";
                            break;
                        case "6":
                            $OznakaPorez = "GRUPA_I";
                            break;
                        case "7":
                            $OznakaPorez = "GRUPA_J";
                            break;
                        case "8":
                            $OznakaPorez = "GRUPA_K";
                            break;
                    }
                    $ele2 = $doc->createElement('FiscalItem');
                    $ele3 = $doc->createElement('Naziv');
                    $ele3->nodeValue = $NazivArtiklaRacuna;
                    $ele2->appendChild($ele3);
                    $ele4 = $doc->createElement('Cena');
                    $ele4->nodeValue = $CenaArtiklaRacuna;
                    $ele2->appendChild($ele4);
                    $ele5 = $doc->createElement('Kolicina');
                    $ele5->nodeValue = $KolicinaArtiklaRacuna;
                    $ele2->appendChild($ele5);
                    $ele6 = $doc->createElement('PoreskaGrupa');
                    $ele6->nodeValue = $OznakaPorez;
                    $ele2->appendChild($ele6);
                    $ele->appendChild($ele2);
                }
                $ele7 = $doc->createElement('Placanje');
                $KarticaPrinted = 0;
                $CekPrinted = 0;
                $GotovinaPrinted = 0;
				$NacinPlacanja = "";
                foreach ($_POST['UbaciRacune'] as $d) {
                    $NacinPlacanja = $d[0];
                    $IznosPlacanja = $d[1];
                    if ($IznosPlacanja > 0) {
                        if ($NacinPlacanja == 'KARTICA') {
                            mysqli_query($link, "INSERT INTO placanje(iznos, nacin, vreme, RACUN_ID) "
                                . "VALUES('$IznosPlacanja', '$NacinPlacanja', '$datumRacuna', '$RacunId')");
                            $ele8 = $doc->createElement('Kartica');
                            $ele8->nodeValue = $IznosPlacanja;
                            $ele7->appendChild($ele8);
                            $KarticaPrinted = 1;
                        }
                        if ($NacinPlacanja == 'GOTOVINA') {
                            mysqli_query($link, "INSERT INTO placanje(iznos, nacin, vreme, RACUN_ID) "
                                . "VALUES('$IznosPlacanja', '$NacinPlacanja', '$datumRacuna', '$RacunId')");
                            $ele8 = $doc->createElement('Gotovina');
                            $ele8->nodeValue = $IznosPlacanja;
                            $ele7->appendChild($ele8);
                            $GotovinaPrinted = 1;
                        }
                        if ($NacinPlacanja == 'CEK' || $NacinPlacanja == 'FAKTURA') {
                            mysqli_query($link, "INSERT INTO placanje(iznos, nacin, vreme, RACUN_ID) "
                                . "VALUES('$IznosPlacanja', '$NacinPlacanja', '$datumRacuna', '$RacunId')");
                            $ele8 = $doc->createElement('Cek');
                            $ele8->nodeValue = $IznosPlacanja;
                            $ele7->appendChild($ele8);
                            $CekPrinted = 1;
                        }
                    }
                }
				if ($NacinPlacanja == 'DRUGO' || $NacinPlacanja == 'VAUCER' || $NacinPlacanja == 'INSTANT') {
					mysqli_query($link, "UPDATE racun SET crnoplacanje='$NacinPlacanja' WHERE id='$RacunId'");
				}
				else {
					mysqli_query($link, "UPDATE racun SET crnoPlacanje=NULL WHERE id='$RacunId'");
				}
                if ($KarticaPrinted == 0) {
                    $ele8 = $doc->createElement('Kartica');
                    $ele8->nodeValue = 0;
                    $ele7->appendChild($ele8);
                }
                if ($GotovinaPrinted == 0) {
                    $ele8 = $doc->createElement('Gotovina');
                    $ele8->nodeValue = 0;
                    $ele7->appendChild($ele8);
                }
                if ($CekPrinted == 0) {
                    $ele8 = $doc->createElement('Cek');
                    $ele8->nodeValue = 0;
                    $ele7->appendChild($ele8);
                }
                $ele->appendChild($ele7);
                $ele11 = $doc->createElement('Konobar');
                $ele11->nodeValue = $korisnikPrograma;
                $ele->appendChild($ele11);

                $doc->appendChild($ele);
                $doc->save($SaveToReceipt . '/' . $NazivRacuna . '.xml');
                //sleep(2);
                if ($DostavaID > 0 && $DostavaAdresaID > 0) {
                    $GetDostavaData = mysqli_query($link, "SELECT d.naziv, d.telefon, da.* WHERE d.id=da.DOSTAVA_ID AND da.id='$DostavaAdresaID'");
                    if (mysqli_num_rows($GetDostavaData) == 1) {
                        $DostavaData = mysqli_fetch_array($GetDostavaData);
                        $doc2 = new DOMDocument('1.0', 'UTF-8');
                        $doc2->preserveWhiteSpace = false;
                        $doc2->formatOutput = true;
                        $ele2 = $doc2->createElement('NefiskalnaStampa');
                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = FormatTextLeft('==============================');
                        $ele2->appendChild($eleH2);
                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = FormatText('Podaci o kupcu:');
                        $ele2->appendChild($eleH2);
                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = FormatTextLeft('==============================');
                        $ele2->appendChild($eleH2);

                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = $DostavaData['naziv'];
                        $ele2->appendChild($eleH2);
                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = $DostavaData['telefon'];
                        $ele2->appendChild($eleH2);
                        $PrintAdresa = $DostavaData['adresa'];
                        if ($DostavaData['broj'] != '') {
                            $PrintAdresa .= " " . $DostavaData['broj'];
                        }
                        if ($DostavaData['mesto'] != '') {
                            $PrintAdresa = $DostavaData['mesto'] . " " . $PrintAdresa;
                        }
                        if ($DostavaData['sprat'] != '') {
                            $PrintAdresa .= " " . $DostavaData['sprat'];
                        }

                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = $PrintAdresa;
                        $ele2->appendChild($eleH2);

                        if ($DostavaData['interfon'] != '') {
                            $eleH2 = $doc2->createElement('Linija');
                            $eleH2->nodeValue = 'Interfon: ' . $DostavaData['interfon'];
                            $ele2->appendChild($eleH2);
                        }
                        if ($DostavaData['napomena'] != '') {
                            $eleH2 = $doc2->createElement('Linija');
                            $eleH2->nodeValue = 'NAPOMENA: ' . $DostavaData['napomena'];
                            $ele2->appendChild($eleH2);
                        }

                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = FormatTextLeft('==============================');
                        $ele2->appendChild($eleH2);
                        $doc2->appendChild($ele2);
                        $doc2->save($SaveToReceipt . '/Dostava' . $NazivRacuna . '.xml');
                    }
                }
            }
        } else {
            mysqli_query($link, "UPDATE racun SET crnoPlacanje=NULL WHERE id='$RacunId'");
            mysqli_query($link, "UPDATE racun_fiskal SET RACUN_ID='$RacunId' WHERE id='$UpdateRacunFiskal'");
            $RemainsToPay = $TotalRacun;
			$NacinPlacanjaG = "";
            foreach ($Placanja as $NacinPlacanja => $IznosPlacanja) {
                if ($IznosPlacanja > 0) {
                    if ($RemainsToPay < $IznosPlacanja) {
                        mysqli_query($link, "INSERT INTO placanje(iznos, nacin, vreme, RACUN_ID) "
                            . "VALUES('$RemainsToPay', '$NacinPlacanja', '$datumRacuna', '$RacunId')");
                    } else {
                        mysqli_query($link, "INSERT INTO placanje(iznos, nacin, vreme, RACUN_ID) "
                            . "VALUES('$IznosPlacanja', '$NacinPlacanja', '$datumRacuna', '$RacunId')");
                    }
                    $RemainsToPay = $RemainsToPay - $IznosPlacanja;
                }
				$NacinPlacanjaG = $NacinPlacanja;
            }
			if ($NacinPlacanjaG == 'DRUGO' || $NacinPlacanjaG == 'VAUCER' || $NacinPlacanjaG == 'INSTANT') {
				mysqli_query($link, "UPDATE racun SET crnoplacanje='$NacinPlacanjaG' WHERE id='$RacunId'");
			}
			else {
				mysqli_query($link, "UPDATE racun SET crnoPlacanje=NULL WHERE id='$RacunId'");
			}
			
        }
        if ($FakturaFormat == "A4") {
            echo json_encode(array('Status' => 'pdfFaktura', 'Message' => 'Kreirana PDF faktura!!!', 'fiskalniRacunId' => $UpdateRacunFiskal, 'Action' => $Logout));
        } else {
			if($racunZatvorenNemaStampaca == "DA") {
				echo json_encode(array('Status' => 'success', 'Message' => 'Račun je kreiran i zabeležen u poreskoj upravi ali štampa nije moguća!<br>Proverite štampač za račune ili kontaktirajte tehničku podršku!', 'RacunId' => $RacunId, 'ButErrPrint' => $racunZatvorenNemaStampaca, 'Action' => $Logout));
			}
			else {
				echo json_encode(array('Status' => 'success', 'Message' => 'Napravljen račun!!!', 'RacunId' => $RacunId, 'Action' => $Logout));
			}
        }
        RekonstrukcijaRacun($RacunId, $Zd);
        die();
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Iznos za uplatu je manji od iznosa računa!!!'));
        die();
    }
}
if (isset($_POST['TransferItems'])) {
    $StoId = mysqli_real_escape_string($link, $_POST['TransferItems']);
    $TransferFromTable = mysqli_real_escape_string($link, $_POST['TransferFromTable']);
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Rastavljanje stola Sto->" . $StoId . " Sa stola->" . $TransferFromTable . " Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    $UserId = mysqli_real_escape_string($link, $_COOKIE['UserId']);
    $VremePorudzbine = date('Y-m-d H:i:s');
    $RacunId = 0;
    $KonobarId = $UserId;
    $GetRacunId = mysqli_query($link, "SELECT * FROM racun WHERE brojStola='$StoId' AND zatvoren=0 ORDER BY id DESC LIMIT 1");
    if (mysqli_num_rows($GetRacunId) == 1) {
        $RacunData = mysqli_fetch_array($GetRacunId);
        $RacunId = $RacunData['id'];
        $KonobarId = $RacunData['KONOBAR_ID'];
        $IznosStola = -1;
    }
    $IsTableOpened = mysqli_query($link, "SELECT kolicina, cena FROM stavkaracuna where brojStola='$StoId'");
    if (mysqli_num_rows($IsTableOpened) > 0) {
        $IznosStola = 0;
        while ($row1 = mysqli_fetch_array($IsTableOpened)) {
            $IznosStola = $IznosStola + ($row1['kolicina'] * $row1['cena']);
        }
    }
    $RadSaGostima = GetSettingVal('rad.sa.gostima');
    if ($IznosStola >= 0 && $RacunId > 0) {
        if ($KonobarId != $UserId) {
			$KonobarPrivilegija = "";
			$GetKonobarUloga = mysqli_query($link, "SELECT nivo FROM konobar WHERE id=$UserId LIMIT 1") or die(mysqli_error($link));
			if (mysqli_num_rows($GetKonobarUloga) == 1) {
				$KonobarPrivilegija = mysqli_fetch_array($GetKonobarUloga)['nivo'];
			}
			if($KonobarPrivilegija != 'SEF') {
				echo json_encode(array('Status' => 'error', 'Message' => "Drugi korisnik vodi sto na koji zelite da prebacite stavke!!! Prebacivanje nije moguce!!!"));
				die();
			}
        }
        $GetMaxGost = mysqli_query($link, "SELECT * FROM stavkaracuna WHERE RACUN_ID='$RacunId' AND brojStola='$StoId' ORDER BY gostbroj DESC LIMIT 1");
        if (mysqli_num_rows($GetMaxGost) == 1) {
            $MaxGostBroj = mysqli_fetch_array($GetMaxGost)['gostbroj'];
        }
    } else {
        $GetBrojRacuna = mysqli_query($link, "SELECT MAX(brojRacuna) as broj FROM racun") or die(mysqli_error());
        if (mysqli_num_rows($GetBrojRacuna) > 0) {
            $ResBrojRacuna = mysqli_fetch_array($GetBrojRacuna);
            $brojRacuna = $ResBrojRacuna['broj'] + 1;
        } else {
            $brojRacuna = 1;
        }
        $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetZd) == 1) {
            $Zd = mysqli_fetch_array($GetZd)['zdBroj'];
        }
        $datumRacuna = date('Y-m-d H:i:s');
        $kasaId = $KasaId;
        $TotalPopust = 0;
        mysqli_query($link, "INSERT INTO racun(brojRacuna, brojStola, datum, fiskalniOdstampan, storniran, zatvoren, KASA_ID, KONOBAR_ID, popust, zdBroj, naOsnovno)
            VALUES('$brojRacuna', '$StoId', '$datumRacuna', 0, 0, 0, '$kasaId', '$UserId', '$TotalPopust', '$Zd', '1')") or die(mysqli_error($link) . "na upisu racuna");
        $RacunId = mysqli_insert_id($link);
        $MaxGostBroj = 0;
    }
    if ($RadSaGostima != 'true') {
        $MaxGostBroj = 0;
    }
    $GostBroj = 0;
    foreach ($_POST['ItemsToTransfer'] as $TransferId => $TransferData) {
        $StavkaId = mysqli_real_escape_string($link, $TransferData[0]);
        $StavkaKolicina = mysqli_real_escape_string($link, $TransferData[1]);
        $GetItemData = mysqli_query($link, "SELECT * FROM stavkaracuna WHERE id='$StavkaId'");
        if (mysqli_num_rows($GetItemData) == 1) {
            $ResItemData = mysqli_fetch_array($GetItemData);
            $NewGostBroj = $MaxGostBroj + $ResItemData['gostbroj'];
            if ($GostBroj != $NewGostBroj) {
                $GostBroj = $NewGostBroj;
                $BrojTureGet = mysqli_query($link, "SELECT MAX(brojTure) as brojTure FROM tura WHERE datum >= (SELECT MAX(zakljucenje) as datum FROM zd WHERE pocetak=1)");
                if (mysqli_num_rows($BrojTureGet) > 0) {
                    $BrojTure = mysqli_fetch_array($BrojTureGet)['brojTure'] + 1;
                } else {
                    $BrojTure = 1;
                }
                mysqli_query($link, "INSERT INTO tura (brojStola, brojTure, datum, pripremljena, uPripremi, pocetak, REZERVACIJA_ID, napomena, RACUN_ID) 
                    VALUES ('$StoId', '$BrojTure', '$VremePorudzbine', 0, 0, now(), 0, 'Prebaceno', '$RacunId')") or die(mysqli_error($link));
                $IdTure = mysqli_insert_id($link);
            }
            $CenaArtikla = $ResItemData['cena'];
            $KolicinaArtikla = $StavkaKolicina;
            $NazivArtikla = $ResItemData['naziv'];
            $IdArtikla = $ResItemData['ARTIKAL_ID'];
            $OpisArtikla = $ResItemData['opis'];
            mysqli_query($link, "INSERT INTO stavkaracuna (brojStola, cena, kolicina, naziv, ARTIKAL_ID, TURA_ID, opis, RACUN_ID, gostbroj) "
                . "VALUES('$StoId', '$CenaArtikla', '$KolicinaArtikla', '$NazivArtikla', '$IdArtikla', '$IdTure', '$OpisArtikla', '$RacunId', '$GostBroj')") or die(mysqli_error($link));
            if ($ResItemData['kolicina'] <= $StavkaKolicina) {
                mysqli_query($link, "DELETE FROM stavkaracuna WHERE id='$StavkaId'");
            } else {
                $NovaKolicina = $ResItemData['kolicina'] - $StavkaKolicina;
                mysqli_query($link, "UPDATE stavkaracuna SET kolicina='$NovaKolicina' WHERE id='$StavkaId'");
            }
        }
    }
    $GetRacun = mysqli_query($link, "SELECT id FROM racun WHERE brojStola='$TransferFromTable' AND zatvoren=0");
    if (mysqli_num_rows($GetRacun) != 0) {
        while ($rowRacun = mysqli_fetch_array($GetRacun)) {
            $RacunId = $rowRacun['id'];
            $GetStavke = mysqli_query($link, "SELECT * FROM stavkaracuna WHERE RACUN_ID='$RacunId'");
            if (mysqli_num_rows($GetStavke) == 0) {
                mysqli_query($link, "UPDATE racun SET zatvoren=1 WHERE id='$RacunId'");
            }
        }
    }
    echo json_encode(array('Status' => 'success', 'Message' => 'Sto je prebacen!!!'));
    die();
}
if (isset($_POST['StornoTable'])) {
    $TableId = mysqli_real_escape_string($link, $_POST['StornoTable']);
    $korisnikPrograma = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $idKorisnika = mysqli_real_escape_string($link, $_COOKIE['UserId']);
    if (isset($_POST['StornoLozinka'])) {
        $NasliSmo = 0;
        $Lozinka = mysqli_real_escape_string($link, $_POST['StornoLozinka']);
        $GetLoginStorno = mysqli_query($link, "SELECT * FROM login WHERE pass='$Lozinka' LIMIT 1") or die(mysqli_error($link));
        if (mysqli_num_rows($GetLoginStorno) == 1) {
            $NasliSmo = 1;
        }
        $GetSifrarnikStorno = mysqli_query($link, "SELECT * FROM sifra WHERE sifarnik='STORNO' AND sifra='$Lozinka' LIMIT 1") or die(mysqli_error($link));
        if (mysqli_num_rows($GetSifrarnikStorno) == 1) {
            $NasliSmo = 1;
        }
        $GetKonobarStorno = mysqli_query($link, "SELECT * FROM konobar WHERE sifra='$Lozinka' AND nivo='SEF' LIMIT 1") or die(mysqli_error($link));
        if (mysqli_num_rows($GetKonobarStorno) == 1) {
            $NasliSmo = 1;
        }
        if ($NasliSmo == 0) {
            echo json_encode(array('Status' => 'error', 'Message' => 'Netačna lozinka!!!'));
            die();
        }
    }
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Storniranje Sto->" . $TableId . " Korisnik->" . $UserName . " Sifra->" . $Lozinka;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");

    mysqli_query($link, "INSERT INTO storno (brojStola, datum, tipStorna, user, vremeStorniranja, KONOBAR_ID) "
        . "VALUES('$TableId', now(), 'PORUDZBINA', '$korisnikPrograma', now(), '$idKorisnika')") or die(mysqli_error($link));
    $StornoId = mysqli_insert_id($link);
    $Stampaci = [];
    $GetTableData = mysqli_query($link, "SELECT * FROM stonaziv WHERE broj='$TableId' LIMIT 1");
    if (mysqli_num_rows($GetTableData) == 1) {
        $NazivStola = mysqli_fetch_array($GetTableData)['naziv'];
    } else {
        $NazivStola = $TableId;
    }
    $GetStampace = mysqli_query($link, "SELECT * FROM artikal_stampac WHERE 1");
    if (mysqli_num_rows($GetStampace) > 0) {
        while ($rowStampaci = mysqli_fetch_array($GetStampace)) {
            $Stampaci[$rowStampaci['ARTIKLI_ID']][$rowStampaci['STAMPAC_ID']] = $rowStampaci['STAMPAC_ID'];
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema podešenih štampača za artikle!!!'));
        die();
    }
    $Inc = 0;
    $ArrayStampaca = [];
    foreach ($_POST['StornoItems'] as $StornoData) {
        $StavkaId = mysqli_real_escape_string($link, $StornoData[0]);
        $Kolicina = mysqli_real_escape_string($link, $StornoData[1]);
        $GetStavkaData = mysqli_query($link, "SELECT * FROM stavkaracuna WHERE id='$StavkaId'");
        if (mysqli_num_rows($GetStavkaData) == 1) {
            $StavkaRes = mysqli_fetch_array($GetStavkaData);
            $StampacArtikla = $Stampaci[$StavkaRes['ARTIKAL_ID']];
            $NazivArtikla = $StavkaRes['naziv'];
            $KolicinaArtikla = $Kolicina;
            if (is_array($StampacArtikla)) {
                foreach ($StampacArtikla as $StampacArtikla) {
                    $Tura = array_search($StampacArtikla, array_column($ArrayStampaca, 'StampacID'));
                    if (is_numeric($Tura)) {
                        array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $NazivArtikla, 'Kolicina' => $KolicinaArtikla));
                    } else {
                        array_push($ArrayStampaca, array('StampacID' => $StampacArtikla, 'artikli' => array(array('Naziv' => $NazivArtikla, 'Kolicina' => $KolicinaArtikla))));
                    }
                }
            } else {
                $Tura = array_search($StampacArtikla, array_column($ArrayStampaca, 'StampacID'));
                if (is_numeric($Tura)) {
                    array_push($ArrayStampaca[$Tura]['artikli'], array('Naziv' => $NazivArtikla, 'Kolicina' => $KolicinaArtikla));
                } else {
                    array_push($ArrayStampaca, array('StampacID' => $StampacArtikla, 'artikli' => array(array('Naziv' => $NazivArtikla, 'Kolicina' => $KolicinaArtikla))));
                }
            }
            if ($Kolicina == $StavkaRes['kolicina']) {
                mysqli_query($link, "DELETE FROM stavkaracuna WHERE id='$StavkaId'");
            } else {
                $NewKolicina = $StavkaRes['kolicina'] - $Kolicina;
                mysqli_query($link, "UPDATE stavkaracuna SET kolicina='$NewKolicina' WHERE id='$StavkaId'");
            }
            $brojTure = $StavkaRes['TURA_ID'];
            $vrednostArtikla = $KolicinaArtikla * $StavkaRes['cena'];
            $idArtikla = $StavkaRes['ARTIKAL_ID'];
            $glavnaArtikla = $StavkaRes['GLAVNASTAVKA_ID'];
            if ($glavnaArtikla == '' || $glavnaArtikla == 0) {
                mysqli_query($link, "INSERT INTO stornostavka (brojTure, kolicina, vrednost, STORNO_ID, ARTIKAL_ID) "
                    . "VALUES ('$brojTure', '$KolicinaArtikla', '$vrednostArtikla', '$StornoId', '$idArtikla')") or die(mysqli_error($link));
            } else {
                mysqli_query($link, "INSERT INTO stornostavka (brojTure, kolicina, vrednost, STORNO_ID, ARTIKAL_ID, GLAVNASTAVKA_ID) "
                    . "VALUES ('$brojTure', '$KolicinaArtikla', '$vrednostArtikla', '$StornoId', '$idArtikla', '$glavnaArtikla')") or die(mysqli_error($link));
            }
        }
    }
    $GetRacun = mysqli_query($link, "SELECT id FROM racun WHERE brojStola='$TableId' AND zatvoren=0");
    if (mysqli_num_rows($GetRacun) != 0) {
        while ($rowRacun = mysqli_fetch_array($GetRacun)) {
            $RacunId = $rowRacun['id'];
            $GetStavke = mysqli_query($link, "SELECT * FROM stavkaracuna WHERE RACUN_ID='$RacunId'");
            if (mysqli_num_rows($GetStavke) == 0) {
                mysqli_query($link, "UPDATE racun SET zatvoren=1, storniran=1 WHERE id='$RacunId'");
            }
        }
    }
    if (is_array($ArrayStampaca)) {
        $StampacData = [];
        $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE 1");
        if (mysqli_num_rows($GetStampacData) > 0) {
            while ($rowStampacData = mysqli_fetch_array($GetStampacData)) {
                $StampacData[$rowStampacData['id']] = $rowStampacData;
            }
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Nema štampača za štampu porudžbina!!!'));
            die();
        }
        $GetProdajnoMesto = mysqli_query($link, "SELECT naziv FROM prodajnomesto ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetProdajnoMesto) == 1) {
            $ProdajnoMesto = mysqli_fetch_array($GetProdajnoMesto)['naziv'];
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Naziv prodajnog mesta nije podešen!!!'));
            die();
        }
        foreach ($ArrayStampaca as $Stampac) {
            $StampacId = $Stampac['StampacID'];
            $BrojKopija = $StampacData[$StampacId]['brojKopijaPorudzbine'];
            $OdeljenjeNaziv = $StampacData[$StampacId]['bnaziv'];
            $NazivStampaca = $StampacData[$StampacId]['naziv'];
            if ($StampacData[$StampacId]['tip'] == 'POSBANK80MM') {
                $PrinterLetters = 40;
            } else {
                $PrinterLetters = 30;
            }
            for ($x = 0; $x < $BrojKopija; $x++) {
                $PrintString = "";
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                $PrintString .= FormatText('STORNO !!!! STORNO !!!! STORNO') . "\n";

                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                $PrintString .= FormatText('STO:' . $NazivStola) . "\n";

                $PrintString .= FormatText($korisnikPrograma) . "\n";

                $PrintString .= str_pad("-", $PrinterLetters, "-", STR_PAD_BOTH) . "\n";

                $PrintString .= FormatText($OdeljenjeNaziv) . "\n";

                $PrintString .= str_pad("-", $PrinterLetters, "-", STR_PAD_BOTH) . "\n";

                foreach ($Stampac['artikli'] as $ArtikalStampaca) {
                    $Remains = $PrinterLetters - 9;
                    $PrintString .= str_pad(mb_substr($ArtikalStampaca['Kolicina'] . 'X', 0, 9, 'UTF-8'), 9, " ", STR_PAD_RIGHT) . "" . str_pad(mb_substr($ArtikalStampaca['Naziv'], 0, $Remains, 'UTF-8'), $Remains, " ", STR_PAD_RIGHT) . "\n";
                }
                $PrintString .= str_pad("-", $PrinterLetters, "-", STR_PAD_BOTH) . "\n";

                $PrintString .= FormatText('STORNO !!!! STORNO !!!! STORNO') . "\n";
                try {
                    // Enter the share name for your USB printer here
                    if (strpos($NazivStampaca, "/")) {
                        $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                    } else {
                        $connector = new WindowsPrintConnector($NazivStampaca);
                    }

                    $printer = new Printer($connector);
                    $printer->pulse(1, 300, 300);
                    $printer->setPrintLeftMargin(0);
                    $printer->setJustification(Printer::JUSTIFY_LEFT);
                    $printer->text($PrintString);
                    $printer->feed();
                    $printer->cut();
                    $printer->close();
                } catch (Exception $e) {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                    die();
                }
            }
        }
    }
    echo json_encode(array('Status' => 'success', 'Message' => 'Stornirano!!!'));
    die();
}
if (isset($_POST['PassPromenaOperatera'])) {
    $PassOperatera = mysqli_real_escape_string($link, $_POST['PassPromenaOperatera']);
    $RadiPromenu = 0;
    $NoviKonobar = 0;
    $GetPass = mysqli_query($link, "SELECT * FROM konobar WHERE sifra='$PassOperatera'");
    if (mysqli_num_rows($GetPass) == 1) {
        $RadiPromenu = 1;
        $NoviKonobar = mysqli_fetch_array($GetPass)['id'];
    }
    /* $GetPassLogin = mysqli_query($link, "SELECT * FROM login WHERE pass='$PassOperatera'");
      if (mysqli_num_rows($GetPassLogin) == 1) {
      $RadiPromenu = 1;
      } */
    if ($RadiPromenu == 1) {
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Promena operatera Korisnik->" . $UserName . " Sifra->" . $PassOperatera;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
        $Stolovi = $_POST['StoloviZaPromenu'];
        $UpdateStolove = "";
        foreach ($Stolovi as $Sto) {
            $Sto = mysqli_real_escape_string($link, $Sto);
            if ($UpdateStolove == "") {
                $UpdateStolove = $Sto;
            } else {
                $UpdateStolove .= ", " . $Sto;
            }
        }
        if ($UpdateStolove != "") {
            mysqli_query($link, "UPDATE racun SET KONOBAR_ID='$NoviKonobar' WHERE brojStola IN ( $UpdateStolove ) AND zatvoren=0");
            echo json_encode(array('Status' => 'success', 'Message' => 'Stolovi su prebaceni!!!'));
            die();
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Greska pri promeni operatera za odabrane stolove - nisu poslati stolovi!!!'));
            die();
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Lozinka nije ispravna!!!'));
        die();
    }
}
if (isset($_POST['StalniGostName'])) {
    $StalniGostName = mysqli_real_escape_string($link, $_POST['StalniGostName']);
    $StalniGostAdresa = mysqli_real_escape_string($link, $_POST['StalniGostAdresa']);
    $StalniGostMesto = mysqli_real_escape_string($link, $_POST['StalniGostMesto']);
    $StalniGostPIB = mysqli_real_escape_string($link, $_POST['StalniGostPIB']);
    $StalniGostMB = mysqli_real_escape_string($link, $_POST['StalniGostMB']);
    $StalniGostTelefon = mysqli_real_escape_string($link, $_POST['StalniGostTelefon']);
    $StalniGostGrupa = mysqli_real_escape_string($link, $_POST['StalniGostGrupa']);
    $StalniGostId = 0;
    if ($StalniGostPIB != '') {
        $IsExist = mysqli_query($link, "SELECT * FROM stalnigost WHERE pib='$StalniGostPIB'");
        if (mysqli_num_rows($IsExist) > 0) {
            echo json_encode(array('Status' => 'error', 'Message' => 'Gost  sa ovim PIB-om već postoji u sistemu!'));
            die();
        }
        mysqli_query($link, "INSERT INTO stalnigost (adersa, blokiran, brojKopijaPregleda, dobavljac, maticniBroj, mesto, naziv, pib, telefon, GRUPA_ID, kupac) 
            VALUES ('$StalniGostAdresa', 0, 1, 0, '$StalniGostMB', '$StalniGostMesto', '$StalniGostName', '$StalniGostPIB', '$StalniGostTelefon', '$StalniGostGrupa', 0) ") or die(mysqli_error($link));
        $StalniGostId = mysqli_insert_id($link);
    } else {
        mysqli_query($link, "INSERT INTO stalnigost (adersa, blokiran, brojKopijaPregleda, dobavljac, mesto, naziv, telefon, GRUPA_ID, kupac) 
            VALUES ('$StalniGostAdresa', 0, 1, 0, '$StalniGostMesto', '$StalniGostName', '$StalniGostTelefon', '$StalniGostGrupa', 0) ") or die(mysqli_error($link));
        $StalniGostId = mysqli_insert_id($link);
    }
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Kreiranje stalnog gosta " . $StalniGostName . " Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    if ($StalniGostId > 0) {
        $HtmlStalni = '<tr style="display: table-row;" gost-id="' . $StalniGostId . '" gost-sifra="" gost-popust="0" class="SelectedGost" gost-grupa="' . $StalniGostGrupa . '">
                                        <td>' . $StalniGostName . '</td>
                                        <td>' . $StalniGostAdresa . '</td>
                                        <td>' . $StalniGostTelefon . '</td>
                                        <td></td>
                                    </tr>';
        echo json_encode(array('Status' => 'success', 'Message' => '', 'StalniGostNewHtml' => $HtmlStalni));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Stalni gost nije kreiran'));
    }
    die();
}
if (isset($_POST['DajSveGotovinskeRacune'])) {
    $DatumOd = date('Y-m-d H:i:s', strtotime('-1 days'));
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Pregled gotovinskih racuna " . $DatumOd . " Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    $GetRacune = mysqli_query($link, "SELECT SUM(p.iznos) as iznos, p.nacin, r.*  FROM racun r, placanje p WHERE r.datum>='$DatumOd' AND r.id=p.RACUN_ID AND r.zatvoren=1 AND (p.nacin='GOTOVINA' OR p.nacin='KARTICA') GROUP BY p.RACUN_ID ORDER BY r.datum DESC") or die(mysqli_error($link));
    if (mysqli_num_rows($GetRacune) > 0) {
        $HtmlRacuni = "";
        $Operateri = [];
        $GetOperateri = mysqli_query($link, "SELECT * FROM konobar");
        if (mysqli_num_rows($GetOperateri)) {
            while ($rowOperateri = mysqli_fetch_array($GetOperateri)) {
                $Operateri[$rowOperateri['id']] = $rowOperateri['punoIme'];
            }
        }
        while ($rowRacuni = mysqli_fetch_array($GetRacune)) {
            $HtmlRacuni .= "<tr racun-id='" . $rowRacuni['id'] . "'>
                        <td>" . $Operateri[$rowRacuni['KONOBAR_ID']] . "</td>
                        <td>" . $rowRacuni['brojStola'] . "</td>
                        <td>" . $rowRacuni['iznos'] . "</td>
                        <td>" . $rowRacuni['nacin'] . "</td>
                        <td>" . date('H:i', strtotime($rowRacuni['datum'])) . "</td></tr>";
        }
        echo json_encode(array('Status' => 'success', 'Message' => '', 'RacuniNewHtml' => $HtmlRacuni));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema računa za koje se može izdati gotovinski račun!'));
    }
    die();
}
if (isset($_POST['GotovinskiName'])) {
    $GotovinskiName = mysqli_real_escape_string($link, $_POST['GotovinskiName']);
    $GotovinskiAdresa = mysqli_real_escape_string($link, $_POST['GotovinskiAdresa']);
    $GotovinskiMesto = mysqli_real_escape_string($link, $_POST['GotovinskiMesto']);
    $GotovinskiPIB = mysqli_real_escape_string($link, $_POST['GotovinskiPIB']);
    $GotovinskiMB = mysqli_real_escape_string($link, $_POST['GotovinskiMB']);
    $GotovinskiId = 0;
    $IsExist = mysqli_query($link, "SELECT * FROM komitent WHERE pib='$GotovinskiPIB'");
    if (mysqli_num_rows($IsExist) > 0) {
        echo json_encode(array('Status' => 'error', 'Message' => 'Komitent sa ovim PIB-om već postoji u sistemu!'));
        die();
    }
    mysqli_query($link, "INSERT INTO komitent (adresa, mesto, naziv, pib, mb) 
            VALUES ('$GotovinskiAdresa', '$GotovinskiMesto', '$GotovinskiName', '$GotovinskiPIB', '$GotovinskiMB') ") or die(mysqli_error($link));
    $GotovinskiId = mysqli_insert_id($link);
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Kreiranje gotovinskog kupca " . $GotovinskiName . " Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    if ($GotovinskiId > 0) {
        $HtmlGotovinski = '<tr komitent-id="' . $GotovinskiId . '" iskomitent="' . $GotovinskiId . '" class="SelectedGotovinski">
                                        <td>' . $GotovinskiName . '</td>
                                        <td>' . $GotovinskiAdresa . '</td>
                                        <td>' . $GotovinskiMesto . '</td>
                                        <td>' . $GotovinskiPIB . '</td>
                                    </tr>';
        echo json_encode(array('Status' => 'success', 'Message' => '', 'GotovinskiNewHtml' => $HtmlGotovinski));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Gotovinski kupac nije kreiran'));
    }
    die();
}
if (isset($_POST['CreateGotovinskiRacunUska'])) {
    $RacunId = mysqli_real_escape_string($link, $_POST['CreateGotovinskiRacunUska']);
    $Komitent = 0;
    $StalniGost = 0;
    $BrojIsecka = mysqli_real_escape_string($link, $_POST['BrojIsecka']);
    if ($BrojIsecka > 0) {
        mysqli_query($link, "UPDATE racun SET brojBI='$BrojIsecka' WHERE id='$RacunId' AND zatvoren=1");
    }
    if (isset($_POST['KomitentGotovinskiRacunUska'])) {
        $Komitent = mysqli_real_escape_string($link, $_POST['KomitentGotovinskiRacunUska']);
        mysqli_query($link, "UPDATE racun SET KOMITENT_ID='$Komitent' WHERE id='$RacunId' AND zatvoren=1");
        $GetKupacData = mysqli_query($link, "SELECT * FROM komitent WHERE id='$Komitent'");
        $KupacData = mysqli_fetch_array($GetKupacData);
        $KupacPib = $KupacData['pib'];
        $KupacNaziv = $KupacData['naziv'];
        $KupacAdresa = $KupacData['adresa'];
        $KupacMesto = $KupacData['mesto'];
        $KupacMB = $KupacData['mb'];
    } else {
        $StalniGost = mysqli_real_escape_string($link, $_POST['StalniGostGotovinskiRacunUska']);
        mysqli_query($link, "UPDATE racun SET STALNIGOST_ID='$StalniGost' WHERE id='$RacunId' AND zatvoren=1");
        $GetKupacData = mysqli_query($link, "SELECT * FROM stalnigost WHERE id='$StalniGost'");
        $KupacData = mysqli_fetch_array($GetKupacData);
        $KupacPib = $KupacData['pib'];
        $KupacNaziv = $KupacData['naziv'];
        $KupacAdresa = $KupacData['adersa'];
        $KupacMesto = $KupacData['mesto'];
        $KupacMB = $KupacData['maticniBroj'];
    }
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Kreiranje gotovinskog racuna ID->" . $RacunId . " Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    $GetRacunData = mysqli_query($link, "SELECT * FROM racun WHERE id='$RacunId' AND zatvoren=1");
    if (mysqli_num_rows($GetRacunData)) {
        $RacunData = mysqli_fetch_array($GetRacunData);
        $NazivRacuna = 'Racun_' . date('Y-m-d-H-i-s') . '-' . $RacunId;
        $doc = new DOMDocument('1.0', 'UTF-8');
        $doc->preserveWhiteSpace = false;
        $doc->formatOutput = true;
        $ele = $doc->createElement('NefiskalnaStampa');
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('==============================');
        $ele->appendChild($eleH);

        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft($SiteName);
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft(GetSettingVal('objekat.adresa'));
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft(GetSettingVal('objekat.mesto'));
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('Poreski broj: ' . GetSettingVal('objekat.pib'));
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('MB: ' . GetSettingVal('objekat.maticni.broj'));
        $ele->appendChild($eleH);

        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('==============================');
        $ele->appendChild($eleH);

        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('Kupac:');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft($KupacNaziv);
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft($KupacAdresa);
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft($KupacMesto);
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('Poreski broj: ' . $KupacPib);
        $ele->appendChild($eleH);
        if ($KupacMB != '') {
            $eleH = $doc->createElement('Linija');
            $eleH->nodeValue = FormatTextLeft('MB: ' . $KupacMB);
            $ele->appendChild($eleH);
        }
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('==============================');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('RAČUN br: ' . $RacunData['brojRacuna']);
        $ele->appendChild($eleH);
        if ($RacunData['brojBI'] != '') {
            $eleH = $doc->createElement('Linija');
            $eleH->nodeValue = FormatTextLeft('BI: ' . $RacunData['brojBI']);
            $ele->appendChild($eleH);
        } else {
            $eleH = $doc->createElement('Linija');
            $eleH->nodeValue = FormatTextLeft('BI: ................................');
            $ele->appendChild($eleH);
        }
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('==============================');
        $ele->appendChild($eleH);
        $Porez20 = 0;
        $Porez10 = 0;
        $Ukupno = 0;
        if ($RacunData['menipromet'] > 0) {
            $GetArtikle = mysqli_query($link, "SELECT * FROM menipromet WHERE RACUN_ID='$RacunId'");
            if (mysqli_num_rows($GetArtikle) > 0) {
                $rowArtikle = mysqli_fetch_array($GetArtikle);
                $Cena = $rowArtikle['cena'];
                $Popust = $RacunData['popust'];
                if ($Popust > 0) {
                    $Cena = $Cena - ($Cena * (0 + ($Popust / 100)));
                }
                $Kolicina = $rowArtikle['kolicina'];
                $Porez = GetSettingVal('meni.redni.broj.pg');
                $Medjuzbir = $Cena * $Kolicina;
                if ($Porez == 3) {
                    $ArtikalPorez20 = $Medjuzbir / 1.2;
                    $Porez20 = $Porez20 + $ArtikalPorez20;
                } elseif ($Porez == 4) {
                    $ArtikalPorez10 = $Medjuzbir / 1.1;
                    $Porez10 = $Porez10 + $ArtikalPorez10;
                }
                $Ukupno = $Ukupno + $Medjuzbir;
                if ($Medjuzbir > 0) {
                    $eleH = $doc->createElement('Linija');
                    $eleH->nodeValue = FormatTextLeft($rowArtikle['naziv']);
                    $ele->appendChild($eleH);
                    $eleH = $doc->createElement('Linija');
                    $eleH->nodeValue = FormatTextRight($Kolicina . 'x    ' . number_format($Cena, 2, '.', '') . '    ' . number_format($Medjuzbir, 2, '.', '') . ' ');
                    $ele->appendChild($eleH);
                }
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Odabrani račun nema stavke!'));
                die();
            }
        } else {
            $GetArtikle = mysqli_query($link, "SELECT a.poreskaGrupa, a.dozvoljenPopust, SUM(sr.kolicina) as kolicina, sr.cena, sr.naziv, sr.ARTIKAL_ID FROM stavkaracuna sr, artikal a WHERE a.id=sr.ARTIKAL_ID AND sr.RACUN_ID='$RacunId' GROUP BY sr.ARTIKAL_ID, sr.cena ORDER BY sr.id ASC");
            if (mysqli_num_rows($GetArtikle) > 0) {
                while ($rowArtikle = mysqli_fetch_array($GetArtikle)) {
                    $Cena = $rowArtikle['cena'];
                    $Popust = $RacunData['popust'];
                    if ($rowArtikle['dozvoljenPopust'] == 1) {
                        if ($Popust > 0) {
                            $Cena = $Cena - ($Cena * (0 + ($Popust / 100)));
                        }
                    }
                    $Kolicina = $rowArtikle['kolicina'];
                    $Porez = $rowArtikle['poreskaGrupa'];
                    $Medjuzbir = $Cena * $Kolicina;
                    if ($Porez == 3) {
                        $ArtikalPorez20 = $Medjuzbir / 1.2;
                        $Porez20 = $Porez20 + $ArtikalPorez20;
                    } elseif ($Porez == 4) {
                        $ArtikalPorez10 = $Medjuzbir / 1.1;
                        $Porez10 = $Porez10 + $ArtikalPorez10;
                    }
                    $Ukupno = $Ukupno + $Medjuzbir;
                    if ($Medjuzbir > 0) {
                        $eleH = $doc->createElement('Linija');
                        $eleH->nodeValue = FormatTextLeft($rowArtikle['naziv']);
                        $ele->appendChild($eleH);
                        $eleH = $doc->createElement('Linija');
                        $eleH->nodeValue = FormatTextRight($Kolicina . 'x    ' . number_format($Cena, 2, '.', '') . '    ' . number_format($Medjuzbir, 2, '.', '') . ' ');
                        $ele->appendChild($eleH);
                    }
                }
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Odabrani račun nema stavke!'));
                die();
            }
        }
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('==============================');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('Ukupno: ' . number_format($Ukupno, 2, '.', '') . ' ');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('==============================');
        $ele->appendChild($eleH);
        if ($Porez20 > 0) {
            $eleH = $doc->createElement('Linija');
            $eleH->nodeValue = FormatTextLeft('Osnovica 20%: ' . number_format($Porez20, 2, '.', ''));
            $ele->appendChild($eleH);
            $Ukupno20 = $Porez20 * 1.2;
            $SamoPorez20 = $Ukupno20 - $Porez20;
            $eleH = $doc->createElement('Linija');
            $eleH->nodeValue = FormatTextLeft('Porez po 20%: ' . number_format($SamoPorez20, 2, '.', ''));
            $ele->appendChild($eleH);
        }
        if ($Porez10 > 0) {
            $eleH = $doc->createElement('Linija');
            $eleH->nodeValue = FormatTextLeft('Osnovica 10%: ' . number_format($Porez10, 2, '.', ''));
            $ele->appendChild($eleH);
            $Ukupno10 = $Porez10 * 1.1;
            $SamoPorez10 = $Ukupno10 - $Porez10;
            $eleH = $doc->createElement('Linija');
            $eleH->nodeValue = FormatTextLeft('Porez po 10%: ' . number_format($SamoPorez10, 2, '.', ''));
            $ele->appendChild($eleH);
        }
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('==============================');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('Operater: ' . $_COOKIE['UserName']);
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('==============================');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft(' ');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('Racun izdao: ');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('................................');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft(' ');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('Potpis kupca:');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('................................');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft(' ');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('Broj lične karte:');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('................................');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('==============================');
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('Datum prometa: ' . date('d.m.Y', strtotime($RacunData['datum'])));
        $ele->appendChild($eleH);
        $eleH = $doc->createElement('Linija');
        $eleH->nodeValue = FormatTextLeft('==============================');
        $ele->appendChild($eleH);
        $doc->appendChild($ele);
        $doc->save($SaveToReceipt . '/' . $NazivRacuna . ' .xml');
        echo json_encode(array('Status' => 'success', 'Message' => 'Gotovinski račun je poslat na štampu!'));
        die();
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Odabran je nepostojeći račun!'));
        die();
    }
    die();
}
if (isset($_POST['FiskalniIzvestajPresekStanja'])) {
    $TipFiscala = GetSettingVal('tipFiskala');
    if ($TipFiscala == 'efiscal') {
        $ZdVremeOd = "";
        $ZdVremeDo = date('Y-m-d H:i:s');
        $Vats = [];
        $GetVatData = mysqli_query($link, "SELECT * FROM poreske_stope WHERE 1 ORDER BY id ASC") or die(mysqli_error($link));
        if (mysqli_num_rows($GetVatData) > 0) {
            while ($rowVatData = mysqli_fetch_array($GetVatData)) {
                $Vats[$rowVatData['oznaka']] = $rowVatData['vrednost'];
            }
        }
        $SaleData = [];
        $RefundData = [];
        $VatData = [];
        $VatRefundData = [];
        $GetZds = mysqli_query($link, "SELECT zakljucenje, pocetak FROM zd ORDER BY zakljucenje DESC LIMIT 1") or die(mysqli_error($link));
        if (mysqli_num_rows($GetZds) == 1) {

            $ZdIn = "";
            $rowZD = mysqli_fetch_array($GetZds);
            if ($rowZD['pocetak'] == 1) {
                $ZdVremeOd = date('Y-m-d H:i:s', strtotime($rowZD['zakljucenje']));
            } else {
                $ZdVremeOd = $ZdVremeDo;
            }
            $GetSaleData = mysqli_query($link, "SELECT id FROM racun WHERE datum>='$ZdVremeOd' AND datum<='$ZdVremeDo' AND zatvoren=1") or die(mysqli_error($link));
            if (mysqli_num_rows($GetSaleData) > 0) {
                while ($rowSale = mysqli_fetch_array($GetSaleData)) {
					$CurrentTotal = 0;
					$GetStavkeProizvoda = mysqli_query($link,"SELECT a.poreskaGrupa, p.oznaka, p.vrednost, sr.naziv as name, sr.kolicina as quantity, sr.cena as unitPrice, 
															IF(a.dozvoljenPopust=0, sr.cena*sr.kolicina, sr.cena*sr.kolicina-(sr.cena*sr.kolicina*r.popust)/100) as totalAmount
															FROM racun r
															left join stavkaracuna sr on r.id=sr.racun_id
															left join artikal a on sr.artikal_id=a.id
															left join poreske_stope p on p.id = a.poreskaGrupa
															Where r.id=${rowSale['id']}") or die(mysqli_error($link));
					while ($rowStavkeProizvoda = mysqli_fetch_array($GetStavkeProizvoda)) {
						if(isset($rowStavkeProizvoda['totalAmount'])) {
							$Vat = $rowStavkeProizvoda['oznaka'];
							$Total = $rowStavkeProizvoda['totalAmount'];
							if ($Total < 0) {
								$Total = -1 * $Total;
							}
							$VatValue = $Vats[$Vat];
							$CurrentTotal = $CurrentTotal + $Total;
							if(!isset($VatData[$Vat]))
								$VatData[$Vat] = $Total;
							else
								$VatData[$Vat] = $VatData[$Vat] + $Total;
						}
					}
					$GetStavkePlacanja = mysqli_query($link,"SELECT iznos as amount, nacin as paymentType FROM placanje WHERE nacin<>'HOTELSKI' and nacin<>'REFUNDACIJA' and racun_id=${rowSale['id']}") or die(mysqli_error($link));
					while ($rowStavkePlacanja = mysqli_fetch_array($GetStavkePlacanja)) {
						if(isset($rowStavkePlacanja['amount'])) {
							$amount = $rowStavkePlacanja['amount'];
							if($Total > $amount) {
								$amount = $Total;
							}
							$paymentType = $rowStavkePlacanja['paymentType'];
							if(!isset($SaleData[$paymentType])) {
								$SaleData[$paymentType] = $amount;
							}
							else {
								$SaleData[$paymentType] = $SaleData[$paymentType] + $amount;
							}
						}
					}
                }
            }
        }
        $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1") or die(mysqli_error($link));
        if (mysqli_num_rows($GetStampacData) > 0) {
            $StampacData = mysqli_fetch_array($GetStampacData);
            if ($StampacData['tip'] == 'POSBANK80MM') {
                $PrinterLetters = 40;
            } else {
                $PrinterLetters = 30;
            }
            $PrintString = "";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $PrintString .= GetSettingVal("objekat.pib") . "\n";
            $PrintString .= GetSettingVal("objekat.naziv") . "\n";
            $PrintString .= GetSettingVal("objekat.mesto") . "\n";
            $PrintString .= GetSettingVal("objekat.adresa") . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $PrintString .= "Presek stanja: " . date('d.m.y H:i:s') . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $PrintString .= str_pad("PRODAJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $UkupnoProdaja = 0;
            foreach ($SaleData as $SaleType => $SaleTypeData) {
                $PaymentPrint = $SaleType;
                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                $UkupnoProdaja = $UkupnoProdaja + $SaleTypeData;
            }
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoProdaja, 2, '.', ''));
            $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoProdaja, 2, '.', '') . "\n";

            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $PrintString .= str_pad("PDV", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $UkupnoVat = 0;
            foreach ($VatData as $SaleType => $SaleTypeData) {
                $VatValue = $Vats[$SaleType];

                $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";

                $VatCalcValOsnovica = $SaleTypeData / (1 + ($VatValue / 100));
                $PaymentPrint = "Osnovica stopa " . $SaleType . " " . $VatValue . "%:";
                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcValOsnovica, 2, '.', ''));
                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcValOsnovica, 2, '.', '') . "\n";

                $VatCalcVal = $SaleTypeData - $VatCalcValOsnovica;
                $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                $UkupnoVat = $UkupnoVat + $SaleTypeData;
            }
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoVat, 2, '.', ''));
            $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoVat, 2, '.', '') . "\n";

            if (count($RefundData) > 0) {
                $UkupnoRefundacija = 0;
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                $PrintString .= str_pad("REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                foreach ($RefundData as $SaleType => $SaleTypeData) {
                    if ($SaleType == 'Cash') {
                        $PaymentPrint = "Gotovina:";
                    } elseif ($SaleType == 'Card') {
                        $PaymentPrint = "Platna kartica:";
                    } elseif ($SaleType == 'Check') {
                        $PaymentPrint = "Ček:";
                    } elseif ($SaleType == 'WireTransfer') {
                        $PaymentPrint = "Prenos na račun:";
                    } elseif ($SaleType == 'MobileMoney') {
                        $PaymentPrint = "Mobilni novac:";
                    } elseif ($SaleType == 'Voucher') {
                        $PaymentPrint = "Vaučer:";
                    } elseif ($SaleType == 'Other') {
                        $PaymentPrint = "Dr. bezgot. plaćanje:";
                    }
                    $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                    $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                    $UkupnoRefundacija = $UkupnoRefundacija + $SaleTypeData;
                }
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacija, 2, '.', ''));
                $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacija, 2, '.', '') . "\n";
            }
            if (count($VatRefundData)) {
                $UkupnoRefundacijaVat = 0;
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                $PrintString .= str_pad("PDV REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                foreach ($VatRefundData as $SaleType => $SaleTypeData) {
                    $VatValue = $Vats[$SaleType];

                    $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                    $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                    $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";

                    $VatCalcValOsnovica = $SaleTypeData / (1 + ($VatValue / 100));
                    $PaymentPrint = "Osnovica stopa " . $SaleType . " " . $VatValue . "%:";
                    $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcValOsnovica, 2, '.', ''));
                    $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcValOsnovica, 2, '.', '') . "\n";

                    $VatCalcVal = $SaleTypeData - $VatCalcValOsnovica;
                    $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                    $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                    $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                    $UkupnoRefundacijaVat = $UkupnoRefundacijaVat + $SaleTypeData;
                }
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacijaVat, 2, '.', ''));
                $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacijaVat, 2, '.', '') . "\n";
            }
            try {
                // Enter the share name for your USB printer here
                $NazivStampaca = $StampacData['naziv'];
                if (strpos($NazivStampaca, "/")) {
                    $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                } else {
                    $connector = new WindowsPrintConnector($NazivStampaca);
                }
                $printer = new Printer($connector);
                $printer->pulse(1, 300, 300);
                $printer->setPrintLeftMargin(0);
                $printer->setJustification(Printer::JUSTIFY_LEFT);
                $printer->text($PrintString);
                $printer->feed();
                $printer->cut();
                $printer->close();
            } catch (Exception $e) {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                die();
            }
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Nema podešenih štampača za štampu izveštaja!'));
            die();
        }
    } else {
        $NazivDokumenta = 'IzvestajFIPS' . date('Y-m-d-H-i-s');
        $doc = new DOMDocument('1.0', 'UTF-8');
        $doc->preserveWhiteSpace = false;
        $doc->formatOutput = true;
        $ele = $doc->createElement('Izvestaj');
        $ele->nodeValue = "1";
        $doc->appendChild($ele);
        $doc->save($SaveToReceipt . '/' . $NazivDokumenta . ' .xml');
    }
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Presek stanja poslat na stampu Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    echo json_encode(array('Status' => 'success', 'Message' => 'Presek stanja je poslat na štampu!'));
    die();
}
if (isset($_POST['FiskalniIzvestajDnevniIzvestaj'])) {
    $UradiKraj = 0;
    if ($KasaData['iskljucena_provera_stolova'] == 'false') {
        $GetTables = mysqli_query($link, "SELECT * FROM racun WHERE zatvoren=0");
        if (mysqli_num_rows($GetTables) > 0) {
            while ($rowTables = mysqli_fetch_array($GetTables)) {
                $RacunId = $rowTables['id'];
                $GetArtikle = mysqli_query($link, "SELECT * FROM stavkaracuna WHERE RACUN_ID='$RacunId'");
                if (mysqli_num_rows($GetArtikle) > 0) {
                    $UradiKraj = 1;
                }
            }
        }
        $LogWhat = "Pokusano zatvaranje dana sa otvorenim stolovima";
    }
    if ($UradiKraj == 0) {

        $TipFiscala = GetSettingVal('tipFiskala');
        if ($KasaData['prodati_artikli'] > 0) {
            if ($TipFiscala != 'efiscal') {
                //Prodati artikli
                for ($i = 0; $i < $KasaData['prodati_artikli']; $i++) {
                    $NazivDokumenta = 'IzvestajAFIPA' . date('Y-m-d-H-i-s');
                    $doc = new DOMDocument('1.0', 'UTF-8');
                    $doc->preserveWhiteSpace = false;
                    $doc->formatOutput = true;
                    $ele = $doc->createElement('Izvestaj');
                    $ele->nodeValue = "2";
                    $doc->appendChild($ele);
                    $doc->save($SaveToReceipt . '/' . $NazivDokumenta . '_' . $i . '.xml');
                }
                sleep(2);
            }
        }
        if ($KasaData['presek_stanja'] > 0) {
            //Presek
            for ($i = 0; $i < $KasaData['presek_stanja']; $i++) {
                if ($TipFiscala == 'efiscal') {
                    $ZdVremeOd = "";
                    $ZdVremeDo = date('Y-m-d H:i:s');
                    $Vats = [];
                    $GetVatData = mysqli_query($link, "SELECT * FROM poreske_stope WHERE 1 ORDER BY id ASC") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetVatData) > 0) {
                        while ($rowVatData = mysqli_fetch_array($GetVatData)) {
                            $Vats[$rowVatData['oznaka']] = $rowVatData['vrednost'];
                        }
                    }
                    $SaleData = [];
                    $RefundData = [];
                    $VatData = [];
                    $VatRefundData = [];
                    $GetZds = mysqli_query($link, "SELECT zakljucenje, pocetak FROM zd ORDER BY zakljucenje DESC LIMIT 1") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetZds) == 1) {

                        $ZdIn = "";
                        $rowZD = mysqli_fetch_array($GetZds);
                        if ($rowZD['pocetak'] == 1) {
                            $ZdVremeOd = date('Y-m-d H:i:s', strtotime($rowZD['zakljucenje']));
                        } else {
                            $ZdVremeOd = $ZdVremeDo;
                        }
                        $GetSaleData = mysqli_query($link, "SELECT id FROM racun WHERE datum>='$ZdVremeOd' AND datum<='$ZdVremeDo' AND zatvoren=1") or die(mysqli_error($link));
						if (mysqli_num_rows($GetSaleData) > 0) {
							while ($rowSale = mysqli_fetch_array($GetSaleData)) {
								$CurrentTotal = 0;
								$GetStavkeProizvoda = mysqli_query($link,"SELECT a.poreskaGrupa, p.oznaka, p.vrednost, sr.naziv as name, sr.kolicina as quantity, sr.cena as unitPrice, 
																		IF(a.dozvoljenPopust=0, sr.cena*sr.kolicina, sr.cena*sr.kolicina-(sr.cena*sr.kolicina*r.popust)/100) as totalAmount 
																		FROM racun r
																		left join stavkaracuna sr on r.id=sr.racun_id
																		left join artikal a on sr.artikal_id=a.id
																		left join poreske_stope p on p.id = a.poreskaGrupa
																		Where r.id=${rowSale['id']}") or die(mysqli_error($link));
								while ($rowStavkeProizvoda = mysqli_fetch_array($GetStavkeProizvoda)) {
									if(isset($rowStavkeProizvoda['totalAmount'])) {
										$Vat = $rowStavkeProizvoda['oznaka'];
										$Total = $rowStavkeProizvoda['totalAmount'];
										if ($Total < 0) {
											$Total = -1 * $Total;
										}
										$VatValue = $Vats[$Vat];
										$CurrentTotal = $CurrentTotal + $Total;
										if(!isset($VatData[$Vat]))
											$VatData[$Vat] = $Total;
										else
											$VatData[$Vat] = $VatData[$Vat] + $Total;
									}
								}
								$GetStavkePlacanja = mysqli_query($link,"SELECT iznos as amount, nacin as paymentType FROM placanje WHERE nacin<>'HOTELSKI' and nacin<>'REFUNDACIJA' and racun_id=${rowSale['id']}") or die(mysqli_error($link));
								while ($rowStavkePlacanja = mysqli_fetch_array($GetStavkePlacanja)) {
									if(isset($rowStavkePlacanja['amount'])) {
										$amount = $rowStavkePlacanja['amount'];
										if($Total > $amount) {
											$amount = $Total;
										}
										$paymentType = $rowStavkePlacanja['paymentType'];
										if(!isset($SaleData[$paymentType])) {
											$SaleData[$paymentType] = $amount;
										}
										else {
											$SaleData[$paymentType] = $SaleData[$paymentType] + $amount;
										}
									}
								}
							}
						}
                    }
                    $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetStampacData) > 0) {
                        $StampacData = mysqli_fetch_array($GetStampacData);
                        if ($StampacData['tip'] == 'POSBANK80MM') {
                            $PrinterLetters = 40;
                        } else {
                            $PrinterLetters = 30;
                        }
                        $PrintString = "";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $PrintString .= GetSettingVal("objekat.pib") . "\n";
                        $PrintString .= GetSettingVal("objekat.naziv") . "\n";
                        $PrintString .= GetSettingVal("objekat.mesto") . "\n";
                        $PrintString .= GetSettingVal("objekat.adresa") . "\n";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $PrintString .= "Presek stanja: " . date('d.m.y H:i:s') . "\n";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $PrintString .= str_pad("PRODAJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $UkupnoProdaja = 0;
                        foreach ($SaleData as $SaleType => $SaleTypeData) {
                            $PaymentPrint = $SaleType;
                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                            $UkupnoProdaja = $UkupnoProdaja + $SaleTypeData;
                        }
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoProdaja, 2, '.', ''));
                        $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoProdaja, 2, '.', '') . "\n";

                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $PrintString .= str_pad("PDV", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $UkupnoVat = 0;
                        foreach ($VatData as $SaleType => $SaleTypeData) {
                            $VatValue = $Vats[$SaleType];

                            $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";

                            $VatCalcValOsnovica = $SaleTypeData / (1 + ($VatValue / 100));
                            $PaymentPrint = "Osnovica stopa " . $SaleType . " " . $VatValue . "%:";
                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcValOsnovica, 2, '.', ''));
                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcValOsnovica, 2, '.', '') . "\n";

                            $VatCalcVal = $SaleTypeData - $VatCalcValOsnovica;
                            $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                            $UkupnoVat = $UkupnoVat + $SaleTypeData;
                        }
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoVat, 2, '.', ''));
                        $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoVat, 2, '.', '') . "\n";

                        if (count($RefundData) > 0) {
                            $UkupnoRefundacija = 0;
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            $PrintString .= str_pad("REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            foreach ($RefundData as $SaleType => $SaleTypeData) {
                                if ($SaleType == 'Cash') {
                                    $PaymentPrint = "Gotovina:";
                                } elseif ($SaleType == 'Card') {
                                    $PaymentPrint = "Platna kartica:";
                                } elseif ($SaleType == 'Check') {
                                    $PaymentPrint = "Ček:";
                                } elseif ($SaleType == 'WireTransfer') {
                                    $PaymentPrint = "Prenos na račun:";
                                } elseif ($SaleType == 'MobileMoney') {
                                    $PaymentPrint = "Mobilni novac:";
                                } elseif ($SaleType == 'Voucher') {
                                    $PaymentPrint = "Vaučer:";
                                } elseif ($SaleType == 'Other') {
                                    $PaymentPrint = "Dr. bezgot. plaćanje:";
                                }
                                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                                $UkupnoRefundacija = $UkupnoRefundacija + $SaleTypeData;
                            }
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacija, 2, '.', ''));
                            $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacija, 2, '.', '') . "\n";
                        }
                        if (count($VatRefundData)) {
                            $UkupnoRefundacijaVat = 0;
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            $PrintString .= str_pad("PDV REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            foreach ($VatRefundData as $SaleType => $SaleTypeData) {
                                $VatValue = $Vats[$SaleType];

                                $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";

                                $VatCalcValOsnovica = $SaleTypeData / (1 + ($VatValue / 100));
                                $PaymentPrint = "Osnovica stopa " . $SaleType . " " . $VatValue . "%:";
                                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcValOsnovica, 2, '.', ''));
                                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcValOsnovica, 2, '.', '') . "\n";

                                $VatCalcVal = $SaleTypeData - $VatCalcValOsnovica;
                                $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                                $UkupnoRefundacijaVat = $UkupnoRefundacijaVat + $SaleTypeData;
                            }
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacijaVat, 2, '.', ''));
                            $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacijaVat, 2, '.', '') . "\n";
                        }
                        try {
                            // Enter the share name for your USB printer here
                            $NazivStampaca = $StampacData['naziv'];
                            if (strpos($NazivStampaca, "/")) {
                                $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                            } else {
                                $connector = new WindowsPrintConnector($NazivStampaca);
                            }
                            $printer = new Printer($connector);
                            $printer->pulse(1, 300, 300);
                            $printer->setPrintLeftMargin(0);
                            $printer->setJustification(Printer::JUSTIFY_LEFT);
                            $printer->text($PrintString);
                            $printer->feed();
                            $printer->cut();
                            $printer->close();
                        } catch (Exception $e) {
                            echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                            die();
                        }
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nema podešenih štampača za štampu izveštaja!'));
                        die();
                    }
                } else {
                    $NazivDokumenta = 'IzvestajBFIPS' . date('Y-m-d-H-i-s');
                    $doc2 = new DOMDocument('1.0', 'UTF-8');
                    $doc2->preserveWhiteSpace = false;
                    $doc2->formatOutput = true;
                    $ele = $doc2->createElement('Izvestaj');
                    $ele->nodeValue = "1";
                    $doc2->appendChild($ele);
                    $doc2->save($SaveToReceipt . '/' . $NazivDokumenta . '_' . $i . '.xml');
                }
            }
            sleep(2);
        }
        if ($KasaData['dnevni_izvestaj'] > 0) {
            //Presek
            for ($i = 0; $i < $KasaData['dnevni_izvestaj']; $i++) {
                if ($TipFiscala == 'efiscal') {
                    $ZdVremeOd = "";
                    $ZdVremeDo = date('Y-m-d H:i:s');
                    $Vats = [];
                    $GetVatData = mysqli_query($link, "SELECT * FROM poreske_stope WHERE 1 ORDER BY id ASC") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetVatData) > 0) {
                        while ($rowVatData = mysqli_fetch_array($GetVatData)) {
                            $Vats[$rowVatData['oznaka']] = $rowVatData['vrednost'];
                        }
                    }
                    $SaleData = [];
                    $RefundData = [];
                    $VatData = [];
                    $VatRefundData = [];
                    $GetZds = mysqli_query($link, "SELECT zakljucenje, pocetak, datum FROM zd ORDER BY zakljucenje DESC LIMIT 1") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetZds) == 1) {
                        $ZdDatum = date('d.m.Y');
                        $rowZD = mysqli_fetch_array($GetZds);
                        if ($rowZD['pocetak'] == 1) {
                            $ZdVremeOd = date('Y-m-d H:i:s', strtotime($rowZD['zakljucenje']));
                            $ZdDatum = date('d.m.Y', strtotime($rowZD['datum']));
                        } else {
                            $ZdVremeOd = $ZdVremeDo;
                        }
                        $GetSaleData = mysqli_query($link, "SELECT id FROM racun WHERE datum>='$ZdVremeOd' AND datum<='$ZdVremeDo' AND zatvoren=1") or die(mysqli_error($link));
						if (mysqli_num_rows($GetSaleData) > 0) {
							while ($rowSale = mysqli_fetch_array($GetSaleData)) {
								$CurrentTotal = 0;
								$GetStavkeProizvoda = mysqli_query($link,"SELECT a.poreskaGrupa, p.oznaka, p.vrednost, sr.naziv as name, sr.kolicina as quantity, sr.cena as unitPrice, 
																		IF(a.dozvoljenPopust=0, sr.cena*sr.kolicina, sr.cena*sr.kolicina-(sr.cena*sr.kolicina*r.popust)/100) as totalAmount
																		FROM racun r
																		left join stavkaracuna sr on r.id=sr.racun_id
																		left join artikal a on sr.artikal_id=a.id
																		left join poreske_stope p on p.id = a.poreskaGrupa
																		Where r.id=${rowSale['id']}") or die(mysqli_error($link));
								while ($rowStavkeProizvoda = mysqli_fetch_array($GetStavkeProizvoda)) {
									if(isset($rowStavkeProizvoda['totalAmount'])) {
										$Vat = $rowStavkeProizvoda['oznaka'];
										$Total = $rowStavkeProizvoda['totalAmount'];
										if ($Total < 0) {
											$Total = -1 * $Total;
										}
										$VatValue = $Vats[$Vat];
										$CurrentTotal = $CurrentTotal + $Total;
										if(!isset($VatData[$Vat]))
											$VatData[$Vat] = $Total;
										else
											$VatData[$Vat] = $VatData[$Vat] + $Total;
									}
								}
								$GetStavkePlacanja = mysqli_query($link,"SELECT iznos as amount, nacin as paymentType FROM placanje WHERE nacin<>'HOTELSKI' and nacin<>'REFUNDACIJA' and racun_id=${rowSale['id']}") or die(mysqli_error($link));
								while ($rowStavkePlacanja = mysqli_fetch_array($GetStavkePlacanja)) {
									if(isset($rowStavkePlacanja['amount'])) {
										$amount = $rowStavkePlacanja['amount'];
										if($Total > $amount) {
											$amount = $Total;
										}
										$paymentType = $rowStavkePlacanja['paymentType'];
										if(!isset($SaleData[$paymentType])) {
											$SaleData[$paymentType] = $amount;
										}
										else {
											$SaleData[$paymentType] = $SaleData[$paymentType] + $amount;
										}
									}
								}
							}
						}
                    }
                    $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetStampacData) > 0) {
                        $StampacData = mysqli_fetch_array($GetStampacData);
                        if ($StampacData['tip'] == 'POSBANK80MM') {
                            $PrinterLetters = 40;
                        } else {
                            $PrinterLetters = 30;
                        }
                        $PrintString = "";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $PrintString .= GetSettingVal("objekat.pib") . "\n";
                        $PrintString .= GetSettingVal("objekat.naziv") . "\n";
                        $PrintString .= GetSettingVal("objekat.mesto") . "\n";
                        $PrintString .= GetSettingVal("objekat.adresa") . "\n";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $PrintString .= "Dnevni izveštaj: " . date('d.m.y', strtotime($ZdDatum)) . "\n";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $PrintString .= str_pad("PRODAJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $UkupnoProdaja = 0;
                        foreach ($SaleData as $SaleType => $SaleTypeData) {
                            $PaymentPrint = $SaleType;
                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                            $UkupnoProdaja = $UkupnoProdaja + $SaleTypeData;
                        }
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoProdaja, 2, '.', ''));
                        $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoProdaja, 2, '.', '') . "\n";

                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $PrintString .= str_pad("PDV", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $UkupnoVat = 0;
                        foreach ($VatData as $SaleType => $SaleTypeData) {
                            $VatValue = $Vats[$SaleType];

                            $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";

                            $VatCalcValOsnovica = $SaleTypeData / (1 + ($VatValue / 100));
                            $PaymentPrint = "Osnovica stopa " . $SaleType . " " . $VatValue . "%:";
                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcValOsnovica, 2, '.', ''));
                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcValOsnovica, 2, '.', '') . "\n";

                            $VatCalcVal = $SaleTypeData - $VatCalcValOsnovica;
                            $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                            $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                            $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                            $UkupnoVat = $UkupnoVat + $SaleTypeData;
                        }
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                        $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoVat, 2, '.', ''));
                        $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoVat, 2, '.', '') . "\n";

                        if (count($RefundData) > 0) {
                            $UkupnoRefundacija = 0;
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            $PrintString .= str_pad("REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            foreach ($RefundData as $SaleType => $SaleTypeData) {
                                if ($SaleType == 'Cash') {
                                    $PaymentPrint = "Gotovina:";
                                } elseif ($SaleType == 'Card') {
                                    $PaymentPrint = "Platna kartica:";
                                } elseif ($SaleType == 'Check') {
                                    $PaymentPrint = "Ček:";
                                } elseif ($SaleType == 'WireTransfer') {
                                    $PaymentPrint = "Prenos na račun:";
                                } elseif ($SaleType == 'MobileMoney') {
                                    $PaymentPrint = "Mobilni novac:";
                                } elseif ($SaleType == 'Voucher') {
                                    $PaymentPrint = "Vaučer:";
                                } elseif ($SaleType == 'Other') {
                                    $PaymentPrint = "Dr. bezgot. plaćanje:";
                                }
                                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                                $UkupnoRefundacija = $UkupnoRefundacija + $SaleTypeData;
                            }
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacija, 2, '.', ''));
                            $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacija, 2, '.', '') . "\n";
                        }
                        if (count($VatRefundData)) {
                            $UkupnoRefundacijaVat = 0;
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            $PrintString .= str_pad("PDV REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            foreach ($VatRefundData as $SaleType => $SaleTypeData) {
                                $VatValue = $Vats[$SaleType];

                                $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";

                                $VatCalcValOsnovica = $SaleTypeData / (1 + ($VatValue / 100));
                                $PaymentPrint = "Osnovica stopa " . $SaleType . " " . $VatValue . "%:";
                                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcValOsnovica, 2, '.', ''));
                                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcValOsnovica, 2, '.', '') . "\n";

                                $VatCalcVal = $SaleTypeData - $VatCalcValOsnovica;
                                $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                                $UkupnoRefundacijaVat = $UkupnoRefundacijaVat + $SaleTypeData;
                            }
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                            $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacijaVat, 2, '.', ''));
                            $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacijaVat, 2, '.', '') . "\n";
                        }
                        try {
                            // Enter the share name for your USB printer here
                            $NazivStampaca = $StampacData['naziv'];
                            if (strpos($NazivStampaca, "/")) {
                                $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                            } else {
                                $connector = new WindowsPrintConnector($NazivStampaca);
                            }
                            $printer = new Printer($connector);
                            $printer->pulse(1, 300, 300);
                            $printer->setPrintLeftMargin(0);
                            $printer->setJustification(Printer::JUSTIFY_LEFT);
                            $printer->text($PrintString);
                            $printer->feed();
                            $printer->cut();
                            $printer->close();
                        } catch (Exception $e) {
                            echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                            die();
                        }
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nema podešenih štampača za štampu izveštaja!'));
                        die();
                    }
                } else {
                    $NazivDokumenta = 'IzvestajZFIDI' . date('Y-m-d-H-i-s');
                    $doc3 = new DOMDocument('1.0', 'UTF-8');
                    $doc3->preserveWhiteSpace = false;
                    $doc3->formatOutput = true;
                    $ele = $doc3->createElement('Izvestaj');
                    $ele->nodeValue = "0";
                    $doc3->appendChild($ele);
                    $doc3->save($SaveToReceipt . '/' . $NazivDokumenta . '_' . $i . '.xml');
                }
            }
        }
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Zatvoren dan";
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
        if ($KasaData['softversko_zakljucenje'] == 'true') {
            if (GetSettingVal('objekat.24h.radno.vreme') == 'true') {
                $GetLastWd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY datum DESC LIMIT 1");
                if (mysqli_num_rows($GetLastWd) == 1) {
                    $LastZdData = mysqli_fetch_array($GetLastWd);
                    $ZdBroj = $LastZdData['zdBroj'];
                    $OpenMax = date('Y-m-d', strtotime('+1 days'));
                    $LastZd = $LastZdData['datum'];
                    $CloseTime = date('H:i:s');
                    $OpenTime = date('H:i:s', strtotime('+1 seconds'));
                    if (strtotime($LastZd) < strtotime($OpenMax)) {
                        while (strtotime($LastZd) < strtotime($OpenMax)) {
                            $DateToHandle = $LastZd;
                            $DateToOpen = date('Y-m-d', strtotime($DateToHandle . ' +1 days'));
                            $TimeToClose = date('Y-m-d ' . $CloseTime . '', strtotime($DateToOpen));
                            $TimeToOpen = date('Y-m-d ' . $OpenTime . '', strtotime($DateToOpen));
                            if (strtotime($TimeToClose) > time()) {
                                $TimeToClose = date('Y-m-d H:i:s');
                                $TimeToOpen = date('Y-m-d H:i:s', strtotime('+1 seconds'));
                            }
                            $IsExist = mysqli_query($link, "SELECT * FROM zd WHERE datum='$DateToHandle' AND pocetak=0 LIMIT 1");
                            if (mysqli_num_rows($IsExist) == 0) {
                                mysqli_query($link, "INSERT INTO zd (datum, pocetak, zakljucenje, zdBroj) VALUES ('$DateToHandle', 0, '$TimeToClose', '$ZdBroj')");
                            }
                            $ZdBroj++;
                            $IsExist2 = mysqli_query($link, "SELECT * FROM zd WHERE datum='$DateToOpen' AND pocetak=1 LIMIT 1");
                            if (mysqli_num_rows($IsExist2) == 0) {
                                mysqli_query($link, "INSERT INTO zd (datum, pocetak, zakljucenje, zdBroj) VALUES ('$DateToOpen', 1, '$TimeToOpen', '$ZdBroj')");
                            }
                            $LastZd = $DateToOpen;
                        }
                    }
                } else {
                    mysqli_query($link, "INSERT INTO zd (datum, pocetak, zakljucenje, zdBroj) VALUES (now(), 1, now(), '1')");
                }
            }
        }
        $GetEvidencija = mysqli_query($link, "SELECT * FROM evidencijazaposlenih WHERE odjavljen=0");
        if (mysqli_num_rows($GetEvidencija) > 0) {
            while ($rowEvidencija = mysqli_fetch_array($GetEvidencija)) {
                $EvidencijaId = $rowEvidencija['id'];
                $EvidencijaVremePrijave = $rowEvidencija['dolazak'];
                $EvidencijaOdjavi = date('Y-m-d H:i:s', strtotime($EvidencijaVremePrijave . "  + 1 minute"));
                mysqli_query($link, "UPDATE evidencijazaposlenih SET odjavljen=1, odlazak='$EvidencijaOdjavi' WHERE id='$EvidencijaId'");
            }
        }
        echo json_encode(array('Status' => 'success', 'Message' => 'Izveštaj je poslat na štampu!!!'));
        die();
    } else {
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = "LOGIN";
        $LogWhat = "Pokusano zatvaranje dana sa otvorenim stolovima";
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
        echo json_encode(array('Status' => 'error', 'Message' => 'Najpre zatvorite otvorene stolove!!!', 'Location' => '', 'Action' => ''));
        die();
    }
}
if (isset($_POST['DatumPresekDo']) && isset($_POST['DatumPresekOd'])) {
    $FromDate = date('d.m.y', strtotime($_POST['DatumPresekOd']));
    $ToDate = date('d.m.y', strtotime($_POST['DatumPresekDo']));
    $TipFiscala = GetSettingVal('tipFiskala');
    if ($TipFiscala == 'efiscal') {
        $DatumOd = date('Y-m-d', strtotime($_POST['DatumPresekOd']));
        $DatumDo = date('Y-m-d', strtotime($_POST['DatumPresekDo']));
        $ZdVremeOd = "";
        //$ZdVremeDo = date('Y-m-d H:i:s');
        $Vats = [];
        $GetVatData = mysqli_query($link, "SELECT * FROM poreske_stope WHERE 1 ORDER BY id ASC") or die(mysqli_error($link));
        if (mysqli_num_rows($GetVatData) > 0) {
            while ($rowVatData = mysqli_fetch_array($GetVatData)) {
                $Vats[$rowVatData['oznaka']] = $rowVatData['vrednost'];
            }
        }
        $SaleData = [];
        $RefundData = [];
        $VatData = [];
        $VatRefundData = [];
        $GetZds = mysqli_query($link, "SELECT zakljucenje FROM zd WHERE datum>='$DatumOd' AND datum<='$DatumDo' ORDER BY id ASC") or die(mysqli_error($link));
        if (mysqli_num_rows($GetZds) > 0) {
            $ZdIn = "";
            while ($rowZD = mysqli_fetch_array($GetZds)) {
                if ($ZdVremeOd == "") {
                    $ZdVremeOd = date('Y-m-d H:i:s', strtotime($rowZD['zakljucenje']));
                }
                if ($rowZD['zakljucenje'] != '') {
                    if (strtotime($rowZD['zakljucenje']) > strtotime($ZdVremeDo)) {
                        $ZdVremeDo = date('Y-m-d H:i:s', strtotime($rowZD['zakljucenje']));
                    }
                }
            }
            $GetSaleData = mysqli_query($link, "SELECT id FROM racun WHERE datum>='$ZdVremeOd' AND datum<='$ZdVremeDo' AND zatvoren=1") or die(mysqli_error($link));
            if (mysqli_num_rows($GetSaleData) > 0) {
                while ($rowSale = mysqli_fetch_array($GetSaleData)) {
					$CurrentTotal = 0;
					$GetStavkeProizvoda = mysqli_query($link,"SELECT a.poreskaGrupa, p.oznaka, p.vrednost, sr.naziv as name, sr.kolicina as quantity, sr.cena as unitPrice, 
															IF(a.dozvoljenPopust=0, sr.cena*sr.kolicina, sr.cena*sr.kolicina-(sr.cena*sr.kolicina*r.popust)/100) as totalAmount 
															FROM racun r
															left join stavkaracuna sr on r.id=sr.racun_id
															left join artikal a on sr.artikal_id=a.id
															left join poreske_stope p on p.id = a.poreskaGrupa
															Where r.id=${rowSale['id']}") or die(mysqli_error($link));
					while ($rowStavkeProizvoda = mysqli_fetch_array($GetStavkeProizvoda)) {
						if(isset($rowStavkeProizvoda['totalAmount'])) {
							$Vat = $rowStavkeProizvoda['oznaka'];
							$Total = $rowStavkeProizvoda['totalAmount'];
							if ($Total < 0) {
								$Total = -1 * $Total;
							}
							$VatValue = $Vats[$Vat];
							$CurrentTotal = $CurrentTotal + $Total;
							if(!isset($VatData[$Vat]))
								$VatData[$Vat] = $Total;
							else
								$VatData[$Vat] = $VatData[$Vat] + $Total;
						}
					}
					$GetStavkePlacanja = mysqli_query($link,"SELECT iznos as amount, nacin as paymentType FROM placanje WHERE nacin<>'HOTELSKI' and nacin<>'REFUNDACIJA' and racun_id=${rowSale['id']}") or die(mysqli_error($link));
					while ($rowStavkePlacanja = mysqli_fetch_array($GetStavkePlacanja)) {
						if(isset($rowStavkePlacanja['amount'])) {
							$amount = $rowStavkePlacanja['amount'];
							if($Total > $amount) {
								$amount = $Total;
							}
							$paymentType = $rowStavkePlacanja['paymentType'];
							if(!isset($SaleData[$paymentType])) {
								$SaleData[$paymentType] = $amount;
							}
							else {
								$SaleData[$paymentType] = $SaleData[$paymentType] + $amount;
							}
						}
					}
                }
            }
        }
        $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1") or die(mysqli_error($link));
        if (mysqli_num_rows($GetStampacData) > 0) {
            $StampacData = mysqli_fetch_array($GetStampacData);
            if ($StampacData['tip'] == 'POSBANK80MM') {
                $PrinterLetters = 40;
            } else {
                $PrinterLetters = 30;
            }

            $PrintString = "";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $PrintString .= GetSettingVal("objekat.pib") . "\n";
            $PrintString .= GetSettingVal("objekat.naziv") . "\n";
            $PrintString .= GetSettingVal("objekat.mesto") . "\n";
            $PrintString .= GetSettingVal("objekat.adresa") . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $PrintString .= "Periodični izveštaj za period: " . $FromDate . "-" . $ToDate . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $PrintString .= str_pad("PRODAJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $UkupnoProdaja = 0;
            foreach ($SaleData as $SaleType => $SaleTypeData) {
                $PaymentPrint = $SaleType;
                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                $UkupnoProdaja = $UkupnoProdaja + $SaleTypeData;
            }
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoProdaja, 2, '.', ''));
            $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoProdaja, 2, '.', '') . "\n";

            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $PrintString .= str_pad("PDV", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $UkupnoVat = 0;
            foreach ($VatData as $SaleType => $SaleTypeData) {

                $VatValue = $Vats[$SaleType];

                $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";

                $VatCalcValOsnovica = $SaleTypeData / (1 + ($VatValue / 100));
                $PaymentPrint = "Osnovica stopa " . $SaleType . " " . $VatValue . "%:";
                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcValOsnovica, 2, '.', ''));
                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcValOsnovica, 2, '.', '') . "\n";

                $VatCalcVal = $SaleTypeData - $VatCalcValOsnovica;
                $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                $UkupnoVat = $UkupnoVat + $SaleTypeData;
            }
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
            $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoVat, 2, '.', ''));
            $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoVat, 2, '.', '') . "\n";

            if (count($RefundData) > 0) {
                $UkupnoRefundacija = 0;
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                $PrintString .= str_pad("REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                foreach ($RefundData as $SaleType => $SaleTypeData) {
                    if ($SaleType == 'Cash') {
                        $PaymentPrint = "Gotovina:";
                    } elseif ($SaleType == 'Card') {
                        $PaymentPrint = "Platna kartica:";
                    } elseif ($SaleType == 'Check') {
                        $PaymentPrint = "Ček:";
                    } elseif ($SaleType == 'WireTransfer') {
                        $PaymentPrint = "Prenos na račun:";
                    } elseif ($SaleType == 'MobileMoney') {
                        $PaymentPrint = "Mobilni novac:";
                    } elseif ($SaleType == 'Voucher') {
                        $PaymentPrint = "Vaučer:";
                    } elseif ($SaleType == 'Other') {
                        $PaymentPrint = "Dr. bezgot. plaćanje:";
                    }
                    $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                    $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";
                    $UkupnoRefundacija = $UkupnoRefundacija + $SaleTypeData;
                }
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacija, 2, '.', ''));
                $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacija, 2, '.', '') . "\n";
            }
            if (count($VatRefundData)) {
                $UkupnoRefundacijaVat = 0;
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                $PrintString .= str_pad("PDV REFUNDACIJA", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                foreach ($VatRefundData as $SaleType => $SaleTypeData) {
                    $VatValue = $Vats[$SaleType];
                    $PaymentPrint = "Iznos stopa " . $SaleType . " " . $VatValue . "%:";
                    $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($SaleTypeData, 2, '.', ''));
                    $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($SaleTypeData, 2, '.', '') . "\n";

                    $VatCalcValOsnovica = $SaleTypeData / (1 + ($VatValue / 100));
                    $PaymentPrint = "Osnovica stopa " . $SaleType . " " . $VatValue . "%:";
                    $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcValOsnovica, 2, '.', ''));
                    $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcValOsnovica, 2, '.', '') . "\n";

                    $VatCalcVal = $SaleTypeData - $VatCalcValOsnovica;
                    $PaymentPrint = "PDV stopa " . $SaleType . " " . $VatValue . "%:";
                    $AddPadd = $PrinterLetters - mb_strlen($PaymentPrint . "" . number_format($VatCalcVal, 2, '.', ''));
                    $PrintString .= $PaymentPrint . "" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($VatCalcVal, 2, '.', '') . "\n";
                    $UkupnoRefundacijaVat = $UkupnoRefundacijaVat + $SaleTypeData;
                }
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_LEFT) . "\n";
                $AddPadd = $PrinterLetters - mb_strlen("UKUPNO:" . number_format($UkupnoRefundacijaVat, 2, '.', ''));
                $PrintString .= "UKUPNO:" . str_pad(" ", $AddPadd, " ", STR_PAD_LEFT) . "" . number_format($UkupnoRefundacijaVat, 2, '.', '') . "\n";
            }
            try {
                // Enter the share name for your USB printer here
                $NazivStampaca = $StampacData['naziv'];
                if (strpos($NazivStampaca, "/")) {
                    $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                } else {
                    $connector = new WindowsPrintConnector($NazivStampaca);
                }
                $printer = new Printer($connector);
                $printer->pulse(1, 300, 300);
                $printer->setPrintLeftMargin(0);
                $printer->setJustification(Printer::JUSTIFY_LEFT);
                $printer->text($PrintString);
                $printer->feed();
                $printer->cut();
                $printer->close();
            } catch (Exception $e) {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                die();
            }
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Nema podešenih štampača za štampu izveštaja!'));
            die();
        }
    } else {
        $NazivDokumenta = 'IzvestajFIIZ' . date('Y-m-d-H-i-s');
        $doc = new DOMDocument('1.0', 'UTF-8');
        $doc->preserveWhiteSpace = false;
        $doc->formatOutput = true;
        $ele = $doc->createElement('Periodicni');
        $eleH = $doc->createElement('FromDate');
        $eleH->nodeValue = $FromDate;
        $ele->appendChild($eleH);

        $eleH = $doc->createElement('ToDate');
        $eleH->nodeValue = $ToDate;
        $ele->appendChild($eleH);

        $doc->appendChild($ele);
        $doc->save($SaveToReceipt . '/' . $NazivDokumenta . ' .xml');
    }
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Periodicni izvestaj poslat na stampu Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    echo json_encode(array('Status' => 'success', 'Message' => 'Periodični izveštaj je poslat na štampu!'));
    die();
}
if (isset($_POST['PregledSvihRacuna'])) {
    $DatumOd = date('Y-m-d H:i:s', strtotime('-1 days'));
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Pregled svih racuna Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    $GetRacune = mysqli_query($link, "SELECT SUM(p.iznos) as iznos, p.nacin, r.*  FROM racun r, placanje p WHERE r.datum>='$DatumOd' AND r.id=p.RACUN_ID AND r.zatvoren=1 GROUP BY p.RACUN_ID ORDER BY r.datum DESC") or die(mysqli_error($link));
    if (mysqli_num_rows($GetRacune) > 0) {
        $HtmlRacuni = "";
        $Operateri = [];
        $GetOperateri = mysqli_query($link, "SELECT * FROM konobar");
        if (mysqli_num_rows($GetOperateri)) {
            while ($rowOperateri = mysqli_fetch_array($GetOperateri)) {
                $Operateri[$rowOperateri['id']] = $rowOperateri['punoIme'];
            }
        }
        while ($rowRacuni = mysqli_fetch_array($GetRacune)) {
            $HtmlRacuni .= "<tr racun-id='" . $rowRacuni['id'] . "'>
                        <td>" . $Operateri[$rowRacuni['KONOBAR_ID']] . "<div class='ExpandInvoiceItems' invoicetoshow='" . $rowRacuni['id'] . "'><i class='fa fa-expand'></i></div></td>
                        <td>" . $rowRacuni['brojStola'] . "</td>
                        <td>" . $rowRacuni['iznos'] . "</td>
                        <td>" . $rowRacuni['nacin'] . "</td>
                        <td>" . date('H:i', strtotime($rowRacuni['datum'])) . "</td></tr>";
        }
        echo json_encode(array('Status' => 'success', 'Message' => '', 'RacuniHtml' => $HtmlRacuni));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema računa u poslednjih 24 časa!'));
    }
    die();
}
if (isset($_POST['PregledJournala']) && isset($_POST['JournalPage'])) {
    $Page = mysqli_real_escape_string($link, $_POST['JournalPage']);
    $DateFrom = mysqli_real_escape_string($link, $_POST['JournalPageFrom']);
    $DateTo = mysqli_real_escape_string($link, $_POST['JournalPageTo']);
    $DatePoc = date('Y-m-d 00:00:00', strtotime($DateFrom));
    $DateKraj = date('Y-m-d 23:59:59', strtotime($DateTo));
	$UserId = mysqli_real_escape_string($link, $_COOKIE['UserId']);
    $TotalItemsToShow = 50;
    $LimitTo = ($Page - 1) * $TotalItemsToShow;
	$prikaziSveRacune = false;
	$GetKonobar = mysqli_query($link, "SELECT * FROM konobar WHERE id=$UserId AND nivo='SEF' LIMIT 1") or die(mysqli_error($link));
	if (mysqli_num_rows($GetKonobar) == 1) {
		$prikaziSveRacune = true;
	}
	$uslovKonobarVidi = "";
	if(!$prikaziSveRacune) {
		$uslovKonobarVidi = " AND konobar_id=$UserId";
	}
    $GetInvoices = mysqli_query($link, "SELECT * FROM racun_fiskal WHERE vremeRacuna>='$DatePoc' AND vremeRacuna<='$DateKraj' $uslovKonobarVidi ORDER BY id DESC LIMIT $LimitTo, $TotalItemsToShow");
    if (mysqli_num_rows($GetInvoices) > 0) {
        $CountInvoice = mysqli_query($link, "SELECT COUNT(id) as TotalItems FROM racun_fiskal WHERE vremeRacuna>='$DatePoc' AND vremeRacuna<='$DateKraj'");
        $TotalItems = mysqli_fetch_array($CountInvoice)['TotalItems'];
        $TotalPages = ceil($TotalItems / $TotalItemsToShow);
        $NextPage = $Page + 1;
        $PrevPage = $Page - 1;
        $BellowShow = $Page - 3;
        $AboveShow = $Page + 3;
        $TotalPageShow = 6;
        $HtmlRacuni = "";
        if ($TotalPages > 1) {
            $HtmlRacuni .= "<ul class='PagerJournalHolder'>";
            if ($Page != 1) {
                $HtmlRacuni .= "<li class='PagerJournal' showpage='" . $PrevPage . "'><i class='fa fa-chevron-left'></i></li>";
            }
            for ($i = 1; $i <= $TotalPages; $i++) {
                if ($i == $Page) {
                    $ActivePage = 'PageIsActive';
                } else {
                    $ActivePage = '';
                }
                if ($TotalPages <= 5 || $Page < $TotalPageShow && $i < $TotalPageShow) {
                    $HtmlRacuni .= "<li class='PagerJournal " . $ActivePage . "' showpage='" . $i . "'>" . $i . "</li>";
                } elseif ($i >= $BellowShow && $i <= $AboveShow) {
                    $HtmlRacuni .= "<li class='PagerJournal " . $ActivePage . "' showpage='" . $i . "'>" . $i . "</li>";
                }
            }
            if ($Page != $TotalPages) {
                $HtmlRacuni .= "<li class='PagerJournal' showpage='" . $NextPage . "'><i class='fa fa-chevron-right'></i></li>";
            }
            $HtmlRacuni .= "</ul>";
        }
        $HtmlRacuni .= "<table>
            <thead>
                <tr>
                    <td>Tip računa</td>
                    <td>Tip transakcije</td>
                    <td>Broj računa</td>
					<td>Način plaćanja</td>
					<td>Iznos</td>
                    <td>Vreme</td>
                </tr>
            </thead>
            <tbody>";
		$ukupno = 0;	
        while ($rowInvoices = mysqli_fetch_array($GetInvoices)) {
			$JournalData = "";
			$GetSaleData = mysqli_query($link, "SELECT * FROM racun_fiskal WHERE id=${rowInvoices['id']}") or die(mysqli_error($link));
			if (mysqli_num_rows($GetSaleData) > 0) {
				while ($rowSale = mysqli_fetch_array($GetSaleData)) {
					$JournalData = unserialize($rowSale['podaciRacuna']);
					$JournalData = json_decode(json_encode($JournalData), true);
				}
			}
			$Payments = "";
			foreach ($JournalData['StavkePlacanja'] as $StavkaPlacanja) {
				if ($StavkaPlacanja['paymentType'] == 'Cash') {
					$PaymentPrint = "Gotovina";
				} elseif ($StavkaPlacanja['paymentType'] == 'Card') {
					$PaymentPrint = "Platna kartica";
				} elseif ($StavkaPlacanja['paymentType'] == 'Check') {
					$PaymentPrint = "Ček";
				} elseif ($StavkaPlacanja['paymentType'] == 'WireTransfer') {
					$PaymentPrint = "Prenos na račun";
				} elseif ($StavkaPlacanja['paymentType'] == 'MobileMoney') {
					$PaymentPrint = "Mobilni novac";
				} elseif ($StavkaPlacanja['paymentType'] == 'Voucher') {
					$PaymentPrint = "Vaučer";
				} elseif ($StavkaPlacanja['paymentType'] == 'Other') {
					$PaymentPrint = "Dr. bezgotovinsko plaćanje";
				}
				if ($Payments == '') {
					$Payments = $PaymentPrint;
				} else {
					$Payments .= ', ' . $PaymentPrint;
				}
			}
            $TipRacuna = "Promet";
            $TipTransakcije = "Prodaja";
            if ($rowInvoices['tipRacuna'] == 'Training') {
                $TipRacuna = "Obuka";
            } elseif ($rowInvoices['tipRacuna'] == 'Proforma') {
                $TipRacuna = "Predračun";
            } elseif ($rowInvoices['tipRacuna'] == 'Copy') {
                $TipRacuna = "Kopija";
            }
            if ($rowInvoices['tipTransakcije'] == 'Refund') {
                $TipTransakcije = "Refundacija";
				$JournalData['totalAmount'] *= -1;
            }
			$racunArr = explode("-",$InvoiceData['brojRacuna']);
			$ukupno += $JournalData['totalAmount'];
            $HtmlRacuni .= "<tr racun-id='" . $rowInvoices['id'] . "'>
                        <td>" . $TipRacuna . "</td>
                        <td>" . $TipTransakcije . "</td>
                        <td>" . $racunArr[2] . "</td>
						<td>" . $Payments . "</td>
						<td>" . number_format($JournalData['totalAmount'], 2, ',', '.') . "</td>
                        <td>" . date('d.m.Y H:i:s', strtotime($rowInvoices['vremeRacuna'])) . "</td></tr>";
        }
		$HtmlRacuni .= "<tr>
                        <td></td>
                        <td></td>
						<td></td>
                        <td><b>Ukupno:</b></td>
						<td><b>" . number_format($ukupno, 2, ',', '.') . "</b></td>
                        <td></td></tr>";
        $HtmlRacuni .= "</tbody>
        </table>";
        echo json_encode(array('Status' => 'success', 'Message' => '', 'RacuniHtml' => $HtmlRacuni));
    } else {
        echo json_encode(array('Status' => 'success', 'Message' => 'Nema kreiranih fiskalnih računa!', 'RacuniHtml' => 'Nema kreiranih fiskalnih računa za traženi period!'));
    }
    die();
}
if (isset($_POST['CreateFiskalAgain'])) {
    $RacunId = mysqli_real_escape_string($link, $_POST['CreateFiskalAgain']);
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Ponovna stampa fiskalnog ID->" . $RacunId . " Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    $GetData = mysqli_query($link, "SELECT * FROM racun WHERE id='$RacunId'");
    if (mysqli_num_rows($GetData) > 0) {
        $RacunData = mysqli_fetch_array($GetData);
        if ($RacunData['menipromet'] == 0) {
            $GetArtikleZaRacun = mysqli_query($link, "SELECT a.poreskaGrupa, a.dozvoljenPopust, SUM(sr.kolicina) as kolicina, sr.cena, sr.naziv, sr.ARTIKAL_ID FROM stavkaracuna sr, artikal a WHERE sr.RACUN_ID='$RacunId' AND a.id=sr.ARTIKAL_ID  GROUP BY sr.ARTIKAL_ID, sr.cena ORDER BY sr.id ASC") or die(mysqli_error($link . "na stavci racuna"));
            if (mysqli_num_rows($GetArtikleZaRacun) > 0) {
                $doc = new DOMDocument('1.0', 'UTF-8');
                $doc->preserveWhiteSpace = false;
                $doc->formatOutput = true;
                $ele = $doc->createElement('FiscalRecipet');
                $NazivRacuna = 'Racun_' . date('Ymd_His');
                $TotalPopust = $RacunData['popust'];
                while ($rowArtikli = mysqli_fetch_array($GetArtikleZaRacun)) {
                    $NazivArtiklaRacuna = $rowArtikli['naziv'];
                    $CenaArtiklaRacuna = $rowArtikli['cena'];
                    if ($rowArtikli['dozvoljenPopust'] == 1) {
                        if ($TotalPopust > 0) {
                            $Popust = $CenaArtiklaRacuna * (0 + $TotalPopust / 100);
                        } else {
                            $Popust = 0;
                        }
                    } else {
                        $Popust = 0;
                    }
                    $CenaArtiklaRacuna = $CenaArtiklaRacuna - $Popust;
                    $CenaArtiklaRacuna = number_format($CenaArtiklaRacuna, 2, '.', '');
                    $KolicinaArtiklaRacuna = number_format($rowArtikli['kolicina'], 3, '.', '');
                    $poreskaGrupa = $rowArtikli['poreskaGrupa'];
                    switch ($poreskaGrupa) {
                        case "0":
                            $OznakaPorez = "GRUPA_A";
                            break;
                        case "1":
                            $OznakaPorez = "GRUPA_G";
                            break;
                        case "2":
                            $OznakaPorez = "GRUPA_D";
                            break;
                        case "3":
                            $OznakaPorez = "GRUPA_DJ";
                            break;
                        case "4":
                            $OznakaPorez = "GRUPA_E";
                            break;
                        case "5":
                            $OznakaPorez = "GRUPA_ZJ";
                            break;
                        case "6":
                            $OznakaPorez = "GRUPA_I";
                            break;
                        case "7":
                            $OznakaPorez = "GRUPA_J";
                            break;
                        case "8":
                            $OznakaPorez = "GRUPA_K";
                            break;
                    }
                    $ele2 = $doc->createElement('FiscalItem');
                    $ele3 = $doc->createElement('Naziv');
                    $ele3->nodeValue = $NazivArtiklaRacuna;
                    $ele2->appendChild($ele3);
                    $ele4 = $doc->createElement('Cena');
                    $ele4->nodeValue = $CenaArtiklaRacuna;
                    $ele2->appendChild($ele4);
                    $ele5 = $doc->createElement('Kolicina');
                    $ele5->nodeValue = $KolicinaArtiklaRacuna;
                    $ele2->appendChild($ele5);
                    $ele6 = $doc->createElement('PoreskaGrupa');
                    $ele6->nodeValue = $OznakaPorez;
                    $ele2->appendChild($ele6);
                    $ele->appendChild($ele2);
                }
                $ele7 = $doc->createElement('Placanje');
                $ele8 = $doc->createElement('Kartica');
                $GetPayment = mysqli_query($link, "SELECT * FROM placanje WHERE RACUN_ID='$RacunId' AND nacin='KARTICA'");
                if (mysqli_num_rows($GetPayment) == 1) {
                    $ele8->nodeValue = number_format(mysqli_fetch_array($GetPayment)['iznos'], 1, '.', '');
                } else {
                    $ele8->nodeValue = '0.0';
                }
                $ele7->appendChild($ele8);
                $ele9 = $doc->createElement('Gotovina');
                $GetPayment = mysqli_query($link, "SELECT * FROM placanje WHERE RACUN_ID='$RacunId' AND nacin='GOTOVINA'");
                if (mysqli_num_rows($GetPayment) == 1) {
                    $ele9->nodeValue = number_format(mysqli_fetch_array($GetPayment)['iznos'], 1, '.', '');
                } else {
                    $ele9->nodeValue = '0.0';
                }
                $ele7->appendChild($ele9);
                $ele10 = $doc->createElement('Cek');
                $GetPayment = mysqli_query($link, "SELECT SUM(iznos) as iznos FROM placanje WHERE RACUN_ID='$RacunId' AND (nacin='CEK' OR nacin='FAKTURA')");
                if (mysqli_num_rows($GetPayment) == 1) {
                    $ele10->nodeValue = number_format(mysqli_fetch_array($GetPayment)['iznos'], 1, '.', '');
                } else {
                    $ele10->nodeValue = '0.0';
                }
                $ele7->appendChild($ele10);
                $ele->appendChild($ele7);
                $ele11 = $doc->createElement('Konobar');
                $ele11->nodeValue = $_COOKIE['UserName'];
                $ele->appendChild($ele11);

                $doc->appendChild($ele);
                $doc->save($SaveToReceipt . '/' . $NazivRacuna . '.xml');
                $DostavaID = $RacunData['DOSTAVA_ID'];
                $DostavaAdresaID = $RacunData['DOSTAVAADRESA_ID'];
                //sleep(2);
                if ($DostavaID > 0 && $DostavaAdresaID > 0) {
                    $GetDostavaData = mysqli_query($link, "SELECT d.naziv, d.telefon, da.*  FROM dostava d, dostava_adresa da WHERE d.id=da.DOSTAVA_ID AND da.id='$DostavaAdresaID'");
                    if (mysqli_num_rows($GetDostavaData) == 1) {
                        $DostavaData = mysqli_fetch_array($GetDostavaData);
                        $doc2 = new DOMDocument('1.0', 'UTF-8');
                        $doc2->preserveWhiteSpace = false;
                        $doc2->formatOutput = true;
                        $ele2 = $doc2->createElement('NefiskalnaStampa');
                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = FormatTextLeft('==============================');
                        $ele2->appendChild($eleH2);
                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = FormatText('Podaci o kupcu:');
                        $ele2->appendChild($eleH2);
                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = FormatTextLeft('==============================');
                        $ele2->appendChild($eleH2);

                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = $DostavaData['naziv'];
                        $ele2->appendChild($eleH2);
                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = $DostavaData['telefon'];
                        $ele2->appendChild($eleH2);
                        $PrintAdresa = $DostavaData['adresa'];
                        if ($DostavaData['broj'] != '') {
                            $PrintAdresa .= " " . $DostavaData['broj'];
                        }
                        if ($DostavaData['mesto'] != '') {
                            $PrintAdresa = $DostavaData['mesto'] . " " . $PrintAdresa;
                        }
                        if ($DostavaData['sprat'] != '') {
                            $PrintAdresa .= " " . $DostavaData['sprat'];
                        }

                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = $PrintAdresa;
                        $ele2->appendChild($eleH2);

                        if ($DostavaData['interfon'] != '') {
                            $eleH2 = $doc2->createElement('Linija');
                            $eleH2->nodeValue = 'Interfon: ' . $DostavaData['interfon'];
                            $ele2->appendChild($eleH2);
                        }
                        if ($DostavaData['napomena'] != '') {
                            $eleH2 = $doc2->createElement('Linija');
                            $eleH2->nodeValue = 'NAPOMENA: ' . $DostavaData['napomena'];
                            $ele2->appendChild($eleH2);
                        }

                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = FormatTextLeft('==============================');
                        $ele2->appendChild($eleH2);
                        $doc2->appendChild($ele2);
                        $doc2->save($SaveToReceipt . '/Dostava' . $NazivRacuna . '.xml');
                    }
                }
                echo json_encode(array('Status' => 'success', 'Message' => 'Račun je poslat na štampu!!!'));
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nema stavki za trazeni racun!!!'));
            }
        } else {
            $MeniPromet = $GetArtikleZaRacun = mysqli_query($link, "SELECT * FROM menipromet WHERE RACUN_ID='$RacunId'") or die(mysqli_error($link . "na stavci racuna"));
            if (mysqli_num_rows($GetArtikleZaRacun) > 0) {
                $poreskaGrupa = GetSettingVal('meni.redni.broj.pg');
                $doc = new DOMDocument('1.0', 'UTF-8');
                $doc->preserveWhiteSpace = false;
                $doc->formatOutput = true;
                $ele = $doc->createElement('FiscalRecipet');
                $NazivRacuna = 'Racun_' . date('Ymd_His');
                $TotalPopust = $RacunData['popust'];
                while ($rowArtikli = mysqli_fetch_array($GetArtikleZaRacun)) {
                    $NazivArtiklaRacuna = $rowArtikli['naziv'];
                    $CenaArtiklaRacuna = $rowArtikli['cena'];
                    if ($TotalPopust > 0) {
                        $Popust = $CenaArtiklaRacuna * (0 + $TotalPopust / 100);
                    } else {
                        $Popust = 0;
                    }
                    $CenaArtiklaRacuna = $CenaArtiklaRacuna - $Popust;
                    $CenaArtiklaRacuna = number_format($CenaArtiklaRacuna, 1, '.', '');
                    $KolicinaArtiklaRacuna = number_format($rowArtikli['kolicina'], 3, '.', '');
                    switch ($poreskaGrupa) {
                        case "0":
                            $OznakaPorez = "GRUPA_A";
                            break;
                        case "1":
                            $OznakaPorez = "GRUPA_G";
                            break;
                        case "2":
                            $OznakaPorez = "GRUPA_D";
                            break;
                        case "3":
                            $OznakaPorez = "GRUPA_DJ";
                            break;
                        case "4":
                            $OznakaPorez = "GRUPA_E";
                            break;
                        case "5":
                            $OznakaPorez = "GRUPA_ZJ";
                            break;
                        case "6":
                            $OznakaPorez = "GRUPA_I";
                            break;
                        case "7":
                            $OznakaPorez = "GRUPA_J";
                            break;
                        case "8":
                            $OznakaPorez = "GRUPA_K";
                            break;
                    }
                    $ele2 = $doc->createElement('FiscalItem');
                    $ele3 = $doc->createElement('Naziv');
                    $ele3->nodeValue = $NazivArtiklaRacuna;
                    $ele2->appendChild($ele3);
                    $ele4 = $doc->createElement('Cena');
                    $ele4->nodeValue = $CenaArtiklaRacuna;
                    $ele2->appendChild($ele4);
                    $ele5 = $doc->createElement('Kolicina');
                    $ele5->nodeValue = $KolicinaArtiklaRacuna;
                    $ele2->appendChild($ele5);
                    $ele6 = $doc->createElement('PoreskaGrupa');
                    $ele6->nodeValue = $OznakaPorez;
                    $ele2->appendChild($ele6);
                    $ele->appendChild($ele2);
                }
                $ele7 = $doc->createElement('Placanje');
                $ele8 = $doc->createElement('Kartica');
                $GetPayment = mysqli_query($link, "SELECT * FROM placanje WHERE RACUN_ID='$RacunId' AND nacin='KARTICA'");
                if (mysqli_num_rows($GetPayment) == 1) {
                    $ele8->nodeValue = number_format(mysqli_fetch_array($GetPayment)['iznos'], 1, '.', '');
                } else {
                    $ele8->nodeValue = '0.0';
                }
                $ele7->appendChild($ele8);
                $ele9 = $doc->createElement('Gotovina');
                $GetPayment = mysqli_query($link, "SELECT * FROM placanje WHERE RACUN_ID='$RacunId' AND nacin='GOTOVINA'");
                if (mysqli_num_rows($GetPayment) == 1) {
                    $ele9->nodeValue = number_format(mysqli_fetch_array($GetPayment)['iznos'], 1, '.', '');
                } else {
                    $ele9->nodeValue = '0.0';
                }
                $ele7->appendChild($ele9);
                $ele10 = $doc->createElement('Cek');
                $GetPayment = mysqli_query($link, "SELECT SUM(iznos) as iznos FROM placanje WHERE RACUN_ID='$RacunId' AND (nacin='CEK' OR nacin='FAKTURA')");
                if (mysqli_num_rows($GetPayment) == 1) {
                    $ele10->nodeValue = number_format(mysqli_fetch_array($GetPayment)['iznos'], 1, '.', '');
                } else {
                    $ele10->nodeValue = '0.0';
                }
                $ele7->appendChild($ele10);
                $ele->appendChild($ele7);
                $ele11 = $doc->createElement('Konobar');
                $ele11->nodeValue = $_COOKIE['UserName'];
                $ele->appendChild($ele11);

                $doc->appendChild($ele);
                $doc->save($SaveToReceipt . '/' . $NazivRacuna . '.xml');
                $DostavaID = $RacunData['DOSTAVA_ID'];
                $DostavaAdresaID = $RacunData['DOSTAVAADRESA_ID'];
                //sleep(2);
                if ($DostavaID > 0 && $DostavaAdresaID > 0) {
                    $GetDostavaData = mysqli_query($link, "SELECT d.naziv, d.telefon, da.adresa, da.broj, da.id FROM dostava d, dostava_adresa da WHERE d.id=da.DOSTAVA_ID AND da.id='$DostavaAdresaID'");
                    if (mysqli_num_rows($GetDostavaData) == 1) {
                        $DostavaData = mysqli_fetch_array($GetDostavaData);
                        $doc2 = new DOMDocument('1.0', 'UTF-8');
                        $doc2->preserveWhiteSpace = false;
                        $doc2->formatOutput = true;
                        $ele2 = $doc2->createElement('NefiskalnaStampa');
                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = FormatTextLeft('==============================');
                        $ele2->appendChild($eleH2);
                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = FormatText('Podaci o kupcu:');
                        $ele2->appendChild($eleH2);
                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = FormatTextLeft('==============================');
                        $ele2->appendChild($eleH2);

                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = $DostavaData['naziv'];
                        $ele2->appendChild($eleH2);
                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = $DostavaData['telefon'];
                        $ele2->appendChild($eleH2);
                        $PrintAdresa = $DostavaData['adresa'];
                        if ($DostavaData['broj'] != '') {
                            $PrintAdresa .= " " . $DostavaData['broj'];
                        }
                        if ($DostavaData['mesto'] != '') {
                            $PrintAdresa = $DostavaData['mesto'] . " " . $PrintAdresa;
                        }
                        if ($DostavaData['sprat'] != '') {
                            $PrintAdresa .= " " . $DostavaData['sprat'];
                        }

                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = $PrintAdresa;
                        $ele2->appendChild($eleH2);

                        if ($DostavaData['interfon'] != '') {
                            $eleH2 = $doc2->createElement('Linija');
                            $eleH2->nodeValue = 'Interfon: ' . $DostavaData['interfon'];
                            $ele2->appendChild($eleH2);
                        }
                        if ($DostavaData['napomena'] != '') {
                            $eleH2 = $doc2->createElement('Linija');
                            $eleH2->nodeValue = 'NAPOMENA: ' . $DostavaData['napomena'];
                            $ele2->appendChild($eleH2);
                        }

                        $eleH2 = $doc2->createElement('Linija');
                        $eleH2->nodeValue = FormatTextLeft('==============================');
                        $ele2->appendChild($eleH2);
                        $doc2->appendChild($ele2);
                        $doc2->save($SaveToReceipt . '/Dostava' . $NazivRacuna . '.xml');
                    }
                }
                echo json_encode(array('Status' => 'success', 'Message' => 'Račun je poslat na štampu!!!'));
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nema stavki za trazeni racun!!!'));
            }
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema podataka za trazeni racun!!!'));
    }
    die();
}
if (isset($_POST['DajSveOpiseZaArtikal'])) {
    $KojiArtikal = mysqli_real_escape_string($link, $_POST['DajSveOpiseZaArtikal']);
    $GetAtribut = mysqli_query($link, "SELECT * FROM atribut a, artikal_atribut aa WHERE a.id=aa.atributID and aa.artikalID='$KojiArtikal' ORDER BY a.naziv ASC") or die(mysqli_error($link));
    if (mysqli_num_rows($GetAtribut) > 0) {
        $OpisiNewHtml = "";
        while ($rowAtribut = mysqli_fetch_array($GetAtribut)) {
            $OpisiNewHtml .= "<div class='PredefinisaniOpis'>" . $rowAtribut['naziv'] . "</div>";
        }
        echo json_encode(array('Status' => 'success', 'OpisiNewHtml' => $OpisiNewHtml));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema atributa!!!'));
    }
    die();
}
if (isset($_POST['FakturaName'])) {
    $FakturaName = mysqli_real_escape_string($link, $_POST['FakturaName']);
    $FakturaAdresa = mysqli_real_escape_string($link, $_POST['FakturaAdresa']);
    $FakturaMesto = mysqli_real_escape_string($link, $_POST['FakturaMesto']);
    $FakturaPIB = mysqli_real_escape_string($link, $_POST['FakturaPIB']);
    $FakturaMB = mysqli_real_escape_string($link, $_POST['FakturaMB']);
    $FakturaId = 0;
    $IsExist = mysqli_query($link, "SELECT * FROM stalnigost WHERE pib='$FakturaPIB'");
    if (mysqli_num_rows($IsExist) > 0) {
        echo json_encode(array('Status' => 'error', 'Message' => 'Gost  sa ovim PIB-om već postoji u sistemu!'));
        die();
    }
    $StalniGostGrupa = 0;
    $GetGrupa = mysqli_query($link, "SELECT * FROM stalnigostigrupa WHERE preduzece=1 ORDER BY id ASC LIMIT 1");
    if (mysqli_num_rows($GetGrupa) == 1) {
        $StalniGostGrupa = mysqli_fetch_array($GetGrupa)['id'];
    }
    mysqli_query($link, "INSERT INTO stalnigost (adersa, blokiran, brojKopijaPregleda, dobavljac, maticniBroj, mesto, naziv, pib, GRUPA_ID, kupac) 
            VALUES ('$FakturaAdresa', 0, 1, 0, '$FakturaMB', '$FakturaMesto', '$FakturaName', '$FakturaPIB', '$StalniGostGrupa', 0) ") or die(mysqli_error($link));
    $FakturaId = mysqli_insert_id($link);

    mysqli_query($link, "INSERT INTO komitent (adresa, mb, mesto, naziv, pib, SG_ID) 
            VALUES ('$FakturaAdresa', '$FakturaMB', '$FakturaMesto', '$FakturaName', '$FakturaPIB', '$FakturaId') ") or die(mysqli_error($link));
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Kreiranje virmanskog kupca " . $FakturaName . " Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    if ($FakturaId > 0) {
        $HtmlFaktura = '<tr komitent-id="' . $FakturaId . '" class="SelectedFaktura">
                                        <td>' . $FakturaName . '</td>
                                        <td>' . $FakturaAdresa . '</td>
                                        <td>' . $FakturaMesto . '</td>
                                        <td>' . $FakturaPIB . '</td>
                                    </tr>';
        echo json_encode(array('Status' => 'success', 'Message' => '', 'FakturaNewHtml' => $HtmlFaktura));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Kupac nije kreiran'));
    }
    die();
}
if (isset($_POST['GetRecurePrice'])) {
    $Table = mysqli_real_escape_string($link, $_POST['GetRecurePrice']);
    $RecurePrice = 0;
    if ($Table != "") {
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Prikaz meni naplate Korisnik->" . $UserName;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
        $GetRacunId = mysqli_query($link, "SELECT * FROM racun WHERE brojStola='$Table' AND zatvoren=0 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetRacunId) == 1) {
            $RacunId = mysqli_fetch_array($GetRacunId)['id'];
        }
        $GetTableItemsRecure = mysqli_query($link, "SELECT s.ARTIKAL_ID, s.kolicina FROM stavkaracuna s WHERE s.brojStola='$Table' AND s.RACUN_ID=$RacunId") or die(mysqli_error($link));
        if (mysqli_num_rows($GetTableItemsRecure) > 0) {
            $Prices = [];
            $GetPrices = mysqli_query($link, "SELECT ts.id, ts.ARTIKAL_ID, ts.komad, t.datumTrebovanja FROM trebovanjestavka ts
                JOIN trebovanje t ON ts.TREBOVANJE_ID = t.id WHERE t.datumTrebovanja <= now()
                AND t.tip IN('DIREKTNO_SA_KNJIZ','DIREKTNO_BEZ_KNJIZ','IZ_MAGACINA') ORDER BY t.datumTrebovanja ASC, ts.id ASC") or die(mysqli_error($link));
            if (mysqli_num_rows($GetPrices) > 0) {
                while ($rowPrices = mysqli_fetch_array($GetPrices)) {
                    if ($rowPrices['komad'] > 0) {
                        $Prices[$rowPrices['ARTIKAL_ID']] = $rowPrices['komad'];
                    }
                }
            }
            $GetPrices2 = mysqli_query($link, "SELECT ps.id, ps.ARTIKAL_ID, ps.komad, p.datumPrijemnice FROM prijemnicastavka ps
                JOIN prijemnica p ON ps.PRIJEMNICA_ID = p.id WHERE p.datumPrijemnice <= now() AND p.tip = 'PRIJEMNICA'  
                ORDER BY  p.datumPrijemnice ASC, ps.id ASC") or die(mysqli_error($link));
            if (mysqli_num_rows($GetPrices2) > 0) {
                while ($rowPrices2 = mysqli_fetch_array($GetPrices2)) {
                    if ($rowPrices2['komad'] > 0) {
                        $Prices[$rowPrices2['ARTIKAL_ID']] = $rowPrices2['komad'];
                    }
                }
            }
            $Normativi = [];
            $GetNormatives = mysqli_query($link, "SELECT * FROM normativartikal WHERE datum<=now() AND aktivan=1 ORDER BY id ASC, datum ASC");
            if (mysqli_num_rows($GetNormatives) > 0) {
                while ($rowNormatives = mysqli_fetch_array($GetNormatives)) {
                    $Normativi[$rowNormatives['ARTIKAL_ID']] = $rowNormatives['id'];
                }
            }
            $Sastojci = [];
            $GetSastojci = mysqli_query($link, "SELECT * FROM normativ ORDER BY id ASC");
            if (mysqli_num_rows($GetSastojci) > 0) {
                while ($rowSastojci = mysqli_fetch_array($GetSastojci)) {
                    $Sastojci[$rowSastojci['NORMATIVARTIKAL_ID']][$rowSastojci['SASTOJAK_ID']] = $rowSastojci['kolicina'];
                }
            }
            while ($rowTableItemsRecure = mysqli_fetch_array($GetTableItemsRecure)) {
                $NabCena = 0;
                if (isset($Prices[$rowTableItemsRecure['ARTIKAL_ID']])) {
                    $NabCena = $Prices[$rowTableItemsRecure['ARTIKAL_ID']];
                }
                if ($NabCena == 0) {
                    if (isset($Normativi[$rowTableItemsRecure['ARTIKAL_ID']])) {
                        $NormativId = $Normativi[$rowTableItemsRecure['ARTIKAL_ID']];
                        foreach ($Sastojci[$NormativId] as $Sastojak => $Kolicina) {
                            $NabCenaSastojak = 0;
                            if (isset($Prices[$Sastojak])) {
                                $NabCenaSastojak = $Prices[$Sastojak];
                            }
                            if ($NabCenaSastojak > 0) {
                                $NabCena = $NabCena + ($NabCenaSastojak * $Kolicina);
                            }
                            if (isset($Normativi[$Sastojak])) {
                                $NormativId2 = $Normativi[$Sastojak];
                                foreach ($Sastojci[$NormativId2] as $Sastojak2 => $Kolicina2) {
                                    $NabCenaSastojak2 = 0;
                                    if (isset($Prices[$Sastojak2])) {
                                        $NabCenaSastojak2 = $Prices[$Sastojak2];
                                    }
                                    if ($NabCenaSastojak2 > 0) {
                                        $NabCena = $NabCena + ($NabCenaSastojak2 * $Kolicina2);
                                    }
                                    if (isset($Normativi[$Sastojak2])) {
                                        $NormativId3 = $Normativi[$Sastojak2];
                                        foreach ($Sastojci[$NormativId3] as $Sastojak3 => $Kolicina3) {
                                            $NabCenaSastojak3 = 0;
                                            if (isset($Prices[$Sastojak3])) {
                                                $NabCenaSastojak3 = $Prices[$Sastojak3];
                                            }
                                            if ($NabCenaSastojak3 > 0) {
                                                $NabCena = $NabCena + ($NabCenaSastojak3 * $Kolicina3);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if ($NabCena > 0) {
                    $RecurePrice = $RecurePrice + ($rowTableItemsRecure['kolicina'] * $NabCena);
                }
            }
            echo json_encode(array('Status' => 'success', 'RecurePrice' => number_format($RecurePrice, 2, '.', '')));
        } else {
            echo json_encode(array('Status' => 'success', 'RecurePrice' => 0));
        }
    } else {
        echo json_encode(array('Status' => 'success', 'RecurePrice' => 0));
    }
    die();
}
if (isset($_POST['CreateNewMenu'])) {
    $MeniName = mysqli_real_escape_string($link, $_POST['CreateNewMenu']);
    $IsExist = mysqli_query($link, "SELECT * FROM meni WHERE naziv='$MeniName'");
    if (mysqli_num_rows($IsExist) > 0) {
        echo json_encode(array('Status' => 'error', 'Message' => 'Meni sa ovim nazivom već postoji u sistemu!'));
        die();
    }
    mysqli_query($link, "INSERT INTO meni (blokiran, naziv) VALUES (0, '$MeniName')");
    $MenuId = mysqli_insert_id($link);
    $MenuNewHtml = '<div class="MenuItem MenuSelected" menu-id="' . $MenuId . '"  menu-name="' . $MeniName . '">' . $MeniName . '</div> ';
    echo json_encode(array('Status' => 'success', 'MenuNewHtml' => $MenuNewHtml));
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Kreiranje novog menija " . $MeniName . " Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    die();
}
if (isset($_POST['DajSveDostavaKupce'])) {
    $KupacTelefon = mysqli_real_escape_string($link, $_POST['DajSveDostavaKupce']);
    $GetKupacData = mysqli_query($link, "SELECT * FROM dostava WHERE telefon='$KupacTelefon' LIMIT 1");
    if (mysqli_num_rows($GetKupacData) == 1) {
        $KupacData = mysqli_fetch_array($GetKupacData);
        $KupacId = $KupacData['id'];
        $Adrese = [];
        $GetKupacAdrese = mysqli_query($link, "SELECT * FROM dostava_adresa WHERE DOSTAVA_ID='$KupacId' ORDER BY id ASC");
        if (mysqli_num_rows($GetKupacAdrese) > 0) {
            while ($rowKupacAdrese = mysqli_fetch_array($GetKupacAdrese)) {
                $Adrese[$rowKupacAdrese['id']] = $rowKupacAdrese;
            }
        }
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Pretraga kupca za dostavu " . $KupacTelefon . " Korisnik->" . $UserName;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
        echo json_encode(array('Status' => 'success', 'Ime' => $KupacData['naziv'], 'ID' => $KupacData['id'], 'Telefon' => $KupacData['telefon'], 'Adrese' => $Adrese));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema kupca sa ovim brojem telefona!'));
    }
    die();
}
if (isset($_POST['NovaDostavaTelefon'])) {
    $NovaDostavaTelefon = mysqli_real_escape_string($link, $_POST['NovaDostavaTelefon']);
    $NovaDostavaIme = mysqli_real_escape_string($link, $_POST['NovaDostavaIme']);
    $NovaDostavaID = mysqli_real_escape_string($link, $_POST['NovaDostavaID']);
    if ($NovaDostavaID == 0) {
        mysqli_query($link, "INSERT INTO dostava (naziv, telefon) VALUES ('$NovaDostavaIme', '$NovaDostavaTelefon')");
        $NovaDostavaID = mysqli_insert_id($link);
    } else {
        mysqli_query($link, "UPDATE dostava SET naziv='$NovaDostavaIme' WHERE id='$NovaDostavaID'");
    }
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Kreiranje novog kupca za dostavu " . $NovaDostavaIme . " Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    $NovaDostavaAdresa = mysqli_real_escape_string($link, $_POST['NovaDostavaAdresa']);
    $NovaDostavaMesto = mysqli_real_escape_string($link, $_POST['NovaDostavaMesto']);
    $NovaDostavaBroj = mysqli_real_escape_string($link, $_POST['NovaDostavaBroj']);
    $NovaDostavaSprat = mysqli_real_escape_string($link, $_POST['NovaDostavaSprat']);
    $NovaDostavaInterfon = mysqli_real_escape_string($link, $_POST['NovaDostavaInterfon']);
    $NovaDostavaNapomena = mysqli_real_escape_string($link, $_POST['NovaDostavaNapomena']);
    $NovaDostavaAdresaID = mysqli_real_escape_string($link, $_POST['NovaDostavaAdresaID']);
    if ($NovaDostavaAdresaID == 0) {
        mysqli_query($link, "INSERT INTO dostava_adresa (mesto, adresa, broj, sprat, interfon, napomena, DOSTAVA_ID) 
            VALUES ('$NovaDostavaMesto', '$NovaDostavaAdresa', '$NovaDostavaBroj', '$NovaDostavaSprat', '$NovaDostavaInterfon', '$NovaDostavaNapomena', '$NovaDostavaID')");
    } else {
        mysqli_query($link, "UPDATE dostava_adresa SET mesto='$NovaDostavaMesto', adresa='$NovaDostavaAdresa', broj='$NovaDostavaBroj', 
            sprat='$NovaDostavaSprat', interfon='$NovaDostavaInterfon', napomena='$NovaDostavaNapomena', DOSTAVA_ID='$NovaDostavaID' WHERE id='$NovaDostavaAdresaID'");
    }
    $GetKupacData = mysqli_query($link, "SELECT * FROM dostava WHERE id='$NovaDostavaID' LIMIT 1");
    if (mysqli_num_rows($GetKupacData) == 1) {
        $KupacData = mysqli_fetch_array($GetKupacData);
        $KupacId = $KupacData['id'];
        $Adrese = [];
        $GetKupacAdrese = mysqli_query($link, "SELECT * FROM dostava_adresa WHERE DOSTAVA_ID='$KupacId' ORDER BY id ASC");
        if (mysqli_num_rows($GetKupacAdrese) > 0) {
            while ($rowKupacAdrese = mysqli_fetch_array($GetKupacAdrese)) {
                $Adrese[$rowKupacAdrese['id']] = $rowKupacAdrese;
            }
        }
        echo json_encode(array('Status' => 'success', 'Ime' => $KupacData['naziv'], 'ID' => $KupacData['id'], 'Telefon' => $KupacData['telefon'], 'Adrese' => $Adrese));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Greska pri kreiranju novog kupca!'));
    }
    die();
}
if (isset($_POST['GetFirstFreeTableDostava'])) {
    $GetLastTableNumber = mysqli_query($link, "SELECT * FROM racun WHERE zatvoren=0 AND brojStola>=20000 ORDER BY brojStola ASC");
    if (mysqli_num_rows($GetLastTableNumber) > 0) {
        $TableArray = [];
        $Min = 0;
        $Max = 0;
        $LastTableNumber = 0;
        while ($rowTables = mysqli_fetch_array($GetLastTableNumber)) {
            $TableArray[$rowTables['brojStola']] = $rowTables['brojStola'];
            if ($Min == 0) {
                $Min = $rowTables['brojStola'];
            }
            if ($Max < $rowTables['brojStola']) {
                $Max = $rowTables['brojStola'];
            }
        }
        while ($Min <= $Max) {
            $TryTableNumber = $Min + 1;
            if (!isset($TableArray[$TryTableNumber])) {
                if ($TableArray[$TryTableNumber] != $TryTableNumber) {
                    if ($LastTableNumber == 0) {
                        $LastTableNumber = $TryTableNumber;
                        $Min = $Max;
                    }
                }
            }
            $Min++;
        }
        echo json_encode(array('Status' => 'success', 'BrojStola' => $LastTableNumber));
    } else {
        echo json_encode(array('Status' => 'success', 'BrojStola' => '20000'));
    }
    die();
}
if (isset($_POST['GetAllDeliveries'])) {
    $Html = "";
    $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY id DESC LIMIT 1");
    if (mysqli_num_rows($GetZd) == 1) {
        $Zd = mysqli_fetch_array($GetZd)['zdBroj'];
        $GetDeliveries = mysqli_query($link, "SELECT * FROM racun WHERE DOSTAVA_ID>0 AND zdBroj='$Zd' AND storniran=0 ORDER BY zatvoren ASC, datum DESC");
    } else {
        $Last24H = date('Y-m-d H:i:s', strtotime('-24 hours'));
        $GetDeliveries = mysqli_query($link, "SELECT * FROM racun WHERE DOSTAVA_ID>0 AND datum>='$Last24H' AND storniran=0 ORDER BY zatvoren ASC, datum DESC");
    }
    if (mysqli_num_rows($GetDeliveries) > 0) {
        $Kupci = [];
        $GetAllDeliveryBuyers = mysqli_query($link, "SELECT d.naziv, d.telefon, da.adresa, da.broj, da.id FROM dostava d, dostava_adresa da WHERE d.id=da.DOSTAVA_ID");
        if (mysqli_num_rows($GetAllDeliveryBuyers) > 0) {
            while ($rowDeliveryBuyer = mysqli_fetch_array($GetAllDeliveryBuyers)) {
                $Kupci[$rowDeliveryBuyer['id']] = ['Naziv' => $rowDeliveryBuyer['naziv'], 'Telefon' => $rowDeliveryBuyer['telefon'], 'Adresa' => $rowDeliveryBuyer['adresa'], 'Broj' => $rowDeliveryBuyer['broj']];
            }
        }
        $Html = "<table class='DeliveriesTable'>";
        while ($rowDeliveries = mysqli_fetch_array($GetDeliveries)) {

            $Class = "CurrentDelivery";
            if ($rowDeliveries['zatvoren'] == 1) {
                $Class = "FinishedDelivery";
            }
            $Expander = "";
            if ($Class == 'FinishedDelivery') {
                $Expander = "<div class='ExpandInvoiceItems' invoicetoshow='" . $rowDeliveries['id'] . "'><i class='fa fa-expand'></i></div>";
            } else {
                $Expander = "<div class='PrintOrderItems' deliveryaddress='" . $rowDeliveries['DOSTAVAADRESA_ID'] . "'><i class='fa fa-print'></i></div>";
            }
            $Html .= "<tr delivery-id='" . $rowDeliveries['brojStola'] . "' delivery-name='" . $Kupci[$rowDeliveries['DOSTAVAADRESA_ID']]['Naziv'] . "' class='DeliveryRow " . $Class . "'>";
            $Html .= "<td>" . $Kupci[$rowDeliveries['DOSTAVAADRESA_ID']]['Naziv'] . " " . $Expander . "</td>";
            $Html .= "<td>" . $Kupci[$rowDeliveries['DOSTAVAADRESA_ID']]['Telefon'] . "</td>";
            $Html .= "<td>" . $Kupci[$rowDeliveries['DOSTAVAADRESA_ID']]['Adresa'] . " " . $Kupci[$rowDeliveries['DOSTAVAADRESA_ID']]['Broj'] . "</td>";
            $Html .= "<td>" . date('d.m.Y H:i:s', strtotime($rowDeliveries['datum'])) . "</td>";
            $Html .= "</tr>";
        }
        $Html .= "</table>";
        echo json_encode(array('Status' => 'success', 'DeliveriesHtml' => $Html));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema prethodnih porudzbina!!!'));
    }
    die();
}
if (isset($_POST['GetAllBuyerDeliveries'])) {
    $DostavaID = mysqli_real_escape_string($link, $_POST['GetAllBuyerDeliveries']);
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Pregled prethodnih dostava DOSTAVA_ID->" . $DostavaID . " Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    $Html = "";
    $GetDeliveries = mysqli_query($link, "SELECT * FROM racun WHERE DOSTAVA_ID='$DostavaID' AND zatvoren=1 ORDER BY datum DESC");
    if (mysqli_num_rows($GetDeliveries) > 0) {
        $Kupci = [];
        $GetAllDeliveryBuyers = mysqli_query($link, "SELECT d.naziv, d.telefon, da.adresa, da.broj, da.id FROM dostava d, dostava_adresa da WHERE d.id=da.DOSTAVA_ID AND d.id='$DostavaID'");
        if (mysqli_num_rows($GetAllDeliveryBuyers) > 0) {
            while ($rowDeliveryBuyer = mysqli_fetch_array($GetAllDeliveryBuyers)) {
                $Kupci[$rowDeliveryBuyer['id']] = ['Naziv' => $rowDeliveryBuyer['naziv'], 'Telefon' => $rowDeliveryBuyer['telefon'], 'Adresa' => $rowDeliveryBuyer['adresa'], 'Broj' => $rowDeliveryBuyer['broj']];
            }
        }
        while ($rowDelivery = mysqli_fetch_array($GetDeliveries)) {
            $RacunId = $rowDelivery['id'];
            $GetItems = mysqli_query($link, "SELECT * FROM stavkaracuna WHERE RACUN_ID='$RacunId'");
            if (mysqli_num_rows($GetItems) > 0) {
                $Html .= "<div class='StaraDostava'>";
                $Html .= "<div class='StaraDostavaTitle'><div class='StaraDostavaText'>" . $Kupci[$rowDelivery['DOSTAVAADRESA_ID']]['Adresa'] . " - " . date('d.m.Y H:i:s', strtotime($rowDelivery['datum'])) . "</div>";
                $Html .= "<span class='PonoviDostavu' idstaredostave='" . $rowDelivery['id'] . "'><i class='fa fa-recycle'></i></span>";
                $Html .= "<span class='PrikaziDostavu' idstaredostave='" . $rowDelivery['id'] . "'><i class='fa fa-expand'></i></span>";
                $Html .= "</div>";
                $Html .= "<div class='StaraDostavaArtikli' idstaredostave='" . $rowDelivery['id'] . "'>";
                while ($rowItems = mysqli_fetch_array($GetItems)) {
                    $Html .= "<div class='StaraDostavaArtikal' staradostavaartikalid='" . $rowItems['ARTIKAL_ID'] . "' staradostavaartikalkolicina='" . $rowItems['kolicina'] . "' staradostavaartikalopis='" . $rowItems['opis'] . "'>";
                    $Html .= $rowItems['naziv'] . " <div class='StaraDostavaKolicina'>X " . $rowItems['kolicina'] . "</div>";
                    $Html .= "</div>";
                }
                $Html .= "</div>";
                $Html .= "</div>";
            }
        }
        if ($Html != '') {
            echo json_encode(array('Status' => 'success', 'DeliveriesHtml' => $Html));
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Nema prethodnih porudzbina za ovog kupca!!!'));
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema prethodnih porudzbina za ovog kupca!!!'));
    }
    die();
}
if (isset($_POST['GetInvoiceItems'])) {
    $RacunId = mysqli_real_escape_string($link, $_POST['GetInvoiceItems']);
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Pregled stavki racuna ID->" . $RacunId . " Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    $Html = "";
    $GetItems = mysqli_query($link, "SELECT * FROM stavkaracuna WHERE RACUN_ID='$RacunId'");
    if (mysqli_num_rows($GetItems) > 0) {
        while ($rowItems = mysqli_fetch_array($GetItems)) {
            $Html .= "<div class='ArtikliExpanderItem'>";
            $Html .= "<div class='ArtikliExpanderItemNaziv'> " . $rowItems['naziv'] . "</div> <div class='ArtikliExpanderItemKolicina'>X " . $rowItems['kolicina'] . "</div>";
            $Html .= "</div>";
        }
        if ($Html != '') {
            echo json_encode(array('Status' => 'success', 'RacunHtml' => $Html));
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Nema stavki za odabrani račun!!!'));
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema stavki za odabrani račun!!!'));
    }
    die();
}
if (isset($_POST['PrintReportNarrow'])) {
    $TipIzvestaja = mysqli_real_escape_string($link, $_POST['PrintReportNarrow']);
    if ($TipIzvestaja == 'PopisnaLista') {
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Uska stampa popisne liste Korisnik->" . $UserName;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
        $OdeljenjaSent = mysqli_real_escape_string($link, $_POST['Odeljenja']);
        $GetOdeljenja = mysqli_query($link, "SELECT * FROM kasa_odeljenje WHERE KASA_ID='$KasaId' AND ODELJENJA_ID IN ( $OdeljenjaSent )");
        if (mysqli_num_rows($GetOdeljenja) > 0) {
            $OdeljenjaIn = "";
            while ($rowOdeljenja = mysqli_fetch_array($GetOdeljenja)) {
                if ($OdeljenjaIn == '') {
                    $OdeljenjaIn = $rowOdeljenja['ODELJENJA_ID'];
                } else {
                    $OdeljenjaIn .= ', ' . $rowOdeljenja['ODELJENJA_ID'];
                }
            }
            $GetArtikle = mysqli_query($link, "SELECT a.tip, a.name, a.JedinicaMere, ao.ODELJENJA_ID FROM artikal a, artikal_odeljenje ao WHERE ao.ARTIKLI_ID=a.id AND ao.ODELJENJA_ID IN ( $OdeljenjaIn ) ORDER BY ao.ODELJENJA_ID ASC, a.name ASC") or die(mysqli_error($link));
            if (mysqli_num_rows($GetArtikle) > 0) {
                $GetOdeljenjeNaziv = mysqli_query($link, "SELECT * FROM odeljenje");
                $OdeljenjeNaziv = [];
                if (mysqli_num_rows($GetOdeljenjeNaziv) > 0) {
                    while ($rowOdeljenje = mysqli_fetch_array($GetOdeljenjeNaziv)) {
                        $OdeljenjeNaziv[$rowOdeljenje['id']] = $rowOdeljenje['naziv'];
                    }
                }
                $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1");
                if (mysqli_num_rows($GetStampacData) > 0) {
                    $StampacData = mysqli_fetch_array($GetStampacData);
                    if ($StampacData['tip'] == 'POSBANK80MM') {
                        $PrinterLetters = 40;
                    } else {
                        $PrinterLetters = 30;
                    }
                    $PrintString = "";
                    $PrintString .= FormatText(date('d.m.Y')) . "\n";

                    $OdeljenjeId = 0;
                    while ($rowArtikle = mysqli_fetch_array($GetArtikle)) {
                        if ($rowArtikle['tip'] == 'PROD' || $rowArtikle['tip'] == 'SIRO') {
                            if ($OdeljenjeId != $rowArtikle['ODELJENJA_ID']) {
                                $OdeljenjeId = $rowArtikle['ODELJENJA_ID'];

                                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                                $PrintString .= FormatText($OdeljenjeNaziv[$OdeljenjeId]) . "\n";

                                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";
                            }
                            $Remains = $PrinterLetters - 5;
                            $PrintString .= str_pad(mb_substr($rowArtikle['name'], 0, $Remains, 'UTF-8'), $Remains, " ", STR_PAD_RIGHT) . "_____\n";
                        }
                    }
                    try {
                        // Enter the share name for your USB printer here
                        $NazivStampaca = $StampacData['naziv'];
                        if (strpos($NazivStampaca, "/")) {
                            $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                        } else {
                            $connector = new WindowsPrintConnector($NazivStampaca);
                        }
                        $printer = new Printer($connector);
                        $printer->pulse(1, 300, 300);
                        $printer->setPrintLeftMargin(0);
                        $printer->setJustification(Printer::JUSTIFY_LEFT);
                        $printer->text($PrintString);
                        $printer->feed();
                        $printer->cut();
                        $printer->close();
                    } catch (Exception $e) {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                        die();
                    }
                    echo json_encode(array('Status' => 'success', 'Message' => 'Izveštaj je poslat na štampu!!!'));
                    die();
                } else {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Nema štampača za štampu izveštaja!!!'));
                    die();
                }
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Greska pri kreiranju fajla Nema artikala...'));
                die();
            }
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Greska pri kreiranju fajla nema podesenih odeljenja...'));
            die();
        }
    } elseif ($TipIzvestaja == 'IzvestajStorno') {
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Uska stampa storno izvestaja Korisnik->" . $UserName;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
        $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE datum<='now()' AND pocetak=1 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetZd) == 1) {
            $ZdVreme = mysqli_fetch_array($GetZd)['zakljucenje'];
            $GetStorno = mysqli_query($link, "SELECT * FROM storno WHERE vremeStorniranja>='$ZdVreme' ORDER BY id DESC") or die(mysqli_error($link));
            if (mysqli_num_rows($GetStorno) > 0) {
                $GetKonobari = mysqli_query($link, "SELECT * FROM konobar");
                $Konobari = [];
                if (mysqli_num_rows($GetKonobari) > 0) {
                    while ($rowKonobar = mysqli_fetch_array($GetKonobari)) {
                        $Konobari[$rowKonobar['id']] = $rowKonobar['punoIme'];
                    }
                }

                $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1");
                if (mysqli_num_rows($GetStampacData) > 0) {
                    $StampacData = mysqli_fetch_array($GetStampacData);
                    if ($StampacData['tip'] == 'POSBANK80MM') {
                        $PrinterLetters = 40;
                    } else {
                        $PrinterLetters = 30;
                    }
                    $PrintString = "";
                    $PrintString .= FormatText(date('d.m.Y')) . "\n";

                    $PrintString .= FormatText('Storno lista') . "\n";

                    while ($rowStorno = mysqli_fetch_array($GetStorno)) {
                        $Rb = 1;
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                        $PrintString .= FormatText('Operater: ' . $Konobari[$rowStorno['KONOBAR_ID']]) . "\n";

                        $PrintString .= FormatText('Vreme: ' . date('d.m.Y H:i:s', strtotime($rowStorno['vremeStorniranja']))) . "\n";

                        $PrintString .= FormatText('Sto: ' . $rowStorno['brojStola']) . "\n";

                        $PrintString .= FormatText('Tip: ' . $rowStorno['tipStorna']) . "\n";

                        $StornoId = $rowStorno['id'];
                        $FourthLetters = $PrinterLetters / 4;
                        $FourthLetters = floor($FourthLetters);
                        $HalfLetters = $PrinterLetters - ($FourthLetters * 2);
                        $GetArtikle = mysqli_query($link, "SELECT a.name, s.* FROM stornostavka s, artikal a WHERE s.ARTIKAL_ID=a.id AND s.STORNO_ID='$StornoId'");
                        if (mysqli_num_rows($GetArtikle) > 0) {
                            $Ukupno = 0;
                            while ($rowArtikle = mysqli_fetch_array($GetArtikle)) {
                                $Cena = $rowArtikle['vrednost'] / $rowArtikle['kolicina'];
                                $Ukupno = $Ukupno + $rowArtikle['vrednost'];
                                $PrintString .= str_pad(mb_substr($rowArtikle['name'], 0, $HalfLetters, 'UTF-8'), $HalfLetters, " ", STR_PAD_RIGHT) . '' . str_pad(mb_substr($rowArtikle['kolicina'] . 'X', 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . '' . str_pad(mb_substr($Cena, 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . "\n";
                            }
                            $PrintString .= str_pad("-", $PrinterLetters, "-", STR_PAD_BOTH) . "\n";
                            $PrintString .= FormatTextHalfLeft('Ukupno:') . '' . FormatTextHalfRight($Ukupno) . "\n";
                        }
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";
                    }
                    try {
                        // Enter the share name for your USB printer here
                        $NazivStampaca = $StampacData['naziv'];
                        if (strpos($NazivStampaca, "/")) {
                            $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                        } else {
                            $connector = new WindowsPrintConnector($NazivStampaca);
                        }
                        $printer = new Printer($connector);
                        $printer->pulse(1, 300, 300);
                        $printer->setPrintLeftMargin(0);
                        $printer->setJustification(Printer::JUSTIFY_LEFT);
                        $printer->text($PrintString);
                        $printer->feed();
                        $printer->cut();
                        $printer->close();
                    } catch (Exception $e) {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                        die();
                    }
                    echo json_encode(array('Status' => 'success', 'Message' => 'Izveštaj je poslat na štampu!!!'));
                    die();
                } else {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Nema štampača za štampu izveštaja!!!'));
                    die();
                }
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nema storniranih računa i porudžbina...'));
                die();
            }
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Greska pri kreiranju fajla Nema radnog dana...'));
            die();
        }
    } elseif ($TipIzvestaja == 'IzvestajSvi') {
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Uska stampa prodaje svih operatera Korisnik->" . $UserName;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
        $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE datum<='now()' AND pocetak=1 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetZd) == 1) {
            $ZdData = mysqli_fetch_array($GetZd);
            $ZdBroj = $ZdData['zdBroj'];
            $ZdVreme = ['zakljucenje'];
            $GetKonobari = mysqli_query($link, "SELECT * FROM konobar ORDER BY punoIme ASC");
            if (mysqli_num_rows($GetKonobari) > 0) {
                $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1");
                if (mysqli_num_rows($GetStampacData) > 0) {
                    $StampacData = mysqli_fetch_array($GetStampacData);
                    if ($StampacData['tip'] == 'POSBANK80MM') {
                        $PrinterLetters = 40;
                    } else {
                        $PrinterLetters = 30;
                    }
                    $PrintString = "";
                    $PrintString .= FormatText(date('d.m.Y')) . "\n";

                    $PrintString .= FormatText('Promet svih operatera') . "\n";

                    while ($rowKonobar = mysqli_fetch_array($GetKonobari)) {
                        $KonobarId = $rowKonobar['id'];
                        $Placanja = [];

                        $Rb = 1;
                        $BrojRacuna = 0;
                        $SomePrinted = 0;
                        $GetRacune = mysqli_query($link, "SELECT r.id, r.crnoPlacanje, SUM(s.kolicina * (s.cena-(s.cena*(IFNULL(if(a.dozvoljenPopust=1, r.popust/100, 0), 0))))) as total 
                FROM racun r, stavkaracuna s, artikal a WHERE r.id=s.RACUN_ID AND s.ARTIKAL_ID=a.id AND 
        r.zdBroj='$ZdBroj' AND r.KONOBAR_ID='$KonobarId' AND r.zatvoren=1 GROUP BY r.id") or die(mysqli_error($link));
                        $GetStorno = mysqli_query($link, "SELECT s.id, SUM(ss.vrednost) as Total FROM storno s, stornostavka ss WHERE s.id=ss.STORNO_ID AND s.vremeStorniranja>='$ZdVreme' AND KONOBAR_ID='$KonobarId' GROUP BY s.id") or die(mysqli_error($link));

                        $NumRacuni = mysqli_num_rows($GetRacune);
                        $NumStorno = mysqli_num_rows($GetStorno);
                        if ($NumRacuni > 0 || $NumStorno > 0) {
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                            $PrintString .= FormatText($rowKonobar['punoIme']) . "\n";

                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";
                        }
                        if ($NumRacuni > 0) {
                            while ($rowRacuni = mysqli_fetch_array($GetRacune)) {
                                $RacunId = $rowRacuni['id'];
                                if ($rowRacuni['crnoPlacanje'] != '') {
                                    $Placanja[$rowRacuni['crnoPlacanje']] = $Placanja[$rowRacuni['crnoPlacanje']] + $rowRacuni['total'];
                                } else {
                                    $GetPayment = mysqli_query($link, "SELECT * FROM placanje WHERE RACUN_ID='$RacunId'");
                                    if (mysqli_num_rows($GetPayment) > 1) {
                                        $Placanja['Kombinovano'] = $Placanja['Kombinovano'] + $rowRacuni['total'];
                                    } else {
                                        while ($rowPayment = mysqli_fetch_array($GetPayment)) {
                                            $Placanja[$rowPayment['nacin']] = $Placanja[$rowPayment['nacin']] + $rowPayment['iznos'];
                                        }
                                    }
                                }
                                $BrojRacuna++;
                            }
                            $PrintString .= FormatTextHalfLeft('Broj računa:') . '' . FormatTextHalfRight($BrojRacuna) . "\n";

                            foreach ($Placanja as $Naziv => $Iznos) {
                                $PrintString .= FormatTextHalfLeft($Naziv . ':') . '' . FormatTextHalfRight($Iznos) . "\n";
                            }
                            $SomePrinted = 1;
                        }

                        if ($NumStorno > 0) {
                            $StornoBroj = 0;
                            $StornoIznos = 0;
                            while ($rowStorno = mysqli_fetch_array($GetStorno)) {
                                $StornoBroj++;
                                $StornoIznos = $StornoIznos + $rowStorno['Total'];
                            }
                            $PrintString .= FormatTextHalfLeft('Broj storno:') . '' . FormatTextHalfRight($StornoBroj) . "\n";

                            $PrintString .= FormatTextHalfLeft('Iznos storno:') . '' . FormatTextHalfRight($StornoIznos) . "\n";
                            $SomePrinted = 1;
                        }
                    }
                    try {
                        // Enter the share name for your USB printer here
                        $NazivStampaca = $StampacData['naziv'];
                        if (strpos($NazivStampaca, "/")) {
                            $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                        } else {
                            $connector = new WindowsPrintConnector($NazivStampaca);
                        }
                        $printer = new Printer($connector);
                        $printer->pulse(1, 300, 300);
                        $printer->setPrintLeftMargin(0);
                        $printer->setJustification(Printer::JUSTIFY_LEFT);
                        $printer->text($PrintString);
                        $printer->feed();
                        $printer->cut();
                        $printer->close();
                    } catch (Exception $e) {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                        die();
                    }
                    echo json_encode(array('Status' => 'success', 'Message' => 'Izveštaj je poslat na štampu!!!'));
                    die();
                } else {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Nema štampača za štampu izveštaja!!!'));
                    die();
                }
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Greska pri kreiranju fajla nema konobara...'));
                die();
            }
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Greska pri kreiranju fajla Nema radnog dana...'));
            die();
        }
    } elseif ($TipIzvestaja == 'IzvestajOperater') {
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Uska stampa prodaje za operatera Korisnik->" . $UserName;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
        $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE datum<='now()' AND pocetak=1 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetZd) == 1) {
            $ZdData = mysqli_fetch_array($GetZd);
            $ZdBroj = $ZdData['zdBroj'];
            $ZdVreme = ['zakljucenje'];
            $UserId = mysqli_real_escape_string($link, $_COOKIE['UserId']);
            $GetRacune = mysqli_query($link, "SELECT SUM(s.kolicina) as Kolicina, (s.cena-(s.cena*(IFNULL(if(a.dozvoljenPopust=1, r.popust/100, 0), 0)))) as cena, s.naziv 
                FROM racun r, stavkaracuna s, artikal a WHERE r.id=s.RACUN_ID AND s.ARTIKAL_ID=a.id AND
        r.zdBroj='$ZdBroj' AND r.KONOBAR_ID='$UserId' AND r.zatvoren=1 GROUP BY s.naziv, s.cena, r.popust ORDER BY naziv ASC") or die(mysqli_error($link));
            if (mysqli_num_rows($GetRacune) > 0) {
                $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1");
                if (mysqli_num_rows($GetStampacData) > 0) {
                    $StampacData = mysqli_fetch_array($GetStampacData);
                    if ($StampacData['tip'] == 'POSBANK80MM') {
                        $PrinterLetters = 40;
                    } else {
                        $PrinterLetters = 30;
                    }
                    $PrintString = "";
                    $PrintString .= FormatText(date('d.m.Y')) . "\n";

                    $PrintString .= FormatText('Izvestaj operatera ' . $_COOKIE['UserName']) . "\n";
                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";
                    $FourthLetters = $PrinterLetters / 4;
                    $FourthLetters = floor($FourthLetters);
                    $HalfLetters = $PrinterLetters - ($FourthLetters * 2);
                    $Ukupno = 0;
                    while ($rowRacuni = mysqli_fetch_array($GetRacune)) {
                        $Medjuzbir = $rowRacuni['Kolicina'] * $rowRacuni['cena'];
                        $Ukupno = $Ukupno + $Medjuzbir;
                        $PrintString .= str_pad(mb_substr($rowRacuni['naziv'], 0, $HalfLetters), $HalfLetters, " ", STR_PAD_RIGHT) . '' . str_pad(mb_substr($rowRacuni['Kolicina'], 0, $FourthLetters), $FourthLetters, " ", STR_PAD_LEFT) . '' . str_pad(mb_substr($Medjuzbir, 0, $FourthLetters), $FourthLetters, " ", STR_PAD_LEFT) . "\n";
                    }
                    $PrintString .= str_pad("-", $PrinterLetters, "-", STR_PAD_BOTH) . "\n";
                    $PrintString .= FormatTextHalfLeft("Ukupno:") . '' . FormatTextHalfRight($Ukupno) . "\n";
                    try {
                        // Enter the share name for your USB printer here
                        $NazivStampaca = $StampacData['naziv'];
                        if (strpos($NazivStampaca, "/")) {
                            $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                        } else {
                            $connector = new WindowsPrintConnector($NazivStampaca);
                        }
                        $printer = new Printer($connector);
                        $printer->pulse(1, 300, 300);
                        $printer->setPrintLeftMargin(0);
                        $printer->setJustification(Printer::JUSTIFY_LEFT);
                        $printer->text($PrintString);
                        $printer->feed();
                        $printer->cut();
                        $printer->close();
                    } catch (Exception $e) {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                        die();
                    }
                    echo json_encode(array('Status' => 'success', 'Message' => 'Izveštaj je poslat na štampu!!!'));
                    die();
                } else {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Nema štampača za štampu izveštaja!!!'));
                    die();
                }
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Greska pri kreiranju fajla nema podataka...'));
                die();
            }
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Greska pri kreiranju fajla Nema radnog dana...'));
            die();
        }
    } elseif ($TipIzvestaja == 'RazduzenjeKonobara') {
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Uska stampa razduzenja konobara Korisnik->" . $UserName;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
        $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetZd) == 1) {
            $Zd = mysqli_fetch_array($GetZd)['zdBroj'];
        }
        $UserId = mysqli_real_escape_string($link, $_COOKIE['UserId']);
        mysqli_query($link, "INSERT INTO zd_konobar(ZD_BROJ, KONOBAR_ID) VALUES ('$Zd', '$UserId')");
        $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaIzvestaje=1 ORDER BY id ASC LIMIT 1");
        if (mysqli_num_rows($GetStampacData) > 0) {
            $StampacData = mysqli_fetch_array($GetStampacData);
            if ($StampacData['tip'] == 'POSBANK80MM') {
                $PrinterLetters = 42;
            } else {
                $PrinterLetters = 30;
            }
            $UserId = mysqli_real_escape_string($link, $_COOKIE['UserId']);
            $GetLastWd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY zakljucenje DESC LIMIT 1") or die(mysqli_error($link));
            if (mysqli_num_rows($GetLastWd) == 1) {
                $ZdData = mysqli_fetch_array($GetLastWd);
                $ZdBroj = $ZdData['zdBroj'];
                $ZdVreme = $ZdData['zakljucenje'];
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nema otvorenog radnog dana!!!'));
                die();
            }
            $GetUserData = mysqli_query($link, "SELECT * FROM konobar WHERE id='$UserId'") or die(mysqli_error($link));
            if (mysqli_num_rows($GetUserData) == 1) {
                $UserData = mysqli_fetch_array($GetUserData);
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nema korisnickog naloga!!!'));
                die();
            }
            $SGID = 0;
            $UserSifra = $UserData['sifra'];
            $GetSG = mysqli_query($link, "SELECT * FROM stalnigost WHERE sifra='$UserSifra' AND blokiran=0") or die(mysqli_error($link));
            if (mysqli_num_rows($GetSG) == 1) {
                $SGData = mysqli_fetch_array($GetSG);
                $SGID = $SGData['id'];
            }
            $GetSaleData = mysqli_query($link, "SELECT r.*, sr.kolicina, sr.naziv, sr.cena, sr.ARTIKAL_ID, sr.RACUN_ID FROM racun r, stavkaracuna sr WHERE r.id=sr.RACUN_ID AND r.zdBroj='$ZdBroj' AND r.KONOBAR_ID='$UserId' ORDER BY r.id ASC, sr.id ASC") or die(mysqli_error($link));
            if (mysqli_num_rows($GetSaleData) > 0) {
                $Payments = [];
                $GetPaymentData = mysqli_query($link, "SELECT * FROM placanje WHERE vreme>='$ZdVreme' ORDER BY id ASC") or die(mysqli_error($link));
                if (mysqli_num_rows($GetPaymentData) > 0) {
                    while ($rowPaymentData = mysqli_fetch_array($GetPaymentData)) {
                        $Payments[$rowPaymentData['RACUN_ID']][$rowPaymentData['id']] = ['Nacin' => $rowPaymentData['nacin'], 'Iznos' => $rowPaymentData['iznos']];
                    }
                }
                $Grupe = [];
                $GetGrupe = mysqli_query($link, "SELECT * FROM grupaartikala");
                if (mysqli_num_rows($GetGrupe) > 0) {
                    while ($rowGrupe = mysqli_fetch_array($GetGrupe)) {
                        $Grupe[$rowGrupe['id']] = $rowGrupe;
                    }
                }
                $PodGrupe = [];
                $GetPodGrupe = mysqli_query($link, "SELECT * FROM podgrupaartikala");
                if (mysqli_num_rows($GetPodGrupe) > 0) {
                    while ($rowPodGrupe = mysqli_fetch_array($GetPodGrupe)) {
                        $PodGrupe[$rowPodGrupe['id']] = $rowPodGrupe;
                    }
                }
                $Artikli = [];
                $GetArtikle = mysqli_query($link, "SELECT * FROM artikal");
                if (mysqli_num_rows($GetArtikle) > 0) {
                    while ($rowArtikal = mysqli_fetch_array($GetArtikle)) {
                        $Artikli[$rowArtikal['id']] = $rowArtikal;
                    }
                }
                $StornoIznos = 0;
                $StornoBroj = [];
                $PoGrupama = [];
                $PoPodgrupama = [];
                $PoArtiklima = [];
                $PoPlacanjima = [];
                $NeNaplaceno = [];
                $PopustNaPopust = 0;
                $PopustNaPopustTotal = 0;
                $NaplaceniIznosi = [];
                $NaplaceniBrojeviRacuna = [];
                $RacuniData = [];
                $NenaplacenoBroj = [];
                while ($rowSaleData = mysqli_fetch_array($GetSaleData)) {
                    $RacunId = $rowSaleData['RACUN_ID'];
                    if ($rowSaleData['zatvoren'] == TRUE) {
                        if ($rowSaleData['storniran'] == TRUE) {
                            //$StornoIznos = $StornoIznos + (($rowSaleData['kolicina'] * $rowSaleData['cena']) - (($rowSaleData['kolicina'] * $rowSaleData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                            //$StornoBroj[$rowSaleData['RACUN_ID']] = $rowSaleData['RACUN_ID'];
                        } else {
                            if ($rowSaleData['menipromet'] > 0) {
                                if (empty($PoArtiklima["MENI" . $RacunId])) {
                                    $GetMeni = mysqli_query($link, "SELECT * FROM menipromet WHERE RACUN_ID='$RacunId'") or die(mysqli_error($link));
                                    if (mysqli_num_rows($GetMeni) == 1) {
                                        $MeniData = mysqli_fetch_array($GetMeni);
                                        $PoArtiklima["MENI" . $RacunId]['Iznos'] = (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                        $PoArtiklima["MENI" . $RacunId]['Kolicina'] = $MeniData['kolicina'];
                                        $PoArtiklima["MENI" . $RacunId]['Naziv'] = $MeniData['naziv'];
                                        $PoArtiklima["MENI" . $RacunId]['Id'] = 0;
                                        $PoArtiklima["MENI" . $RacunId]['PodGrupa'] = 0;
                                    }
                                    if (!empty($RacuniData[$RacunId])) {
                                        $RacuniData[$RacunId]['Iznos'] = $RacuniData[$RacunId]['Iznos'] + (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                    } else {
                                        if ($rowSaleData['crnoPlacanje'] == '') {
                                            $RacuniData[$RacunId]['CrnoPlacanje'] = "";
                                        } else {
                                            $RacuniData[$RacunId]['CrnoPlacanje'] = $rowSaleData['crnoPlacanje'];
                                        }
                                        $RacuniData[$RacunId]['Iznos'] = (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                    }
                                    $PodGrupa = 0;
                                    if (!empty($PoPodgrupama[$PodGrupa]['Iznos'])) {
                                        $PoPodgrupama[$PodGrupa]['Iznos'] = $PoPodgrupama[$PodGrupa]['Iznos'] + (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                    } else {
                                        $PoPodgrupama[$PodGrupa]['Iznos'] = (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                        $PoPodgrupama[$PodGrupa]['Naziv'] = 'Meni';
                                    }
                                    $Grupa = 0;
                                    if (!empty($PoGrupama[$Grupa]['Iznos'])) {
                                        $PoGrupama[$Grupa]['Iznos'] = $PoGrupama[$Grupa]['Iznos'] + (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                    } else {
                                        $PoGrupama[$Grupa]['Iznos'] = (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                        $PoGrupama[$Grupa]['Naziv'] = 'Meni';
                                    }
                                    if ($rowSaleData['STALNIGOST_ID'] == $SGID) {
                                        $PopustNaPopustTotal = $PopustNaPopustTotal + ($MeniData['kolicina'] * $MeniData['cena']);
                                        $PopustNaPopust = $PopustNaPopust + (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                    }
                                }
                            } else {
                                if ($rowSaleData['STALNIGOST_ID'] == $SGID) {
                                    $PopustNaPopustTotal = $PopustNaPopustTotal + ($rowSaleData['kolicina'] * $rowSaleData['cena']);
                                    if ($Artikli[$rowSaleData['ARTIKAL_ID']]['dozvoljenPopust'] == TRUE) {
                                        $PopustNaPopust = $PopustNaPopust + (($rowSaleData['kolicina'] * $rowSaleData['cena']) - (($rowSaleData['kolicina'] * $rowSaleData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                    } else {
                                        $PopustNaPopust = $PopustNaPopust + ($rowSaleData['kolicina'] * $rowSaleData['cena']);
                                    }
                                }
                                if ($Artikli[$rowSaleData['ARTIKAL_ID']]['dozvoljenPopust'] == TRUE) {
                                    $LineTotal = (($rowSaleData['kolicina'] * $rowSaleData['cena']) - (($rowSaleData['kolicina'] * $rowSaleData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                } else {
                                    $LineTotal = $rowSaleData['kolicina'] * $rowSaleData['cena'];
                                }
                                $PodGrupa = $Artikli[$rowSaleData['ARTIKAL_ID']]['PODGRUPA_ID'];
                                if (!empty($PoPodgrupama[$PodGrupa]['Iznos'])) {
                                    $PoPodgrupama[$PodGrupa]['Iznos'] = $PoPodgrupama[$PodGrupa]['Iznos'] + $LineTotal;
                                } else {
                                    $PoPodgrupama[$PodGrupa]['Iznos'] = $LineTotal;
                                    $PoPodgrupama[$PodGrupa]['Naziv'] = $PodGrupe[$PodGrupa]['naziv'];
                                }
                                $Grupa = $PodGrupe[$PodGrupa]['GRUPA_ID'];
                                if (!empty($PoGrupama[$Grupa]['Iznos'])) {
                                    $PoGrupama[$Grupa]['Iznos'] = $PoGrupama[$Grupa]['Iznos'] + $LineTotal;
                                } else {
                                    $PoGrupama[$Grupa]['Iznos'] = $LineTotal;
                                    $PoGrupama[$Grupa]['Naziv'] = $Grupe[$Grupa]['naziv'];
                                }

                                if (!empty($PoArtiklima[$rowSaleData['ARTIKAL_ID']])) {
                                    $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Iznos'] = $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Iznos'] + $LineTotal;
                                    $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Kolicina'] = $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Kolicina'] + $rowSaleData['kolicina'];
                                } else {
                                    $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Iznos'] = $LineTotal;
                                    $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Kolicina'] = $rowSaleData['kolicina'];
                                    $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Naziv'] = $rowSaleData['naziv'];
                                    $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Id'] = $rowSaleData['ARTIKAL_ID'];
                                    $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['PodGrupa'] = $PodGrupa;
                                }
                                if (!empty($RacuniData[$RacunId])) {
                                    $RacuniData[$RacunId]['Iznos'] = $RacuniData[$RacunId]['Iznos'] + $LineTotal;
                                } else {
                                    if ($rowSaleData['crnoPlacanje'] == '') {
                                        $RacuniData[$RacunId]['CrnoPlacanje'] = "";
                                    } else {
                                        $RacuniData[$RacunId]['CrnoPlacanje'] = $rowSaleData['crnoPlacanje'];
                                    }
                                    $RacuniData[$RacunId]['Iznos'] = $LineTotal;
                                }
                            }
                        }
                    } else {
                        if (!empty($NeNaplaceno[$rowSaleData['ARTIKAL_ID']])) {
                            $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Kolicina'] = $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Kolicina'] + $rowSaleData['kolicina'];
                            $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Iznos'] = $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Iznos'] + ($rowSaleData['cena'] * $rowSaleData['kolicina']);
                        } else {
                            $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Naziv'] = $rowSaleData['naziv'];
                            $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Kolicina'] = $rowSaleData['kolicina'];
                            $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Iznos'] = $rowSaleData['cena'] * $rowSaleData['kolicina'];
                        }
                        $NenaplacenoBroj[$RacunId] = $RacunId;
                    }
                }
                if (!empty($RacuniData)) {
                    foreach ($RacuniData as $RacunId => $Racun) {
                        if ($Racun['CrnoPlacanje'] != '') {
                            if (!empty($NaplaceniIznosi[$Racun['CrnoPlacanje']])) {
                                $NaplaceniIznosi[$Racun['CrnoPlacanje']] = $NaplaceniIznosi[$Racun['CrnoPlacanje']] + $Racun['Iznos'];
                            } else {
                                $NaplaceniIznosi[$Racun['CrnoPlacanje']] = $Racun['Iznos'];
                            }
                            if (!empty($NaplaceniBrojeviRacuna[$Racun['CrnoPlacanje']])) {
                                $NaplaceniBrojeviRacuna[$Racun['CrnoPlacanje']] = $NaplaceniBrojeviRacuna[$Racun['CrnoPlacanje']] + 1;
                            } else {
                                $NaplaceniBrojeviRacuna[$Racun['CrnoPlacanje']] = 1;
                            }
                        } else {
                            $CountPayments = $Payments[$RacunId];
                            if (count($CountPayments) > 1) {
                                if (!empty($NaplaceniBrojeviRacuna['KOMBINOVANO'])) {
                                    $NaplaceniBrojeviRacuna['KOMBINOVANO'] = $NaplaceniBrojeviRacuna['KOMBINOVANO'] + 1;
                                } else {
                                    $NaplaceniBrojeviRacuna['KOMBINOVANO'] = 1;
                                }
                            } else {
                                foreach ($CountPayments as $PaymentData) {
                                    if (!empty($NaplaceniBrojeviRacuna[$PaymentData['Nacin']])) {
                                        $NaplaceniBrojeviRacuna[$PaymentData['Nacin']] = $NaplaceniBrojeviRacuna[$PaymentData['Nacin']] + 1;
                                    } else {
                                        $NaplaceniBrojeviRacuna[$PaymentData['Nacin']] = 1;
                                    }
                                }
                            }
                            foreach ($CountPayments as $PaymentData) {
                                if (!empty($NaplaceniIznosi[$PaymentData['Nacin']])) {
                                    $NaplaceniIznosi[$PaymentData['Nacin']] = $NaplaceniIznosi[$PaymentData['Nacin']] + $PaymentData['Iznos'];
                                } else {
                                    $NaplaceniIznosi[$PaymentData['Nacin']] = $PaymentData['Iznos'];
                                }
                            }
                        }
                    }
                }
                $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE datum<='now()' AND pocetak=1 ORDER BY id DESC LIMIT 1");
                if (mysqli_num_rows($GetZd) == 1) {
                    $ZdVreme = mysqli_fetch_array($GetZd)['zakljucenje'];
                    $GetStorno = mysqli_query($link, "SELECT * FROM storno s, stornostavka ss  WHERE s.vremeStorniranja>='$ZdVreme' AND s.KONOBAR_ID='$UserId' AND s.id=ss.STORNO_ID ORDER BY s.id ASC") or die(mysqli_error($link));
                    if (mysqli_num_rows($GetStorno) > 0) {
                        while ($rowStorno = mysqli_fetch_array($GetStorno)) {
                            $StornoIznos = $StornoIznos + $rowStorno['vrednost'];
                            $StornoBroj[$rowStorno['STORNO_ID']] = $rowStorno['STORNO_ID'];
                        }
                    }
                }
                $PrintString = "";
                $PrintString .= FormatText(date('d.m.Y H:i:s')) . "\n";

                $PrintString .= FormatText('Promet po operateru ') . "\n";

                $PrintString .= FormatText($_COOKIE['UserName']) . "\n";

                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";
                $FourthLetters = $PrinterLetters / 4;
                $FourthLetters = floor($FourthLetters);
                $HalfLetters = $PrinterLetters - ($FourthLetters * 2);
                if (isset($_POST['UskaStampaRazduzenja'])) {
                    if ($_POST['UskaStampaRazduzenja'] == 'true') {

                        $PrintString .= FormatText('Nenaplaćeni stolovi: ' . count($NenaplacenoBroj) . 'kom') . "\n";

                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                        $TotalNenaplaceno = 0;
                        foreach ($NeNaplaceno as $Artikal) {
                            $Cena = $Artikal['Iznos'] / $Artikal['Kolicina'];
                            $PrintString .= str_pad(mb_substr($Artikal['Naziv'], 0, $HalfLetters, 'UTF-8'), $HalfLetters, " ", STR_PAD_RIGHT) . '' . str_pad(mb_substr(number_format($Artikal['Kolicina'], 2, '.', ''), 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . '' . str_pad(mb_substr(number_format($Artikal['Iznos'], 2, '.', ''), 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . "\n";
                            $TotalNenaplaceno = $TotalNenaplaceno + $Artikal['Iznos'];
                        }
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                        $PrintString .= str_pad(mb_substr("UKUPNO", 0, $HalfLetters, 'UTF-8'), $HalfLetters, " ", STR_PAD_RIGHT) . '' . str_pad(" ", $FourthLetters, " ", STR_PAD_LEFT) . '' . str_pad(mb_substr($TotalNenaplaceno, 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . "\n";

                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                        $PrintString .= str_pad(" ", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                        $Total = 0;
                        $TotalKolicina = 0;
                        foreach ($PoPodgrupama as $PodGrupaId => $PodGrupa) {
                            $TotalPodGrupa = 0;
                            $TotalKolicinaPodGrupa = 0;
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                            $PrintString .= FormatText($PodGrupa['Naziv']) . "\n";

                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";
                            foreach ($PoArtiklima as $Artikal) {
                                if ($Artikal['PodGrupa'] == $PodGrupaId) {
                                    $Cena = $Artikal['Iznos'] / $Artikal['Kolicina'];

                                    $PrintString .= str_pad(mb_substr($Artikal['Naziv'], 0, $HalfLetters, 'UTF-8'), $HalfLetters, " ", STR_PAD_RIGHT) . '' . str_pad(mb_substr(number_format($Artikal['Kolicina'], 2, '.', ''), 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . '' . str_pad(mb_substr(number_format($Artikal['Iznos'], 2, '.', ''), 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . "\n";
                                    $TotalPodGrupa = $TotalPodGrupa + $Artikal['Iznos'];
                                    $TotalKolicinaPodGrupa = $TotalKolicinaPodGrupa + $Artikal['Kolicina'];
                                }
                            }
                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                            $PrintString .= str_pad(mb_substr("UKUPNO", 0, $HalfLetters, 'UTF-8'), $HalfLetters, " ", STR_PAD_RIGHT) . '' . str_pad(mb_substr(number_format($TotalKolicinaPodGrupa, 2, '.', ''), 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . '' . str_pad(mb_substr(number_format($TotalPodGrupa, 2, '.', ''), 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . "\n";

                            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                            $Total = $Total + $TotalPodGrupa;
                            $TotalKolicina = $TotalKolicina + $TotalKolicinaPodGrupa;
                        }

                        $PrintString .= str_pad(mb_substr("UKUPNO", 0, $HalfLetters, 'UTF-8'), $HalfLetters, " ", STR_PAD_RIGHT) . '' . str_pad(mb_substr(number_format($TotalKolicina, 2, '.', ''), 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . '' . str_pad(mb_substr(number_format($Total, 2, '.', ''), 0, $FourthLetters, 'UTF-8'), $FourthLetters, " ", STR_PAD_LEFT) . "\n";

                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                        $PrintString .= str_pad(" ", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                        $PrintString .= FormatTextHalfLeft('Podgrupe') . '' . FormatTextHalfRight('Total') . "\n";

                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                        $TotalPodGrupe = 0;
                        foreach ($PoPodgrupama as $PodGrupa) {
                            $PrintString .= FormatTextHalfLeft($PodGrupa['Naziv']) . '' . FormatTextHalfRight(number_format($PodGrupa['Iznos'], 2, '.', '')) . "\n";
                            $TotalPodGrupe = $TotalPodGrupe + $PodGrupa['Iznos'];
                        }
                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                        $PrintString .= FormatTextHalfLeft('UKUPNO') . '' . FormatTextHalfRight(number_format($TotalPodGrupe, 2, '.', '')) . "\n";

                        $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                        $PrintString .= str_pad(" ", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                    }
                }

                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                $PrintString .= FormatTextHalfLeft('Instrument placanja') . '' . FormatTextHalfRight('Neto iznos') . "\n";

                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                if ($NaplaceniIznosi['GOTOVINA'] > 0) {
                    $PrintString .= FormatTextHalfLeft('GOTOVINA') . '' . FormatTextHalfRight(number_format($NaplaceniIznosi['GOTOVINA'], 2, '.', '')) . "\n";
                }
                if ($NaplaceniIznosi['KARTICA'] > 0) {
                    $PrintString .= FormatTextHalfLeft('KARTICA') . '' . FormatTextHalfRight(number_format($NaplaceniIznosi['KARTICA'], 2, '.', '')) . "\n";
                }
                if ($NaplaceniIznosi['CEK'] > 0) {
                    $PrintString .= FormatTextHalfLeft('CEK') . '' . FormatTextHalfRight(number_format($NaplaceniIznosi['CEK'], 2, '.', '')) . "\n";
                }
                if ($NaplaceniIznosi['FAKTURA'] > 0) {
                    $PrintString .= FormatTextHalfLeft('FAKTURA') . '' . FormatTextHalfRight(number_format($NaplaceniIznosi['FAKTURA'], 2, '.', '')) . "\n";
                }
                $TotalIznos = 0;
                foreach ($NaplaceniIznosi as $Nacin => $Iznos) {
                    if ($Nacin != 'GOTOVINA' && $Nacin != 'CEK' && $Nacin != 'KARTICA' && $Nacin != 'FAKTURA') {
                        $PrintString .= FormatTextHalfLeft($Nacin) . '' . FormatTextHalfRight(number_format($Iznos, 2, '.', '')) . "\n";
                    }
                    $TotalIznos = $TotalIznos + $Iznos;
                }
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                $PrintString .= FormatTextHalfLeft('UKUPNO') . '' . FormatTextHalfRight(number_format($TotalIznos, 2, '.', '')) . "\n";

                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                $PrintString .= str_pad(" ", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                $PrintString .= FormatTextHalfLeft('Nacin placanja') . '' . FormatTextHalfRight('Broj racuna') . "\n";

                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                if ($NaplaceniBrojeviRacuna['GOTOVINA'] > 0) {
                    $PrintString .= FormatTextHalfLeft('GOTOVINA') . '' . FormatTextHalfRight(number_format($NaplaceniBrojeviRacuna['GOTOVINA'], 0, '.', '')) . "\n";
                }
                if ($NaplaceniBrojeviRacuna['KARTICA'] > 0) {
                    $PrintString .= FormatTextHalfLeft('KARTICA') . '' . FormatTextHalfRight(number_format($NaplaceniBrojeviRacuna['KARTICA'], 0, '.', '')) . "\n";
                }
                if ($NaplaceniBrojeviRacuna['CEK'] > 0) {
                    $PrintString .= FormatTextHalfLeft('CEK') . '' . FormatTextHalfRight(number_format($NaplaceniBrojeviRacuna['CEK'], 0, '.', '')) . "\n";
                }
                if ($NaplaceniBrojeviRacuna['FAKTURA'] > 0) {
                    $PrintString .= FormatTextHalfLeft('FAKTURA') . '' . FormatTextHalfRight(number_format($NaplaceniBrojeviRacuna['FAKTURA'], 0, '.', '')) . "\n";
                }
                if ($NaplaceniBrojeviRacuna['KOMBINOVANO'] > 0) {
                    $PrintString .= FormatTextHalfLeft('KOMBINOVANO') . '' . FormatTextHalfRight(number_format($NaplaceniBrojeviRacuna['KOMBINOVANO'], 0, '.', '')) . "\n";
                }
                $TotalBrojevi = 0;
                foreach ($NaplaceniBrojeviRacuna as $Nacin => $Broj) {
                    if ($Nacin != 'GOTOVINA' && $Nacin != 'CEK' && $Nacin != 'KARTICA' && $Nacin != 'FAKTURA' && $Nacin != 'KOMBINOVANO') {
                        $PrintString .= FormatTextHalfLeft($Nacin) . '' . FormatTextHalfRight(number_format($Broj, 0, '.', '')) . "\n";
                    }
                    $TotalBrojevi = $TotalBrojevi + $Broj;
                }
                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                $PrintString .= FormatTextHalfLeft('UKUPNO') . '' . FormatTextHalfRight(number_format($TotalBrojevi, 0, '.', '')) . "\n";

                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                $PrintString .= str_pad(" ", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                $PrintString .= FormatTextHalfLeft('Ukupno storno') . '' . FormatTextHalfRight(number_format($StornoIznos, 2, '.', '')) . "\n";

                $PrintString .= FormatTextHalfLeft('Broj storna') . '' . FormatTextHalfRight(count($StornoBroj)) . "\n";

                $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                $PrintString .= str_pad(" ", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

                if ($PopustNaPopust > 0) {
                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                    $PrintString .= FormatText('Promet stalnog gosta') . "\n";

                    $PrintString .= FormatText($SGData['naziv']) . "\n";

                    $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";

                    $PrintString .= FormatTextHalfLeft('Ukupno') . '' . FormatTextHalfRight(number_format($PopustNaPopustTotal, 2, '.', '')) . "\n";

                    $PrintString .= FormatTextHalfLeft('Popust sg') . '' . FormatTextHalfRight(number_format($SGData['popust'], 1, '.', '') . "%") . "\n";

                    $SaPopustom = $PopustNaPopustTotal - $PopustNaPopust;
                    $PrintString .= FormatTextHalfLeft('Ostvaren popust') . '' . FormatTextHalfRight(number_format($SaPopustom, 1, '.', '')) . "\n";

                    $PrintString .= str_pad(" ", $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
                }

                try {
                    // Enter the share name for your USB printer here
                    $NazivStampaca = $StampacData['naziv'];
                    if (strpos($NazivStampaca, "/")) {
                        $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                    } else {
                        $connector = new WindowsPrintConnector($NazivStampaca);
                    }
                    $printer = new Printer($connector);
                    $printer->pulse(1, 300, 300);
                    $printer->setPrintLeftMargin(0);
                    $printer->setJustification(Printer::JUSTIFY_LEFT);
                    $printer->text($PrintString);
                    $printer->feed();
                    $printer->cut();
                    $printer->close();
                } catch (Exception $e) {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                    die();
                }
                echo json_encode(array('Status' => 'success', 'Message' => 'Izveštaj je poslat na štampu!!!'));
                die();
                die();
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nema podataka za prikaz!!!'));
                die();
            }
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Nema štampača za štampu izveštaja!!!'));
            die();
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nepoznat tip izveštaja!!!'));
    }
    die();
}
if (isset($_POST['GetOperater3'])) {
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Pregled razduzenja konobara Korisnik->" . $UserName;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    $UserId = mysqli_real_escape_string($link, $_COOKIE['UserId']);
    $GetLastWd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY zakljucenje DESC LIMIT 1") or die(mysqli_error($link));
    if (mysqli_num_rows($GetLastWd) == 1) {
        $ZdData = mysqli_fetch_array($GetLastWd);
        $ZdBroj = $ZdData['zdBroj'];
        $ZdVreme = $ZdData['zakljucenje'];
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema otvorenog radnog dana!!!'));
        die();
    }
    $GetUserData = mysqli_query($link, "SELECT * FROM konobar WHERE id='$UserId'") or die(mysqli_error($link));
    if (mysqli_num_rows($GetUserData) == 1) {
        $UserData = mysqli_fetch_array($GetUserData);
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema korisnickog naloga!!!'));
        die();
    }
    $SGID = 0;
    $UserSifra = $UserData['sifra'];
    $GetSG = mysqli_query($link, "SELECT * FROM stalnigost WHERE sifra='$UserSifra' AND blokiran=0") or die(mysqli_error($link));
    if (mysqli_num_rows($GetSG) == 1) {
        $SGData = mysqli_fetch_array($GetSG);
        $SGID = $SGData['id'];
    }
    $GetSaleData = mysqli_query($link, "SELECT r.*, sr.kolicina, sr.naziv, sr.cena, sr.ARTIKAL_ID, sr.RACUN_ID FROM racun r, stavkaracuna sr WHERE r.id=sr.RACUN_ID AND r.zdBroj='$ZdBroj' AND r.KONOBAR_ID='$UserId' ORDER BY r.id ASC, sr.id ASC") or die(mysqli_error($link));
    if (mysqli_num_rows($GetSaleData) > 0) {
        $Payments = [];
        $GetPaymentData = mysqli_query($link, "SELECT * FROM placanje WHERE vreme>='$ZdVreme' ORDER BY id ASC") or die(mysqli_error($link));
        if (mysqli_num_rows($GetPaymentData) > 0) {
            while ($rowPaymentData = mysqli_fetch_array($GetPaymentData)) {
                $Payments[$rowPaymentData['RACUN_ID']][$rowPaymentData['id']] = ['Nacin' => $rowPaymentData['nacin'], 'Iznos' => $rowPaymentData['iznos']];
            }
        }
        $Grupe = [];
        $GetGrupe = mysqli_query($link, "SELECT * FROM grupaartikala");
        if (mysqli_num_rows($GetGrupe) > 0) {
            while ($rowGrupe = mysqli_fetch_array($GetGrupe)) {
                $Grupe[$rowGrupe['id']] = $rowGrupe;
            }
        }
        $PodGrupe = [];
        $GetPodGrupe = mysqli_query($link, "SELECT * FROM podgrupaartikala");
        if (mysqli_num_rows($GetPodGrupe) > 0) {
            while ($rowPodGrupe = mysqli_fetch_array($GetPodGrupe)) {
                $PodGrupe[$rowPodGrupe['id']] = $rowPodGrupe;
            }
        }
        $Artikli = [];
        $GetArtikle = mysqli_query($link, "SELECT * FROM artikal");
        if (mysqli_num_rows($GetArtikle) > 0) {
            while ($rowArtikal = mysqli_fetch_array($GetArtikle)) {
                $Artikli[$rowArtikal['id']] = $rowArtikal;
            }
        }
        $StornoIznos = 0;
        $StornoBroj = [];
        $PoGrupama = [];
        $PoPodgrupama = [];
        $PoArtiklima = [];
        $PoPlacanjima = [];
        $NeNaplaceno = [];
        $PopustNaPopust = 0;
        $PopustNaPopustTotal = 0;
        $NaplaceniIznosi = [];
        $NaplaceniBrojeviRacuna = [];
        $RacuniData = [];
        $NenaplacenoBroj = [];
        while ($rowSaleData = mysqli_fetch_array($GetSaleData)) {
            $RacunId = $rowSaleData['RACUN_ID'];
            if ($rowSaleData['zatvoren'] == TRUE) {
                if ($rowSaleData['storniran'] == TRUE) {
                    //$StornoIznos = $StornoIznos + (($rowSaleData['kolicina'] * $rowSaleData['cena']) - (($rowSaleData['kolicina'] * $rowSaleData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                    //$StornoBroj[$rowSaleData['RACUN_ID']] = $rowSaleData['RACUN_ID'];
                } else {
                    if ($rowSaleData['menipromet'] > 0) {
                        if (empty($PoArtiklima["MENI" . $RacunId])) {
                            $GetMeni = mysqli_query($link, "SELECT * FROM menipromet WHERE RACUN_ID='$RacunId'") or die(mysqli_error($link));
                            if (mysqli_num_rows($GetMeni) == 1) {
                                $MeniData = mysqli_fetch_array($GetMeni);
                                $PoArtiklima["MENI" . $RacunId]['Iznos'] = (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                $PoArtiklima["MENI" . $RacunId]['Kolicina'] = $MeniData['kolicina'];
                                $PoArtiklima["MENI" . $RacunId]['Naziv'] = $MeniData['naziv'];
                                $PoArtiklima["MENI" . $RacunId]['Id'] = 0;
                                $PoArtiklima["MENI" . $RacunId]['PodGrupa'] = 0;
                            }
                            if (!empty($RacuniData[$RacunId])) {
                                $RacuniData[$RacunId]['Iznos'] = $RacuniData[$RacunId]['Iznos'] + (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                            } else {
                                if ($rowSaleData['crnoPlacanje'] == '') {
                                    $RacuniData[$RacunId]['CrnoPlacanje'] = "";
                                } else {
                                    $RacuniData[$RacunId]['CrnoPlacanje'] = $rowSaleData['crnoPlacanje'];
                                }
                                $RacuniData[$RacunId]['Iznos'] = (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                            }
                            $PodGrupa = 0;
                            if (!empty($PoPodgrupama[$PodGrupa]['Iznos'])) {
                                $PoPodgrupama[$PodGrupa]['Iznos'] = $PoPodgrupama[$PodGrupa]['Iznos'] + (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                            } else {
                                $PoPodgrupama[$PodGrupa]['Iznos'] = (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                $PoPodgrupama[$PodGrupa]['Naziv'] = 'Meni';
                            }
                            $Grupa = 0;
                            if (!empty($PoGrupama[$Grupa]['Iznos'])) {
                                $PoGrupama[$Grupa]['Iznos'] = $PoGrupama[$Grupa]['Iznos'] + (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                            } else {
                                $PoGrupama[$Grupa]['Iznos'] = (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                                $PoGrupama[$Grupa]['Naziv'] = 'Meni';
                            }
                            if ($rowSaleData['STALNIGOST_ID'] == $SGID) {
                                $PopustNaPopustTotal = $PopustNaPopustTotal + ($MeniData['kolicina'] * $MeniData['cena']);
                                $PopustNaPopust = $PopustNaPopust + (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                            }
                        }
                    } else {
                        if ($rowSaleData['STALNIGOST_ID'] == $SGID) {
                            $PopustNaPopustTotal = $PopustNaPopustTotal + ($rowSaleData['kolicina'] * $rowSaleData['cena']);
                            if ($Artikli[$rowSaleData['ARTIKAL_ID']]['dozvoljenPopust'] == TRUE) {
                                $PopustNaPopust = $PopustNaPopust + (($rowSaleData['kolicina'] * $rowSaleData['cena']) - (($rowSaleData['kolicina'] * $rowSaleData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                            } else {
                                $PopustNaPopust = $PopustNaPopust + ($rowSaleData['kolicina'] * $rowSaleData['cena']);
                            }
                        }
                        if ($Artikli[$rowSaleData['ARTIKAL_ID']]['dozvoljenPopust'] == TRUE) {
                            $LineTotal = (($rowSaleData['kolicina'] * $rowSaleData['cena']) - (($rowSaleData['kolicina'] * $rowSaleData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                        } else {
                            $LineTotal = $rowSaleData['kolicina'] * $rowSaleData['cena'];
                        }
                        $PodGrupa = $Artikli[$rowSaleData['ARTIKAL_ID']]['PODGRUPA_ID'];
                        if (!empty($PoPodgrupama[$PodGrupa]['Iznos'])) {
                            $PoPodgrupama[$PodGrupa]['Iznos'] = $PoPodgrupama[$PodGrupa]['Iznos'] + $LineTotal;
                        } else {
                            $PoPodgrupama[$PodGrupa]['Iznos'] = $LineTotal;
                            $PoPodgrupama[$PodGrupa]['Naziv'] = $PodGrupe[$PodGrupa]['naziv'];
                        }
                        $Grupa = $PodGrupe[$PodGrupa]['GRUPA_ID'];
                        if (!empty($PoGrupama[$Grupa]['Iznos'])) {
                            $PoGrupama[$Grupa]['Iznos'] = $PoGrupama[$Grupa]['Iznos'] + $LineTotal;
                        } else {
                            $PoGrupama[$Grupa]['Iznos'] = $LineTotal;
                            $PoGrupama[$Grupa]['Naziv'] = $Grupe[$Grupa]['naziv'];
                        }

                        if (!empty($PoArtiklima[$rowSaleData['ARTIKAL_ID']])) {
                            $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Iznos'] = $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Iznos'] + $LineTotal;
                            $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Kolicina'] = $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Kolicina'] + $rowSaleData['kolicina'];
                        } else {
                            $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Iznos'] = $LineTotal;
                            $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Kolicina'] = $rowSaleData['kolicina'];
                            $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Naziv'] = $rowSaleData['naziv'];
                            $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Id'] = $rowSaleData['ARTIKAL_ID'];
                            $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['PodGrupa'] = $PodGrupa;
                        }
                        if (!empty($RacuniData[$RacunId])) {
                            $RacuniData[$RacunId]['Iznos'] = $RacuniData[$RacunId]['Iznos'] + $LineTotal;
                        } else {
                            if ($rowSaleData['crnoPlacanje'] == '') {
                                $RacuniData[$RacunId]['CrnoPlacanje'] = "";
                            } else {
                                $RacuniData[$RacunId]['CrnoPlacanje'] = $rowSaleData['crnoPlacanje'];
                            }
                            $RacuniData[$RacunId]['Iznos'] = $LineTotal;
                        }
                    }
                }
            } else {
                if (!empty($NeNaplaceno[$rowSaleData['ARTIKAL_ID']])) {
                    $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Kolicina'] = $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Kolicina'] + $rowSaleData['kolicina'];
                    $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Iznos'] = $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Iznos'] + ($rowSaleData['cena'] * $rowSaleData['kolicina']);
                } else {
                    $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Naziv'] = $rowSaleData['naziv'];
                    $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Kolicina'] = $rowSaleData['kolicina'];
                    $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Iznos'] = $rowSaleData['cena'] * $rowSaleData['kolicina'];
                }
                $NenaplacenoBroj[$RacunId] = $RacunId;
            }
        }
        if (!empty($RacuniData)) {
            foreach ($RacuniData as $RacunId => $Racun) {
                if ($Racun['CrnoPlacanje'] != '') {
                    if (!empty($NaplaceniIznosi[$Racun['CrnoPlacanje']])) {
                        $NaplaceniIznosi[$Racun['CrnoPlacanje']] = $NaplaceniIznosi[$Racun['CrnoPlacanje']] + $Racun['Iznos'];
                    } else {
                        $NaplaceniIznosi[$Racun['CrnoPlacanje']] = $Racun['Iznos'];
                    }
                    if (!empty($NaplaceniBrojeviRacuna[$Racun['CrnoPlacanje']])) {
                        $NaplaceniBrojeviRacuna[$Racun['CrnoPlacanje']] = $NaplaceniBrojeviRacuna[$Racun['CrnoPlacanje']] + 1;
                    } else {
                        $NaplaceniBrojeviRacuna[$Racun['CrnoPlacanje']] = 1;
                    }
                } else {
                    $CountPayments = $Payments[$RacunId];
                    if (count($CountPayments) > 1) {
                        if (!empty($NaplaceniBrojeviRacuna['KOMBINOVANO'])) {
                            $NaplaceniBrojeviRacuna['KOMBINOVANO'] = $NaplaceniBrojeviRacuna['KOMBINOVANO'] + 1;
                        } else {
                            $NaplaceniBrojeviRacuna['KOMBINOVANO'] = 1;
                        }
                    } else {
                        foreach ($CountPayments as $PaymentData) {
                            if (!empty($NaplaceniBrojeviRacuna[$PaymentData['Nacin']])) {
                                $NaplaceniBrojeviRacuna[$PaymentData['Nacin']] = $NaplaceniBrojeviRacuna[$PaymentData['Nacin']] + 1;
                            } else {
                                $NaplaceniBrojeviRacuna[$PaymentData['Nacin']] = 1;
                            }
                        }
                    }
                    foreach ($CountPayments as $PaymentData) {
                        if (!empty($NaplaceniIznosi[$PaymentData['Nacin']])) {
                            $NaplaceniIznosi[$PaymentData['Nacin']] = $NaplaceniIznosi[$PaymentData['Nacin']] + $PaymentData['Iznos'];
                        } else {
                            $NaplaceniIznosi[$PaymentData['Nacin']] = $PaymentData['Iznos'];
                        }
                    }
                }
            }
        }
        $GetZd = mysqli_query($link, "SELECT * FROM zd WHERE datum<='now()' AND pocetak=1 ORDER BY id DESC LIMIT 1");
        if (mysqli_num_rows($GetZd) == 1) {
            $ZdVreme = mysqli_fetch_array($GetZd)['zakljucenje'];
            $GetStorno = mysqli_query($link, "SELECT * FROM storno s, stornostavka ss WHERE s.vremeStorniranja>='$ZdVreme' AND s.KONOBAR_ID='$UserId' AND s.id=ss.STORNO_ID ORDER BY s.id ASC") or die(mysqli_error($link));
            if (mysqli_num_rows($GetStorno) > 0) {
                while ($rowStorno = mysqli_fetch_array($GetStorno)) {
                    $StornoIznos = $StornoIznos + $rowStorno['vrednost'];
                    $StornoBroj[$rowStorno['STORNO_ID']] = $rowStorno['STORNO_ID'];
                }
            }
        }
        $HtmlToReturn = "<table class='ReportTable'>
            <thead>
            <tr><th>Način plaćanja</th><th>Iznos</th></tr>
            </thead>
            <tbody>";
        $TotalIznos = 0;
        if ($NaplaceniIznosi['GOTOVINA'] > 0) {
            $HtmlToReturn .= "<tr>
                <td>GOTOVINA</td>
                <td>" . number_format($NaplaceniIznosi['GOTOVINA'], 2, '.', '') . "</td>
            </tr>";
        }
        if ($NaplaceniIznosi['KARTICA'] > 0) {
            $HtmlToReturn .= "<tr>
                <td>KARTICA</td>
                <td>" . number_format($NaplaceniIznosi['KARTICA'], 2, '.', '') . "</td>
            </tr>";
        }
        if ($NaplaceniIznosi['CEK'] > 0) {
            $HtmlToReturn .= "<tr>
                <td>CEK</td>
                <td>" . number_format($NaplaceniIznosi['CEK'], 2, '.', '') . "</td>
            </tr>";
        }
        if ($NaplaceniIznosi['FAKTURA'] > 0) {
            $HtmlToReturn .= "<tr>
                <td>FAKTURA</td>
                <td>" . number_format($NaplaceniIznosi['FAKTURA'], 2, '.', '') . "</td>
            </tr>";
        }

        foreach ($NaplaceniIznosi as $Nacin => $Iznos) {
            if ($Nacin != 'GOTOVINA' && $Nacin != 'CEK' && $Nacin != 'KARTICA' && $Nacin != 'FAKTURA') {
                $HtmlToReturn .= "<tr>
                    <td>" . $Nacin . "</td>
                    <td>" . number_format($Iznos, 2, '.', '') . "</td>
                </tr>";
            }
            $TotalIznos = $TotalIznos + $Iznos;
        }
        $HtmlToReturn .= "</tbody>";
        $HtmlToReturn .= "<tfoot><tr>
                <th>UKUPNO</th>
                <th>" . number_format($TotalIznos, 2, '.', '') . "</th>
            </tr></tfoot>";
        $HtmlToReturn .= "</table>";

        $HtmlToReturn .= "<table class='ReportTable'>
            <thead>
            <tr><th>Način plaćanja</th><th>Broj računa</th></tr>
            </thead>
            <tbody>";
        if ($NaplaceniBrojeviRacuna['GOTOVINA'] > 0) {
            $HtmlToReturn .= "<tr>
                <td>GOTOVINA</td>
                <td>" . number_format($NaplaceniBrojeviRacuna['GOTOVINA'], 0, '.', '') . "</td>
            </tr>";
        }
        if ($NaplaceniBrojeviRacuna['KARTICA'] > 0) {
            $HtmlToReturn .= "<tr>
                <td>KARTICA</td>
                <td>" . number_format($NaplaceniBrojeviRacuna['KARTICA'], 0, '.', '') . "</td>
            </tr>";
        }
        if ($NaplaceniBrojeviRacuna['CEK'] > 0) {
            $HtmlToReturn .= "<tr>
                <td>CEK</td>
                <td>" . number_format($NaplaceniBrojeviRacuna['CEK'], 0, '.', '') . "</td>
            </tr>";
        }
        if ($NaplaceniBrojeviRacuna['FAKTURA'] > 0) {
            $HtmlToReturn .= "<tr>
                <td>FAKTURA</td>
                <td>" . number_format($NaplaceniBrojeviRacuna['FAKTURA'], 0, '.', '') . "</td>
            </tr>";
        }
        if ($NaplaceniBrojeviRacuna['KOMBINOVANO'] > 0) {
            $HtmlToReturn .= "<tr>
                <td>KOMBINOVANO</td>
                <td>" . number_format($NaplaceniBrojeviRacuna['KOMBINOVANO'], 0, '.', '') . "</td>
            </tr>";
        }
        $TotalBrojevi = 0;
        foreach ($NaplaceniBrojeviRacuna as $Nacin => $Broj) {
            if ($Nacin != 'GOTOVINA' && $Nacin != 'CEK' && $Nacin != 'KARTICA' && $Nacin != 'FAKTURA' && $Nacin != 'KOMBINOVANO') {
                $HtmlToReturn .= "<tr>
                    <td>" . $Nacin . "</td>
                    <td>" . number_format($Broj, 0, '.', '') . "</td>
                </tr>";
            }
            $TotalBrojevi = $TotalBrojevi + $Broj;
        }
        $HtmlToReturn .= "</tbody>";
        $HtmlToReturn .= "<tfoot><tr>
                <th>UKUPNO</th>
                <th>" . number_format($TotalBrojevi, 0, '.', '') . "</th>
            </tr></tfoot>";
        $HtmlToReturn .= "</table>";

        $HtmlToReturn .= "<table class='ReportTable'>
            <tbody>";
        $HtmlToReturn .= "<tr>
                <td>Ukupno storno</td>
                <td>" . number_format($StornoIznos, 2, '.', '') . "</td>
            </tr>";
        $HtmlToReturn .= "<tr>
                <td>Broj storna</td>
                <td>" . count($StornoBroj) . "</td>
            </tr>";
        $HtmlToReturn .= "</tbody>";
        $HtmlToReturn .= "</table>";
        if ($PopustNaPopust > 0) {
            $HtmlToReturn .= "<table class='ReportTable'>
            <tbody>";
            $HtmlToReturn .= "<tr>
                    <td>Popust po stalnom gostu:</td>
                    <td>" . $SGData['naziv'] . "</td>
                </tr>";
            $HtmlToReturn .= "<tr>
                    <td>Ukupno</td>
                    <td>" . number_format($PopustNaPopustTotal, 2, '.', '') . "</td>
                </tr>";
            $HtmlToReturn .= "<tr>
                    <td>Popust</td>
                    <td>" . number_format($SGData['popust'], 1, '.', '') . "%</td>
                </tr>";
            $SaPopustom = $PopustNaPopustTotal - $PopustNaPopust;
            $HtmlToReturn .= "<tr>
                    <td>Ukupno sa popustom</td>
                    <td>" . number_format($PopustNaPopust, 1, '.', '') . "</td>
                </tr>";
            $HtmlToReturn .= "<tr>
                    <th>Ostvareni popust</th>
                    <th>" . number_format($SaPopustom, 1, '.', '') . "</th>
                </tr>";
            $HtmlToReturn .= "</tbody>";
            $HtmlToReturn .= "</table>";
        }
        $HtmlToReturn .= "<table class='ReportTable'>
            <thead>
            <tr><th>Grupe</th><th>Total</th></tr>
            </thead>
            <tbody>";
        $TotalGrupe = 0;
        foreach ($PoGrupama as $Grupa) {
            $HtmlToReturn .= "<tr>
                <td>" . $Grupa['Naziv'] . "</td>
                <td>" . number_format($Grupa['Iznos'], 2, '.', '') . "</td>
            </tr>";
            $TotalGrupe = $TotalGrupe + $Grupa['Iznos'];
        }
        $HtmlToReturn .= "</tbody>";
        $HtmlToReturn .= "<tfoot><tr>
                <th>UKUPNO</th>
                <th>" . number_format($TotalGrupe, 2, '.', '') . "</th>
            </tr></tfoot>";
        $HtmlToReturn .= "</table>";

        $HtmlToReturn .= "<table class='ReportTable'>
            <thead>
            <tr><th>Podgrupe</th><th>Total</th></tr>
            </thead>
            <tbody>";
        $TotalPodGrupe = 0;
        foreach ($PoPodgrupama as $PodGrupa) {
            $HtmlToReturn .= "<tr>
                <td>" . $PodGrupa['Naziv'] . "</td>
                <td>" . number_format($PodGrupa['Iznos'], 2, '.', '') . "</td>
            </tr>";
            $TotalPodGrupe = $TotalPodGrupe + $PodGrupa['Iznos'];
        }
        $HtmlToReturn .= "</tbody>";
        $HtmlToReturn .= "<tfoot><tr>
                <th>UKUPNO</th>
                <th>" . number_format($TotalPodGrupe, 2, '.', '') . "</th>
            </tr></tfoot>";
        $HtmlToReturn .= "</table>";

        $HtmlToReturn .= "<table class='ReportTable YellowLetters'>
            <thead>
            <tr><th colspan='4'>Nenaplaćeni stolovi</th></tr>
            <tr><th>Artikal</th><th>Kolicina</th><th>Cena</th><th>Total</th></tr>
            </thead>
            <tbody>";
        $TotalNenaplaceno = 0;
        foreach ($NeNaplaceno as $Artikal) {
            $Cena = $Artikal['Iznos'] / $Artikal['Kolicina'];
            $HtmlToReturn .= "<tr class='NenaplaceniArtikliNaStolovima'>
                        <td>" . $Artikal['Naziv'] . "</td>
                        <td>" . $Artikal['Kolicina'] . "</td>
                        <td>" . number_format($Cena, 2, '.', '') . "</td> 
                        <td>" . number_format($Artikal['Iznos'], 2, '.', '') . "</td>
                    </tr>";
            $TotalNenaplaceno = $TotalNenaplaceno + $Artikal['Iznos'];
        }
        $HtmlToReturn .= "</tbody>";
        $HtmlToReturn .= "<tfoot><tr>
                <th>UKUPNO</th>
                <th></th>
                <th>Stolova: " . count($NenaplacenoBroj) . "</th>
                <th>" . number_format($TotalNenaplaceno, 2, '.', '') . "</th>
            </tr></tfoot>";
        $HtmlToReturn .= "</table>";

        $HtmlToReturn .= "<table class='ReportTable'>
            <tbody>";
        $Total = 0;
        $TotalKolicina = 0;
        foreach ($PoPodgrupama as $PodGrupaId => $PodGrupa) {
            $TotalPodGrupa = 0;
            $TotalKolicinaPodGrupa = 0;
            $HtmlToReturn .= "<tr>
                <th colspan='4'>" . $PodGrupa['Naziv'] . "</th>
            </tr>
            <tr>
                <th>Artikal</th>
                <th>Količina</th>
                <th>Cena</th>
                <th>Iznos</th>
            </tr>
            ";
            foreach ($PoArtiklima as $Artikal) {
                if ($Artikal['PodGrupa'] == $PodGrupaId) {
                    $Cena = $Artikal['Iznos'] / $Artikal['Kolicina'];
                    $HtmlToReturn .= "<tr>
                        <td>" . $Artikal['Naziv'] . "</td>
                        <td>" . $Artikal['Kolicina'] . "</td>
                        <td>" . number_format($Cena, 2, '.', '') . "</td> 
                        <td>" . number_format($Artikal['Iznos'], 2, '.', '') . "</td>
                    </tr>";
                    $TotalPodGrupa = $TotalPodGrupa + $Artikal['Iznos'];
                    $TotalKolicinaPodGrupa = $TotalKolicinaPodGrupa + $Artikal['Kolicina'];
                }
            }
            $HtmlToReturn .= "<tr>
                        <th>UKUPNO</th>
                        <th>" . number_format($TotalKolicinaPodGrupa, 2, '.', '') . "</th>
                        <th></th>
                        <th>" . number_format($TotalPodGrupa, 2, '.', '') . "</th>
                    </tr>";
            $Total = $Total + $TotalPodGrupa;
            $TotalKolicina = $TotalKolicina + $TotalKolicinaPodGrupa;
        }

        $HtmlToReturn .= "</tbody>";
        $HtmlToReturn .= "<tfoot><tr>
                <th>UKUPNO</th>
                <th>" . number_format($TotalKolicina, 2, '.', '') . "</th>
                <th></th>
                <th>" . number_format($Total, 2, '.', '') . "</th>
            </tr></tfoot>";
        $HtmlToReturn .= "</table>";

        echo json_encode(array(
            'Status' => 'success', 'Message' => 'Uspesno!!!',
            'RacuniHtml' => $HtmlToReturn
        ));
        die();
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema podataka za prikaz!!!'));
        die();
    }
}
if (isset($_POST['PrintDeliveryData'])) {
    $DostavaAdresaID = mysqli_real_escape_string($link, $_POST['PrintDeliveryData']);
    $GetDostavaData = mysqli_query($link, "SELECT d.naziv, d.telefon, da.* FROM dostava d, dostava_adresa da WHERE d.id=da.DOSTAVA_ID AND da.id='$DostavaAdresaID'");
    if (mysqli_num_rows($GetDostavaData) == 1) {

        $GetPrinters = mysqli_query($link, "SELECT * FROM stampac WHERE 1 ORDER BY id ASC LIMIT 1");
        $BrojStampaca = mysqli_num_rows($GetPrinters);
        if ($BrojStampaca > 0) {
            $GeneralijeStampaca = mysqli_fetch_array($GetPrinters);
            $OdeljenjeNaziv = $GeneralijeStampaca['bnaziv'];
            $NazivStampaca = $GeneralijeStampaca['naziv'];
            $BrojKaraktera = 32;
            if ($GeneralijeStampaca['tip'] == 'POSBANK80MM') {
                $BrojKaraktera = 42;
            }
        } else {
            $NazivRacuna = 'Racun_' . date('Ymd_His');
        }
        $PrintString = "";
        $DostavaData = mysqli_fetch_array($GetDostavaData);
        $doc2 = new DOMDocument('1.0', 'UTF-8');
        $doc2->preserveWhiteSpace = false;
        $doc2->formatOutput = true;
        $ele2 = $doc2->createElement('NefiskalnaStampa');
        $eleH2 = $doc2->createElement('Linija');
        $eleH2->nodeValue = FormatTextLeft('==============================');
        $ele2->appendChild($eleH2);
        $PrintString .= str_pad("=", $BrojKaraktera, "=", STR_PAD_BOTH) . "\n";

        $eleH2 = $doc2->createElement('Linija');
        $eleH2->nodeValue = FormatText('Podaci o kupcu:');
        $ele2->appendChild($eleH2);
        $PrintString .= FormatText('Podaci o kupcu:') . "\n";

        $eleH2 = $doc2->createElement('Linija');
        $eleH2->nodeValue = FormatTextLeft('==============================');
        $ele2->appendChild($eleH2);
        $PrintString .= str_pad("=", $BrojKaraktera, "=", STR_PAD_BOTH) . "\n";

        $eleH2 = $doc2->createElement('Linija');
        $eleH2->nodeValue = $DostavaData['naziv'];
        $ele2->appendChild($eleH2);
        $PrintString .= $DostavaData['naziv'] . "\n";

        $eleH2 = $doc2->createElement('Linija');
        $eleH2->nodeValue = $DostavaData['telefon'];
        $ele2->appendChild($eleH2);
        $PrintString .= $DostavaData['telefon'] . "\n";

        $PrintAdresa = $DostavaData['adresa'];
        if ($DostavaData['broj'] != '') {
            $PrintAdresa .= " " . $DostavaData['broj'];
        }
        if ($DostavaData['mesto'] != '') {
            $PrintAdresa = $DostavaData['mesto'] . " " . $PrintAdresa;
        }
        if ($DostavaData['sprat'] != '') {
            $PrintAdresa .= " " . $DostavaData['sprat'];
        }

        $eleH2 = $doc2->createElement('Linija');
        $eleH2->nodeValue = $PrintAdresa;
        $ele2->appendChild($eleH2);
        $PrintString .= $PrintAdresa . "\n";

        if ($DostavaData['interfon'] != '') {
            $eleH2 = $doc2->createElement('Linija');
            $eleH2->nodeValue = 'Interfon: ' . $DostavaData['interfon'];
            $ele2->appendChild($eleH2);
            $PrintString .= 'Interfon: ' . $DostavaData['interfon'] . "\n";
        }
        if ($DostavaData['napomena'] != '') {
            $eleH2 = $doc2->createElement('Linija');
            $eleH2->nodeValue = 'NAPOMENA: ' . $DostavaData['napomena'];
            $ele2->appendChild($eleH2);
            $PrintString .= 'NAPOMENA: ' . $DostavaData['napomena'] . "\n";
        }

        $eleH2 = $doc2->createElement('Linija');
        $eleH2->nodeValue = FormatTextLeft('==============================');
        $ele2->appendChild($eleH2);
        $doc2->appendChild($ele2);
        $PrintString .= str_pad("=", $BrojKaraktera, "=", STR_PAD_BOTH) . "\n";

        if ($BrojStampaca > 0) {
            try {
                // Enter the share name for your USB printer here
                if (strpos($NazivStampaca, "/")) {
                    $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                } else {
                    $connector = new WindowsPrintConnector($NazivStampaca);
                }

                $printer = new Printer($connector);
                $printer->pulse(1, 300, 300);
                $printer->setPrintLeftMargin(0);
                $printer->setJustification(Printer::JUSTIFY_LEFT);
                $printer->text($PrintString);
                $printer->feed();
                $printer->cut();
                $printer->close();
            } catch (Exception $e) {
                echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $e->getMessage()));
                die();
            }
        } else {
            $doc2->save($SaveToReceipt . '/Dostava' . $NazivRacuna . '.xml');
        }
        echo json_encode(array('Status' => 'success', 'Message' => "Tiket za dostavu je poslat na štampu!"));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => "Tražena adresa ne postoji u bazi!"));
    }
    die();
}
if (isset($_POST['CheckPasswordToUnlockMedjuzbir'])) {
    $TableId = mysqli_real_escape_string($link, $_POST['TableToUnlockMedjuzbir']);
    $NasliSmo = 0;
    $Lozinka = mysqli_real_escape_string($link, $_POST['CheckPasswordToUnlockMedjuzbir']);
    $GetLoginStorno = mysqli_query($link, "SELECT * FROM login WHERE pass='$Lozinka' LIMIT 1") or die(mysqli_error($link));
    if (mysqli_num_rows($GetLoginStorno) == 1) {
        $NasliSmo = 1;
    }
    $GetKonobarStorno = mysqli_query($link, "SELECT * FROM konobar WHERE sifra='$Lozinka' AND nivo='SEF' LIMIT 1") or die(mysqli_error($link));
    if (mysqli_num_rows($GetKonobarStorno) == 1) {
        $NasliSmo = 1;
    }
    if ($NasliSmo == 0) {
        echo json_encode(array('Status' => 'error', 'Message' => 'Netačna lozinka!!!'));
        die();
    }
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Otkljucavanje stola sa medjuzbira Sto->" . $TableId . " Korisnik->" . $UserName . " Sifra->" . $Lozinka;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    mysqli_query($link, "UPDATE racun SET crnoPlacanje=NULL WHERE brojStola='$TableId' AND zatvoren=0");
    echo json_encode(array('Status' => 'success', 'Message' => 'Sto je otključan!!!'));
    die();
}
if (isset($_POST['PromenaPodesavanjaKase'])) {
    foreach ($_POST as $Key => $Value) {
        if ($Key != 'PromenaPodesavanjaKase') {
            $Key = mysqli_real_escape_string($link, $Key);
            $Value = mysqli_real_escape_string($link, $Value);
            mysqli_query($link, "DELETE FROM kasadata WHERE kasaId='$KasaId' AND kasaDataMeta='$Key'");
            mysqli_query($link, "INSERT INTO kasadata (kasaDataMeta, kasaDataValue, kasaId) VALUES ('$Key', '$Value', '$KasaId')");
        }
    }
    $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
    $LogDate = date('Y-m-d');
    $LogTime = date('H:i:s');
    $LogUser = $UserName;
    $LogWhat = "Promena podesavanja kase KASA_ID->" . $KasaId;
    mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    echo json_encode(array('Status' => 'success', 'Message' => "Podešavanja kase su uspešno završena! Neophodno je ponovno pokretanje sistema!"));
    die();
}
if (isset($_POST['GetAllOtherOperators'])) {
    $HtmlToReturn = "";
    $SviOperateri = [];
    $GetSveOperatere = mysqli_query($link, "SELECT * FROM konobar");
    if (mysqli_num_rows($GetSveOperatere) > 0) {
        while ($rowSviOperateri = mysqli_fetch_array($GetSveOperatere)) {
            $SviOperateri[$rowSviOperateri['id']] = $rowSviOperateri['punoIme'];
        }
    }
    $Operater = mysqli_real_escape_string($link, $_COOKIE['UserId']);
    $GetOperatera = mysqli_query($link, "SELECT * FROM konobar_kasa WHERE KONOBARI_ID!='$Operater' AND KASE_ID='$KasaId'");
    if (mysqli_num_rows($GetOperatera) > 0) {
        while ($rowOperater = mysqli_fetch_array($GetOperatera)) {
            if ($SviOperateri[$rowOperater['KONOBARI_ID']] != '') {
                $HtmlToReturn .= '<div class="Operater" operater-id="' . $rowOperater['KONOBARI_ID'] . '">
                    <span>' . $SviOperateri[$rowOperater['KONOBARI_ID']] . '</span>
                </div>';
            }
        }
    } else {
        $GetOperatera = mysqli_query($link, "SELECT * FROM konobar_kasa WHERE KASE_ID='$KasaId'");
        if (mysqli_num_rows($GetOperatera) == 0) {
            foreach ($SviOperateri as $Id => $Name) {
                if ($Id != $Operater) {
                    $HtmlToReturn .= '<div class="Operater" operater-id="' . $Id . '">
                    <span>' . $Name . '</span>
                </div>';
                }
            }
        }
    }
    echo json_encode(array('Status' => 'success', 'Message' => "", "HtmlToInsert" => $HtmlToReturn));
    die();
}
if (isset($_POST['GetAllGroupsChange'])) {
    $GetGroups = mysqli_query($link, "SELECT * FROM grupaartikala WHERE 1 ORDER BY prioritet ASC");
    if (mysqli_num_rows($GetGroups) > 0) {
        $HtmlToReturn = "";
        while ($rowGroups = mysqli_fetch_array($GetGroups)) {
            $HtmlToReturn .= "<div class='PodesavanjeGrupe' idgrupe='" . $rowGroups['id'] . "' skrnaziv='" . $rowGroups['skrNaziv'] . "' prioritet='" . $rowGroups['prioritet'] . "' prikaznaekran='" . $rowGroups['prikazNaEkran'] . "' prikazordermaster='" . $rowGroups['prikazOrderMaster'] . "'>" . $rowGroups['naziv'] . "</div>";
        }
        echo json_encode(array('Status' => 'success', 'Message' => "", "HtmlToInsert" => $HtmlToReturn));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => "U sistemu nema podešenih grupa!"));
    }
    die();
}
if (isset($_POST['CreateGroupId'])) {
    $GroupId = mysqli_real_escape_string($link, $_POST['CreateGroupId']);
    $GroupName = mysqli_real_escape_string($link, $_POST['CreateGroupName']);
    $GroupShortName = mysqli_real_escape_string($link, $_POST['CreateGroupShortName']);
    $GroupPriority = mysqli_real_escape_string($link, $_POST['CreateGroupPriority']);
    $GroupShowScreen = mysqli_real_escape_string($link, $_POST['CreateGroupShowScreen']);
    $GroupShowOrder = mysqli_real_escape_string($link, $_POST['CreateGroupShowOrder']);
    if ($GroupShowOrder == '') {
        $GroupShowOrder = 0;
    }
    if ($GroupShowScreen == '') {
        $GroupShowScreen = 0;
    }
    $IsExist = mysqli_query($link, "SELECT * FROM grupaartikala WHERE id!='$GroupId' AND (naziv='$GroupName' OR skrNaziv='$GroupShortName')");
    if (mysqli_num_rows($IsExist) == 0) {
        if ($GroupId == 0) {
            mysqli_query($link, "INSERT INTO grupaartikala (naziv, skrNaziv, prikazNaEkran, prikazOrderMaster, prioritet) 
                VALUES ('$GroupName', '$GroupShortName', $GroupShowScreen, $GroupShowOrder, '$GroupPriority')") or die(mysqli_error($link));
            echo json_encode(array('Status' => 'success', 'Message' => "Grupa je uspešno kreirana!"));
        } else {
            mysqli_query($link, "UPDATE grupaartikala SET naziv='$GroupName', skrNaziv='$GroupShortName', prikazNaEkran=$GroupShowScreen, prikazOrderMaster=$GroupShowOrder, prioritet='$GroupPriority' WHERE id='$GroupId'") or die(mysqli_error($link));
            echo json_encode(array('Status' => 'success', 'Message' => "Grupa je uspešno izmenjena!"));
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => "Grupa sa istim nazivom već postoji u sistemu!"));
    }
    die();
}
if (isset($_POST['DeleteProductGroup'])) {
    $GroupId = mysqli_real_escape_string($link, $_POST['DeleteProductGroup']);
    $GetSubGroup = mysqli_query($link, "SELECT * FROM podgrupaartikala WHERE GRUPA_ID='$GroupId'");
    if (mysqli_num_rows($GetSubGroup) > 0) {
        echo json_encode(array('Status' => 'error', 'Message' => "Postoje podgrupe koje pripadaju ovoj grupi! Brisanje nije moguće!"));
        die();
    }
    mysqli_query($link, "DELETE FROM grupaartikala WHERE id='$GroupId'");
    echo json_encode(array('Status' => 'success', 'Message' => "Grupa je obrisana!"));
    die();
}
if (isset($_POST['GetAllSubGroupsChange'])) {
    $GetGroups = mysqli_query($link, "SELECT * FROM podgrupaartikala WHERE 1 ORDER BY prioritet ASC");
    if (mysqli_num_rows($GetGroups) > 0) {
        $HtmlToReturn = "";
        while ($rowGroups = mysqli_fetch_array($GetGroups)) {
            $HtmlToReturn .= "<div class='PodesavanjePodGrupe' idpodgrupe='" . $rowGroups['id'] . "' skrnaziv='" . $rowGroups['skrNaziv'] . "' prioritet='" . $rowGroups['prioritet'] . "' idgrupe='" . $rowGroups['GRUPA_ID'] . "'>" . $rowGroups['naziv'] . "</div>";
        }
        echo json_encode(array('Status' => 'success', 'Message' => "", "HtmlToInsert" => $HtmlToReturn));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => "U sistemu nema podešenih podgrupa!"));
    }
    die();
}
if (isset($_POST['CreateSubGroupId'])) {
    $GroupId = mysqli_real_escape_string($link, $_POST['CreateSubGroupId']);
    $GroupName = mysqli_real_escape_string($link, $_POST['CreateSubGroupName']);
    $GroupShortName = mysqli_real_escape_string($link, $_POST['CreateSubGroupShortName']);
    $GroupPriority = mysqli_real_escape_string($link, $_POST['CreateSubGroupPriority']);
    $CreateSubGroupGroup = mysqli_real_escape_string($link, $_POST['CreateSubGroupGroup']);

    $IsExist = mysqli_query($link, "SELECT * FROM podgrupaartikala WHERE id!='$GroupId' AND (naziv='$GroupName' OR skrNaziv='$GroupShortName')");
    if (mysqli_num_rows($IsExist) == 0) {
        if ($GroupId == 0) {
            mysqli_query($link, "INSERT INTO podgrupaartikala (naziv, skrNaziv, GRUPA_ID, prioritet) 
                VALUES ('$GroupName', '$GroupShortName', $CreateSubGroupGroup, '$GroupPriority')") or die(mysqli_error($link));
            echo json_encode(array('Status' => 'success', 'Message' => "Podgrupa je uspešno kreirana!"));
        } else {
            mysqli_query($link, "UPDATE podgrupaartikala SET naziv='$GroupName', skrNaziv='$GroupShortName', GRUPA_ID='$CreateSubGroupGroup', prioritet='$GroupPriority' WHERE id='$GroupId'") or die(mysqli_error($link));
            echo json_encode(array('Status' => 'success', 'Message' => "Podgrupa je uspešno izmenjena!"));
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => "Podgrupa sa istim nazivom već postoji u sistemu!"));
    }
    die();
}
if (isset($_POST['DeleteProductSubGroup'])) {
    $GroupId = mysqli_real_escape_string($link, $_POST['DeleteProductSubGroup']);
    $GetArticles = mysqli_query($link, "SELECT * FROM artikal WHERE PODGRUPA_ID='$GroupId'");
    if (mysqli_num_rows($GetArticles) > 0) {
        echo json_encode(array('Status' => 'error', 'Message' => "Postoje artikli koji pripadaju ovoj podgrupi! Brisanje nije moguće!"));
        die();
    }
    mysqli_query($link, "DELETE FROM podgrupaartikala WHERE id='$GroupId'");
    echo json_encode(array('Status' => 'success', 'Message' => "Podrupa je obrisana!"));
    die();
}
if (isset($_POST['GetAllPrintersChange'])) {
    $GetGroups = mysqli_query($link, "SELECT * FROM stampac WHERE 1");
    if (mysqli_num_rows($GetGroups) > 0) {
        $HtmlToReturn = "";
        while ($rowGroups = mysqli_fetch_array($GetGroups)) {
            $HtmlToReturn .= "<div class='PodesavanjeStampac' idstampaca='" . $rowGroups['id'] . "' bnaziv='" . $rowGroups['bnaziv'] . "' naziv='" . $rowGroups['naziv'] . "' stampaizvestaje='" . $rowGroups['stampaIzvestaje'] . "' stampagotovinski='" . $rowGroups['stampaGotovinski'] . "' brojkopijaporudzbine='" . $rowGroups['brojKopijaPorudzbine'] . "'>" . $rowGroups['bnaziv'] . " | " . $rowGroups['naziv'] . "</div>";
        }
        echo json_encode(array('Status' => 'success', 'Message' => "", "HtmlToInsert" => $HtmlToReturn));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => "U sistemu nema podešenih štampača!"));
    }
    die();
}
if (isset($_POST['CreatePrinterId'])) {
    $CreatePrinterId = mysqli_real_escape_string($link, $_POST['CreatePrinterId']);
    $CreatePrinterName = mysqli_real_escape_string($link, $_POST['CreatePrinterName']);
    $CreatePrinterBName = mysqli_real_escape_string($link, $_POST['CreatePrinterBName']);
    $CreatePrinterWidth = mysqli_real_escape_string($link, $_POST['CreatePrinterWidth']);
    $CreatePrinterCopy = mysqli_real_escape_string($link, $_POST['CreatePrinterCopy']);
    $CreatePrinterReports = mysqli_real_escape_string($link, $_POST['CreatePrinterReports']);
    $CreatePrinterInvoice = mysqli_real_escape_string($link, $_POST['CreatePrinterInvoice']);
    if ($CreatePrinterReports == '') {
        $CreatePrinterReports = 0;
    }
    if ($CreatePrinterInvoice == '') {
        $CreatePrinterInvoice = 0;
    }
    $IsExist = mysqli_query($link, "SELECT * FROM stampac WHERE id!='$CreatePrinterId' AND (naziv='$CreatePrinterName' OR bnaziv='$CreatePrinterBName')");
    if (mysqli_num_rows($IsExist) == 0) {
        if ($CreatePrinterId == 0) {
            mysqli_query($link, "INSERT INTO stampac (naziv, bnaziv, brojKopijaPorudzbine, stampaIzvestaje, tip, stampaGotovinski) 
                VALUES ('$CreatePrinterName', '$CreatePrinterBName', '$CreatePrinterCopy', $CreatePrinterReports, '$CreatePrinterWidth', $CreatePrinterInvoice)") or die(mysqli_error($link));
            echo json_encode(array('Status' => 'success', 'Message' => "Štampač je uspešno kreiran!"));
        } else {
            mysqli_query($link, "UPDATE stampac SET naziv='$CreatePrinterName', bnaziv='$CreatePrinterBName', brojKopijaPorudzbine='$CreatePrinterCopy', stampaGotovinski=$CreatePrinterInvoice, stampaIzvestaje=$CreatePrinterReports, tip='$CreatePrinterWidth' WHERE id='$CreatePrinterId'") or die(mysqli_error($link));
            echo json_encode(array('Status' => 'success', 'Message' => "Štampač je uspešno izmenjen!"));
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => "Štampač sa istim nazivom već postoji u sistemu!"));
    }
    die();
}
if (isset($_POST['DeletePrinter'])) {
    $PrinterId = mysqli_real_escape_string($link, $_POST['DeletePrinter']);
    mysqli_query($link, "DELETE FROM stampac WHERE id='$PrinterId'");
    mysqli_query($link, "DELETE FROM artikal_stampac WHERE STAMPAC_ID='$PrinterId'");
    echo json_encode(array('Status' => 'success', 'Message' => "Štampač je obrisan!"));
    die();
}
if (isset($_POST['SearchArticlesSetup'])) {
    $Page = mysqli_real_escape_string($link, $_POST['SearchArticlesSetup']);
    $Naziv = mysqli_real_escape_string($link, $_POST['PodesavanjePretragaNaziv']);
    $PodGrupa = mysqli_real_escape_string($link, $_POST['PodesavanjePretragaPodGrupa']);
    $Filter = "";
    if ($Naziv != "") {
        $Filter = "name LIKE '%$Naziv%'";
    }
    if ($PodGrupa != "") {
        if ($Filter == "") {
            $Filter = "PODGRUPA_ID = '$PodGrupa'";
        } else {
            $Filter = " AND PODGRUPA_ID = '$PodGrupa'";
        }
    }
    if ($Filter == "") {
        $Filter = "1";
    }
    if ($Page == 0) {
        $Page = 1;
    }
    $PageLinks = [];
    $InvoiceData = [];
    $LimitTo = ($Page - 1) * 30;
    $DocumentQuery = mysqli_query($link, "SELECT * FROM artikal WHERE $Filter AND blokiran=0 ORDER BY name ASC LIMIT $LimitTo, 30") or die(mysqli_error($link));
    if (mysqli_num_rows($DocumentQuery) > 0) {
        $CountQuery = mysqli_query($link, "SELECT COUNT(id) as TotalItems FROM artikal WHERE $Filter AND blokiran=0") or die(mysqli_error($link));
        $TotalItems = mysqli_fetch_array($CountQuery)['TotalItems'];
        $TotalPages = ceil($TotalItems / 30);
        $NextPage = $Page + 1;
        $PrevPage = $Page - 1;
        $BellowShow = $Page - 3;
        $AboveShow = $Page + 3;
        $TotalPageShow = 7;
        if ($AboveShow < $TotalPageShow) {
            $AboveShow = $TotalPageShow;
        }
        $CountLink = 0;
        if ($TotalPages > 1) {
            if ($Page != 1) {
                $PageLinks[$CountLink] = ['Number' => $PrevPage, 'Content' => '<i class="fa fa-chevron-left"></i>', 'Class' => ''];
                $CountLink++;
            }
            for ($i = 1; $i <= $TotalPages; $i++) {
                if ($i == $Page) {
                    $ActivePage = 'OFPageIsActive';
                } else {
                    $ActivePage = '';
                }
                if ($i >= $BellowShow && $i <= $AboveShow) {
                    $PageLinks[$CountLink] = ['Number' => $i, 'Content' => $i, 'Class' => $ActivePage];
                    $CountLink++;
                }
            }
            if ($Page != $TotalPages) {
                $PageLinks[$CountLink] = ['Number' => $NextPage, 'Content' => '<i class="fa fa-chevron-right"></i>', 'Class' => ''];
                $CountLink++;
            }
        }
        $IncDocument = 0;
        while ($resDocument = mysqli_fetch_array($DocumentQuery)) {
            $ArtikalId = $resDocument['id'];
            $Stampaci = "";
            $GetPrinters = mysqli_query($link, "SELECT * FROM artikal_stampac WHERE ARTIKLI_ID='$ArtikalId'");
            if (mysqli_num_rows($GetPrinters) > 0) {
                while ($rowPrinters = mysqli_fetch_array($GetPrinters)) {
                    if ($Stampaci == "") {
                        $Stampaci = $rowPrinters['STAMPAC_ID'];
                    } else {
                        $Stampaci .= "," . $rowPrinters['STAMPAC_ID'];
                    }
                }
            }
            $InvoiceData[$IncDocument] = [
                "id" => $resDocument['id'],
                "name" => $resDocument['name'],
                "sifra" => $resDocument['barCode'],
                "jedinicaMere" => $resDocument['jedinicaMere'],
                "cena" => $resDocument['cena'],
                "poreskaGrupa" => $resDocument['poreskaGrupa'],
                "PODGRUPA_ID" => $resDocument['PODGRUPA_ID'],
                'stampaci' => $Stampaci,
                'dozvoljenPopust' => $resDocument['dozvoljenPopust']
            ];
            $IncDocument++;
        }
    }
    if (count($PageLinks) <= 0) {
        $PageLinks = "";
    }
    if (count($InvoiceData) <= 0) {
        $InvoiceData = "";
    }
    echo json_encode(array('Status' => 'success', 'Message' => '', 'PageLinks' => $PageLinks, 'InvoiceData' => $InvoiceData));
    die();
}
if (isset($_POST['DeleteProduct'])) {
    $ProductId = mysqli_real_escape_string($link, $_POST['DeleteProduct']);
    mysqli_query($link, "UPDATE artikal SET blokiran=1 WHERE id='$ProductId'");
    echo json_encode(array('Status' => 'success', 'Message' => "Artikal je obrisan!"));
    die();
}
if (isset($_POST['CreateProductId'])) {
    $CreateProductId = mysqli_real_escape_string($link, $_POST['CreateProductId']);
    $CreateProductName = mysqli_real_escape_string($link, $_POST['CreateProductName']);
    $CreateProductCode = mysqli_real_escape_string($link, $_POST['CreateProductCode']);
    $CreateProductPrice = mysqli_real_escape_string($link, $_POST['CreateProductPrice']);
    $CreateProductSubGroup = mysqli_real_escape_string($link, $_POST['CreateProductSubGroup']);
    $CreateProductUnit = mysqli_real_escape_string($link, $_POST['CreateProductUnit']);
    $CreateProductVat = mysqli_real_escape_string($link, $_POST['CreateProductVat']);
    $CreateProductDiscount = mysqli_real_escape_string($link, $_POST['CreateProductDiscount']);

    $IsExist = mysqli_query($link, "SELECT * FROM artikal WHERE id!='$CreateProductId' AND (skrNaziv='$CreateProductName' OR name='$CreateProductName')");
    if (mysqli_num_rows($IsExist) == 0) {
        if ($CreateProductId == 0) {
            mysqli_query($link, "INSERT INTO artikal (name, skrNaziv, barCode, jedinicaMere, cena, poreskaGrupa, PODGRUPA_ID, dozvoljenPopust, mera, tip, blokiran) 
                VALUES ('$CreateProductName', '$CreateProductName', '$CreateProductCode', '$CreateProductUnit', '$CreateProductPrice', '$CreateProductVat', '$CreateProductSubGroup', $CreateProductDiscount, '1', 'SLOZ', 0)") or die(mysqli_error($link));
            $CreateProductId = mysqli_insert_id($link);
            $GetSvaOdeljenja = mysqli_query($link, "SELECT * FROM odeljenje WHERE magacin=0");
            if (mysqli_num_rows($GetSvaOdeljenja) > 0) {
                while ($rowOdeljenja = mysqli_fetch_array($GetSvaOdeljenja)) {
                    $OdeljenjeId = $rowOdeljenja['id'];
                    mysqli_query($link, "INSERT INTO artikal_odeljenje (ARTIKLI_ID, ODELJENJA_ID) VALUES ('$CreateProductId', '$OdeljenjeId')");
                }
            }
            echo json_encode(array('Status' => 'success', 'Message' => "Artikal je uspešno kreiran!"));
        } else {
            mysqli_query($link, "UPDATE artikal SET name='$CreateProductName', skrNaziv='$CreateProductName', barCode='$CreateProductCode', 
                jedinicaMere='$CreateProductUnit', cena='$CreateProductPrice', poreskaGrupa='$CreateProductVat', 
                PODGRUPA_ID='$CreateProductSubGroup', dozvoljenPopust=$CreateProductDiscount  WHERE id='$CreateProductId'") or die(mysqli_error($link));
            echo json_encode(array('Status' => 'success', 'Message' => "Artikal je uspešno izmenjen!"));
        }
        mysqli_query($link, "DELETE FROM artikal_stampac WHERE ARTIKLI_ID='$CreateProductId'");
        if (isset($_POST['CreateProductPrinter'])) {
            foreach ($_POST['CreateProductPrinter'] as $PrinterId) {
                $PrinterId = mysqli_real_escape_string($link, $PrinterId);
                mysqli_query($link, "INSERT INTO artikal_stampac (ARTIKLI_ID, STAMPAC_ID) VALUES ('$CreateProductId', '$PrinterId')");
            }
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => "Artikal sa istim nazivom već postoji u sistemu!"));
    }
    die();
}
if (isset($_POST['GetAllOperatorsChange'])) {
    $GetOperators = mysqli_query($link, "SELECT * FROM konobar WHERE blokiranje=0");
    if (mysqli_num_rows($GetOperators) > 0) {
        $HtmlToReturn = "";
        while ($rowOperators = mysqli_fetch_array($GetOperators)) {
            $ThisOperatorId = $rowOperators['id'];
            $Grafici = "";
            $GetGrafici = mysqli_query($link, "SELECT * FROM grafik_konobar WHERE konobar_id='$ThisOperatorId'");
            if (mysqli_num_rows($GetGrafici) > 0) {
                while ($rowGrafici = mysqli_fetch_array($GetGrafici)) {
                    if ($Grafici == "") {
                        $Grafici = $rowGrafici['grafik_id'];
                    } else {
                        $Grafici .= "," . $rowGrafici['grafik_id'];
                    }
                }
            }
            $Kase = "";
            $GetKase = mysqli_query($link, "SELECT * FROM konobar_kasa WHERE KONOBARI_ID='$ThisOperatorId'");
            if (mysqli_num_rows($GetKase) > 0) {
                while ($rowKase = mysqli_fetch_array($GetKase)) {
                    if ($Kase == "") {
                        $Kase = $rowKase['KASE_ID'];
                    } else {
                        $Kase .= "," . $rowKase['KASE_ID'];
                    }
                }
            }
            $Admin = "";
            $GetAdmin = mysqli_query($link, "SELECT * FROM konobar_admin WHERE KONOBAR_ID='$ThisOperatorId'");
            if (mysqli_num_rows($GetAdmin) > 0) {
                while ($rowAdmin = mysqli_fetch_array($GetAdmin)) {
                    if ($Admin == "") {
                        $Admin = $rowAdmin['MENI_TIP'];
                    } else {
                        $Admin .= "," . $rowAdmin['MENI_TIP'];
                    }
                }
            }
            $HtmlToReturn .= "<div class='PodesavanjeKonobar' 
                idkonobara='" . $rowOperators['id'] . "' 
                punoime='" . $rowOperators['punoIme'] . "' 
                sifra='" . $rowOperators['sifra'] . "' 
                nivo='" . $rowOperators['nivo'] . "'
                medjuzirBezSifre='" . $rowOperators['medjuzirBezSifre'] . "'
                mozeStorno='" . $rowOperators['mozeStorno'] . "'
                naplata='" . $rowOperators['naplata'] . "'
                oduzmi_ponisti='" . $rowOperators['oduzmi_ponisti'] . "'
                otvaraKomitenta='" . $rowOperators['otvaraKomitenta'] . "'
                otvaraMeni='" . $rowOperators['otvaraMeni'] . "'
                otvaraPreduzece='" . $rowOperators['otvaraPreduzece'] . "'
                prometNaMeniPromet='" . $rowOperators['prometNaMeniPromet'] . "'
                skrIme='" . $rowOperators['skrIme'] . "'
                ponovnaStampaRacuna='" . $rowOperators['ponovnaStampaRacuna'] . "'
                pregledProdajeSvih='" . $rowOperators['pregledProdajeSvih'] . "'
                pregledStorna='" . $rowOperators['pregledStorna'] . "'
                prijemDostave='" . $rowOperators['prijemDostave'] . "'
                administracijaPopusta='" . $rowOperators['administracijaPopusta'] . "'
                prikazani_grafici='" . $Grafici . "'
                dostupne_kase='" . $Kase . "'
                admin_meni='" . $Admin . "'>" . $rowOperators['skrIme'] . "</div>";
        }
        echo json_encode(array('Status' => 'success', 'Message' => "", "HtmlToInsert" => $HtmlToReturn));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => "U sistemu nema podešenih konobara!"));
    }
    die();
}
if (isset($_POST['CreateOperatorId'])) {
    $CreateOperatorId = mysqli_real_escape_string($link, $_POST['CreateOperatorId']);
    $CreateOperatorName = mysqli_real_escape_string($link, $_POST['CreateOperatorName']);
    $CreateOperatorShortName = mysqli_real_escape_string($link, $_POST['CreateOperatorShortName']);
    $CreateOperatorLevel = mysqli_real_escape_string($link, $_POST['CreateOperatorLevel']);
    $CreateOperatorSifra = mysqli_real_escape_string($link, $_POST['CreateOperatorSifra']);
    $CreateOperatorDiscountAdmin = mysqli_real_escape_string($link, $_POST['CreateOperatorDiscountAdmin']);
    $CreateOperatorSubTotalPass = mysqli_real_escape_string($link, $_POST['CreateOperatorSubTotalPass']);
    $CreateOperatorStornoAble = mysqli_real_escape_string($link, $_POST['CreateOperatorStornoAble']);
    $CreateOperatorPayup = mysqli_real_escape_string($link, $_POST['CreateOperatorPayup']);
    $CreateOperatorDeduct = mysqli_real_escape_string($link, $_POST['CreateOperatorDeduct']);
    $CreateOperatorOpensBuyer = mysqli_real_escape_string($link, $_POST['CreateOperatorOpensBuyer']);
    $CreateOperatorOpensMenu = mysqli_real_escape_string($link, $_POST['CreateOperatorOpensMenu']);
    $CreateOperatorOpensCompany = mysqli_real_escape_string($link, $_POST['CreateOperatorOpensCompany']);
    $CreateOperatorMenuSales = mysqli_real_escape_string($link, $_POST['CreateOperatorMenuSales']);
    $CreateOperatorRepeatPrint = mysqli_real_escape_string($link, $_POST['CreateOperatorRepeatPrint']);
    $CreateOperatorAllSales = mysqli_real_escape_string($link, $_POST['CreateOperatorAllSales']);
    $CreateOperatorViewStorno = mysqli_real_escape_string($link, $_POST['CreateOperatorViewStorno']);
    $CreateOperatorReceiveDelivery = mysqli_real_escape_string($link, $_POST['CreateOperatorReceiveDelivery']);

    if ($CreateOperatorDiscountAdmin == "") {
        $CreateOperatorDiscountAdmin = 0;
    }
    if ($CreateOperatorSubTotalPass == "") {
        $CreateOperatorSubTotalPass = 0;
    }
    if ($CreateOperatorStornoAble == "") {
        $CreateOperatorStornoAble = 0;
    }
    if ($CreateOperatorPayup == "") {
        $CreateOperatorPayup = 0;
    }
    if ($CreateOperatorDeduct == "") {
        $CreateOperatorDeduct = 0;
    }
    if ($CreateOperatorOpensBuyer == "") {
        $CreateOperatorOpensBuyer = 0;
    }
    if ($CreateOperatorOpensMenu == "") {
        $CreateOperatorOpensMenu = 0;
    }
    if ($CreateOperatorOpensCompany == "") {
        $CreateOperatorOpensCompany = 0;
    }
    if ($CreateOperatorMenuSales == "") {
        $CreateOperatorMenuSales = 0;
    }
    if ($CreateOperatorRepeatPrint == "") {
        $CreateOperatorRepeatPrint = 0;
    }
    if ($CreateOperatorAllSales == "") {
        $CreateOperatorAllSales = 0;
    }
    if ($CreateOperatorViewStorno == "") {
        $CreateOperatorViewStorno = 0;
    }
    if ($CreateOperatorReceiveDelivery == "") {
        $CreateOperatorReceiveDelivery = 0;
    }

    $IsExist = mysqli_query($link, "SELECT * FROM konobar WHERE id!='$CreateOperatorId' AND blokiranje=0 AND (skrIme='$CreateOperatorShortName' OR punoIme='$CreateOperatorName' OR sifra='$CreateOperatorSifra')");
    if (mysqli_num_rows($IsExist) == 0) {
        if ($CreateOperatorId == 0) {
            mysqli_query($link, "INSERT INTO konobar (punoime, skrIme, nivo, sifra, administracijaPopusta, medjuzirBezSifre, mozeStorno, naplata, oduzmi_ponisti, otvaraKomitenta, otvaraMeni, otvaraPreduzece, prometNaMeniPromet, ponovnaStampaRacuna, pregledProdajeSvih, pregledStorna, prijemDostave, blokiranje) 
                VALUES ('$CreateOperatorName', '$CreateOperatorShortName', '$CreateOperatorLevel', '$CreateOperatorSifra', 
                    $CreateOperatorDiscountAdmin, $CreateOperatorSubTotalPass, $CreateOperatorStornoAble, $CreateOperatorPayup, $CreateOperatorDeduct, $CreateOperatorOpensBuyer, 
                    $CreateOperatorOpensMenu, $CreateOperatorOpensCompany, $CreateOperatorMenuSales, $CreateOperatorRepeatPrint, $CreateOperatorAllSales, $CreateOperatorViewStorno, $CreateOperatorReceiveDelivery, 0)") or die(mysqli_error($link));
            $CreateOperatorId = mysqli_insert_id($link);
            echo json_encode(array('Status' => 'success', 'Message' => "Operater je uspešno kreiran!"));
        } else {
            mysqli_query($link, "UPDATE konobar SET punoime='$CreateOperatorName', skrIme='$CreateOperatorShortName', nivo='$CreateOperatorLevel',
                sifra='$CreateOperatorSifra', administracijaPopusta=$CreateOperatorDiscountAdmin, medjuzirBezSifre=$CreateOperatorSubTotalPass, 
                    mozeStorno=$CreateOperatorStornoAble, naplata=$CreateOperatorPayup, oduzmi_ponisti=$CreateOperatorDeduct, otvaraKomitenta=$CreateOperatorOpensBuyer,
                        otvaraMeni=$CreateOperatorOpensMenu, otvaraPreduzece=$CreateOperatorOpensCompany, prometNaMeniPromet=$CreateOperatorMenuSales, 
                            ponovnaStampaRacuna=$CreateOperatorRepeatPrint, pregledProdajeSvih=$CreateOperatorAllSales, pregledStorna=$CreateOperatorViewStorno, 
                                prijemDostave=$CreateOperatorReceiveDelivery WHERE id='$CreateOperatorId'") or die(mysqli_error($link));
            echo json_encode(array('Status' => 'success', 'Message' => "Operater je uspešno izmenjen!"));
        }
        mysqli_query($link, "DELETE FROM konobar_kasa WHERE KONOBARI_ID='$CreateOperatorId'");
        if (isset($_POST['CreateOperatorKasa'])) {
            foreach ($_POST['CreateOperatorKasa'] as $KasaId) {
                $KasaId = mysqli_real_escape_string($link, $KasaId);
                mysqli_query($link, "INSERT INTO konobar_kasa (KASE_ID, KONOBARI_ID) VALUES ('$KasaId', '$CreateOperatorId')");
            }
        }
        mysqli_query($link, "DELETE FROM grafik_konobar WHERE konobar_id='$CreateOperatorId'");
        if (isset($_POST['CreateOperatorGrafik'])) {
            foreach ($_POST['CreateOperatorGrafik'] as $GrafikId) {
                $GrafikId = mysqli_real_escape_string($link, $GrafikId);
                mysqli_query($link, "INSERT INTO grafik_konobar (grafik_id, konobar_id) VALUES ('$GrafikId', '$CreateOperatorId')");
            }
        }
        mysqli_query($link, "DELETE FROM konobar_admin WHERE KONOBAR_ID='$CreateOperatorId'");
        if (isset($_POST['CreateOperatorAdmin'])) {
            foreach ($_POST['CreateOperatorAdmin'] as $AdminId) {
                $AdminId = mysqli_real_escape_string($link, $AdminId);
                mysqli_query($link, "INSERT INTO konobar_admin (MENI_TIP, KONOBAR_ID) VALUES ('$AdminId', '$CreateOperatorId')");
            }
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => "Operater sa istim imenom i/ili šifrom već postoji u sistemu!"));
    }
    die();
}
if (isset($_POST['DeleteOperator'])) {
    $OperatorId = mysqli_real_escape_string($link, $_POST['DeleteOperator']);
    mysqli_query($link, "UPDATE konobar SET blokiranje=1, sifra='BLOKIRAN' WHERE id='$OperatorId'");
    echo json_encode(array('Status' => 'success', 'Message' => "Operater je obrisan!"));
    die();
}
if (isset($_POST['GetAllVats'])) {
    $GetGroups = mysqli_query($link, "SELECT * FROM poreske_stope WHERE 1");
    if (mysqli_num_rows($GetGroups) > 0) {
        $HtmlToReturn = "";
        while ($rowGroups = mysqli_fetch_array($GetGroups)) {
            if ($rowGroups['aktivna'] == 1) {
                $Aktivna = "Aktivna";
            } else {
                $Aktivna = "Neaktivna";
            }
            $HtmlToReturn .= "<div class='PodesavanjeStope'>" . $rowGroups['oznaka'] . " - " . $rowGroups['vrednost'] . "% | " . $Aktivna . "</div>";
        }
        echo json_encode(array('Status' => 'success', 'Message' => "", "HtmlToInsert" => $HtmlToReturn));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => "U sistemu nema podešenih stopa!"));
    }
    die();
}
if (isset($_POST['SyncVat'])) {
    $LPFRUrl = $KasaData['lpfr_adresa'];
    $UrlStatus = $LPFRUrl . "/api/v3/status";
    $cu = curl_init();
    $apiHeader[] = 'Accept: application/json';
    $apiHeader[] = 'Content-Type: application/json';
    $options = array(
        CURLOPT_URL => $UrlStatus,
        CURLOPT_HTTPHEADER => $apiHeader,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET'
    );
    curl_setopt_array($cu, $options);
    $outputcu = curl_exec($cu);
    if (curl_errno($cu) > 0) {
        echo json_encode(array('Status' => 'error', 'Message' => 'Greška pri sinhronizaciji sa LPFR! ' . curl_error($cu)));
    } else {
        $json = json_decode($outputcu);
        mysqli_query($link, "TRUNCATE table poreske_stope");
        foreach ($json->currentTaxRates->taxCategories as $tax) {
            $TaxRate = $tax->taxRates;
            foreach ($TaxRate as $TaxInsert) {
                $ProductVatName = mysqli_real_escape_string($link, $TaxInsert->label);
                $ProductVatActive = 1;
                $ProductVatValue = mysqli_real_escape_string($link, $TaxInsert->rate);
                $IsExist = mysqli_query($link, "SELECT oznaka FROM poreske_stope WHERE oznaka='$ProductVatName' AND vrednost='$ProductVatValue'") or die(mysqli_error($link));
                if (mysqli_num_rows($IsExist) == 0) {
                    mysqli_query($link, "INSERT INTO poreske_stope (oznaka, vrednost, aktivna) VALUES ('$ProductVatName', '$ProductVatValue', '$ProductVatActive')") or die(mysqli_error($link));
                    $NewCurrent = mysqli_insert_id($link2);
                } else {
                    mysqli_query($link, "UPDATE poreske_stope SET aktivna=1 WHERE oznaka='$ProductVatName' AND vrednost='$ProductVatValue'");
                }
            }
        }
        echo json_encode(array('Status' => 'success', 'Message' => 'Stope su preuzete!', "Stope" => json_decode($outputcu)));
    }
    curl_close($cu);
    die();
}
if (isset($_POST['CreateInvoiceCopy'])) {
    $InvoiceId = mysqli_real_escape_string($link, $_POST['CreateInvoiceCopy']);
    $GetInvoiceData = mysqli_query($link, "SELECT * FROM racun_fiskal WHERE id='$InvoiceId'");
    if (mysqli_num_rows($GetInvoiceData) == 1) {
        $InvoiceData = mysqli_fetch_array($GetInvoiceData);
        $OldJournalData = unserialize($InvoiceData['podaciRacuna']);
        $OldJournalData = json_decode(json_encode($OldJournalData), true);
        $LPFRUrl = $KasaData['lpfr_adresa'];
        $Pin = $KasaData['lpfr_pin'];
        $UrlStatus = $LPFRUrl . "/api/v3/status";
        $DoRequest = 1;
        $cu = curl_init();
        $apiHeader[] = 'Accept: application/json';
        $apiHeader[] = 'Content-Type: application/json';
        $options = array(
            CURLOPT_URL => $UrlStatus,
            CURLOPT_HTTPHEADER => $apiHeader,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET'
        );
        curl_setopt_array($cu, $options);
        $outputcu = curl_exec($cu);
        if (curl_errno($cu) > 0) {
            $DoRequest = 0;
        }
        curl_close($cu);
        $StatusResults = json_decode($outputcu);
        if ($StatusResults->isPinRequired != '') {
            if ($Pin != '') {
                $UrlPIN = $LPFRUrl . "/api/v3/pin";
                $cu = curl_init();
                $options = array(
                    CURLOPT_URL => $UrlPIN,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_HEADER => false, // true to show header information
                    CURLINFO_HEADER_OUT => true,
                    CURLOPT_HTTPGET => false,
                    CURLOPT_POST => true,
                    CURLOPT_FOLLOWLOCATION => false,
                    CURLOPT_VERBOSE => true,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_SSL_VERIFYHOST => false, // true in production
                    CURLOPT_SSL_VERIFYPEER => false, // true in production
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_HTTPHEADER => $apiHeader,
                    CURLOPT_USERAGENT => 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)',
                    CURLOPT_HTTPAUTH => CURLAUTH_ANYSAFE, // CURLAUTH_BASIC
                    CURLOPT_POSTFIELDS => $Pin,
                );
                curl_setopt_array($cu, $options);
                $outputcu = curl_exec($cu);
                if (curl_errno($cu) > 0) {
                    $DoRequest = 0;
                    echo json_encode(array('Status' => 'error', 'Message' => 'Greška pri komunikaciji sa LPFR!' . curl_error($cu)));
                }
                curl_close($cu);
                $Result = json_decode($outputcu);
                if ($Result != "0100") {
                    if ($Result == "2100") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'PIN koji ste uneli nije ispravan!'));
                    } elseif ($Result == "2110") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Kartica je zaključana!'));
                    } elseif ($Result == "2210") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Sigurnosni element je zaključan! Nije moguća fiskalizacija računa!'));
                    } elseif ($Result == "2220") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća komunikacija sa sigurnosnim elementom!'));
                    } elseif ($Result == "1300") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Kartica nije umetnuta!'));
                    } elseif ($Result->status == "400") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'LPFR nije dostupan!'));
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nepoznata greska! Kod:' . $outputcu));
                    }
                    $DoRequest = 0;
                }
            } else {
                echo json_encode(array('Status' => 'pinrequired', 'Message' => 'Neophodno je da unesete PIN!'));
                $DoRequest = 0;
            }
        }
        if ($DoRequest == 1) {
            if ($KasaData['lpfr_adresa'] != '') {
                $Date = date('Y-m-d');
                $DateOfIssue = $Date . " " . date('H:i:s');
                $FiscalRequest = [];
                $EntityVAT = "";
                $EntityVATType = "";
                $EntityField = "";
                $EntityFieldType = "";
                if ($OldJournalData['EsirKupacPIBTip']) {
                    $EntityVATType = $OldJournalData['EsirKupacPIBTip'];
                }
                if ($OldJournalData['EsirKupacPIB']) {
                    $EntityVAT = $OldJournalData['EsirKupacPIB'];
                }
                if ($OldJournalData['EsirKupacOP']) {
                    $EntityField = $OldJournalData['EsirKupacOP'];
                }
                if ($OldJournalData['EsirKupacOPTip']) {
                    $EntityFieldType = $OldJournalData['EsirKupacOPTip'];
                }
                $ReferentNumber = $InvoiceData['brojRacuna'];
                $ReferentTime = $InvoiceData['vremeRacuna'];
                $FiscalRequest['invoiceType'] = "Copy";
                $FiscalRequest['transactionType'] = $InvoiceData['tipTransakcije'];
                $FiscalRequest['cashier'] = $OldJournalData['EsirKorisnik'];
                if ($EntityVAT != '') {
                    if ($EntityVATType != '') {
                        $FiscalRequest['buyerId'] = $EntityVATType . ":" . $EntityVAT;
                    }
                }
                if ($EntityField != '') {
                    if ($EntityFieldType != '' && $EntityVAT != '') {
                        $FiscalRequest['buyerCostCenterId'] = $EntityFieldType . ":" . $EntityField;
                    } elseif ($EntityVAT == '') {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Unesite oznaku kupca'));
                        die();
                    }
                }
                if ($ReferentNumber != '') {
                    //ovde naci referentno vreme
                    $FiscalRequest['referentDocumentDT'] = $ReferentTime;
                    $FiscalRequest['referentDocumentNumber'] = $ReferentNumber;
                }
                $FiscalRequest['options']['OmitTextualRepresentation'] = 0;
                $FiscalRequest['options']['OmitQRCodeGen'] = 0;
                $FiscalRequest['invoiceNumber'] = '230/' . $ThisSoftwareVersion;
                $IncProduct = 0;

                $SaveProducts = [];
                $UbaceniArtikli = $OldJournalData['StavkeProizvoda'];
                foreach ($UbaceniArtikli as $UbaceniArtikal) {
                    $FiscalRequest['items'][$IncProduct] = [
                        "gtin" => $UbaceniArtikal['gtin'], "name" => $UbaceniArtikal['name'],
                        "quantity" => $UbaceniArtikal['quantity'],
                        "unitPrice" => $UbaceniArtikal['unitPrice'],
                        "labels" => [$UbaceniArtikal['labels'][0]],
                        "totalAmount" => $UbaceniArtikal['totalAmount']
                    ];
                    $SaveProducts[$IncProduct] = [
                        "gtin" => $UbaceniArtikal['gtin'], "name" => $UbaceniArtikal['name'],
                        "quantity" => $UbaceniArtikal['quantity'],
                        "unitPrice" => $UbaceniArtikal['unitPrice'],
                        "labels" => [$UbaceniArtikal['labels'][0]],
                        "totalAmount" => $UbaceniArtikal['totalAmount'],
                        "unitName" => $UbaceniArtikal['unitName']
                    ];
                    $IncProduct++;
                }
                if (count($SaveProducts) > 0) {
                    $SavePayments = [];
                    $IncPayment = 0;
                    $UbaciPlacanja = $OldJournalData['StavkePlacanja'];
                    foreach ($UbaciPlacanja as $UbaciPlacanje) {
                        $FiscalRequest['payment'][$IncPayment] = ["amount" => $UbaciPlacanje['amount'], "paymentType" => $UbaciPlacanje['paymentType']];
                        $SavePayments[$IncPayment] = ["amount" => $UbaciPlacanje['amount'], "paymentType" => $UbaciPlacanje['paymentType']];
                        $IncPayment++;
                    }
                    if (count($SavePayments) > 0) {
                        //error_log(json_encode($FiscalRequest));
                        $UrlService = $LPFRUrl . "/api/v3/invoices";
                        $curl = curl_init();
                        $options = array(
                            CURLOPT_URL => $UrlService,
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_HEADER => false, // true to show header information
                            CURLINFO_HEADER_OUT => true,
                            CURLOPT_HTTPGET => false,
                            CURLOPT_POST => true,
                            CURLOPT_FOLLOWLOCATION => false,
                            CURLOPT_VERBOSE => true,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_SSL_VERIFYHOST => false, // true in production
                            CURLOPT_SSL_VERIFYPEER => false, // true in production
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_HTTPHEADER => $apiHeader,
                            CURLOPT_USERAGENT => 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)',
                            CURLOPT_HTTPAUTH => CURLAUTH_ANYSAFE, // CURLAUTH_BASIC
                            CURLOPT_POSTFIELDS => json_encode($FiscalRequest)
                        );
                        curl_setopt_array($curl, $options);
                        $output = curl_exec($curl);
                        if (curl_errno($curl) > 0) {
                            echo json_encode(array('Status' => 'error', 'Message' => 'Greška pri kontaktiranju LPFR!' . curl_error($curl)));
                            die();
                        } else {
                            //error_log($output);
                            $json = json_decode($output);
                            if (strtoupper($json->messages) != 'SUCCESS') {
                                $ModelError = $json->modelState;
                                $GreskeKojeSuUocene = "";
                                foreach ($ModelError as $ErrorData) {
                                    $StaJeLose = $ErrorData->property;
                                    $KojeSuGreske = $ErrorData->errors;
                                    $GreskeKojeSuUocene .= "Polje:" . $StaJeLose;
                                    foreach ($KojeSuGreske as $KodGreske) {
                                        if ($KodGreske == '2310') {
                                            $GreskeKojeSuUocene .= " poreska stopa nije ispravna. ";
                                        } elseif ($KodGreske == '2800') {
                                            $GreskeKojeSuUocene .= " je obavezno. ";
                                        } elseif ($KodGreske == '2801') {
                                            $GreskeKojeSuUocene .= " je predugo. ";
                                        } elseif ($KodGreske == '2802') {
                                            $GreskeKojeSuUocene .= " je prekratko. ";
                                        } elseif ($KodGreske == '2803') {
                                            $GreskeKojeSuUocene .= " je neispravne dužine. ";
                                        } elseif ($KodGreske == '2804') {
                                            $GreskeKojeSuUocene .= " je izvan očekivane vrednosti. ";
                                        } elseif ($KodGreske == '2805') {
                                            $GreskeKojeSuUocene .= " je neispravne vrednosti. ";
                                        } elseif ($KodGreske == '2806') {
                                            $GreskeKojeSuUocene .= " je neispravnog formata. ";
                                        } elseif ($KodGreske == '2807') {
                                            $GreskeKojeSuUocene .= " ne sadrži makar jedan element. ";
                                        } elseif ($KodGreske == '2808') {
                                            $GreskeKojeSuUocene .= " sadrži više od dozvoljenog broja elemenata. ";
                                        }
                                    }
                                }
                                echo json_encode(array('Status' => 'error', 'Message' => 'Neuspešna fiskalizacija! ' . $GreskeKojeSuUocene));
                                die();
                            } else {
                                $text = $json->journal;
                                $qrCode = $json->verificationQRCode;
                                $qrurl = $json->verificationUrl;
                                $LPFRNumber = $json->invoiceNumber;
                                $JournalData = [];
                                foreach ($json as $JsonName => $JsonValue) {
                                    if ($JsonName != 'verificationQRCode' && $JsonName != 'encryptedInternalData' && $JsonName != 'signature' && $JsonName != 'journal') {
                                        $JournalData[$JsonName] = $JsonValue;
                                    }
                                }
                                $JournalData['StavkeProizvoda'] = $SaveProducts;
                                $JournalData['StavkePlacanja'] = $SavePayments;
                                $JournalData['EsirKorisnik'] = $OldJournalData['EsirKorisnik'];
                                if ($EntityVAT > 0) {
                                    $JournalData['EsirKupacPIB'] = $EntityVAT;
                                    $JournalData['EsirKupacPIBTip'] = $EntityVATType;
                                }
                                if ($EntityField != '') {
                                    $JournalData['EsirKupacOP'] = $EntityField;
                                    $JournalData['EsirKupacOPTip'] = $EntityFieldType;
                                }
                                if ($ReferentNumber != '') {
                                    $JournalData['EsirReferentnoVremeDokumenta'] = $ReferentTime;
                                }
                                $TransactionType = $InvoiceData['tipTransakcije'];
                                $InvoiceType = "Copy";
                                $JournalData['InvoiceType'] = "Copy";
                                $JournalData['TransactionType'] = $InvoiceData['tipTransakcije'];
                                $brojRacuna = $LPFRNumber;
                                $tipRacuna = mysqli_real_escape_string($link, "Copy");
                                $tipTransakcije = mysqli_real_escape_string($link, $InvoiceData['tipTransakcije']);
                                $KONOBAR_ID = mysqli_real_escape_string($link, $UserId);
                                $vremeRacuna = date('Y-m-d H:i:s', strtotime($JournalData['sdcDateTime']));
                                $vremeRacuna = mysqli_real_escape_string($link, $vremeRacuna);
                                $brojRacuna = mysqli_real_escape_string($link, $LPFRNumber);
                                $podaciRacuna = serialize($JournalData);
                                $podaciRacuna = mysqli_real_escape_string($link, $podaciRacuna);
                                mysqli_query($link, "INSERT INTO racun_fiskal (RACUN_ID, brojRacuna, tipRacuna, tipTransakcije, KONOBAR_ID, vremeRacuna, podaciRacuna) 
                                    VALUES (0, '$brojRacuna', '$tipRacuna', '$tipTransakcije', '$KONOBAR_ID', '$vremeRacuna', '$podaciRacuna')") or die(mysqli_error($link));
                                $GetStampac = mysqli_query($link, "SELECT * FROM stampac WHERE stampaGotovinski=1 ORDER BY id ASC LIMIT 1");
                                if (mysqli_num_rows($GetStampac) == 1) {
                                    $StampacData = mysqli_fetch_array($GetStampac);
                                    $NazivStampaca = $StampacData['naziv'];
                                    $PrinterSize = 57;
                                    if ($StampacData['tip'] == 'POSBANK80MM') {
                                        $PrinterSize = 80;
                                    }
                                    if ($tipRacuna == 'Normal') {
                                        $PrintNameStart = " ФИСКАЛНИ РАЧУН ";
                                        $PrintNameEnd = " КРАЈ ФИСКАЛНОГ РАЧУНА ";
                                    } else {
                                        $PrintNameStart = " ОВО НИЈЕ ФИСКАЛНИ РАЧУН ";
                                        $PrintNameEnd = " ОВО НИЈЕ ФИСКАЛНИ РАЧУН ";
                                    }
                                    $TipRacunaStampa = "";
                                    $VrstaRacunaStampa = "";
                                    $PorezUkupno = 0;

                                    if ($tipRacuna == 'Normal') {
                                        $PrintNameStart = " FISKALNI RAČUN ";
                                        $PrintNameEnd = " KRAJ FISKALNOG RAČUNA ";
                                    } else {
                                        $PrintNameStart = " OVO NIJE FISKALNI RAČUN ";
                                        $PrintNameEnd = " OVO NIJE FISKALNI RAČUN ";
                                    }
                                    $TipRacunaStampa = "";
                                    $VrstaRacunaStampa = "";
                                    $PorezUkupno = 0;

                                    if ($tipTransakcije == 'Sale') {
                                        $TipRacunaStampa = "PRODAJA";
                                    } else {
                                        $TipRacunaStampa = "REFUNDACIJA";
                                    }
                                    if ($tipRacuna == 'Normal') {
                                        $VrstaRacunaStampa = "PROMET";
                                    } else if ($tipRacuna == 'Training') {
                                        $VrstaRacunaStampa = "OBUKA";
                                    } else if ($tipRacuna == 'Copy') {
                                        $VrstaRacunaStampa = "KOPIJA";
                                    } else if ($tipRacuna == 'Proforma') {
                                        $VrstaRacunaStampa = "PREDRAČUN";
                                    } else if ($tipRacuna == 'Advance') {
                                        $VrstaRacunaStampa = "AVANS";
                                    }
                                    if ($PrinterSize == 80) {
                                        $width1 = 480;
                                        $fontsize = 15;
                                        $linesize = 23;
                                        $barcodeSize = 420;
                                        $TotalCharacters = 40;
                                    } else {
                                        $width1 = 375;
                                        $fontsize = 14;
                                        $linesize = 18;
                                        $barcodeSize = 365;
                                        $TotalCharacters = 34;
                                    }
                                    try {
                                        // Enter the share name for your USB printer here
                                        if (strpos($NazivStampaca, "/")) {
                                            $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                                        } else {
                                            $connector = new WindowsPrintConnector($NazivStampaca);
                                        }
                                        $printer = new Printer($connector);
                                        $printer->pulse(1, 300, 300);
                                        $printer->setPrintLeftMargin(0);
                                        if ($PrinterSize == 80) {
                                            $printer->setJustification(Printer::JUSTIFY_CENTER);
                                        } else {
                                            $printer->setJustification(Printer::JUSTIFY_LEFT);
                                        }
                                        $printer->selectCharacterTable();
                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $JournalPrint = str_pad("", $MinusToAdd, "=", STR_PAD_LEFT) . "" . mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, "=", STR_PAD_RIGHT) . "\n";

                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $MinusToAdd = floor($MinusToAdd);
                                        $JournalPrint = str_pad("", $MinusToAdd, "=", STR_PAD_LEFT) . "" . mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, "=", STR_PAD_RIGHT) . "\n";

                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['tin'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $MinusToAdd = floor($MinusToAdd);
                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['tin'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['businessName'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $MinusToAdd = floor($MinusToAdd);
                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['businessName'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['locationName'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $MinusToAdd = floor($MinusToAdd);
                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['locationName'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['address'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $MinusToAdd = floor($MinusToAdd);
                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['address'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['district'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $MinusToAdd = floor($MinusToAdd);
                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['district'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                        $JournalPrint .= str_pad("-", $TotalCharacters, "-", STR_PAD_BOTH) . "\n";

                                        $MinusToAdd = $TotalCharacters - mb_strlen("Kasir:" . mb_substr($JournalData['EsirKorisnik'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                        $JournalPrint .= "Kasir:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['EsirKorisnik'], 0, $TotalCharacters, 'UTF-8') . "\n";

                                        if (isset($JournalData['EsirKupacPIB']) && $JournalData['EsirKupacPIB'] > 0) {
                                            $KupacPrint = $JournalData['EsirKupacPIBTip'] . ":" . $JournalData['EsirKupacPIB'];
                                            $MinusToAdd = $TotalCharacters - mb_strlen("ID kupca:" . mb_substr($KupacPrint, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                            $JournalPrint .= "ID kupca:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($KupacPrint, 0, $TotalCharacters, 'UTF-8') . "\n";
                                        }

                                        if (isset($JournalData['EsirKupacOP'])) {
                                            $KupacOpPrint = $JournalData['EsirKupacOPTip'] . ":" . $JournalData['EsirKupacOP'];
                                            $MinusToAdd = $TotalCharacters - mb_strlen("Opciono polje kupca:" . mb_substr($KupacOpPrint, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                            $JournalPrint .= "Opciono polje kupca:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($KupacOpPrint, 0, $TotalCharacters, 'UTF-8') . "\n";
                                        }

                                        $MinusToAdd = $TotalCharacters - mb_strlen("ESIR broj:" . mb_substr('230/' . $ThisSoftwareVersion, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                        $JournalPrint .= "ESIR broj:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr('230/' . $ThisSoftwareVersion, 0, $TotalCharacters, 'UTF-8') . "\n";

                                        if ($ReferentNumber != '') {
                                            $MinusToAdd = $TotalCharacters - mb_strlen("Ref. broj:" . mb_substr($ReferentNumber, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                            $JournalPrint .= "Ref. broj:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($ReferentNumber, 0, $TotalCharacters, 'UTF-8') . "\n";

                                            if ($ReferentTime != '') {
                                                $RefTime = date('d.m.Y H:i:s', strtotime($ReferentTime));
                                                $MinusToAdd = $TotalCharacters - mb_strlen("Ref. vreme:" . mb_substr($RefTime, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                $JournalPrint .= "Ref. vreme:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($RefTime, 0, $TotalCharacters, 'UTF-8') . "\n";
                                            }
                                        }
                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($VrstaRacunaStampa . " " . $TipRacunaStampa, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $JournalPrint .= str_pad("", $MinusToAdd, "-", STR_PAD_LEFT) . "" . mb_substr($VrstaRacunaStampa . " " . $TipRacunaStampa, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, "-", STR_PAD_LEFT) . "\n";

                                        $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("Artikli", 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                        $JournalPrint .= mb_substr("Artikli", 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "\n";

                                        $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";
                                        if ($PrinterSize == 80) {
                                            $JournalPrint .= mb_substr("Naziv    Cena       Kol.          Ukupno", 0, $TotalCharacters, 'UTF-8') . "\n";
                                        } else {
                                            $JournalPrint .= mb_substr("Naziv  Cena     Kol.        Ukupno", 0, $TotalCharacters, 'UTF-8') . "\n";
                                        }


                                        //error_log(str_pad(mb_substr("", 0, 40, 'UTF-8'), 40, "=", STR_PAD_LEFT));
                                        foreach ($JournalData['StavkeProizvoda'] as $StavkaRacuna) {
                                            /*
											if ($StavkaRacuna['gtin'] != '') {
												$ArticleName = $StavkaRacuna['gtin'] . "-" . $StavkaRacuna['name'];
											} else {
												
											}
											*/
											$ArticleName = $StavkaRacuna['name'];
                                            $ArticleName .= " (";
                                            foreach ($StavkaRacuna['labels'] as $TaxMark) {
                                                $ArticleName .= $TaxMark;
                                            }
                                            $ArticleName .= ")";
                                            $arr = array();
                                            $strLen = mb_strlen($ArticleName, 'UTF-8');
                                            for ($i = 0; $i < $strLen; $i++) {
                                                $Name = mb_substr($ArticleName, $i, $TotalCharacters, 'UTF-8');
                                                $MinusToAdd = $TotalCharacters - mb_strlen($Name, 'UTF-8');
                                                $JournalPrint .= str_pad($Name, $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";
                                                $i = $i + $TotalCharacters - 1;
                                            }
                                            if ($TransactionType != 'Sale') {
                                                $StavkaRacuna['totalAmount'] = "-" . $StavkaRacuna['totalAmount'];
                                            }
                                            $TotalCharactersPrice = mb_strlen(number_format($StavkaRacuna['unitPrice'], 2, '.', ''), 'UTF-8');
                                            $TotalCharactersQuantity = mb_strlen(number_format($StavkaRacuna['quantity'], 3, '.', ''), 'UTF-8');
                                            $TotalCharactersTotal = mb_strlen(number_format($StavkaRacuna['totalAmount'], 2, '.', ''), 'UTF-8');
                                            if ($PrinterSize == 80) {
                                                $MaxPrice = 13;
                                                $MaxQuantity = 11;
                                                $MaxTotal = 16;
                                            } else {
                                                $MaxPrice = 11;
                                                $MaxQuantity = 9;
                                                $MaxTotal = 14;
                                            }
                                            if ($TotalCharactersPrice < $MaxPrice) {
                                                $MinusToAdd = $MaxPrice - $TotalCharactersPrice;
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($StavkaRacuna['unitPrice'], 2, '.', '');
                                                $TakenFromPrice = 0;
                                            } else {
                                                $TakenFromPrice = $TotalCharactersPrice - $MaxPrice;
                                                $JournalPrint .= number_format($StavkaRacuna['unitPrice'], 2, '.', '');
                                            }

                                            if ($TotalCharactersQuantity < $MaxQuantity) {
                                                $MinusToAdd = $MaxQuantity - $TotalCharactersQuantity - $TakenFromPrice;
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($StavkaRacuna['quantity'], 3, '.', '');
                                                $TakenFromQuantity = 0;
                                            } else {
                                                $TakenFromQuantity = $TotalCharactersQuantity - $MaxQuantity;
                                                $JournalPrint .= number_format($StavkaRacuna['quantity'], 3, '.', '');
                                            }

                                            if ($TotalCharactersTotal < $MaxTotal) {
                                                $MinusToAdd = $MaxTotal - $TotalCharactersTotal - $TakenFromQuantity;
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($StavkaRacuna['totalAmount'], 2, '.', '') . "\n";
                                            } else {
                                                $JournalPrint .= number_format($StavkaRacuna['totalAmount'], 2, '.', '') . "\n";
                                            }
                                        }
                                        $JournalPrint .= str_pad("", $TotalCharacters, "-", STR_PAD_LEFT) . "\n";
                                        if ($TransactionType == 'Sale') {
                                            $MinusToAdd = $TotalCharacters - mb_strlen("Ukupan iznos:" . number_format($JournalData['totalAmount'], 2, '.', ''), 'UTF-8');
                                            $JournalPrint .= "Ukupan iznos:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($JournalData['totalAmount'], 2, '.', '') . "\n";
                                        } else {
                                            $MinusToAdd = $TotalCharacters - mb_strlen("Ukupna refundacija:" . number_format($JournalData['totalAmount'], 2, '.', ''), 'UTF-8');
                                            $JournalPrint .= "Ukupna refundacija:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($JournalData['totalAmount'], 2, '.', '') . "\n";
                                        }

                                        $PrintFakturaData = 0;
                                        $SvaPlacanja = 0;
                                        foreach ($JournalData['StavkePlacanja'] as $StavkaPlacanja) {
                                            if ($StavkaPlacanja['paymentType'] == 'Cash') {
                                                $PaymentPrint = "Gotovina:";
                                            } elseif ($StavkaPlacanja['paymentType'] == 'Card') {
                                                $PaymentPrint = "Platna kartica:";
                                            } elseif ($StavkaPlacanja['paymentType'] == 'Check') {
                                                $PaymentPrint = "Ček:";
                                            } elseif ($StavkaPlacanja['paymentType'] == 'WireTransfer') {
                                                $PrintFakturaData = 1;
                                                $PaymentPrint = "Prenos na račun:";
                                            } elseif ($StavkaPlacanja['paymentType'] == 'MobileMoney') {
                                                $PaymentPrint = "Mobilni novac:";
                                            } elseif ($StavkaPlacanja['paymentType'] == 'Voucher') {
                                                $PaymentPrint = "Vaučer:";
                                            } elseif ($StavkaPlacanja['paymentType'] == 'Other') {
                                                $PaymentPrint = "Dr. bezgotovinsko plaćanje:";
                                            }
                                            $MinusToAdd = $TotalCharacters - mb_strlen($PaymentPrint . "" . number_format($StavkaPlacanja['amount'], 2, '.', ''), 'UTF-8');
                                            $JournalPrint .= $PaymentPrint . "" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($StavkaPlacanja['amount'], 2, '.', '') . "\n";
                                            $SvaPlacanja = $SvaPlacanja + $StavkaPlacanja['amount'];
                                        }
                                        $Kusur = $SvaPlacanja - $JournalData['totalAmount'];

                                        if ($Kusur >= 0) {
                                            $MinusToAdd = $TotalCharacters - mb_strlen("Повраћај:" . number_format($Kusur, 2, '.', ''), 'UTF-8');
                                            $JournalPrint .= "Povraćaj:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($Kusur, 2, '.', '') . "\n";
                                        } else {
                                            $PreostaloZaNaplatu = -1 * $Kusur;
                                            if ($PreostaloZaNaplatu > 0) {
                                                $MinusToAdd = $TotalCharacters - mb_strlen("Преостало за плаћање:" . number_format($PreostaloZaNaplatu, 2, '.', ''), 'UTF-8');
                                                $JournalPrint .= "Preostalo za plaćanje:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($PreostaloZaNaplatu, 2, '.', '') . "\n";
                                            }
                                        }
                                        if ($Kusur < 0) {
                                            $Kusur = 0;
                                        }
                                        $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";
                                        if ($InvoiceType != 'Normal' && $InvoiceType != 'Advance') {
                                            $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                            $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";
                                            $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";
                                        }
                                        if ($PrinterSize == 80) {
                                            $JournalPrint .= "Oznaka         Ime    Stopa        Porez\n";
                                        } else {
                                            $JournalPrint .= "Oznaka       Ime  Stopa      Porez\n";
                                        }
                                        foreach ($JournalData['taxItems'] as $TaxData) {
                                            $PorezUkupno = $PorezUkupno + number_format($TaxData->amount, 2, '.', '');
                                            if ($TaxData->categoryType == 0) {
                                                $TaxData->rate = number_format($TaxData->rate, 2, '.', '') . "%";
                                            } else {
                                                $TaxData->rate = number_format($TaxData->rate, 2, '.', '');
                                            }
                                            $TotalCharactersLabel = mb_strlen($TaxData->label, 'UTF-8');
                                            $TotalCharactersCategoryName = mb_strlen($TaxData->categoryName, 'UTF-8');
                                            $TotalCharactersRate = mb_strlen($TaxData->rate, 'UTF-8');
                                            $TotalCharactersAmount = mb_strlen(number_format($TaxData->amount, 2, '.', ''), 'UTF-8');
                                            if ($PrinterSize == 80) {
                                                $MaxLabel = 8;
                                                $MaxName = 10;
                                                $MaxRate = 9;
                                                $MaxAmmount = 13;
                                            } else {
                                                $MaxLabel = 6;
                                                $MaxName = 10;
                                                $MaxRate = 7;
                                                $MaxAmmount = 11;
                                            }
                                            if ($TotalCharactersLabel < $MaxLabel) {
                                                $MinusToAdd = $MaxLabel - $TotalCharactersLabel;
                                                $JournalPrint .= $TaxData->label . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT);
                                                $TakenFromLabel = 0;
                                            } else {
                                                $TakenFromLabel = $TotalCharactersLabel - $MaxLabel;
                                                $JournalPrint .= $TaxData->label;
                                            }

                                            if ($TotalCharactersCategoryName < $MaxName) {
                                                $MinusToAdd = $MaxName - $TotalCharactersCategoryName - $TakenFromLabel;
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $TaxData->categoryName;
                                                $TakenFromCategoryName = 0;
                                            } else {
                                                $TakenFromCategoryName = $TotalCharactersCategoryName - $MaxName;
                                                $JournalPrint .= $TaxData->categoryName;
                                            }

                                            if ($TotalCharactersRate < $MaxRate) {
                                                $MinusToAdd = $MaxRate - $TotalCharactersRate - $TakenFromCategoryName;
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $TaxData->rate;
                                                $TakenFromRate = 0;
                                            } else {
                                                $TakenFromRate = $TotalCharactersRate - $MaxRate;
                                                $JournalPrint .= $TaxData->rate;
                                            }

                                            if ($TotalCharactersAmount < $MaxAmmount) {
                                                $MinusToAdd = $MaxAmmount - $TotalCharactersAmount - $TakenFromRate;
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($TaxData->amount, 2, '.', '') . "\n";
                                            } else {
                                                $JournalPrint .= number_format($TaxData->amount, 2, '.', '') . "\n";
                                            }
                                        }
                                        $JournalPrint .= str_pad("", $TotalCharacters, "-", STR_PAD_LEFT) . "\n";
                                        $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("Ukupan iznos poreza:" . number_format($PorezUkupno, 2, ".", ""), 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                        $JournalPrint .= "Ukupan iznos poreza:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($PorezUkupno, 2, ".", "") . "\n";
                                        $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";

                                        $PFRVreme = date('d.m.Y H:i:s', strtotime($JournalData['sdcDateTime']));
                                        $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("PFR vreme:" . $PFRVreme, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                        $JournalPrint .= "PFR vreme:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $PFRVreme . "\n";

                                        if ($PrinterSize == 80) {
                                            $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("PFR br. računa:" . $JournalData['invoiceNumber'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                            $JournalPrint .= "PFR br. računa:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $JournalData['invoiceNumber'] . "\n";
                                        } else {
                                            $JournalPrint .= str_pad("PFR br. računa:", $TotalCharacters, " ", STR_PAD_RIGHT) . "\n";
                                            $JournalPrint .= str_pad($JournalData['invoiceNumber'], $TotalCharacters, " ", STR_PAD_LEFT) . "\n";
                                        }
                                        $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("Brojač računa:" . $JournalData['invoiceCounter'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                        $JournalPrint .= "Brojač računa:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $JournalData['invoiceCounter'] . "\n";

                                        $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";
                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($PrintNameEnd, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $JournalPrint .= str_pad("", $MinusToAdd, "=", STR_PAD_LEFT) . "" . mb_substr($PrintNameEnd, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, "=", STR_PAD_RIGHT) . "\n";

                                        $text = $JournalPrint;
                                        $qrurl = $JournalData['verificationUrl'];

                                        include('qrcode.php');
                                        $options = ['s' => 'qr-l'];
                                        $generator = new QRCodeGen($qrurl, $options);
                                        //QRCode::png($qrurl, null, QR_ECLEVEL_L, 1, 0);
                                        $image = $generator->render_image();
                                        ob_start();
                                        imagepng($image);
                                        $imageString = ob_get_contents();
                                        ob_end_clean();
                                        imagedestroy($image);
                                        $array = preg_split("/\r\n|\n|\r/", $text);
                                        $CountArray = count($array);

                                        $height1 = ($CountArray * $linesize) + $barcodeSize + $linesize;
                                        if ($InvoiceType == 'Copy' && $TransactionType == 'Refund') {
                                            $height1 = (($CountArray + 3) * $linesize) + $barcodeSize + $linesize;
                                        }
                                        $count = 1;
                                        $image = imagecreate($width1, $height1);
                                        $background = imagecolorallocate($image, 255, 255, 255);
                                        $color = imagecolorallocate($image, 0, 0, 0);
                                        imagefill($image, 0, 0, $background);
                                        $offsetTop = 0;
                                        $JournalPrintBigger = str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT);
                                        foreach ($array as $line) {
                                            //error_log($line);
                                            $count++;
                                            if ($count == $CountArray) {
                                                $offsetTop = $offsetTop + $linesize;
                                                $source = imagecreatefromstring($imageString);
                                                $width = imagesx($source);
                                                $height = imagesy($source);
                                                $newwidth = $barcodeSize;
                                                $newheight = $barcodeSize;
                                                $margin = ($width1 - $newwidth) / 2;
                                                $margin = floor($margin);
                                                imagecopyresized($image, $source, $margin, $offsetTop, 0, 0, $newwidth, $newheight, $width, $height);
                                                $offsetTop = $offsetTop + $barcodeSize + $linesize;
                                                //imagestring($image, 5, 10, $offsetTop, $line, $color);
                                                if ($InvoiceType == 'Copy' && $TransactionType == 'Refund') {
                                                    $offsetTop = $offsetTop + $linesize + $linesize;
                                                    if ($PrinterSize == 80) {
                                                        imagettftext($image, $fontsize, 0, 0, $offsetTop, $color, "assets/fonts/LUCON.TTF", "Potpis kupca: _________________________");
                                                    } else {
                                                        imagettftext($image, $fontsize, 0, 0, $offsetTop, $color, "assets/fonts/LUCON.TTF", "Potpis kupca: ___________________");
                                                    }
                                                    $offsetTop = $offsetTop + $linesize;
                                                }
                                                imagettftext($image, $fontsize, 0, 0, $offsetTop, $color, "assets/fonts/LUCON.TTF", $line);
                                            } else {
                                                if ($line == $JournalPrintBigger) {
                                                    $offsetTop = $offsetTop + $linesize;
                                                    //imagestring($image, 5, 10, $offsetTop, $line, $color);
                                                    if ($PrinterSize == 80) {
                                                        $NewFontSize = $fontsize * 1.6;
                                                    } else {
                                                        $NewFontSize = $fontsize * 1.35;
                                                    }
                                                    imagettftext($image, $NewFontSize, 0, 0, $offsetTop, $color, "assets/fonts/LUCON.TTF", $PrintNameStart);
                                                } else {
                                                    $offsetTop = $offsetTop + $linesize;
                                                    //imagestring($image, 5, 10, $offsetTop, $line, $color);
                                                    imagettftext($image, $fontsize, 0, 0, $offsetTop, $color, "assets/fonts/LUCON.TTF", $line);
                                                }
                                            }
                                        }
                                        $NewHeight = $height1;
                                        $NewWidth = $width1 / 2;

                                        $imageNew = imagecreate($NewWidth, $NewHeight);
                                        imagecopyresized($imageNew, $image, 0, 0, 0, 0, $NewWidth, $NewHeight, $width1, $height1);
                                        $TempImgName = "tempimg" . time();
                                        imagepng($imageNew, $TempImgName . ".png", 9, PNG_NO_FILTER);
                                        $img = EscposImage::load($TempImgName . ".png"); // Load image
                                        if ($PrinterSize == 80) {
                                            $printer->setJustification(Printer::JUSTIFY_CENTER);
                                        } else {
                                            $printer->setJustification(Printer::JUSTIFY_LEFT);
                                        }
                                        $printer->bitImageColumnFormat($img, Printer::IMG_DOUBLE_WIDTH);
                                        unlink($TempImgName . ".png");

                                        $printer->feed();
                                        if ($PrintFakturaData == 1 && $EntityVAT != '') {
                                            $PibKupca = mysqli_real_escape_string($link, $EntityVAT);
                                            $GetKupacData = mysqli_query($link, "SELECT * FROM stalnigost WHERE pib='$PibKupca' ORDER BY id DESC LIMIT 1");
                                            if (mysqli_num_rows($GetKupacData) == 1) {
                                                $ResKupacData = mysqli_fetch_array($GetKupacData);
                                                $printer->setJustification(Printer::JUSTIFY_LEFT);
                                                $printer->text("Kupac: " . $ResKupacData['skrNaziv'] . "\n");
                                                $printer->text("PIB: " . $ResKupacData['pib'] . "\n");
                                                $printer->text("MB: " . $ResKupacData['maticniBroj'] . "\n");
                                                $printer->text("Mesto: " . $ResKupacData['mesto'] . "\n");
                                                $printer->text("Adresa: " . $ResKupacData['adersa'] . "\n");
                                            }
                                        }
                                        $printer->cut();
                                        $printer->close();
                                    } catch (Exception $e) {
                                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $NazivStampaca . ' ' . $e->getMessage()));
                                        die();
                                    }
                                }
                                echo json_encode(array('Status' => 'success', 'Message' => 'Napravljen racun!!!', 'RacunId' => 0, 'Action' => $Logout));
                                die();
                            }
                        }
                    }
                } else {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Nisu poslate stavke za naplatu!!! Izdavanje računa nije moguće!!!', 'Request' => json_encode($FiscalRequest)));
                    die();
                }
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Kasa nije podešena za rad sa LPFR!!! Izdavanje računa nije moguće!!!', 'Request' => json_encode($FiscalRequest)));
                die();
            }
        } else {
            die();
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Traženi račun nije pronađen u bazi!'));
    }
    die();
}
if (isset($_POST['CreateInvoiceRefund'])) {
    $InvoiceId = mysqli_real_escape_string($link, $_POST['CreateInvoiceRefund']);
	$CheckInvoiceRef = mysqli_query($link, "SELECT * FROM racun_fiskal WHERE refundZaRacunFiskal='$InvoiceId'");
	if (mysqli_num_rows($CheckInvoiceRef) == 1) {
		echo json_encode(array('Status' => 'error', 'Message' => 'Za izabrani račun već je urađena refundacija!'));
		die();
	}
    $GetInvoiceData = mysqli_query($link, "SELECT * FROM racun_fiskal WHERE id='$InvoiceId'");
	if (mysqli_num_rows($GetInvoiceData) == 1) {
        $InvoiceData = mysqli_fetch_array($GetInvoiceData);
		if($InvoiceData['tipTransakcije'] == 'Refund') {
			$GetInvoiceData = mysqli_query($link, "SELECT brojRacuna FROM racun_fiskal WHERE id='${InvoiceData['refundZaRacunFiskal']}'");
			$InvoiceData = mysqli_fetch_array($GetInvoiceData);
			$racunArr = explode("-",$InvoiceData['brojRacuna']);
			echo json_encode(array('Status' => 'error', 'Message' => 'Izabrani račun je već refundacija računa broj '.$racunArr[2]));
			die();
		}
        $OldJournalData = unserialize($InvoiceData['podaciRacuna']);
        $OldJournalData = json_decode(json_encode($OldJournalData), true);
        $LPFRUrl = $KasaData['lpfr_adresa'];
        $Pin = $KasaData['lpfr_pin'];
        $UrlStatus = $LPFRUrl . "/api/v3/status";
        $DoRequest = 1;
        $cu = curl_init();
        $apiHeader[] = 'Accept: application/json';
        $apiHeader[] = 'Content-Type: application/json';
        $options = array(
            CURLOPT_URL => $UrlStatus,
            CURLOPT_HTTPHEADER => $apiHeader,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET'
        );
        curl_setopt_array($cu, $options);
        $outputcu = curl_exec($cu);
        if (curl_errno($cu) > 0) {
            $DoRequest = 0;
        }
        curl_close($cu);
        $StatusResults = json_decode($outputcu);
        if ($StatusResults->isPinRequired != '') {
            if ($Pin != '') {
                $UrlPIN = $LPFRUrl . "/api/v3/pin";
                $cu = curl_init();
                $options = array(
                    CURLOPT_URL => $UrlPIN,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_HEADER => false, // true to show header information
                    CURLINFO_HEADER_OUT => true,
                    CURLOPT_HTTPGET => false,
                    CURLOPT_POST => true,
                    CURLOPT_FOLLOWLOCATION => false,
                    CURLOPT_VERBOSE => true,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_SSL_VERIFYHOST => false, // true in production
                    CURLOPT_SSL_VERIFYPEER => false, // true in production
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_HTTPHEADER => $apiHeader,
                    CURLOPT_USERAGENT => 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)',
                    CURLOPT_HTTPAUTH => CURLAUTH_ANYSAFE, // CURLAUTH_BASIC
                    CURLOPT_POSTFIELDS => $Pin,
                );
                curl_setopt_array($cu, $options);
                $outputcu = curl_exec($cu);
                if (curl_errno($cu) > 0) {
                    $DoRequest = 0;
                    echo json_encode(array('Status' => 'error', 'Message' => 'Greška pri komunikaciji sa LPFR!' . curl_error($cu)));
                }
                curl_close($cu);
                $Result = json_decode($outputcu);
                if ($Result != "0100") {
                    if ($Result == "2100") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'PIN koji ste uneli nije ispravan!'));
                    } elseif ($Result == "2110") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Kartica je zaključana!'));
                    } elseif ($Result == "2210") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Sigurnosni element je zaključan! Nije moguća fiskalizacija računa!'));
                    } elseif ($Result == "2220") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća komunikacija sa sigurnosnim elementom!'));
                    } elseif ($Result == "1300") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Kartica nije umetnuta!'));
                    } elseif ($Result->status == "400") {
                        echo json_encode(array('Status' => 'error', 'Message' => 'LPFR nije dostupan!'));
                    } else {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Nepoznata greska! Kod:' . $outputcu));
                    }
                    $DoRequest = 0;
                }
            } else {
                echo json_encode(array('Status' => 'pinrequired', 'Message' => 'Neophodno je da unesete PIN!'));
                $DoRequest = 0;
            }
        }
        if ($DoRequest == 1) {
            if ($KasaData['lpfr_adresa'] != '') {
                $Date = date('Y-m-d');
                $DateOfIssue = $Date . " " . date('H:i:s');
                $FiscalRequest = [];
                $EntityVAT = "";
                $EntityVATType = "";
                $EntityField = "";
                $EntityFieldType = "";
                if ($OldJournalData['EsirKupacPIBTip']) {
                    $EntityVATType = $OldJournalData['EsirKupacPIBTip'];
                }
                if ($OldJournalData['EsirKupacPIB']) {
                    $EntityVAT = $OldJournalData['EsirKupacPIB'];
                }
                if ($OldJournalData['EsirKupacOP']) {
                    $EntityField = $OldJournalData['EsirKupacOP'];
                }
                if ($OldJournalData['EsirKupacOPTip']) {
                    $EntityFieldType = $OldJournalData['EsirKupacOPTip'];
                }
                $ReferentNumber = $InvoiceData['brojRacuna'];
                $ReferentTime = $InvoiceData['vremeRacuna'];
                $FiscalRequest['invoiceType'] = $InvoiceData['tipRacuna'];
                $FiscalRequest['transactionType'] = "Refund";
                $FiscalRequest['cashier'] = $OldJournalData['EsirKorisnik'];
                if ($EntityVAT != '') {
                    if ($EntityVATType != '') {
                        $FiscalRequest['buyerId'] = $EntityVATType . ":" . $EntityVAT;
                    }
                }
                if ($EntityField != '') {
                    if ($EntityFieldType != '' && $EntityVAT != '') {
                        $FiscalRequest['buyerCostCenterId'] = $EntityFieldType . ":" . $EntityField;
                    } elseif ($EntityVAT == '') {
                        echo json_encode(array('Status' => 'error', 'Message' => 'Unesite oznaku kupca'));
                        die();
                    }
                }
                if ($ReferentNumber != '') {
                    //ovde naci referentno vreme
                    $FiscalRequest['referentDocumentDT'] = $ReferentTime;
                    $FiscalRequest['referentDocumentNumber'] = $ReferentNumber;
                }
                $FiscalRequest['options']['OmitTextualRepresentation'] = 0;
                $FiscalRequest['options']['OmitQRCodeGen'] = 0;
                $FiscalRequest['invoiceNumber'] = '230/' . $ThisSoftwareVersion;
                $IncProduct = 0;

                $SaveProducts = [];
                $UbaceniArtikli = $OldJournalData['StavkeProizvoda'];
                foreach ($UbaceniArtikli as $UbaceniArtikal) {
                    $FiscalRequest['items'][$IncProduct] = [
                        "gtin" => $UbaceniArtikal['gtin'], "name" => $UbaceniArtikal['name'],
                        "quantity" => $UbaceniArtikal['quantity'],
                        "unitPrice" => $UbaceniArtikal['unitPrice'],
                        "labels" => [$UbaceniArtikal['labels'][0]],
                        "totalAmount" => $UbaceniArtikal['totalAmount']
                    ];
                    $SaveProducts[$IncProduct] = [
                        "gtin" => $UbaceniArtikal['gtin'], "name" => $UbaceniArtikal['name'],
                        "quantity" => $UbaceniArtikal['quantity'],
                        "unitPrice" => $UbaceniArtikal['unitPrice'],
                        "labels" => [$UbaceniArtikal['labels'][0]],
                        "totalAmount" => $UbaceniArtikal['totalAmount'],
                        "unitName" => $UbaceniArtikal['unitName']
                    ];
                    $IncProduct++;
                }
                if (count($SaveProducts) > 0) {
                    $SavePayments = [];
                    $IncPayment = 0;
                    $UbaciPlacanja = $OldJournalData['StavkePlacanja'];
                    foreach ($UbaciPlacanja as $UbaciPlacanje) {
                        $FiscalRequest['payment'][$IncPayment] = ["amount" => $UbaciPlacanje['amount'], "paymentType" => $UbaciPlacanje['paymentType']];
                        $SavePayments[$IncPayment] = ["amount" => $UbaciPlacanje['amount'], "paymentType" => $UbaciPlacanje['paymentType']];
                        $IncPayment++;
                    }
                    if (count($SavePayments) > 0) {
                        //error_log(json_encode($FiscalRequest));
                        $UrlService = $LPFRUrl . "/api/v3/invoices";
                        $curl = curl_init();
                        $options = array(
                            CURLOPT_URL => $UrlService,
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_HEADER => false, // true to show header information
                            CURLINFO_HEADER_OUT => true,
                            CURLOPT_HTTPGET => false,
                            CURLOPT_POST => true,
                            CURLOPT_FOLLOWLOCATION => false,
                            CURLOPT_VERBOSE => true,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_SSL_VERIFYHOST => false, // true in production
                            CURLOPT_SSL_VERIFYPEER => false, // true in production
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_HTTPHEADER => $apiHeader,
                            CURLOPT_USERAGENT => 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)',
                            CURLOPT_HTTPAUTH => CURLAUTH_ANYSAFE, // CURLAUTH_BASIC
                            CURLOPT_POSTFIELDS => json_encode($FiscalRequest)
                        );
                        curl_setopt_array($curl, $options);
                        $output = curl_exec($curl);
                        if (curl_errno($curl) > 0) {
                            echo json_encode(array('Status' => 'error', 'Message' => 'Greška pri kontaktiranju LPFR!' . curl_error($curl)));
                            die();
                        } else {
                            //error_log($output);
                            $json = json_decode($output);
                            if (strtoupper($json->messages) != 'SUCCESS') {
                                $ModelError = $json->modelState;
                                $GreskeKojeSuUocene = "";
                                foreach ($ModelError as $ErrorData) {
                                    $StaJeLose = $ErrorData->property;
                                    $KojeSuGreske = $ErrorData->errors;
                                    $GreskeKojeSuUocene .= "Polje:" . $StaJeLose;
                                    foreach ($KojeSuGreske as $KodGreske) {
                                        if ($KodGreske == '2310') {
                                            $GreskeKojeSuUocene .= " poreska stopa nije ispravna. ";
                                        } elseif ($KodGreske == '2800') {
                                            $GreskeKojeSuUocene .= " je obavezno. ";
                                        } elseif ($KodGreske == '2801') {
                                            $GreskeKojeSuUocene .= " je predugo. ";
                                        } elseif ($KodGreske == '2802') {
                                            $GreskeKojeSuUocene .= " je prekratko. ";
                                        } elseif ($KodGreske == '2803') {
                                            $GreskeKojeSuUocene .= " je neispravne dužine. ";
                                        } elseif ($KodGreske == '2804') {
                                            $GreskeKojeSuUocene .= " je izvan očekivane vrednosti. ";
                                        } elseif ($KodGreske == '2805') {
                                            $GreskeKojeSuUocene .= " je neispravne vrednosti. ";
                                        } elseif ($KodGreske == '2806') {
                                            $GreskeKojeSuUocene .= " je neispravnog formata. ";
                                        } elseif ($KodGreske == '2807') {
                                            $GreskeKojeSuUocene .= " ne sadrži makar jedan element. ";
                                        } elseif ($KodGreske == '2808') {
                                            $GreskeKojeSuUocene .= " sadrži više od dozvoljenog broja elemenata. ";
                                        }
                                    }
                                }
                                echo json_encode(array('Status' => 'error', 'Message' => 'Neuspešna fiskalizacija! ' . $GreskeKojeSuUocene));
                                die();
                            } else {
                                $text = $json->journal;
                                $qrCode = $json->verificationQRCode;
                                $qrurl = $json->verificationUrl;
                                $LPFRNumber = $json->invoiceNumber;
                                $JournalData = [];
                                foreach ($json as $JsonName => $JsonValue) {
                                    if ($JsonName != 'verificationQRCode' && $JsonName != 'encryptedInternalData' && $JsonName != 'signature' && $JsonName != 'journal') {
                                        $JournalData[$JsonName] = $JsonValue;
                                    }
                                }
                                $JournalData['StavkeProizvoda'] = $SaveProducts;
                                $JournalData['StavkePlacanja'] = $SavePayments;
                                $JournalData['EsirKorisnik'] = $OldJournalData['EsirKorisnik'];
                                if ($EntityVAT > 0) {
                                    $JournalData['EsirKupacPIB'] = $EntityVAT;
                                    $JournalData['EsirKupacPIBTip'] = $EntityVATType;
                                }
                                if ($EntityField != '') {
                                    $JournalData['EsirKupacOP'] = $EntityField;
                                    $JournalData['EsirKupacOPTip'] = $EntityFieldType;
                                }
                                if ($ReferentNumber != '') {
                                    $JournalData['EsirReferentnoVremeDokumenta'] = $ReferentTime;
                                }
                                $TransactionType = "Refund";
                                $InvoiceType = $InvoiceData['tipRacuna'];
                                $JournalData['InvoiceType'] = $InvoiceType;
                                $JournalData['TransactionType'] = $TransactionType;
                                $brojRacuna = $LPFRNumber;
                                $tipRacuna = mysqli_real_escape_string($link, $InvoiceType);
                                $tipTransakcije = mysqli_real_escape_string($link, $TransactionType);
                                $KONOBAR_ID = mysqli_real_escape_string($link, $UserId);
                                $vremeRacuna = date('Y-m-d H:i:s', strtotime($JournalData['sdcDateTime']));
                                $vremeRacuna = mysqli_real_escape_string($link, $vremeRacuna);
                                $brojRacuna = mysqli_real_escape_string($link, $LPFRNumber);
                                $podaciRacuna = serialize($JournalData);
                                $podaciRacuna = mysqli_real_escape_string($link, $podaciRacuna);
                                mysqli_query($link, "INSERT INTO racun_fiskal (RACUN_ID, brojRacuna, tipRacuna, tipTransakcije, KONOBAR_ID, refundZaRacunFiskal, vremeRacuna, podaciRacuna) 
                                    VALUES (0, '$brojRacuna', '$tipRacuna', '$tipTransakcije', '$KONOBAR_ID', '$InvoiceId', '$vremeRacuna', '$podaciRacuna')") or die(mysqli_error($link));
                                $NoviRacunFiskalId = mysqli_insert_id($link);
								$UserId = mysqli_real_escape_string($link, $_COOKIE['UserId']);
								$NoviRacunId = -1;
								$ZdBroj = -1;
								$GetRacunFiskal = mysqli_query($link, "SELECT racun_id FROM racun_fiskal WHERE id='$InvoiceId'");
								if (mysqli_num_rows($GetRacunFiskal) == 1) {
									$RacunFiskalData = mysqli_fetch_array($GetRacunFiskal);
									$RacunID = $RacunFiskalData['racun_id'];
									$GetRacun = mysqli_query($link, "SELECT * FROM racun WHERE id='$RacunID' ORDER BY id DESC LIMIT 1");
									if (mysqli_num_rows($GetRacun) == 1) {
										$RacunData = mysqli_fetch_array($GetRacun);
										mysqli_query($link, "INSERT INTO racun(brojRacuna, brojStola, datum, fiskalniOdstampan, storniran, zatvoren, KASA_ID, KONOBAR_ID, popust, zdBroj, DOSTAVA_ID, DOSTAVAADRESA_ID, crnoplacanje, naOsnovno)
										VALUES('${RacunData['brojRacuna']}', '${RacunData['brojStola']}', '${RacunData['datum']}', 0, 0, 1, '${RacunData['KASA_ID']}', '$UserId', '${RacunData['popust']}', 
												'${RacunData['zdBroj']}', '${RacunData['DOSTAVA_ID']}', '${RacunData['DOSTAVAADRESA_ID']}', 'REFUNDACIJA', '1')") or die(mysqli_error($link) . "na upisu racuna pri refundaciji");
										$NoviRacunId = mysqli_insert_id($link);
										$ZdBroj = $RacunData['zdBroj'];
									}
									if($NoviRacunId > 0) {
										$GetRacunStavke = mysqli_query($link, "SELECT * FROM stavkaracuna WHERE RACUN_ID='$RacunID' ORDER BY id DESC");
										if (mysqli_num_rows($GetRacunStavke) > 0) {
											while ($RacunStavkeData = mysqli_fetch_array($GetRacunStavke)) {
												$RacunStavkeData['kolicina'] = $RacunStavkeData['kolicina'] * (-1);
												mysqli_query($link, "INSERT INTO stavkaracuna (brojStola, cena, kolicina, naziv, ARTIKAL_ID, TURA_ID, opis, RACUN_ID, gostbroj) 
													VALUES ('${RacunStavkeData['brojStola']}', '${RacunStavkeData['cena']}', '${RacunStavkeData['kolicina']}', '${RacunStavkeData['naziv']}', 
													'${RacunStavkeData['ARTIKAL_ID']}', '${RacunStavkeData['TURA_ID']}', '${RacunStavkeData['opis']}', '$NoviRacunId', '${RacunStavkeData['gostbroj']}')") or die(mysqli_error($link));
											}
										}
									}
									
									$UpdateRacunFiskal = mysqli_query($link, "UPDATE racun_fiskal SET RACUN_ID='$NoviRacunId', refundZaRacunFiskal='$InvoiceId' WHERE id='$NoviRacunFiskalId'");
									RekonstrukcijaRacun($NoviRacunId, $ZdBroj, -1);
								}
								$GetStampac = mysqli_query($link, "SELECT * FROM stampac WHERE stampaGotovinski=1 ORDER BY id ASC LIMIT 1");
                                if (mysqli_num_rows($GetStampac) == 1) {
                                    $StampacData = mysqli_fetch_array($GetStampac);
                                    $NazivStampaca = $StampacData['naziv'];
                                    $PrinterSize = 57;
                                    if ($StampacData['tip'] == 'POSBANK80MM') {
                                        $PrinterSize = 80;
                                    }
                                    if ($tipRacuna == 'Normal') {
                                        $PrintNameStart = " FISKALNI RAČUN ";
                                        $PrintNameEnd = " KRAJ FISKALNOG RAČUNA ";
                                    } else {
                                        $PrintNameStart = " OVO NIJE FISKALNI RAČUN ";
                                        $PrintNameEnd = " OVO NIJE FISKALNI RAČUN ";
                                    }
                                    $TipRacunaStampa = "";
                                    $VrstaRacunaStampa = "";
                                    $PorezUkupno = 0;

                                    if ($tipTransakcije == 'Sale') {
                                        $TipRacunaStampa = "PRODAJA";
                                    } else {
                                        $TipRacunaStampa = "REFUNDACIJA";
                                    }
                                    if ($tipRacuna == 'Normal') {
                                        $VrstaRacunaStampa = "PROMET";
                                    } else if ($tipRacuna == 'Training') {
                                        $VrstaRacunaStampa = "OBUKA";
                                    } else if ($tipRacuna == 'Copy') {
                                        $VrstaRacunaStampa = "KOPIJA";
                                    } else if ($tipRacuna == 'Proforma') {
                                        $VrstaRacunaStampa = "PREDRAČUN";
                                    } else if ($tipRacuna == 'Advance') {
                                        $VrstaRacunaStampa = "AVANS";
                                    }
                                    if ($PrinterSize == 80) {
                                        $width1 = 480;
                                        $fontsize = 15;
                                        $linesize = 23;
                                        $barcodeSize = 420;
                                        $TotalCharacters = 40;
                                    } else {
                                        $width1 = 375;
                                        $fontsize = 14;
                                        $linesize = 18;
                                        $barcodeSize = 365;
                                        $TotalCharacters = 34;
                                    }

                                    try {
                                        // Enter the share name for your USB printer here
                                        if (strpos($NazivStampaca, "/")) {
                                            $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                                        } else {
                                            $connector = new WindowsPrintConnector($NazivStampaca);
                                        }
                                        $printer = new Printer($connector);
                                        $printer->pulse(1, 300, 300);
                                        $printer->setPrintLeftMargin(0);
                                        if ($PrinterSize == 80) {
                                            $printer->setJustification(Printer::JUSTIFY_CENTER);
                                        } else {
                                            $printer->setJustification(Printer::JUSTIFY_LEFT);
                                        }
                                        $printer->selectCharacterTable();
                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $MinusToAdd = floor($MinusToAdd);
                                        $JournalPrint = str_pad("", $MinusToAdd, "=", STR_PAD_LEFT) . "" . mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, "=", STR_PAD_RIGHT) . "\n";

                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['tin'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $MinusToAdd = floor($MinusToAdd);
                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['tin'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['businessName'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $MinusToAdd = floor($MinusToAdd);
                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['businessName'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['locationName'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $MinusToAdd = floor($MinusToAdd);
                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['locationName'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['address'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $MinusToAdd = floor($MinusToAdd);
                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['address'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($JournalData['district'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $MinusToAdd = floor($MinusToAdd);
                                        $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['district'], 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";

                                        $JournalPrint .= str_pad("-", $TotalCharacters, "-", STR_PAD_BOTH) . "\n";

                                        $MinusToAdd = $TotalCharacters - mb_strlen("Kasir:" . mb_substr($JournalData['EsirKorisnik'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                        $JournalPrint .= "Kasir:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($JournalData['EsirKorisnik'], 0, $TotalCharacters, 'UTF-8') . "\n";

                                        if (isset($JournalData['EsirKupacPIB']) && $JournalData['EsirKupacPIB'] > 0) {
                                            $KupacPrint = $JournalData['EsirKupacPIBTip'] . ":" . $JournalData['EsirKupacPIB'];
                                            $MinusToAdd = $TotalCharacters - mb_strlen("ID kupca:" . mb_substr($KupacPrint, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                            $JournalPrint .= "ID kupca:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($KupacPrint, 0, $TotalCharacters, 'UTF-8') . "\n";
                                        }

                                        if (isset($JournalData['EsirKupacOP'])) {
                                            $KupacOpPrint = $JournalData['EsirKupacOPTip'] . ":" . $JournalData['EsirKupacOP'];
                                            $MinusToAdd = $TotalCharacters - mb_strlen("Opciono polje kupca:" . mb_substr($KupacOpPrint, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                            $JournalPrint .= "Opciono polje kupca:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($KupacOpPrint, 0, $TotalCharacters, 'UTF-8') . "\n";
                                        }

                                        $MinusToAdd = $TotalCharacters - mb_strlen("ESIR broj:" . mb_substr('230/' . $ThisSoftwareVersion, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                        $JournalPrint .= "ESIR broj:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr('230/' . $ThisSoftwareVersion, 0, $TotalCharacters, 'UTF-8') . "\n";

                                        if ($ReferentNumber != '') {
                                            $MinusToAdd = $TotalCharacters - mb_strlen("Ref. broj:" . mb_substr($ReferentNumber, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                            $JournalPrint .= "Ref. broj:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($ReferentNumber, 0, $TotalCharacters, 'UTF-8') . "\n";

                                            if ($ReferentTime != '') {
                                                $RefTime = date('d.m.Y H:i:s', strtotime($ReferentTime));
                                                $MinusToAdd = $TotalCharacters - mb_strlen("Ref. vreme:" . mb_substr($RefTime, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                                $JournalPrint .= "Ref. vreme:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($RefTime, 0, $TotalCharacters, 'UTF-8') . "\n";
                                            }
                                        }
                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($VrstaRacunaStampa . " " . $TipRacunaStampa, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $JournalPrint .= str_pad("", $MinusToAdd, "-", STR_PAD_LEFT) . "" . mb_substr($VrstaRacunaStampa . " " . $TipRacunaStampa, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, "-", STR_PAD_LEFT) . "\n";

                                        $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("Artikli", 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                        $JournalPrint .= mb_substr("Artikli", 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "\n";

                                        $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";
                                        if ($PrinterSize == 80) {
                                            $JournalPrint .= mb_substr("Naziv    Cena       Kol.          Ukupno", 0, $TotalCharacters, 'UTF-8') . "\n";
                                        } else {
                                            $JournalPrint .= mb_substr("Naziv  Cena     Kol.        Ukupno", 0, $TotalCharacters, 'UTF-8') . "\n";
                                        }
                                        //error_log(str_pad(mb_substr("", 0, 40, 'UTF-8'), 40, "=", STR_PAD_LEFT));
                                        foreach ($JournalData['StavkeProizvoda'] as $StavkaRacuna) {
                                            /*
											if ($StavkaRacuna['gtin'] != '') {
												$ArticleName = $StavkaRacuna['gtin'] . "-" . $StavkaRacuna['name'];
											} else {
												
											}
											*/
											$ArticleName = $StavkaRacuna['name'];
                                            $ArticleName .= " (";
                                            foreach ($StavkaRacuna['labels'] as $TaxMark) {
                                                $ArticleName .= $TaxMark;
                                            }
                                            $ArticleName .= ")";
                                            $arr = array();
                                            $strLen = mb_strlen($ArticleName, 'UTF-8');
                                            for ($i = 0; $i < $strLen; $i++) {
                                                $Name = mb_substr($ArticleName, $i, $TotalCharacters, 'UTF-8');
                                                $MinusToAdd = $TotalCharacters - mb_strlen($Name, 'UTF-8');
                                                $JournalPrint .= str_pad($Name, $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";
                                                $i = $i + $TotalCharacters - 1;
                                            }
                                            if ($TransactionType != 'Sale') {
                                                $StavkaRacuna['totalAmount'] = "-" . $StavkaRacuna['totalAmount'];
                                            }
                                            $TotalCharactersPrice = mb_strlen(number_format($StavkaRacuna['unitPrice'], 2, '.', ''), 'UTF-8');
                                            $TotalCharactersQuantity = mb_strlen(number_format($StavkaRacuna['quantity'], 3, '.', ''), 'UTF-8');
                                            $TotalCharactersTotal = mb_strlen(number_format($StavkaRacuna['totalAmount'], 2, '.', ''), 'UTF-8');
                                            if ($PrinterSize == 80) {
                                                $MaxPrice = 13;
                                                $MaxQuantity = 11;
                                                $MaxTotal = 16;
                                            } else {
                                                $MaxPrice = 11;
                                                $MaxQuantity = 9;
                                                $MaxTotal = 14;
                                            }
                                            if ($TotalCharactersPrice < $MaxPrice) {
                                                $MinusToAdd = $MaxPrice - $TotalCharactersPrice;
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($StavkaRacuna['unitPrice'], 2, '.', '');
                                                $TakenFromPrice = 0;
                                            } else {
                                                $TakenFromPrice = $TotalCharactersPrice - $MaxPrice;
                                                $JournalPrint .= number_format($StavkaRacuna['unitPrice'], 2, '.', '');
                                            }

                                            if ($TotalCharactersQuantity < $MaxQuantity) {
                                                $MinusToAdd = $MaxQuantity - $TotalCharactersQuantity - $TakenFromPrice;
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($StavkaRacuna['quantity'], 3, '.', '');
                                                $TakenFromQuantity = 0;
                                            } else {
                                                $TakenFromQuantity = $TotalCharactersQuantity - $MaxQuantity;
                                                $JournalPrint .= number_format($StavkaRacuna['quantity'], 3, '.', '');
                                            }

                                            if ($TotalCharactersTotal < $MaxTotal) {
                                                $MinusToAdd = $MaxTotal - $TotalCharactersTotal - $TakenFromQuantity;
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($StavkaRacuna['totalAmount'], 2, '.', '') . "\n";
                                            } else {
                                                $JournalPrint .= number_format($StavkaRacuna['totalAmount'], 2, '.', '') . "\n";
                                            }
                                        }
                                        $JournalPrint .= str_pad("", $TotalCharacters, "-", STR_PAD_LEFT) . "\n";
                                        if ($TransactionType == 'Sale') {
                                            $MinusToAdd = $TotalCharacters - mb_strlen("Ukupan iznos:" . number_format($JournalData['totalAmount'], 2, '.', ''), 'UTF-8');
                                            $JournalPrint .= "Ukupan iznos:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($JournalData['totalAmount'], 2, '.', '') . "\n";
                                        } else {
                                            $MinusToAdd = $TotalCharacters - mb_strlen("Ukupna refundacija:" . number_format($JournalData['totalAmount'], 2, '.', ''), 'UTF-8');
                                            $JournalPrint .= "Ukupna refundacija:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($JournalData['totalAmount'], 2, '.', '') . "\n";
                                        }
                                        $PrintFakturaData = 0;
                                        $SvaPlacanja = 0;
                                        foreach ($JournalData['StavkePlacanja'] as $StavkaPlacanja) {
                                            if ($StavkaPlacanja['paymentType'] == 'Cash') {
                                                $PaymentPrint = "Gotovina:";
                                            } elseif ($StavkaPlacanja['paymentType'] == 'Card') {
                                                $PaymentPrint = "Platna kartica:";
                                            } elseif ($StavkaPlacanja['paymentType'] == 'Check') {
                                                $PaymentPrint = "Ček:";
                                            } elseif ($StavkaPlacanja['paymentType'] == 'WireTransfer') {
                                                $PaymentPrint = "Prenos na račun:";
                                                $PrintFakturaData = 1;
                                            } elseif ($StavkaPlacanja['paymentType'] == 'MobileMoney') {
                                                $PaymentPrint = "Mobilni novac:";
                                            } elseif ($StavkaPlacanja['paymentType'] == 'Voucher') {
                                                $PaymentPrint = "Vaučer:";
                                            } elseif ($StavkaPlacanja['paymentType'] == 'Other') {
                                                $PaymentPrint = "Dr. bezgotovinsko plaćanje:";
                                            }
                                            $MinusToAdd = $TotalCharacters - mb_strlen($PaymentPrint . "" . number_format($StavkaPlacanja['amount'], 2, '.', ''), 'UTF-8');
                                            $JournalPrint .= $PaymentPrint . "" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($StavkaPlacanja['amount'], 2, '.', '') . "\n";
                                            $SvaPlacanja = $SvaPlacanja + $StavkaPlacanja['amount'];
                                        }
                                        $Kusur = $SvaPlacanja - $JournalData['totalAmount'];

                                        if ($Kusur >= 0) {
                                            $MinusToAdd = $TotalCharacters - mb_strlen("Повраћај:" . number_format($Kusur, 2, '.', ''), 'UTF-8');
                                            $JournalPrint .= "Povraćaj:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($Kusur, 2, '.', '') . "\n";
                                        } else {
                                            $PreostaloZaNaplatu = -1 * $Kusur;
                                            if ($PreostaloZaNaplatu > 0) {
                                                $MinusToAdd = $TotalCharacters - mb_strlen("Преостало за плаћање:" . number_format($PreostaloZaNaplatu, 2, '.', ''), 'UTF-8');
                                                $JournalPrint .= "Preostalo za plaćanje:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($PreostaloZaNaplatu, 2, '.', '') . "\n";
                                            }
                                        }
                                        if ($Kusur < 0) {
                                            $Kusur = 0;
                                        }
                                        $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";
                                        if ($InvoiceType != 'Normal' && $InvoiceType != 'Advance') {
                                            $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                            $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT) . "\n";
                                            $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";
                                        }
                                        if ($PrinterSize == 80) {
                                            $JournalPrint .= "Oznaka         Ime    Stopa        Porez\n";
                                        } else {
                                            $JournalPrint .= "Oznaka       Ime  Stopa      Porez\n";
                                        }
                                        foreach ($JournalData['taxItems'] as $TaxData) {
                                            $PorezUkupno = $PorezUkupno + number_format($TaxData->amount, 2, '.', '');
                                            if ($TaxData->categoryType == 0) {
                                                $TaxData->rate = number_format($TaxData->rate, 2, '.', '') . "%";
                                            } else {
                                                $TaxData->rate = number_format($TaxData->rate, 2, '.', '');
                                            }
                                            $TotalCharactersLabel = mb_strlen($TaxData->label, 'UTF-8');
                                            $TotalCharactersCategoryName = mb_strlen($TaxData->categoryName, 'UTF-8');
                                            $TotalCharactersRate = mb_strlen($TaxData->rate, 'UTF-8');
                                            $TotalCharactersAmount = mb_strlen(number_format($TaxData->amount, 2, '.', ''), 'UTF-8');
                                            if ($PrinterSize == 80) {
                                                $MaxLabel = 8;
                                                $MaxName = 10;
                                                $MaxRate = 9;
                                                $MaxAmmount = 13;
                                            } else {
                                                $MaxLabel = 6;
                                                $MaxName = 10;
                                                $MaxRate = 7;
                                                $MaxAmmount = 11;
                                            }
                                            if ($TotalCharactersLabel < $MaxLabel) {
                                                $MinusToAdd = $MaxLabel - $TotalCharactersLabel;
                                                $JournalPrint .= $TaxData->label . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT);
                                                $TakenFromLabel = 0;
                                            } else {
                                                $TakenFromLabel = $TotalCharactersLabel - $MaxLabel;
                                                $JournalPrint .= $TaxData->label;
                                            }

                                            if ($TotalCharactersCategoryName < $MaxName) {
                                                $MinusToAdd = $MaxName - $TotalCharactersCategoryName - $TakenFromLabel;
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $TaxData->categoryName;
                                                $TakenFromCategoryName = 0;
                                            } else {
                                                $TakenFromCategoryName = $TotalCharactersCategoryName - $MaxName;
                                                $JournalPrint .= $TaxData->categoryName;
                                            }

                                            if ($TotalCharactersRate < $MaxRate) {
                                                $MinusToAdd = $MaxRate - $TotalCharactersRate - $TakenFromCategoryName;
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $TaxData->rate;
                                                $TakenFromRate = 0;
                                            } else {
                                                $TakenFromRate = $TotalCharactersRate - $MaxRate;
                                                $JournalPrint .= $TaxData->rate;
                                            }

                                            if ($TotalCharactersAmount < $MaxAmmount) {
                                                $MinusToAdd = $MaxAmmount - $TotalCharactersAmount - $TakenFromRate;
                                                $JournalPrint .= str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($TaxData->amount, 2, '.', '') . "\n";
                                            } else {
                                                $JournalPrint .= number_format($TaxData->amount, 2, '.', '') . "\n";
                                            }
                                        }
                                        $JournalPrint .= str_pad("", $TotalCharacters, "-", STR_PAD_LEFT) . "\n";
                                        $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("Ukupan iznos poreza:" . number_format($PorezUkupno, 2, ".", ""), 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                        $JournalPrint .= "Ukupan iznos poreza:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . number_format($PorezUkupno, 2, ".", "") . "\n";
                                        $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";

                                        $PFRVreme = date('d.m.Y H:i:s', strtotime($JournalData['sdcDateTime']));
                                        $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("PFR vreme:" . $PFRVreme, 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                        $JournalPrint .= "PFR vreme:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $PFRVreme . "\n";

                                        if ($PrinterSize == 80) {
                                            $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("PFR br. računa:" . $JournalData['invoiceNumber'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                            $JournalPrint .= "PFR br. računa:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $JournalData['invoiceNumber'] . "\n";
                                        } else {
                                            $JournalPrint .= str_pad("PFR br. računa:", $TotalCharacters, " ", STR_PAD_RIGHT) . "\n";
                                            $JournalPrint .= str_pad($JournalData['invoiceNumber'], $TotalCharacters, " ", STR_PAD_LEFT) . "\n";
                                        }

                                        $MinusToAdd = $TotalCharacters - mb_strlen(mb_substr("Brojač računa:" . $JournalData['invoiceCounter'], 0, $TotalCharacters, 'UTF-8'), 'UTF-8');
                                        $JournalPrint .= "Brojač računa:" . str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . $JournalData['invoiceCounter'] . "\n";

                                        $JournalPrint .= str_pad("", $TotalCharacters, "=", STR_PAD_LEFT) . "\n";
                                        $MinusToAdd = ($TotalCharacters - mb_strlen(mb_substr($PrintNameEnd, 0, $TotalCharacters, 'UTF-8'), 'UTF-8')) / 2;
                                        $JournalPrint .= str_pad("", $MinusToAdd, "=", STR_PAD_LEFT) . "" . mb_substr($PrintNameEnd, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, "=", STR_PAD_RIGHT) . "\n";

                                        $text = $JournalPrint;
                                        $qrurl = $JournalData['verificationUrl'];

                                        include('qrcode.php');
                                        $options = ['s' => 'qr-l'];
                                        $generator = new QRCodeGen($qrurl, $options);
                                        //QRCode::png($qrurl, null, QR_ECLEVEL_L, 1, 0);
                                        $image = $generator->render_image();
                                        ob_start();
                                        imagepng($image);
                                        $imageString = ob_get_contents();
                                        ob_end_clean();
                                        imagedestroy($image);
                                        $array = preg_split("/\r\n|\n|\r/", $text);
                                        $CountArray = count($array);

                                        $height1 = ($CountArray * $linesize) + $barcodeSize + $linesize;
                                        if ($InvoiceType == 'Copy' && $TransactionType == 'Refund') {
                                            $height1 = (($CountArray + 3) * $linesize) + $barcodeSize + $linesize;
                                        }
                                        $count = 1;
                                        $image = imagecreate($width1, $height1);
                                        $background = imagecolorallocate($image, 255, 255, 255);
                                        $color = imagecolorallocate($image, 0, 0, 0);
                                        imagefill($image, 0, 0, $background);
                                        $offsetTop = 0;
                                        $JournalPrintBigger = str_pad("", $MinusToAdd, " ", STR_PAD_LEFT) . "" . mb_substr($PrintNameStart, 0, $TotalCharacters, 'UTF-8') . "" . str_pad("", $MinusToAdd, " ", STR_PAD_RIGHT);
                                        foreach ($array as $line) {
                                            //error_log($line);
                                            $count++;
                                            if ($count == $CountArray) {
                                                $offsetTop = $offsetTop + $linesize;
                                                $source = imagecreatefromstring($imageString);
                                                $width = imagesx($source);
                                                $height = imagesy($source);
                                                $newwidth = $barcodeSize;
                                                $newheight = $barcodeSize;
                                                $margin = ($width1 - $newwidth) / 2;
                                                $margin = floor($margin);
                                                imagecopyresized($image, $source, $margin, $offsetTop, 0, 0, $newwidth, $newheight, $width, $height);
                                                $offsetTop = $offsetTop + $barcodeSize + $linesize;
                                                //imagestring($image, 5, 10, $offsetTop, $line, $color);
                                                if ($InvoiceType == 'Copy' && $TransactionType == 'Refund') {
                                                    $offsetTop = $offsetTop + $linesize + $linesize;
                                                    imagettftext($image, $fontsize, 0, 0, $offsetTop, $color, "assets/fonts/LUCON.TTF", "Potpis kupca: _________________________");
                                                    $offsetTop = $offsetTop + $linesize;
                                                }
                                                imagettftext($image, $fontsize, 0, 0, $offsetTop, $color, "assets/fonts/LUCON.TTF", $line);
                                            } else {
                                                if ($line == $JournalPrintBigger) {
                                                    $offsetTop = $offsetTop + $linesize;
                                                    //imagestring($image, 5, 10, $offsetTop, $line, $color);
                                                    if ($PrinterSize == 80) {
                                                        $NewFontSize = $fontsize * 1.6;
                                                    } else {
                                                        $NewFontSize = $fontsize * 1.35;
                                                    }
                                                    imagettftext($image, $NewFontSize, 0, 0, $offsetTop, $color, "assets/fonts/LUCON.TTF", $PrintNameStart);
                                                } else {
                                                    $offsetTop = $offsetTop + $linesize;
                                                    //imagestring($image, 5, 10, $offsetTop, $line, $color);
                                                    imagettftext($image, $fontsize, 0, 0, $offsetTop, $color, "assets/fonts/LUCON.TTF", $line);
                                                }
                                            }
                                        }
                                        $NewHeight = $height1;
                                        $NewWidth = $width1 / 2;

                                        $imageNew = imagecreate($NewWidth, $NewHeight);
                                        imagecopyresized($imageNew, $image, 0, 0, 0, 0, $NewWidth, $NewHeight, $width1, $height1);
                                        $TempImgName = "tempimg" . time();
                                        imagepng($imageNew, $TempImgName . ".png", 9, PNG_NO_FILTER);
                                        $img = EscposImage::load($TempImgName . ".png"); // Load image
                                        if ($PrinterSize == 80) {
                                            $printer->setJustification(Printer::JUSTIFY_CENTER);
                                        } else {
                                            $printer->setJustification(Printer::JUSTIFY_LEFT);
                                        }


                                        $printer->bitImageColumnFormat($img, Printer::IMG_DOUBLE_WIDTH);
                                        unlink($TempImgName . ".png");

                                        $printer->feed();
                                        if ($PrintFakturaData == 1 && $EntityVAT != '') {
                                            $PibKupca = mysqli_real_escape_string($link, $EntityVAT);
                                            $GetKupacData = mysqli_query($link, "SELECT * FROM stalnigost WHERE pib='$PibKupca' ORDER BY id DESC LIMIT 1");
                                            if (mysqli_num_rows($GetKupacData) == 1) {
                                                $ResKupacData = mysqli_fetch_array($GetKupacData);
                                                $printer->setJustification(Printer::JUSTIFY_LEFT);
                                                $printer->text("Kupac: " . $ResKupacData['skrNaziv'] . "\n");
                                                $printer->text("PIB: " . $ResKupacData['pib'] . "\n");
                                                $printer->text("MB: " . $ResKupacData['maticniBroj'] . "\n");
                                                $printer->text("Mesto: " . $ResKupacData['mesto'] . "\n");
                                                $printer->text("Adresa: " . $ResKupacData['adersa'] . "\n");
                                            }
                                        }
                                        $printer->cut();
                                        $printer->close();
                                    } catch (Exception $e) {
                                        echo json_encode(array('Status' => 'error', 'Message' => 'Nije moguća štampa na: ' . $NazivStampaca . ' ' . $e->getMessage()));
                                        die();
                                    }
                                }
                                echo json_encode(array('Status' => 'success', 'Message' => 'Napravljen racun!!!', 'RacunId' => 0, 'Action' => $Logout));
                                die();
                            }
                        }
                    }
                } else {
                    echo json_encode(array('Status' => 'error', 'Message' => 'Nisu poslate stavke za naplatu!!! Izdavanje računa nije moguće!!!', 'Request' => json_encode($FiscalRequest)));
                    die();
                }
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => 'Kasa nije podešena za rad sa LPFR!!! Izdavanje računa nije moguće!!!', 'Request' => json_encode($FiscalRequest)));
                die();
            }
        } else {
            die();
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Traženi račun nije pronađen u bazi!'));
    }
    die();
}
if (isset($_POST['SearchForProductItem'])) {
    $SearchTerm = mysqli_real_escape_string($link, $_POST['SearchForProductItem']);
    $GetItems = mysqli_query($link, "SELECT * FROM artikal WHERE (skrNaziv LIKE '%$SearchTerm%' OR barCode LIKE '%$SearchTerm%') AND blokiran!=1 AND tip!='SIRO' ORDER BY prioritet ASC, skrNaziv ASC LIMIT 10");
    if (mysqli_num_rows($GetItems) > 0) {
        $HtmlToReturn = "";
        while ($rowItems = mysqli_fetch_array($GetItems)) {
            $HtmlToReturn .= "<div class='PretragaArtikalaRezultat' idtrazenogartikla='" . $rowItems['id'] . "'>" . $rowItems['skrNaziv'] . "</div>";
        }
        echo json_encode(array('Status' => 'success', 'Message' => 'Traženi artikal je pronađen u bazi!', 'HtmlToInsert' => $HtmlToReturn));
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Traženi artikal nije pronađen u bazi!'));
    }
}
if (isset($_FILES['ImportItemsFile'])) {
    $CsvFile = $_FILES['ImportItemsFile']['name'];
    $ext = strtolower(end(explode('.', $CsvFile)));
    $tmpName = $_FILES['ImportItemsFile']['tmp_name'];
    if ($_FILES['ImportItemsFile']['error'] == 0) {
        if ($ext === 'csv' || $ext === 'xls' || $ext === 'xlsx') {
            require('xlsreader/php-excel-reader/excel_reader2.php');
            require('xlsreader/SpreadsheetReader.php');

            $Reader = new SpreadsheetReader($tmpName, $CsvFile);
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => 'Greska!!! Pogresan tip fajla!!!'));
            die();
        }
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Greska u fajlu!!!'));
        die();
    }

    $OdeljenjaInsert = [];
    $GetSvaOdeljenja = mysqli_query($link, "SELECT * FROM odeljenje WHERE magacin=0");
    if (mysqli_num_rows($GetSvaOdeljenja) > 0) {
        while ($rowOdeljenja = mysqli_fetch_array($GetSvaOdeljenja)) {
            $OdeljenjaInsert[$rowOdeljenja['id']] = $rowOdeljenja['id'];
        }
    }
    $Uspesno = 0;
    $Neuspesno = 0;
    foreach ($Reader as $Row) {
        $name = mysqli_real_escape_string($link, $Row[0]);
        $cena = mysqli_real_escape_string($link, $Row[1]);
        $PODGRUPA_ID = mysqli_real_escape_string($link, $Row[2]);
        $jedinicaMere = mysqli_real_escape_string($link, $Row[3]);
        $poreskaGrupa = mysqli_real_escape_string($link, $Row[4]);
        $dozvoljenPopust = mysqli_real_escape_string($link, $Row[5]);
        $barCode = mysqli_real_escape_string($link, $Row[6]);
        if ($dozvoljenPopust == "1") {
            $dozvoljenPopust = 1;
        } else {
            $dozvoljenPopust = 0;
        }
        if ($cena == "") {
            $cena = 0;
        }
        $cena = number_format($cena, 2, '.', '');
        if ($name != 'Naziv artikla' && $name != '') {
            $IsExist = mysqli_query($link, "SELECT * FROM artikal WHERE skrNaziv='$name' OR name='$name'");
            if (mysqli_num_rows($IsExist) == 0) {
                mysqli_query($link, "INSERT INTO artikal (name, skrNaziv, barCode, jedinicaMere, cena, poreskaGrupa, PODGRUPA_ID, dozvoljenPopust, mera, tip, blokiran) 
                        VALUES ('$name', '$name', '$barCode', '$jedinicaMere', '$cena', '$poreskaGrupa', '$PODGRUPA_ID', $dozvoljenPopust, '1', 'SLOZ', 0)") or die(mysqli_error($link));
                $CreateProductId = mysqli_insert_id($link);
                if (count($OdeljenjaInsert) > 0) {
                    foreach ($OdeljenjaInsert as $OdeljenjeId) {
                        mysqli_query($link, "INSERT INTO artikal_odeljenje (ARTIKLI_ID, ODELJENJA_ID) VALUES ('$CreateProductId', '$OdeljenjeId')") or die(mysqli_error($link));
                    }
                }
                $Uspesno++;
            } else {
                $Neuspesno++;
            }
        } else {
            $Neuspesno++;
        }
    }
    echo json_encode(array('Status' => 'success', 'Message' => "Uspešno uvezeno:" . $Uspesno . " artikala! Neuspešno: " . $Neuspesno . ""));
    die();
}
if (isset($_POST['GetAllHotelGuests'])) {
    $IsProtel = GetSettingVal('recepcija.protel');
	$IsSerbianBookers = GetSettingVal('recepcija.serbian.bookers');
    if ($IsProtel == 'true') {
        $ProtelAdresa = GetSettingVal('recepcija.protel_adresa');
        if ($ProtelAdresa != '') {
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $ProtelAdresa . '/FindReservationByName',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => '<Body>
            <Search></Search>
            </Body> ',
                CURLOPT_HTTPHEADER => array(
                    'Transaction: 66062',
                    'Content-Type: text/plain'
                ),
            ));
            $response = curl_exec($curl);
			$response = mb_convert_encoding($response, 'UTF-8', 'UTF-8');
            curl_close($curl);
            if ($response != '') {
                $Array = simplexml_load_string($response);
                $HtmlToReturn = "";
                $RoomIds = [];
                foreach ($Array as $RoomData) {
                    if ($RoomData->Blocked != '1') {
                        $Room = (string) $RoomData->Room;
                        $Guest = (string) $RoomData->ResNo;
                        $RoomIds[$Room] = $Guest;
                    }
                }
                if (count($RoomIds) > 0) {
                    foreach ($RoomIds as $RoomId => $RoomGuest) {
                        $HtmlToReturn .= "<div class='SelectHotelRoom' roomid='" . $RoomId . "' guestid='" . $RoomGuest . "'><span>" . $RoomId . "</span></div>";
                    }
                }

                if ($HtmlToReturn != '') {
                    echo json_encode(array('Status' => 'success', 'HtmlToInsert' => $HtmlToReturn));
                } else {
                    echo json_encode(array('Status' => 'error', 'Message' => "Nema otvorenih soba. Akcija nije moguća!"));
                }
            } else {
                echo json_encode(array('Status' => 'error', 'Message' => "Greška pri povlačenju spiska soba. Akcija nije moguća!"));
            }
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => "Adresa za povezivanje sa hotelom nije podešena. Akcija nije moguća!"));
        }
    } else if($IsSerbianBookers == 'true') {
		$bookersUserName = GetSettingVal('recepcija.bookers.username');
		$bookersPassword = GetSettingVal('recepcija.bookers.password');
		$bookersId = GetSettingVal('recepcija.bookers.kod');
		$apiHeader[] = 'Accept: application/json';
		$apiHeader[] = 'Content-Type: application/json';
		$loginData = [
			'username' => $bookersUserName,
			'password' => $bookersPassword,
			'remember' => '1',
		];
		$curl = curl_init();
		$options = array(
			CURLOPT_URL => "https://app.otasync.me/api/user/auth/login",
			CURLOPT_RETURNTRANSFER => true,
			CURLINFO_HEADER_OUT => true,
			CURLOPT_POST => true,
			CURLOPT_VERBOSE => true,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_SSL_VERIFYHOST => false, // true in production
			CURLOPT_SSL_VERIFYPEER => false, // true in production
			CURLOPT_HTTPHEADER => $apiHeader,
		);
		curl_setopt_array($curl, $options);
		curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($loginData));
		$response = curl_exec($curl);
		$response = mb_convert_encoding($response, 'UTF-8', 'UTF-8');
		curl_close($curl);
		if ($response != '') {
			$seqKey = "";
			$Result = json_decode($response);
			foreach ($Result as $key => $value) {
				if($key == "pkey") {
					$seqKey = $value;
				}
			}
			$occupiedRoomsData = [
				'key' => $seqKey,
				'id_properties' => $bookersId,  
			];
			$curl = curl_init();
			$options = array(
				CURLOPT_URL => "https://app.otasync.me/api/reservation/data/occupiedRooms",
				CURLOPT_RETURNTRANSFER => true,
				CURLINFO_HEADER_OUT => true,
				CURLOPT_POST => true,
				CURLOPT_VERBOSE => true,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_SSL_VERIFYHOST => false, // true in production
				CURLOPT_SSL_VERIFYPEER => false, // true in production
				CURLOPT_HTTPHEADER => $apiHeader,
			);
			curl_setopt_array($curl, $options);
			curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($occupiedRoomsData));
			$response = curl_exec($curl);
			$response = mb_convert_encoding($response, 'UTF-8', 'UTF-8');
			curl_close($curl);
			$occupiedRooms = array();
			$Result = json_decode($response);
			foreach ($Result as $key => $value) {
				if($key == "rooms") {
					foreach ($value as $room) {
						$oneRoom = [];
						foreach ($room as $keyRoom => $valueRoom) {
							if($keyRoom == "id_reservations") {
								$oneRoom['id_reservations'] = $valueRoom;
							}
							if($keyRoom == "id_guests") {
								$oneRoom['id_guests'] = $valueRoom;
							}
							if($keyRoom == "id_rooms") {
								$oneRoom['id_rooms'] = $valueRoom;
							}
							if($keyRoom == "room_name") {
								$oneRoom['room_name'] = $valueRoom;
							}
							if($keyRoom == "room_type_shortname") {
								$oneRoom['room_type_shortname'] = $valueRoom;
							}
						}
						$occupiedRooms[] = $oneRoom;
					}	
				}
			}
			$HtmlToReturn = "";
			if (count($occupiedRooms) > 0) {
				foreach ($occupiedRooms as $occupiedRoom) {
					$HtmlToReturn .= "<div class='SelectHotelRoom' roomid='" . $occupiedRoom['id_rooms'] . "' reservationid='" .$occupiedRoom['id_reservations']. "' guestid='" . $occupiedRoom['id_guests'] . "'><span>" . $occupiedRoom['room_name'] . "<br> (" . $occupiedRoom['room_type_shortname'] . ")"."</span></div>";
				}
			}
			if ($HtmlToReturn != '') {
				echo json_encode(array('Status' => 'success', 'HtmlToInsert' => $HtmlToReturn));
			} else {
				echo json_encode(array('Status' => 'error', 'Message' => "Nema otvorenih soba. Akcija nije moguća!"));
			}
		} else {
			echo json_encode(array('Status' => 'error', 'Message' => "Greška pri povlačenju spiska soba. Akcija nije moguća!"));
		}	
	} else {
        $serverName = GetSettingVal('recepcija.hostname');
        $uid = "sa";
        $pwd = "928374";
        $databaseName = 'recp';
        $UslugaRecepcija = GetSettingVal('recepcija.usluga');

        $connectionInfo = array(
            "UID" => $uid,
            "PWD" => $pwd,
            "Database" => $databaseName
        );

        /* Connect using SQL Server Authentication. */
        $conn = sqlsrv_connect($serverName, $connectionInfo);

        $tsql = "SELECT Room, guestid FROM v_oktodo WHERE ok_department=1 ORDER BY Room ASC";

        /* Execute the query. */

        $stmt = sqlsrv_query($conn, $tsql);

        if (!$stmt) {
            echo json_encode(array('Status' => 'error', 'Message' => "Neuspešna veza sa bazom. Akcija nije moguća!"));
			die();
        }
        /* Iterate through the result set printing a row of data upon each iteration. */
        $HtmlToReturn = "";
        $RoomIds = [];
        while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_NUMERIC)) {
            $RoomIds[$row[0]] = $row[1];
        }

        /* Free statement and connection resources. */
        sqlsrv_free_stmt($stmt);
        sqlsrv_close($conn);
        if (count($RoomIds) > 0) {
            foreach ($RoomIds as $RoomId => $RoomGuest) {
                $HtmlToReturn .= "<div class='SelectHotelRoom' roomid='" . $RoomId . "' guestid='" . $RoomGuest . "'><span>" . $RoomId . "</span></div>";
            }
        }

        if ($HtmlToReturn != '') {
            echo json_encode(array('Status' => 'success', 'HtmlToInsert' => $HtmlToReturn));
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => "Nema otvorenih soba. Akcija nije moguća!"));
        }
    }
    die();
}
if (isset($_POST['TransferTableToHotel']) && isset($_POST['TrasferTableToRoomGuest'])) {
    $Table = mysqli_real_escape_string($link, $_POST['TransferTableToHotel']);
    $Guest = mysqli_real_escape_string($link, $_POST['TrasferTableToRoomGuest']);
    $Room = mysqli_real_escape_string($link, $_POST['TrasferTableToRoom']);
    $TableItems = [];
    $RacunId = "";
	$ZdBroj = "";
    $GetRacunId = mysqli_query($link, "SELECT * FROM racun WHERE brojStola='$Table' AND zatvoren=0 ORDER BY id DESC LIMIT 1");
    if (mysqli_num_rows($GetRacunId) == 1) {
        $RacunData = mysqli_fetch_array($GetRacunId);
    }
    $RacunId = $RacunData['id'];
	$ZdBroj = $RacunData['zdBroj'];
    $GetTableItems = mysqli_query($link, "SELECT gostbroj, ARTIKAL_ID, GLAVNASTAVKA_ID, kolicina, cena, naziv, id, TURA_ID, opis FROM stavkaracuna WHERE brojStola='$Table' AND RACUN_ID='$RacunId' ORDER BY gostbroj ASC, TURA_ID ASC, id ASC");
    if (mysqli_num_rows($GetTableItems) > 0) {
        $GetTuraTime = 0;
        $TuraTime = "";
        while ($rowTableItems = mysqli_fetch_array($GetTableItems)) {
            $TableItems[$rowTableItems['gostbroj'] . '' . $rowTableItems['id']] = [
                'BrojGosta' => $rowTableItems['gostbroj'],
                'Naziv' => $rowTableItems['naziv'],
                'Kolicina' => $rowTableItems['kolicina'],
                'Cena' => number_format($rowTableItems['cena'], 2, '.', ''),
                'IdTure' => $rowTableItems['TURA_ID'],
                'Dodatni' => 0,
                'ArtikalId' => $rowTableItems['ARTIKAL_ID'],
                'StavkaId' => $rowTableItems['id'],
                'Vreme' => date('H:i', strtotime($TuraTime)),
                'Opis' => $rowTableItems['opis']
            ];
        }
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Prebacivanje stola na hotel Sto->" . $Table . " -> Korisnik: " . $UserName;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");
    } else {
        echo json_encode(array('Status' => 'error', 'Message' => 'Nema stavki za prebacivanje!'));
        die();
    }
    $IsProtel = GetSettingVal('recepcija.protel');
	$IsSerbianBookers = GetSettingVal('recepcija.serbian.bookers');
    if ($IsProtel == 'true') {
        $ProtelAdresa = GetSettingVal('recepcija.protel_adresa');
        if ($ProtelAdresa != '') {
            $ProductsData = [];
            $GetAllProductsData = mysqli_query($link, "SELECT * FROM artikal WHERE 1");
            if (mysqli_num_rows($GetAllProductsData) > 0) {
                while ($rowAllProductsData = mysqli_fetch_array($GetAllProductsData)) {
                    $ProductsData[$rowAllProductsData['id']] = $rowAllProductsData;
                }
            }
            $VatsData = [];
            $GetAllVatsData = mysqli_query($link, "SELECT * FROM poreske_stope WHERE 1");
            if (mysqli_num_rows($GetAllVatsData) > 0) {
                while ($rowAllVatsData = mysqli_fetch_array($GetAllVatsData)) {
                    $VatsData[$rowAllVatsData['id']] = $rowAllVatsData;
                }
            }
            $xml = "<?xml version=\"1.0\" encoding=\"windows-1250\"?>";
            $xml .= "<Body xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">";
            $xml .= "<Creation>" . date('YmdHis') . "</Creation>";
            $xml .= "<Outlet>" . $_COOKIE['ThisFrontId'] . "</Outlet>";
            $xml .= "<User>1</User>";
            $xml .= "<MPEHotel>1</MPEHotel>";
            $xml .= "<Invoice>" . $RacunData['brojRacuna'] . "</Invoice>";
            $TotalAmountAll = 0;
            foreach ($TableItems as $Artikli) {
                $xml .= "<Item>";
                $TotalAmount = $Artikli['Kolicina'] * $Artikli['Cena'];
                $Group = $ProductsData[$Artikli['ArtikalId']]['PODGRUPA_ID'];
                $ProductTax = $VatsData[$ProductsData[$Artikli['ArtikalId']]['poreskaGrupa']];

                $xml .= "<TotalAmount>" . $TotalAmount . "</TotalAmount>";
                $xml .= "<Type>Revenue</Type>";
                $xml .= "<Text>" . $Artikli['Naziv'] . "</Text>";
                $xml .= "<Productgroup>" . $Group . "</Productgroup>";
                if ($ProductTax['vrednost'] == 10) {
                    $xml .= "<TaxClassification>1</TaxClassification>";
                } else {
                    $xml .= "<TaxClassification>2</TaxClassification>";
                }
                $xml .= "<SingleAmount>" . $Artikli['Cena'] . "</SingleAmount>";
                $xml .= "<Quantity>" . $Artikli['Kolicina'] . "</Quantity>";
                $TotalAmountAll = $TotalAmountAll + $TotalAmount;
                $xml .= "</Item>";
            }
            $xml .= "<Item>";
            $xml .= "<TotalAmount>" . $TotalAmountAll . "</TotalAmount>";
            $xml .= "<Type>Payment</Type>";
            $xml .= "<ResNo>" . $Guest . "</ResNo>";
            $xml .= "</Item>";
            $xml .= "</Body>";
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $ProtelAdresa . '/CloseInvoice',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 5,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $xml,
                CURLOPT_HTTPHEADER => array(
                    'Transaction: ' . $RacunId . '',
                    'Content-Type: application/xml'
                ),
            ));
            $response = curl_exec($curl);
            if (curl_getinfo($curl, CURLINFO_HTTP_CODE) != 200) {
                //error_log('Ulazi u error');
                echo json_encode(array('Status' => 'error', 'Message' => "Greška pri slanju podataka u PROTEL. Akcija nije moguća!"));
            } else {
                //error_log('Ulazi u neerror');
				RekonstrukcijaRacun($RacunId, $ZdBroj);
                mysqli_query($link, "UPDATE racun SET zatvoren=1, crnoPlacanje='HOTEL' WHERE id='$RacunId'");
                echo json_encode(array('Status' => 'success', 'Message' => ""));
            }
            curl_close($curl);
        } else {
            echo json_encode(array('Status' => 'error', 'Message' => "Adresa za povezivanje sa hotelom nije podešena. Akcija nije moguća!"));
        }
    } else if($IsSerbianBookers == 'true') {
		$ReservationId = mysqli_real_escape_string($link, $_POST['TrasferTableRoomReservation']);
		$bookersUserName = GetSettingVal('recepcija.bookers.username');
		$bookersPassword = GetSettingVal('recepcija.bookers.password');
		$bookersId = GetSettingVal('recepcija.bookers.kod');
		$apiHeader[] = 'Accept: application/json';
		$apiHeader[] = 'Content-Type: application/json';
		$loginData = [
			'username' => $bookersUserName,
			'password' => $bookersPassword,
			'remember' => '1',
		];
		$curl = curl_init();
		$options = array(
			CURLOPT_URL => "https://app.otasync.me/api/user/auth/login",
			CURLOPT_RETURNTRANSFER => true,
			CURLINFO_HEADER_OUT => true,
			CURLOPT_POST => true,
			CURLOPT_VERBOSE => true,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_SSL_VERIFYHOST => false, // true in production
			CURLOPT_SSL_VERIFYPEER => false, // true in production
			CURLOPT_HTTPHEADER => $apiHeader,
		);
		curl_setopt_array($curl, $options);
		curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($loginData));
		$response = curl_exec($curl);
		$response = mb_convert_encoding($response, 'UTF-8', 'UTF-8');
		curl_close($curl);
		if ($response != '') {
			$seqKey = "";
			$Result = json_decode($response);
			foreach ($Result as $key => $value) {
				if($key == "pkey") {
					$seqKey = $value;
				}
			}
			$extras = "[";
			foreach ($TableItems as $Artikli) {
				$GetTax = mysqli_query($link, "SELECT p.vrednost from poreske_stope p left join artikal a on p.id=a.poreskaGrupa where a.id=${Artikli['ArtikalId']} LIMIT 1");
				if (mysqli_num_rows($GetTax) == 1) {
					$TaxData = mysqli_fetch_array($GetTax);
				}
				$tax = $TaxData['vrednost'];
				$name = $Artikli['Naziv'];
				$quantity = $Artikli['Kolicina'];
                $price_per_unit = $Artikli['Cena'];
                $total_price = $Artikli['Kolicina'] * $Artikli['Cena'];
				$extras .= "{\n  \"name\": \"$name\",\n  \"quantity\": \"$quantity\",\n  \"price_per_unit\": \"$price_per_unit\",\n  \"tax\": \"$tax\",\n  \"total_price\": \"$total_price\"\n},";
			}
			$extras = substr($extras,0 , -1);
			$extras .="]";
			$debitRoomsData = [
				'key' => $seqKey,
				'id_properties' => $bookersId,  
				'id_reservations' => $ReservationId,
				'extras' => $extras,
			];
			$curl = curl_init();
			$options = array(
				CURLOPT_URL => "https://app.otasync.me/api/reservation/insert/reservationExtra",
				CURLOPT_RETURNTRANSFER => true,
				CURLINFO_HEADER_OUT => true,
				CURLOPT_POST => true,
				CURLOPT_VERBOSE => true,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_SSL_VERIFYHOST => false, // true in production
				CURLOPT_SSL_VERIFYPEER => false, // true in production
				CURLOPT_HTTPHEADER => $apiHeader,
			);		
			curl_setopt_array($curl, $options);
			curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($debitRoomsData));
			$response = curl_exec($curl);
			$response = mb_convert_encoding($response, 'UTF-8', 'UTF-8');
			curl_close($curl);
			$occupiedRooms = array();
			$Result = json_decode($response);
			$statusUpisa = "";
			foreach ($Result as $key => $value) {
				if($key == "status") {
					$statusUpisa = $value;
				}
			}
			if($statusUpisa == "ok") {
				RekonstrukcijaRacun($RacunId, $ZdBroj);
				mysqli_query($link, "UPDATE racun SET zatvoren=1, crnoPlacanje='HOTEL' WHERE id='$RacunId'");
                echo json_encode(array('Status' => 'success', 'Message' => ""));
			} else {
				echo json_encode(array('Status' => 'error', 'Message' => "Greška pri slanju računa na sobu. Akcija nije $ReservationId moguća! "));
			}
		} else {
			echo json_encode(array('Status' => 'error', 'Message' => "Greška pri povezivanju na BOOKERS. Akcija nije moguća!"));
		}
	} else {
        $serverName = GetSettingVal('recepcija.hostname');
        $uid = "sa";
        $pwd = "928374";
        $databaseName = 'recp';
        $UslugaRecepcija = GetSettingVal('recepcija.usluga');

        $connectionInfo = array(
            "UID" => $uid,
            "PWD" => $pwd,
            "Database" => $databaseName
        );

        /* Connect using SQL Server Authentication. */
        $conn = sqlsrv_connect($serverName, $connectionInfo);
        $ddate = date('Y-m-d');
        $ttime = date('H:i:s');
        $billno = $RacunData['brojRacuna'];
        $guestid = $Guest;
        $servtype = 4;
        $status = "N";
        $department = $UslugaRecepcija;
        $waiterid = $_COOKIE['UserId'];
        $waiter = $_COOKIE['UserName'];
        $deptid = 1;
        $LastId = sqlsrv_query($conn, "SELECT TOP 1 id FROM todo ORDER BY id DESC");
        if ($LastId) {
            $idtodo = sqlsrv_fetch_array($LastId, SQLSRV_FETCH_NUMERIC)[0] + 1;
        }
        $tsql = "INSERT INTO todo (id, ddate, ttime, billno, guestid, servtype, status, department, waiterid, waiter, deptid) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        /* Execute the query. */

        $params = array(&$idtodo, &$ddate, &$ttime, &$billno, &$guestid, &$servtype, &$status, &$department, &$waiterid, &$waiter, &$deptid);
        $stmt = sqlsrv_prepare($conn, $tsql, $params);

        if (sqlsrv_execute($stmt) === false) {
            //error_log(json_encode(sqlsrv_errors()));
            echo json_encode(array('Status' => 'error', 'Message' => "Neuspešna veza sa bazom unos todo. Akcija nije moguća!"));
        } else {
            foreach ($TableItems as $Artikli) {
                $article = $Artikli['Naziv'];
                $qtty = $Artikli['Kolicina'];
                $price = $Artikli['Cena'];
                $TotalAmount = $Artikli['Kolicina'] * $Artikli['Cena'];
                $total = $TotalAmount;
                $articleid = $Artikli['ArtikalId'];
                $ttype = "";
                $LastIdDet = sqlsrv_query($conn, "SELECT TOP 1 id FROM tododet ORDER BY id DESC");
                $idtododet = 0;
                if ($LastIdDet) {
                    $idtododet = sqlsrv_fetch_array($LastIdDet, SQLSRV_FETCH_NUMERIC)[0] + 1;
                }
                if ($idtododet > 0) {
                    $tsqldet = "INSERT INTO tododet (id, idtodo, article, qtty, price, total, articleid, ttype) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                    $paramsdet = array(&$idtododet, &$idtodo, &$article, &$qtty, &$price, &$total, &$articleid, &$ttype);
                    $stmtdet = sqlsrv_prepare($conn, $tsqldet, $paramsdet);
                    if (sqlsrv_execute($stmtdet) === false) {
                        //error_log(json_encode(sqlsrv_errors()));
                        echo json_encode(array('Status' => 'error', 'Message' => "Neuspešna veza sa bazom unos tododet. Akcija nije moguća!"));
                        die();
                    }
                }
            }
			RekonstrukcijaRacun($RacunId, $ZdBroj);
            mysqli_query($link, "UPDATE racun SET zatvoren=1, crnoPlacanje='HOTEL' WHERE id='$RacunId'");
            echo json_encode(array('Status' => 'success', 'Message' => ""));
        }
        /* Free statement and connection resources. */
        sqlsrv_close($conn);
    }
    $StampacData = [];
    $GetStampacData = mysqli_query($link, "SELECT * FROM stampac WHERE stampaGotovinski=1");
    if (mysqli_num_rows($GetStampacData) > 0) {
        while ($rowStampacData = mysqli_fetch_array($GetStampacData)) {
            $StampacData[$rowStampacData['id']] = $rowStampacData;
        }
    }
    $GetProdajnoMesto = mysqli_query($link, "SELECT naziv FROM prodajnomesto ORDER BY id DESC LIMIT 1");
    if (mysqli_num_rows($GetProdajnoMesto) == 1) {
        $ProdajnoMesto = mysqli_fetch_array($GetProdajnoMesto)['naziv'];
    }
    foreach ($StampacData as $Stampac) {
        $StampacId = $Stampac['id'];
        $BrojKopija = 2;
        $NazivStampaca = $Stampac['naziv'];
        if ($Stampac['tip'] == 'POSBANK80MM') {
            $PrinterLetters = 40;
        } else {
            $PrinterLetters = 30;
        }
        for ($x = 0; $x < $BrojKopija; $x++) {
            $PreText = "";
            $PrintString = FormatText("H O T E L S K I   G O S T") . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";
            $PrintString .= FormatText($ProdajnoMesto) . "\n";
            $PrintString .= str_pad("=", $PrinterLetters, "=", STR_PAD_BOTH) . "\n";
            $PrintString .= FormatText("Broj Sobe") . "\n";
            $PrintString .= FormatText($Room) . "\n";
            $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
            $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";

            foreach ($TableItems as $Artikli) {
                $PreText = $Artikli['Kolicina'] . "X " . $Artikli['Naziv'];
                $PrintString .= $PreText . "\n";
            }
            $PreText = "";
            $PrintString .= FormatText("") . "\n";
            $PrintString .= str_pad(mb_substr($PreText, 0, $PrinterLetters, 'UTF-8'), $PrinterLetters, " ", STR_PAD_BOTH) . "\n";
            $PrintString .= FormatText("") . "\n";
            $PrintString .= str_pad("_", $PrinterLetters, "_", STR_PAD_BOTH) . "\n";
            $PrintString .= FormatText("Potpis kupca") . "\n";
            $PrintString .= "\n";
            $PrintString .= "\n";
            $PrintString .= FormatText("Datum: " . date('d.m.Y.') . date('H:i:s')) . "\n";
            $PrintString .= FormatText("Konobar: " . $_COOKIE['UserName']) . "\n";
            //error_log($PrintString);
            try {
                // Enter the share name for your USB printer here
                if (strpos($NazivStampaca, "/")) {
                    $connector = new WindowsPrintConnector("smb://" . $NazivStampaca);
                } else {
                    $connector = new WindowsPrintConnector($NazivStampaca);
                }
                $printer = new Printer($connector);
                $printer->pulse(1, 300, 300);
                $printer->setPrintLeftMargin(0);
                $printer->setJustification(Printer::JUSTIFY_LEFT);
                $printer->text($PrintString);
                $printer->feed();
                $printer->cut();
                $printer->close();
            } catch (Exception $e) {
                die();
            }
        }
    }
    die();
}
