<?php
if ($DirectStop != 'MasterSoftware') {
    header("Location: 404.php");
}
if ($WhatUserCanSee['KnjigaSanka'] != 1) {
    header("Location: 404.php");
    die();
}
?>
<!DOCTYPE html>
<html lang="en" class="no-js">
    <!-- BEGIN HEAD -->
    <head>
        <meta charset="utf-8" />
        <title>Stanje zaliha</title>
        <meta content="IE=edge" http-equiv="X-UA-Compatible">
        <meta content="width=device-width, initial-scale=1" name="viewport" />
        <meta content="" name="description" />
        <meta content="" name="author" />
        <link rel="stylesheet" type="text/css" href="//maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" />
        <?php include('Partials/HeaderScripts.php'); ?>
        <link rel="shortcut icon" href="<?php echo BASE_URL; ?>/favicon.ico" />
    </head>
    <!-- END HEAD -->
    <!-- BEGIN BODY -->
    <body class="page-header-fixed page-quick-sidebar-over-content page-sidebar-closed">
        <!-- BEGIN HEADER -->
        <?php include('Partials/PageHeader.php'); ?>
        <!-- END HEADER -->
        <div class="clearfix">
        </div>
        <!-- BEGIN CONTAINER -->
        <div class="page-container">
            <!-- BEGIN SIDEBAR -->
            <?php include('Partials/PageSideBar.php'); ?>
            <!-- END SIDEBAR -->
            <!-- BEGIN CONTENT -->
            <div class="page-content-wrapper">
                <div class="page-content">
                    <h3 class="page-title">
                        Stanje zaliha
                    </h3>
                    <div class="page-bar">
                        <div id="dashboard-report-range" class="tooltips btn btn-fit-height btn-stock-report margin-top-10" data-placement="top" data-original-title="Change dashboard date range">
                            <i class="icon-calendar"></i>&nbsp;
                            <span class="thin uppercase inline-block width-80"></span>&nbsp;
                            <i class="fa fa-angle-down"></i>
                        </div>
                        <?php
                        foreach (GetDepartments() as $department) {
                            ?>
                            <div class="tooltips btn btn-fit-height btn-stock-report margin-top-10" data-placement="top" data-original-title="Department">
                                <span class="text-align-left thin uppercase inline-block width-80"><?php Echo $department['naziv']; ?></span>&nbsp;
                                <input type="checkbox" name="department" value="<?php Echo $department['id']; ?>" <?php if($department['id']!='1'){ Echo "checked"; }?> />
                            </div>
                            <?php
                        }
                        ?>
                        <div class="tooltips btn btn-fit-height btn-stock-report margin-top-10" data-placement="top" data-original-title="Department">
                            <span class="text-align-left thin uppercase inline-block width-80">Osnovno</span>&nbsp;
                            <input type="checkbox" name="white" value="1" checked />
                        </div>
                        <div class="tooltips btn btn-fit-height btn-stock-report margin-top-10" data-placement="top" data-original-title="Department">
                            <span class="text-align-left thin uppercase inline-block width-80">Dodatno</span>&nbsp;
                            <input type="checkbox" name="black" value="1" checked />
                        </div>
                        <div class="tooltips btn btn-fit-height btn-stock-report margin-top-10" data-placement="top" data-original-title="Department">
                            <span class="text-align-left thin uppercase inline-block width-80">Bruto</span>&nbsp;
                            <input type="checkbox" name="bruto" value="1" checked/>
                        </div>
                        <div class="tooltips btn btn-fit-height btn-stock-report margin-top-10" data-placement="top" data-original-title="Department">
                            <span class="text-align-left thin uppercase inline-block width-80">Podgrupe</span>&nbsp;
                            <input type="checkbox" name="subGroupsSort" value="1"/>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN TABLE PORTLET-->
                            <?php
                            $gross = 'TRUE';
                            $white = 'TRUE';
                            $black = 'TRUE';
                            $departments = '2,3,4';
                            $doDatuma = date('Y-m-d');
                            $subGroupsSort = "FALSE";
                            include('Tables/TableCurrentState.php');
                            ?>
                            <!-- END TABLE PORTLET-->
                        </div>
                    </div>
                </div>
            </div>
            <!-- END CONTENT -->
        </div>
        <!-- END CONTAINER -->
        <!-- BEGIN FOOTER -->
        <div class="page-footer">
            <div class="page-footer-inner">
                <p id="date" class="date-left2"></p>
                &copy; Master Izveštaji
                <script>
                    var d = new Date();
                    var n = d.getFullYear();
                    document.getElementById("date").innerHTML = n;
                </script>
            </div>
            <div class="scroll-to-top">
                <i class="icon-arrow-up"></i>
            </div>
        </div>
        <!-- END FOOTER -->
<?php include('Partials/ReportsScripts.php'); ?>
        <script>
            $(document).ready(function () {
                $('input[type=checkbox]').on('click', function () {
                    $('.daterangepicker .applyBtn').click();
                });
            });
        </script>
    </body>
    <!-- END BODY -->
</html>