<div id="tableList" class="table-scrollable portlet-body">
    <?php
    ini_set('memory_limit', '1024M');
    ini_set('max_execution_time', 1800);
    $from = date('Y-m-d', strtotime($odDatuma));
    $to = date('Y-m-d', strtotime($doDatuma));


    if (isset($_GET['gross'])) {
        $gross = mysqli_real_escape_string($link, $_GET['gross']);
    }
    if (isset($_GET['white'])) {
        $white = mysqli_real_escape_string($link, $_GET['white']);
    } elseif ($white == "") {
        $white = "FALSE";
    }
    if (isset($_GET['black'])) {
        $black = mysqli_real_escape_string($link, $_GET['black']);
    } elseif ($black == "") {
        $black = "FALSE";
    }
    if (isset($_GET['subGroupsSort'])) {
        $subGroupsSort = mysqli_real_escape_string($link, $_GET['subGroupsSort']);
    } elseif ($subGroupsSort == "") {
        $subGroupsSort = "FALSE";
    }
    if (isset($_GET['departments'])) {
        $departments = mysqli_real_escape_string($link, $_GET['departments']);
    }
    $departments = str_replace(",", "-", $departments);
    $total = 0;
    if ($from == '1970-01-01') {
        $from = date('Y-m-d');
        $to = date('Y-m-d');
    }
    $maxDate = mysqli_query($link, "SELECT MAX(datum) FROM zd");
    $maxDate = mysqli_fetch_row($maxDate);
    $maxDate = $maxDate[0];
    $minDate = mysqli_query($link, "SELECT MIN(datum) FROM zd");
    $minDate = mysqli_fetch_row($minDate);
    $minDate = $minDate[0];
    
    if (strtotime($maxDate) <= strtotime($to)) {
        if ($minDate >= $from) {
            $from = date('Y-m-d', strtotime($minDate));
        }
        if($from>=$maxDate){
            $from = date('Y-m-d', strtotime($maxDate));
        }
        $to = date('Y-m-d', strtotime($maxDate));
        include('mojarekonstrukcija.php');
        rekonstrukcijaKarticaSaPrikazom($to, $to);
    } else {
        if (strtotime($minDate) >= strtotime($from)) {
            $from = date('Y-m-d', strtotime($minDate));
        }
    }
    if (strtoupper($gross) == 'TRUE') {
        if ($departments != '') {
            ?>
            <?php
            foreach (CurrentGrossState($from, $to, $departments, $black, $white, $subGroupsSort) AS $trenutno) {
                ?>
                <table class="tablesorter">
                    <thead>
                        <tr>
                            <th class="sorter-false tableReviewTh" colspan="5"  data-sorter="false"> <?php Echo $trenutno['kljuc']; ?></th>
                        </tr>
                        <tr>
                            <th> Artikal</th>
                            <th> Osnovno</th>
                            <th> Dodatno</th>
                            <th> Završno</th>
                            <th> Vrednost</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($trenutno['artikli'] as $item) {
                            ?>
                            <tr>
                                <td><?php Echo $item['artikal']; ?></td>
                                <td><?php Echo number_format($item['osnovno'], 4, '.', ''); ?></td>
                                <td><?php Echo number_format($item['dodatno'], 4, '.', ''); ?></td>
                                <td><?php Echo number_format($item['zavrsno'], 4, '.', ''); ?></td>
                                <td><?php Echo number_format($item['zavrsna_vrednost'], 2, '.', ''); ?></td>
                            </tr>
                            <?php
                            $total = $total + $item['zavrsna vrednost'];
                        }
                        ?>
                    </tbody>
                    <tbody class="tablesorter-infoOnly">
                        <tr>
                            <th colspan="4" class="Total">TOTAL</th>
                            <th data-math="above-sum">Iznos</th>
                        </tr>
                    </tbody>
                </table>
                <?php
            }
        }
        if ($departments != '' && (strtoupper($black) == 'TRUE' || strtoupper($white) == 'TRUE')) {
            ?>
            <table class="tablesorter table table-bordered tablesorter-bootstrap" id="AlwaysVisible">
                <tr>
                    <th colspan="4" class="Total">TOTAL</th>
                    <th><?php Echo number_format($total, 2, '.', ''); ?></th>
                </tr>
            </table>
            <?php
        } else {
            Echo "<h3>Nema rezultata </h3>";
        }
        ?>
        <style>
            thead tr:nth-child(1) .tablesorter-icon{
                display: none;
            }
            table tr td:nth-child(1){
                width: 40%;
            }
            table tr td{
                width: 15%;
            }
        </style>
        <?php
    } else {
        if ($departments != '') {
            foreach (CurrentState($from, $to, $departments, $black, $white, $subGroupsSort) AS $trenutno) {
                ?>
                <table class="tablesorter">
                    <thead>
                        <tr>
                            <th class="sorter-false tableReviewTh" colspan="7"  data-sorter="false"> <?php Echo $trenutno['kljuc']; ?></th>
                        </tr>
                        <tr>
                            <th> Artikal</th>
                            <th> JM</th>
                            <th> Početno</th>
                            <th> Ulaz</th>
                            <th> Izlaz</th>
                            <th> Završno</th>
                            <th> Vrednost</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($trenutno['artikli'] as $item) {
                            ?>
                            <tr>
                                <td><?php Echo $item['artikal']; ?></td>
                                <td><?php Echo $item['jm']; ?></td>
                                <td><?php Echo number_format($item['pocetno'], 4, '.', ''); ?></td>
                                <td><?php Echo number_format($item['ulaz'], 4, '.', ''); ?></td>
                                <td><?php Echo number_format($item['izlaz'], 4, '.', ''); ?></td>
                                <td><?php Echo number_format($item['zavrsno'], 4, '.', ''); ?></td>
                                <td><?php Echo number_format($item['zavrsna_vrednost'], 2, '.', ''); ?></td>
                            </tr>
                            <?php
                            $total = $total + $item['zavrsna vrednost'];
                        }
                        ?>
                    </tbody>
                    <tbody class="tablesorter-infoOnly">
                        <tr>
                            <th colspan="6" class="Total">TOTAL</th>
                            <th data-math="above-sum">Iznos</th>
                        </tr>
                    </tbody>
                </table>
                <?php
            }
        }
        ?>
        <?php
        if ($departments != '') {
            ?>
            <table class="tablesorter table table-bordered tablesorter-bootstrap" id="AlwaysVisible">
                <tr>
                    <th colspan="4" class="Total">TOTAL</th>
                    <th><?php Echo number_format($total, 2, '.', ''); ?></th>
                </tr>
            </table>
            <?php
        } else {
            Echo "<h3>Nema rezultata </h3>";
        }
        ?>

        <style>
            thead tr:nth-child(1) .tablesorter-icon{
                display: none;
            }
            table tr td:nth-child(1){
                width: 30%;
            }
            table tr td:nth-child(2){
                width: 10%;
            }
            table tr td{
                width: 12%;
            }
        </style>
    <?php } ?>
</div>
