       $(function () {

            $.tablesorter.themes.bootstrap = {
                table: 'table table-bordered',
                caption: 'caption',
                header: 'bootstrap-header', 
                footerRow: '',
                footerCells: '',
                icons: '', 
                sortNone: 'bootstrap-icon-unsorted',
                sortAsc: 'icon-chevron-up glyphicon glyphicon-chevron-up',
                sortDesc: 'icon-chevron-down glyphicon glyphicon-chevron-down',
                active: '',
                hover: '',
                filterRow: '',
                even: '',
                odd: '' 
            };

            $("table.tablesorter").tablesorter({

                theme: "bootstrap",

                widthFixed: true,

                headerTemplate: '{content} {icon}', 

                headers: {
                    0: { lockedOrder: 'asc' },
                    1: { lockedOrder: 'asc' },
                    2: { lockedOrder: 'asc' }
                },

                widgets: ["uitheme", "zebra", "math"],

                widgetOptions: {
                    math_data: 'math', 
                    math_ignore: [0, 1],
                    math_mask: '#,##0.00',
                    math_complete: function ($cell, wo, result, value, arry) {
                        var txt = '<span class="align-decimal">' + result + '</span>';
                        if ($cell.attr('data-math') === 'all-sum') {
                            // when the "all-sum" is processed, add a count to the end
                            return txt + ' (Sum of ' + arry.length + ' cells)';
                        }
                        return txt;
                    }
                }
            })

        });