<?php

function CheckAgainst($value) {
	global $link;
    $search = array("\\", "\x00", "\n", "\r", "'", '"', "\x1a");
    $replace = array("\\\\", "\\0", "\\n", "\\r", "\'", '\"', "\\Z");

    return str_replace($search, $replace, $value);
}

function IsTableOpened($table) {
	global $link;
    $query = mysqli_query($link, "SELECT SUM(kolicina*cena) as iznos FROM stavkaracuna where ISNULL(racun_id) AND brojStola='$table'");
    $row = mysqli_fetch_row($query);
    return $row[0];
}

function WhoIsWaiter($table) {
	global $link;
    $query = mysqli_query($link, "SELECT KONOBAR_ID FROM sto WHERE broj='$table'") or die(mysqli_error($link));
    $row = mysqli_fetch_row($query);
    return $row[0];
}

function GetStampacArtikla($IdArtikla) {
	global $link;
    $res = [];
    $query = mysqli_query($link, "SELECT STAMPAC_ID FROM artikal_stampac WHERE ARTIKLI_ID='$IdArtikla'") or die(mysqli_error($link));
    while ($row = mysqli_fetch_array($query)) {
        array_push($res, $row[0]);
    }
    return $res;
}

function GetKopijeStampaca($StampacId) {
	global $link;
    $query = mysqli_query($link, "SELECT brojKopijaPorudzbine FROM stampac WHERE id='$StampacId'") or die(mysqli_error($link));
    $row = mysqli_fetch_row($query);
    return $row[0];
}

function GetProdajnoMesto() {
	global $link;
    $query = mysqli_query($link, "SELECT naziv FROM prodajnomesto ORDER BY id DESC LIMIT 1") or die(mysqli_error($link));
    $row = mysqli_fetch_row($query);
    return $row[0];
}

function GetOdeljenjeKase($StampacId) {
	global $link;
    $query = mysqli_query($link, "SELECT naziv, bnaziv, id FROM stampac WHERE id='$StampacId' ORDER BY id DESC LIMIT 1") or die(mysqli_error($link));
    $row = mysqli_fetch_row($query);
    return $row;
}

function GetDodatno() {
	global $link;
    $rezultati = array();
    $query = mysqli_query($link, "SELECT * FROM crnoplacanje WHERE prikazWebOrder=1 ORDER BY id ASC") or die(mysqli_error($link));
    while ($row1 = mysqli_fetch_array($query)) {
        array_push($rezultati, $row1);
    }
    return $rezultati;
}

function IsMedjuzbir($Naplata) {
	global $link;
    $query = mysqli_query($link, "SELECT medjuZbir FROM crnoplacanje WHERE naziv='$Naplata' AND medjuZbir=1") or die(mysqli_error($link));
    $count = mysqli_num_rows($query);
    return $count;
}

function IsRekapitulacija($Naplata) {
	global $link;
    $query = mysqli_query($link, "SELECT rekapitulacijaPoreza FROM crnoplacanje WHERE naziv='$Naplata' AND rekapitulacijaPoreza=1") or die(mysqli_error($link));
    $count = mysqli_num_rows($query);
    return $count;
}

function GetStampacMedjuzbir($NacinPlacanja) {
	global $link;
    $query = mysqli_query($link, "SELECT STAMPAC_ID FROM crnoplacanje WHERE naziv='$NacinPlacanja'") or die(mysqli_error($link));
    $row = mysqli_fetch_row($query);
    return $row[0];
}

function IsTableLocked($StoPorudzbine) {
	global $link;
    $query = mysqli_query($link, "SELECT * FROM sto WHERE broj='$StoPorudzbine' AND blokiran=1") or die(mysqli_error($link));
    $count = mysqli_num_rows($query);
    return $count;
}

function GetHeaderFooterMedjuzbir($NacinPlacanja) {
	global $link;
    $query = mysqli_query($link, "SELECT footer1, footer2, footer3, header1 FROM crnoplacanje WHERE naziv='$NacinPlacanja'") or die(mysqli_error($link));
    $row = mysqli_fetch_row($query);
    return $row;
}

function FormatText($Word) {
	global $link;
    global $PrinterLetters;
    $WordLength = strlen($Word);
    if ($WordLength < $PrinterLetters) {
        $NewWord = str_pad($Word, $PrinterLetters, " ", STR_PAD_BOTH);
        return $NewWord;
    } else {
        return $Word;
    }
}

function FormatTextHalf($Word) {
	global $link;
    global $PrinterLetters;
    $NewPrinterLetters = $PrinterLetters / 2;
    $WordLength = strlen($Word);
    if ($WordLength < $NewPrinterLetters) {
        $NewWord = str_pad($Word, $NewPrinterLetters, " ", STR_PAD_BOTH);
        return $NewWord;
    } else {
        $Word = substr($Word, 0, number_format($NewPrinterLetters));
        return $Word;
    }
}

function FormatTextHalfLeft($Word) {
	global $link;
    global $PrinterLetters;
    $NewPrinterLetters = $PrinterLetters / 2;
    $WordLength = strlen($Word);
    if ($WordLength < $NewPrinterLetters) {
        $NewWord = str_pad($Word, $NewPrinterLetters, " ", STR_PAD_RIGHT);
        return $NewWord;
    } else {
        $Word = substr($Word, 0, number_format($NewPrinterLetters));
        return $Word;
    }
}

function FormatTextHalfRight($Word) {
	global $link;
    global $PrinterLetters;
    $NewPrinterLetters = $PrinterLetters / 2;
    $WordLength = strlen($Word);
    if ($WordLength < $NewPrinterLetters) {
        $NewWord = str_pad($Word, $NewPrinterLetters, " ", STR_PAD_LEFT);
        return $NewWord;
    } else {
        $Word = substr($Word, 0, number_format($NewPrinterLetters));
        return $Word;
    }
}

function FormatTextFourth($Word) {
	global $link;
    global $PrinterLetters;
    $NewPrinterLetters = $PrinterLetters / 4;
    $WordLength = strlen($Word);
    if ($WordLength < $NewPrinterLetters) {
        $NewWord = str_pad($Word, $NewPrinterLetters, " ", STR_PAD_BOTH);
        return $NewWord;
    } else {
        $Word = substr($Word, 0, number_format($NewPrinterLetters));
        return $Word;
    }
}

function IsHappyHour($time) {
	global $link;
    $dan = date('w', strtotime($time)) + 1;
    $sat = date('H', strtotime($time));
    $minut = date('i', strtotime($time));
    $query = mysqli_query($link, "SELECT id FROM setting WHERE name='happy.hour' AND actual='true'") or die(mysqli_error($link));
    if (mysqli_num_rows($query) != 0) {
        $queryPopust = mysqli_query($link, "SELECT id FROM popust WHERE IF(danOd<=danDo, (danOd<='$dan' AND danDo>='$dan'), (danOd<='$dan' OR danDo>='$dan')) AND IF(danOd='$dan', (satOd<='$sat' AND IF(satOd='$sat', (minOd<='$minut'), TRUE) ), TRUE) AND IF(danDo='$sat', (satDo>='$sat' AND IF(satDo='$sat', (minDo>='$minut'), TRUE)), TRUE)") or die(mysqli_error($link));
        if (mysqli_num_rows($queryPopust) >= 1) {
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}

function CanWaiterSeeGraphic($WaiterId, $GraphicId) {
	global $link;
    $query = mysqli_query($link, "SELECT * FROM grafik_konobar WHERE konobar_id='$WaiterId' AND grafik_id='$GraphicId'") or die(mysqli_error($link));
    if (mysqli_num_rows($query) != 0) {
        return true;
    } else {
        return false;
    }
}

function CanKasaSeeGraphic($KasaId, $GraphicId) {
	global $link;
    $query = mysqli_query($link, "SELECT * FROM kasa_grafici WHERE grafikID='$GraphicId' AND kasaID='$KasaId' ORDER BY id DESC Limit 1");
    if (mysqli_num_rows($query) != 0) {
        return true;
    } else {
        return false;
    }
}

function FindTableName($table) {
	global $link;
    $query = mysqli_query($link, "SELECT naziv FROM stonaziv WHERE broj='$table'") or die(mysqli_error($link));
    $row = mysqli_fetch_row($query);
    if ($row[0] == '') {
        return $table;
    } else {
        return $row[0];
    }
}

function GetSettingValue($Setting) {
	global $link;
    $query = mysqli_query($link, "SELECT actual FROM setting WHERE name='$Setting'") or die(mysqli_error($link));
    $row = mysqli_fetch_row($query);
    if ($row[0] == '') {
        return '';
    } else {
        return $row[0];
    }
}
