<?php

if ($DirectStop != "CuCaNaBuCaNa") {
    header("Location: ./logout.php");
    die();
}
require_once('stampa/config/tcpdf_config_alt.php');
require_once('stampa/tcpdf.php');
require_once('stampa/tcpdf_include.php');

class PDF extends TCPDF {

    function Footer() {
        $this->SetY(-10);
        $PageNo = $this->PageNo();
        $this->SetFont('dejavusans', '', 5);
        $DateTime = date('d.m.Y H:i:s');
        $FooterPrint = <<<EOD
                    <table border="0" cellpadding="0">
                    <tr>
                        <td style="width: 10%; text-align: left;">
                            <b>str. $PageNo</b>
                        </td>
                        <td style="width: 90%; text-align: right;">
                            <i>Dokument štampan $DateTime iz programa "Barmaster" autor 5.com.d.o.o. -www.petcom.rs- Software for Business and Pleasure</i>
                        </td>
                    </tr>
                    </table>
EOD;
        $this->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $FooterPrint, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
    }

    function Header() {
        $this->SetFont('dejavusansb', '', 8);
        global $SiteName;

        $ThisCompanyName = $SiteName;
        global $ThisCompanyPIB;
        global $ThisCompanyMB;
        global $ThisCompanyAddress;
        global $ThisCompanyZip;
        global $ThisCompanyCity;
        $ThisCompanyPhone = "";
        global $ThisCompanySifraDelatnosti;
        global $ThisCompanyRacun;
        global $ThisCompanyBanka;
        global $Updv;

        $ThisCompanyPhone2 = "";
        $PrintThisAddress = '';
        if ($ThisCompanyAddress != '') {
            $PrintThisAddress .= $ThisCompanyAddress;
        }
        if ($ThisCompanyZip != '') {
            $PrintThisAddress .= ', ' . $ThisCompanyZip;
        }
        if ($ThisCompanyCity != '') {
            $PrintThisAddress .= ', ' . $ThisCompanyCity;
        }
        $IncLines = 0;
        $this->Ln(5);
        $HeaderHtml = '<table border="0" cellpadding="0">';
        $HeaderHtml .= '<tr>
                    <td style="text-align: left; width: 50%; font-size: 7mm;">' . $ThisCompanyName . '</td>
                    <td style="text-align: right; width: 50%">';
        if ($ThisCompanyName != '') {
            $HeaderHtml .= '<b>' . $ThisCompanyName . '</b><br>';
        }
        $this->SetFont('dejavusans', '', 8);
        if ($ThisCompanyPIB != '') {
            $HeaderHtml .= '<b>PIB: </b>' . $ThisCompanyPIB . '<br>';
        }
        if ($ThisCompanyMB != '') {
            $HeaderHtml .= '<b>MB: </b>' . $ThisCompanyMB . '<br>';
        }
        if ($ThisCompanyMB != '') {
            $HeaderHtml .= $PrintThisAddress . '<br>';
        }
        if ($ThisCompanyPhone != '') {
            $HeaderHtml .= '<b>Telefon: </b>' . $ThisCompanyPhone . '<br>';
        }
        if ($ThisCompanyPhone2 != '') {
            $HeaderHtml .= $ThisCompanyPhone2 . '<br>';
        }

        if ($Updv == "true") {
            $HeaderHtml .= '<b>U sistemu PDV: </b> DA<br>';
        } else {
            $HeaderHtml .= '<b>U sistemu PDV: </b> NE<br>';
        }
        $HeaderHtml .= '<b>Šifra delatnosti: </b>' . $ThisCompanySifraDelatnosti . '<br>';
        $HeaderHtml .= '<b>' . $ThisCompanyBanka . ': </b>' . $ThisCompanyRacun . '<br>';
        $HeaderHtml .= '</td>
            </tr></table>';
        $HeaderHtml = <<<EOD
            $HeaderHtml
EOD;
        $this->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $HeaderHtml, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
    }

}
$UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
$LogDate = date('Y-m-d');
$LogTime = date('H:i:s');
$LogUser = $UserName;
$LogWhat = "Stampa popisne liste -> Korisnik: " . $UserName;
mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");

$OdeljenjaSent = mysqli_real_escape_string($link, $_GET['Odeljenja']);
$GetOdeljenja = mysqli_query($link, "SELECT * FROM kasa_odeljenje WHERE KASA_ID='$KasaId' AND ODELJENJA_ID IN ( $OdeljenjaSent )");
if (mysqli_num_rows($GetOdeljenja) > 0) {
    $OdeljenjaIn = "";
    while ($rowOdeljenja = mysqli_fetch_array($GetOdeljenja)) {
        if ($OdeljenjaIn == '') {
            $OdeljenjaIn = $rowOdeljenja['ODELJENJA_ID'];
        } else {
            $OdeljenjaIn .= ', ' . $rowOdeljenja['ODELJENJA_ID'];
        }
    }

    $GetArtikle = mysqli_query($link, "SELECT a.tip, a.name, ao.ODELJENJA_ID FROM artikal a, artikal_odeljenje ao WHERE ao.ARTIKLI_ID=a.id AND ao.ODELJENJA_ID IN ( $OdeljenjaIn ) ORDER BY ao.ODELJENJA_ID ASC, a.name ASC") or die(mysqli_error($link));
    if (mysqli_num_rows($GetArtikle) > 0) {
        $GetOdeljenjeNaziv = mysqli_query($link, "SELECT * FROM odeljenje");
        $OdeljenjeNaziv = [];
        if (mysqli_num_rows($GetOdeljenjeNaziv) > 0) {
            while ($rowOdeljenje = mysqli_fetch_array($GetOdeljenjeNaziv)) {
                $OdeljenjeNaziv[$rowOdeljenje['id']] = $rowOdeljenje['naziv'];
            }
        }
        $Updv = GetSettingVal('objekat.updv');
        $ThisCompanyPIB = GetSettingVal('objekat.pib');
        $ThisCompanyMB = GetSettingVal('objekat.maticni.broj');
        $ThisCompanyAddress = GetSettingVal('objekat.adresa');
        $ThisCompanyZip = GetSettingVal('objekat.maticni.broj');
        $ThisCompanyCity = GetSettingVal('objekat.mesto');
        $ThisCompanySifraDelatnosti = GetSettingVal('objekat.sifra.delatnosti');
        $ThisCompanyRacun = GetSettingVal('objekat.racun');
        $ThisCompanyBanka = GetSettingVal('objekat.banka');

        $pdf = new PDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $SheetName = "Popisna lista -" . date('Y-m-d');
        $pdf->SetFont('dejavusans', '', 10);
        $pdf->SetTitle($SheetName);

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Sparkom Software www.sparkom.net');
        $pdf->SetTitle($SheetName);
        $pdf->SetSubject($SheetName);
        $pdf->SetFont('dejavusans', '', 8);
        $pdf->SetMargins(8, 40, 8);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->startPageGroup();
        $pdf->AddPage();
        $pdf->Cell(0, 1, "", "T", 1, "C");


        $pdf->SetFont('dejavusansb', '', 14);
        $pdf->Cell(0, 10, "Popisna lista na dan: " . date('d.m.Y'), 0, 1, 'C');

        $pdf->SetFont('dejavusansb', '', 8);
        $pdf->Ln();
        $pdf->SetFillColor(200, 200, 200);
        $pdf->SetFont('dejavusans', '', 6);
        $Rb = 1;
        $ArtikliSadrzaj = '<table border="0" cellpadding="2">
                    <thead>
                    <tr style="font-size: 8px;">
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 4%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>R.B.</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: left; width: 70%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Naziv artikla</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 26%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Količina</b></td>
                    </tr>
                    </thead>';
        $OdeljenjeId = 0;
        while ($rowArtikle = mysqli_fetch_array($GetArtikle)) {
            if ($rowArtikle['tip'] == 'PROD' || $rowArtikle['tip'] == 'SIRO') {
                if ($OdeljenjeId != $rowArtikle['ODELJENJA_ID']) {
                    if ($OdeljenjeId != 0) {
                        $ArtikliSadrzaj .= '</table>';
                        $ArtikliSadrzaj = <<<EOD
            $ArtikliSadrzaj
EOD;
                        $pdf->SetFont('dejavusans', '', 7);
                        $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
                        $pdf->AddPage();
                        $ArtikliSadrzaj = '<table border="0" cellpadding="2">
                    <thead>
                    <tr style="font-size: 8px;">
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 4%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>R.B.</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: left; width: 70%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Naziv artikla</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 26%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Količina</b></td>
                    </tr>
                    </thead>';
                    }
                    $OdeljenjeId = $rowArtikle['ODELJENJA_ID'];
                    $ArtikliSadrzaj .= '<tr style="font-size: 8px;">
                        <td colspan="3" style="background-color:#DDDDDD;color:#111111;text-align: center; width: 100%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>' . $OdeljenjeNaziv[$OdeljenjeId] . '</b></td>
                    </tr>';

                    $Rb = 1;
                }
                $ArtikliSadrzaj .= '<tr>
                            <td style="text-align: center; width: 4%; border: 1px solid #333;">' . $Rb . '.</td>
                            <td style="text-align: left; width: 70%; border: 1px solid #333;"><b>' . $rowArtikle['name'] . '</b></td>
                            <td style="width: 26%; border: 1px solid #333;"></td>
                        </tr>';

                $Rb++;
            }
        }
        $ArtikliSadrzaj .= '</table>';
        $ArtikliSadrzaj = <<<EOD
            $ArtikliSadrzaj
EOD;
        $pdf->SetFont('dejavusans', '', 7);
        $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);



        $FileName = str_replace('.', '-', $SheetName);
        $FileName = str_replace('/', '-', $FileName);
        $FileName = str_replace(':', ' ', $FileName);
        $pdf->Output($FileName . '.pdf', I);
    } else {
        Echo "Greska pri kreiranju PDF Fajla Nema artikala...";
    }
} else {
    Echo "Greska pri kreiranju PDF Fajla nema podesenih odeljenja...";
}
