<?php
require_once('stampa/config/tcpdf_config_alt.php');
require_once('stampa/tcpdf.php');
require_once('stampa/tcpdf_include.php');
require_once('stampa/qrcode.php');
$DirectStop = "CuCaNaBuCaNa";
require_once('../include/config.php');
ob_end_clean();
$EntityId = 1;
$valuta = GetSettingVal("racun.valuta.placanja");
$brKopija = GetSettingVal("faktura.broj.kopija.fakture");
$JournalData = "";
$GetSaleData = mysqli_query($link, "SELECT * FROM racun_fiskal WHERE id=${_GET['id']}") or die(mysqli_error($link));
if (mysqli_num_rows($GetSaleData) > 0) {
    while ($rowSale = mysqli_fetch_array($GetSaleData)) {
        $JournalData = unserialize($rowSale['podaciRacuna']);
        $JournalData = json_decode(json_encode($JournalData), true);
	}
}

$pibKupca = $JournalData['EsirKupacPIB'];
$EntityDataRes['EntityPIN'] = $pibKupca;
$EntityDataRes['EntityName'] = "";
$EntityDataRes['EntityNumber'] = "";
$EntityAddress['EntityAddress'] = "";
$EntityAddress['EntityCity'] = "";
$EntityAddress['EntityPostCode'] = "";

$GetSaleData = mysqli_query($link, "SELECT * FROM stalnigost WHERE pib='".$pibKupca."'") or die(mysqli_error($link));
if (mysqli_num_rows($GetSaleData) > 0) {
    while ($rowSale = mysqli_fetch_array($GetSaleData)) {
        if($rowSale['valutaPlacanja']>0){
			$valuta = $rowSale['valutaPlacanja'];
		}
		$EntityDataRes['EntityName'] = $rowSale['naziv'];
		$EntityDataRes['EntityNumber'] = $rowSale['maticniBroj'];
		$EntityAddress['EntityAddress'] = $rowSale['adersa'];
		$EntityAddress['EntityCity'] = $rowSale['mesto'];
	}
}	

$VatTypes = [];
$AllVatTypes = mysqli_query($link, "SELECT * FROM poreske_stope WHERE 1");
if (mysqli_num_rows($AllVatTypes) > 0) {
	while ($rowAllVatTypes = mysqli_fetch_array($AllVatTypes)) {
		$VatTypes[$rowAllVatTypes['oznaka']] = $rowAllVatTypes['vrednost'];
	}
}
			
class PDF extends TCPDF {

	function Footer() {
		global $JournalData;
		// Go to 1.5 cm from bottom
		$this->SetY(-15);
		// Select Arial italic 8
		
		$this->SetFont('dejavusans', 'I', 8);
		// Print centered page number
		$PageNo = $this->PageNo();
		// $this->Cell(50, 8, 'str. ' . $PageNo, 0, 0, 'L');
		$this->Cell(153, 8, 'Štampano iz BMaster software | www.petcom.rs | Generisan: ' . date("d.m.Y H:i:s") . ' | Štampao: ' . $JournalData['EsirKorisnik'], 0, 0, 'R'); // $_COOKIE['UserName']
	}

	function Header() {
		$Title = GetSettingVal("objekat.naziv") . " | PIB: " . GetSettingVal("objekat.pib") . " | MB:" . GetSettingVal("objekat.maticni.broj") . " | TR: " . GetSettingVal('objekat.racun');
		// Select Arial bold 15
		$this->SetFont('dejavusans', 'B', 8);
		// Move to the right
		// Framed title
		// Line break
		$this->Ln(5);
		$HeaderHtml = '<table border="0" cellpadding="0">';
		$HeaderHtml .= '<tr>
	
	<td style="text-align: left; width: 75%">';
		$HeaderHtml .= '<b>' . $Title . '</b><br><br>Adresa sedišta: ' . GetSettingVal('objekat.adresa') . ', ' . GetSettingVal('objekat.mesto');
		$HeaderHtml .= '</td>
	<td style="text-align: right; width: 25%"><img src="../assets/images/printlogo.jpg" alt="Logo Img" height="50" border="0" /></td>
</tr></table>';
// Line break
		$HeaderHtml = <<<EOD
		$HeaderHtml
EOD;
		$this->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $HeaderHtml, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
	}
}
$pdf = new PDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$qrurl = $JournalData['verificationUrl'];
$options = ['s' => 'qr-l'];
$generator = new QRCodeGen($qrurl, $options);
for($i=1; $i<=$brKopija; $i++) {

	//$pdf->setNoPage(1);
		$SheetName = $JournalData['totalCounter'];
		$pdf->SetFont('dejavusans', '', 10);
		$pdf->SetTitle(clean($SheetName));
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor('Sparkom Software www.sparkom.net');
		$pdf->SetTitle($SheetName);
		$pdf->SetSubject($SheetName);
		$pdf->SetFont('dejavusans', '', 8);
		$pdf->SetMargins(8, 22, 8);
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
		$pdf->startPageGroup();
		$pdf->AddPage();
		$pdf->Cell(0, 1, "", "T", 1, "C");
		//$JournalData = unserialize($DocumentData['JournalData']);
		//$JournalData = json_decode(json_encode($JournalData), true);

		
		//QRCode::png($qrurl, null, QR_ECLEVEL_L, 1, 0);
		$image = $generator->render_image();
		ob_start();
		imagepng($image);
		$imageString = ob_get_contents();
		ob_end_clean();
		imagedestroy($image);
		if ($JournalData['InvoiceType'] != 'Normal') {
			$PrintName = "OVO NIJE FISKALNI RAČUN";
			$PrintNameEnd = "OVO NIJE FISKALNI RAČUN";
		} else {
			$PrintName = "FISKALNI RAČUN";
			$PrintNameEnd = "KRAJ FISKALNOG RAČUNA";
		}
		
		$TipRacunaStampa = "";
		$VrstaRacunaStampa = "";
		$PorezUkupno = 0;

		if ($JournalData['TransactionType'] == 'Sale') {
			$TipRacunaStampa = "PRODAJA";
		} else {
			$TipRacunaStampa = "REFUNDACIJA";
		}
		if ($JournalData['InvoiceType'] == 'Normal') {
			$VrstaRacunaStampa = "PROMET";
		} else if ($JournalData['JournalKind'] == 'Training') {
			$VrstaRacunaStampa = "OBUKA";
		} else if ($JournalData['JournalKind'] == 'Copy') {
			$VrstaRacunaStampa = "KOPIJA";
		} else if ($JournalData['JournalKind'] == 'Proforma') {
			$VrstaRacunaStampa = "PREDRAČUN";
		} else if ($JournalData['JournalKind'] == 'Advance') {
			$VrstaRacunaStampa = "AVANS";
		}
	   
		$TaxPrint = '<table border="0" cellpadding="4">
					<thead>
					<tr>
					<td colspan="5"><b>Poreske stope</b></td>
					</tr>
					<tr>
						<td style="width: 25%; border: 1px solid #333; background-color: #ccc;"><b>Oznaka</b></td>
						<td style="text-align: right; width: 25%; border: 1px solid #333; background-color: #ccc;"><b>Naziv</b></td>
						<td style="text-align: right; width: 25%; border: 1px solid #333; background-color: #ccc;"><b>Stopa</b></td>
						<td style="text-align: right; width: 25%; border: 1px solid #333; background-color: #ccc;"><b>Porez</b></td>
					</tr>
					</thead>';
		
		foreach ($JournalData['taxItems'] as $TaxData) {
			if ($TaxData['categoryType'] == 0) {
				$TaxData['rate'] = number_format($TaxData['rate'], 2, '.', '') . "%";
			} else {
				$TaxData['rate'] = number_format($TaxData['rate'], 2, '.', '');
			}
			$PorezUkupno = $PorezUkupno + number_format($TaxData['amount'], 2, '.', '');
			$TaxPrint .= '<tr>
						<td style="width: 25%; border: 1px solid #333;"><i>' . $TaxData['label'] . '</i></td>
						<td style="text-align: right; width: 25%; border: 1px solid #333;">' . $TaxData['categoryName'] . '</td>
						<td style="text-align: right; width: 25%; border: 1px solid #333;">' . $TaxData['rate'] . '</td>
						<td style="text-align: right; width: 25%; border: 1px solid #333;">' . number_format($TaxData['amount'], 2, ',', '.') . '</td>
					</tr>';
		}
		$TaxPrint .= '</table>';
		$EntityVat = "";
		if ($JournalData['EsirKupacPIB'] != '') {
			$EntityVat = $JournalData['EsirKupacPIBTip'] . ":" . $JournalData['EsirKupacPIB'];
		}
		if ($JournalData['EsirKupacOP']) {
			$Entity = $JournalData['EsirKupacOPTip'] . ":" . $JournalData['EsirKupacOP'];
		}
		$PrintEntity = "";
		if($EntityVat!=""){
			$PrintEntity = 'ID Kupca: '.$EntityVat.'<br>';
			if ($EntityId != 0 && $EntityAddress['EntityAddress']!='') {
				$PrintEntity .= $EntityDataRes['EntityName'].'<br>';
				$PrintEntity .= 'PIB: ' . $EntityDataRes['EntityPIN'] . ', <br>MB: ' . $EntityDataRes['EntityNumber'].'<br>';
				$PrintEntity .= $EntityAddress['EntityAddress'] . ', ' . $EntityAddress['EntityPostCode'] . ', ' . $EntityAddress['EntityCity'];
			}
		}
		if($JournalData['EsirKupacOP']!=''){
			$PrintEntity .= '<br>Opciono polje kupca: '.$Entity;
		}
		$FiscalUserData = $JournalData['EsirKorisnik'];

		$Payments = "";
		foreach ($JournalData['StavkePlacanja'] as $StavkaPlacanja) {
			if ($StavkaPlacanja['paymentType'] == 'Cash') {
				$PaymentPrint = "Gotovina";
			} elseif ($StavkaPlacanja['paymentType'] == 'Card') {
				$PaymentPrint = "Platna kartica";
			} elseif ($StavkaPlacanja['paymentType'] == 'Check') {
				$PaymentPrint = "Ček";
			} elseif ($StavkaPlacanja['paymentType'] == 'WireTransfer') {
				$PaymentPrint = "Prenos na račun";
			} elseif ($StavkaPlacanja['paymentType'] == 'MobileMoney') {
				$PaymentPrint = "Mobilni novac";
			} elseif ($StavkaPlacanja['paymentType'] == 'Voucher') {
				$PaymentPrint = "Vaučer";
			} elseif ($StavkaPlacanja['paymentType'] == 'Other') {
				$PaymentPrint = "Dr. bezgotovinsko plaćanje";
			}
			if ($Payments == '') {
				$Payments = $PaymentPrint;
			} else {
				$Payments .= ', ' . $PaymentPrint;
			}
		}
		if($PrintEntity!=''){
			$ZaglavljeHtml = '<table border="0" cellpadding="8">
				<tr>
					<td style="width: 45%;"><b>Dobavljač:</b></td>
					<td style="width: 10%;"></td>
					<td style="width: 45%;"><b>Kupac:</b></td>
				</tr>
				<tr>
                        <td style="width: 45%; border: 1px solid #333;"><b>PIB:</b> ' . $JournalData['tin'] . '
                            <br><b>Preduzeće:</b> ' . $JournalData['businessName'] . '
                                <br><b>Mesto prodaje:</b> ' . $JournalData['locationName'] . '
                            <br><b>Adresa:</b> ' . $JournalData['address'] . '
                            <br><b>Opština:</b> ' . $JournalData['district'] . '
                            <br><b>Esir Broj:</b> 359/1.0
                            <br><b>Kasir:</b> ' . $FiscalUserData . '</td>
                        <td style="width: 10%;"></td>
                        <td style="width: 45%; border: 1px solid #333;"><b>'.$PrintEntity.'</b></td>
                    </tr>
			</table>';
		}else{
			$ZaglavljeHtml = '<table border="0" cellpadding="8">
				<tr>
					<td style="width: 45%;"><b>Dobavljač:</b></td>
					<td style="width: 10%;"></td>
					<td style="width: 45%;"><b></b></td>
				</tr>
				<tr>
					<td style="width: 45%; border: 1px solid #333;"><b>PIB:</b> ' . $JournalData['tin'] . '
						<br><b>Preduzeće:</b> ' . $JournalData['businessName'] . '
							<br><b>Mesto prodaje:</b> ' . $JournalData['locationName'] . '
						<br><b>Adresa:</b> ' . $JournalData['address'] . '
						<br><b>Opština:</b> ' . $JournalData['district'] . '
						<br><b>Esir Broj:</b> 359/1.0
						<br><b>Kasir:</b> ' . $FiscalUserData . '</td>
					<td style="width: 10%;"></td>
					<td style="width: 45%;"><b></b></td>
				</tr>
			</table>';
		}
		
		$ZaglavljeHtml = <<<EOD
	$ZaglavljeHtml
EOD;
		$pdf->SetFont('dejavusans', 'B', 8);
		$pdf->Cell(0, 10, str_pad($PrintName, 86, "=", STR_PAD_BOTH), 0, 1, 'C');
		$pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ZaglavljeHtml, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
		$pdf->SetFont('dejavusans', 'B', 10);
		$pdf->Cell(0, 10, $VrstaRacunaStampa . ' ' . $TipRacunaStampa, 0, 0, 'C');
		$pdf->Ln(5);
		$pdf->SetFont('dejavusans', 'B', 9);
		$pdf->Cell(0, 10, $JournalData['invoiceNumber'], 0, 0, 'C');
		
		$pdf->Ln(10);
		$pdf->SetFillColor(200, 200, 200);
		if ($JournalData['InvoiceType'] != 'Normal') {
			$pdf->SetFont('dejavusans', 'B', 16);
			$pdf->Cell(0, 10, $PrintName, 1, 1, 'C');
		}
		$pdf->SetFont('dejavusans', '', 8);
		
		if($JournalData['ReferentNumber']!=''){
			$pdf->Cell(97, 10, 'Ref. broj: ' . $JournalData['ReferentNumber'], 1, 0, 'C');
			$pdf->Cell(97, 10, 'Ref. vreme: '.date('d.m.Y H:i:s', strtotime($JournalData['EsirReferentnoVremeDokumenta'])), 1, 1, 'C');
		}
		$rbr = 1;
		$ArtikliSadrzaj = '<table border="0" cellpadding="4">
					<thead>
					<tr>
					<td colspan="5"><b>Artikli</b></td>
					</tr>
					<tr>
						<td style="text-align: right; width: 5%; border: 1px solid #333; background-color: #ccc;"><b>RBR</b></td>
						<td style="text-align: left; width: 45%; border: 1px solid #333; background-color: #ccc;"><b>Naziv</b></td>
						<td style="text-align: right; width: 8%; border: 1px solid #333; background-color: #ccc;"><b>Cena</b></td>
						<td style="text-align: right; width: 8%; border: 1px solid #333; background-color: #ccc;"><b>Količina</b></td>
						<td style="text-align: right; width: 6%; border: 1px solid #333; background-color: #ccc;"><b>PDV %</b></td>
						<td style="text-align: right; width: 10%; border: 1px solid #333; background-color: #ccc;"><b>Osnovica</b></td>
						<td style="text-align: right; width: 8%; border: 1px solid #333; background-color: #ccc;"><b>PDV</b></td>
						<td style="text-align: right; width: 10%; border: 1px solid #333; background-color: #ccc;"><b>Međuzbir</b></td>
					</tr>
					</thead>';
		foreach ($JournalData['StavkeProizvoda'] as $StavkaRacuna) {
			$ArticleName = $StavkaRacuna['name'];
			$ArticleName .= "/".$StavkaRacuna['unitName'];
			$ArticleName .= " (";
			$PorezZaArtikal = "";
			foreach ($StavkaRacuna['labels'] as $TaxMark) {
				$ArticleName .= $TaxMark;
				$PorezZaArtikal = $TaxMark;
			}
			$ArticleName .= ")";
			if ($JournalData['TransactionType'] != 'Sale') {
				$StavkaRacuna['totalAmount'] = "-" . $StavkaRacuna['totalAmount'];
			}

			$Kolicina = $StavkaRacuna['quantity'];
			if ($Kolicina < 0) {
				$Kolicina = -1 * $Kolicina;
			}
			$Osnovica = number_format($StavkaRacuna['totalAmount'], 2, '.', '') / (1+($VatTypes[$PorezZaArtikal]/100));
			$pdvZaArtikal = number_format($StavkaRacuna['totalAmount'], 2, '.', '') - $Osnovica;
			$ArtikliSadrzaj .= '<tr>
							<td style="text-align: right; width: 5%; border: 1px solid #333;">' . $rbr . '</td>
							<td style="text-align: left; width: 45%; border: 1px solid #333;"><i>' . $ArticleName . '</i></td>
							<td style="text-align: right; width: 8%; border: 1px solid #333;">' . number_format($StavkaRacuna['unitPrice'], 2, ',', '.') . '</td>
							<td style="text-align: right; width: 8%; border: 1px solid #333;">' . number_format($Kolicina, 3, ',', '.') . '</td>
							<td style="text-align: right; width: 6%; border: 1px solid #333;">' . $VatTypes[$PorezZaArtikal] . '</td>
							<td style="text-align: right; width: 10%; border: 1px solid #333;">' . number_format($Osnovica, 2, ',', '.') . '</td>
							<td style="text-align: right; width: 8%; border: 1px solid #333;">' . number_format($pdvZaArtikal, 2, ',', '.') . '</td>
							<td style="text-align: right; width: 10%; border: 1px solid #333;">' . number_format($StavkaRacuna['totalAmount'], 2, ',', '.') . '</td>
						</tr>';
			$rbr++;
		}
		
		$ArtikliSadrzaj .= '<tr>
						<td style="text-align: right; border: 1px solid #333; background-color: #ccc;" colspan="7"><b>UKUPNO:</b></td>
						<td style="text-align: right; border: 1px solid #333; background-color: #ccc;" ><b>'.number_format($JournalData['totalAmount'], 2, ',', '.').'</b></td>
					</tr>';
		$ArtikliSadrzaj .= '</table>';
		$ArtikliSadrzaj = <<<EOD
	$ArtikliSadrzaj
EOD;
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->Cell(0, 5, "", 0, 1, "C");
		$pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);

		$TaxPrint = <<<EOD
	$TaxPrint
EOD;
		$pdf->Cell(0, 5, "", 0, 1, "C");
		$pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $TaxPrint, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
		$PaymentDetails = '<table border="0" cellpadding="2">
					<tr>
						<td style="text-align: left;width: 30%;"><b>Za uplatu:</b></td>
						<td style="text-align: left;width: 30%;">' . number_format($JournalData['totalAmount'], 2, ',', '.') . '</td>
						<td style="text-align: right; width: 40%;" rowspan="6">
							<img src="@' . base64_encode($imageString) . '" style="width:45mm; height:45mm;" height="45mm" width="45mm" border="0" />
						</td>
					</tr>
					<tr>
						<td style="text-align: left;width: 30%;"><b>Porez ukupno:</b></td>
						<td style="text-align: left;width: 30%;">' . number_format($PorezUkupno, 2, ',', '.') . '</td>
					</tr>
					<tr>
						<td style="text-align: left;width: 30%;"><b>Valuta plaćanja:</b></td>
						<td style="text-align: left;width: 30%;">' . $valuta . '</td>
					</tr>
					<tr>
						<td style="text-align: left;width: 30%;"><b>Način plaćanja:</b></td>
						<td style="text-align: left;width: 30%;">' . $Payments . '</td>
					</tr>
					<tr>
						<td style="text-align: left;width: 30%;"><b>PFR vreme: </b></td>
						<td style="text-align: left;width: 30%;">' . date('d.m.Y H:i:s', strtotime($JournalData['sdcDateTime'])) . '</td>
					</tr>
					<tr>
						<td style="text-align: left;width: 30%;"><b>PFR br. računa:</b></td>
						<td style="text-align: left;width: 30%;">' . $JournalData['invoiceNumber'] . '</td>
					</tr>
					<tr>
						<td style="text-align: left;width: 30%;"><b>Brojač računa:</b></td>
						<td style="text-align: left;width: 30%;">' . $JournalData['invoiceCounter'] . '</td>
					</tr>
				</table>';
		$PaymentDetails = <<<EOD
	$PaymentDetails
EOD;
		$pdf->Ln(5);
		$pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $PaymentDetails, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
		if($JournalData['JournalKind']=='Copy' && $JournalData['TransactionType']!='Sale'){
			$pdf->Cell(100, 10, "", "B", 1, "C");
			$pdf->Cell(100, 10, "Potpis kupca", 0, 0, "C");
			$pdf->Ln(5);
		}
		$pdf->SetFont('dejavusans', 'B', 8);
		$pdf->Cell(0, 10, str_pad($PrintNameEnd, 86, "=", STR_PAD_BOTH), 0, 1, 'C');
		if ($JournalData['Note'] != '') {
			$pdf->MultiCell(0, 5, 'Napomena: ' . $JournalData['Note'], 0, 'L', true);
			$pdf->Ln();
		}
		$pdf->Cell(50, 7, "", 'B', 0, 'C');
		$pdf->Cell(20, 7, "", 0, 0, 'C');
		$pdf->Cell(50, 7, "", 'B', 0, 'C');
		$pdf->Cell(20, 7, "", 0, 0, 'C');
		$pdf->Cell(50, 7, "", 'B', 1, 'C');

		$pdf->Cell(50, 7, "Racun izradio: ".$FiscalUserData, 0, 0, 'C');
		$pdf->Cell(20, 7, "", 0, 0, 'C');
		$pdf->Cell(50, 7, "Robu izdao", 0, 0, 'C');
		$pdf->Cell(20, 7, "", 0, 0, 'C');
		$pdf->Cell(50, 7, "Racun i robu primio", 0, 1, 'C');
		$pdf->SetFont('dejavusans', 'B', 8);
		$FileName = str_replace('.', '-', $SheetName);
		$FileName = str_replace('/', '-', $FileName);
		$FileName = str_replace(':', ' ', $FileName);      
}	
$pdf->Output($FileName . '.pdf', I);
?>