function RecalcGrafik(GrafikId) {
    $('.SelectGrafik').removeClass('SelectedGrafik');
    $('.SelectGrafik[grafikid="' + GrafikId + '"]').addClass('SelectedGrafik');
    $('.ShowGrafik').hide();
    $('.ShowGrafik[grafikid="' + GrafikId + '"]').show();
    $('.SelectGrafik').hide();
    if ($('.SelectGrafik').length <= 7) {
        $('.SelectGrafikBack').hide();
        $('.SelectGrafikForward').hide();
        $('.SelectGrafik').show();
    } else {
        $('.SelectGrafikBack').show();
        $('.SelectGrafikForward').show();
        $('.SelectGrafik').slice(0, 5).show();
    }
    setTimeout(function () {
        var WindowHeight = $('body').height();
        var HeaderHeight = $('.GraficiTop').height();
        var FooterHeight = $('.GraficiBottom').height();
        var GrafikWidth = $('body').width();
        var GrafikHeight = parseFloat(WindowHeight) - parseFloat(HeaderHeight) - parseFloat(FooterHeight);
        $('.ShowGrafik[grafikid="' + GrafikId + '"]').height(GrafikHeight);
        if ($('#GrafikImg' + GrafikId).length) {
            $('#GrafikImg' + GrafikId).removeAttr('style');
            var ImgWidth = $('#GrafikImg' + GrafikId).width();
            var ImgHeight = $('#GrafikImg' + GrafikId).height();
        } else {
            var ImgWidth = GrafikWidth;
            var ImgHeight = GrafikHeight;
        }
        var AspectRatioHeight = parseFloat(GrafikHeight) / parseFloat(ImgHeight);
        var AspectRatioWidth = parseFloat(GrafikWidth) / parseFloat(ImgWidth);
        var PossibleImgHeight = parseFloat(ImgHeight) * parseFloat(AspectRatioHeight);
        var PossibleImgWidth = parseFloat(ImgWidth) * parseFloat(AspectRatioWidth);
        var AspectRatio = 1;
        if (parseInt(PossibleImgWidth) <= parseInt(GrafikWidth)) {
            PossibleImgHeight2 = parseFloat(ImgHeight) * parseFloat(AspectRatioWidth);
            if (parseInt(PossibleImgHeight2) <= parseInt(GrafikHeight)) {
                AspectRatio = AspectRatioWidth;
            }
        }
        if (parseInt(PossibleImgHeight) <= parseInt(GrafikHeight) && AspectRatio == 1) {
            PossibleImgWidth = parseFloat(ImgWidth) * parseFloat(AspectRatioHeight);
            if (parseInt(PossibleImgWidth) <= parseInt(GrafikWidth)) {
                AspectRatio = AspectRatioHeight;
            }
        }
        $('.Sto').each(function () {
            var StoH = $(this).attr('stovisina') * AspectRatio;
            var StoW = $(this).attr('stosirina') * AspectRatio;
            var StoX = $(this).attr('stox') * AspectRatio;
            var StoY = $(this).attr('stoy') * AspectRatio;
            var StoKrug = $(this).attr('stokrug');
            var Style = "width: " + StoW + "px; height:" + StoH + "px; left:" + StoX + "px; top:" + StoY + "px;";
            if (StoKrug == 1) {
                Style += "border-radius: 50%;";
            }
            $(this).attr('style', Style);
        });
        if ($('#GrafikImg' + GrafikId).length) {
            var NewImgWidth = parseFloat(ImgWidth) * parseFloat(AspectRatio);
            $('#GrafikImg' + GrafikId).attr('style', 'width: ' + parseInt(NewImgWidth) + 'px;');
        }
        GetAllTables();
    }, 50);
}
function GetAllTables() {
    if ($('.FrontScreen').is(":visible")) {
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: 'GetAllTables=true',
            error: function () {
                //CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    //console.log(objData.Tables);
                    $('.Sto').each(function () {
                        $(this).removeClass('Zauzet');
                        $(this).removeClass('Tudji');
                        $(this).removeClass('Zakljucan');
                        $(this).removeAttr('nacinnaplate');
                        $(this).children('.StoVrednost').html('');
                    });
                    if (objData.Tables != '') {
                        $.each(objData.Tables, function (i, values) {
                            if (parseFloat(values.Suma) >= 0) {
                                if (values.Konobar == window.UserId) {
                                    $('.Sto[stoid="' + i + '"]').addClass('Zauzet');
                                    $('.Sto[stoid="' + i + '"] .StoVrednost').html(parseFloat(values.Suma).toFixed(0));
                                } else {
                                    $('.Sto[stoid="' + i + '"]').addClass('Tudji');
                                    $('.Sto[stoid="' + i + '"] .StoVrednost').html(values.KonobarIme);
                                }
                                if (values.Medjuzbir != '') {
                                    $('.Sto[stoid="' + i + '"]').addClass('Zakljucan');
                                    $('.Sto[stoid="' + i + '"]').attr('nacinnaplate', values.Medjuzbir);
                                }
                            }
                        });
                    }
                } else if (objData.Status) {
                    if (objData.Message == 'Istekla sesija ulogujte se ponovo!!!') {
                        if ($('.FrontScreen').is(":visible")) {
                            CreateWindowAlert(objData.Message, 'error');
                            window.location = './logout.php';
                        }
                    } else {
                        //CreateWindowAlert(objData.Message, 'error');
                    }
                } else {
                    //CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                }
            }
        });
    }
}
function RearangeOrder() {
    $('.PodGrupa').removeAttr('style');
    $('.Grupa').removeAttr('style');
    $('.Artikal').removeAttr('style');
    $('.PodGrupe').removeAttr('style');
    $('.Artikli').removeAttr('style');
    $('.Grupe').removeAttr('style');
    var BodyHeight = $(window).height();
    var HeaderHeight = $('.PorudzbinaHeader').height();
    var ArikliHeaderHeight = $('.PorudzbinaArtikliHeader').height();
    var TotalHeight = $('.PorudzbinaTotalKolicina').height();
    var NumerikHeight = $('.PorudzbinaNumerik').height();
    var GostiHeight = 0;
    if (!$('body').hasClass('PayQuickPayment') && !$('body').hasClass('PayForDelivery')) {
        GostiHeight = $('.GostiAkcije').height();
    }
    var ArtikliBodyHeight = parseFloat(BodyHeight) - parseFloat(ArikliHeaderHeight) - parseFloat(TotalHeight) - parseFloat(NumerikHeight) - parseFloat(HeaderHeight) - parseFloat(GostiHeight);
    $('.PorudzbinaArtikliBody').height(ArtikliBodyHeight);
    var OrderHeight = $('.PorudzbinaRightDugmad').height();
    if (window.prikaz_artikala == 'novi') {
        var PodgrupaHeight = parseFloat(OrderHeight);
        var PodgrupeButtonNumber = window.broj_redova_podgrupa;
        var GrupaButtonHeight = parseFloat(PodgrupaHeight) / (parseInt(PodgrupeButtonNumber) + 1);
        $('.PodGrupa').each(function () {
            $(this).attr('style', 'height:' + GrupaButtonHeight + 'px; line-height: ' + GrupaButtonHeight + 'px;');
        });
        $('.Grupa').each(function () {
            $(this).attr('style', 'height:' + GrupaButtonHeight + 'px; line-height: ' + GrupaButtonHeight + 'px;');
        });
        var PodgrupaSetHeight = parseFloat(PodgrupaHeight) - parseFloat(GrupaButtonHeight);
        $('.Grupe').height(GrupaButtonHeight);
        $('.PodGrupe').height(PodgrupaSetHeight);
        $('.BackGrupe').attr('style', 'height:' + GrupaButtonHeight + 'px; line-height: ' + GrupaButtonHeight + 'px;');
        $('.BackPodGrupe').attr('style', 'height:' + GrupaButtonHeight + 'px; line-height: ' + GrupaButtonHeight + 'px;');
        $('.ForwardGrupe').attr('style', 'height:' + GrupaButtonHeight + 'px; line-height: ' + GrupaButtonHeight + 'px;');
        $('.ForwardPodGrupe').attr('style', 'height:' + GrupaButtonHeight + 'px; line-height: ' + GrupaButtonHeight + 'px;');
        $('.Grupa').hide();
        if ($('.Grupa').length <= 5) {
            $('.BackGrupe').hide();
            $('.ForwardGrupe').hide();
            $('.Grupa').show();
        } else {
            $('.BackGrupe').show();
            $('.ForwardGrupe').show();
            $('.Grupa').slice(0, 3).show();
        }
        $('.Grupa').first().click();
        var ButtonNumber = window.broj_redova_artikala;
        var ArtikliHeight = parseFloat(PodgrupaSetHeight);
        var ButtonHeight = parseFloat(ArtikliHeight) / parseInt(ButtonNumber);

        $('.Artikal').each(function () {
            $(this).attr('style', 'height:' + ButtonHeight + 'px; line-height: ' + ButtonHeight + 'px;');
        });
        $('.NazadNaPodgrupe').attr('style', 'height:' + ButtonHeight + 'px; line-height: ' + ButtonHeight + 'px;');
        $('.BackArtikli').attr('style', 'height:' + ButtonHeight + 'px; line-height: ' + ButtonHeight + 'px;');
        $('.ForwardArtikli').attr('style', 'height:' + ButtonHeight + 'px; line-height: ' + ButtonHeight + 'px;');

        $('.Artikli').height(ArtikliHeight);
    } else {
        var OdnosPorudzbinaArtikli = window.visina_podgrupa;
        var PodgrupaHeight = parseFloat(OrderHeight) * (0 + (parseInt(OdnosPorudzbinaArtikli) / 100));
        var PodgrupeButtonNumber = window.broj_redova_podgrupa;
        var GrupaButtonHeight = parseFloat(PodgrupaHeight) / (parseInt(PodgrupeButtonNumber) + 1);
        $('.PodGrupa').each(function () {
            $(this).attr('style', 'height:' + GrupaButtonHeight + 'px; line-height: ' + GrupaButtonHeight + 'px;');
        });
        $('.Grupa').each(function () {
            $(this).attr('style', 'height:' + GrupaButtonHeight + 'px; line-height: ' + GrupaButtonHeight + 'px;');
        });
        var PodgrupaSetHeight = parseFloat(PodgrupaHeight) - parseFloat(GrupaButtonHeight);
        $('.Grupe').height(GrupaButtonHeight);
        $('.PodGrupe').height(PodgrupaSetHeight);
        $('.BackGrupe').attr('style', 'height:' + GrupaButtonHeight + 'px; line-height: ' + GrupaButtonHeight + 'px;');
        $('.BackPodGrupe').attr('style', 'height:' + GrupaButtonHeight + 'px; line-height: ' + GrupaButtonHeight + 'px;');
        $('.ForwardGrupe').attr('style', 'height:' + GrupaButtonHeight + 'px; line-height: ' + GrupaButtonHeight + 'px;');
        $('.ForwardPodGrupe').attr('style', 'height:' + GrupaButtonHeight + 'px; line-height: ' + GrupaButtonHeight + 'px;');
        $('.Grupa').hide();
        if ($('.Grupa').length <= 5) {
            $('.BackGrupe').hide();
            $('.ForwardGrupe').hide();
            $('.Grupa').show();
        } else {
            $('.BackGrupe').show();
            $('.ForwardGrupe').show();
            $('.Grupa').slice(0, 3).show();
        }
        $('.Grupa').first().click();
        var ButtonNumber = window.broj_redova_artikala;
        var ArtikliHeight = parseFloat(OrderHeight) - PodgrupaHeight;
        var ButtonHeight = parseFloat(ArtikliHeight) / parseInt(ButtonNumber);

        $('.Artikal').each(function () {
            $(this).attr('style', 'height:' + ButtonHeight + 'px; line-height: ' + ButtonHeight + 'px;');
        });
        $('.BackArtikli').attr('style', 'height:' + ButtonHeight + 'px; line-height: ' + ButtonHeight + 'px;');
        $('.ForwardArtikli').attr('style', 'height:' + ButtonHeight + 'px; line-height: ' + ButtonHeight + 'px;');

        $('.Artikli').height(ArtikliHeight);
    }
}
function GetAktivniStolovi() {
    $.ajax({
        type: 'POST',
        url: './?modul=GetAjax',
        data: 'GetAllTables=true',
        error: function () {
            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
        },
        complete: function (response) {
            var objData = jQuery.parseJSON(response.responseText);
            if (objData.Status == 'success') {
                //console.log(objData.Tables);
                $('.Sto').each(function () {
                    $(this).removeClass('Zauzet');
                    $(this).removeClass('Tudji');
                    $(this).children('.StoVrednost').html('');
                });
                if (objData.Tables != '') {
                    $('.AktivniStoloviBody').html('');
                    $.each(objData.Tables, function (i, values) {
                        if (parseFloat(values.Suma) >= 0) {
                            if (values.Konobar == window.UserId) {
                                $('.Sto[stoid="' + i + '"]').addClass('Zauzet');
                                $('.Sto[stoid="' + i + '"] .StoVrednost').html(parseFloat(values.Suma).toFixed(2));
                                if (values.Dostava == '' || values.Dostava == null || values.Dostava == '0') {
                                    var StoName = $('.Sto[stoid="' + i + '"] .StoNaziv').text();
                                    if (StoName == '') {
                                        StoName = i;
                                    }
                                    $('.AktivniStoloviBody').append('<div class="AktivniStoloviRed" idstola="' + i + '"><div class="AktivniStoloviOperater">' + window.UserName + '</div><div class="AktivniStoloviSto">' + StoName + '</div></div>');
                                }
                            } else {
                                $('.Sto[stoid="' + i + '"]').addClass('Tudji');
                            }
                        }
                    });
                }
            } else if (objData.Status) {
                if (objData.Message == 'Istekla sesija ulogujte se ponovo!!!') {
                    CreateWindowAlert(objData.Message, 'error');
                    window.location = './logout.php';
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                }
            } else {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
            }
        }
    });
    $('.AktivniStolovi').show();
    var RightHeight = $('.AktivniStoloviDesno').height();
    var RightBtnHeight = parseFloat(RightHeight) / 4;
    $('.AktivniStoloviDesno div').attr('style', 'height: ' + RightBtnHeight + 'px; line-height: ' + RightBtnHeight + 'px;');
}
function CalcTotal() {
    if ($('.PorudzbinaArtikliBody .PoruceniArtikal').length) {
        var TotalIznos = 0;
        var TotalKolicina = 0;
        $('.PorudzbinaArtikliBody .PoruceniArtikal').each(function () {
            var Kolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
            var Cena = $(this).attr('cenaporucenog');
            var Iznos = parseFloat(Kolicina) * parseFloat(Cena);
            TotalIznos = TotalIznos + parseFloat(Iznos);
            TotalKolicina = TotalKolicina + parseFloat(Kolicina);
            $(this).find('.PorudzbinaArtikliIznos').first().html(parseFloat(Iznos).toFixed(2));
        });
        if (TotalIznos > 0) {
            $('.PorudzbinaTotalPay .PorudzbinaTotalValue').html(parseFloat(TotalIznos).toFixed(2));
        }
    } else {
        $('.PorudzbinaTotalValue').html(0.00);
    }
}
function GetTableItems(StoId) {
    $('.PorudzbinaArtikliBody').html('');
    $('.PorudzbinaTotal').hide();
    $('.PorudzbinaKolicina').hide();
    $.ajax({
        type: 'POST',
        url: './?modul=GetAjax',
        data: 'GetTableItems=' + StoId,
        error: function () {
            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
        },
        complete: function (response) {
            var objData = jQuery.parseJSON(response.responseText);
            if (objData.Status == 'success') {
                //console.log(objData);
                if (objData.TableItems != '') {
                    $('.GostiAkcije .GostAkcija').remove();
                    $('.PrazanStoAkcije').hide();
                    $('.AktivanStoAkcije').hide();
                    $('.PunStoAkcije').show();
                    $('.AktivniStoloviBody').html('');
                    $('.PorudzbinaArtikliBody').html("<div class='StariArtikli'></div>");
                    var TuraId = 0;
                    var GostBroj = 0;
                    var ItemHtml = '';
                    var TuraInc = 1;
                    $.each(objData.TableItems, function (i, values) {
                        var Iznos = parseFloat(values.Kolicina) * parseFloat(values.Cena);
                        if (values.IdTure != TuraId) {
                            if (TuraId != 0) {
                                ItemHtml += '</div>';
                            }
                            if (values.BrojGosta != GostBroj) {
                                if (GostBroj != 0) {
                                    ItemHtml += '</div>';
                                }
                                ItemHtml += '<div class="GostArtikli" gost-broj="' + values.BrojGosta + '">';
                                $('.GostiAkcije').append('<div class="GostAkcija" gost-number="' + values.BrojGosta + '">G' + values.BrojGosta + '</div>');
                                GostBroj = values.BrojGosta;
                            }
                            ItemHtml += '<div class="StoTura" id-ture="' + values.IdTure + '"><div class="StoTuraTitle">Porudžbina ' + TuraInc + ' br.' + values.BrojTure + '<span class="ReloadTura"><i class="fa fa-recycle"></i></span></div><div class="StoTuraVreme">' + values.Vreme + '</div>';
                            TuraId = values.IdTure;
                            TuraInc++;
                        }
                        if (values.Dodatni != 0) {
                            ItemHtml += '<div class="DodatniArtikal PoruceniArtikal" stavkaracunaopis="' + values.Opis + '" glavnastavka="' + values.Dodatni + '" stavkaracunakolicina="' + values.Kolicina + '" stavkaracunaid="' + values.StavkaId + '" cenaporucenog="' + values.Cena + '" idporucenog="' + values.ArtikalId + '" stavkaturaid="' + values.IdTure + '">'
                                    + '<div class="PorudzbinaArtikliNaziv">' + values.Naziv + '</div>'
                                    + '<div class="PorudzbinaArtikliKolicina">' + values.Kolicina + '</div>'
                                    + '<div class="PorudzbinaArtikliIznos">' + parseFloat(Iznos).toFixed(2) + '</div>'
                                    + '</div>';
                        } else {
                            ItemHtml += '<div class="PoruceniArtikal" stavkaracunaopis="' + values.Opis + '" stavkaracunakolicina="' + values.Kolicina + '" stavkaracunaid="' + values.StavkaId + '" cenaporucenog="' + values.Cena + '" idporucenog="' + values.ArtikalId + '" stavkaturaid="' + values.IdTure + '">'
                                    + '<div class="PorudzbinaArtikliNaziv">' + values.Naziv + '</div>'
                                    + '<div class="PorudzbinaArtikliKolicina">' + values.Kolicina + '</div>'
                                    + '<div class="PorudzbinaArtikliIznos">' + parseFloat(Iznos).toFixed(2) + '</div>'
                                    + '</div>';
                        }
                    });
                    ItemHtml += '</div>';
                    ItemHtml += '</div>';
                    $('.PorudzbinaArtikliBody .StariArtikli').append(ItemHtml);
                    $('.GostiAkcije .GostAkcija').first().click();
                    CalcTotal();
                    if ($('.Sto[stoid="' + StoId + '"]').hasClass('Zakljucan') && window.UserMedjuzbir != '1') {
                        if (window.UserLevel != 'SEF') {
                            $('.Porudzbina').hide();
                            $('.PorudzbinaRightAkcija[dugmeaction="Naplata"]').click();
                        }
                    }
                } else {
                    $('.GostiAkcije .GostAkcija').remove();
                    $('.GostiAkcije').append('<div class="GostAkcija ActiveGostAkcija" gost-number="1">G1</div>');
                    $('.PorudzbinaArtikliBody').html('<div class="GostArtikli ActiveGostArtikli" gost-broj="1"></div>');
                    $('.PrazanStoAkcije').show();
                    $('.AktivanStoAkcije').hide();
                    $('.PunStoAkcije').hide();
                }
            } else if (objData.Status) {
                if (objData.Message == 'Istekla sesija ulogujte se ponovo!!!') {
                    CreateWindowAlert(objData.Message, 'error');
                    window.location = './logout.php';
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                }
                $('.GostiAkcije .GostAkcija').remove();
                $('.GostiAkcije').append('<div class="GostAkcija ActiveGostAkcija" gost-number="1">G1</div>');
                $('.PorudzbinaArtikliBody').html('<div class="GostArtikli ActiveGostArtikli" gost-broj="1"></div>');
                $('.PrazanStoAkcije').show();
                $('.AktivanStoAkcije').hide();
                $('.PunStoAkcije').hide();
            } else {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                $('.GostiAkcije .GostAkcija').remove();
                $('.GostiAkcije').append('<div class="GostAkcija ActiveGostAkcija" gost-number="1">G1</div>');
                $('.PorudzbinaArtikliBody').html('<div class="GostArtikli ActiveGostArtikli" gost-broj="1"></div>');
                $('.PrazanStoAkcije').show();
                $('.AktivanStoAkcije').hide();
                $('.PunStoAkcije').hide();

            }
        }
    });
}
function PosaljiPorudzbinu() {
    $('.Loader').show();
    if ($('.PoruceniArtikal').length) {
        var Artikli = [];
        var IncOrder = 0;
        var OrderTotal = 0;
        $('.PorudzbinaArtikliBody .GostArtikli').each(function () {
            var GostBroj = $(this).attr('gost-broj');
            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + GostBroj + '"] .PoruceniArtikal').each(function () {
                var IdArtikla = $(this).attr('idporucenog');
                var TipArtikla = $(this).attr('tipporucenog');
                var CenaArtikla = $(this).attr('cenaporucenog');
                var NazivArtikla = $(this).find('.PorudzbinaArtikliNaziv').first().text();
                var KolicinaArtikla = $(this).find('.PorudzbinaArtikliKolicina').first().text();
                var NadredjeniArtikal = $(this).attr('glavniartikal');
                var OpisArtikla = "";
                if ($(this).find('.OpisArtikla').first().length) {
                    OpisArtikla = $(this).find('.OpisArtikla .OpisContent').first().html();
                }
                Artikli[IncOrder] = [];
                Artikli[IncOrder][0] = IdArtikla;
                Artikli[IncOrder][1] = TipArtikla;
                Artikli[IncOrder][2] = CenaArtikla;
                Artikli[IncOrder][3] = NazivArtikla;
                Artikli[IncOrder][4] = KolicinaArtikla;
                Artikli[IncOrder][5] = NadredjeniArtikal;
                Artikli[IncOrder][6] = OpisArtikla;
                Artikli[IncOrder][7] = GostBroj;
                IncOrder++;
                OrderTotal = OrderTotal + (parseFloat(CenaArtikla) * parseFloat(KolicinaArtikla));
            });
        });
        if (parseFloat(OrderTotal) > 0) {
            var StoId = $('.PorudzbinaSto').attr('sto-id');
            var StoNaziv = $('.PorudzbinaSto').text();
            var OpisTure = $('.TuraOpisiTop').html();
            if (!OpisTure) {
                OpisTure = "";
            }
            var DostavaId = 0;
            var DostavaAdresaId = 0;
            if ($('.SelectedDostavaAdresa').length) {
                DostavaAdresaId = $('.SelectedDostavaAdresa').attr('adresaid');
                DostavaId = $('.DostavaIme').attr('kupacdostavaid');
            }
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: {
                    InsertOrderForTable: StoId,
                    TuraOpis: OpisTure,
                    ArtikliTure: Artikli,
                    TableName: StoNaziv,
                    DeliveryBuyerId: DostavaId,
                    DeliveryBuyerAddressId: DostavaAdresaId
                },
                error: function () {
                    $('.Loader').hide();
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                },
                complete: function (response) {
                    $('.Loader').hide();
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        $('.PorudzbinaArtikliBody').html('');
                        $('.Porudzbina').hide();
                        $('.ListaAdresa').hide();
                        $('.PretragaDostava').hide();
                        $('.Dostava').hide();
                        $('body').removeClass('PayForDelivery');
                        $('body').removeClass('DostavaActive');
                        $('.DostavaTelefon').val('');
                        $('.DostavaAdrese').html('');
                        if ($('body').hasClass('brzaNaplata')) {
                            $('.SelectAction[actionid="QuickPayment"]').click();
                        }
                        if (objData.Action == "Logout") {
                            window.location = './logout.php';
                        }
                    } else {
                        CreateWindowAlert(objData.Message, 'error');
                    }
                }
            });
        } else {
            $('.Loader').hide();
            CreateWindowAlert('Poručena vrednost mora biti veća od 0!!!', 'error');
        }
    } else {
        $('.Loader').hide();
        CreateWindowAlert('Najpre odaberite artikle!!!', 'error');
    }
}
function DecreaseItem() {
    if ($('.NumerikInput').val()) {
        var Text = $('.NumerikInput').val();
        var NewText = Text.slice(0, -1);
        $('.NumerikInput').val(NewText);
    } else {
        if (!$('.StariArtikli').length) {
            if ($('.OdabraniArtikal').length) {
                var Kolicina = $('.OdabraniArtikal .PorudzbinaArtikliKolicina').html();
                var NewKolicina = 0;
                if (parseFloat(Kolicina) > 0) {
                    NewKolicina = parseFloat(Kolicina) - 1;
                }
                if (parseFloat(NewKolicina) > 0) {
                    $('.OdabraniArtikal .PorudzbinaArtikliKolicina').html(parseFloat(NewKolicina).toFixed(2));
                } else {
                    $('.OdabraniArtikal').remove();
                }
                CalcTotal();
            } else {
                if ($('.PoruceniArtikal').length) {
                    var Kolicina = $('.PoruceniArtikal').last().find('.PorudzbinaArtikliKolicina').first().html();
                    var NewKolicina = 0;
                    if (parseFloat(Kolicina) > 0) {
                        NewKolicina = parseFloat(Kolicina) - 1;
                    }
                    if (parseFloat(NewKolicina) > 0) {
                        $('.PoruceniArtikal').last().find('.PorudzbinaArtikliKolicina').first().html(parseFloat(NewKolicina).toFixed(2));
                    } else {
                        $('.PoruceniArtikal').last().remove();
                    }
                    CalcTotal();
                } else {
                    CreateWindowAlert('Nema artikala kojima se može umanjiti količina!!!', 'error');
                }
            }
        }
    }
}
function CalcKusur() {
    var UkupnoValue = $('.UkupnoValue').val();
    var UplacenoValue = $('.UplacenoValue').val();
    if (parseFloat(UkupnoValue) > 0 && parseFloat(UplacenoValue) > 0) {
        var Kusur = parseFloat(UplacenoValue) - parseFloat(UkupnoValue);
        $('.KusurValue').val(parseFloat(Kusur).toFixed(2));
    } else {
        if (parseFloat(UkupnoValue) > 0) {
            $('.KusurValue').val('-' + UkupnoValue);
        } else {
            $('.KusurValue').val(0);
        }
    }
}
function NaplatiRacun() {
    var Efiskal = "ne";
    if ($('.Efiskalizacija').length) {
        Efiskal = "da";
    }
    var TotalToPay = $('.UkupnoValue').val();
    var TotalPaid = $('.UplacenoValue').val();
    if ($('.NaplataButton[buton-action="Kombinovano"]').hasClass('SelectedOption')) {
        if ($('.FakturaValue').length) {
            if ($('.FakturaValue').val()) {
                if ($('.FakturaValue').val() != TotalToPay) {
                    CreateWindowAlert('Iznos naplate putem fakture mora biti jednak ukupno naplaćenom iznosu!!!', 'error');
                    return false;
                }
            }
        }
        var CheckTotal = 0;
        $('.KombinovanoValue').each(function () {
            var ThisVal = $(this).val();
            if (ThisVal) {
                CheckTotal = parseFloat(CheckTotal) + parseFloat(ThisVal);
            }
        });
        if (parseFloat(CheckTotal) != parseFloat(TotalPaid)) {
            CreateWindowAlert('Iznos koji ste uneli je neispravan!!!', 'error');
            return false;
        }
    } else {
        if (!$('.SelectedNaplata').length) {
            CreateWindowAlert('Najpre odaberite način naplate!!!', 'error');
            return false;
        }
        if ($('.BeloNaplata[belo-opcija="FAKTURA"]').hasClass('SelectedNaplata')) {
            if (!$('.StalniGostValue').attr('komitent-id') && !$('.OFPibKupca').val()) {
                $('.Faktura').show(500);
                setTimeout(function () {
                    var Height = $('.FakturaKupciAkcije').height() / 3;
                    $('.FakturaKupciAkcija').attr('style', 'height: ' + Height + 'px; line-height: ' + Height + 'px;');
                }, 510);
                $('.FindKupca').focus();
                return false;
            } else if (!$('.OFPibKupcaID').val())
            {
                CreateWindowAlert('Najpre odaberite tip oznake kupca!!!', 'error');
                return false;
            }
        }
    }
    if (parseFloat(TotalPaid) < parseFloat(TotalToPay)) {
        CreateWindowAlert('Uplaćeni iznos je manji od iznosa računa!!!', 'error');
        return false;
    }
    if (!$('.SelectedDelivery').length) {
        if (!$('body').hasClass('PayQuickPayment')) {
            if (window.brojanje_gostiju == 'true') {
                if ($('.UsluzeniGosti').is(':visible')) {
                    var BrojGostiju = $('.BrojPosluzenihGostiju').val();
                    if (!BrojGostiju) {
                        CreateWindowAlert('Unesite broj usluženih gostiju!!!', 'error');
                        return false;
                    }
                } else {
                    if (!$('.CrnoNaplata[crno-opcija="MEDJUZBIR"]').hasClass('SelectedNaplata')) {
                        $('.UsluzeniGosti').show();
                        $('.BrojPosluzenihGostiju').focus();
                        $('.BrojPosluzenihGostiju').val('');
                        return false;
                    }
                }
            }
        }
    }

    var RacunData = [];
    var IncData = 0;
    if (Efiskal == "da") {
        var InvoiceType = $('.OFVrstaRacuna').val();
        RacunData[IncData] = ['InvoiceType', InvoiceType];
        IncData++;
        var BuyerVat = $('.OFPibKupca').val();
        RacunData[IncData] = ['BuyerVat', BuyerVat];
        IncData++;
        var BuyerOption = $('.OFOpcionoPoljeKupca').val();
        RacunData[IncData] = ['BuyerOption', BuyerOption];
        IncData++;
        var BuyerVatID = $('.OFPibKupcaID').val();
        RacunData[IncData] = ['BuyerVatID', BuyerVatID];
        IncData++;
        var BuyerOptionID = $('.OFOpcionoPoljeKupcaID').val();
        RacunData[IncData] = ['BuyerOptionID', BuyerOptionID];
        IncData++;
        var ReferentNumber = $('.OFReferentniBrojKupca').val();
        RacunData[IncData] = ['ReferentNumber', ReferentNumber];
        IncData++;
        var FakturaFormat = $('.FakturaFormat').val();
        RacunData[IncData] = ['FakturaFormat', FakturaFormat];
        IncData++;
    }
    var ArtikliData = [];
    var ArtikliInc = 0;
    var TipRacuna = "ObicanRacun";
    if ($('body').hasClass('PayTransferedTables')) {
        if ($('.CrnoNaplata').hasClass('SelectedNaplata')) {
            var IsMedjuzbir = $('.SelectedNaplata').attr('crno-medjuzbir');
            if (IsMedjuzbir == 1) {
                CreateWindowAlert('Nije moguće izvršiti naplatu iz rastavljanja sa ovim načinom plaćanja!!! Odaberite drugi način plaćanja!!!', 'error');
                return false;
            }
        }
        $('.RastavljanjeRight .PoruceniArtikal').each(function () {
            var StavkaId = $(this).attr('stavkaracunaid');
            var CenaArtikla = $(this).attr('cenaporucenog');
            var IdPorucenog = $(this).attr('idporucenog');
            var Kolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
            var NazivArtikla = $(this).find('.PorudzbinaArtikliNaziv').first().html();
            ArtikliData[ArtikliInc] = [StavkaId, Kolicina, CenaArtikla, IdPorucenog, NazivArtikla];
            ArtikliInc++;
        });
        TipRacuna = "RastavljanjeStola";
    } else if ($('body').hasClass('PayQuickPayment')) {
        if ($('.CrnoNaplata').hasClass('SelectedNaplata')) {
            var IsMedjuzbir = $('.SelectedNaplata').attr('crno-medjuzbir');
            if (IsMedjuzbir == 1) {
                CreateWindowAlert('Nije moguće izvršiti brzu naplatu sa ovim načinom plaćanja!!! Odaberite drugi način plaćanja!!!', 'error');
                return false;
            }
        }
        $('.PorudzbinaArtikliBody .PoruceniArtikal').each(function () {
            var StavkaId = 0;
            var CenaArtikla = $(this).attr('cenaporucenog');
            var IdPorucenog = $(this).attr('idporucenog');
            var Kolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
            var NazivArtikla = $(this).find('.PorudzbinaArtikliNaziv').first().html();
            var TipArtikla = $(this).attr('tipporucenog');
            var OpisArtikla = "";
            if ($(this).find('.OpisArtikla').first().length) {
                OpisArtikla = $(this).find('.OpisArtikla .OpisContent').first().html();
            }
            ArtikliData[ArtikliInc] = [StavkaId, Kolicina, CenaArtikla, IdPorucenog, NazivArtikla, TipArtikla, OpisArtikla];
            ArtikliInc++;
        });
        var OpisTure = $('.TuraOpisiTop').html();
        if (!OpisTure) {
            OpisTure = "";
        }
        RacunData[IncData] = ['RacunTuraOpis', OpisTure];
        IncData++;
        TipRacuna = "BrzaNaplata";
    } else {
        $('.PorudzbinaArtikliBody .PoruceniArtikal').each(function () {
            var StavkaId = $(this).attr('stavkaracunaid');
            var CenaArtikla = $(this).attr('cenaporucenog');
            var IdPorucenog = $(this).attr('idporucenog');
            var Kolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
            var NazivArtikla = $(this).find('.PorudzbinaArtikliNaziv').first().html();
            ArtikliData[ArtikliInc] = [StavkaId, Kolicina, CenaArtikla, IdPorucenog, NazivArtikla];
            ArtikliInc++;
        });
    }
    if (parseFloat(TotalPaid) >= parseFloat(TotalToPay)) {
        if ($('.NaplataButton[buton-action="Kombinovano"]').hasClass('SelectedOption')) {
            var CekanjePaid = 0;
            $('.KombinovanoValue').each(function () {
                if ($(this).hasClass('KarticaValue') || $(this).hasClass('CekValue')) {
                    var ThisVal = $(this).val();
                    CekanjePaid = parseFloat(CekanjePaid) + parseFloat(ThisVal);
                }
            });
            if (parseFloat(TotalToPay) < parseFloat(CekanjePaid)) {
                CreateWindowAlert('Iznos naplate putem čeka ili kartice mora biti manji ili jednak ukupno naplaćenom iznosu!!!', 'error');
            } else {
                RacunData[IncData] = ['TotalZaRacun', TotalToPay];
                IncData++;
                if ($('.NaplataButton[buton-action="MeniNaplata"]').hasClass('SelectedOption')) {
                    var MeniId = $('.SelectedMenuItem').attr('menu-id');
                    var MeniNaziv = $('.SelectedMenuItem').attr('menu-name');
                    var MeniKolicina = $('.MenuKolicina').val();
                    var MeniCena = $('.MenuCena').val();
                    RacunData[IncData] = ['MeniId', MeniId];
                    IncData++;
                    RacunData[IncData] = ['MeniNaziv', MeniNaziv];
                    IncData++;
                    RacunData[IncData] = ['MeniKolicina', MeniKolicina];
                    IncData++;
                    RacunData[IncData] = ['MeniCena', MeniCena];
                    IncData++;
                }
                $('.CrnoNaplata').each(function () {
                    var Opcija = $(this).attr('crno-opcija');
                    RacunData[IncData] = [Opcija, '0'];
                    IncData++;
                });
                $('.BeloNaplata').each(function () {
                    var Opcija = $(this).attr('belo-opcija');
                    var OpcijaVrednost = $(this).find('.KombinovanoValue').first().val();
                    if (OpcijaVrednost) {
                        RacunData[IncData] = [Opcija, OpcijaVrednost];
                    } else {
                        RacunData[IncData] = [Opcija, '0'];
                    }
                    IncData++;
                });
                var BrojStola = $('.PorudzbinaSto').attr('sto-id');
                RacunData[IncData] = ['BrojStola', BrojStola];
                IncData++;
                var StalniGostId = $('.StalniGostValue').attr('stalnigost-id');
                if (!parseInt(StalniGostId) > 0) {
                    StalniGostId = '0';
                }
                RacunData[IncData] = ['StalniGostId', StalniGostId];
                IncData++;
                var KomitentId = $('.StalniGostValue').attr('komitent-id');
                if (!parseInt(KomitentId) > 0) {
                    KomitentId = '0';
                }
                RacunData[IncData] = ['RacunKomitent', KomitentId];
                IncData++;
                var Popust = $('.PopustPercentValue').val();
                if (!parseInt(Popust) > 0) {
                    Popust = '0';
                }
                RacunData[IncData] = ['PopustZaRacun', Popust];
                IncData++;
                var BrojGostiju = $('.BrojPosluzenihGostiju').val();
                if (!parseInt(BrojGostiju) > 0) {
                    BrojGostiju = '0';
                }
                RacunData[IncData] = ['BrojPosluzenihGostiju', BrojGostiju];
                //console.log(RacunData);

                $('.Loader').show();
                $.ajax({
                    type: 'POST',
                    url: './?modul=GetAjax',
                    data: {
                        TipUbacivanjaRacuna: TipRacuna,
                        UbaciRacune: RacunData,
                        UbaceniArtikli: ArtikliData
                    },
                    error: function () {
                        CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');

                        $('.Loader').hide();
                    },
                    complete: function (response) {
                        var objData = jQuery.parseJSON(response.responseText);
                        if (objData.Status == 'success') {
                            $('.Naplata').hide();
                            if (!$('body').hasClass('PayTransferedTables')) {
                                $('.Porudzbina').hide();
                                if (objData.Action == 'Logout' && parseInt(KomitentId) <= 0 && !$('.NaplataButton[buton-action="Gotovinski"]').hasClass('SelectedOption')) {
                                    window.location = './logout.php';
                                }
                            }
                            $('.RastavljanjeRight').html('');
                            if ($('.RastavljanjeLeft .PoruceniArtikal').length) {

                            } else {
                                $('.Rastavljanje').hide();
                                $('body').removeClass('PayTransferedTables');
                                $('.Porudzbina').hide();
                                if (objData.Action == 'Logout' && parseInt(KomitentId) <= 0 && !$('.NaplataButton[buton-action="Gotovinski"]').hasClass('SelectedOption')) {
                                    window.location = './logout.php';
                                }
                            }
                            $('body').removeClass('PayQuickPayment');
                            $('.StalniGostValue').removeAttr('stalnigost-id');
                            $('.StalniGostValue').removeAttr('komitent-id');
                            $('.StalniGostValue').val('');
                            $('.PopustPercentValue').val('');
                            if ($('.NaplataButton[buton-action="Gotovinski"]').hasClass('SelectedOption') && Efiskal == 'ne') {
                                $('.SelectAction[actionid="Gotovinski"]').click();
                            }
                            if (parseInt(KomitentId) > 0 && objData.RacunId != '' && Efiskal == 'ne') {
                                $('.FakturaBi').show();
                                $('.FakturaBrojRacuna').val(objData.RacunId);
                                $('.FakturaBrojIsecka').focus();
                            }
                            if ($('.NaplataButton[buton-action="MeniNaplata"]').hasClass('SelectedOption')) {
                                $('.NaplataButton[buton-action="MeniNaplata"]').removeClass('SelectedOption');
                                $('.MenuCena').val('');
                                $('.MenuKolicina').val('');
                                $('.MenuUkupno').val('');
                                $('.SelectedMenuItem').removeAttr('menu-id');
                                $('.SelectedMenuItem').removeAttr('menu-name');
                                $('.MenuItem').removeClass('MenuSelected');
                            }
                            $('.Dostava').hide();
                            $('body').removeClass('PayForDelivery');
                            $('body').removeClass('DostavaActive');
                            if ($('body').hasClass('brzaNaplata')) {
                                $('.SelectAction[actionid="QuickPayment"]').click();
                            }
                        } else if (objData.Status) {
                            if (objData.Message == 'Istekla sesija ulogujte se ponovo!!!') {
                                CreateWindowAlert(objData.Message, 'error');
                                window.location = './logout.php';
                            } else {
                                CreateWindowAlert(objData.Message, 'error');
                            }
                        } else {
                            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                        }
                        $('.StalniGosti tr').removeClass('SelectedGost');
                        $('.Loader').hide();
                    }
                });
            }
        } else {
            if ($('.SelectedNaplata').length) {
                if ($('.SelectedNaplata').attr('belo-opcija') == 'KARTICA' || $('.SelectedNaplata').attr('belo-opcija') == 'CEK') {
                    if (parseFloat(TotalToPay) != parseFloat(TotalPaid)) {
                        CreateWindowAlert('Iznos naplate putem čeka ili kartice mora biti manji ili jednak ukupno naplaćenom iznosu!!!', 'error');
                    } else {
                        RacunData[IncData] = ['TotalZaRacun', TotalToPay];
                        IncData++;
                        if ($('.NaplataButton[buton-action="MeniNaplata"]').hasClass('SelectedOption')) {
                            var MeniId = $('.SelectedMenuItem').attr('menu-id');
                            var MeniNaziv = $('.SelectedMenuItem').attr('menu-name');
                            var MeniKolicina = $('.MenuKolicina').val();
                            var MeniCena = $('.MenuCena').val();
                            RacunData[IncData] = ['MeniId', MeniId];
                            IncData++;
                            RacunData[IncData] = ['MeniNaziv', MeniNaziv];
                            IncData++;
                            RacunData[IncData] = ['MeniKolicina', MeniKolicina];
                            IncData++;
                            RacunData[IncData] = ['MeniCena', MeniCena];
                            IncData++;
                        }
                        $('.CrnoNaplata').each(function () {
                            var Opcija = $(this).attr('crno-opcija');
                            if ($(this).hasClass('SelectedNaplata')) {
                                RacunData[IncData] = [Opcija, TotalPaid];
                            } else {
                                RacunData[IncData] = [Opcija, '0'];
                            }
                            IncData++;
                        });
                        $('.BeloNaplata').each(function () {
                            var Opcija = $(this).attr('belo-opcija');
                            if ($(this).hasClass('SelectedNaplata')) {
                                RacunData[IncData] = [Opcija, TotalPaid];
                            } else {
                                RacunData[IncData] = [Opcija, '0'];
                            }
                            IncData++;
                        });
                        var BrojStola = $('.PorudzbinaSto').attr('sto-id');
                        RacunData[IncData] = ['BrojStola', BrojStola];
                        IncData++;
                        var StalniGostId = $('.StalniGostValue').attr('stalnigost-id');
                        if (!parseInt(StalniGostId) > 0) {
                            StalniGostId = '0';
                        }
                        RacunData[IncData] = ['StalniGostId', StalniGostId];
                        IncData++;
                        var KomitentId = $('.StalniGostValue').attr('komitent-id');
                        if (!parseInt(KomitentId) > 0) {
                            KomitentId = '0';
                        }
                        RacunData[IncData] = ['RacunKomitent', KomitentId];
                        IncData++;
                        var Popust = $('.PopustPercentValue').val();
                        if (!parseInt(Popust) > 0) {
                            Popust = '0';
                        }
                        RacunData[IncData] = ['PopustZaRacun', Popust];
                        IncData++;
                        var BrojGostiju = $('.BrojPosluzenihGostiju').val();
                        if (!parseInt(BrojGostiju) > 0) {
                            BrojGostiju = '0';
                        }
                        RacunData[IncData] = ['BrojPosluzenihGostiju', BrojGostiju];
                        $('.Loader').show();
                        $.ajax({
                            type: 'POST',
                            url: './?modul=GetAjax',
                            data: {
                                TipUbacivanjaRacuna: TipRacuna,
                                UbaciRacune: RacunData,
                                UbaceniArtikli: ArtikliData
                            },
                            error: function () {
                                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                $('.Loader').hide();
                            },
                            complete: function (response) {
                                console.log(response);
                                var objData = jQuery.parseJSON(response.responseText);
                                if (objData.Status == 'success') {
                                    $('.Naplata').hide();
                                    if (!$('body').hasClass('PayTransferedTables')) {
                                        $('.Porudzbina').hide();
                                        if (objData.Action == 'Logout' && parseInt(KomitentId) <= 0 && !$('.NaplataButton[buton-action="Gotovinski"]').hasClass('SelectedOption')) {
                                            window.location = './logout.php';
                                        }
                                    }
                                    $('.RastavljanjeRight').html('');
                                    if ($('.RastavljanjeLeft .PoruceniArtikal').length) {

                                    } else {
                                        $('.Rastavljanje').hide();
                                        $('body').removeClass('PayTransferedTables');
                                        $('.Porudzbina').hide();
                                        if (objData.Action == 'Logout' && parseInt(KomitentId) <= 0 && !$('.NaplataButton[buton-action="Gotovinski"]').hasClass('SelectedOption')) {
                                            window.location = './logout.php';
                                        }
                                    }
                                    $('body').removeClass('PayQuickPayment');
                                    $('.StalniGostValue').removeAttr('stalnigost-id');
                                    $('.StalniGostValue').removeAttr('komitent-id');
                                    $('.StalniGostValue').val('');
                                    $('.PopustPercentValue').val('');
                                    if ($('.NaplataButton[buton-action="Gotovinski"]').hasClass('SelectedOption') && Efiskal == 'ne') {
                                        $('.SelectAction[actionid="Gotovinski"]').click();
                                    }
                                    if (parseInt(KomitentId) > 0 && objData.RacunId != '' && Efiskal == 'ne') {
                                        $('.FakturaBi').show();
                                        $('.FakturaBrojRacuna').val(objData.RacunId);
                                        $('.FakturaBrojIsecka').focus();
                                    }
                                    if ($('.NaplataButton[buton-action="MeniNaplata"]').hasClass('SelectedOption')) {
                                        $('.NaplataButton[buton-action="MeniNaplata"]').removeClass('SelectedOption');
                                        $('.MenuCena').val('');
                                        $('.MenuKolicina').val('');
                                        $('.MenuUkupno').val('');
                                        $('.SelectedMenuItem').removeAttr('menu-id');
                                        $('.SelectedMenuItem').removeAttr('menu-name');
                                        $('.MenuItem').removeClass('MenuSelected');
                                    }
                                    $('.Dostava').hide();
                                    $('body').removeClass('PayForDelivery');
                                    $('body').removeClass('DostavaActive');
                                    if ($('body').hasClass('brzaNaplata')) {
                                        $('.SelectAction[actionid="QuickPayment"]').click();
                                    }
                                } else if (objData.Status) {
                                    if (objData.Message == 'Istekla sesija ulogujte se ponovo!!!') {
                                        CreateWindowAlert(objData.Message, 'error');
                                        window.location = './logout.php';
                                    } else {
                                        CreateWindowAlert(objData.Message, 'error');
                                    }
                                } else {
                                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                }
                                $('.StalniGosti tr').removeClass('SelectedGost');
                                $('.Loader').hide();
                            }
                        });
                    }
                } else {
                    RacunData[IncData] = ['TotalZaRacun', TotalToPay];
                    IncData++;
                    if ($('.NaplataButton[buton-action="MeniNaplata"]').hasClass('SelectedOption')) {
                        var MeniId = $('.SelectedMenuItem').attr('menu-id');
                        var MeniNaziv = $('.SelectedMenuItem').attr('menu-name');
                        var MeniKolicina = $('.MenuKolicina').val();
                        var MeniCena = $('.MenuCena').val();
                        RacunData[IncData] = ['MeniId', MeniId];
                        IncData++;
                        RacunData[IncData] = ['MeniNaziv', MeniNaziv];
                        IncData++;
                        RacunData[IncData] = ['MeniKolicina', MeniKolicina];
                        IncData++;
                        RacunData[IncData] = ['MeniCena', MeniCena];
                        IncData++;
                    }
                    $('.CrnoNaplata').each(function () {
                        var Opcija = $(this).attr('crno-opcija');
                        if ($(this).hasClass('SelectedNaplata')) {
                            RacunData[IncData] = [Opcija, TotalPaid];
                        } else {
                            RacunData[IncData] = [Opcija, '0'];
                        }
                        IncData++;
                    });
                    $('.BeloNaplata').each(function () {
                        var Opcija = $(this).attr('belo-opcija');
                        if ($(this).hasClass('SelectedNaplata')) {
                            RacunData[IncData] = [Opcija, TotalPaid];
                        } else {
                            RacunData[IncData] = [Opcija, '0'];
                        }
                        IncData++;
                    });
                    var BrojStola = $('.PorudzbinaSto').attr('sto-id');
                    RacunData[IncData] = ['BrojStola', BrojStola];
                    IncData++;
                    var StalniGostId = $('.StalniGostValue').attr('stalnigost-id');
                    if (!parseInt(StalniGostId) > 0) {
                        StalniGostId = '0';
                    }
                    RacunData[IncData] = ['StalniGostId', StalniGostId];
                    IncData++;
                    var KomitentId = $('.StalniGostValue').attr('komitent-id');
                    if (!parseInt(KomitentId) > 0) {
                        KomitentId = '0';
                    }
                    RacunData[IncData] = ['RacunKomitent', KomitentId];
                    IncData++;
                    var Popust = $('.PopustPercentValue').val();
                    if (!parseInt(Popust) > 0) {
                        Popust = '0';
                    }
                    RacunData[IncData] = ['PopustZaRacun', Popust];
                    IncData++;
                    var BrojGostiju = $('.BrojPosluzenihGostiju').val();
                    if (!parseInt(BrojGostiju) > 0) {
                        BrojGostiju = '0';
                    }
                    RacunData[IncData] = ['BrojPosluzenihGostiju', BrojGostiju];
                    $('.Loader').show();
                    $.ajax({
                        type: 'POST',
                        url: './?modul=GetAjax',
                        data: {
                            TipUbacivanjaRacuna: TipRacuna,
                            UbaciRacune: RacunData,
                            UbaceniArtikli: ArtikliData
                        },
                        error: function () {
                            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                            $('.Loader').hide();
                        },
                        complete: function (response) {
                            console.log(response);
                            var objData = jQuery.parseJSON(response.responseText);
                            var fiskalniRacunId = objData.fiskalniRacunId;
                            if (objData.Status == 'success') {
                                $('.Naplata').hide();
                                if (!$('body').hasClass('PayTransferedTables')) {
                                    $('.Porudzbina').hide();
                                    if (objData.Action == 'Logout' && parseInt(KomitentId) <= 0 && !$('.NaplataButton[buton-action="Gotovinski"]').hasClass('SelectedOption')) {
                                        window.location = './logout.php';
                                    }
                                }
                                $('.RastavljanjeRight').html('');
                                if ($('.RastavljanjeLeft .PoruceniArtikal').length) {

                                } else {
                                    $('.Rastavljanje').hide();
                                    $('body').removeClass('PayTransferedTables');
                                    $('.Porudzbina').hide();
                                    if (objData.Action == 'Logout' && parseInt(KomitentId) <= 0 && !$('.NaplataButton[buton-action="Gotovinski"]').hasClass('SelectedOption')) {
                                        window.location = './logout.php';
                                    }
                                }
                                $('body').removeClass('PayQuickPayment');
                                $('.StalniGostValue').removeAttr('stalnigost-id');
                                $('.StalniGostValue').removeAttr('komitent-id');
                                $('.StalniGostValue').val('');
                                $('.PopustPercentValue').val('');
                                if ($('.NaplataButton[buton-action="Gotovinski"]').hasClass('SelectedOption') && Efiskal == 'ne') {
                                    $('.SelectAction[actionid="Gotovinski"]').click();
                                }
                                if (parseInt(KomitentId) > 0 && objData.RacunId != '' && Efiskal == 'ne') {
                                    $('.FakturaBi').show();
                                    $('.FakturaBrojRacuna').val(objData.RacunId);
                                    $('.FakturaBrojIsecka').focus();
                                }
                                if ($('.NaplataButton[buton-action="MeniNaplata"]').hasClass('SelectedOption')) {
                                    $('.NaplataButton[buton-action="MeniNaplata"]').removeClass('SelectedOption');
                                    $('.MenuCena').val('');
                                    $('.MenuKolicina').val('');
                                    $('.MenuUkupno').val('');
                                    $('.SelectedMenuItem').removeAttr('menu-id');
                                    $('.SelectedMenuItem').removeAttr('menu-name');
                                    $('.MenuItem').removeClass('MenuSelected');
                                }
                                $('.Dostava').hide();
                                $('body').removeClass('PayForDelivery');
                                $('body').removeClass('DostavaActive');
                                if ($('body').hasClass('brzaNaplata')) {
                                    $('.SelectAction[actionid="QuickPayment"]').click();
                                }
                            } else if (objData.Status == 'pdfFaktura') {
                                window.open('./partials/pdfFaktura.php?id=' + fiskalniRacunId);
                                $('.Naplata').hide();
                                $('.Porudzbina').hide();
                            } else if (objData.Status) {
                                if (objData.Message == 'Istekla sesija ulogujte se ponovo!!!') {
                                    CreateWindowAlert(objData.Message, 'error');
                                    window.location = './logout.php';
                                } else {
                                    CreateWindowAlert(objData.Message, 'error');
                                }
                            } else {
                                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                            }
                            $('.StalniGosti tr').removeClass('SelectedGost');
                            $('.Loader').hide();
                        }
                    });
                }
            } else {
                CreateWindowAlert('Najpre odaberite način naplate!!!', 'error');
                $('.Loader').hide();
            }
        }
    } else {
        CreateWindowAlert('Uplaćeni iznos je manji od iznosa računa!!!', 'error');
        $('.Loader').hide();
    }
}
function CalcKombinovano() {
    var TotalRacun = $('.UkupnoValue').val();
    var TotalToPay = 0;
    $('.KombinovanoValue').each(function () {
        var ThisVal = $(this).val();
        if (ThisVal) {
            if ($(this).hasClass('FakturaValue')) {
                if (parseFloat(ThisVal) > parseFloat(TotalRacun)) {
                    CreateWindowAlert('Iznos naplate putem fakture mora biti jednak ukupno naplaćenom iznosu!!!', 'error');
                    return false;
                }
            }
            if ($(this).hasClass('CekValue') || $(this).hasClass('KarticaValue')) {
                if (parseFloat(ThisVal) > parseFloat(TotalRacun)) {
                    CreateWindowAlert('Iznos naplate putem čeka ili kartice mora biti manji ili jednak ukupno naplaćenom iznosu!!!', 'error');
                    return false;
                }
            }
            TotalToPay = parseFloat(TotalToPay) + parseFloat(ThisVal);
        }
    });
    $('.UplacenoValue').val(parseFloat(TotalToPay).toFixed(2));
}
function StornirajArtikle(Sto, Artikli) {
    $('.Loader').show();
    if ($('.StornoPassword').length) {
        var Sifra = $('.StornoInput').val();
        if (Sifra) {
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: {
                    StornoTable: Sto,
                    StornoLozinka: Sifra,
                    StornoItems: Artikli
                },
                error: function () {
                    $('.Loader').hide();
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                },
                complete: function (response) {
                    $('.Loader').hide();
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        if ($('.Dostava').length) {
                            GetSveDostave();
                        }
                        $('.RastavljanjeRight').html('');
                        $('.StornoPassword').hide();
                        $('.StornoInput').val('');
                        $('.Rastavljanje').hide();
                        $('.Porudzbina').hide();
                        CreateWindowAlert('Odabrani artikli su stornirani!', 'success');
                        if ($('body').hasClass('brzaNaplata')) {
                            $('.SelectAction[actionid="QuickPayment"]').click();
                        }
                    } else {
                        CreateWindowAlert(objData.Message, 'error');
                    }
                }
            });
        } else {
            $('.Loader').hide();
            CreateWindowAlert('Molimo vas da unesete lozinku za storno!!!', 'error');
        }
    } else {
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: {
                StornoTable: Sto,
                StornoItems: Artikli
            },
            error: function () {
                $('.Loader').hide();
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
            },
            complete: function (response) {
                $('.Loader').hide();
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    if ($('.Dostava').length) {
                        GetSveDostave();
                    }
                    $('.RastavljanjeRight').html('');
                    $('.StornoPassword').hide();
                    $('.StornoInput').val('');
                    $('.Rastavljanje').hide();
                    $('.Porudzbina').hide();
                    CreateWindowAlert('Odabrani artikli su stornirani!', 'success');
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                }
            }
        });
    }
}
function CalcRastavljanje() {
    $('.Rastavljanje .PoruceniArtikal').each(function () {
        var Cena = $(this).attr('cenaporucenog');
        var Kolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
        var Iznos = parseFloat(Cena) * parseFloat(Kolicina);
        $(this).find('.PorudzbinaArtikliIznos').first().html(parseFloat(Iznos).toFixed(2));
    });
}
function CalcMeni() {
    var MenuKolicina = $('.MenuKolicina').val();
    var MenuCena = $('.MenuCena').val();
    var TotalMeni = 0;
    if (parseFloat(MenuKolicina) > 0 && parseFloat(MenuCena) > 0) {
        var TotalMeni = parseFloat(MenuKolicina) * parseFloat(MenuCena);
    }
    $('.MenuUkupno').val(parseFloat(TotalMeni).toFixed(2));
}
function GetSveDostave() {
    $('.DostavaLista').html('');
    $('.DostavaAkcija').removeClass('SelectedDeliveryFilter');
    $.ajax({
        type: 'POST',
        url: './?modul=GetAjax',
        data: 'GetAllDeliveries=true',
        error: function () {
            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
        },
        complete: function (response) {
            var objData = jQuery.parseJSON(response.responseText);
            if (objData.Status == 'success') {
                $('.DostavaLista').html(objData.DeliveriesHtml);
            }
        }
    });
}
function SearchForDelivery() {
    setTimeout(function () {
        var DostavaTermin = $('.DostavaSearch').val().toLowerCase();
        if (DostavaTermin.length >= 3) {
            $(".DeliveriesTable tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(DostavaTermin) > -1);
            });
        } else {
            $(".DeliveriesTable tr").each(function () {
                $(this).show();
            });
        }
    }, 300);
}
function PrikaziStarePorudzbine() {
    var KupacId = $('.DostavaIme').attr('kupacdostavaid');
    $.ajax({
        type: 'POST',
        url: './?modul=GetAjax',
        data: 'GetAllBuyerDeliveries=' + KupacId,
        error: function () {
            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
        },
        complete: function (response) {
            var objData = jQuery.parseJSON(response.responseText);
            if (objData.Status == 'success') {
                $('.StareDostaveTop').html(objData.DeliveriesHtml);
                $('.StareDostave').show();
            } else {
                CreateWindowAlert(objData.Message, 'error');
            }
        }
    });
}
function GetArtikleZaRacun(RacunId) {
    $.ajax({
        type: 'POST',
        url: './?modul=GetAjax',
        data: 'GetInvoiceItems=' + RacunId,
        error: function () {
            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
        },
        complete: function (response) {
            var objData = jQuery.parseJSON(response.responseText);
            if (objData.Status == 'success') {
                $('.ArtikliExpanderList').html(objData.RacunHtml);
                $('.ArtikliExpander').show();
            } else {
                CreateWindowAlert(objData.Message, 'error');
            }
        }
    });
}
function PreuzmiSveGrupe() {
    $.ajax({
        type: 'POST',
        url: './?modul=GetAjax',
        data: 'GetAllGroupsChange=true',
        error: function () {
            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
        },
        complete: function (response) {
            var objData = jQuery.parseJSON(response.responseText);
            if (objData.Status == 'success') {
                $('.PodesavanjeGrupaLista').html(objData.HtmlToInsert);
            } else {
                CreateWindowAlert(objData.Message, 'error');
            }
        }
    });
}
function PreuzmiSvePodGrupe() {
    $.ajax({
        type: 'POST',
        url: './?modul=GetAjax',
        data: 'GetAllSubGroupsChange=true',
        error: function () {
            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
        },
        complete: function (response) {
            var objData = jQuery.parseJSON(response.responseText);
            if (objData.Status == 'success') {
                $('.PodesavanjePodGrupaLista').html(objData.HtmlToInsert);
                var HtmlPodgrupe = "";
                $('.PodesavanjePodGrupe').each(function () {
                    var PodgrupaId = $(this).attr('idpodgrupe');
                    var PodgrupaNaziv = $(this).attr('skrnaziv');
                    HtmlPodgrupe += "<option value='" + PodgrupaId + "'>" + PodgrupaNaziv + "</option>"
                });
                $('.CreateProductSubGroup').html(HtmlPodgrupe);
                $('.PodesavanjePretragaPodGrupa').html("<option value=''>Sve podgrupe</option>" + HtmlPodgrupe);
            } else {
                CreateWindowAlert(objData.Message, 'error');
            }
        }
    });
}
function PreuzmiSveStampace() {
    $.ajax({
        type: 'POST',
        url: './?modul=GetAjax',
        data: 'GetAllPrintersChange=true',
        error: function () {
            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
        },
        complete: function (response) {
            var objData = jQuery.parseJSON(response.responseText);
            if (objData.Status == 'success') {
                $('.PodesavanjeStampacaLista').html(objData.HtmlToInsert);
                var HtmlToAdd = "";
                $('.PodesavanjeStampac').each(function () {
                    var StampacId = $(this).attr('idstampaca');
                    var StampacNaziv = $(this).attr('bnaziv');
                    HtmlToAdd += "<label class='CreateGroupLabel'><span>" + StampacNaziv + "</span><input type='checkbox' name='CreateProductPrinter[]' class='CreateProductPrinter' value='" + StampacId + "' checked></label>";
                });
                $('.PodesavanjeArtikalaStampaci').html(HtmlToAdd);
            } else {
                CreateWindowAlert(objData.Message, 'error');
            }
        }
    });
}
function PreuzmiSveKonobare() {
    $.ajax({
        type: 'POST',
        url: './?modul=GetAjax',
        data: 'GetAllOperatorsChange=true',
        error: function () {
            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
        },
        complete: function (response) {
            var objData = jQuery.parseJSON(response.responseText);
            if (objData.Status == 'success') {
                $('.PodesavanjeKonobaraLista').html(objData.HtmlToInsert);
            } else {
                CreateWindowAlert(objData.Message, 'error');
            }
        }
    });
}
function PreuzmiSvePoreskeStope() {
    $.ajax({
        type: 'POST',
        url: './?modul=GetAjax',
        data: 'GetAllVats=true',
        error: function () {
            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
        },
        complete: function (response) {
            var objData = jQuery.parseJSON(response.responseText);
            if (objData.Status == 'success') {
                $('.PodesavanjeStopaLista').html(objData.HtmlToInsert);
            } else {
                CreateWindowAlert(objData.Message, 'error');
            }
        }
    });
}
function GetJournalData(PageNo) {
    var DateFrom = $('#DateFromJournal').val();
    var DateTo = $('#DateToJournal').val();
    $.ajax({
        type: 'POST',
        url: './?modul=GetAjax',
        data: "PregledJournala=true&JournalPage=" + PageNo + "&JournalPageFrom=" + DateFrom + "&JournalPageTo=" + DateTo,
        error: function () {
            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
        },
        complete: function (response) {
            var objData = jQuery.parseJSON(response.responseText);
            if (objData.Status == 'success') {
                $('.JournalSearchResults').html(objData.RacuniHtml);
                $('.JournalData').show();
            } else if (objData.Message != '') {
                CreateWindowAlert(objData.Message, 'error');
            } else {
                CreateWindowAlert('Nepoznata greska!', 'error');
            }
        }
    });
}
$(document).ready(function () {
    setTime();
    $(".Loader").click(function () {
        $(this).hide();
    });
    $("img").on('error', function () {
        $(this).remove();
    });
    $('.JournalSearchForm').on('submit', function (e) {
        GetJournalData(1);
        return false;
    });
    $('body').delegate('.ArtikliExpanderClose', 'click', function () {
        $('.ArtikliExpanderList').html('');
        $('.ArtikliExpander').hide();
    });
    $('.SelectGrafik').click(function () {
        var GrafikId = $(this).attr('grafikid');
        if (GrafikId) {
            RecalcGrafik(GrafikId);
        }
    });
    $('.Sto').click(function () {
        if ($(this).hasClass('Tudji') && window.UserLevel != 'SEF') {
            CreateWindowAlert('Ovaj sto je zauzet od strane drugog konobara!!!', 'error');
        } else {
            $('.TuraOpisiTop').html('');
            $('.ArtikalOpisiTop').html('');
            if ($('body').hasClass('TransferTables')) {
                if ($(this).attr('stoid') == $('.PorudzbinaSto').attr('sto-id')) {
                    $('body').removeClass('TransferTables');
                } else {
                    if ($('.RastavljanjeRight .PoruceniArtikal').length) {
                        $('.Loader').show();
                        var ArtikliZaPrebacivanje = [];
                        var StoNaKojiPrebacujemo = $(this).attr('stoid');
                        var StoSaKogaPrebacujemo = $('.PorudzbinaSto').attr('sto-id');
                        var Inc = 0;
                        $('.RastavljanjeRight .PoruceniArtikal').each(function () {
                            var StavkaId = $(this).attr('stavkaracunaid');
                            var Kolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
                            ArtikliZaPrebacivanje[Inc] = [StavkaId, Kolicina];
                            Inc++;
                        });
                        $.ajax({
                            type: 'POST',
                            url: './?modul=GetAjax',
                            data: {TransferItems: StoNaKojiPrebacujemo, ItemsToTransfer: ArtikliZaPrebacivanje, TransferFromTable: StoSaKogaPrebacujemo},
                            error: function () {
                                $('.Loader').hide();
                                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                            },
                            complete: function (response) {
                                $('.Loader').hide();
                                var objData = jQuery.parseJSON(response.responseText);
                                if (objData.Status == 'success') {
                                    $('body').removeClass('TransferTables');
                                    $('.RastavljanjeRight').html('');
                                } else if (objData.Status) {
                                    if (objData.Message == 'Istekla sesija ulogujte se ponovo!!!') {
                                        CreateWindowAlert(objData.Message, 'error');
                                        window.location = './logout.php';
                                    } else {
                                        CreateWindowAlert(objData.Message, 'error');
                                    }
                                } else {
                                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                }
                            }
                        });
                    } else {
                        $('body').removeClass('TransferTables');
                    }
                }
            } else if ($('body').hasClass('PromenaTables')) {
                $(this).toggleClass('OdabranStoZaPromenu');
            } else {
                if ($(this).hasClass('Zakljucan') && window.UserMedjuzbir != '1') {
                    if (window.UserLevel != 'SEF') {
                        $('.Porudzbina').hide();
                    } else {
                        $('.Porudzbina').show();
                    }
                } else {
                    $('.Porudzbina').show();
                }
                $('.TuraOpisiTop').html('');
                $('.ArtikalOpisiTop').html('');
                GetTableItems($(this).attr('stoid'));
                CalcTotal();
                $('.PorudzbinaSto').attr('sto-id', $(this).attr('stoid'));
                $('.PorudzbinaSto').html($(this).find('.StoNaziv').first().text());
                RearangeOrder();
            }
        }
    });

    /*
     if ($('.UnosBrojaStola').length) {
     $('.UnosBrojaStola').show();
     $('.UnosBrojaStolaInput').val('');
     $('.UnosBrojaStolaInput').focus();
     }
     */
    $('.ClosePorudzbina').click(function () {
        $('.Porudzbina').hide();
        GetAllTables();
    });

    $('body').delegate('.SelectGrafikForward', 'click', function () {
        var IdGrupe = $('.SelectGrafik:visible').last().attr('grafikid');
        var LastId = $('.SelectGrafik').last().attr('grafikid');
        if (LastId != IdGrupe) {
            var WhatIsLast = $('.SelectGrafik:visible').last();
            $(WhatIsLast).prevAll('.SelectGrafik').hide();
            $(WhatIsLast).hide();
            $(WhatIsLast).nextAll('.SelectGrafik').slice(0, 5).show();
        }
        if ($('.SelectGrafik:visible').length < 5) {
            $('.SelectGrafikForward').hide();
        } else {
            $('.SelectGrafikForward').show();
        }
    });
    $('body').delegate('.SelectGrafikBack', 'click', function () {
        var IdGrupe = $('.SelectGrafik:visible').first().attr('grafikid');
        var LastId = $('.SelectGrafik').first().attr('grafikid');
        if (LastId != IdGrupe) {
            var WhatIsFirst = $('.SelectGrafik:visible').first();
            $(WhatIsFirst).nextAll('.SelectGrafik').hide();
            $(WhatIsFirst).hide();
            $(WhatIsFirst).prevAll('.SelectGrafik').slice(0, 5).show();
        }
        if ($('.SelectGrafik:visible').length < 5) {
            $('.SelectGrafikForward').hide();
        } else {
            $('.SelectGrafikForward').show();
        }
    });
    $('body').delegate('.Grupa', 'click', function () {
        $('.Grupa').removeClass('GrupaSelected');
        $(this).addClass('GrupaSelected');
        var IdGrupe = $(this).attr('idgrupe');
        $('.PodGrupa').hide();
        var PodGrupeLength = $('.PodGrupa[idgrupe="' + IdGrupe + '"]').length;
        var PodgrupaNumber = window.broj_redova_podgrupa;
        var PodgrupaBroj = parseInt(PodgrupaNumber) * 4;
        var PodgrupaSlice = parseInt(PodgrupaBroj) - 2;
        if (PodGrupeLength <= PodgrupaBroj) {
            $('.BackPodGrupe').hide();
            $('.ForwardPodGrupe').hide();
            $('.PodGrupa[idgrupe="' + IdGrupe + '"]').show();
        } else {
            $('.BackPodGrupe').show();
            $('.ForwardPodGrupe').show();
            $('.PodGrupa[idgrupe="' + IdGrupe + '"]').slice(0, PodgrupaSlice).show();
        }
        if (window.prikaz_artikala == 'novi') {
            $('.PodGrupe').show();
            $('.Artikli').hide();
        } else {
            setTimeout(function () {
                $('.PodGrupa[idgrupe="' + IdGrupe + '"]').first().click();
            }, 50);
        }
    });
    $('body').delegate('.ForwardGrupe', 'click', function () {
        var IdGrupe = $('.Grupa:visible').last().attr('idgrupe');
        var LastId = $('.Grupa').last().attr('idgrupe');
        if (LastId != IdGrupe) {
            var WhatIsLast = $('.Grupa:visible').last();
            $(WhatIsLast).prevAll('.Grupa').hide();
            $(WhatIsLast).hide();
            $(WhatIsLast).nextAll('.Grupa').slice(0, 3).show();
        }
        if ($('.Grupa:visible').length < 3) {
            $('.ForwardGrupe').hide();
        } else {
            $('.ForwardGrupe').show();
        }
    });
    $('body').delegate('.BackGrupe', 'click', function () {
        var IdGrupe = $('.Grupa:visible').first().attr('idgrupe');
        var LastId = $('.Grupa').first().attr('idgrupe');
        if (LastId != IdGrupe) {
            var WhatIsFirst = $('.Grupa:visible').first();
            $(WhatIsFirst).nextAll('.Grupa').hide();
            $(WhatIsFirst).hide();
            $(WhatIsFirst).prevAll('.Grupa').slice(0, 3).show();
        }
        if ($('.Grupa:visible').length < 3) {
            $('.ForwardGrupe').hide();
        } else {
            $('.ForwardGrupe').show();
        }
    });
    $('body').delegate('.PodGrupa', 'click', function () {
        $('.PodGrupa').removeClass('PodGrupaSelected');
        $(this).addClass('PodGrupaSelected');
        var IdPodGrupe = $(this).attr('idpodgrupe');
        $('.Artikal').hide();
        var ArtikliLength = $('.Artikal[idpodgrupe="' + IdPodGrupe + '"]').length;
        var AtikliNumber = window.broj_redova_artikala;
        var ArtikliBroj = parseInt(AtikliNumber) * 4;
        var ArtikliSlice = parseInt(ArtikliBroj) - 2;
        if (window.prikaz_artikala == 'novi') {
            ArtikliBroj = parseInt(ArtikliBroj) - 1;
            ArtikliSlice = parseInt(ArtikliSlice) - 1;
            $('.PodGrupe').hide();
            $('.Artikli').show();
        }
        if (ArtikliLength <= ArtikliBroj) {
            $('.BackArtikli').hide();
            $('.ForwardArtikli').hide();
            $('.Artikal[idpodgrupe="' + IdPodGrupe + '"]').show();
        } else {
            $('.BackArtikli').show();
            $('.ForwardArtikli').show();
            $('.Artikal[idpodgrupe="' + IdPodGrupe + '"]').slice(0, ArtikliSlice).show();
        }
    });
    $('body').delegate('.ForwardPodGrupe', 'click', function () {
        var IdGrupe = $('.GrupaSelected').attr('idgrupe');
        var IdPodGrupe = $('.PodGrupa:visible').last().attr('idpodgrupe');
        var LastId = $('.PodGrupa[idgrupe="' + IdGrupe + '"]').last().attr('idpodgrupe');
        var PodgrupaNumber = window.broj_redova_podgrupa;
        var PodgrupaBroj = parseInt(PodgrupaNumber) * 4;
        var PodgrupaSlice = parseInt(PodgrupaBroj) - 2;
        if (LastId != IdPodGrupe) {
            var WhatIsLast = $('.PodGrupa:visible').last();
            $(WhatIsLast).prevAll('.PodGrupa').hide();
            $(WhatIsLast).hide();
            $(WhatIsLast).nextAll('.PodGrupa[idgrupe="' + IdGrupe + '"]').slice(0, PodgrupaSlice).show();
        }
        if ($('.PodGrupa:visible').length < PodgrupaSlice) {
            $('.ForwardPodGrupe').hide();
        } else {
            $('.ForwardPodGrupe').show();
        }
    });
    $('body').delegate('.AktivniStoloviPotvrdi', 'click', function () {
        if ($('.AktivniStoloviSelected').length) {
            var StoId = $('.AktivniStoloviSelected').attr('idstola');
            var NazivStola = $('.AktivniStoloviSelected').find('.AktivniStoloviSto').first().html();
            if (NazivStola == '') {
                NazivStola = StoId;
            }
            $('.Porudzbina').show();
            GetTableItems(StoId);
            $('.AktivniStolovi').hide();
            $('.PorudzbinaSto').attr('sto-id', StoId);
            $('.PorudzbinaSto').html(NazivStola);
            $('.TuraOpisiTop').html('');
            $('.ArtikalOpisiTop').html('');
            RearangeOrder();
        } else {
            CreateWindowAlert('Najpre odaberite sto!', 'error');
        }
    });
    $('body').delegate('.BackPodGrupe', 'click', function () {
        var IdGrupe = $('.GrupaSelected').attr('idgrupe');
        var IdPodGrupe = $('.PodGrupa:visible').first().attr('idpodgrupe');
        var LastId = $('.PodGrupa[idgrupe="' + IdGrupe + '"]').first().attr('idpodgrupe');
        var PodgrupaNumber = window.broj_redova_podgrupa;
        var PodgrupaBroj = parseInt(PodgrupaNumber) * 4;
        var PodgrupaSlice = parseInt(PodgrupaBroj) - 2;
        if (LastId != IdPodGrupe) {
            var WhatIsFirst = $('.PodGrupa:visible').first();
            $(WhatIsFirst).nextAll('.PodGrupa').hide();
            $(WhatIsFirst).hide();
            $(WhatIsFirst).prevAll('.PodGrupa[idgrupe="' + IdGrupe + '"]').slice(0, PodgrupaSlice).show();
        }
        if ($('.PodGrupa:visible').length < PodgrupaSlice) {
            $('.ForwardPodGrupe').hide();
        } else {
            $('.ForwardPodGrupe').show();
        }
    });
    $('body').delegate('.ForwardArtikli', 'click', function () {
        var IdPodGrupe = $('.PodGrupaSelected').attr('idpodgrupe');
        var IdArtikla = $('.Artikal:visible').last().attr('idartikla');
        var LastId = $('.Artikal[idpodgrupe="' + IdPodGrupe + '"]').last().attr('idartikla');
        var AtikliNumber = window.broj_redova_artikala;
        var ArtikliBroj = parseInt(AtikliNumber) * 4;
        var ArtikliSlice = parseInt(ArtikliBroj) - 2;
        if (window.prikaz_artikala == 'novi') {
            ArtikliBroj = parseInt(ArtikliBroj) - 1;
            ArtikliSlice = parseInt(ArtikliSlice) - 1;
        }
        if (LastId != IdArtikla) {
            var WhatIsLast = $('.Artikal:visible').last();
            $(WhatIsLast).prevAll('.Artikal').hide();
            $(WhatIsLast).hide();
            $(WhatIsLast).nextAll('.Artikal[idpodgrupe="' + IdPodGrupe + '"]').slice(0, ArtikliSlice).show();
        }
        if ($('.Artikal:visible').length < ArtikliSlice) {
            $('.ForwardArtikli').hide();
        } else {
            $('.ForwardArtikli').show();
        }
    });
    $('body').delegate('.BackArtikli', 'click', function () {
        var IdPodGrupe = $('.PodGrupaSelected').attr('idpodgrupe');
        var IdArtikla = $('.Artikal:visible').first().attr('idartikla');
        var LastId = $('.Artikal[idpodgrupe="' + IdPodGrupe + '"]').first().attr('idartikla');
        var AtikliNumber = window.broj_redova_artikala;
        var ArtikliBroj = parseInt(AtikliNumber) * 4;
        var ArtikliSlice = parseInt(ArtikliBroj) - 2;
        if (window.prikaz_artikala == 'novi') {
            ArtikliBroj = parseInt(ArtikliBroj) - 1;
            ArtikliSlice = parseInt(ArtikliSlice) - 1;
        }
        if (LastId != IdArtikla) {
            var WhatIsFirst = $('.Artikal:visible').first();
            $(WhatIsFirst).nextAll('.Artikal').hide();
            $(WhatIsFirst).hide();
            $(WhatIsFirst).prevAll('.Artikal[idpodgrupe="' + IdPodGrupe + '"]').slice(0, ArtikliSlice).show();
        }
        if ($('.Artikal:visible').length < ArtikliSlice) {
            $('.ForwardArtikli').hide();
        } else {
            $('.ForwardArtikli').show();
        }
    });
    $('body').delegate('.NazadNaPodgrupe', 'click', function () {
        $('.PodGrupe').show();
        $('.Artikli').hide();
    });
    $('body').delegate('.PorudzbinaRightAkcija', 'click', function () {
        var StaRadi = $(this).attr('dugmeaction');
        if (StaRadi == 'Odustani') {
            $('.Porudzbina').hide();
            $('.UnosBrojaStolaInput').val('');
            $('body').removeClass('PayQuickPayment');
            $('body').removeClass('PayForDelivery');
            $('body').removeClass('DostavaActive');
            if ($('body').hasClass('brzaNaplata')) {
                $('.SelectAction[actionid="QuickPayment"]').click();
            }
        } else if (StaRadi == 'PretragaArtikla') {
            $('.PretragaArtikala').show();
            $('.PretragaArtikalaInput').val('');
            $('.PretragaArtikalaRezultati').html('');
        } else if (StaRadi == 'Rastavljanje') {
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: 'ZahtevajSifruZaRastavljanje=true',
                error: function () {
                    $('.Loader').hide();
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                },
                complete: function (response) {
                    $('.Loader').hide();
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.zahtevajSifru == 'true') {
                        if ($('.RastavljanjePassword').length) {
                            $('.RastavljanjePassword').show();
                            $('.RastavljanjePassInput').val('');
                            $('.RastavljanjePassInput').focus();
                        }
                    } else {
                        $('.Rastavljanje').show();
                        var RastavljanjeHeight = $('.RastavljanjeCenter').height();
                        var NewButtonHeight = (parseFloat(RastavljanjeHeight) / 6) - 1;
                        $('.RastavljanjeAction').attr('style', 'height: ' + NewButtonHeight + 'px; line-height: ' + NewButtonHeight + 'px;');
                        $('.RastavljanjeSto').html($('.PorudzbinaSto').html());
                        $('.RastavljanjeLeft').html($('.StariArtikli').html());
                        $('.RastavljanjeLeft').prepend('<div class="RastavljanjeGosti"></div>');
                        $('.GostiAkcije .GostAkcija').each(function () {
                            var GostBroj = $(this).attr('gost-number');
                            $('.RastavljanjeGosti').append('<div class="RastavljanjeGostAkcija ActiveGostAkcija" gost-number="' + GostBroj + '">G' + GostBroj + '</div>');
                        });
                        $('.RastavljanjeGosti .RastavljanjeGostAkcija').first().click();
                        $('.RastavljanjeRight').html('');
                    }
                }
            });
        } else if (StaRadi == 'Potvrdi') {
            PosaljiPorudzbinu();
        } else if (StaRadi == 'Storno') {
            if ($('.StornoPassword').length) {
                $('.StornoPassword').show();
                $('.StornoInput').val('');
                $('.StornoInput').focus();
            } else {
                var Inc = 0;
                $('.PorudzbinaArtikliBody .PoruceniArtikal').each(function () {
                    var StavkaId = $(this).attr('stavkaracunaid');
                    var Kolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
                    ArtikliStorno[Inc] = [StavkaId, Kolicina];
                    Inc++;
                });
                var StoStorno = $('.PorudzbinaSto').attr('sto-id');
                StornirajArtikle(StoStorno, ArtikliStorno);
            }
        } else if (StaRadi == 'Opis') {
            if ($('.PoruceniArtikal').length) {
                $('.OpisPorudzbine').show(500);
                $('.OpisPorudzbineHeaderStavka[selectoption="Artikal"]').click();
                if ($('.OdabraniArtikal').length) {
                    var PoruceniArtikal = $('.OdabraniArtikal').attr('idporucenog');
                } else {
                    $('.ActiveGostArtikli .PoruceniArtikal').last().addClass('OdabraniArtikal');
                    var PoruceniArtikal = $('.ActiveGostArtikli .PoruceniArtikal').last().attr('idporucenog');
                }
                $.ajax({
                    type: 'POST',
                    url: './?modul=GetAjax',
                    data: "DajSveOpiseZaArtikal=" + PoruceniArtikal,
                    error: function () {
                        CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                    },
                    complete: function (response) {
                        var objData = jQuery.parseJSON(response.responseText);
                        if (objData.Status == 'success') {
                            $('.ArtikalOpisiBottom').html(objData.OpisiNewHtml);
                        } else {
                            $('.ArtikalOpisiBottom').html('');
                        }
                    }
                });
            } else {
                CreateWindowAlert('Nema otvorene porudžbine za koju se može dodati opis!!!', 'error');
            }
        } else if (StaRadi == 'Naplata') {
            var TotalToPay = $('.PorudzbinaTotalValue').html();
            if (parseFloat(TotalToPay) <= 0) {
                CreateWindowAlert('Iznos računa mora biti veći od 0!!!', 'error');
                return false;
            }
            $('.StalniGostValue').removeAttr('komitent-id');
            $('.OFVrstaRacuna').val($('.OFVrstaRacuna').attr('default-value'));
            $('.OFPibKupcaID').val($('.OFPibKupcaID').attr('default-value'));
            $('.OFOpcionoPoljeKupcaID').val($('.OFOpcionoPoljeKupcaID').attr('default-value'));
            $('.OFPibKupca').val("");
            $('.OFOpcionoPoljeKupca').val("");
            $('.OFReferentniBrojKupca').val("");
            $('.NaplataButton').removeClass('SelectedPredracunOption');
            if ($('.StariArtikli').length || $('body').hasClass('PayQuickPayment')) {
                var IznosValue = $('.PorudzbinaTotalValue').html();
                if ($('.PoruceniArtikal').length) {
                    $('.Naplata').show(500);
                    $('.IznosValue').val(parseFloat(IznosValue).toFixed(2));
                    $('.PopustValue').val('0.00');
                    $('.UkupnoValue').val(parseFloat(IznosValue).toFixed(2));
                    $('.UplacenoValue').val(parseFloat(IznosValue).toFixed(2));
                    $('.KusurValue').val('0.00');
                    $('.KombinovanoValue').each(function () {
                        $(this).val('');
                    });
                    $(".ArtikliZaNaplatuSadrzaj").html('');
                    $('.PorudzbinaArtikliBody .PoruceniArtikal').each(function () {
                        var ArtikalId = $(this).attr('idporucenog');
                        var ArtikalTip = $(this).attr('tipporucenog');
                        var ArtikalPrice = $(this).attr('cenaporucenog');
                        var ArtikalKolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
                        if ($('.ArtikliZaNaplatu .PoruceniArtikal[idporucenog="' + ArtikalId + '"][cenaporucenog="' + ArtikalPrice + '"]').length) {
                            var Kolicina = $('.ArtikliZaNaplatu .PoruceniArtikal[idporucenog="' + ArtikalId + '"][cenaporucenog="' + ArtikalPrice + '"]').find('.PorudzbinaArtikliKolicina').first().html();
                            var NewKolicina = parseFloat(ArtikalKolicina) + parseFloat(Kolicina);
                            var NovaVrednost = parseFloat(NewKolicina) * parseFloat(ArtikalPrice);
                            $('.ArtikliZaNaplatu .PoruceniArtikal[idporucenog="' + ArtikalId + '"][cenaporucenog="' + ArtikalPrice + '"]').find('.PorudzbinaArtikliKolicina').first().html(NewKolicina);
                            $('.ArtikliZaNaplatu .PoruceniArtikal[idporucenog="' + ArtikalId + '"][cenaporucenog="' + ArtikalPrice + '"]').find('.PorudzbinaArtikliIznos').first().html(parseFloat(NovaVrednost).toFixed(2));
                        } else {
                            var ArtikalHtml = '<div class="PoruceniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '">' + $(this).html() + '</div>';
                            $('.ArtikliZaNaplatuSadrzaj').append(ArtikalHtml);
                        }
                    });
                    $(".ArtikliZaNaplatuSadrzaj").scrollTop($(".ArtikliZaNaplatuSadrzaj")[0].scrollHeight);

                    if ($('.NaplataButton[buton-action="Kombinovano"]').hasClass('SelectedOption')) {
                        $('.NaplataButton[buton-action="Kombinovano"]').click();
                    }
                    if ($('.NaplataButton[buton-action="Gotovinski"]').hasClass('SelectedOption')) {
                        $('.NaplataButton[buton-action="Gotovinski"]').click();
                    }
                    $('.BeloNaplata').removeClass('SelectedNaplata');
                    $('.CrnoNaplata').removeClass('SelectedNaplata');
                    //$('.BeloNaplata').last().click();
                    setTimeout(function () {
                        var BeloLength = $('.BeloNaplata').length;
                        var InitialHeight = $('.NaplataOpcije').height();
                        var RightKeysHeight = (parseFloat(InitialHeight) / parseFloat(BeloLength));
                        var NumericKeysHeight = (parseFloat(InitialHeight) / 4);
                        $('.BeloNaplata').attr('style', 'height:' + parseInt(RightKeysHeight) + 'px; line-height: ' + parseInt(RightKeysHeight) + 'px;');
                        $('.CrnoNaplata').attr('style', 'height:' + parseInt(RightKeysHeight) + 'px; line-height: ' + parseInt(RightKeysHeight) + 'px;');
                        $('.NaplataNumeric').attr('style', 'height:' + parseInt(NumericKeysHeight) + 'px; line-height: ' + parseInt(NumericKeysHeight) + 'px;');
                        $('.UplacenoValue').focus().select();
                    }, 500);
                    setTimeout(function () {
                        var ArtikliZaNaplatuVelicina = $('.Naplata').height() - $('.NaplataTop').height() - $('.NaplataBottom').height() - $('.NaplataOpcije .NaplataLeft').height() - $('.ArtikliZaNaplatuTitle').height();
                        $('.ArtikliZaNaplatuSadrzaj').height(ArtikliZaNaplatuVelicina);
                    }, 1000);
                } else {
                    CreateWindowAlert('Nema artikala za naplatu!!!', 'error');
                }
            } else {
                CreateWindowAlert('Nema artikala za naplatu!!!', 'error');
            }
        } else if (StaRadi == 'PrethodnePorudzbine') {
            PrikaziStarePorudzbine();
        } else if (StaRadi == 'Admin') {
            $('.SelectAction[actionid="Admin"]').click();
        } else if (StaRadi == 'Gotovinski') {
            $('.SelectAction[actionid="Gotovinski"]').click();
        } else if (StaRadi == 'Dostava') {
            $('.SelectAction[actionid="Dostava"]').click();
        } else if (StaRadi == 'Gotovina') {
            var TotalToPay = $('.PorudzbinaTotalValue').html();
            if (parseFloat(TotalToPay) <= 0) {
                CreateWindowAlert('Iznos računa mora biti veći od 0!!!', 'error');
                return false;
            }
            $('.UkupnoValue').val(TotalToPay);
            $('.UplacenoValue').val(TotalToPay);
            $('.PorudzbinaRightAkcija[dugmeaction="Naplata"]').click();
            $('.BeloNaplata[belo-opcija="GOTOVINA"]').click();
        } else if (StaRadi == 'HotelskiGost') {
            GetAllHotelGuests();
        } else {
        }
    });
    $('.KombinovanoValue').on('focusin', function () {
        $('.CrnoNaplata').removeClass('SelectedNaplata');
        $('.BeloNaplata').removeClass('SelectedNaplata');
        $(this).parents('.BeloNaplata').first().addClass('SelectedNaplata');
        var TotalPaid = 0;
        $('.BeloNaplata').each(function () {
            if (!$(this).hasClass('SelectedNaplata')) {
                var ThisVal = $(this).find('.KombinovanoValue').first().val();
                if (ThisVal) {
                    TotalPaid = parseFloat(TotalPaid) + parseFloat(ThisVal);
                }
            }
        });
        var TotalToPay = $('.UkupnoValue').val();
        var Remains = parseFloat(TotalToPay) - parseFloat(TotalPaid);
        if (parseFloat(Remains) > 0) {
            if ($('.SelectedNaplata').find('.KombinovanoValue').first().val() == '' || parseInt($('.SelectedNaplata').find('.KombinovanoValue').first().val()) == 0) {
                $('.SelectedNaplata').find('.KombinovanoValue').first().val(parseFloat(Remains).toFixed(2)).select();
            } else {
                $('.SelectedNaplata').find('.KombinovanoValue').first().select();
            }
        } else {
            $('.SelectedNaplata').find('.KombinovanoValue').first().select();
        }
        CalcKombinovano();
        CalcKusur();
    });
    $('body').delegate('.BeloNaplata', 'click', function () {
        if ($('.NaplataButton[buton-action="Kombinovano"]').hasClass('SelectedOption')) {
            $('.CrnoNaplata').removeClass('SelectedNaplata');
            $('.BeloNaplata').removeClass('SelectedNaplata');
            $(this).addClass('SelectedNaplata');
            var TotalPaid = 0;
            $('.BeloNaplata').each(function () {
                if (!$(this).hasClass('SelectedNaplata')) {
                    var ThisVal = $(this).find('.KombinovanoValue').first().val();
                    if (ThisVal) {
                        TotalPaid = parseFloat(TotalPaid) + parseFloat(ThisVal);
                    }
                }
            });
            var TotalToPay = $('.UkupnoValue').val();
            var Remains = parseFloat(TotalToPay) - parseFloat(TotalPaid);
            if (parseFloat(Remains) > 0) {
                if ($('.SelectedNaplata').find('.KombinovanoValue').first().val() == '') {
                    $('.SelectedNaplata').find('.KombinovanoValue').first().val(parseFloat(Remains).toFixed(2)).select();
                } else {
                    $('.SelectedNaplata').find('.KombinovanoValue').first().select();
                }
            } else {
                $('.SelectedNaplata').find('.KombinovanoValue').first().select();
            }
            CalcKombinovano();
            CalcKusur();
        } else {
            $('.CrnoNaplata').removeClass('SelectedNaplata');
            $('.BeloNaplata').removeClass('SelectedNaplata');
            $(this).addClass('SelectedNaplata');
            //var TotalToPay = $('.UkupnoValue').val();
            //$('.UplacenoValue').val(TotalToPay);
            CalcKusur();
            NaplatiRacun();
        }
    });
    $('body').delegate('.CrnoNaplata', 'click', function () {
        var OpcijaPlacanja = $(this).attr('crno-opcija');
        var Sto = $('.PorudzbinaSto').attr('sto-id');
        if ($('.NaplataButton[buton-action="Kombinovano"]').hasClass('SelectedOption')) {
            $('.NaplataButton[buton-action="Kombinovano"]').click();
        }
        $('.CrnoNaplata').removeClass('SelectedNaplata');
        $('.BeloNaplata').removeClass('SelectedNaplata');
        $(this).addClass('SelectedNaplata');
        //var TotalToPay = $('.UkupnoValue').val();
        //$('.UplacenoValue').val(TotalToPay);
        if ($('.Sto[stoid="' + Sto + '"]').hasClass('Zakljucan')) {
            var NaplacenPutem = $('.Sto[stoid="' + Sto + '"]').attr('nacinnaplate');
            if (NaplacenPutem == OpcijaPlacanja) {
                if (window.UserMedjuzbir != "1" && window.UserLevel != "SEF") {
                    $('.OtkljucavanjeStola').show();
                    return false;
                }
            }
        }
        NaplatiRacun();
    });
    $('body').delegate('.NaplataButton', 'click', function () {
        var WhatIsClicked = $(this).attr('buton-action');
        if (WhatIsClicked == 'Odustani') {
            $('.Naplata').hide(500);
            $('body').removeClass('PayTransferedTables');
            $('.SelectedMenuItem').removeAttr('menu-id');
            $('.SelectedMenuItem').removeAttr('menu-name');
            $('.MenuCena').val('');
            $('.MenuKolicina').val('');
            $('.MenuUkupno').val('');
            $('.MenuItem').removeClass('MenuSelected');
            $('.NaplataButton[buton-action="MeniNaplata"]').removeClass('SelectedOption');
            $('.StalniGostValue').removeAttr('stalnigost-id');
            $('.StalniGostValue').removeAttr('komitent-id');
            $('.StalniGostValue').val('');
            $('.StalniGosti tr').removeClass('SelectedGost');
            $('.PopustPercentValue').val('');
        } else if (WhatIsClicked == 'Predracun') {
            $(this).toggleClass('SelectedPredracunOption');
            if ($(this).hasClass('SelectedPredracunOption')) {
                $('.OFVrstaRacuna').val('Proforma');
            } else {
                $('.OFVrstaRacuna').val($('.OFVrstaRacuna').attr('default-value'));
            }
        } else if (WhatIsClicked == 'Refakcija') {
            $('.OdabirRefakcije').show();
        } else if (WhatIsClicked == 'Gotovinski') {
            $(this).toggleClass('SelectedOption');
            var Efiskal = "ne";
            if ($('.Efiskalizacija').length) {
                Efiskal = "da";
            }
            if (Efiskal == "ne") {
                if ($(this).hasClass('SelectedOption')) {
                    $('.NaplataLeft').hide();
                } else {
                    $('.NaplataLeft').show();
                }
            }
        } else if (WhatIsClicked == 'Kombinovano') {
            $('.NaplataRight').toggleClass('KombinovanoActivated');
            if ($('.NaplataRight').hasClass('KombinovanoActivated')) {
                $('.BeloNaplata:visible').first().find('.KombinovanoValue').first().focus();
                $('.CrnoNaplata').hide();
            } else {
                $('.UplacenoValue').focus();
                $('.CrnoNaplata').show();
            }
            $(this).toggleClass('SelectedOption');
        } else if (WhatIsClicked == 'Potvrdi') {
            NaplatiRacun();
        } else if (WhatIsClicked == 'StalniGost') {
            $('.StalniGosti').show();
            $('.StalniGosti input').each(function () {
                $(this).val('');
            });
            $('.SearchStalniGosti tbody tr').hide();
            $('.StalniGosti tbody tr').removeClass('SelectedGost');
            var IznosValue = $('.IznosValue').val();
            var PopustValue = 0;
            $('.PopustValue').val(parseFloat(PopustValue).toFixed(2));
            $('.UkupnoValue').val(parseFloat(IznosValue).toFixed(2));
            $('.StalniGostValue').removeAttr('stalnigost-id');
            $('.StalniGostValue').removeAttr('komitent-id');
            $('.StalniGostValue').val('');
            $('.PopustPercentValue').val('');
            CalcKusur();

            $('.GrupeGostiju').removeAttr('style');
            var TotalHeight = $('.StalniGostiRight').height();
            var TotalNumber = $('.GrupeGostiju').length;
            var NewHeight = parseFloat(TotalHeight) / parseFloat(TotalNumber);
            $('.GrupeGostiju').attr('style', 'height: ' + NewHeight + 'px; line-height: ' + NewHeight + 'px;');
            $('.FindGuest').focus();
            $('.StalniGosti input').removeClass('StalniFocus');
            $('.FindGuest').addClass('StalniFocus');
        } else if (WhatIsClicked == 'MeniNaplata') {
            $('.Meni').show();
            setTimeout(function () {
                var KeysHeight = $('.MenuKeys').height() / 4;
                $('.MenuKey').attr('style', 'height: ' + KeysHeight + 'px; line-height: ' + KeysHeight + 'px;');
            }, 100);
            var MenuItemId = $('.SelectedMenuItem').attr('menu-id');
            if (parseInt(MenuItemId)) {
                $('.MenuItem[menu-id="' + MenuItemId + '"]').click();
            }
            var Sto = $('.PorudzbinaSto').attr('sto-id');
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: "GetRecurePrice=" + Sto,
                error: function () {
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                },
                complete: function (response) {
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        $('.MenuNabavna').val(objData.RecurePrice);
                    } else {
                        CreateWindowAlert(objData.Message, 'error');
                    }
                }
            });
        } else if (WhatIsClicked == 'FiksniPopust') {
            $('.FiksniPopustValue').val('');
            $('.FiksniPopust').show();
            $('.FiksniPopustValue').focus();
        } else {
            CreateWindowAlert('Nepoznata akcija!!!', 'error');
        }
    });
    $('body').delegate('.OpisPorudzbineHeaderStavka', 'click', function () {
        $('.OpisPorudzbineHeaderStavka').removeClass('OpisPorudzbineOdabranaStavka');
        var WhatToShow = $(this).attr('selectoption');
        $('.OpisPorudzbineBodyStavka').hide();
        $('.OpisPorudzbineHeaderStavka[selectoption="' + WhatToShow + '"]').addClass('OpisPorudzbineOdabranaStavka');
        $('.OpisPorudzbineBodyStavka[selectoption="' + WhatToShow + '"]').show();
        $('.OpisPorudzbineBodyStavka[selectoption="' + WhatToShow + '"] div[contenteditable]').first().focus();
    });
    $('body').delegate('.FiksniPopustKey', 'click', function () {
        var WhatIsClicked = $(this).attr('popust-key');
        var WhatIsInside = $('.FiksniPopustValue').val();
        if (WhatIsClicked == 'Odustani') {
            $('.FiksniPopust').hide();
            $('.FiksniPopustValue').val('');
        } else if (WhatIsClicked == 'Potvrdi') {
            var NewValue = WhatIsInside;
            var TotalInvoice = 0;
            if ($('body').hasClass('PayTransferedTables')) {
                $('.RastavljanjeRight .PoruceniArtikal').each(function () {
                    var IdArtikla = $(this).attr('idporucenog');
                    var IznosPorucenog = $(this).find('.PorudzbinaArtikliIznos').first().html();
                    var MozePopust = $('.Artikal[idartikla="' + IdArtikla + '"]').first().attr('dozvoljenpopust');
                    if (MozePopust == 1) {
                        TotalInvoice = parseFloat(TotalInvoice) + parseFloat(IznosPorucenog);
                    }
                });
            } else {
                $('.PorudzbinaArtikliBody .PoruceniArtikal').each(function () {
                    var IdArtikla = $(this).attr('idporucenog');
                    var IznosPorucenog = $(this).find('.PorudzbinaArtikliIznos').first().html();
                    var MozePopust = $('.Artikal[idartikla="' + IdArtikla + '"]').first().attr('dozvoljenpopust');
                    if (MozePopust == 1) {
                        TotalInvoice = parseFloat(TotalInvoice) + parseFloat(IznosPorucenog);
                    }
                });
            }
            if (parseFloat(NewValue) < parseFloat(TotalInvoice)) {
                var Percentage = (parseFloat(NewValue) / parseFloat(TotalInvoice)) * 100;
                $('.PopustValue').val(NewValue);
                $('.PopustPercentValue').val(Percentage);
                $('.FiksniPopust').hide();
                var OldTotal = $('.IznosValue').val();
                var NewTotal = parseFloat(OldTotal) - parseFloat(NewValue);
                $('.UkupnoValue').val(parseFloat(NewTotal).toFixed(2));
                $('.UplacenoValue').val(parseFloat(NewTotal).toFixed(2)).focus().select();
                CalcKusur();
            } else {
                TotalInvoice = parseFloat(TotalInvoice) - 0.01;
                CreateWindowAlert('Maksimalni iznos popusta je: ' + parseFloat(TotalInvoice).toFixed(2) + '!!!', 'error');
            }
        } else if (WhatIsClicked == '.') {
            if (!WhatIsInside.contains('.')) {
                $('.FiksniPopustValue').val(WhatIsInside + "" + WhatIsClicked);
            } else {
                CreateWindowAlert('Ova akcija nije dozvoljena!!!', 'error');
            }
        } else if (WhatIsClicked == 'Delete') {
            if (WhatIsInside != '') {
                $('.FiksniPopustValue').val(WhatIsInside.substring(0, WhatIsInside.length - 1));
            }
        } else {
            var NewValue = WhatIsInside + "" + WhatIsClicked;
            var TotalInvoice = 0;
            if ($('body').hasClass('PayTransferedTables')) {
                $('.RastavljanjeRight .PoruceniArtikal').each(function () {
                    var IdArtikla = $(this).attr('idporucenog');
                    var IznosPorucenog = $(this).find('.PorudzbinaArtikliIznos').first().html();
                    var MozePopust = $('.Artikal[idartikla="' + IdArtikla + '"]').first().attr('dozvoljenpopust');
                    if (MozePopust == 1) {
                        TotalInvoice = parseFloat(TotalInvoice) + parseFloat(IznosPorucenog);
                    }
                });
            } else {
                $('.PorudzbinaArtikliBody .PoruceniArtikal').each(function () {
                    var IdArtikla = $(this).attr('idporucenog');
                    var IznosPorucenog = $(this).find('.PorudzbinaArtikliIznos').first().html();
                    var MozePopust = $('.Artikal[idartikla="' + IdArtikla + '"]').first().attr('dozvoljenpopust');
                    if (MozePopust == 1) {
                        TotalInvoice = parseFloat(TotalInvoice) + parseFloat(IznosPorucenog);
                    }
                });
            }
            if (parseFloat(NewValue) < parseFloat(TotalInvoice)) {
                $('.FiksniPopustValue').val(WhatIsInside + "" + WhatIsClicked);
            } else {
                TotalInvoice = parseFloat(TotalInvoice) - 0.01;
                CreateWindowAlert('Maksimalni iznos popusta je: ' + parseFloat(TotalInvoice).toFixed(2) + '!!!', 'error');
            }
        }
    });
    $('.AktivniStoloviOtkazi').click(function () {
        $('.AktivniStolovi').hide();
    });
    $('body').delegate('.AktivniStoloviRed', 'click', function () {
        $('.AktivniStoloviRed').removeClass('AktivniStoloviSelected');
        $(this).addClass('AktivniStoloviSelected');
        $('.AktivniStoloviRed').get(0).scrollIntoView();
    });
    $('body').delegate('.AktivniStoloviGore', 'click', function () {
        if ($('.AktivniStoloviSelected').length) {
            $('.AktivniStoloviSelected').prev('.AktivniStoloviRed').click()
        } else {
            $('.AktivniStoloviRed').last().click();
        }
    });
    $('body').delegate('.AktivniStoloviDole', 'click', function () {
        if ($('.AktivniStoloviSelected').length) {
            $('.AktivniStoloviSelected').next('.AktivniStoloviRed').click()
        } else {
            $('.AktivniStoloviRed').first().click();
        }
    });
    $('body').delegate('.Artikal', 'click', function () {
        if ($('.StariArtikli').length) {
            $('.PorudzbinaArtikliBody').html('');
            $('.GostiAkcije .GostAkcija').each(function () {
                var WhatIs = $(this).attr('gost-number');
                var HasClass = '';
                if ($(this).hasClass('ActiveGostAkcija')) {
                    HasClass = 'ActiveGostArtikli';
                }
                $('.PorudzbinaArtikliBody').append('<div class="GostArtikli ' + HasClass + '" gost-broj="' + WhatIs + '"></div>');
            });
        }
        var SelectedGost = $('.ActiveGostAkcija').attr('gost-number');
        if (!SelectedGost) {
            SelectedGost = 1;
        }
        var ArtikalId = $(this).attr('idartikla');
        var ArtikalName = $(this).find('span').first().text();
        var ArtikalPrice = $(this).attr('cenaartikla');
        var ArtikalTip = $(this).attr('tipartikla');
        var ArtikalNewPrice = 0;
        if (ArtikalTip == "DODA" && !$('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').length) {
            CreateWindowAlert('Nema artikla na koji se može dodati dodatak!!!', 'error');
            return false;
        }
        if ($('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').length) {
            if (ArtikalTip != "DODA") {
                if ($('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().find('.OpisArtikla').length || $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().hasClass('ImaDodatni')) {
                } else {
                    var KolikoArtikala = $('.NumerikInput').val();
                    if (KolikoArtikala != '') {
                        if (isNaN(KolikoArtikala)) {
                            KolikoArtikala = 1;
                        }
                    } else {
                        KolikoArtikala = 1;
                    }
                    var Kolicina = $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().find('.PorudzbinaArtikliKolicina').first().text();
                    if (parseFloat(Kolicina) >= 1) {
                        var NewKolicina = parseFloat(Kolicina) + parseFloat(KolikoArtikala);
                        var NewIznos = parseFloat(NewKolicina) * parseFloat(ArtikalPrice);
                        $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().find('.PorudzbinaArtikliKolicina').first().html(NewKolicina);
                        $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().find('.PorudzbinaArtikliIznos').first().html(NewIznos);
                        $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().addClass('OdabraniArtikal');
                        $('.NumerikInput').val('');
                        CalcTotal();
                        return false;
                    }
                }
            }
        }
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: 'GetArticlePrice=' + ArtikalId,
            error: function () {
                ArtikalNewPrice = 0;
                if (ArtikalNewPrice > 0) {
                    ArtikalPrice = ArtikalNewPrice;
                }
                //var ArtikalTip = $(this).attr('tipartikla');
                var KolikoArtikala = $('.NumerikInput').val();
                if (KolikoArtikala != '') {
                    if (isNaN(KolikoArtikala)) {
                        KolikoArtikala = 1;
                    }
                } else {
                    KolikoArtikala = 1;
                }
                if (parseFloat(KolikoArtikala) >= 1) {
                    if (ArtikalTip == 'DODA') {
                        if ($('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .OdabraniArtikal').length) {
                            var GlavniArtikal = $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .OdabraniArtikal').attr('idporucenog');
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .OdabraniArtikal').addClass('ImaDodatni');
                            var ArtikalHtml = '<div class="DodatniArtikal PoruceniArtikal" glavniartikal="' + GlavniArtikal + '" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                            $(ArtikalHtml).insertAfter('.OdabraniArtikal');
                            $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                        } else {
                            var GlavniArtikal = $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').last().attr('idporucenog');
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').last().addClass('ImaDodatni');
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').last().addClass('OdabraniArtikal');
                            var ArtikalHtml = '<div class="DodatniArtikal PoruceniArtikal" glavniartikal="' + GlavniArtikal + '" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                            $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                        }
                    } else {
                        $('.PorudzbinaArtikliBody .PoruceniArtikal').removeClass('OdabraniArtikal');
                        if ($('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').length) {
                            if ($('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().find('.OpisArtikla').length || $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().hasClass('ImaDodatni')) {
                                var ArtikalHtml = '<div class="PoruceniArtikal OdabraniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                                $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                                $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                            } else {
                                var Kolicina = $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().find('.PorudzbinaArtikliKolicina').first().text();
                                if (parseFloat(Kolicina) >= 1) {
                                    var NewKolicina = parseFloat(Kolicina) + parseFloat(KolikoArtikala);
                                    var NewIznos = parseFloat(NewKolicina) * parseFloat(ArtikalPrice);
                                    $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().find('.PorudzbinaArtikliKolicina').first().html(NewKolicina);
                                    $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().find('.PorudzbinaArtikliIznos').first().html(NewIznos);
                                    $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().addClass('OdabraniArtikal');
                                } else {
                                    var ArtikalHtml = '<div class="PoruceniArtikal OdabraniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                                    $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                                    $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                                }
                            }
                        } else {
                            var ArtikalHtml = '<div class="PoruceniArtikal OdabraniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                            $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                        }
                    }
                } else {
                    if (ArtikalTip == 'DODA') {
                        if ($('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .OdabraniArtikal').length) {
                            var GlavniArtikal = $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .OdabraniArtikal').attr('idporucenog');
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .OdabraniArtikal').addClass('ImaDodatni');
                            var ArtikalHtml = '<div class="DodatniArtikal PoruceniArtikal" glavniartikal="' + GlavniArtikal + '" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                            $(ArtikalHtml).insertAfter('.OdabraniArtikal');
                            $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                        } else {
                            var GlavniArtikal = $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').last().attr('idporucenog');
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').last().addClass('ImaDodatni');
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').last().addClass('OdabraniArtikal');
                            var ArtikalHtml = '<div class="DodatniArtikal PoruceniArtikal" glavniartikal="' + GlavniArtikal + '" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                            $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                        }
                    } else {
                        $('.PorudzbinaArtikliBody .PoruceniArtikal').removeClass('OdabraniArtikal');
                        var Cena = parseFloat(KolikoArtikala) * parseFloat(ArtikalPrice);
                        if (parseFloat(window.polaporcije) > 0 && KolikoArtikala == '0.5') {
                            Cena = parseFloat(ArtikalPrice) * (0 + (parseFloat(window.polaporcije) / 100));
                            ArtikalPrice = parseFloat(Cena) * 2;
                        }
                        ArtikalPrice = parseFloat(ArtikalPrice).toFixed(2);
                        var ArtikalHtml = '<div class="PoruceniArtikal OdabraniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(Cena).toFixed(2) + '</div></div>';
                        $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                        $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                    }
                }
                $('.AktivanStoAkcije').show();
                $('.PrazanStoAkcije').hide();
                $('.PunStoAkcije').hide();
                $('.NumerikInput').val('');
                CalcTotal();
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    ArtikalNewPrice = objData.Price;
                } else {
                    ArtikalNewPrice = 0;
                }
                if (ArtikalNewPrice > 0) {
                    ArtikalPrice = ArtikalNewPrice;
                }

                var KolikoArtikala = $('.NumerikInput').val();
                if (KolikoArtikala != '') {
                    if (isNaN(KolikoArtikala)) {
                        KolikoArtikala = 1;
                    }
                } else {
                    KolikoArtikala = 1;
                }
                if (parseFloat(KolikoArtikala) >= 1) {
                    ArtikalPrice = parseFloat(ArtikalPrice).toFixed(2);
                    if (ArtikalTip == 'DODA') {
                        if ($('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .OdabraniArtikal').length) {
                            var GlavniArtikal = $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .OdabraniArtikal').attr('idporucenog');
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .OdabraniArtikal').addClass('ImaDodatni');
                            var ArtikalHtml = '<div class="DodatniArtikal PoruceniArtikal" glavniartikal="' + GlavniArtikal + '" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                            $(ArtikalHtml).insertAfter('.OdabraniArtikal');
                            $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                        } else {
                            var GlavniArtikal = $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').last().attr('idporucenog');
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').last().addClass('ImaDodatni');
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').last().addClass('OdabraniArtikal');
                            var ArtikalHtml = '<div class="DodatniArtikal PoruceniArtikal" glavniartikal="' + GlavniArtikal + '" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                            $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                        }
                    } else {
                        $('.PorudzbinaArtikliBody .PoruceniArtikal').removeClass('OdabraniArtikal');
                        if ($('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').length) {
                            if ($('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().find('.OpisArtikla').length || $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().hasClass('ImaDodatni')) {
                                var ArtikalHtml = '<div class="PoruceniArtikal OdabraniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                                $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                                $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                            } else {
                                var Kolicina = $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().find('.PorudzbinaArtikliKolicina').first().text();
                                if (parseFloat(Kolicina) >= 1) {
                                    var NewKolicina = parseFloat(Kolicina) + parseFloat(KolikoArtikala);
                                    var NewIznos = parseFloat(NewKolicina) * parseFloat(ArtikalPrice);
                                    $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().find('.PorudzbinaArtikliKolicina').first().html(NewKolicina);
                                    $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().find('.PorudzbinaArtikliIznos').first().html(NewIznos);
                                    $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal[idporucenog="' + ArtikalId + '"]').last().addClass('OdabraniArtikal');
                                } else {
                                    var ArtikalHtml = '<div class="PoruceniArtikal OdabraniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                                    $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                                    $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                                }
                            }
                        } else {
                            var ArtikalHtml = '<div class="PoruceniArtikal OdabraniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                            $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                        }
                    }
                } else {
                    if (ArtikalTip == 'DODA') {
                        if ($('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .OdabraniArtikal').length) {
                            var GlavniArtikal = $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .OdabraniArtikal').attr('idporucenog');
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .OdabraniArtikal').addClass('ImaDodatni');
                            var ArtikalHtml = '<div class="DodatniArtikal PoruceniArtikal" glavniartikal="' + GlavniArtikal + '" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                            $(ArtikalHtml).insertAfter('.OdabraniArtikal');
                            $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                        } else {
                            var GlavniArtikal = $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').last().attr('idporucenog');
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').last().addClass('ImaDodatni');
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"] .PoruceniArtikal').last().addClass('OdabraniArtikal');
                            var ArtikalHtml = '<div class="DodatniArtikal PoruceniArtikal" glavniartikal="' + GlavniArtikal + '" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(ArtikalPrice).toFixed(2) + '</div></div>';
                            $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                            $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                        }
                    } else {
                        $('.PorudzbinaArtikliBody .PoruceniArtikal').removeClass('OdabraniArtikal');
                        var Cena = parseFloat(KolikoArtikala) * parseFloat(ArtikalPrice);
                        if (parseFloat(window.polaporcije) > 0 && KolikoArtikala == '0.5') {
                            Cena = parseFloat(ArtikalPrice) * (0 + (parseFloat(window.polaporcije) / 100));
                            ArtikalPrice = parseFloat(Cena) * 2;
                        }
                        ArtikalPrice = parseFloat(ArtikalPrice).toFixed(2);
                        var ArtikalHtml = '<div class="PoruceniArtikal OdabraniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + parseFloat(Cena).toFixed(2) + '</div></div>';
                        $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                        $(".PorudzbinaArtikliBody").scrollTop($(".PorudzbinaArtikliBody")[0].scrollHeight);
                    }
                }
                $('.AktivanStoAkcije').show();
                $('.PrazanStoAkcije').hide();
                $('.PunStoAkcije').hide();
                $('.NumerikInput').val('');
                CalcTotal();
            }
        });
    });
    $('body').delegate('.NumerikButton', 'click', function () {
        var Attr = $(this).attr('numerikvalue');
        if (Attr == 'Expand') {
            //$('.CanBeHidden').toggle(100);
            $('.PorudzbinaNumerik').toggleClass('ExpandedKeyboard');
            setTimeout(function () {
                RearangeOrder();
            }, 110);
        } else if (Attr == 'Clear') {
            if (!$('.StariArtikli').length) {
                if ($('.OdabraniArtikal').length) {
                    $('.OdabraniArtikal').remove();
                } else {
                    if ($('.PoruceniArtikal').length) {
                        $('.PoruceniArtikal').each(function () {
                            $(this).remove();
                        });
                    }
                    $('.NumerikInput').val('');
                }
            }
            CalcTotal();
        } else if (Attr == 'Decrease') {
            DecreaseItem();
        } else if (Attr == '0.5') {
            if ($('.OdabraniArtikal').length) {
                if (!$('.StariArtikli').length) {
                    var ArtikalPrice = $('.OdabraniArtikal').attr('cenaporucenog');
                    if (parseFloat(window.polaporcije) > 0) {
                        Cena = parseFloat(ArtikalPrice) * (0 + (parseFloat(window.polaporcije) / 100));
                        ArtikalPrice = parseFloat(Cena) * 2;
                    }
                    $('.OdabraniArtikal').attr('cenaporucenog', ArtikalPrice);
                    $('.OdabraniArtikal .PorudzbinaArtikliKolicina').html('0.5');
                    $('.NumerikInput').val('');
                    CalcTotal();
                }
            } else {
                $('.NumerikInput').val('0.5');
            }
        } else if (Attr == 'Confirm') {
            var VallToConfirm = $('.NumerikInput').val();
            if (VallToConfirm != '') {
                if ($('.OdabraniArtikal').length) {
                    if (!$('.StariArtikli').length) {
                        var DotOccurence = VallToConfirm.split(".").length - 1;
                        if (DotOccurence > 1) {
                            CreateWindowAlert('Neispravan unos količine!!!', 'error');
                        } else {
                            $('.OdabraniArtikal .PorudzbinaArtikliKolicina').html(VallToConfirm);
                            $('.NumerikInput').val('');
                            CalcTotal();
                        }
                    }
                } else {
                    CreateWindowAlert('Odaberite artikal za ažuriranje količine!!!', 'error');
                }
            } else {
                CreateWindowAlert('Vrednost polja za unos je prazna!!!', 'error');
            }
        } else {
            var Text = $('.NumerikInput').val();
            var TextToAdd = Attr;
            $('.NumerikInput').val(Text + TextToAdd);
        }
    });
    $('body').delegate('.PorudzbinaLeft .PoruceniArtikal', 'click', function () {
        $('.PoruceniArtikal').removeClass('OdabraniArtikal');
        $(this).addClass('OdabraniArtikal');
    });
    $('body').delegate('.Rastavljanje .PoruceniArtikal', 'click', function () {
        $('.PoruceniArtikal').removeClass('OdabraniArtikal');
        $(this).addClass('OdabraniArtikal');
        if ($(this).hasClass('DodatniArtikal')) {
            var StavkaId = $(this).attr('glavnastavka');
            $('.PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').addClass('OdabraniArtikal');
            $('.DodatniArtikal[glavnastavka="' + StavkaId + '"]').each(function () {
                $(this).addClass('OdabraniArtikal');
            });
        } else {
            var StavkaId = $(this).attr('stavkaracunaid');
            $('.DodatniArtikal[glavnastavka="' + StavkaId + '"]').each(function () {
                $(this).addClass('OdabraniArtikal');
            });
        }
    });
    $('body').delegate('.OpisPorudzbineKeyboard .QwertyKeys', 'click', function () {
        var WhatIsPressed = $(this).attr('qwerty-value');
        var WhatIsShown = $('.OpisPorudzbineOdabranaStavka').attr('selectoption');
        if (WhatIsPressed == 'Delete') {
            if (WhatIsShown == 'Artikal') {
                var ValToDelete = $('.ArtikalOpisiTop').html();
                $('.ArtikalOpisiTop').html(ValToDelete.substring(0, ValToDelete.length - 1));
            } else {
                var ValToDelete = $('.TuraOpisiTop').html();
                $('.TuraOpisiTop').html(ValToDelete.substring(0, ValToDelete.length - 1));
            }
        } else if (WhatIsPressed == 'Zatvori') {
            $('.OpisPorudzbine').hide();
            $('.ArtikalOpisiTop').html('');
        } else if (WhatIsPressed == 'Enter') {
            var IsEmptyArtikal = $('.ArtikalOpisiTop').text();
            if (IsEmptyArtikal != '') {
                var ValToAdd = $('.ArtikalOpisiTop').html();
                if ($('.OdabraniArtikal').length) {
                    var HtmlToAdd = '<div class="OpisArtikla"><div class="OpisIcon"><i class="fa fa-edit"></i></div><div class="OpisContent">' + ValToAdd + '</div></div>';
                    if ($('.OdabraniArtikal .OpisArtikla').length) {
                        $('.OdabraniArtikal .OpisArtikla').remove();
                    }
                    $('.OdabraniArtikal').prepend(HtmlToAdd);
                } else {
                    var HtmlToAdd = '<div class="OpisArtikla"><div class="OpisIcon"><i class="fa fa-edit"></i></div><div class="OpisContent">' + ValToAdd + '</div></div>';
                    if ($('.ActiveGostArtikli .PoruceniArtikal').last().find('.OpisArtikla').first().length) {
                        $('.ActiveGostArtikli .PoruceniArtikal').last().find('.OpisArtikla').first().remove();
                    }
                    $('.ActiveGostArtikli .PoruceniArtikal').last().prepend(HtmlToAdd);
                }
                $('.ArtikalOpisiTop').html('');
            }
            $('.OpisPorudzbine').hide();
        } else {
            if (WhatIsShown == 'Artikal') {
                var ValToAdd = $('.ArtikalOpisiTop').html();
                $('.ArtikalOpisiTop').html(ValToAdd + WhatIsPressed);
            } else {
                var ValToAdd = $('.TuraOpisiTop').html();
                $('.TuraOpisiTop').html(ValToAdd + WhatIsPressed);
            }
        }
    });
    $('body').delegate('.PredefinisaniOpis', 'click', function () {
        var OpisContent = $('.ArtikalOpisiTop').html();
        var WhatIsClicked = $(this).html();
        if (OpisContent == '') {
            var NewContent = WhatIsClicked;
        } else {
            var NewContent = OpisContent + "<div>" + WhatIsClicked + "</div>";
        }
        if (NewContent.length > 255) {
            CreateWindowAlert('Dostignut je maksimalan broj karaktera za opis!!!', 'error');
        } else {
            $('.ArtikalOpisiTop').html(NewContent);
        }
    });
    $('body').delegate('.NewLineArtikal', 'click', function () {
        $('.ArtikalOpisiTop').append("<div><br></div>");
        $('.ArtikalOpisiTop').focus();
        document.execCommand('selectAll', false, null);
        document.getSelection().collapseToEnd();
    });
    $('body').delegate('.NewLineTura', 'click', function () {
        $('.TuraOpisiTop').append("<div><br></div>");
        $('.TuraOpisiTop').focus();
        document.execCommand('selectAll', false, null);
        document.getSelection().collapseToEnd();
    });
    $('body').delegate('.StalniGosti .QwertyKeys', 'click', function () {
        var WhatIsPressed = $(this).attr('qwerty-value');
        if (WhatIsPressed == 'Delete') {
            var ValToDelete = $('.StalniFocus').val();
            $('.StalniFocus').val(ValToDelete.substring(0, ValToDelete.length - 1));
        } else if (WhatIsPressed == 'Zatvori') {
            if ($('.CreateStalniGosti').is(':visible')) {
                $('.CreateStalniGosti').hide();
            } else {
                $('.StalniGosti').hide();
            }
        } else if (WhatIsPressed == 'Enter') {
            if ($('.CreateStalniGosti').is(':visible')) {
                $('.CreateStalnogGosta').submit();
            } else {
                var Value = $('.FindGuest').val();
                if (Value) {
                    $('.StalniGosti tbody tr').removeClass('SelectedGost');
                    $('.StalniGosti tbody tr').each(function () {
                        var ThisValue = $(this).attr('gost-sifra');
                        if (ThisValue) {
                            if (ThisValue == Value) {
                                $(this).addClass('SelectedGost');
                            }
                        }
                    });
                    if ($('.SelectedGost').length > 1) {
                        $('.StalniGosti tbody tr').removeClass('SelectedGost');
                    }
                }
                if ($('.StalniGosti .SelectedGost').length) {
                    var GostId = $('.StalniGosti .SelectedGost').attr('gost-id');
                    var GostName = $('.StalniGosti .SelectedGost').find('td').first().text();
                    var GostPopust = $('.StalniGosti .SelectedGost').attr('gost-popust');
                    var GostPlacanje = $('.StalniGosti .SelectedGost').attr('gost-placanje');
                    var IznosValue = $('.IznosValue').val();
                    var PopustValue = 0;
                    var ZaUplatu = IznosValue;
                    if (parseInt(GostPopust) != 0) {
                        var ArtikalPopust = 0;
                        var ArtikalIznos = 0;
                        if ($('body').hasClass('PayTransferedTables')) {
                            $('.RastavljanjeRight .PoruceniArtikal').each(function () {
                                var ArtikalId = $(this).attr('idporucenog');
                                var ArtikalCena = $(this).attr('cenaporucenog');
                                var ArtikalKolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
                                var IsPopustAllowed = $('.Artikli .Artikal[idartikla="' + ArtikalId + '"]').first().attr('dozvoljenpopust');
                                if (IsPopustAllowed == '1') {
                                    ArtikalPopust = parseFloat(ArtikalPopust) + ((parseFloat(ArtikalCena) * (0 + (parseFloat(GostPopust) / 100))) * parseFloat(ArtikalKolicina));
                                    ArtikalIznos = parseFloat(ArtikalIznos) + ((parseFloat(ArtikalCena) * parseFloat(ArtikalKolicina)) - ((parseFloat(ArtikalCena) * (0 + (parseFloat(GostPopust) / 100))) * parseFloat(ArtikalKolicina)));
                                } else {
                                    ArtikalIznos = parseFloat(ArtikalIznos) + (parseFloat(ArtikalCena) * parseFloat(ArtikalKolicina));
                                }
                            });
                        } else {
                            $('.PorudzbinaArtikliBody .PoruceniArtikal').each(function () {
                                var ArtikalId = $(this).attr('idporucenog');
                                var ArtikalCena = $(this).attr('cenaporucenog');
                                var ArtikalKolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
                                var IsPopustAllowed = $('.Artikli .Artikal[idartikla="' + ArtikalId + '"]').first().attr('dozvoljenpopust');
                                if (IsPopustAllowed == '1') {
                                    ArtikalPopust = parseFloat(ArtikalPopust) + ((parseFloat(ArtikalCena) * (0 + (parseFloat(GostPopust) / 100))) * parseFloat(ArtikalKolicina));
                                    ArtikalIznos = parseFloat(ArtikalIznos) + ((parseFloat(ArtikalCena) * parseFloat(ArtikalKolicina)) - ((parseFloat(ArtikalCena) * (0 + (parseFloat(GostPopust) / 100))) * parseFloat(ArtikalKolicina)));
                                } else {
                                    ArtikalIznos = parseFloat(ArtikalIznos) + (parseFloat(ArtikalCena) * parseFloat(ArtikalKolicina));
                                }
                            });
                        }
                        PopustValue = ArtikalPopust;
                        ZaUplatu = ArtikalIznos;
                    }
                    $('.PopustValue').val(parseFloat(PopustValue).toFixed(2));
                    $('.UkupnoValue').val(parseFloat(ZaUplatu).toFixed(2));
                    $('.UplacenoValue').val(parseFloat(ZaUplatu).toFixed(2));
                    $('.UplacenoValue').focus().select();
                    CalcKusur();

                    $('.StalniGostValue').val(GostName);
                    $('.PopustPercentValue').val(GostPopust);
                    $('.StalniGostValue').attr('stalnigost-id', GostId);
                    $('.StalniGosti').hide();
                    if (GostPlacanje != '') {
                        if (GostPlacanje == 'GOTOVINA' || GostPlacanje == 'CEK' || GostPlacanje == 'KARTICA' || GostPlacanje == 'FAKTURA') {
                            $('.BeloNaplata[belo-opcija="' + GostPlacanje + '"]').click();
                        } else {
                            $('.CrnoNaplata[crno-opcija="' + GostPlacanje + '"]').click();
                        }
                    }
                } else {
                    CreateWindowAlert('Najpre odaberite stalnog gosta!!!', 'error');
                }
            }
        } else {
            var ValToAdd = $('.StalniFocus').val();
            $('.StalniFocus').val(ValToAdd + WhatIsPressed);
        }
        $('.StalniFocus').focus();
    });
    $('body').delegate('.StalniGosti tbody tr', 'click', function () {
        $('.StalniGosti tbody tr').removeClass('SelectedGost');
        $(this).toggleClass('SelectedGost');
    });
    $('body').delegate('.StalniGosti input', 'click focusin', function () {
        $('.StalniGosti input').removeClass('StalniFocus');
        $(this).addClass('StalniFocus');
    });
    $('body').delegate('.FindGuest', 'keypress', function (evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        console.log(charCode);
        if (charCode == 13) {
            $('.StalniGostiKeyboard .QwertyKeys[qwerty-value="Enter"]').click();
            return false;
        }
        return true;
    });
    $('body').delegate('.GrupeGostiju', 'click', function () {
        var WhatIsClicked = $(this).attr('grupa-id');
        if (WhatIsClicked == 'Add') {
            $('.CreateStalniGosti').show();
            $('.CreateStalnogGosta input').first().click();
        } else {
            $('.SearchResults tbody tr').hide();
            $('.SearchResults tbody tr[gost-grupa="' + WhatIsClicked + '"]').show();
        }
    });
    $('body').delegate('.SearchGuests', 'change keyup focusin', function () {
        var value = $(this).val().toLowerCase();
        if (value) {
            $(".SearchResults tbody tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
            });
        }
    });
    $('body').delegate('.CreateStalnogGosta', 'submit', function (e) {
        if (CheckForm(this) == 1) {
            CreateWindowAlert('Popunite sva tražena polja!!!', 'error');
            return false;
        }
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: $(this).serialize(),
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    $('.SearchResults tbody tr').removeClass('SelectedGost');
                    $('.SearchResults tbody').append(objData.StalniGostNewHtml);
                    $('.CreateStalniGosti').hide();
                    $('.CreateStalnogGosta input').each(function () {
                        $(this).val('');
                    });
                    $(".SearchResults").scrollTop($(".SearchResults")[0].scrollHeight);
                    CreateWindowAlert('Stalni gost je kreiran!', 'success');
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                }
            }
        });
        return false;
    });
    $('body').delegate('.OpisArtikla', 'click', function () {
        var ValToAdd = $(this).find('.OpisContent').first().html();
        $('.ArtikalOpisiTop').html(ValToAdd);
        $('.OpisPorudzbine').show();
    });
    $('.UplacenoValue').focus(function () {
        $('.OFPibKupca').removeClass('FocusedElement');
        $('.UplacenoValue').addClass('FocusedElement');
    });
    $('.OFPibKupca').focus(function () {
        $('.UplacenoValue').removeClass('FocusedElement');
        $('.OFPibKupca').addClass('FocusedElement');
        $('.OFPibKupca').select();
    });
    $('body').delegate('.NaplataNumeric', 'click', function () {
        if (!$('.FocusedElement').length) {
            if ($('.NaplataButton[buton-action="Kombinovano"]').hasClass('SelectedOption')) {
                $('.BeloNaplata').first().find('.KombinovanoValue').first().addClass('FocusedElement');
            } else {
                $('.UplacenoValue').addClass('FocusedElement');
                $('.UplacenoValue').addClass('AllSelected');
            }
        }
        if ($('.FocusedElement').hasClass('AllSelected')) {
            $('.FocusedElement').val('');
            $('.FocusedElement').removeClass('AllSelected');
        }
        var WhatToAdd = $(this).attr('numeric-val');
        var ToWhatToAdd = $('.FocusedElement').val();
        if (!ToWhatToAdd) {
            ToWhatToAdd = "";
        }
        if (WhatToAdd == 'Delete') {
            $('.FocusedElement').val(ToWhatToAdd.substring(0, ToWhatToAdd.length - 1));
        } else if (WhatToAdd == '.') {
            if (ToWhatToAdd.includes('.')) {
                CreateWindowAlert('Neispravan unos!!!', 'error');
            } else {
                $('.FocusedElement').val(ToWhatToAdd + "" + WhatToAdd);
            }
        } else {
            $('.FocusedElement').val(ToWhatToAdd + "" + WhatToAdd);
        }
        if ($('.FocusedElement').hasClass('KombinovanoValue')) {
            CalcKombinovano();
        }
        CalcKusur();
    });
    var TimeoutFocused;
    var NaplataKljuc = "";
    $('body').delegate('.FocusedElement', 'keypress', function (evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if ($(this).hasClass('AllSelected')) {
            $(this).val('');
            $(this).removeClass('AllSelected');
        }
        if (charCode == 46) {
            if (NaplataKljuc.includes('.')) {
                CreateWindowAlert('Neispravan unos!!!', 'error');
                var Value = $('.FocusedElement').val();
                $('.FocusedElement').val(Value + '' + NaplataKljuc);
                NaplataKljuc = "";
                if (TimeoutFocused) {
                    clearTimeout(TimeoutFocused);
                    TimeoutFocused = null;
                }
                return false;
            }
        }
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            var Value = $('.FocusedElement').val();
            $('.FocusedElement').val(Value + '' + NaplataKljuc);
            NaplataKljuc = "";
            if (TimeoutFocused) {
                clearTimeout(TimeoutFocused);
                TimeoutFocused = null;
            }
            return false;
        }
        if (charCode == 13) {
            if ($('.CrnoSifra[crno-sifra="' + NaplataKljuc + '"]').length) {
                $('.CrnoSifra[crno-sifra="' + NaplataKljuc + '"]').click();
                NaplataKljuc = "";
                if (TimeoutFocused) {
                    clearTimeout(TimeoutFocused);
                    TimeoutFocused = null;
                }
            } else {
                var Value = $('.FocusedElement').val();
                $('.FocusedElement').val(Value + '' + NaplataKljuc);
                NaplataKljuc = "";
                if (TimeoutFocused) {
                    clearTimeout(TimeoutFocused);
                    TimeoutFocused = null;
                }
                $('.NaplataButton[buton-action="Potvrdi"]').click();
            }
            return false;
        }
        if (TimeoutFocused) {
            clearTimeout(TimeoutFocused);
            TimeoutFocused = null;
        }
        console.log(charCode);
        if (charCode >= 48 && charCode <= 57) {
            NaplataKljuc += String.fromCharCode(charCode);
        }
        TimeoutFocused = setTimeout(function () {
            var Value = $('.FocusedElement').val();
            $('.FocusedElement').val(Value + '' + NaplataKljuc);
            NaplataKljuc = "";
            setTimeout(function () {
                if ($('.FocusedElement').hasClass('KombinovanoValue')) {
                    CalcKombinovano();
                }
                CalcKusur();
            }, 100);
        }, 250);
        return false;
    });
    $('body').delegate('.FocusedElement', 'change', function (evt) {
        if ($('.FocusedElement').hasClass('KombinovanoValue')) {
            CalcKombinovano();
        }
        CalcKusur();
    });
    $('body').delegate('.KombinovanoValue', 'click focus', function () {
        $('.UplacenoValue').removeClass('FocusedElement');
        $('.KombinovanoValue').removeClass('FocusedElement');
        $('.KombinovanoValue').removeClass('AllSelected');
        $('.UplacenoValue').removeClass('AllSelected');
        $(this).addClass('FocusedElement');
        $(this).select();
        $(this).addClass('AllSelected');
    });
    $('body').delegate('.UplacenoValue', 'click focus', function () {
        $('.UplacenoValue').removeClass('FocusedElement');
        $('.KombinovanoValue').removeClass('FocusedElement');
        $('.KombinovanoValue').removeClass('AllSelected');
        $('.UplacenoValue').removeClass('AllSelected');
        $(this).addClass('FocusedElement');
        $(this).select();
        $(this).addClass('AllSelected');
    });
    $('body').delegate('.TransferAction', 'click', function () {
        var WhatIsClicked = $(this).attr('transfer-action');
        if (WhatIsClicked == 'Odustani') {
            $('.Rastavljanje').hide();
            $('.RastavljanjeRight').html('');
            $('.RastavljanjeLeft').html('');
            $('body').removeClass('PayTransferedTables');
            var StoId = $('.PorudzbinaSto').attr('sto-id');
            GetTableItems(StoId);
        } else if (WhatIsClicked == 'Prebaci') {
            if ($('.RastavljanjeRight .PoruceniArtikal').length) {
                $('.Rastavljanje').hide();
                $('.Porudzbina').hide();
                $('.UnosBrojaStolaInput').val('');
                $('body').addClass('TransferTables');
            } else {
                CreateWindowAlert('Najpre odaberite artikle!!!', 'error');
            }
        } else if (WhatIsClicked == 'Storno') {
            if ($('.RastavljanjeRight .PoruceniArtikal').length) {
                if ($('.StornoPassword').length) {
                    $('.StornoPassword').show();
                    $('.StornoInput').val('');
                    $('.StornoInput').focus();
                } else {

                }
            } else {
                CreateWindowAlert('Nema artikala za storniranje!!!', 'error');
            }
        } else if (WhatIsClicked == 'Naplata') {
            $('.OFVrstaRacuna').val($('.OFVrstaRacuna').attr('default-value'));
            $('.OFPibKupcaID').val($('.OFPibKupcaID').attr('default-value'));
            $('.OFOpcionoPoljeKupcaID').val($('.OFOpcionoPoljeKupcaID').attr('default-value'));
            $('.OFPibKupca').val("");
            $('.OFOpcionoPoljeKupca').val("");
            $('.OFReferentniBrojKupca').val("");
            $('.NaplataButton').removeClass('SelectedPredracunOption');
            if ($('.RastavljanjeRight .PoruceniArtikal').length) {
                var TotalToPay = 0;
                $('.RastavljanjeRight .PoruceniArtikal').each(function () {
                    var Iznos = $(this).find('.PorudzbinaArtikliIznos').first().html();
                    TotalToPay = parseFloat(TotalToPay) + parseFloat(Iznos);
                });
                if (parseFloat(TotalToPay) <= 0) {
                    CreateWindowAlert('Iznos računa mora biti veći od 0!!!', 'error');
                    return false;
                }
                $('.IznosValue').val(parseFloat(TotalToPay).toFixed(2));
                $('.PopustValue').val('0.00');
                $('.UkupnoValue').val(parseFloat(TotalToPay).toFixed(2));
                $('.UplacenoValue').val(parseFloat(TotalToPay).toFixed(2));
                $('.KusurValue').val('0.00');
                $('body').addClass('PayTransferedTables');
                $('.Naplata').show();
                $('.KombinovanoValue').each(function () {
                    $(this).val('');
                });
                if ($('.NaplataButton[buton-action="Kombinovano"]').hasClass('SelectedOption')) {
                    $('.NaplataButton[buton-action="Kombinovano"]').click();
                }
                if ($('.NaplataButton[buton-action="Gotovinski"]').hasClass('SelectedOption')) {
                    $('.NaplataButton[buton-action="Gotovinski"]').click();
                }
                //$('.BeloNaplata').last().click();
                $('.BeloNaplata').removeClass('SelectedNaplata');
                $('.CrnoNaplata').removeClass('SelectedNaplata');
                $(".ArtikliZaNaplatuSadrzaj").html('');
                $('.RastavljanjeRight .PoruceniArtikal').each(function () {
                    var ArtikalId = $(this).attr('idporucenog');
                    var ArtikalTip = $(this).attr('tipporucenog');
                    var ArtikalPrice = $(this).attr('cenaporucenog');
                    var ArtikalKolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
                    if ($('.ArtikliZaNaplatu .PoruceniArtikal[idporucenog="' + ArtikalId + '"][cenaporucenog="' + ArtikalPrice + '"]').length) {
                        var Kolicina = $('.ArtikliZaNaplatu .PoruceniArtikal[idporucenog="' + ArtikalId + '"][cenaporucenog="' + ArtikalPrice + '"]').find('.PorudzbinaArtikliKolicina').first().html();
                        var NewKolicina = parseFloat(ArtikalKolicina) + parseFloat(Kolicina);
                        var NovaVrednost = parseFloat(NewKolicina) * parseFloat(ArtikalPrice);
                        $('.ArtikliZaNaplatu .PoruceniArtikal[idporucenog="' + ArtikalId + '"][cenaporucenog="' + ArtikalPrice + '"]').find('.PorudzbinaArtikliKolicina').first().html(NewKolicina);
                        $('.ArtikliZaNaplatu .PoruceniArtikal[idporucenog="' + ArtikalId + '"][cenaporucenog="' + ArtikalPrice + '"]').find('.PorudzbinaArtikliIznos').first().html(parseFloat(NovaVrednost).toFixed(2));
                    } else {
                        var ArtikalHtml = '<div class="PoruceniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '">' + $(this).html() + '</div>';
                        $('.ArtikliZaNaplatuSadrzaj').append(ArtikalHtml);
                    }
                });
                $(".ArtikliZaNaplatuSadrzaj").scrollTop($(".ArtikliZaNaplatuSadrzaj")[0].scrollHeight);
                setTimeout(function () {
                    var BeloLength = $('.BeloNaplata').length;
                    var InitialHeight = $('.NaplataOpcije').height();
                    var RightKeysHeight = (parseFloat(InitialHeight) / parseFloat(BeloLength));
                    var NumericKeysHeight = (parseFloat(InitialHeight) / 4);
                    $('.BeloNaplata').attr('style', 'height:' + parseInt(RightKeysHeight) + 'px; line-height: ' + parseInt(RightKeysHeight) + 'px;');
                    $('.CrnoNaplata').attr('style', 'height:' + parseInt(RightKeysHeight) + 'px; line-height: ' + parseInt(RightKeysHeight) + 'px;');
                    $('.NaplataNumeric').attr('style', 'height:' + parseInt(NumericKeysHeight) + 'px; line-height: ' + parseInt(NumericKeysHeight) + 'px;');
                    $('.UplacenoValue').focus();
                    $('.NaplataDetaljiValue').removeClass('FocusedElement');
                    $('.PopustiDetaljiValue').removeClass('FocusedElement');
                    $('.UplacenoValue').addClass('FocusedElement');
                }, 500);
                setTimeout(function () {
                    var ArtikliZaNaplatuVelicina = $('.Naplata').height() - $('.NaplataTop').height() - $('.NaplataBottom').height() - $('.NaplataOpcije .NaplataLeft').height() - $('.ArtikliZaNaplatuTitle').height();
                    $('.ArtikliZaNaplatuSadrzaj').height(ArtikliZaNaplatuVelicina);
                }, 1000);
            } else {
                CreateWindowAlert('Najpre odaberite artikle!!!', 'error');
            }
        }
    });
    $('body').delegate('.RastavljanjeAction', 'click', function () {
        var WhatIsClicked = $(this).attr('rastavljanje-action');
        if (WhatIsClicked == 'ToRightOne') {
            if ($('.RastavljanjeLeft .PoruceniArtikal').length) {
                if ($('.RastavljanjeLeft .OdabraniArtikal').length) {
                    if ($('.RastavljanjeLeft .OdabraniArtikal').length == 1) {
                        var NazivOdabranog = $('.RastavljanjeLeft .OdabraniArtikal').find('.PorudzbinaArtikliNaziv').first().html();
                        var KolicinaOdabranog = $('.RastavljanjeLeft .OdabraniArtikal').find('.PorudzbinaArtikliKolicina').first().html();
                        var CenaOdabranog = $('.RastavljanjeLeft .OdabraniArtikal').attr('cenaporucenog');
                        var IdOdabranog = $('.RastavljanjeLeft .OdabraniArtikal').attr('idporucenog');
                        var StavkaId = $('.RastavljanjeLeft .OdabraniArtikal').attr('stavkaracunaid');
                        var StavkaTura = $('.RastavljanjeLeft .OdabraniArtikal').attr('stavkaturaid');
                    } else {
                        $('.RastavljanjeLeft .OdabraniArtikal').each(function () {
                            $(this).appendTo('.RastavljanjeRight');
                        });
                        CalcRastavljanje();
                        return false;
                    }
                } else {
                    if ($('.RastavljanjeLeft .ActiveGostArtikli .PoruceniArtikal').length) {
                        $('.RastavljanjeLeft .ActiveGostArtikli .PoruceniArtikal').last().click();
                        var NazivOdabranog = $('.RastavljanjeLeft .ActiveGostArtikli .PoruceniArtikal').last().find('.PorudzbinaArtikliNaziv').first().html();
                        var KolicinaOdabranog = $('.RastavljanjeLeft .ActiveGostArtikli .PoruceniArtikal').last().find('.PorudzbinaArtikliKolicina').first().html();
                        var CenaOdabranog = $('.RastavljanjeLeft .ActiveGostArtikli .PoruceniArtikal').last().attr('cenaporucenog');
                        var IdOdabranog = $('.RastavljanjeLeft .ActiveGostArtikli .PoruceniArtikal').last().attr('idporucenog');
                        var StavkaId = $('.RastavljanjeLeft .ActiveGostArtikli .PoruceniArtikal').last().attr('stavkaracunaid');
                        var StavkaTura = $('.RastavljanjeLeft .ActiveGostArtikli .PoruceniArtikal').last().attr('stavkaturaid');
                    } else {
                        CreateWindowAlert('Nema artikala za prenos!!!', 'error');
                        return false;
                    }
                }
                if ($('.RastavljanjeLeft .OdabraniArtikal').length > 1) {
                    $('.RastavljanjeLeft .OdabraniArtikal').each(function () {
                        $(this).appendTo('.RastavljanjeRight');
                    });
                } else {
                    var TransferKolicina = 1;
                    if (KolicinaOdabranog < 1) {
                        TransferKolicina = KolicinaOdabranog;
                    }
                    if (parseFloat(KolicinaOdabranog) <= 1) {
                        $('.RastavljanjeLeft .OdabraniArtikal').remove();
                    } else {
                        var NewKolicina = parseFloat(KolicinaOdabranog) - parseFloat(TransferKolicina);
                        $('.RastavljanjeLeft .OdabraniArtikal').find('.PorudzbinaArtikliKolicina').first().html(parseFloat(NewKolicina).toFixed(2));
                    }
                    if ($('.RastavljanjeRight .PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').length) {
                        var KolicinaPrebacenog = $('.RastavljanjeRight .PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').find('.PorudzbinaArtikliKolicina').first().html();
                        var NovaKolicina = parseFloat(KolicinaPrebacenog) + parseFloat(TransferKolicina);
                        $('.RastavljanjeRight .PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').find('.PorudzbinaArtikliKolicina').first().html(parseFloat(NovaKolicina).toFixed(2));
                    } else {
                        var HtmlAppend = '<div class="PoruceniArtikal" stavkaturaid="' + StavkaTura + '" stavkaracunaid="' + StavkaId + '" cenaporucenog="' + CenaOdabranog + '" idporucenog="' + IdOdabranog + '">';
                        HtmlAppend += '<div class="PorudzbinaArtikliNaziv">' + NazivOdabranog + '</div>';
                        HtmlAppend += '<div class="PorudzbinaArtikliKolicina">' + TransferKolicina + '</div>';
                        HtmlAppend += '<div class="PorudzbinaArtikliIznos">' + CenaOdabranog + '</div></div>';
                        $('.RastavljanjeRight').append(HtmlAppend);
                    }
                }
                CalcRastavljanje();
            } else {
                CreateWindowAlert('Nema artikala za prenos!!!', 'error');
            }
        } else if (WhatIsClicked == 'ToLeftOne') {
            if ($('.RastavljanjeRight .PoruceniArtikal').length) {
                if ($('.RastavljanjeRight .OdabraniArtikal').length) {
                    var NazivOdabranog = $('.RastavljanjeRight .OdabraniArtikal').find('.PorudzbinaArtikliNaziv').first().html();
                    var KolicinaOdabranog = $('.RastavljanjeRight .OdabraniArtikal').find('.PorudzbinaArtikliKolicina').first().html();
                    var CenaOdabranog = $('.RastavljanjeRight .OdabraniArtikal').attr('cenaporucenog');
                    var IdOdabranog = $('.RastavljanjeRight .OdabraniArtikal').attr('idporucenog');
                    var StavkaId = $('.RastavljanjeRight .OdabraniArtikal').attr('stavkaracunaid');
                    var StavkaTura = $('.RastavljanjeRight .OdabraniArtikal').attr('stavkaturaid');
                } else {
                    $('.RastavljanjeRight .PoruceniArtikal').last().click();
                    var NazivOdabranog = $('.RastavljanjeRight .PoruceniArtikal').last().find('.PorudzbinaArtikliNaziv').first().html();
                    var KolicinaOdabranog = $('.RastavljanjeRight .PoruceniArtikal').last().find('.PorudzbinaArtikliKolicina').first().html();
                    var CenaOdabranog = $('.RastavljanjeRight .PoruceniArtikal').last().attr('cenaporucenog');
                    var IdOdabranog = $('.RastavljanjeRight .PoruceniArtikal').last().attr('idporucenog');
                    var StavkaId = $('.RastavljanjeRight .OdabraniArtikal').last().attr('stavkaracunaid');
                    var StavkaTura = $('.RastavljanjeRight .OdabraniArtikal').last().attr('stavkaturaid');
                }
                if ($('.RastavljanjeRight .OdabraniArtikal').length > 1) {
                    var TuraId = $('.RastavljanjeRight .OdabraniArtikal').first().attr('stavkaturaid');
                    $('.RastavljanjeRight .OdabraniArtikal').each(function () {
                        $(this).appendTo('.RastavljanjeLeft .StoTura[id-ture="' + TuraId + '"]');
                    });
                } else {
                    var TransferKolicina = 1;
                    if (KolicinaOdabranog < 1) {
                        TransferKolicina = KolicinaOdabranog;
                    }
                    if (parseFloat(KolicinaOdabranog) <= 1) {
                        $('.RastavljanjeRight .OdabraniArtikal').remove();
                    } else {
                        var NewKolicina = parseFloat(KolicinaOdabranog) - parseFloat(TransferKolicina);
                        $('.RastavljanjeRight .OdabraniArtikal').find('.PorudzbinaArtikliKolicina').first().html(parseFloat(NewKolicina).toFixed(2));
                    }
                    if ($('.RastavljanjeLeft .PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').length) {
                        var KolicinaPrebacenog = $('.RastavljanjeLeft .PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').find('.PorudzbinaArtikliKolicina').first().html();
                        var NovaKolicina = parseFloat(KolicinaPrebacenog) + parseFloat(TransferKolicina);
                        $('.RastavljanjeLeft .PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').find('.PorudzbinaArtikliKolicina').first().html(parseFloat(NovaKolicina).toFixed(2));
                    } else {
                        var HtmlAppend = '<div class="PoruceniArtikal" stavkaturaid="' + StavkaTura + '" stavkaracunaid="' + StavkaId + '" cenaporucenog="' + CenaOdabranog + '" idporucenog="' + IdOdabranog + '">';
                        HtmlAppend += '<div class="PorudzbinaArtikliNaziv">' + NazivOdabranog + '</div>';
                        HtmlAppend += '<div class="PorudzbinaArtikliKolicina">' + TransferKolicina + '</div>';
                        HtmlAppend += '<div class="PorudzbinaArtikliIznos">' + CenaOdabranog + '</div></div>';
                        $('.RastavljanjeLeft .StoTura[id-ture="' + StavkaTura + '"]').append(HtmlAppend);
                    }
                }

                CalcRastavljanje();
            } else {
                CreateWindowAlert('Nema artikala za prenos!!!', 'error');
            }
        } else if (WhatIsClicked == 'ToRightAll') {
            if ($('.RastavljanjeLeft .PoruceniArtikal').length) {
                $('.RastavljanjeLeft .PoruceniArtikal').each(function () {
                    $(this).appendTo('.RastavljanjeRight');
                });
                $('.RastavljanjeRight .PoruceniArtikal').removeClass('OdabraniArtikal');
                CalcRastavljanje();
            } else {
                CreateWindowAlert('Nema artikala za prenos!!!', 'error');
            }
        } else if (WhatIsClicked == 'ToLeftAll') {
            if ($('.RastavljanjeRight .PoruceniArtikal').length) {
                $('.RastavljanjeRight .PoruceniArtikal').each(function () {
                    var Tura = $(this).attr('stavkaturaid');
                    $(this).appendTo('.RastavljanjeLeft .StoTura[id-ture="' + Tura + '"]');
                });
                $('.RastavljanjeLeft .PoruceniArtikal').removeClass('OdabraniArtikal');
                CalcRastavljanje();
            } else {
                CreateWindowAlert('Nema artikala za prenos!!!', 'error');
            }
        } else if (WhatIsClicked == 'ToRightMore') {
            if ($('.RastavljanjeLeft .ActiveGostArtikli .PoruceniArtikal').length) {
                if ($('.RastavljanjeLeft .ActiveGostArtikli .OdabraniArtikal').length > 1) {
                    CreateWindowAlert('Ova opcija dostupna je samo za jedan odabrani artikal!!!', 'error');
                } else {
                    $('.RastavljanjeKolicina').show();
                    $('.RastavljanjeKolicina').removeClass('TransferRight');
                    $('.RastavljanjeKolicina').removeClass('TransferLeft');
                    $('.RastavljanjeKolicina').addClass('TransferRight');
                    $('.RastavljanjeKolicinaInput').val('');
                    $('.RastavljanjeKolicinaInput').focus();
                    if (!$('.RastavljanjeLeft .OdabraniArtikal').length) {
                        $('.RastavljanjeLeft .ActiveGostArtikli .PoruceniArtikal').last().click();
                    }
                }
            } else {
                CreateWindowAlert('Nema artikala za prenos!!!', 'error');
            }
        } else if (WhatIsClicked == 'ToLeftMore') {
            if ($('.RastavljanjeRight .PoruceniArtikal').length) {
                if ($('.RastavljanjeRight .OdabraniArtikal').length > 1) {
                    CreateWindowAlert('Ova opcija dostupna je samo za jedan odabrani artikal!!!', 'error');
                } else {
                    $('.RastavljanjeKolicina').show();
                    $('.RastavljanjeKolicina').removeClass('TransferRight');
                    $('.RastavljanjeKolicina').removeClass('TransferLeft');
                    $('.RastavljanjeKolicina').addClass('TransferLeft');
                    $('.RastavljanjeKolicinaInput').val('');
                    $('.RastavljanjeKolicinaInput').focus();
                    if (!$('.RastavljanjeRight .OdabraniArtikal').length) {
                        $('.RastavljanjeRight .PoruceniArtikal').last().click();
                    }
                }
            } else {
                CreateWindowAlert('Nema artikala za prenos!!!', 'error');
            }
        }
    });
    $('body').delegate('.StoTuraTitle', 'click', function () {
        $('.RastavljanjeLeft .PoruceniArtikal').removeClass('OdabraniArtikal');
        var Tura = $(this).parent('.StoTura').first().attr('id-ture');
        $('.StoTura[id-ture="' + Tura + '"] .PoruceniArtikal').each(function () {
            $(this).addClass('OdabraniArtikal');
        });
    });
    $('body').delegate('.RastavljanjeKey', 'click', function () {
        var WhatIsClicked = $(this).attr('key-value');
        if (WhatIsClicked == 'Odustani') {
            $('.RastavljanjeKolicina').hide();
        } else if (WhatIsClicked == 'Delete') {
            var ValToDelete = $('.RastavljanjeKolicinaInput').val();
            var NewVal = ValToDelete.substring(0, ValToDelete.length - 1);
            $('.RastavljanjeKolicinaInput').val(NewVal);
            $('.RastavljanjeKolicinaInput').focus();
        } else if (WhatIsClicked == '.') {
            var Value = $('.RastavljanjeKolicinaInput').val();
            if (Value.includes('.')) {
                CreateWindowAlert('Neispravan unos!!!', 'error');
            } else {
                $('.RastavljanjeKolicinaInput').val(Value + '' + WhatIsClicked);
            }
            $('.RastavljanjeKolicinaInput').focus();
        } else if (WhatIsClicked == 'Potvrdi') {
            var Value = $('.RastavljanjeKolicinaInput').val();
            if (Value) {
                if ($('.RastavljanjeKolicina').hasClass('TransferLeft')) {
                    if ($('.RastavljanjeRight .OdabraniArtikal').length) {
                        var NazivOdabranog = $('.RastavljanjeRight .OdabraniArtikal').find('.PorudzbinaArtikliNaziv').first().html();
                        var KolicinaOdabranog = $('.RastavljanjeRight .OdabraniArtikal').find('.PorudzbinaArtikliKolicina').first().html();
                        var CenaOdabranog = $('.RastavljanjeRight .OdabraniArtikal').attr('cenaporucenog');
                        var IdOdabranog = $('.RastavljanjeRight .OdabraniArtikal').attr('idporucenog');
                        var StavkaId = $('.RastavljanjeRight .OdabraniArtikal').attr('stavkaracunaid');
                        var StavkaTura = $('.RastavljanjeRight .OdabraniArtikal').attr('stavkaturaid');
                        var TransferKolicina = Value;
                        if (parseFloat(KolicinaOdabranog) < parseInt(Value)) {
                            CreateWindowAlert('Uneta količina je veća od kucane!!! Max: ' + KolicinaOdabranog + 'kom', 'error');
                            return false;
                        }
                        if (parseFloat(KolicinaOdabranog) <= parseFloat(Value)) {
                            $('.RastavljanjeRight .OdabraniArtikal').remove();
                        } else {
                            var NewKolicina = parseFloat(KolicinaOdabranog) - parseFloat(TransferKolicina);
                            $('.RastavljanjeRight .OdabraniArtikal').find('.PorudzbinaArtikliKolicina').first().html(parseFloat(NewKolicina).toFixed(2));
                        }
                        if ($('.RastavljanjeLeft .PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').length) {
                            var KolicinaPrebacenog = $('.RastavljanjeLeft .PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').find('.PorudzbinaArtikliKolicina').first().html();
                            var NovaKolicina = parseFloat(KolicinaPrebacenog) + parseFloat(TransferKolicina);
                            $('.RastavljanjeLeft .PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').find('.PorudzbinaArtikliKolicina').first().html(parseFloat(NovaKolicina).toFixed(2));
                        } else {
                            var HtmlAppend = '<div class="PoruceniArtikal" stavkaturaid="' + StavkaTura + '" stavkaracunaid="' + StavkaId + '" cenaporucenog="' + CenaOdabranog + '" idporucenog="' + IdOdabranog + '">';
                            HtmlAppend += '<div class="PorudzbinaArtikliNaziv">' + NazivOdabranog + '</div>';
                            HtmlAppend += '<div class="PorudzbinaArtikliKolicina">' + TransferKolicina + '</div>';
                            HtmlAppend += '<div class="PorudzbinaArtikliIznos">' + CenaOdabranog + '</div></div>';
                            $('.RastavljanjeLeft .StoTura[id-ture="' + StavkaTura + '"]').append(HtmlAppend);
                        }
                        CalcRastavljanje();
                    }
                } else {
                    if ($('.RastavljanjeLeft .OdabraniArtikal').length) {
                        var NazivOdabranog = $('.RastavljanjeLeft .OdabraniArtikal').find('.PorudzbinaArtikliNaziv').first().html();
                        var KolicinaOdabranog = $('.RastavljanjeLeft .OdabraniArtikal').find('.PorudzbinaArtikliKolicina').first().html();
                        var CenaOdabranog = $('.RastavljanjeLeft .OdabraniArtikal').attr('cenaporucenog');
                        var IdOdabranog = $('.RastavljanjeLeft .OdabraniArtikal').attr('idporucenog');
                        var StavkaId = $('.RastavljanjeLeft .OdabraniArtikal').attr('stavkaracunaid');
                        var StavkaTura = $('.RastavljanjeLeft .OdabraniArtikal').attr('stavkaturaid');
                        var TransferKolicina = Value;
                        if (parseFloat(KolicinaOdabranog) < parseInt(Value)) {
                            CreateWindowAlert('Uneta količina je veća od kucane!!! Max: ' + KolicinaOdabranog + 'kom', 'error');
                            return false;
                        }
                        if (parseFloat(KolicinaOdabranog) <= parseFloat(Value)) {
                            $('.RastavljanjeLeft .OdabraniArtikal').remove();
                        } else {
                            var NewKolicina = parseFloat(KolicinaOdabranog) - parseFloat(TransferKolicina);
                            $('.RastavljanjeLeft .OdabraniArtikal').find('.PorudzbinaArtikliKolicina').first().html(parseFloat(NewKolicina).toFixed(2));
                        }
                        if ($('.RastavljanjeRight .PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').length) {
                            var KolicinaPrebacenog = $('.RastavljanjeRight .PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').find('.PorudzbinaArtikliKolicina').first().html();
                            var NovaKolicina = parseFloat(KolicinaPrebacenog) + parseFloat(TransferKolicina);
                            $('.RastavljanjeRight .PoruceniArtikal[stavkaracunaid="' + StavkaId + '"]').find('.PorudzbinaArtikliKolicina').first().html(parseFloat(NovaKolicina).toFixed(2));
                        } else {
                            var HtmlAppend = '<div class="PoruceniArtikal" stavkaturaid="' + StavkaTura + '" stavkaracunaid="' + StavkaId + '" cenaporucenog="' + CenaOdabranog + '" idporucenog="' + IdOdabranog + '">';
                            HtmlAppend += '<div class="PorudzbinaArtikliNaziv">' + NazivOdabranog + '</div>';
                            HtmlAppend += '<div class="PorudzbinaArtikliKolicina">' + TransferKolicina + '</div>';
                            HtmlAppend += '<div class="PorudzbinaArtikliIznos">' + CenaOdabranog + '</div></div>';
                            $('.RastavljanjeRight').append(HtmlAppend);
                        }
                        CalcRastavljanje();
                    }
                }
                $('.RastavljanjeKolicinaInput').val('');
                $('.RastavljanjeKolicina').hide();
            } else {
                CreateWindowAlert('Neispravan unos!!!', 'error');
            }
        } else {
            var Value = $('.RastavljanjeKolicinaInput').val();
            $('.RastavljanjeKolicinaInput').val(Value + '' + WhatIsClicked);
            $('.RastavljanjeKolicinaInput').focus();
        }
    });
    $('body').delegate('.RastavljanjeKolicinaInput', 'keypress', function (evt) {
        var Value = $('.RastavljanjeKolicinaInput').val();
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        console.log(charCode);
        if (charCode == 13) {
            $('.RastavljanjeKey[key-value="Potvrdi"]').click();
            return false;
        }
        if (charCode == 46) {
            if (Value.includes('.')) {
                CreateWindowAlert('Neispravan unos!!!', 'error');
                return false;
            } else {
                return true;
            }
        }
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    });
    $('body').delegate('.SelectAction', 'click', function () {
        var WhatIsClicked = $(this).attr('actionid');
        if (WhatIsClicked == 'CancelTransfer') {
            $('body').removeClass('TransferTables');
        } else if (WhatIsClicked == 'PromenaOperatera') {
            $('body').addClass('PromenaTables');
            $('.Zauzet').addClass('OdabranStoZaPromenu');
        } else if (WhatIsClicked == 'CancelPromena') {
            $('body').removeClass('PromenaTables');
            $('.Sto').removeClass('OdabranStoZaPromenu');
        } else if (WhatIsClicked == 'SelectPromenaAll') {
            if ($('.OdabranStoZaPromenu').length) {
                $('.Sto').removeClass('OdabranStoZaPromenu');
            } else {
                $('.Zauzet').addClass('OdabranStoZaPromenu');
            }
        } else if (WhatIsClicked == 'SelectPromena') {
            if ($('.OdabranStoZaPromenu').length) {
                $.ajax({
                    type: 'POST',
                    url: './?modul=GetAjax',
                    data: "GetAllOtherOperators=true",
                    error: function () {
                        CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                    },
                    complete: function (response) {
                        var objData = jQuery.parseJSON(response.responseText);
                        if (objData.Status == 'success') {
                            $('.ImportOtherOperators').html(objData.HtmlToInsert);
                        } else {
                            CreateWindowAlert(objData.Message, 'error');
                        }
                    }
                });
                $('.PromenaOperatera').show();
            } else {
                CreateWindowAlert('Nema odabranih stolova za promenu operatera!!!', 'error');
            }
        } else if (WhatIsClicked == 'QuickPayment') {
            $('.Porudzbina').show();
            $('.PorudzbinaArtikliBody').html('');
            $('.PorudzbinaSto').attr('sto-id', '0');
            $('.PorudzbinaSto').html('Brza naplata');
            $('.PorudzbinaTotalValue').html('0');
            $('body').addClass('PayQuickPayment');
            $('.TuraOpisiTop').html('');
            $('.ArtikalOpisiTop').html('');
            $('.GostAkcija').remove();
            $('.GostiAkcije').append('<div class="GostAkcija ActiveGostAkcija" gost-number="1">G1</div>');
            $('.PorudzbinaArtikliBody').html('<div class="GostArtikli ActiveGostArtikli" gost-broj="1"></div>');
            RearangeOrder();
        } else if (WhatIsClicked == 'Gotovinski') {
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: "DajSveGotovinskeRacune=true",
                error: function () {
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                },
                complete: function (response) {
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        $('.PrikazGotovinski tbody').html(objData.RacuniNewHtml);
                        $('.Gotovinski').show();
                        var GotovinskiHeight = $('.AkcijeGotovinski').height() / 4;
                        $('.AkcijaGotovinski').attr('style', 'height: ' + GotovinskiHeight + 'px; line-height: ' + GotovinskiHeight + 'px;');
                    } else {
                        CreateWindowAlert(objData.Message, 'error');
                    }
                }
            });
        } else if (WhatIsClicked == 'Admin') {
            $('.AdminMeni').show();
            var Height = ($(window).height() / 5) - 1;
            $('.AdminMeniStavka').attr('style', 'height: ' + Height + 'px; line-height: ' + Height + 'px;');
        } else if (WhatIsClicked == 'Dostava') {
            $('.Dostava').show();
            $('body').addClass('DostavaActive');
            GetSveDostave();
            setTimeout(function () {
                var ButtonsHeight = $('.DostavaAkcije').height() / 4;
                $('.DostavaAkcija').attr('style', 'height: ' + ButtonsHeight + 'px; line-height: ' + ButtonsHeight + 'px;');
            });
            $('.DostavaSearch').focus();
        } else if (WhatIsClicked == 'Stolovi') {
            GetAktivniStolovi();
        }
    });
    $('body').delegate('.StornoKey', 'click', function () {
        var WhatIsClicked = $(this).attr('storno-key');
        var ToWhatToAdd = $('.StornoInput').val();
        if (WhatIsClicked == 'Potvrdi') {
            var StoStorno = $('.PorudzbinaSto').attr('sto-id');
            var ArtikliStorno = [];
            if ($('.RastavljanjeRight .PoruceniArtikal').length) {
                var Inc = 0;
                $('.RastavljanjeRight .PoruceniArtikal').each(function () {
                    var StavkaId = $(this).attr('stavkaracunaid');
                    var Kolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
                    ArtikliStorno[Inc] = [StavkaId, Kolicina];
                    Inc++;
                });
            } else {
                if ($('.PorudzbinaArtikliBody .OdabraniArtikal').length) {
                    var StavkaId = $('.PorudzbinaArtikliBody .OdabraniArtikal').attr('stavkaracunaid');
                    var Kolicina = $('.PorudzbinaArtikliBody .OdabraniArtikal .PorudzbinaArtikliKolicina').first().html();
                    ArtikliStorno[0] = [StavkaId, Kolicina];
                } else {
                    var Inc = 0;
                    $('.PorudzbinaArtikliBody .PoruceniArtikal').each(function () {
                        var StavkaId = $(this).attr('stavkaracunaid');
                        var Kolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
                        ArtikliStorno[Inc] = [StavkaId, Kolicina];
                        Inc++;
                    });
                }
            }
            StornirajArtikle(StoStorno, ArtikliStorno);
        } else if (WhatIsClicked == 'Delete') {
            $('.StornoInput').val(ToWhatToAdd.substring(0, ToWhatToAdd.length - 1));
        } else if (WhatIsClicked == 'Odustani') {
            $('.StornoPassword').hide();
        } else {
            $('.StornoInput').val(ToWhatToAdd + "" + WhatIsClicked);
        }
    });
    $('body').delegate('.StornoInput', 'keypress', function (evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        console.log(charCode);
        if (charCode == 13) {
            $('.StornoKey[storno-key="Potvrdi"]').click();
            return false;
        }
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    });
    $('body').delegate('.RastavljanjePassKey', 'click', function () {
        var WhatIsClicked = $(this).attr('rastavljanjePass-key');
        var ToWhatToAdd = $('.RastavljanjePassInput').val();
        if (WhatIsClicked == 'Potvrdi') {
            var SifraRas = $('.RastavljanjePassInput').val();
            if (SifraRas) {
                $.ajax({
                    type: 'POST',
                    url: './?modul=GetAjax',
                    data: 'SifraZaRastavljanje=' + SifraRas,
                    error: function () {
                        $('.Loader').hide();
                        CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                    },
                    complete: function (response) {
                        var objData = jQuery.parseJSON(response.responseText);
                        if (objData.ispravnaSifra == 'true') {
                            $('.RastavljanjePassInput').val('');
                            $('.RastavljanjePassword').hide();
                            $('.Rastavljanje').show();
                            var RastavljanjeHeight = $('.RastavljanjeCenter').height();
                            var NewButtonHeight = (parseFloat(RastavljanjeHeight) / 6) - 1;
                            $('.RastavljanjeAction').attr('style', 'height: ' + NewButtonHeight + 'px; line-height: ' + NewButtonHeight + 'px;');
                            $('.RastavljanjeSto').html($('.PorudzbinaSto').html());
                            $('.RastavljanjeLeft').html($('.StariArtikli').html());
                            $('.RastavljanjeLeft').prepend('<div class="RastavljanjeGosti"></div>');
                            $('.GostiAkcije .GostAkcija').each(function () {
                                var GostBroj = $(this).attr('gost-number');
                                $('.RastavljanjeGosti').append('<div class="RastavljanjeGostAkcija ActiveGostAkcija" gost-number="' + GostBroj + '">G' + GostBroj + '</div>');
                            });
                            $('.RastavljanjeGosti .RastavljanjeGostAkcija').first().click();
                            $('.RastavljanjeRight').html('');
                        } else {
                            CreateWindowAlert('Šifra nije dobra!', 'error');
                        }
                    }
                });
            } else {
                $('.Loader').hide();
                CreateWindowAlert('Molimo vas da unesete šifru za rastavljanje!!!', 'error');
            }
        } else if (WhatIsClicked == 'Delete') {
            $('.RastavljanjePassInput').val(ToWhatToAdd.substring(0, ToWhatToAdd.length - 1));
        } else if (WhatIsClicked == 'Odustani') {
            $('.RastavljanjePassInput').val('');
            $('.RastavljanjePassword').hide();
        } else {
            $('.RastavljanjePassInput').val(ToWhatToAdd + "" + WhatIsClicked);
        }
    });
    $('body').delegate('.RastavljanjePassInput', 'keypress', function (evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        console.log(charCode);
        if (charCode == 13) {
            $('.RastavljanjePassKey[rastavljanjePass-key="Potvrdi"]').click();
            return false;
        }
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    });
    $('body').delegate('.UnosBrojaStolaKey', 'click', function () {
        var WhatIsClicked = $(this).attr('brojStola-key');
        var ToWhatToAdd = $('.UnosBrojaStolaInput').val();
        if (WhatIsClicked == 'Potvrdi') {
            var IdStola = $('.UnosBrojaStolaInput').val();
            $('.UnosBrojaStolaInput').val('');
            if (IdStola) {
                if ($(this).hasClass('Tudji') && window.UserLevel != 'SEF') {
                    CreateWindowAlert('Ovaj sto je zauzet od strane drugog konobara!!!', 'error');
                } else {
                    $('.TuraOpisiTop').html('');
                    $('.ArtikalOpisiTop').html('');
                    if ($('body').hasClass('TransferTables')) {
                        if (IdStola == $('.PorudzbinaSto').attr('sto-id')) {
                            $('body').removeClass('TransferTables');
                        } else {
                            if ($('.RastavljanjeRight .PoruceniArtikal').length) {
                                $('.Loader').show();
                                var ArtikliZaPrebacivanje = [];
                                var StoNaKojiPrebacujemo = IdStola;
                                var StoSaKogaPrebacujemo = $('.PorudzbinaSto').attr('sto-id');
                                var Inc = 0;
                                $('.RastavljanjeRight .PoruceniArtikal').each(function () {
                                    var StavkaId = $(this).attr('stavkaracunaid');
                                    var Kolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
                                    ArtikliZaPrebacivanje[Inc] = [StavkaId, Kolicina];
                                    Inc++;
                                });
                                $.ajax({
                                    type: 'POST',
                                    url: './?modul=GetAjax',
                                    data: {TransferItems: StoNaKojiPrebacujemo, ItemsToTransfer: ArtikliZaPrebacivanje, TransferFromTable: StoSaKogaPrebacujemo},
                                    error: function () {
                                        $('.Loader').hide();
                                        CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                    },
                                    complete: function (response) {
                                        $('.Loader').hide();
                                        var objData = jQuery.parseJSON(response.responseText);
                                        if (objData.Status == 'success') {
                                            $('body').removeClass('TransferTables');
                                            $('.RastavljanjeRight').html('');
                                        } else if (objData.Status) {
                                            if (objData.Message == 'Istekla sesija ulogujte se ponovo!!!') {
                                                CreateWindowAlert(objData.Message, 'error');
                                                window.location = './logout.php';
                                            } else {
                                                CreateWindowAlert(objData.Message, 'error');
                                            }
                                        } else {
                                            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                        }
                                    }
                                });
                            } else {
                                $('body').removeClass('TransferTables');
                            }
                        }
                    } else if ($('body').hasClass('PromenaTables')) {
                        $(this).toggleClass('OdabranStoZaPromenu');
                    } else {
                        if ($(this).hasClass('Zakljucan') && window.UserMedjuzbir != '1') {
                            if (window.UserLevel != 'SEF') {
                                $('.Porudzbina').hide();
                            } else {
                                $('.Porudzbina').show();
                            }
                        } else {
                            $('.Porudzbina').show();
                        }
                        $('.TuraOpisiTop').html('');
                        $('.ArtikalOpisiTop').html('');
                        GetTableItems(IdStola);
                        CalcTotal();
                        $('.PorudzbinaSto').attr('sto-id', IdStola);
                        $('.PorudzbinaSto').html(IdStola);
                        RearangeOrder();
                    }
                }
            } else {
                $('.Loader').hide();
                CreateWindowAlert('Molimo vas da unesete broj stola!!!', 'error');
            }
        } else if (WhatIsClicked == 'Delete') {
            $('.UnosBrojaStolaInput').val(ToWhatToAdd.substring(0, ToWhatToAdd.length - 1));
        } else if (WhatIsClicked == 'Odustani') {
            $('.UnosBrojaStolaInput').val('');// $('.UnosBrojaStola').hide();
        } else {
            $('.UnosBrojaStolaInput').val(ToWhatToAdd + "" + WhatIsClicked);
        }
    });
    $('body').delegate('.UnosBrojaStolaInput', 'keypress', function (evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        console.log(charCode);
        if (charCode == 13) {
            $('.UnosBrojaStolaKey[brojStola-key="Potvrdi"]').click();
            return false;
        }
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    });
    $('body').delegate('.PromenaKey', 'click', function () {
        var WhatIsClicked = $(this).attr('promena-key');
        var ToWhatToAdd = $('.SifraOperateraInput').val();
        if (WhatIsClicked == 'Potvrdi') {
            if (ToWhatToAdd) {
                $('<div class="ModalConfirm"><h6>Da li ste sigurni da želite da promenite operatera za odabrane stolove?!</h6></div>').appendTo('body').dialog({
                    modal: true,
                    title: "Potvrda",
                    zIndex: 10000,
                    autoOpen: true,
                    width: 'auto',
                    resizable: false,
                    draggable: false,
                    buttons: {
                        "Da": function () {
                            var StoloviZaPrebacivanje = [];
                            var IncStolovi = 0;
                            $('.OdabranStoZaPromenu').each(function () {
                                var StoId = $(this).attr('stoid');
                                if (!StoId) {
                                    console.log('nema grafika');
                                    StoId = $('.UnosBrojaStolaInput').val();
                                }
                                StoloviZaPrebacivanje[IncStolovi] = StoId;
                                IncStolovi++;
                            });
                            $.ajax({
                                type: 'POST',
                                url: './?modul=GetAjax',
                                data: {
                                    PassPromenaOperatera: ToWhatToAdd,
                                    StoloviZaPromenu: StoloviZaPrebacivanje
                                },
                                error: function () {
                                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                },
                                complete: function (response) {
                                    var objData = jQuery.parseJSON(response.responseText);
                                    if (objData.Status == 'success') {
                                        $('.SifraOperatera').hide();
                                        $('.OdabirOperatera').show();
                                        $('.PromenaOperatera').hide();
                                        $('.Sto').removeClass('OdabranStoZaPromenu');
                                        $('body').removeClass('PromenaTables');
                                        $('.SifraOperateraInput').val('');
                                        CreateWindowAlert('Stolovi su uspešno prebačeni!', 'success');
                                    } else {
                                        CreateWindowAlert(objData.Message, 'error');
                                    }
                                }
                            });
                            $(this).dialog("close");
                        },
                        "Ne": function () {
                            $(this).dialog("close");
                            return false;
                        }
                    },
                    close: function (event, ui) {
                        $(this).remove();
                    }
                });
            }
        } else if (WhatIsClicked == 'Odustani') {
            $('.PromenaOperatera').hide();
        } else if (WhatIsClicked == 'Delete') {
            $('.SifraOperateraInput').val(ToWhatToAdd.substring(0, ToWhatToAdd.length - 1));
            $('.SifraOperateraInput').focus();
        } else {
            $('.SifraOperateraInput').val(ToWhatToAdd + '' + WhatIsClicked);
            $('.SifraOperateraInput').focus();
        }
    });
    $('body').delegate('.SifraOperatera', 'keypress', function (evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        console.log(charCode);
        if (charCode == 13) {
            $('.PromenaKey[promena-key="Potvrdi"]').click();
            return false;
        }
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    });
    $('body').delegate('.PromenaOperateraOdustani', 'click', function () {
        $('.PromenaOperatera').hide();
    });
    $('body').delegate('.Operater', 'click', function () {
        $('.Operater').removeClass('OdabraniOperater');
        $(this).addClass('OdabraniOperater');
        $('.SifraOperatera').show();
        $('.OdabirOperatera').hide();
        $('.SifraOperateraInput').focus();
    });
    $('body').delegate('.GostiKey', 'click', function () {
        var WhatIsClicked = $(this).attr('gost-key');
        var ToWhatToAdd = $('.BrojPosluzenihGostiju').val();
        if (WhatIsClicked == 'Potvrdi') {
            if (ToWhatToAdd) {
                NaplatiRacun();
                $('.UsluzeniGosti').hide();
            } else {
                CreateWindowAlert('Molimo Vas da unesete broj usluženih gostiju!', 'error');
            }
        } else if (WhatIsClicked == 'Odustani') {
            $('.UsluzeniGosti').hide();
            $('.StalniGostValue').removeAttr('komitent-id');
        } else if (WhatIsClicked == 'Delete') {
            $('.BrojPosluzenihGostiju').val(ToWhatToAdd.substring(0, ToWhatToAdd.length - 1));
            $('.BrojPosluzenihGostiju').focus();
        } else {
            $('.BrojPosluzenihGostiju').val(ToWhatToAdd + '' + WhatIsClicked);
            $('.BrojPosluzenihGostiju').focus();
        }
    });
    $('body').delegate('.BrojPosluzenihGostiju', 'keypress', function (evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        console.log(charCode);
        if (charCode == 13) {
            $('.GostiKey[gost-key="Potvrdi"]').click();
            return false;
        }
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    });
    $('body').delegate('.PrikazGotovinski tbody tr', 'click', function () {
        $('.PrikazGotovinski tr').removeClass('SelectedRacun');
        $(this).addClass('SelectedRacun');
    });
    $('body').delegate('.GotovinskiRacun input', 'click focusin', function () {
        $('.GotovinskiRacun input').removeClass('GotovinskiFocus');
        $(this).addClass('GotovinskiFocus');
    });
    $('body').delegate('.AkcijaGotovinski', 'click', function () {
        var WhatIsClicked = $(this).attr('gotovinski-akcija');
        if (WhatIsClicked == 'Izlaz') {
            $('.Gotovinski').hide();
        } else if (WhatIsClicked == 'Potvrdi') {
            if ($('.PrikazGotovinski .SelectedRacun').length) {
                $('.GotovinskiRacun').show();
                $('.FindGotovinski').focus();
                var GotovinskiKupciAkcija = $('.GotovinskiKupciAkcije').height() / 4;
                $('.GotovinskiKupciAkcija').attr('style', 'height: ' + GotovinskiKupciAkcija + 'px; line-height: ' + GotovinskiKupciAkcija + 'px;');
            } else {
                CreateWindowAlert('Najpre odaberite račun!', 'error');
            }
        } else if (WhatIsClicked == 'Gore') {
            var Selected = $('.PrikazGotovinski .SelectedRacun');
            $('.PrikazGotovinski tbody tr').removeClass('SelectedRacun');
            if (Selected.length) {
                Selected.prev('tr').addClass('SelectedRacun');
            } else {
                $('.PrikazGotovinski tbody tr').last().addClass('SelectedRacun');
            }
        } else if (WhatIsClicked == 'Dole') {
            var Selected = $('.PrikazGotovinski .SelectedRacun');
            $('.PrikazGotovinski tbody tr').removeClass('SelectedRacun');
            if (Selected.length) {
                Selected.next('tr').addClass('SelectedRacun');
            } else {
                $('.PrikazGotovinski tbody tr').first().addClass('SelectedRacun');
            }
        }
    });
    $('body').delegate('.FindGotovinski', 'change focusin keyup', function () {
        var value = $(this).val().toLowerCase();
        if (value) {
            $(".GotovinskiKupci tbody tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
            });
        } else {
            $(".GotovinskiKupci tbody tr").removeAttr('style');
        }
    });
    $('body').delegate('.Gotovinski .QwertyKeys', 'click', function () {
        var WhatIsPressed = $(this).attr('qwerty-value');
        if (WhatIsPressed == 'Delete') {
            var ValToDelete = $('.GotovinskiFocus').val();
            $('.GotovinskiFocus').val(ValToDelete.substring(0, ValToDelete.length - 1));
        } else if (WhatIsPressed == 'Zatvori') {
            if ($('.KreiranjeGotovinskog').is(':visible')) {
                $('.KreiranjeGotovinskog').hide();
            } else {
                $('.GotovinskiRacun').hide();
                $('.GotovinskiRacun input').each(function () {
                    $(this).val('');
                });
            }
        } else if (WhatIsPressed == 'Enter') {
            if ($('.KreiranjeGotovinskog').is(':visible')) {
                $('.CreateGotovinski').submit();
            } else {
                $('.GotovinskiKupciAkcija[gotovinski-akcija="A4"]').click();
            }
        } else {
            var ValToAdd = $('.GotovinskiFocus').val();
            $('.GotovinskiFocus').val(ValToAdd + WhatIsPressed);
        }
        $('.GotovinskiFocus').focus();
    });
    $('body').delegate('.GotovinskiKupciAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('gotovinski-akcija');
        if (WhatIsClicked == 'Izlaz') {
            $('.GotovinskiRacun').hide();
            $('.GotovinskiRacun input').each(function () {
                $(this).val('');
            });
        } else if (WhatIsClicked == 'Uska') {
            if ($('.SelectedGotovinski').length) {
                var Racun = $('.SelectedRacun').attr('racun-id');
                var Kupac = $('.SelectedGotovinski').attr('komitent-id');
                var IsKomitent = $('.SelectedGotovinski').attr('iskomitent');
                var BrojIsecka = $('.BrojIseckaGotovinski').val();
                if (Kupac == IsKomitent) {
                    $.ajax({
                        type: 'POST',
                        url: './?modul=GetAjax',
                        data: 'CreateGotovinskiRacunUska=' + Racun + '&KomitentGotovinskiRacunUska=' + Kupac + '&BrojIsecka=' + BrojIsecka,
                        error: function () {
                            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                        },
                        complete: function (response) {
                            var objData = jQuery.parseJSON(response.responseText);
                            if (objData.Status == 'success') {
                                $('.GotovinskiRacun').hide();
                                $('.Gotovinski').hide();
                                CreateWindowAlert('Gotovinski račun je poslat na štampu!', 'success');
                                if (window.smenski_rad_odjava == 'true') {
                                    setTimeout(function () {
                                        window.location = './logout.php';
                                    }, 500);
                                }
                            } else {
                                CreateWindowAlert(objData.Message, 'error');
                            }
                        }
                    });
                } else {
                    $.ajax({
                        type: 'POST',
                        url: './?modul=GetAjax',
                        data: 'CreateGotovinskiRacunUska=' + Racun + '&StalniGostGotovinskiRacunUska=' + Kupac + '&BrojIsecka=' + BrojIsecka,
                        error: function () {
                            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                        },
                        complete: function (response) {
                            var objData = jQuery.parseJSON(response.responseText);
                            if (objData.Status == 'success') {
                                $('.GotovinskiRacun').hide();
                                $('.Gotovinski').hide();
                                CreateWindowAlert('Gotovinski račun je poslat na štampu!', 'success');
                                if (window.smenski_rad_odjava == 'true') {
                                    setTimeout(function () {
                                        window.location = './logout.php';
                                    }, 500);
                                }
                            } else {
                                CreateWindowAlert(objData.Message, 'error');
                            }
                        }
                    });
                }
            } else {
                CreateWindowAlert('Najpre odaberite kupca!', 'error');
            }
        } else if (WhatIsClicked == 'A4') {
            if ($('.SelectedGotovinski').length) {
                var Racun = $('.SelectedRacun').attr('racun-id');
                var Kupac = $('.SelectedGotovinski').attr('komitent-id');
                var IsKomitent = $('.SelectedGotovinski').attr('iskomitent');
                var BrojIsecka = $('.BrojIseckaGotovinski').val();
                if (Kupac == IsKomitent) {
                    window.open('./?modul=gotovinski&id=' + Racun + '&komitent=' + Kupac + '&BrojIsecka=' + BrojIsecka);
                } else {
                    window.open('./?modul=gotovinski&id=' + Racun + '&stalnigost=' + Kupac + '&BrojIsecka=' + BrojIsecka);
                }
                $('.Gotovinski input').each(function () {
                    $(this).val('');
                });
                $('.GotovinskiRacun').hide();
                $('.Gotovinski').hide();
                if (window.smenski_rad_odjava == 'true') {
                    setTimeout(function () {
                        window.location = './logout.php';
                    }, 1500);
                }
            } else {
                CreateWindowAlert('Najpre odaberite kupca!', 'error');
            }
        } else if (WhatIsClicked == 'Novi') {
            $('.KreiranjeGotovinskog').show();
        }
    });
    $('body').delegate('.CreateGotovinski', 'submit', function () {
        if (CheckForm(this) == 1) {
            CreateWindowAlert('Popunite sva tražena polja!!!', 'error');
            return false;
        }
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: $(this).serialize(),
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    $('.GotovinskiKupci tbody tr').removeClass('SelectedGotovinski');
                    $('.GotovinskiKupci tbody').append(objData.GotovinskiNewHtml);
                    $('.KreiranjeGotovinskog').hide();
                    $('.KreiranjeGotovinskog input').each(function () {
                        $(this).val('');
                    });
                    $(".GotovinskiKupci").scrollTop($(".GotovinskiKupci")[0].scrollHeight);
                    CreateWindowAlert('Kupac je uspešno kreiran!', 'success');
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                }
            }
        });
        return false;
    });
    $('body').delegate('.GotovinskiKupci tbody tr', 'click', function () {
        $('.GotovinskiKupci tbody tr').removeClass('SelectedGotovinski');
        $(this).addClass('SelectedGotovinski');
    });
    $('body').delegate('.FakturaKupciAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('gotovinski-akcija');
        if (WhatIsClicked == 'Izlaz') {
            $('.Faktura').hide();
            $('.Faktura input').each(function () {
                $(this).val('');
            });
        } else if (WhatIsClicked == 'Novi') {
            $('.KreiranjeFakture').show();
        } else if (WhatIsClicked == 'Potvrdi') {
            if ($('.Faktura tbody .SelectedFaktura').length) {
                var GostId = $('.Faktura tbody .SelectedFaktura').attr('komitent-id');
                var GostPopust = $('.Faktura tbody .SelectedFaktura').attr('popustkomitenta');
                var GostName = $('.Faktura tbody .SelectedFaktura').find('td').first().text();
                var GostPib = $('.Faktura tbody .SelectedFaktura').attr('pibkomitenta');
                var IznosValue = $('.IznosValue').val();
                var PopustValue = 0;
                var ZaUplatu = IznosValue;
                if (parseInt(GostPopust) > 0) {
                    var ArtikalPopust = 0;
                    var ArtikalIznos = 0;
                    if ($('body').hasClass('PayTransferedTables')) {
                        $('.RastavljanjeRight .PoruceniArtikal').each(function () {
                            var ArtikalId = $(this).attr('idporucenog');
                            var ArtikalCena = $(this).attr('cenaporucenog');
                            var ArtikalKolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
                            var IsPopustAllowed = $('.Artikli .Artikal[idartikla="' + ArtikalId + '"]').first().attr('dozvoljenpopust');
                            if (IsPopustAllowed == '1') {
                                ArtikalPopust = parseFloat(ArtikalPopust) + ((parseFloat(ArtikalCena) * (0 + (parseFloat(GostPopust) / 100))) * parseFloat(ArtikalKolicina));
                                ArtikalIznos = parseFloat(ArtikalIznos) + ((parseFloat(ArtikalCena) * parseFloat(ArtikalKolicina)) - ((parseFloat(ArtikalCena) * (0 + (parseFloat(GostPopust) / 100))) * parseFloat(ArtikalKolicina)));
                            } else {
                                ArtikalIznos = parseFloat(ArtikalIznos) + (parseFloat(ArtikalCena) * parseFloat(ArtikalKolicina));
                            }
                        });
                    } else {
                        $('.PorudzbinaArtikliBody .PoruceniArtikal').each(function () {
                            var ArtikalId = $(this).attr('idporucenog');
                            var ArtikalCena = $(this).attr('cenaporucenog');
                            var ArtikalKolicina = $(this).find('.PorudzbinaArtikliKolicina').first().html();
                            var IsPopustAllowed = $('.Artikli .Artikal[idartikla="' + ArtikalId + '"]').first().attr('dozvoljenpopust');
                            if (IsPopustAllowed == '1') {
                                ArtikalPopust = parseFloat(ArtikalPopust) + ((parseFloat(ArtikalCena) * (0 + (parseFloat(GostPopust) / 100))) * parseFloat(ArtikalKolicina));
                                ArtikalIznos = parseFloat(ArtikalIznos) + ((parseFloat(ArtikalCena) * parseFloat(ArtikalKolicina)) - ((parseFloat(ArtikalCena) * (0 + (parseFloat(GostPopust) / 100))) * parseFloat(ArtikalKolicina)));
                            } else {
                                ArtikalIznos = parseFloat(ArtikalIznos) + (parseFloat(ArtikalCena) * parseFloat(ArtikalKolicina));
                            }
                        });
                    }
                    PopustValue = ArtikalPopust;
                    ZaUplatu = ArtikalIznos;
                }
                $('.PopustValue').val(parseFloat(PopustValue).toFixed(2));
                $('.UkupnoValue').val(parseFloat(ZaUplatu).toFixed(2));
                $('.UplacenoValue').val(parseFloat(ZaUplatu).toFixed(2));
                $('.UplacenoValue').focus().select();
                CalcKusur();

                $('.StalniGostValue').val(GostName);
                $('.PopustPercentValue').val(GostPopust);
                $('.StalniGostValue').attr('komitent-id', GostId);
                $('.StalniGostValue').attr('stalnigost-id', GostId);
                if (GostPib != "") {
                    $('.OFPibKupca').val(GostPib);
                    $('.OFPibKupcaID').val('10');
                }
                $('.Faktura').hide();
                $('.Faktura input').each(function () {
                    $(this).val('');
                });
                $('.FakturaFormat').val('A4');

                $('.NaplataButton[buton-action="Potvrdi"]').click();
            } else {
                CreateWindowAlert('Najpre odaberite kupca!!!', 'error');
            }
        }
    });
    $('body').delegate('.Faktura .QwertyKeys', 'click', function () {
        var WhatIsPressed = $(this).attr('qwerty-value');
        if (WhatIsPressed == 'Delete') {
            var ValToDelete = $('.FakturaFocus').val();
            $('.FakturaFocus').val(ValToDelete.substring(0, ValToDelete.length - 1));
        } else if (WhatIsPressed == 'Zatvori') {
            if ($('.KreiranjeFakture').is(':visible')) {
                $('.KreiranjeFakture').hide();
            } else {
                $('.Faktura').hide();
                $('.Faktura input').each(function () {
                    $(this).val('');
                });
            }
        } else if (WhatIsPressed == 'Enter') {
            if ($('.KreiranjeFakture').is(':visible')) {
                $('.CreateFaktura').submit();
            } else {
                if ($('.Faktura tbody .SelectedFaktura').length) {
                    var KomitentId = $('.Faktura tbody .SelectedFaktura').attr('komitent-id');
                    $('.StalniGostValue').attr('komitent-id', KomitentId);
                    $('.Faktura').hide();
                    $('.Faktura input').each(function () {
                        $(this).val('');
                    });
                    $('.NaplataButton[buton-action="Potvrdi"]').click();
                } else {
                    CreateWindowAlert('Najpre odaberite kupca!!!', 'error');
                }
            }
        } else {
            var ValToAdd = $('.FakturaFocus').val();
            $('.FakturaFocus').val(ValToAdd + WhatIsPressed);
        }
        $('.FakturaFocus').focus();
    });
    $('body').delegate('.CreateFaktura', 'submit', function () {
        if (CheckForm(this) == 1) {
            CreateWindowAlert('Popunite sva tražena polja!!!', 'error');
            return false;
        }
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: $(this).serialize(),
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    $('.Faktura tbody tr').removeClass('SelectedFaktura');
                    $('.Faktura tbody').append(objData.FakturaNewHtml);
                    $('.KreiranjeFakture').hide();
                    $('.Faktura input').each(function () {
                        $(this).val('');
                    });
                    $(".FakturaKupci").scrollTop($(".FakturaKupci")[0].scrollHeight);
                    CreateWindowAlert('Kupac je uspešno kreiran!', 'success');
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                }
            }
        });
        return false;
    });
    $('body').delegate('.Faktura tbody tr', 'click', function () {
        $('.Faktura tr').removeClass('SelectedFaktura');
        $(this).addClass('SelectedFaktura');
    });
    $('body').delegate('.Faktura input', 'click focusin', function () {
        $('.Faktura input').removeClass('FakturaFocus');
        $(this).addClass('FakturaFocus');
    });
    $('body').delegate('.FindKupca', 'change focusin keyup', function () {
        var value = $(this).val().toLowerCase();
        if (value) {
            $(".Faktura tbody tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
            });
        } else {
            $(".Faktura tbody tr").removeAttr('style');
        }
    });
    $('body').delegate('.FakturaBiKey', 'click', function () {
        var WhatIsClicked = $(this).attr('gost-key');
        var ToWhatToAdd = $('.FakturaBrojIsecka').val();
        if (WhatIsClicked == 'Potvrdi') {
            if (ToWhatToAdd) {
                var Racun = $('.FakturaBrojRacuna').val();
                window.open('./?modul=faktura&id=' + Racun + '&BrojIsecka=' + ToWhatToAdd);
                $('.FakturaBi').hide();
                $('.FakturaBrojRacuna').val('');
                $('.FakturaBrojIsecka').val('');
                if (window.smenski_rad_odjava == 'true') {
                    setTimeout(function () {
                        window.location = './logout.php';
                    }, 1500);
                }
            } else {
                CreateWindowAlert('Molimo Vas da unesete broj fiskalnog isečka!', 'error');
            }
        } else if (WhatIsClicked == 'Odustani') {
            $('.FakturaBi').hide();
            if (ToWhatToAdd) {
                var Racun = $('.FakturaBrojRacuna').val();
                window.open('./?modul=faktura&id=' + Racun + '&BrojIsecka=' + ToWhatToAdd);
                $('.FakturaBi').hide();
            }
            $('.FakturaBrojRacuna').val('');
            $('.FakturaBrojIsecka').val('');
        } else if (WhatIsClicked == 'Delete') {
            $('.FakturaBrojIsecka').val(ToWhatToAdd.substring(0, ToWhatToAdd.length - 1));
            $('.FakturaBrojIsecka').focus();
        } else {
            $('.FakturaBrojIsecka').val(ToWhatToAdd + '' + WhatIsClicked);
            $('.FakturaBrojIsecka').focus();
        }
    });
    $('body').delegate('.FakturaBrojIsecka', 'keypress', function (evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        console.log(charCode);
        if (charCode == 13) {
            $('.FakturaBiKey[gost-key="Potvrdi"]').click();
            return false;
        }
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    });
    $('body').delegate('.AdminMeniStavka', 'click', function () {
        var WhatIsClicked = $(this).attr('admin-stavka');
        if (WhatIsClicked == 'Izlaz') {
            $('.AdminMeni').hide();
        } else if (WhatIsClicked == 'PresekStanja') {
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: "FiskalniIzvestajPresekStanja=true",
                error: function () {
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                },
                complete: function (response) {
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        $('.AdminMeni').hide();
                        CreateWindowAlert('Presek stanja je poslat na štampu!!!', 'success');
                    } else {
                        CreateWindowAlert('Nepoznata greska!', 'error');
                    }
                }
            });
        } else if (WhatIsClicked == 'DnevniIzvestaj') {
            $('.Loader').show();
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: "FiskalniIzvestajDnevniIzvestaj=true",
                error: function () {
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                    $('.Loader').hide();
                },
                complete: function (response) {
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        $('.AdminMeni').hide();
                        CreateWindowAlert('Dnevni izveštaj je poslat na štampu!!!', 'success');
                        setTimeout(function () {
                            open(location, '_self').close();
                        }, 500);
                    } else {
                        CreateWindowAlert('Nepoznata greska!', 'error');
                    }
                    $('.Loader').hide();
                }
            });
        } else if (WhatIsClicked == 'PopisnaLista') {
            $('.OdaberiTipStampePopis').show();
            $('.OdaberiTipStampePopis').attr('tipizvestaja', 'PopisnaLista');
            //window.open('./?modul=popisnalista');
        } else if (WhatIsClicked == 'IzvestajStorno') {
            $('.OdaberiTipStampe').show();
            $('.OdaberiTipStampe').attr('tipizvestaja', 'IzvestajStorno');
            //window.open('./?modul=stornolista');
        } else if (WhatIsClicked == 'IzvestajSvi') {
            $('.OdaberiTipStampe').show();
            $('.OdaberiTipStampe').attr('tipizvestaja', 'IzvestajSvi');
            //window.open('./?modul=prodajasvi');
        } else if (WhatIsClicked == 'IzvestajOperater') {
            $('.OdaberiTipStampe').show();
            $('.OdaberiTipStampe').attr('tipizvestaja', 'IzvestajOperater');
            //window.open('./?modul=prodajaoperater');
        } else if (WhatIsClicked == 'Periodicni') {
            $('.OdaberiDatum').show();
        } else if (WhatIsClicked == 'PregledRacuna') {
            if ($('.Efiskalizacija').length) {
                GetJournalData('1');
            } else {
                $.ajax({
                    type: 'POST',
                    url: './?modul=GetAjax',
                    data: "PregledSvihRacuna=true",
                    error: function () {
                        CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                    },
                    complete: function (response) {
                        var objData = jQuery.parseJSON(response.responseText);
                        if (objData.Status == 'success') {
                            $('.SviRacuniLeft tbody').html(objData.RacuniHtml)
                            $('.SviRacuni').show();
                        } else if (objData.Message != '') {
                            CreateWindowAlert(objData.Message, 'error');
                        } else {
                            CreateWindowAlert('Nepoznata greska!', 'error');
                        }
                    }
                });
            }
        } else if (WhatIsClicked == 'Razduzenje') {
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: "GetOperater3=true",
                error: function () {
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                },
                complete: function (response) {
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        $('.TriTrojkeContent').html(objData.RacuniHtml)
                        $('.TriTrojke').show();
                        var TriTrojkeRightHeight = $('.TriTrojke').height();
                        var ButtonHeight = parseFloat(TriTrojkeRightHeight) / 4;
                        $('.TriTrojkeAction').attr('style', 'height:' + ButtonHeight + 'px;line-height:' + ButtonHeight + 'px;');
                    } else {
                        CreateWindowAlert('Nepoznata greska!', 'error');
                    }
                }
            });
        } else if (WhatIsClicked == 'SetupKase') {
            $('.PodesavanjeKase').show();
            var HeightPodesavanjaAkcije = $('.PodesavanjaAkcije').height();
            var DugmadHeight = HeightPodesavanjaAkcije / 2;
            $('.PodesavanjaAkcijePotvrdi').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');
            $('.PodesavanjaAkcijeOtkazi').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');
        } else if (WhatIsClicked == 'NazadPodesavanja') {
            $('.AdminMeniPodesavanja').hide();
        } else if (WhatIsClicked == 'Podesavanja') {
            $('.AdminMeniPodesavanja').show();
        } else if (WhatIsClicked == 'SetupGrupa') {
            PreuzmiSveGrupe();
            $('.PodesavanjeGrupa').show();
            var HeightPodesavanjaAkcije = $('.PodesavanjeGrupaAkcije').height();
            var DugmadHeight = HeightPodesavanjaAkcije / 4;
            $('.PodesavanjeGrupaAkcija').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');
        } else if (WhatIsClicked == 'SetupPodGrupa') {
            PreuzmiSvePodGrupe();
            PreuzmiSveGrupe();
            $('.PodesavanjePodGrupa').show();
            var HeightPodesavanjaAkcije = $('.PodesavanjePodGrupaAkcije').height();
            var DugmadHeight = HeightPodesavanjaAkcije / 4;
            $('.PodesavanjePodGrupaAkcija').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');
        } else if (WhatIsClicked == 'SetupStampaca') {
            PreuzmiSveStampace();
            $('.PodesavanjeStampaca').show();
            var HeightPodesavanjaAkcije = $('.PodesavanjeStampacaAkcije').height();
            var DugmadHeight = HeightPodesavanjaAkcije / 4;
            $('.PodesavanjeStampacaAkcija').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');
        } else if (WhatIsClicked == 'SetupArtikala') {
            PreuzmiSveStampace();
            PreuzmiSvePodGrupe();
            $('.PodesavanjePretragaNaziv').val('');
            $('.PodesavanjePretragaPodGrupa').val('');
            $('.PodesavanjeArtikalaLista').val('');
            $('.PodesavanjeArtikala').show();
            var HeightPodesavanjaAkcije = $('.PodesavanjeArtikalaAkcije').height();
            var DugmadHeight = HeightPodesavanjaAkcije / 6;
            $('.PodesavanjeArtikalaAkcija').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');
        } else if (WhatIsClicked == 'SetupKonobara') {
            PreuzmiSveKonobare();
            $('.PodesavanjeKonobara').show();
            var HeightPodesavanjaAkcije = $('.PodesavanjeKonobaraAkcije').height();
            var DugmadHeight = HeightPodesavanjaAkcije / 4;
            $('.PodesavanjeKonobaraAkcija').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');
        } else if (WhatIsClicked == 'SetupSyncVat') {
            PreuzmiSvePoreskeStope();
            $('.PodesavanjeStopa').show();
            var HeightPodesavanjaAkcije = $('.PodesavanjeStopaAkcije').height();
            var DugmadHeight = HeightPodesavanjaAkcije / 2;
            $('.PodesavanjeStopaAkcija').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');
        }
    });
    $('body').delegate('.OtkaziDatum', 'click', function () {
        $('.OdaberiDatum').hide();
    });
    $('body').delegate('.PotvrdiDatum', 'click', function () {
        $('.OdaberiDatum').hide();
        var DatumOd = $('#DateFromF').val();
        var DatumDo = $('#DateToF').val();
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: "DatumPresekOd=" + DatumOd + "&DatumPresekDo=" + DatumDo,
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    $('.AdminMeni').hide();
                    CreateWindowAlert('Periodični izveštaj je poslat na štampu!!!', 'success');
                } else {
                    CreateWindowAlert('Nepoznata greska!', 'error');
                }
            }
        });
    });
    $('body').delegate('.SviRacuniAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('akcija');
        if (WhatIsClicked == 'PrintFiscal') {
            if ($('.SviRacuni .SelectedRacun').length) {
                var Racun = $('.SviRacuni .SelectedRacun').attr('racun-id');
                $.ajax({
                    type: 'POST',
                    url: './?modul=GetAjax',
                    data: "CreateFiskalAgain=" + Racun,
                    error: function () {
                        CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                    },
                    complete: function (response) {
                        var objData = jQuery.parseJSON(response.responseText);
                        if (objData.Status == 'success') {
                            CreateWindowAlert('Fiskalni račun je poslat na štampu!', 'success');
                            $('.SviRacuni').hide();
                        } else {
                            CreateWindowAlert(objData.Message, 'error');
                        }
                    }
                });
            } else {
                CreateWindowAlert('Najpre odaberite račun!!!', 'error');
            }
        } else if (WhatIsClicked == 'Izlaz') {
            $('.SviRacuni').hide();
        } else if (WhatIsClicked == 'PrintMemo') {
            if ($('.SviRacuni .SelectedRacun').length) {
                var Racun = $('.SviRacuni .SelectedRacun').attr('racun-id');
                window.open('./?modul=gotovinski&id=' + Racun);
                $('.SviRacuni').hide();
            } else {
                CreateWindowAlert('Najpre odaberite račun!!!', 'error');
            }
        }
    });
    $('body').delegate('.SviRacuni tr', 'click', function () {
        $('.SviRacuni tr').removeClass('SelectedRacun');
        $(this).addClass('SelectedRacun');
    });
    $('body').delegate('.ReloadTura', 'click', function () {
        var TuraId = $(this).parents('.StoTura').first().attr('id-ture');
        var ArtikliKolicine = [];
        $('.StoTura[id-ture="' + TuraId + '"] .PoruceniArtikal').each(function () {
            var ThisArtikalKolicina = $(this).attr('stavkaracunakolicina');
            var ThisArtikalId = $(this).attr('idporucenog');
            var ThisArtikalOpis = $(this).attr('stavkaracunaopis');
            ArtikliKolicine.push([ThisArtikalKolicina, ThisArtikalId, ThisArtikalOpis]);
        });
        $('<div class="ModalConfirm"><h6>Da li ste sigurni da želite da ponovite porudžbinu?!</h6></div>').appendTo('body').dialog({
            modal: true,
            title: "Potvrda",
            zIndex: 10000,
            autoOpen: true,
            width: 'auto',
            resizable: false,
            draggable: false,
            buttons: {
                "Da": function () {
                    $('.PorudzbinaArtikliBody').html('');
                    $('.GostiAkcije .GostAkcija').each(function () {
                        var WhatIs = $(this).attr('gost-number');
                        var HasClass = '';
                        if ($(this).hasClass('ActiveGostAkcija')) {
                            HasClass = 'ActiveGostArtikli';
                        }
                        $('.PorudzbinaArtikliBody').append('<div class="GostArtikli ' + HasClass + '" gost-broj="' + WhatIs + '"></div>');
                    });
                    var SelectedGost = $('.ActiveGostAkcija').attr('gost-number');
                    if (!SelectedGost) {
                        SelectedGost = 1;
                    }
                    $.each(ArtikliKolicine, function (key, value) {
                        var Kolicina = value[0];
                        var ArtikalId = value[1];
                        var Opis = value[2];
                        var ArtikalTip = $('.Artikal[idartikla="' + ArtikalId + '"]').first().attr('tipartikla');
                        var ArtikalPrice = $('.Artikal[idartikla="' + ArtikalId + '"]').first().attr('cenaartikla');
                        var ArtikalName = $('.Artikal[idartikla="' + ArtikalId + '"]').first().find('span').first().text();
                        $.ajax({
                            type: 'POST',
                            url: './?modul=GetAjax',
                            data: 'GetArticlePrice=' + ArtikalId,
                            async: false,
                            error: function () {
                                ArtikalNewPrice = 0;
                                if (ArtikalNewPrice > 0) {
                                    ArtikalPrice = ArtikalNewPrice;
                                }
                                var KolikoArtikala = Kolicina;
                                if (KolikoArtikala != '') {
                                    if (isNaN(KolikoArtikala)) {
                                        KolikoArtikala = 1;
                                    }
                                } else {
                                    KolikoArtikala = 1;
                                }
                                var IznosArtikala = parseFloat(KolikoArtikala) * parseFloat(ArtikalPrice);
                                if (Opis.length > 0) {
                                    var ArtikalHtml = '<div class="PoruceniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="OpisArtikla"><div class="OpisIcon"><i class="fa fa-edit"></i></div><div class="OpisContent">' + Opis + '</div></div><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + IznosArtikala + '</div></div>';
                                } else {
                                    var ArtikalHtml = '<div class="PoruceniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + IznosArtikala + '</div></div>';
                                }
                                $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                                $('.AktivanStoAkcije').show();
                                $('.PrazanStoAkcije').hide();
                                $('.PunStoAkcije').hide();
                                $('.NumerikInput').val('');
                                CalcTotal();
                            },
                            complete: function (response) {
                                var objData = jQuery.parseJSON(response.responseText);
                                if (objData.Status == 'success') {
                                    ArtikalNewPrice = objData.Price;
                                } else {
                                    ArtikalNewPrice = 0;
                                }
                                if (ArtikalNewPrice > 0) {
                                    ArtikalPrice = ArtikalNewPrice;
                                }

                                var KolikoArtikala = Kolicina;
                                if (KolikoArtikala != '') {
                                    if (isNaN(KolikoArtikala)) {
                                        KolikoArtikala = 1;
                                    }
                                } else {
                                    KolikoArtikala = 1;
                                }
                                var IznosArtikala = parseFloat(KolikoArtikala) * parseFloat(ArtikalPrice);

                                if (Opis.length > 0) {
                                    var ArtikalHtml = '<div class="PoruceniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="OpisArtikla"><div class="OpisIcon"><i class="fa fa-edit"></i></div><div class="OpisContent">' + Opis + '</div></div><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + IznosArtikala + '</div></div>';
                                } else {
                                    var ArtikalHtml = '<div class="PoruceniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + IznosArtikala + '</div></div>';
                                }
                                $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                                $('.AktivanStoAkcije').show();
                                $('.PrazanStoAkcije').hide();
                                $('.PunStoAkcije').hide();
                                $('.NumerikInput').val('');
                                CalcTotal();
                            }
                        });
                    });
                    $(this).dialog("close");
                },
                "Ne": function () {
                    $(this).dialog("close");
                    return false;
                }
            },
            close: function (event, ui) {
                $(this).remove();
            }
        });

    });
    $('body').delegate('.CloseMenu', 'click', function () {
        $('.Meni').hide();
    });
    $('body').delegate('.ConfirmMenu', 'click', function () {
        if ($('.MenuSelected').length) {
            var Kolicina = $('.MenuKolicina').val();
            var Cena = $('.MenuCena').val();
            var Ukupno = $('.MenuUkupno').val();
            var MenuName = $('.MenuSelected').attr('menu-name');
            var MenuId = $('.MenuSelected').attr('menu-id');
            if (parseFloat(Ukupno) > 0) {
                $('<div class="ModalConfirm"><h6>Da li ste sigurni da želite da odaberete meni ' + MenuName + '?!</h6><div>Kolicina: ' + Kolicina + '</div><div>Cena: ' + Cena + '</div><div>Ukupno: ' + Ukupno + '</div></div>').appendTo('body').dialog({
                    modal: true,
                    title: "Potvrdite odabir",
                    zIndex: 10000,
                    autoOpen: true,
                    width: 'auto',
                    resizable: false,
                    draggable: false,
                    buttons: {
                        "Da": function () {
                            $('.Meni').hide();
                            $('.NaplataButton[buton-action="MeniNaplata"]').addClass('SelectedOption');
                            $('.IznosValue').val(parseFloat(Ukupno).toFixed(2));
                            $('.UplacenoValue').val(parseFloat(Ukupno).toFixed(2));
                            $('.SelectedMenuItem').attr('menu-id', MenuId);
                            $('.SelectedMenuItem').attr('menu-name', MenuName);
                            var GostPopust = $('.StalniGosti .SelectedGost').attr('gost-popust');
                            var IznosValue = $('.IznosValue').val();
                            var PopustValue = 0;
                            var ZaUplatu = IznosValue;
                            if (parseInt(GostPopust) > 0) {
                                PopustValue = parseFloat(IznosValue) * (0 + (parseFloat(GostPopust) / 100));
                                ZaUplatu = parseFloat(IznosValue) - parseFloat(PopustValue);
                            }
                            $('.PopustValue').val(parseFloat(PopustValue).toFixed(2));
                            $('.UkupnoValue').val(parseFloat(ZaUplatu).toFixed(2));
                            $('.UplacenoValue').val(parseFloat(ZaUplatu).toFixed(2));
                            CalcKusur();
                            $(this).dialog("close");
                        },
                        "Ne": function () {
                            $(this).dialog("close");
                            return false;
                        }
                    },
                    close: function (event, ui) {
                        $(this).remove();
                    }
                });
            } else {
                CreateWindowAlert('Najpre popunite neophodna polja!', 'error');
            }
        } else {
            CreateWindowAlert('Najpre odaberite meni!', 'error');
        }
    });
    $('body').delegate('.MenuItem', 'click', function () {
        $('.MenuItem').removeClass('MenuSelected');
        $(this).addClass('MenuSelected');
    });
    $('body').delegate('.MeniAction', 'click', function () {
        var Action = $(this).attr('action');
        if (Action == 'Up') {
            if ($('.MenuSelected').length) {
                $('.MenuSelected').next('.MenuItem').click();
            } else {
                $('.MenuItem').last().click();
            }
        } else if (Action == 'Down') {
            if ($('.MenuSelected').length) {
                $('.MenuSelected').prev('.MenuItem').click();
            } else {
                $('.MenuItem').first().click();
            }
        } else if (Action == 'Novi') {
            $('.CreateMenu').show();
            $('.NewMenuName').focus();
        }
    });
    $('body').delegate('.MenuKolicina', 'click focus', function () {
        $('.MenuInput input').removeClass('MenuInputFocus');
        $(this).addClass('MenuInputFocus');
    });
    $('body').delegate('.MenuCena', 'click focus', function () {
        $('.MenuInput input').removeClass('MenuInputFocus');
        $(this).addClass('MenuInputFocus');
    });
    $('body').delegate('.MenuKey', 'click', function () {
        if (!$('.MenuInputFocus').length) {
            $('.MenuKolicina').addClass('MenuInputFocus');
        }
        var WhatIsClicked = $(this).attr('data-key');
        var ToWhatToAdd = $('.MenuInputFocus').val();
        if (WhatIsClicked == 'delete') {
            $('.MenuInputFocus').val(ToWhatToAdd.substring(0, ToWhatToAdd.length - 1));
            $('.MenuInputFocus').focus();
        } else if (WhatIsClicked == '.') {
            if (ToWhatToAdd.includes('.')) {
                CreateWindowAlert('Neispravan unos!!!', 'error');
            } else {
                $('.MenuInputFocus').val(ToWhatToAdd + "" + WhatIsClicked);
            }
        } else {
            $('.MenuInputFocus').val(ToWhatToAdd + '' + WhatIsClicked);
            $('.MenuInputFocus').focus();
        }
        CalcMeni();
    });
    $('body').delegate('.MenuInputFocus', 'keypress', function (evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        setTimeout(function () {
            CalcMeni();
        }, 100);
        return true;
    });
    $('body').delegate('.CreateMenuKeyboard .QwertyKeys', 'click', function () {
        var WhatIsPressed = $(this).attr('qwerty-value');
        if (WhatIsPressed == 'Delete') {
            var ValToDelete = $('.NewMenuName').val();
            $('.NewMenuName').val(ValToDelete.substring(0, ValToDelete.length - 1));
        } else if (WhatIsPressed == 'Zatvori') {
            $('.CreateMenu').hide();
            $('.NewMenuName').val('');
        } else if (WhatIsPressed == 'Enter') {
            var ValToInsert = $('.NewMenuName').val();
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: 'CreateNewMenu=' + ValToInsert,
                error: function () {
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                },
                complete: function (response) {
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        $('.MenuItem').removeClass('MenuSelected');
                        $('.MeniList').append(objData.MenuNewHtml);
                        $('.CreateMenu').hide();
                        $('.NewMenuName').val('');
                        $(".GotovinskiKupci").scrollTop($(".GotovinskiKupci")[0].scrollHeight);
                        CreateWindowAlert('Meni je uspešno kreiran!', 'success');
                    } else {
                        CreateWindowAlert(objData.Message, 'error');
                    }
                }
            });
        } else {
            var ValToAdd = $('.NewMenuName').val();
            $('.NewMenuName').val(ValToAdd + WhatIsPressed);
        }
    });
    $('body').delegate('.DostavaAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('dostava-id');
        if (WhatIsClicked == 'Izlaz') {
            $('.Dostava').hide();
            $('body').removeClass('DostavaActive');
            $('body').removeClass('PayForDelivery');
            $('.DostavaTelefon').val('');
            $('.DostavaAdrese').html('');
            $('.DostavaSearch').val('');
            $('.DeliveryRow').removeClass('SelectedDelivery');
        } else if (WhatIsClicked == 'Nova') {
            $('.PretragaDostava').show();
            $('.DostavaTelefon').focus();
            $('.DeliveryRow').removeClass('SelectedDelivery');
        } else if (WhatIsClicked == 'Aktuelne') {
            $('.FinishedDelivery').hide();
            $('.CurrentDelivery').show();
            $('.DostavaAkcija').removeClass('SelectedDeliveryFilter');
            $(this).addClass('SelectedDeliveryFilter');
        } else if (WhatIsClicked == 'Zavrsene') {
            $('.FinishedDelivery').show();
            $('.CurrentDelivery').hide();
            $('.DostavaAkcija').removeClass('SelectedDeliveryFilter');
            $(this).addClass('SelectedDeliveryFilter');
        }
    });
    $('body').delegate('.DostavaKeyboard .QwertyKeys', 'click', function () {
        var WhatIsPressed = $(this).attr('qwerty-value');
        if (WhatIsPressed == 'Delete') {
            var ValToDelete = $('.DostavaSearch').val();
            $('.DostavaSearch').val(ValToDelete.substring(0, ValToDelete.length - 1));
            $('.DostavaSearch').focus();
        } else if (WhatIsPressed == 'Zatvori') {
            $('.Dostava').hide();
            $('body').removeClass('PayForDelivery');
            $('body').removeClass('DostavaActive');
            $('.DostavaTelefon').val('');
            $('.DostavaAdrese').html('');
            $('.DostavaSearch').val('');
            $('.DeliveryRow').removeClass('SelectedDelivery');
            if ($('body').hasClass('brzaNaplata')) {
                $('.SelectAction[actionid="QuickPayment"]').click();
            }
        } else if (WhatIsPressed == 'Enter') {
            if ($('.DeliveryRow:visible').length == 1) {
                $('.DeliveryRow:visible').first().click();
            }
        } else {
            var ValToAdd = $('.DostavaSearch').val();
            $('.DostavaSearch').val(ValToAdd + WhatIsPressed);
            $('.DostavaSearch').focus();
        }
        SearchForDelivery();
    });

    $('body').delegate('.DostavaKey', 'click', function () {
        var WhatIsClicked = $(this).attr('dostava-key');
        var ToWhatToAdd = $('.DostavaTelefon').val();
        if (WhatIsClicked == 'Potvrdi') {
            if (ToWhatToAdd) {
                $.ajax({
                    type: 'POST',
                    url: './?modul=GetAjax',
                    data: "DajSveDostavaKupce=" + ToWhatToAdd,
                    error: function () {
                        CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                    },
                    complete: function (response) {
                        var objData = jQuery.parseJSON(response.responseText);
                        if (objData.Status == 'success') {
                            $('.DostavaIme').html(objData.Ime);
                            $('.DostavaIme').attr('KupacDostavaId', objData.ID);
                            $('.DostavaTelefonOdabir').html(objData.Telefon);
                            $('.DostavaAdrese').html('');
                            $.each(objData.Adrese, function (i, value) {
                                var Adresa = value.adresa;
                                var Broj = value.broj;
                                var ID = value.id;
                                $('.DostavaAdrese').append('<div class="DostavaAdresa" adresaid="' + ID + '"><div class="DostavaAdresaTitle">' + Adresa + ' ' + Broj + '</div><div class="DostavaAdresaUredi" adresaid="' + ID + '"><i class="fa fa-edit"></i></div></div>')
                            });
                            $('.ListaAdresa').show();
                        } else {
                            $('.NovaAdresa').show();
                            $('.UpdateNovaDostavaIme').val('');
                            $('.UpdateNovaDostavaTelefon').val(ToWhatToAdd);
                            $('.UpdateNovaDostavaId').val('0');
                            $('.UpdateNovaAdresaId').val('0');
                            var NovaDostavaButtonsHeight = $('.NovaAdresaAkcije').height() / 2;
                            $('.NovaAdresaAkcija').attr('style', 'height: ' + NovaDostavaButtonsHeight + 'px; line-height: ' + NovaDostavaButtonsHeight + 'px;');
                            $('.UpdateNovaDostavaIme').focus();
                            $('.UpdateDostavaTitle').html('Unos novog kupca');
                        }
                    }
                });
            } else {
                CreateWindowAlert('Molimo Vas da unesete broj telefona!', 'error');
            }
        } else if (WhatIsClicked == 'Odustani') {
            $('.PretragaDostava').hide();
            $('.DostavaTelefon').val('');
        } else if (WhatIsClicked == 'Delete') {
            $('.DostavaTelefon').val(ToWhatToAdd.substring(0, ToWhatToAdd.length - 1));
            $('.DostavaTelefon').focus();
        } else {
            $('.DostavaTelefon').val(ToWhatToAdd + '' + WhatIsClicked);
            $('.DostavaTelefon').focus();
        }
    });
    $('body').delegate('.DostavaTelefon', 'keypress', function (evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        console.log(charCode);
        if (charCode == 13) {
            $('.DostavaKey[dostava-key="Potvrdi"]').click();
            return false;
        }
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    });
    $('body').delegate('.DostavaSearch', 'keyup', function () {
        SearchForDelivery();
        return true;
    });
    $('body').delegate('.InsertDostava input', 'click focusin', function () {
        if (!$(this).hasClass('UpdateNovaDostavaTelefon')) {
            $('.InsertDostava input').removeClass('DostavaFocused');
            $(this).addClass('DostavaFocused');
        }
    });
    $('body').delegate('.NovaAdresaAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('adresa-akcija');
        if (WhatIsClicked == 'Odustani') {
            $('.NovaAdresa').hide();
            $('body').removeClass('PayForDelivery');
        } else if (WhatIsClicked == 'Potvrdi') {
            $('.InsertDostava').submit();
        }
    });
    $('body').delegate('.DostavaAdresaKeyboard .QwertyKeys', 'click', function () {
        if (!$('.DostavaFocused').length) {
            $('.UpdateNovaDostavaIme').addClass('DostavaFocused');
        }
        var WhatIsPressed = $(this).attr('qwerty-value');
        if (WhatIsPressed == 'Delete') {
            var ValToDelete = $('.DostavaFocused').val();
            $('.DostavaFocused').val(ValToDelete.substring(0, ValToDelete.length - 1));
            $('.DostavaFocused').focus();
        } else if (WhatIsPressed == 'Zatvori') {
            $('.NovaAdresa').hide();
            $('.InsertDostava input').each(function () {
                $(this).val('');
            });

        } else if (WhatIsPressed == 'Enter') {
            $('.InsertDostava').submit();
        } else {
            var ValToAdd = $('.DostavaFocused').val();
            $('.DostavaFocused').val(ValToAdd + WhatIsPressed);
            $('.DostavaFocused').focus();
        }
    });
    $('.InsertDostava').on('submit', function (e) {
        if (CheckForm(this) == 1) {
            CreateWindowAlert('Popunite sva tražena polja!!!', 'error');
            return false;
        }
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: $(this).serialize(),
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    $('.DostavaIme').html(objData.Ime);
                    $('.DostavaIme').attr('KupacDostavaId', objData.ID);
                    $('.DostavaTelefonOdabir').html(objData.Telefon);
                    $('.DostavaAdrese').html('');
                    $.each(objData.Adrese, function (i, value) {
                        var Adresa = value.adresa;
                        var Broj = value.broj;
                        var ID = value.id;
                        $('.DostavaAdrese').append('<div class="DostavaAdresa" adresaid="' + ID + '"><div class="DostavaAdresaTitle">' + Adresa + ' ' + Broj + '</div><div class="DostavaAdresaUredi" adresaid="' + ID + '"><i class="fa fa-edit"></i></div></div>')
                    });
                    if ($('.DostavaAdresa').length == 1) {
                        $('.DostavaAdresa').click();
                    }
                    $('.ListaAdresa').show();
                    $('.NovaAdresa').hide();
                    $('.InsertDostava input').each(function () {
                        $(this).val('');
                    });
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                }
            }
        });
        return false;
    });
    $('body').delegate('.DostavaAdresaUredi', 'click', function () {
        var EditDostava = $(this).attr('adresaid');
        var KupacTelefon = $('.DostavaTelefonOdabir').html();
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: "DajSveDostavaKupce=" + KupacTelefon,
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    $('.NovaAdresa').show();
                    $('.UpdateNovaDostavaIme').val(objData.Ime);
                    $('.UpdateNovaDostavaTelefon').val(objData.Telefon);
                    $('.UpdateNovaDostavaId').val(objData.ID);
                    $('.UpdateNovaAdresaId').val(EditDostava);
                    $.each(objData.Adrese, function (i, value) {
                        var ID = value.id;
                        if (ID == EditDostava) {
                            $('.UpdateNovaDostavaNapomena').val(value.napomena);
                            $('.UpdateNovaDostavaInterfon').val(value.interfon);
                            $('.UpdateNovaDostavaSprat').val(value.sprat);
                            $('.UpdateNovaDostavaBroj').val(value.broj);
                            $('.UpdateNovaDostavaMesto').val(value.mesto);
                            $('.UpdateNovaDostavaAdresa').val(value.adresa);
                        }
                    });
                    var NovaDostavaButtonsHeight = $('.NovaAdresaAkcije').height() / 2;
                    $('.NovaAdresaAkcija').attr('style', 'height: ' + NovaDostavaButtonsHeight + 'px; line-height: ' + NovaDostavaButtonsHeight + 'px;');
                    $('.UpdateNovaDostavaIme').focus();
                    $('.UpdateDostavaTitle').html('Izmena postojećeg kupca');
                } else {
                    CreateWindowAlert('Greska pri kreiranju zahteva!!! Pokusajte ponovo!!!', 'error');
                }
            }
        });
    });
    $('body').delegate('.AdreseAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('adresa-akcija');
        if (WhatIsClicked == 'Odustani') {
            $('.ListaAdresa').hide();
        } else if (WhatIsClicked == 'Nova') {
            var KupacTelefon = $('.DostavaTelefonOdabir').html();
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: "DajSveDostavaKupce=" + KupacTelefon,
                error: function () {
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                },
                complete: function (response) {
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        $('.NovaAdresa').show();
                        $('.UpdateNovaDostavaIme').val(objData.Ime);
                        $('.UpdateNovaDostavaTelefon').val(objData.Telefon);
                        $('.UpdateNovaDostavaId').val(objData.ID);
                        $('.UpdateNovaAdresaId').val('0');

                        $('.UpdateNovaDostavaNapomena').val('');
                        $('.UpdateNovaDostavaInterfon').val('');
                        $('.UpdateNovaDostavaSprat').val('');
                        $('.UpdateNovaDostavaBroj').val('');
                        $('.UpdateNovaDostavaMesto').val('');
                        $('.UpdateNovaDostavaAdresa').val('');
                        var NovaDostavaButtonsHeight = $('.NovaAdresaAkcije').height() / 2;
                        $('.NovaAdresaAkcija').attr('style', 'height: ' + NovaDostavaButtonsHeight + 'px; line-height: ' + NovaDostavaButtonsHeight + 'px;');
                        $('.UpdateNovaDostavaIme').focus();
                        $('.UpdateDostavaTitle').html('Izmena postojećeg kupca');

                    } else {
                        CreateWindowAlert('Greska pri kreiranju zahteva!!! Pokusajte ponovo!!!', 'error');
                    }
                }
            });
        } else if (WhatIsClicked == 'Potvrdi') {
            if ($('.DostavaAdresa').length == 1) {
                $('.DostavaAdresa').click();
            }
            if ($('.SelectedDostavaAdresa').length) {
                var NazivKlijenta = $('.DostavaIme').html();
                $('body').addClass('PayForDelivery');
                $.ajax({
                    type: 'POST',
                    url: './?modul=GetAjax',
                    data: "GetFirstFreeTableDostava=true",
                    error: function () {
                        CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                    },
                    complete: function (response) {
                        var objData = jQuery.parseJSON(response.responseText);
                        if (objData.Status == 'success') {
                            $('.Porudzbina').show();
                            $('.PorudzbinaSto').attr('sto-id', objData.BrojStola);
                            $('.PorudzbinaSto').html(NazivKlijenta);
                            $('.TuraOpisiTop').html('');
                            $('.ArtikalOpisiTop').html('');
                            $('.GostAkcija').remove();
                            $('.GostiAkcije').append('<div class="GostAkcija ActiveGostAkcija" gost-number="1">G1</div>');
                            GetTableItems(objData.BrojStola);
                            RearangeOrder();
                            $('.Dostava').hide();
                            $('.ListaAdresa').hide();
                            $('.PretragaDostava').hide();
                            $('body').removeClass('PayQuickPayment');
                        } else {
                            CreateWindowAlert('Greska pri kreiranju zahteva!!! Pokusajte ponovo!!!', 'error');
                        }
                    }
                });
            } else {
                CreateWindowAlert('Najpre odaberite adresu za dostavu!!!', 'error');
            }
        }
    });
    $('body').delegate('.DostavaAdresa', 'click', function () {
        $('.DostavaAdresa').removeClass('SelectedDostavaAdresa');
        $(this).addClass('SelectedDostavaAdresa');
    });
    $('body').delegate('.DeliveryRow .PrintOrderItems', 'click', function () {
        var WhatIsClicked = $(this).attr('deliveryaddress');
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: "PrintDeliveryData=" + WhatIsClicked,
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    CreateWindowAlert(objData.Message, 'success');
                } else {
                    CreateWindowAlert('Greska pri kreiranju zahteva!!! Pokusajte ponovo!!!', 'error');
                }
            }
        });
        return false;
    });
    $('body').delegate('.DeliveryRow', 'click', function () {
        if ($(this).hasClass('CurrentDelivery')) {
            var TableId = $(this).attr('delivery-id');
            var TableName = $(this).attr('delivery-name');
            $('.Porudzbina').show();
            GetTableItems(TableId);
            $('.PorudzbinaSto').attr('sto-id', TableId);
            $('.PorudzbinaSto').html(TableName);
            $('.TuraOpisiTop').html('');
            $('.ArtikalOpisiTop').html('');
            RearangeOrder();
            $('.Dostava').hide();
            $('body').removeClass('PayQuickPayment');
        }
        $('.DeliveryRow').removeClass('SelectedDelivery');
        $(this).addClass('SelectedDelivery');
    });
    $('body').delegate('.StaraDostavaDugme', 'click', function () {
        var WhatIsClicked = $(this).attr('dugme-akcija');
        if (WhatIsClicked == 'Odustani') {
            $('.StareDostave').hide();
        } else if (WhatIsClicked == 'IdiDole') {
            if ($('.StaraDostavaPrikazano').length) {
                var Which = $('.StaraDostavaPrikazano').first();
                $(Which).next().addClass('StaraDostavaPrikazano');
                $(Which).removeClass('StaraDostavaPrikazano');
            } else {
                $('.StaraDostava').first().addClass('StaraDostavaPrikazano');
            }
        } else if (WhatIsClicked == 'IdiGore') {
            if ($('.StaraDostavaPrikazano').length) {
                var Which = $('.StaraDostavaPrikazano').last();
                $(Which).prev().addClass('StaraDostavaPrikazano');
                $(Which).removeClass('StaraDostavaPrikazano');
            } else {
                $('.StaraDostava').last().addClass('StaraDostavaPrikazano');
            }
        }
    });
    $('body').delegate('.PrikaziDostavu', 'click', function () {
        $(this).parents('.StaraDostava').toggleClass('StaraDostavaPrikazano');
    });
    $('body').delegate('.PonoviDostavu', 'click', function () {
        var WhatToRepeat = $(this).attr('idstaredostave');
        var ArtikliKolicine = [];
        $('.StaraDostavaArtikli[idstaredostave="' + WhatToRepeat + '"] .StaraDostavaArtikal').each(function () {
            var ThisArtikalKolicina = $(this).attr('staradostavaartikalkolicina');
            var ThisArtikalId = $(this).attr('staradostavaartikalid');
            var ThisArtikalOpis = $(this).attr('staradostavaartikalopis');
            ArtikliKolicine.push([ThisArtikalKolicina, ThisArtikalId, ThisArtikalOpis]);
        });
        $('<div class="ModalConfirm"><h6>Da li ste sigurni da želite da ponovite porudžbinu?!</h6></div>').appendTo('body').dialog({
            modal: true,
            title: "Potvrda",
            zIndex: 10000,
            autoOpen: true,
            width: 'auto',
            resizable: false,
            draggable: false,
            buttons: {
                "Da": function () {
                    $('.PorudzbinaArtikliBody').html('');
                    $('.GostiAkcije .GostAkcija').each(function () {
                        var WhatIs = $(this).attr('gost-number');
                        var HasClass = '';
                        if ($(this).hasClass('ActiveGostAkcija')) {
                            HasClass = 'ActiveGostArtikli';
                        }
                        $('.PorudzbinaArtikliBody').append('<div class="GostArtikli ' + HasClass + '" gost-broj="' + WhatIs + '"></div>');
                    });
                    var SelectedGost = $('.ActiveGostAkcija').attr('gost-number');
                    if (!SelectedGost) {
                        SelectedGost = 1;
                    }
                    $.each(ArtikliKolicine, function (key, value) {
                        var Kolicina = value[0];
                        var ArtikalId = value[1];
                        var Opis = value[2];
                        var ArtikalTip = $('.Artikal[idartikla="' + ArtikalId + '"]').first().attr('tipartikla');
                        var ArtikalPrice = $('.Artikal[idartikla="' + ArtikalId + '"]').first().attr('cenaartikla');
                        var ArtikalName = $('.Artikal[idartikla="' + ArtikalId + '"] span').first().text();
                        $.ajax({
                            type: 'POST',
                            url: './?modul=GetAjax',
                            data: 'GetArticlePrice=' + ArtikalId,
                            async: false,
                            error: function () {
                                ArtikalNewPrice = 0;
                                if (ArtikalNewPrice > 0) {
                                    ArtikalPrice = ArtikalNewPrice;
                                }
                                var KolikoArtikala = Kolicina;
                                if (KolikoArtikala != '') {
                                    if (isNaN(KolikoArtikala)) {
                                        KolikoArtikala = 1;
                                    }
                                } else {
                                    KolikoArtikala = 1;
                                }
                                var IznosArtikala = parseFloat(KolikoArtikala) * parseFloat(ArtikalPrice);
                                if (Opis.length > 0) {
                                    var ArtikalHtml = '<div class="PoruceniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="OpisArtikla"><div class="OpisIcon"><i class="fa fa-edit"></i></div><div class="OpisContent">' + Opis + '</div></div><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + IznosArtikala + '</div></div>';
                                } else {
                                    var ArtikalHtml = '<div class="PoruceniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + IznosArtikala + '</div></div>';
                                }
                                $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                                $('.AktivanStoAkcije').show();
                                $('.PrazanStoAkcije').hide();
                                $('.PunStoAkcije').hide();
                                $('.NumerikInput').val('');
                                $('.StareDostave').hide();
                                CalcTotal();
                            },
                            complete: function (response) {
                                var objData = jQuery.parseJSON(response.responseText);
                                if (objData.Status == 'success') {
                                    ArtikalNewPrice = objData.Price;
                                } else {
                                    ArtikalNewPrice = 0;
                                }
                                if (ArtikalNewPrice > 0) {
                                    ArtikalPrice = ArtikalNewPrice;
                                }

                                var KolikoArtikala = Kolicina;
                                if (KolikoArtikala != '') {
                                    if (isNaN(KolikoArtikala)) {
                                        KolikoArtikala = 1;
                                    }
                                } else {
                                    KolikoArtikala = 1;
                                }
                                var IznosArtikala = parseFloat(KolikoArtikala) * parseFloat(ArtikalPrice);

                                if (Opis.length > 0) {
                                    var ArtikalHtml = '<div class="PoruceniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="OpisArtikla"><div class="OpisIcon"><i class="fa fa-edit"></i></div><div class="OpisContent">' + Opis + '</div></div><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + IznosArtikala + '</div></div>';
                                } else {
                                    var ArtikalHtml = '<div class="PoruceniArtikal" idporucenog="' + ArtikalId + '" tipporucenog="' + ArtikalTip + '" cenaporucenog="' + ArtikalPrice + '"><div class="PorudzbinaArtikliNaziv">' + ArtikalName + '</div><div class="PorudzbinaArtikliKolicina">' + parseFloat(KolikoArtikala) + '</div><div class="PorudzbinaArtikliIznos">' + IznosArtikala + '</div></div>';
                                }
                                $('.PorudzbinaArtikliBody .GostArtikli[gost-broj="' + SelectedGost + '"]').append(ArtikalHtml);
                                $('.AktivanStoAkcije').show();
                                $('.PrazanStoAkcije').hide();
                                $('.PunStoAkcije').hide();
                                $('.NumerikInput').val('');
                                $('.StareDostave').hide();
                                CalcTotal();
                            }
                        });
                    });
                    $(this).dialog("close");
                },
                "Ne": function () {
                    $(this).dialog("close");
                    return false;
                }
            },
            close: function (event, ui) {
                $(this).remove();
            }
        });
    });
    $('body').delegate('.ExpandInvoiceItems', 'click', function () {
        var WhatToShow = $(this).attr('invoicetoshow');
        if (parseInt(WhatToShow) > 0) {
            GetArtikleZaRacun(WhatToShow);
        }
    });
    $('body').delegate('.TipStampeOdabir', 'click', function () {
        var WhatIsClicked = $('.OdaberiTipStampe').attr('tipizvestaja');
        var WhatIsRequested = $(this).attr('tipstampe');
        if (WhatIsRequested == 'A4') {
            if (WhatIsClicked == 'PopisnaLista') {
                window.open('./?modul=popisnalista');
            } else if (WhatIsClicked == 'IzvestajStorno') {
                window.open('./?modul=stornolista');
            } else if (WhatIsClicked == 'IzvestajSvi') {
                window.open('./?modul=prodajasvi');
            } else if (WhatIsClicked == 'IzvestajOperater') {
                window.open('./?modul=prodajaoperater');
            }
            $('.OdaberiTipStampe').hide();
        } else {
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: "PrintReportNarrow=" + WhatIsClicked,
                error: function () {
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                },
                complete: function (response) {
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        CreateWindowAlert(objData.Message, 'success');
                        $('.OdaberiTipStampe').hide();
                    } else {
                        CreateWindowAlert('Greska pri kreiranju zahteva!!! Pokusajte ponovo!!!', 'error');
                    }
                }
            });
        }
    });
    $('body').delegate('.TipStampePopisOdabir', 'click', function () {
        var WhatIsClicked = $('.OdaberiTipStampePopis').attr('tipizvestaja');
        var WhatIsRequested = $(this).attr('tipstampe');
        if ($('.SelectedOdeljenje').length) {
            var Odeljenja = "";
            $('.SelectedOdeljenje').each(function () {
                if (Odeljenja == "") {
                    Odeljenja = $(this).attr('odeljenje-id');
                } else {
                    Odeljenja += ", " + $(this).attr('odeljenje-id');
                }
            });
            if (WhatIsRequested == 'A4') {
                window.open('./?modul=popisnalista&Odeljenja=' + Odeljenja);
                $('.OdaberiTipStampePopis').hide();
            } else {
                $.ajax({
                    type: 'POST',
                    url: './?modul=GetAjax',
                    data: "PrintReportNarrow=" + WhatIsClicked + "&Odeljenja=" + Odeljenja,
                    error: function () {
                        CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                    },
                    complete: function (response) {
                        var objData = jQuery.parseJSON(response.responseText);
                        if (objData.Status == 'success') {
                            CreateWindowAlert(objData.Message, 'success');
                            $('.OdaberiTipStampePopis').hide();
                        } else {
                            CreateWindowAlert('Greska pri kreiranju zahteva!!! Pokusajte ponovo!!!', 'error');
                        }
                    }
                });
            }
        } else {
            CreateWindowAlert('Najpre odaberite odeljenja!!!', 'error');
        }
    });
    $('body').delegate('.SelectOdeljenja', 'click', function () {
        $(this).toggleClass('SelectedOdeljenje');
    });
    $('body').delegate('.UgasiTipStampe', 'click', function () {
        $('.OdaberiTipStampe').hide();
    });
    $('body').delegate('.UgasiTipStampePopis', 'click', function () {
        $('.OdaberiTipStampePopis').hide();
    });

    $('body').delegate('.GostAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('gost-number');
        $('.GostAkcija').removeClass('ActiveGostAkcija');
        $('.GostArtikli').removeClass('ActiveGostArtikli');
        $(this).addClass('ActiveGostAkcija');
        $('.GostArtikli[gost-broj="' + WhatIsClicked + '"]').addClass('ActiveGostArtikli');
        $('.PoruceniArtikal').removeClass('OdabraniArtikal');
    });
    $('body').delegate('.RastavljanjeGostAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('gost-number');
        $('.RastavljanjeGostAkcija').removeClass('ActiveGostAkcija');
        $('.RastavljanjeLeft .GostArtikli').removeClass('ActiveGostArtikli');
        $(this).addClass('ActiveGostAkcija');
        $('.RastavljanjeLeft .GostArtikli[gost-broj="' + WhatIsClicked + '"]').addClass('ActiveGostArtikli');
        $('.RastavljanjeLeft .PoruceniArtikal').removeClass('OdabraniArtikal');
        $('.RastavljanjeLeft .GostArtikli[gost-broj="' + WhatIsClicked + '"] .PoruceniArtikal').addClass('OdabraniArtikal');
    });
    $('body').delegate('.NewGostAkcija', 'click', function () {
        var NajveciGost = 0;
        $('.GostAkcija').each(function () {
            var Broj = $(this).attr('gost-number');
            if (parseInt(Broj) > parseInt(NajveciGost)) {
                NajveciGost = Broj;
            }
        });
        NajveciGost = parseInt(NajveciGost) + 1;
        if ($('.GostAkcija').length >= 23) {
            CreateWindowAlert('Maksimalni broj gostiju je dostignut!!!', 'error');
        } else {
            $('.GostAkcija').removeClass('ActiveGostAkcija');
            $('.GostArtikli').removeClass('ActiveGostArtikli');
            $('.GostiAkcije').append('<div class="GostAkcija ActiveGostAkcija" gost-number="' + NajveciGost + '">G' + NajveciGost + '</div>');
            $('.PorudzbinaArtikliBody').append('<div class="GostArtikli ActiveGostArtikli" gost-broj="' + NajveciGost + '"></div>');
            RearangeOrder();
        }
    });
    $('body').delegate('.TriTrojkeAction', 'click', function () {
        var WhatIsClicked = $(this).attr('action-value');
        if (WhatIsClicked == 'Izlaz') {
            $('.TriTrojke').hide();
        } else if (WhatIsClicked == 'StampaA4') {
            if ($('.NenaplaceniArtikliNaStolovima').length) {
                CreateWindowAlert('Nije moguće razduženje!!! Najpre zaključite otvorene stolove!!!', 'error');
                return false;
            }
            window.open('./?modul=razduzenje');
            $('.TriTrojke').hide();
            $('.AdminMeni').hide();
            setTimeout(function () {
                window.location = "./logout.php";
            }, 2000);
        } else if (WhatIsClicked == 'BlicStampa') {
            if ($('.NenaplaceniArtikliNaStolovima').length) {
                CreateWindowAlert('Nije moguće razduženje!!! Najpre zaključite otvorene stolove!!!', 'error');
                return false;
            }
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: "PrintReportNarrow=RazduzenjeKonobara&UskaStampaRazduzenja=false",
                error: function () {
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                },
                complete: function (response) {
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        CreateWindowAlert(objData.Message, 'success');
                        $('.TriTrojke').hide();
                        $('.AdminMeni').hide();
                        window.location = "./logout.php";
                    } else {
                        CreateWindowAlert('Greska pri kreiranju zahteva!!! Pokusajte ponovo!!!', 'error');
                    }
                }
            });
        } else if (WhatIsClicked == 'Stampa') {
            if ($('.NenaplaceniArtikliNaStolovima').length) {
                CreateWindowAlert('Nije moguće razduženje!!! Najpre zaključite otvorene stolove!!!', 'error');
                return false;
            }
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: "PrintReportNarrow=RazduzenjeKonobara&UskaStampaRazduzenja=true",
                error: function () {
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                },
                complete: function (response) {
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        CreateWindowAlert(objData.Message, 'success');
                        $('.TriTrojke').hide();
                        $('.AdminMeni').hide();
                        window.location = "./logout.php";
                    } else {
                        CreateWindowAlert('Greska pri kreiranju zahteva!!! Pokusajte ponovo!!!', 'error');
                    }
                }
            });
        }
    });
    if ($('body').hasClass('brzaNaplata')) {
        $('.SelectAction[actionid="QuickPayment"]').click();
    }
    $('body').delegate('.OtkljucavanjeKey', 'click', function () {
        var WhatIsClicked = $(this).attr('gost-key');
        var ToWhatToAdd = $('.OtkljucavanjeStolaMedjuzbir').val();
        if (WhatIsClicked == 'Potvrdi') {
            if (ToWhatToAdd) {
                var Sto = $('.PorudzbinaSto').attr('sto-id');
                $.ajax({
                    type: 'POST',
                    url: './?modul=GetAjax',
                    data: "CheckPasswordToUnlockMedjuzbir=" + ToWhatToAdd + "&TableToUnlockMedjuzbir=" + Sto,
                    error: function () {
                        CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                    },
                    complete: function (response) {
                        var objData = jQuery.parseJSON(response.responseText);
                        if (objData.Status == 'success') {
                            $('.Sto[stoid="' + Sto + '"]').removeClass('Zakljucan');
                            $('.OtkljucavanjeStola').hide();
                            $('.OtkljucavanjeStolaMedjuzbir').val('');
                            $('.Naplata').hide();
                            $('.Sto[stoid="' + Sto + '"]').click();
                        } else {
                            CreateWindowAlert(objData.Message, 'error');
                        }
                    }
                });

            } else {
                CreateWindowAlert('Molimo Vas da unesete lozinku za otključavanje stola!', 'error');
            }
        } else if (WhatIsClicked == 'Odustani') {
            $('.OtkljucavanjeStola').hide();
            $('.OtkljucavanjeStolaMedjuzbir').val('');
        } else if (WhatIsClicked == 'Delete') {
            $('.OtkljucavanjeStolaMedjuzbir').val(ToWhatToAdd.substring(0, ToWhatToAdd.length - 1));
            $('.OtkljucavanjeStolaMedjuzbir').focus();
        } else {
            $('.OtkljucavanjeStolaMedjuzbir').val(ToWhatToAdd + '' + WhatIsClicked);
            $('.OtkljucavanjeStolaMedjuzbir').focus();
        }
    });
    $('body').delegate(".PodesavanjaAkcijeOtkazi", "click", function () {
        $('.PodesavanjeKase').hide();
    });
    $('body').delegate(".PodesavanjaAkcijePotvrdi", "click", function () {
        $('.PodesavanjeForma').submit();
    });
    $('.PodesavanjeForma').on("submit", function () {
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: $(this).serialize(),
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    CreateWindowAlert(objData.Message, 'success');
                    setTimeout(function () {
                        window.location.reload();
                    }, 2000);
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                }
            }
        });
        return false;
    });
    $('.SelectGrafik').first().click();
    $('body').delegate('.PodesavanjeGrupaAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('akcija');
        if (WhatIsClicked == 'Exit') {
            $('.PodesavanjeGrupa').hide();
        } else if (WhatIsClicked == 'New') {
            $('.KreiranjeGrupe').show();
            $('.CreateGroupId').val('0');
            $('.CreateGroupName').val('');
            $('.CreateGroupShortName').val('');
            var HowManyOrder = $('.PodesavanjeGrupe').length;
            $('.CreateGroupPriority').html('');
            for (i = 1; i <= HowManyOrder; i++) {
                $('.CreateGroupPriority').append('<option value="' + i + '">' + i + '</option>');
            }
            $('.CreateGroupPriority').val('1');
            if (!$('.CreateGroupShowScreen').is(':checked')) {
                $('.CreateGroupShowScreen').click();
            }
            if (!$('.CreateGroupShowOrder').is(':checked')) {
                $('.CreateGroupShowOrder').click();
            }
            $('.KreiranjeGrupeTitle').html('Kreiranje nove grupe');
        } else if (WhatIsClicked == 'Change') {
            if ($('.SelectedPodesavanjeGrupe').length) {
                $('.KreiranjeGrupe').show();
                var GroupId = $('.SelectedPodesavanjeGrupe').attr('idgrupe');
                var ShortName = $('.SelectedPodesavanjeGrupe').attr('skrnaziv');
                var Priority = $('.SelectedPodesavanjeGrupe').attr('prioritet');
                var ShowScreen = $('.SelectedPodesavanjeGrupe').attr('prikaznaekran');
                var ShowOrder = $('.SelectedPodesavanjeGrupe').attr('prikazordermaster');
                var GroupName = $('.SelectedPodesavanjeGrupe').text();

                $('.CreateGroupId').val(GroupId);
                $('.CreateGroupName').val(GroupName);
                $('.CreateGroupShortName').val(ShortName);
                var HowManyOrder = $('.PodesavanjeGrupe').length;
                $('.CreateGroupPriority').html('');
                for (i = 1; i <= HowManyOrder; i++) {
                    $('.CreateGroupPriority').append('<option value="' + i + '">' + i + '</option>');
                }
                $('.CreateGroupPriority').val(Priority);
                if (ShowScreen == 1) {
                    if (!$('.CreateGroupShowScreen').is(':checked')) {
                        $('.CreateGroupShowScreen').click();
                    }
                } else {
                    if ($('.CreateGroupShowScreen').is(':checked')) {
                        $('.CreateGroupShowScreen').click();
                    }
                }
                if (ShowOrder == 1) {
                    if (!$('.CreateGroupShowOrder').is(':checked')) {
                        $('.CreateGroupShowOrder').click();
                    }
                } else {
                    if ($('.CreateGroupShowOrder').is(':checked')) {
                        $('.CreateGroupShowOrder').click();
                    }
                }
                $('.KreiranjeGrupeTitle').html('Izmena grupe');
            } else {
                CreateWindowAlert('Najpre odaberite grupu koju želite da izmenite!', 'error');
            }
        } else if (WhatIsClicked == 'Delete') {
            if ($('.SelectedPodesavanjeGrupe').length) {
                var GroupId = $('.SelectedPodesavanjeGrupe').attr('idgrupe');
                $('<div class="ModalConfirm"><h6>Da li ste sigurni da želite da obrišete grupu?!</h6></div>').appendTo('body').dialog({
                    modal: true,
                    title: "Potvrda brisanja",
                    zIndex: 10000,
                    autoOpen: true,
                    width: 'auto',
                    resizable: false,
                    draggable: false,
                    buttons: {
                        "Da": function () {
                            $('.Loader').show();
                            $.ajax({
                                type: 'POST',
                                url: './?modul=GetAjax',
                                data: "DeleteProductGroup=" + GroupId,
                                error: function () {
                                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                    $('.Loader').hide();
                                },
                                complete: function (response) {
                                    var objData = jQuery.parseJSON(response.responseText);
                                    if (objData.Status == 'success') {
                                        PreuzmiSveGrupe();
                                        CreateWindowAlert(objData.Message, 'success');
                                        $('.Loader').hide();
                                    } else {
                                        CreateWindowAlert(objData.Message, 'error');
                                        $('.Loader').hide();
                                    }
                                }
                            });
                            $(this).dialog("close");
                        },
                        "Ne": function () {
                            $(this).dialog("close");
                            return false;
                        }
                    },
                    close: function (event, ui) {
                        $(this).remove();
                    }
                });
            } else {
                CreateWindowAlert('Najpre odaberite grupu koju želite da obrišete!', 'error');
            }
        }
    });
    $('body').delegate('.CloseCreateGroup', 'click', function () {
        $('.KreiranjeGrupe').hide();
    });
    $('body').delegate('.PodesavanjeGrupe', 'click', function () {
        $('.PodesavanjeGrupe').removeClass('SelectedPodesavanjeGrupe');
        $(this).addClass('SelectedPodesavanjeGrupe');
    });
    $('body').delegate('.CreateGroupForm', 'submit', function () {
        $('.Loader').show();
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: $(this).serialize(),
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                $('.Loader').hide(500);
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    CreateWindowAlert(objData.Message, 'success');
                    PreuzmiSveGrupe();
                    $('.KreiranjeGrupe').hide();
                    $('.Loader').hide(500);
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                    $('.Loader').hide(500);
                }
            }
        });
        return false;
    });
    $('body').delegate('.PodesavanjePodGrupaAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('akcija');
        if (WhatIsClicked == 'Exit') {
            $('.PodesavanjePodGrupa').hide();
        } else if (WhatIsClicked == 'New') {
            $('.KreiranjePodGrupe').show();
            $('.CreateSubGroupId').val('0');
            $('.CreateSubGroupName').val('');
            $('.CreateSubGroupShortName').val('');
            var HowManyOrder = $('.PodesavanjePodGrupe').length;
            $('.CreateSubGroupPriority').html('');
            for (i = 1; i <= HowManyOrder; i++) {
                $('.CreateSubGroupPriority').append('<option value="' + i + '">' + i + '</option>');
            }
            $('.CreateSubGroupGroup').html('');
            $('.PodesavanjeGrupe').each(function () {
                var Id = $(this).attr('idgrupe');
                var Naziv = $(this).attr('skrnaziv');
                $('.CreateSubGroupGroup').append('<option value="' + Id + '">' + Naziv + '</option>');
            });
            $('.CreateSubGroupPriority').val('1');
            $('.KreiranjeGrupeTitle').html('Kreiranje nove podgrupe');
        } else if (WhatIsClicked == 'Change') {
            if ($('.SelectedPodesavanjePodGrupe').length) {
                $('.KreiranjePodGrupe').show();
                var SubGroupId = $('.SelectedPodesavanjePodGrupe').attr('idpodgrupe');
                var GroupId = $('.SelectedPodesavanjePodGrupe').attr('idgrupe');
                var ShortName = $('.SelectedPodesavanjePodGrupe').attr('skrnaziv');
                var Priority = $('.SelectedPodesavanjePodGrupe').attr('prioritet');
                var GroupName = $('.SelectedPodesavanjePodGrupe').text();

                $('.CreateSubGroupId').val(SubGroupId);
                $('.CreateSubGroupName').val(GroupName);
                $('.CreateSubGroupShortName').val(ShortName);
                var HowManyOrder = $('.PodesavanjePodGrupe').length;
                $('.CreateSubGroupPriority').html('');
                for (i = 1; i <= HowManyOrder; i++) {
                    $('.CreateSubGroupPriority').append('<option value="' + i + '">' + i + '</option>');
                }
                $('.CreateSubGroupPriority').val(Priority);
                $('.CreateSubGroupGroup').html('');
                $('.PodesavanjeGrupe').each(function () {
                    var Id = $(this).attr('idgrupe');
                    var Naziv = $(this).attr('skrnaziv');
                    $('.CreateSubGroupGroup').append('<option value="' + Id + '">' + Naziv + '</option>');
                });
                $('.CreateSubGroupGroup').val(GroupId);
                $('.KreiranjeGrupeTitle').html('Izmena podgrupe');
            } else {
                CreateWindowAlert('Najpre odaberite podgrupu koju želite da izmenite!', 'error');
            }
        } else if (WhatIsClicked == 'Delete') {
            if ($('.SelectedPodesavanjePodGrupe').length) {
                var GroupId = $('.SelectedPodesavanjePodGrupe').attr('idpodgrupe');
                $('<div class="ModalConfirm"><h6>Da li ste sigurni da želite da obrišete podgrupu?!</h6></div>').appendTo('body').dialog({
                    modal: true,
                    title: "Potvrda brisanja",
                    zIndex: 10000,
                    autoOpen: true,
                    width: 'auto',
                    resizable: false,
                    draggable: false,
                    buttons: {
                        "Da": function () {
                            $('.Loader').show();
                            $.ajax({
                                type: 'POST',
                                url: './?modul=GetAjax',
                                data: "DeleteProductSubGroup=" + GroupId,
                                error: function () {
                                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                    $('.Loader').hide();
                                },
                                complete: function (response) {
                                    var objData = jQuery.parseJSON(response.responseText);
                                    if (objData.Status == 'success') {
                                        PreuzmiSvePodGrupe();
                                        CreateWindowAlert(objData.Message, 'success');
                                        $('.Loader').hide();
                                    } else {
                                        CreateWindowAlert(objData.Message, 'error');
                                        $('.Loader').hide();
                                    }
                                }
                            });
                            $(this).dialog("close");
                        },
                        "Ne": function () {
                            $(this).dialog("close");
                            return false;
                        }
                    },
                    close: function (event, ui) {
                        $(this).remove();
                    }
                });
            } else {
                CreateWindowAlert('Najpre odaberite podgrupu koju želite da obrišete!', 'error');
            }
        }
    });
    $('body').delegate('.CloseCreateSubGroup', 'click', function () {
        $('.KreiranjePodGrupe').hide();
    });
    $('body').delegate('.PodesavanjePodGrupe', 'click', function () {
        $('.PodesavanjePodGrupe').removeClass('SelectedPodesavanjePodGrupe');
        $(this).addClass('SelectedPodesavanjePodGrupe');
    });
    $('body').delegate('.CreateSubGroupForm', 'submit', function () {
        $('.Loader').show();
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: $(this).serialize(),
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                $('.Loader').hide(500);
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    CreateWindowAlert(objData.Message, 'success');
                    PreuzmiSvePodGrupe();
                    $('.KreiranjePodGrupe').hide();
                    $('.Loader').hide(500);
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                    $('.Loader').hide(500);
                }
            }
        });
        return false;
    });
    $('body').delegate('.PodesavanjeStampacaAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('akcija');
        if (WhatIsClicked == 'Exit') {
            $('.PodesavanjeStampaca').hide();
        } else if (WhatIsClicked == 'New') {
            $('.KreiranjeStampaca').show();
            $('.CreatePrinterId').val('0');
            $('.CreatePrinterName').val('');
            $('.CreatePrinterBName').val('');
            $('.CreatePrinterCopy').val('1');
            if (!$('.CreatePrinterReports').is(':checked')) {
                $('.CreatePrinterReports').click();
            }
            if (!$('.CreatePrinterInvoice').is(':checked')) {
                $('.CreatePrinterInvoice').click();
            }
            $('.KreiranjeGrupeTitle').html('Kreiranje novog štampača');
        } else if (WhatIsClicked == 'Change') {
            if ($('.SelectedPodesavanjeStampac').length) {
                $('.KreiranjeStampaca').show();
                var PrinterId = $('.SelectedPodesavanjeStampac').attr('idstampaca');
                var CopyNo = $('.SelectedPodesavanjeStampac').attr('brojkopijaporudzbine');
                var BName = $('.SelectedPodesavanjeStampac').attr('bnaziv');
                var PrintReports = $('.SelectedPodesavanjeStampac').attr('stampaizvestaje');
                var PrintInvoices = $('.SelectedPodesavanjeStampac').attr('stampagotovinski');
                var Name = $('.SelectedPodesavanjeStampac').attr('naziv');

                $('.CreatePrinterId').val(PrinterId);
                $('.CreatePrinterName').val(Name);
                $('.CreatePrinterBName').val(BName);
                $('.CopyNo').val(CopyNo);
                if (PrintReports == 1) {
                    if (!$('.CreatePrinterReports').is(':checked')) {
                        $('.CreatePrinterReports').click();
                    }
                } else {
                    if ($('.CreatePrinterReports').is(':checked')) {
                        $('.CreatePrinterReports').click();
                    }
                }
                if (PrintInvoices == 1) {
                    if (!$('.CreatePrinterInvoice').is(':checked')) {
                        $('.CreatePrinterInvoice').click();
                    }
                } else {
                    if ($('.CreatePrinterInvoice').is(':checked')) {
                        $('.CreatePrinterInvoice').click();
                    }
                }
                $('.KreiranjeGrupeTitle').html('Izmena štampača');
            } else {
                CreateWindowAlert('Najpre odaberite štampač koji želite da izmenite!', 'error');
            }
        } else if (WhatIsClicked == 'Delete') {
            if ($('.SelectedPodesavanjeStampac').length) {
                var PrinterId = $('.SelectedPodesavanjeStampac').attr('idstampaca');
                $('<div class="ModalConfirm"><h6>Da li ste sigurni da želite da obrišete štampač?!</h6></div>').appendTo('body').dialog({
                    modal: true,
                    title: "Potvrda brisanja",
                    zIndex: 10000,
                    autoOpen: true,
                    width: 'auto',
                    resizable: false,
                    draggable: false,
                    buttons: {
                        "Da": function () {
                            $('.Loader').show();
                            $.ajax({
                                type: 'POST',
                                url: './?modul=GetAjax',
                                data: "DeletePrinter=" + PrinterId,
                                error: function () {
                                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                    $('.Loader').hide();
                                },
                                complete: function (response) {
                                    var objData = jQuery.parseJSON(response.responseText);
                                    if (objData.Status == 'success') {
                                        PreuzmiSveStampace();
                                        CreateWindowAlert(objData.Message, 'success');
                                        $('.Loader').hide();
                                    } else {
                                        CreateWindowAlert(objData.Message, 'error');
                                        $('.Loader').hide();
                                    }
                                }
                            });
                            $(this).dialog("close");
                        },
                        "Ne": function () {
                            $(this).dialog("close");
                            return false;
                        }
                    },
                    close: function (event, ui) {
                        $(this).remove();
                    }
                });
            } else {
                CreateWindowAlert('Najpre odaberite štampač koji želite da obrišete!', 'error');
            }
        }
    });
    $('body').delegate('.CloseCreatePrinter', 'click', function () {
        $('.KreiranjeStampaca').hide();
    });
    $('body').delegate('.PodesavanjeStampac', 'click', function () {
        $('.PodesavanjeStampac').removeClass('SelectedPodesavanjeStampac');
        $(this).addClass('SelectedPodesavanjeStampac');
    });
    $('body').delegate('.CreatePrinterForm', 'submit', function () {
        $('.Loader').show();
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: $(this).serialize(),
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                $('.Loader').hide(500);
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    CreateWindowAlert(objData.Message, 'success');
                    PreuzmiSveStampace();
                    $('.KreiranjeStampaca').hide();
                    $('.Loader').hide(500);
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                    $('.Loader').hide(500);
                }
            }
        });
        return false;
    });
    $('body').delegate('.ImportArtikalaAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('akcija');
        if (WhatIsClicked == 'Exit') {
            $('.ImportArtikala').hide();
        } else if (WhatIsClicked == 'Save') {
            $('.Loader').show();
            var fd = new FormData();
            var files = $('#ImportFile')[0].files;
            // Check file selected or not
            if (files.length > 0) {
                fd.append('ImportItemsFile', files[0]);
                $.ajax({
                    type: 'POST',
                    url: './?modul=GetAjax',
                    data: fd,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        var objData = jQuery.parseJSON(response);
                        if (objData.Status == 'success') {
                            CreateWindowAlert(objData.Message, 'success');
                            $('.Loader').hide(500);
                            $('.ImportArtikala').hide();
                        } else {
                            CreateWindowAlert(objData.Message, 'error');
                            $('.Loader').hide(500);
                        }
                    },
                    error: function (response) {
                        CreateWindowAlert('Greska na mrezi!!! Uvoz nije moguć!!!', 'error');
                        $('.Loader').hide();
                    }
                });
            } else {
                CreateWindowAlert("Najpre odaberite fajl!", 'error');
                $('.Loader').hide();
            }
        }
    });
    $('body').delegate('.PodesavanjeArtikalaAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('akcija');
        if (WhatIsClicked == 'Exit') {
            $('.PodesavanjeArtikala').hide();
        } else if (WhatIsClicked == 'Import') {
            $('.ImportArtikala').show();
        } else if (WhatIsClicked == 'Export') {
            window.open('./?modul=exportartikala');
        } else if (WhatIsClicked == 'New') {
            $('.KreiranjeArtikala').show();
            $('.CreateProductId').val('0');
            $('.CreateProductName').val('');
            $('.CreateProductCode').val('');
            $('.CreateProductPrice').val('0');
            $('.CreateProductPrinter').each(function () {
                if ($(this).is(":checked")) {
                    $(this).click();
                }
            });
            if (!$('.CreateProductDiscount').is(':checked')) {
                $('.CreateProductDiscount').click();
            }
            $('.KreiranjeGrupeTitle').html('Kreiranje novog artikla');
        } else if (WhatIsClicked == 'Change') {
            if ($('.SelectedPodesavanjeArtikal').length) {
                $('.KreiranjeArtikala').show();
                var ProductId = $('.SelectedPodesavanjeArtikal').attr('idartikla');
                var SubGroup = $('.SelectedPodesavanjeArtikal').attr('podgrupa_id');
                var Price = $('.SelectedPodesavanjeArtikal').attr('cena');
                var Code = $('.SelectedPodesavanjeArtikal').attr('sifra');
                var Name = $('.SelectedPodesavanjeArtikal').attr('naziv');
                var Vat = $('.SelectedPodesavanjeArtikal').attr('porez');
                var Unit = $('.SelectedPodesavanjeArtikal').attr('jm');
                var Printers = $('.SelectedPodesavanjeArtikal').attr('stampaci');
                var Discount = $('.SelectedPodesavanjeArtikal').attr('dozvoljenpopust');

                $('.CreateProductId').val(ProductId);
                $('.CreateProductName').val(Name);
                $('.CreateProductCode').val(Code);
                $('.CreateProductPrice').val(Price);
                $('.CreateProductSubGroup').val(SubGroup);
                $('.CreateProductUnit').val(Unit);
                $('.CreateProductVat').val(Vat);
                if (Discount == 1) {
                    if (!$('.CreateProductDiscount').is(':checked')) {
                        $('.CreateProductDiscount').click();
                    }
                } else {
                    if ($('.CreateProductDiscount').is(':checked')) {
                        $('.CreateProductDiscount').click();
                    }
                }
                $('.CreateProductPrinter').each(function () {
                    if ($(this).is(":checked")) {
                        $(this).click();
                    }
                });
                var CurrentPrinters = Printers.split(',');
                $.each(CurrentPrinters, function (key, value) {
                    if (!$('.CreateProductPrinter[value="' + value + '"]').is(":checked")) {
                        $('.CreateProductPrinter[value="' + value + '"]').click();
                    }
                });
                $('.KreiranjeGrupeTitle').html('Izmena artikla');
            } else {
                CreateWindowAlert('Najpre odaberite artikal koji želite da izmenite!', 'error');
            }
        } else if (WhatIsClicked == 'Delete') {
            if ($('.SelectedPodesavanjeArtikal').length) {
                var ProductId = $('.SelectedPodesavanjeArtikal').attr('idartikla');
                $('<div class="ModalConfirm"><h6>Da li ste sigurni da želite da obrišete artikal?!</h6></div>').appendTo('body').dialog({
                    modal: true,
                    title: "Potvrda brisanja",
                    zIndex: 10000,
                    autoOpen: true,
                    width: 'auto',
                    resizable: false,
                    draggable: false,
                    buttons: {
                        "Da": function () {
                            $('.Loader').show();
                            $.ajax({
                                type: 'POST',
                                url: './?modul=GetAjax',
                                data: "DeleteProduct=" + ProductId,
                                error: function () {
                                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                    $('.Loader').hide();
                                },
                                complete: function (response) {
                                    var objData = jQuery.parseJSON(response.responseText);
                                    if (objData.Status == 'success') {
                                        $('.SelectedPodesavanjeArtikal').remove();
                                        CreateWindowAlert(objData.Message, 'success');
                                        $('.Loader').hide();
                                    } else {
                                        CreateWindowAlert(objData.Message, 'error');
                                        $('.Loader').hide();
                                    }
                                }
                            });
                            $(this).dialog("close");
                        },
                        "Ne": function () {
                            $(this).dialog("close");
                            return false;
                        }
                    },
                    close: function (event, ui) {
                        $(this).remove();
                    }
                });
            } else {
                CreateWindowAlert('Najpre odaberite artikal koji želite da obrišete!', 'error');
            }
        }
    });
    $('body').delegate('.CloseCreateProduct', 'click', function () {
        $('.KreiranjeArtikala').hide();
    });
    $('body').delegate('.PodesavanjeArtikal', 'click', function () {
        $('.PodesavanjeArtikal').removeClass('SelectedPodesavanjeArtikal');
        $(this).addClass('SelectedPodesavanjeArtikal');
    });
    $('body').delegate('.PodesavanjePretragaArtikala', 'submit', function () {
        var ProductGroup = $('.PodesavanjePretragaPodGrupa').val();
        var ProductName = $('.PodesavanjePretragaNaziv').val();
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: "SearchArticlesSetup=0&PodesavanjePretragaPodGrupa=" + ProductGroup + "&PodesavanjePretragaNaziv=" + ProductName,
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                $('.Loader').hide();
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    $('.PodesavanjeArtikalaLista').html('');
                    if (objData.PageLinks != "") {
                        var HtmlToAppend = "<div class='OFPager'>";
                        $.each(objData.PageLinks, function (key, value) {
                            HtmlToAppend += "<div class='OFPagerLink " + value.Class + "' gotopage='" + value.Number + "'>" + value.Content + "</div>";
                        });
                        HtmlToAppend += "</div>";
                        $('.PodesavanjeArtikalaLista').html(HtmlToAppend);
                    }
                    if (objData.InvoiceData != "") {
                        var HtmlToAppend = "<table>";
                        HtmlToAppend += "<tr class='PodesavanjeArtikalHeader'>";
                        HtmlToAppend += "<td>Naziv</td>";
                        HtmlToAppend += "<td>Barcode</td>";
                        HtmlToAppend += "<td>JM</td>";
                        HtmlToAppend += "<td>Cena</td>";
                        HtmlToAppend += "</tr>";
                        $.each(objData.InvoiceData, function (key, value) {
                            HtmlToAppend += "<tr class='PodesavanjeArtikal' dozvoljenpopust='" + value.dozvoljenPopust + "' porez='" + value.poreskaGrupa + "' idartikla='" + value.id + "' podgrupa_id='" + value.PODGRUPA_ID + "' cena='" + value.cena + "' sifra='" + value.sifra + "' naziv='" + value.name + "' jm='" + value.jedinicaMere + "'  stampaci='" + value.stampaci + "'>";
                            HtmlToAppend += "<td>" + value.name + "</td>";
                            HtmlToAppend += "<td>" + value.sifra + "</td>";
                            HtmlToAppend += "<td>" + value.jedinicaMere + "</td>";
                            HtmlToAppend += "<td>" + value.cena + "</td>";
                            HtmlToAppend += "</tr>";
                        });
                        HtmlToAppend += "</table>";
                        $('.PodesavanjeArtikalaLista').append(HtmlToAppend);
                    }
                    $('.Loader').hide();
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                    $('.Loader').hide();
                }
            }
        });
        return false;
    });
    $('body').delegate('.CreateProductForm', 'submit', function () {
        $('.Loader').show();
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: $(this).serialize(),
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                $('.Loader').hide(500);
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    CreateWindowAlert(objData.Message, 'success');
                    $('.PodesavanjePretragaArtikala').submit();
                    $('.KreiranjeArtikala').hide();
                    $('.Loader').hide(500);
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                    $('.Loader').hide(500);
                }
            }
        });
        return false;
    });
    $('body').delegate('.OFPagerLink', 'click', function () {
        if (!$(this).hasClass('OFPageIsActive')) {
            var WhereToGo = $(this).attr('gotopage');
            var ProductGroup = $('.PodesavanjePretragaPodGrupa').val();
            var ProductName = $('.PodesavanjePretragaNaziv').val();
            $.ajax({
                type: 'POST',
                url: './?modul=GetAjax',
                data: "SearchArticlesSetup=" + WhereToGo + "&PodesavanjePretragaPodGrupa=" + ProductGroup + "&PodesavanjePretragaNaziv=" + ProductName,
                error: function () {
                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                    $('.Loader').hide();
                },
                complete: function (response) {
                    var objData = jQuery.parseJSON(response.responseText);
                    if (objData.Status == 'success') {
                        $('.PodesavanjeArtikalaLista').html('');
                        if (objData.PageLinks != "") {
                            var HtmlToAppend = "<div class='OFPager'>";
                            $.each(objData.PageLinks, function (key, value) {
                                HtmlToAppend += "<div class='OFPagerLink " + value.Class + "' gotopage='" + value.Number + "'>" + value.Content + "</div>";
                            });
                            HtmlToAppend += "</div>";
                            $('.PodesavanjeArtikalaLista').html(HtmlToAppend);
                        }
                        if (objData.InvoiceData != "") {
                            var HtmlToAppend = "<table>";
                            HtmlToAppend += "<tr class='PodesavanjeArtikalHeader'>";
                            HtmlToAppend += "<td>Naziv</td>";
                            HtmlToAppend += "<td>Šifra</td>";
                            HtmlToAppend += "<td>JM</td>";
                            HtmlToAppend += "<td>Cena</td>";
                            HtmlToAppend += "</tr>";
                            $.each(objData.InvoiceData, function (key, value) {
                                HtmlToAppend += "<tr class='PodesavanjeArtikal' dozvoljenpopust='" + value.dozvoljenPopust + "' porez='" + value.poreskaGrupa + "' idartikla='" + value.id + "' podgrupa_id='" + value.PODGRUPA_ID + "' cena='" + value.cena + "' sifra='" + value.sifra + "' naziv='" + value.name + "' jm='" + value.jedinicaMere + "'  stampaci='" + value.stampaci + "'>";
                                HtmlToAppend += "<td>" + value.name + "</td>";
                                HtmlToAppend += "<td>" + value.sifra + "</td>";
                                HtmlToAppend += "<td>" + value.jedinicaMere + "</td>";
                                HtmlToAppend += "<td>" + value.cena + "</td>";
                                HtmlToAppend += "</tr>";
                            });
                            HtmlToAppend += "</table>";
                            $('.PodesavanjeArtikalaLista').append(HtmlToAppend);
                        }
                        $('.Loader').hide();
                    } else {
                        CreateWindowAlert(objData.Message, 'error');
                        $('.Loader').hide();
                    }
                }
            });
            return false;
        }
    });
    $('body').delegate('.PodesavanjeKonobaraAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('akcija');
        if (WhatIsClicked == 'Exit') {
            $('.PodesavanjeKonobara').hide();
        } else if (WhatIsClicked == 'New') {
            $('.KreiranjeOperatera').show();
            $('.CreateOperatorId').val('0');
            $('.CreateOperatorName').val('');
            $('.CreateOperatorShortName').val('');
            $('.CreateOperatorSifra').val('');
            $('.CreateOperatorLevel').val('KONOBAR');
            $('.KreiranjeOperatera .CreateGroupLabel input[type="checkbox"]').each(function () {
                if ($(this).is(':checked')) {
                    $(this).click();
                }
            });
            $('.KreiranjeGrupeTitle').html('Kreiranje novog operatera');
        } else if (WhatIsClicked == 'Change') {
            if ($('.SelectedPodesavanjeKonobar').length) {
                $('.KreiranjeOperatera').show();
                var OperatorId = $('.SelectedPodesavanjeKonobar').attr('idkonobara');
                var OperatorName = $('.SelectedPodesavanjeKonobar').attr('punoime');
                var OperatorShortName = $('.SelectedPodesavanjeKonobar').attr('skrIme');
                var OperatorLevel = $('.SelectedPodesavanjeKonobar').attr('nivo');
                var OperatorSifra = $('.SelectedPodesavanjeKonobar').attr('sifra');
                var OperatorDiscountAdmin = $('.SelectedPodesavanjeKonobar').attr('administracijaPopusta');
                var OperatorSubTotalPass = $('.SelectedPodesavanjeKonobar').attr('medjuzirBezSifre');
                var OperatorStornoAble = $('.SelectedPodesavanjeKonobar').attr('mozeStorno');
                var OperatorPayup = $('.SelectedPodesavanjeKonobar').attr('naplata');
                var OperatorDeduct = $('.SelectedPodesavanjeKonobar').attr('oduzmi_ponisti');
                var OperatorOpensBuyer = $('.SelectedPodesavanjeKonobar').attr('otvaraKomitenta');
                var OperatorOpensMenu = $('.SelectedPodesavanjeKonobar').attr('otvaraMeni');
                var OperatorOpensCompany = $('.SelectedPodesavanjeKonobar').attr('otvaraPreduzece');
                var OperatorMenuSales = $('.SelectedPodesavanjeKonobar').attr('prometNaMeniPromet');
                var OperatorRepeatPrint = $('.SelectedPodesavanjeKonobar').attr('ponovnaStampaRacuna');
                var OperatorAllSales = $('.SelectedPodesavanjeKonobar').attr('pregledProdajeSvih');
                var OperatorViewStorno = $('.SelectedPodesavanjeKonobar').attr('pregledStorna');
                var OperatorReceiveDelivery = $('.SelectedPodesavanjeKonobar').attr('prijemDostave');
                var OperatorGrafik = $('.SelectedPodesavanjeKonobar').attr('prikazani_grafici');
                var OperatorKasa = $('.SelectedPodesavanjeKonobar').attr('dostupne_kase');
                var OperatorAdmin = $('.SelectedPodesavanjeKonobar').attr('admin_meni');
                $('.KreiranjeOperatera .CreateGroupLabel input[type="checkbox"]').each(function () {
                    if ($(this).is(':checked')) {
                        $(this).click();
                    }
                });
                $('.CreateOperatorId').val(OperatorId);
                $('.CreateOperatorName').val(OperatorName);
                $('.CreateOperatorShortName').val(OperatorShortName);
                $('.CreateOperatorLevel').val(OperatorLevel);
                $('.CreateOperatorSifra').val(OperatorSifra);
                $('.CreateOperatorId').val(OperatorId);

                if (OperatorDiscountAdmin == 1) {
                    $('.CreateOperatorDiscountAdmin').click();
                }
                if (OperatorSubTotalPass == 1) {
                    $('.CreateOperatorSubTotalPass').click();
                }
                if (OperatorStornoAble == 1) {
                    $('.CreateOperatorStornoAble').click();
                }
                if (OperatorPayup == 1) {
                    $('.CreateOperatorPayup').click();
                }
                if (OperatorDeduct == 1) {
                    $('.CreateOperatorDeduct').click();
                }
                if (OperatorOpensBuyer == 1) {
                    $('.CreateOperatorOpensBuyer').click();
                }
                if (OperatorOpensMenu == 1) {
                    $('.CreateOperatorOpensMenu').click();
                }
                if (OperatorOpensCompany == 1) {
                    $('.CreateOperatorOpensCompany').click();
                }
                if (OperatorMenuSales == 1) {
                    $('.CreateOperatorMenuSales').click();
                }
                if (OperatorRepeatPrint == 1) {
                    $('.CreateOperatorRepeatPrint').click();
                }
                if (OperatorAllSales == 1) {
                    $('.CreateOperatorAllSales').click();
                }
                if (OperatorViewStorno == 1) {
                    $('.CreateOperatorViewStorno').click();
                }
                if (OperatorReceiveDelivery == 1) {
                    $('.CreateOperatorReceiveDelivery').click();
                }

                if (OperatorGrafik != "") {
                    var CurrentGrafik = OperatorGrafik.split(',');
                    $.each(CurrentGrafik, function (key, value) {
                        $('.CreateOperatorGrafik[value="' + value + '"]').click();
                    });
                }
                if (OperatorKasa != "") {
                    var CurrentKasa = OperatorKasa.split(',');
                    $.each(CurrentKasa, function (key, value) {
                        $('.CreateOperatorKasa[value="' + value + '"]').click();
                    });
                }
                if (OperatorAdmin != "") {
                    var CurrentAdmin = OperatorAdmin.split(',');
                    $.each(CurrentAdmin, function (key, value) {
                        $('.CreateOperatorAdmin[value="' + value + '"]').click();
                    });
                }
                $('.KreiranjeGrupeTitle').html('Izmena operatera');
            } else {
                CreateWindowAlert('Najpre odaberite operatera koga želite da izmenite!', 'error');
            }
        } else if (WhatIsClicked == 'Delete') {
            if ($('.SelectedPodesavanjeKonobar').length) {
                var OperatorId = $('.SelectedPodesavanjeKonobar').attr('idkonobara');
                $('<div class="ModalConfirm"><h6>Da li ste sigurni da želite da obrišete operatera?!</h6></div>').appendTo('body').dialog({
                    modal: true,
                    title: "Potvrda brisanja",
                    zIndex: 10000,
                    autoOpen: true,
                    width: 'auto',
                    resizable: false,
                    draggable: false,
                    buttons: {
                        "Da": function () {
                            $('.Loader').show();
                            $.ajax({
                                type: 'POST',
                                url: './?modul=GetAjax',
                                data: "DeleteOperator=" + OperatorId,
                                error: function () {
                                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                    $('.Loader').hide();
                                },
                                complete: function (response) {
                                    var objData = jQuery.parseJSON(response.responseText);
                                    if (objData.Status == 'success') {
                                        PreuzmiSveKonobare();
                                        CreateWindowAlert(objData.Message, 'success');
                                        $('.Loader').hide();
                                    } else {
                                        CreateWindowAlert(objData.Message, 'error');
                                        $('.Loader').hide();
                                    }
                                }
                            });
                            $(this).dialog("close");
                        },
                        "Ne": function () {
                            $(this).dialog("close");
                            return false;
                        }
                    },
                    close: function (event, ui) {
                        $(this).remove();
                    }
                });
            } else {
                CreateWindowAlert('Najpre odaberite operatera koga želite da obrišete!', 'error');
            }
        }
    });
    $('body').delegate('.PodesavanjeKonobar', 'click', function () {
        $('.PodesavanjeKonobar').removeClass('SelectedPodesavanjeKonobar');
        $(this).addClass('SelectedPodesavanjeKonobar');
    });
    $('body').delegate('.CloseCreateOperator', 'click', function () {
        $('.KreiranjeOperatera').hide();
    });
    $('body').delegate('.CreateOperatorForm', 'submit', function () {
        $('.Loader').show();
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: $(this).serialize(),
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                $('.Loader').hide(500);
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    CreateWindowAlert(objData.Message, 'success');
                    PreuzmiSveKonobare();
                    $('.KreiranjeOperatera').hide();
                    $('.Loader').hide(500);
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                    $('.Loader').hide(500);
                }
            }
        });
        return false;
    });
    $('body').delegate('.PodesavanjeStopaAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('akcija');
        if (WhatIsClicked == 'Exit') {
            $('.PodesavanjeStopa').hide();
        } else if (WhatIsClicked == 'Sync') {
            $('<div class="ModalConfirm"><h6>Da li ste sigurni?! Akcija može potrajati!</h6></div>').appendTo('body').dialog({
                modal: true,
                title: "Sinhronizacija poreskih stopa sa LPFR",
                zIndex: 10000,
                autoOpen: true,
                width: 'auto',
                resizable: false,
                draggable: false,
                buttons: {
                    "Da": function () {
                        $('.Loader').show();
                        $.ajax({
                            type: 'POST',
                            url: './?modul=GetAjax',
                            data: "SyncVat=true",
                            error: function () {
                                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                $('.Loader').hide();
                            },
                            complete: function (response) {
                                var objData = jQuery.parseJSON(response.responseText);
                                if (objData.Status == 'success') {
                                    PreuzmiSvePoreskeStope();
                                    CreateWindowAlert(objData.Message, 'success');
                                    $('.Loader').hide();
                                } else {
                                    CreateWindowAlert(objData.Message, 'error');
                                    $('.Loader').hide();
                                }
                            }
                        });
                        $(this).dialog("close");
                    },
                    "Ne": function () {
                        $(this).dialog("close");
                        return false;
                    }
                },
                close: function (event, ui) {
                    $(this).remove();
                }
            });
        }
    });
    $('body').delegate('.JournalDataAkcija', 'click', function () {
        var WhatIsClicked = $(this).attr('akcija');
        if (WhatIsClicked == 'Izlaz') {
            $('.JournalData').hide();
        } else if (WhatIsClicked == 'CopyInvoice') {
            if ($('.SelectedJournal').length) {
                var JournalId = $('.SelectedJournal').attr('racun-id');
                $('<div class="ModalConfirm"><h6>Da li ste sigurni?! Akcija će fiskalizovati novu kopiju ovog računa!</h6></div>').appendTo('body').dialog({
                    modal: true,
                    title: "Fiskalizacija kopije računa",
                    zIndex: 10000,
                    autoOpen: true,
                    width: 'auto',
                    resizable: false,
                    draggable: false,
                    buttons: {
                        "Da": function () {
                            $('.Loader').show();
                            $.ajax({
                                type: 'POST',
                                url: './?modul=GetAjax',
                                data: "CreateInvoiceCopy=" + JournalId,
                                error: function () {
                                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                    $('.Loader').hide();
                                },
                                complete: function (response) {
                                    var objData = jQuery.parseJSON(response.responseText);
                                    if (objData.Status == 'success') {
                                        CreateWindowAlert(objData.Message, 'success');
                                        $('.Loader').hide();
                                    } else {
                                        CreateWindowAlert(objData.Message, 'error');
                                        $('.Loader').hide();
                                    }
                                }
                            });
                            $(this).dialog("close");
                        },
                        "Ne": function () {
                            $(this).dialog("close");
                            return false;
                        }
                    },
                    close: function (event, ui) {
                        $(this).remove();
                    }
                });
            } else {
                CreateWindowAlert("Najpre odaberite račun za kreiranje kopije!", 'error');
            }
        } else if (WhatIsClicked == 'RefundInvoice') {
            if ($('.SelectedJournal').length) {
                var JournalId = $('.SelectedJournal').attr('racun-id');
                $('<div class="ModalConfirm"><h6>Da li ste sigurni?! Akcija će fiskalizovati novu refundaciju ovog računa!</h6></div>').appendTo('body').dialog({
                    modal: true,
                    title: "Fiskalizacija refundacije računa",
                    zIndex: 10000,
                    autoOpen: true,
                    width: 'auto',
                    resizable: false,
                    draggable: false,
                    buttons: {
                        "Da": function () {
                            $('.Loader').show();
                            $.ajax({
                                type: 'POST',
                                url: './?modul=GetAjax',
                                data: "CreateInvoiceRefund=" + JournalId,
                                error: function () {
                                    CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                                    $('.Loader').hide();
                                },
                                complete: function (response) {
                                    var objData = jQuery.parseJSON(response.responseText);
                                    if (objData.Status == 'success') {
                                        CreateWindowAlert(objData.Message, 'success');
                                        $('.Loader').hide();
                                    } else {
                                        CreateWindowAlert(objData.Message, 'error');
                                        $('.Loader').hide();
                                    }
                                }
                            });
                            $(this).dialog("close");
                        },
                        "Ne": function () {
                            $(this).dialog("close");
                            return false;
                        }
                    },
                    close: function (event, ui) {
                        $(this).remove();
                    }
                });
            } else {
                CreateWindowAlert("Najpre odaberite račun za kreiranje refundacije!", 'error');
            }
        }
    });
    $('body').delegate('.PagerJournal', 'click', function () {
        var WhatIsClicked = $(this).attr('showpage');
        GetJournalData(WhatIsClicked);
    });
    $('body').delegate('.JournalDataLeft tbody tr', 'click', function () {
        $('.JournalDataLeft tbody tr').removeClass('SelectedJournal');
        $(this).addClass('SelectedJournal');
    });
    $('body').delegate('.ConfirmOdabirRefakcije', 'click', function () {
        $('.OdabirRefakcije').hide();
    });
    $('body').delegate('.CloseOdabirRefakcije', 'click', function () {
        $('.OdabirRefakcije').hide();
        $('.OFOpcionoPoljeKupcaID').val($('.OFOpcionoPoljeKupcaID').attr('default-value'));
        $('.OFOpcionoPoljeKupca').val("");
        $('.OFReferentniBrojKupca').val("");
    });
    $('body').delegate('.ClosePretragaArtikala', 'click', function () {
        $('.PretragaArtikala').hide();
        $('.PretragaArtikalaInput').val('');
        $('.PretragaArtikalaRezultati').html('');
    });
    $('body').delegate('.PretragaArtikalaRezultat', 'click', function () {
        $('.PretragaArtikalaRezultat').removeClass('PretragaArtikalaOdabraniRezultat');
        $(this).addClass('PretragaArtikalaOdabraniRezultat');
    });
    $('body').delegate('.PretragaArtikalaHolder', 'submit', function (e) {
        if ($('.PretragaArtikalaOdabraniRezultat').length) {
            var KojiArtikalDaKliknem = $('.PretragaArtikalaOdabraniRezultat').attr('idtrazenogartikla');
            $('.Artikal[idartikla="' + KojiArtikalDaKliknem + '"]').first().click();
            $('.PretragaArtikala').hide();
            $('.PretragaArtikalaInput').val('');
            $('.PretragaArtikalaRezultati').html('');
        } else {
            var PretragaString = $('.PretragaArtikalaInput').val();
            if (PretragaString != "") {
                $.ajax({
                    type: 'POST',
                    url: './?modul=GetAjax',
                    data: "SearchForProductItem=" + PretragaString,
                    error: function () {
                        CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                        $('.Loader').hide();
                    },
                    complete: function (response) {
                        var objData = jQuery.parseJSON(response.responseText);
                        if (objData.Status == 'success') {
                            $('.PretragaArtikalaRezultati').html(objData.HtmlToInsert);
                        } else {
                            CreateWindowAlert(objData.Message, 'error');
                            $('.Loader').hide();
                        }
                    }
                });
            } else {
                CreateWindowAlert('Najpre unesite termin za pretragu', 'error');
            }
        }
        return false;
    });
    $('body').delegate('.PretragaArtikalaKeyboard .QwertyKeys', 'click', function () {
        var WhatIsPressed = $(this).attr('qwerty-value');
        if (WhatIsPressed == 'Delete') {
            var ValToDelete = $('.PretragaArtikalaInput').val();
            $('.PretragaArtikalaInput').val(ValToDelete.substring(0, ValToDelete.length - 1));
        } else if (WhatIsPressed == 'Zatvori') {
            $('.PretragaArtikala').hide();
        } else if (WhatIsPressed == 'Enter') {
            $('.PretragaArtikalaHolder').submit();
        } else {
            var ValToAdd = $('.PretragaArtikalaInput').val();
            $('.PretragaArtikalaInput').val(ValToAdd + WhatIsPressed);
        }
    });
});
$(function () {
    $(".DatePicker").datepicker({
        maxDate: 0,
        dateFormat: 'dd.mm.yy',
        monthNames: ["Januar", "Februar", "Mart", "April", "Maj", "Jun", "Jul", "Avgust", "Septembar", "Oktobar", "Novembar", "Decembar"],
        dayNamesMin: ["Ne", "Po", "Ut", "Sr", "Če", "Pe", "Su"]
    });
    var fromTimeInputF = $('#DateFromF');
    var toTimeInputF = $('#DateToF');
    fromTimeInputF.datepicker({
        dateFormat: 'dd.mm.yy',
        monthNames: ["Januar", "Februar", "Mart", "April", "Maj", "Jun", "Jul", "Avgust", "Septembar", "Oktobar", "Novembar", "Decembar"],
        dayNamesMin: ["Ne", "Po", "Ut", "Sr", "Če", "Pe", "Su"],
        maxDate: 0
    });
    toTimeInputF.datepicker({
        dateFormat: 'dd.mm.yy',
        monthNames: ["Januar", "Februar", "Mart", "April", "Maj", "Jun", "Jul", "Avgust", "Septembar", "Oktobar", "Novembar", "Decembar"],
        dayNamesMin: ["Ne", "Po", "Ut", "Sr", "Če", "Pe", "Su"],
        maxDate: 0
    });
    fromTimeInputF.on('change', function () {
        //console.log($(this).val());
        var parts = $(this).val().split('.');
        var someDate = new Date(parts[2], parts[1] - 1, parts[0]);
        //console.log(someDate);
        var numberOfDaysToAdd = 0;
        someDate.setDate(someDate.getDate() + numberOfDaysToAdd);
        var dd = someDate.getDate();
        var mm = someDate.getMonth() + 1;
        var y = someDate.getFullYear();
        var someFormattedDate = dd + '.' + mm + '.' + y;
        //console.log(someFormattedDate);
        toTimeInputF.datepicker("option", "minDate", someFormattedDate);
    });
    toTimeInputF.on('change', function () {
        //console.log($(this).val());
        var parts = $(this).val().split('.');
        var someDate = new Date(parts[2], parts[1] - 1, parts[0]);
        //console.log(someDate);
        var numberOfDaysToAdd = 0;
        someDate.setDate(someDate.getDate() + numberOfDaysToAdd);
        var dd = someDate.getDate();
        var mm = someDate.getMonth() + 1;
        var y = someDate.getFullYear();
        var someFormattedDate = dd + '.' + mm + '.' + y;
        //console.log(someFormattedDate);
        fromTimeInputF.datepicker("option", "maxDate", someFormattedDate);
    });
    var fromTimeInputJ = $('#DateFromJournal');
    var toTimeInputJ = $('#DateToJournal');
    fromTimeInputJ.datepicker({
        dateFormat: 'dd.mm.yy',
        monthNames: ["Januar", "Februar", "Mart", "April", "Maj", "Jun", "Jul", "Avgust", "Septembar", "Oktobar", "Novembar", "Decembar"],
        dayNamesMin: ["Ne", "Po", "Ut", "Sr", "Če", "Pe", "Su"],
        maxDate: 0
    });
    toTimeInputJ.datepicker({
        dateFormat: 'dd.mm.yy',
        monthNames: ["Januar", "Februar", "Mart", "April", "Maj", "Jun", "Jul", "Avgust", "Septembar", "Oktobar", "Novembar", "Decembar"],
        dayNamesMin: ["Ne", "Po", "Ut", "Sr", "Če", "Pe", "Su"],
        maxDate: 0
    });
    fromTimeInputJ.on('change', function () {
        //console.log($(this).val());
        var parts = $(this).val().split('.');
        var someDate = new Date(parts[2], parts[1] - 1, parts[0]);
        //console.log(someDate);
        var numberOfDaysToAdd = 0;
        someDate.setDate(someDate.getDate() + numberOfDaysToAdd);
        var dd = someDate.getDate();
        var mm = someDate.getMonth() + 1;
        var y = someDate.getFullYear();
        var someFormattedDate = dd + '.' + mm + '.' + y;
        //console.log(someFormattedDate);
        toTimeInputJ.datepicker("option", "minDate", someFormattedDate);
    });
    toTimeInputJ.on('change', function () {
        //console.log($(this).val());
        var parts = $(this).val().split('.');
        var someDate = new Date(parts[2], parts[1] - 1, parts[0]);
        //console.log(someDate);
        var numberOfDaysToAdd = 0;
        someDate.setDate(someDate.getDate() + numberOfDaysToAdd);
        var dd = someDate.getDate();
        var mm = someDate.getMonth() + 1;
        var y = someDate.getFullYear();
        var someFormattedDate = dd + '.' + mm + '.' + y;
        //console.log(someFormattedDate);
        fromTimeInputJ.datepicker("option", "maxDate", someFormattedDate);
    });
});
$(window).on('load', function () {
    $('.GrafikImg').each(function () {
        var ImgSrc = $(this).attr('data-src');
        if (ImgSrc) {
            $(this).attr('src', ImgSrc);
            $(this).removeAttr('data-src');
        }
    });
    $('body').delegate('.CloseChooseHotelGuest', 'click', function(){
        $('.PretragaSobaHotel').hide();
    });
    $('body').delegate('.SelectHotelRoom', 'click', function(){
        var GuestId = $(this).attr('guestid');
        var RoomId = $(this).attr('roomid');
        var TableId = $('.Porudzbina .PorudzbinaSto').first().attr('sto-id');
        $('.Loader').show();
        $.ajax({
            type: 'POST',
            url: './?modul=GetAjax',
            data: "TransferTableToHotel="+TableId+"&TrasferTableToRoom="+RoomId+"&TrasferTableToRoomGuest="+GuestId,
            error: function () {
                CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
                $('.Loader').hide();
            },
            complete: function (response) {
                var objData = jQuery.parseJSON(response.responseText);
                if (objData.Status == 'success') {
                    $('.PretragaSobaHotel').hide();
                    $('.Loader').hide();
                    $('.PorudzbinaRightAkcija[dugmeaction="Odustani"]').click();
                } else {
                    CreateWindowAlert(objData.Message, 'error');
                    $('.Loader').hide();
                }
            }
        });
    });
});
$(window).resize(function () {
    var Height = ($(window).height() / 5) - 1;
    $('.AdminMeniStavka').attr('style', 'height: ' + Height + 'px; line-height: ' + Height + 'px;');
    var GotovinskiKupciAkcija = $('.GotovinskiKupciAkcije').height() / 4;
    $('.GotovinskiKupciAkcija').attr('style', 'height: ' + GotovinskiKupciAkcija + 'px; line-height: ' + GotovinskiKupciAkcija + 'px;');
    var GotovinskiHeight = $('.AkcijeGotovinski').height() / 4;
    $('.AkcijaGotovinski').attr('style', 'height: ' + GotovinskiHeight + 'px; line-height: ' + GotovinskiHeight + 'px;');

    var SelectedGrafik = $('.SelectedGrafik').attr('grafikid');
    RecalcGrafik(SelectedGrafik);
    RearangeOrder();
    $('.RastavljanjeAction').removeAttr('style');
    var RastavljanjeHeight = $('.RastavljanjeCenter').height();
    var NewButtonHeight = (parseFloat(RastavljanjeHeight) / 6) - 1;
    $('.RastavljanjeAction').attr('style', 'height: ' + NewButtonHeight + 'px; line-height: ' + NewButtonHeight + 'px;');

    var FakturaHeight = $('.FakturaKupciAkcije').height() / 3;
    $('.FakturaKupciAkcija').attr('style', 'height: ' + FakturaHeight + 'px; line-height: ' + FakturaHeight + 'px;');
    $('.MenuKey').removeAttr('style');
    $('.DostavaAkcija').removeAttr('style');
    $('.NovaAdresaAkcija').removeAttr('style');
    $('.TriTrojkeAction').removeAttr('style');
    $('.AktivniStoloviDesno div').removeAttr('style');
    $('.PodesavanjaAkcijePotvrdi').removeAttr('style');
    $('.PodesavanjaAkcijeOtkazi').removeAttr('style');
    $('.PodesavanjeKonobaraAkcija').removeAttr('style');
    setTimeout(function () {
        var NovaDostavaButtonsHeight = $('.NovaAdresaAkcije').height() / 2;
        $('.NovaAdresaAkcija').attr('style', 'height: ' + NovaDostavaButtonsHeight + 'px; line-height: ' + NovaDostavaButtonsHeight + 'px;');
        var ButtonsHeight = $('.DostavaAkcije').height() / 4;
        $('.DostavaAkcija').attr('style', 'height: ' + ButtonsHeight + 'px; line-height: ' + ButtonsHeight + 'px;');
        var MenuKeyHeight = $('.MenuKeys').height() / 4;
        $('.MenuKey').attr('style', 'height: ' + MenuKeyHeight + 'px; line-height: ' + MenuKeyHeight + 'px;');
        var BeloLength = $('.BeloNaplata').length;
        var InitialHeight = $('.NaplataOpcije').height();
        var RightKeysHeight = (parseFloat(InitialHeight) / parseFloat(BeloLength));
        var NumericKeysHeight = (parseFloat(InitialHeight) / 4);
        $('.BeloNaplata').attr('style', 'height:' + parseInt(RightKeysHeight) + 'px; line-height: ' + parseInt(RightKeysHeight) + 'px;');
        $('.CrnoNaplata').attr('style', 'height:' + parseInt(RightKeysHeight) + 'px; line-height: ' + parseInt(RightKeysHeight) + 'px;');
        $('.NaplataNumeric').attr('style', 'height:' + parseInt(NumericKeysHeight) + 'px; line-height: ' + parseInt(NumericKeysHeight) + 'px;');
        var TriTrojkeRightHeight = $('.TriTrojke').height();
        var ButtonHeight = parseFloat(TriTrojkeRightHeight) / 4;
        $('.TriTrojkeAction').attr('style', 'height:' + ButtonHeight + 'px;line-height:' + ButtonHeight + 'px;');
        var RightHeight = $('.AktivniStoloviDesno').height();
        var RightBtnHeight = parseFloat(RightHeight) / 4;
        $('.AktivniStoloviDesno div').attr('style', 'height: ' + RightBtnHeight + 'px; line-height: ' + RightBtnHeight + 'px;');
        var HeightPodesavanjaAkcije = $('.PodesavanjaAkcije').height();
        var DugmadHeightAkcije = HeightPodesavanjaAkcije / 2;
        $('.PodesavanjaAkcijePotvrdi').attr('style', 'height: ' + DugmadHeightAkcije + 'px; line-height: ' + DugmadHeightAkcije + 'px;');
        $('.PodesavanjaAkcijeOtkazi').attr('style', 'height: ' + DugmadHeightAkcije + 'px; line-height: ' + DugmadHeightAkcije + 'px;');

        var HeightPodesavanjaAkcije = $('.PodesavanjeGrupaAkcije').height();
        var DugmadHeight = HeightPodesavanjaAkcije / 4;
        $('.PodesavanjeGrupaAkcija').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');

        var HeightPodesavanjaAkcije = $('.PodesavanjePodGrupaAkcije').height();
        var DugmadHeight = HeightPodesavanjaAkcije / 4;
        $('.PodesavanjePodGrupaAkcija').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');

        var HeightPodesavanjaAkcije = $('.PodesavanjeStampacaAkcije').height();
        var DugmadHeight = HeightPodesavanjaAkcije / 4;
        $('.PodesavanjeStampacaAkcija').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');

        var HeightPodesavanjaAkcije = $('.PodesavanjeKonobaraAkcije').height();
        var DugmadHeight = HeightPodesavanjaAkcije / 4;
        $('.PodesavanjeKonobaraAkcija').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');

        var HeightPodesavanjaAkcije = $('.PodesavanjeStopaAkcije').height();
        var DugmadHeight = HeightPodesavanjaAkcije / 2;
        $('.PodesavanjeStopaAkcija').attr('style', 'height: ' + DugmadHeight + 'px; line-height: ' + DugmadHeight + 'px;');
    }, 500);
    setTimeout(function () {
        var ArtikliZaNaplatuVelicina = $('.Naplata').height() - $('.NaplataTop').height() - $('.NaplataBottom').height() - $('.NaplataOpcije .NaplataLeft').height() - $('.ArtikliZaNaplatuTitle').height();
        $('.ArtikliZaNaplatuSadrzaj').height(ArtikliZaNaplatuVelicina);
    }, 1000);
});
function GetAllHotelGuests() {
    $('.Loader').show();
    $.ajax({
        type: 'POST',
        url: './?modul=GetAjax',
        data: "GetAllHotelGuests=true",
        error: function () {
            CreateWindowAlert('Greska na mrezi!!! Pokusajte ponovo!!!', 'error');
            $('.Loader').hide();
        },
        complete: function (response) {
            var objData = jQuery.parseJSON(response.responseText);
            if (objData.Status == 'success') {
                $('.OdabirSobeZaPrebacivanje').html(objData.HtmlToInsert);
                $('.OdabirSobeZaPrebacivanje').prepend('<div class="CloseChooseHotelGuest YellowLetters"><span>Otkaži odabir</span></div>');
                $('.PretragaSobaHotel').show();
                $('.Loader').hide();
            } else {
                CreateWindowAlert(objData.Message, 'error');
                $('.Loader').hide();
            }
        }
    });
}